T_ENTRY = {
    # # 申込みID
    # 't_entry_id': {
    #     'label': '申込みID',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': False
    # },
    # 申込みコード
    'entry_code': {
        'label': '申込みコード',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 営業コード
    'salesman_code': {
        'label': '営業コード',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # チケットID
    'ticket_id': {
        'label': 'チケットID',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 企業名
    'company_name': {
        'label': '企業名',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 企業名(カナ)
    'company_name_kana': {
        'label': '企業名(カナ)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 郵便番号
    'company_zipcode': {
        'label': '郵便番号',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 住所(都道府県)
    'company_address_pref': {
        'label': '住所(都道府県)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 住所1
    'company_address_1': {
        'label': '住所1',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 住所2
    'company_address_2': {
        'label': '住所2',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 住所3
    'company_address_3': {
        'label': '住所3',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # # 住所1(カナ)
    # 'company_address_1_kana': {
    #     'label': '住所1(カナ)',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': False
    # },
    # # 住所2(カナ)
    # 'company_address_2_kana': {
    #     'label': '住所2(カナ)',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': False
    # },
    # # 住所3(カナ)
    # 'company_address_3_kana': {
    #     'label': '住所3(カナ)',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': False
    # },
    # 電話番号1
    'company_tel_1': {
        'label': '電話番号1',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # # FAX1
    # 'company_fax_1': {
    #     'label': 'FAX1',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': False
    # },
    # 代表者名(姓)
    'company_leader_last': {
        'label': '代表者名(姓)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 代表者名(名)
    'company_leader_first': {
        'label': '代表者名(名)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 代表者名(姓)(カナ)
    'company_leader_kana_last': {
        'label': '代表者名(姓)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 代表者名(名)(カナ)
    'company_leader_kana_first': {
        'label': '代表者名(名)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者名(姓)
    'contract_name_last': {
        'label': '契約者名(姓)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者名(名)
    'contract_name_first': {
        'label': '契約者名(名)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者名(姓)(カナ)
    'contract_name_last_kana': {
        'label': '契約者名(姓)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者名(名)(カナ)
    'contract_name_first_kana': {
        'label': '契約者名(名)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者部署名
    'contract_department': {
        'label': '契約者部署名',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者役職
    'contract_position': {
        'label': '契約者役職',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者メールアドレス
    'contract_email': {
        'label': '契約者メールアドレス',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者郵便番号
    'contract_zipcode': {
        'label': '契約者郵便番号',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者都道府県
    'contract_address_pref': {
        'label': '契約者都道府県',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者住所1
    'contract_address_1': {
        'label': '契約者住所1',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者住所2
    'contract_address_2': {
        'label': '契約者住所2',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 契約者住所3
    'contract_address_3': {
        'label': '契約者住所3',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # # 契約者住所1(カナ)
    # 'contract_address_1_kana': {
    #     'label': '契約者住所1(カナ)',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # # 契約者住所2(カナ)
    # 'contract_address_2_kana': {
    #     'label': '契約者住所2(カナ)',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # # 契約者住所3(カナ)
    # 'contract_address_3_kana': {
    #     'label': '契約者住所3(カナ)',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # 契約者電話番号1
    'contract_tel_1': {
        'label': '契約者電話番号1',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # # 契約者FAX1
    # 'contract_fax_1': {
    #     'label': '契約者FAX1',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # 管理者名(姓)
    'administrator_name_last': {
        'label': '管理者名(姓)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 管理者名(名)
    'administrator_name_first': {
        'label': '管理者名(名)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 管理者名(姓)(カナ)
    'administrator_name_last_kana': {
        'label': '管理者名(姓)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 管理者名(名)(カナ)
    'administrator_name_first_kana': {
        'label': '管理者名(名)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 管理者部署名
    'administrator_department': {
        'label': '管理者部署名',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 管理者役職
    'administrator_position': {
        'label': '管理者役職',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 管理者メールアドレス
    'administrator_email': {
        'label': '管理者メールアドレス',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 管理者電話番号1
    'administrator_tel_1': {
        'label': '管理者電話番号1',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # # 管理者FAX1
    # 'administrator_fax_1': {
    #     'label': '管理者FAX1',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # 登録日
    'insert_date': {
        'label': '登録日',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # メール送信日
    'send_date': {
        'label': 'メール送信日',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # MSCOneクラウドライセンスサービス
    'service_mscone_lic': {
        'label': 'MSCOneクラウドライセンスサービス',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 請求書の送付方法
    'invoice_sending_method': {
        'label': '請求書の送付方法',
        'min': 0,
        'max': 1,
        'is_required': False,
        'is_intger': True
    },
    # 代表者の生年月日
    'company_leader_date_of_birth': {
        'label': '代表者の生年月日',
        'min': 0,
        'max': 0,
        'is_required': False
    },
    # システムID
    'system_id': {
        'label': 'システムID',
        'min': 8,
        'max': 8,
        'is_required': False
    },
    # サービスID
    'service_id': {
        'label': 'サービスID',
        'min': 8,
        'max': 8,
        'is_required': False
    }
}

class TEntry:
    def __init__(self):
        self.t_entry_id: int                        # 申込みID
        self.entry_code: str                        # 申込みコード
        self.salesman_code: str                     # 営業コード
        self.ticket_id: str                         # チケットID
        self.company_name: str                      # 企業名
        self.company_name_kana: str                 # 企業名(カナ)
        self.company_zipcode: str                   # 郵便番号
        self.company_address_pref: str              # 住所(都道府県)
        self.company_address_1: str                 # 住所1
        self.company_address_2: str                 # 住所2
        self.company_address_3: str                 # 住所3
        self.company_address_1_kana: str            # 住所1(カナ)
        self.company_address_2_kana: str            # 住所2(カナ)
        self.company_address_3_kana: str            # 住所3(カナ)
        self.company_tel_1: str                     # 電話番号1
        self.company_fax_1: str                     # FAX1
        self.company_leader_last: str               # 代表者名(姓)
        self.company_leader_first: str              # 代表者名(名)
        self.company_leader_kana_last: str          # 代表者名(姓)(カナ)
        self.company_leader_kana_first: str         # 代表者名(名)(カナ)
        self.contract_name_last: str                # 契約者名(姓)
        self.contract_name_first: str               # 契約者名(名)
        self.contract_name_last_kana: str           # 契約者名(姓)(カナ)
        self.contract_name_first_kana: str          # 契約者名(名)(カナ)
        self.contract_department: str               # 契約者部署名
        self.contract_position: str                 # 契約者役職
        self.contract_email: str                    # 契約者メールアドレス
        self.contract_zipcode: str                  # 契約者郵便番号
        self.contract_address_pref: str             # 契約者都道府県
        self.contract_address_1: str                # 契約者住所1
        self.contract_address_2: str                # 契約者住所2
        self.contract_address_3: str                # 契約者住所3
        self.contract_address_1_kana: str           # 契約者住所1(カナ)
        self.contract_address_2_kana: str           # 契約者住所2(カナ)
        self.contract_address_3_kana: str           # 契約者住所3(カナ)
        self.contract_tel_1: str                    # 契約者電話番号1
        self.contract_fax_1: str                    # 契約者FAX1
        self.administrator_name_last: str           # 管理者名(姓)
        self.administrator_name_first: str          # 管理者名(名)
        self.administrator_name_last_kana: str      # 管理者名(姓)(カナ)
        self.administrator_name_first_kana: str     # 管理者名(名)(カナ)
        self.administrator_department: str          # 管理者部署名
        self.administrator_position: str            # 管理者役職
        self.administrator_email: str               # 管理者メールアドレス
        self.administrator_tel_1: str               # 管理者電話番号1
        self.administrator_fax_1: str               # 管理者FAX1
        self.insert_date: str                       # 登録日
        self.send_date: str                         # メール送信日
        self.service_mscone_lic: str                # MSCOneクラウドライセンスサービス
        self.invoice_sending_method: str            # 請求書の送付方法
        self.company_leader_date_of_birth: str      # 代表者の生年月日
        self.system_id: str                         # システムID
        self.service_id: str                        # サービスID
        
    def set_t_entry_id(self, t_entry_id):
        self.t_entry_id = t_entry_id
        
    def set_entry_code(self, entry_code):
        self.entry_code = entry_code
        
    def set_salesman_code(self, salesman_code):
        self.salesman_code = salesman_code
        
    def set_ticket_id(self, ticket_id):
        self.ticket_id = ticket_id
        
    def set_company_name(self, company_name):
        self.company_name = company_name
        
    def set_company_name_kana(self, company_name_kana):
        self.company_name_kana = company_name_kana
        
    def set_company_zipcode(self, company_zipcode):
        self.company_zipcode = company_zipcode
        
    def set_company_address_pref(self, company_address_pref):
        self.company_address_pref = company_address_pref
        
    def set_company_address_1(self, company_address_1):
        self.company_address_1 = company_address_1
        
    def set_company_address_2(self, company_address_2):
        self.company_address_2 = company_address_2
        
    def set_company_address_3(self, company_address_3):
        self.company_address_3 = company_address_3
        
    def set_company_address_1_kana(self, company_address_1_kana):
        self.company_address_1_kana = company_address_1_kana
        
    def set_company_address_2_kana(self, company_address_2_kana):
        self.company_address_2_kana = company_address_2_kana
        
    def set_company_address_3_kana(self, company_address_3_kana):
        self.company_address_3_kana = company_address_3_kana
        
    def set_company_tel_1(self, company_tel_1):
        self.company_tel_1 = company_tel_1
        
    def set_company_fax_1(self, company_fax_1):
        self.company_fax_1 = company_fax_1
        
    def set_company_leader_last(self, company_leader_last):
        self.company_leader_last = company_leader_last
        
    def set_company_leader_first(self, company_leader_first):
        self.company_leader_first = company_leader_first
        
    def set_company_leader_kana_last(self, company_leader_kana_last):
        self.company_leader_kana_last = company_leader_kana_last
        
    def set_company_leader_kana_first(self, company_leader_kana_first):
        self.company_leader_kana_first = company_leader_kana_first
        
    def set_contract_name_last(self, contract_name_last):
        self.contract_name_last = contract_name_last
        
    def set_contract_name_first(self, contract_name_first):
        self.contract_name_first = contract_name_first
        
    def set_contract_name_last_kana(self, contract_name_last_kana):
        self.contract_name_last_kana = contract_name_last_kana
        
    def set_contract_name_first_kana(self, contract_name_first_kana):
        self.contract_name_first_kana = contract_name_first_kana
        
    def set_contract_department(self, contract_department):
        self.contract_department = contract_department
        
    def set_contract_position(self, contract_position):
        self.contract_position = contract_position
        
    def set_contract_email(self, contract_email):
        self.contract_email = contract_email
        
    def set_contract_zipcode(self, contract_zipcode):
        self.contract_zipcode = contract_zipcode
        
    def set_contract_address_pref(self, contract_address_pref):
        self.contract_address_pref = contract_address_pref
        
    def set_contract_address_1(self, contract_address_1):
        self.contract_address_1 = contract_address_1
        
    def set_contract_address_2(self, contract_address_2):
        self.contract_address_2 = contract_address_2
        
    def set_contract_address_3(self, contract_address_3):
        self.contract_address_3 = contract_address_3
        
    def set_contract_address_1_kana(self, contract_address_1_kana):
        self.contract_address_1_kana = contract_address_1_kana
        
    def set_contract_address_2_kana(self, contract_address_2_kana):
        self.contract_address_2_kana = contract_address_2_kana
        
    def set_contract_address_3_kana(self, contract_address_3_kana):
        self.contract_address_3_kana = contract_address_3_kana
        
    def set_contract_tel_1(self, contract_tel_1):
        self.contract_tel_1 = contract_tel_1
        
    def set_contract_fax_1(self, contract_fax_1):
        self.contract_fax_1 = contract_fax_1
        
    def set_administrator_name_last(self, administrator_name_last):
        self.administrator_name_last = administrator_name_last
        
    def set_administrator_name_first(self, administrator_name_first):
        self.administrator_name_first = administrator_name_first
        
    def set_administrator_name_last_kana(self, administrator_name_last_kana):
        self.administrator_name_last_kana = administrator_name_last_kana
        
    def set_administrator_name_first_kana(self, administrator_name_first_kana):
        self.administrator_name_first_kana = administrator_name_first_kana
        
    def set_administrator_department(self, administrator_department):
        self.administrator_department = administrator_department
        
    def set_administrator_position(self, administrator_position):
        self.administrator_position = administrator_position
        
    def set_administrator_email(self, administrator_email):
        self.administrator_email = administrator_email
        
    def set_administrator_tel_1(self, administrator_tel_1):
        self.administrator_tel_1 = administrator_tel_1
        
    def set_administrator_fax_1(self, administrator_fax_1):
        self.administrator_fax_1 = administrator_fax_1
        
    def set_insert_date(self, insert_date):
        self.insert_date = insert_date
        
    def set_send_date(self, send_date):
        self.send_date = send_date
        
    def set_service_mscone_lic(self, service_mscone_lic):
        self.service_mscone_lic = service_mscone_lic
        
    def set_invoice_sending_method(self, invoice_sending_method):
        self.invoice_sending_method = invoice_sending_method
        
    def set_company_leader_date_of_birth(self, company_leader_date_of_birth):
        self.company_leader_date_of_birth = company_leader_date_of_birth
        
    def set_system_id(self, system_id):
        self.system_id = system_id
        
    def set_service_id(self, service_id):
        self.service_id = service_id


M_USER = {
    # Auth0ユーザーID
    'auth0_user_id': {
        'label': 'Auth0ユーザーID',
        'min': 0,
        'max': 128,
        'is_required': True
    },
    # 企業コード
    'company_code': {
        'label': '企業コード',
        'min': 6,
        'max': 6,
        'is_required': True
    },
    # 名前(姓)
    'name_last': {
        'label': '名前(姓)',
        'min': 0,
        'max': 128,
        'is_required': True
    },
    # 名前(名)
    'name_first': {
        'label': '名前(名)',
        'min': 0,
        'max': 128,
        'is_required': True
    },
    # 名前(カナ)(姓)
    'name_last_kana': {
        'label': '名前(カナ)(姓)',
        'min': 0,
        'max': 128,
        'is_required': True
    },
    # 名前(カナ)(名)
    'name_first_kana': {
        'label': '名前(カナ)(名)',
        'min': 0,
        'max': 128,
        'is_required': True
    },
    # 部署名
    'department': {
        'label': '部署名',
        'min': 0,
        'max': 128,
        'is_required': True
    },
    # 役職
    'position': {
        'label': '役職',
        'min': 0,
        'max': 128,
        'is_required': False
    },
    # メールアドレス
    'email': {
        'label': 'メールアドレス',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 電話番号
    'tel': {
        'label': '電話番号',
        'min': 10,
        'max': 11,
        'is_required': True
    },
    # 招待コード
    'invitation_code': {
        'label': '招待コード',
        'min': 0,
        'max': 128,
        'is_required': False
    },
    # 招待日時
    'invitation_date': {
        'label': '招待日時',
        'min': 0,
        'max': 0,
        'is_required': False,
        'is_date': True,
        'date_format': '%Y/%m/%d',
        'date_format_description': 'yyyy/mm/dd'
    },
}


class MUser:

    def __init__(self):
        self.auth0_user_id: str
        self.company_code: str
        self.name_last: str
        self.name_first: str
        self.name_last_kana: str
        self.name_first_kana: str
        self.department: str
        self.position: str
        self.email: str
        self.tel: str
        self.invitation_code: str
        self.invitation_date: str

    def set_auth0_user_id(self, auth0_user_id):
        self.auth0_user_id = auth0_user_id

    def set_company_code(self, company_code):
        self.company_code = company_code

    def set_name_last(self, name_last):
        self.name_last = name_last

    def set_name_first(self, name_first):
        self.name_first = name_first

    def set_name_last_kana(self, name_last_kana):
        self.name_last_kana = name_last_kana

    def set_name_first_kana(self, name_first_kana):
        self.name_first_kana = name_first_kana

    def set_department(self, department):
        self.department = department

    def set_position(self, position):
        self.position = position

    def set_email(self, email):
        self.email = email

    def set_tel(self, tel):
        self.tel = tel

    def set_invitation_code(self, invitation_code):
        self.invitation_code = invitation_code

    def set_invitation_date(self, invitation_date):
        self.invitation_date = invitation_date


M_COMPANY = {
    # 企業コード
    'company_code': {
        'label': '企業コード',
        'min': 6,
        'max': 6,
        'is_required': True
    },
    # 申込みコード
    'entry_code': {
        'label': '申込みコード',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 営業コード
    'salesman_code': {
        'label': '営業コード',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 企業名
    'company_name': {
        'label': '企業名',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 企業名(カナ)
    'company_name_kana': {
        'label': '企業名(カナ)',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 郵便番号
    'company_zipcode': {
        'label': '郵便番号',
        'min': 7,
        'max': 7,
        'is_required': True
    },
    # 住所(都道府県)
    'company_address_pref': {
        'label': '住所(都道府県)',
        'min': 0,
        'max': 4,
        'is_required': True
    },
    # 住所1
    'company_address_1': {
        'label': '住所1',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 住所2
    'company_address_2': {
        'label': '住所2',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 住所3
    'company_address_3': {
        'label': '住所3',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # # 住所1(カナ)
    # 'company_address_1_kana': {
    #     'label': '住所1(カナ)',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # # 住所2(カナ)
    # 'company_address_2_kana': {
    #     'label': '住所2(カナ)',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # # 住所3(カナ)
    # 'company_address_3_kana': {
    #     'label': '住所3(カナ)',
    #     'min': 0,
    #     'max': 256,
    #     'is_required': False
    # },
    # 電話番号1
    'company_tel_1': {
        'label': '電話番号1',
        'min': 10,
        'max': 11,
        'is_required': True
    },
    # # FAX1
    # 'company_fax_1': {
    #     'label': 'FAX1',
    #     'min': 10,
    #     'max': 11,
    #     'is_required': False
    # },
    # 代表者名(姓)
    'company_leader_last': {
        'label': '代表者名(姓)',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 代表者名(名)
    'company_leader_first': {
        'label': '代表者名(名)',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 代表者名(姓)(カナ)
    'company_leader_kana_last': {
        'label': '代表者名(姓)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # 代表者名(名)(カナ)
    'company_leader_kana_first': {
        'label': '代表者名(名)(カナ)',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # # 登録日
    # 'insert_date': {
    #     'label': '登録日',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': True,
    #     'is_date': True,
    #     'date_format': '%Y-%m-%dT%H:%M:%SZ',
    #     'date_format_description': 'yyyy-mm-ddTHH:MM:SSZ'
    # },
    # # 更新日
    # 'update_date': {
    #     'label': '更新日',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': False,
    #     'date_format': '%Y-%m-%dT%H:%M:%SZ',
    #     'date_format_description': 'yyyy-mm-ddTHH:MM:SSZ'
    # },
    # 削除フラグ
    'delete_flg': {
        'label': '削除フラグ',
        'min': 0,
        'max': 0,
        'is_required': False,
        'is_bool': True
    },
    # system_usable_flag
    'system_usable_flag': {
        'label': 'system_usable_flag',
        'min': 0,
        'max': 2,
        'is_required': False,
        'is_intger': True
    },
    # 代表者の生年月日
    'company_leader_date_of_birth': {
        'label': '代表者の生年月日',
        'min': 10,
        'max': 10,
        'is_required': False,
        'is_date': True,
        'date_format': '%Y/%m/%d',
        'date_format_description': 'yyyy/mm/dd'
    },
}


class MCompany:
    def __init__(self):
        # 企業コード
        self.company_code: str
        # 申込みコード
        self.entry_code: str
        # 営業コード
        self.salesman_code: str
        # 企業名
        self.company_name: str
        # 企業名(カナ)
        self.company_name_kana: str
        # 郵便番号
        self.company_zipcode: str
        # 住所(都道府県)
        self.company_address_pref: str
        # 住所1
        self.company_address_1: str
        # 住所2
        self.company_address_2: str
        # 住所3
        self.company_address_3: str
        # 住所1(カナ)
        self.company_address_1_kana: str
        # 住所2(カナ)
        self.company_address_2_kana: str
        # 住所3(カナ)
        self.company_address_3_kana: str
        # 電話番号1
        self.company_tel_1: str
        # FAX1
        self.company_fax_1: str
        # 代表者名(姓)
        self.company_leader_last: str
        # 代表者名(名)
        self.company_leader_first: str
        # 代表者名(姓)(カナ)
        self.company_leader_kana_last: str
        # 代表者名(名)(カナ)
        self.company_leader_kana_first: str
        # 登録日
        self.insert_date: str
        # 更新日
        self.update_date: str
        # 削除フラグ
        self.delete_flg: str
        # system_usable_flag
        self.system_usable_flag: str
        # 代表者の生年月日
        self.company_leader_date_of_birth: str

    def set_company_code(self, company_code):
        self.company_code = company_code

    def set_entry_code(self, entry_code):
        self.entry_code = entry_code

    def set_salesman_code(self, salesman_code):
        self.salesman_code = salesman_code

    def set_company_name(self, company_name):
        self.company_name = company_name

    def set_company_name_kana(self, company_name_kana):
        self.company_name_kana = company_name_kana

    def set_company_zipcode(self, company_zipcode):
        self.company_zipcode = company_zipcode

    def set_company_address_pref(self, company_address_pref):
        self.company_address_pref = company_address_pref

    def set_company_address_1(self, company_address_1):
        self.company_address_1 = company_address_1

    def set_company_address_2(self, company_address_2):
        self.company_address_2 = company_address_2

    def set_company_address_3(self, company_address_3):
        self.company_address_3 = company_address_3

    def set_company_address_1_kana(self, company_address_1_kana):
        self.company_address_1_kana = company_address_1_kana

    def set_company_address_2_kana(self, company_address_2_kana):
        self.company_address_2_kana = company_address_2_kana

    def set_company_address_3_kana(self, company_address_3_kana):
        self.company_address_3_kana = company_address_3_kana

    def set_company_tel_1(self, company_tel_1):
        self.company_tel_1 = company_tel_1

    def set_company_fax_1(self, company_fax_1):
        self.company_fax_1 = company_fax_1

    def set_company_leader_last(self, company_leader_last):
        self.company_leader_last = company_leader_last

    def set_company_leader_first(self, company_leader_first):
        self.company_leader_first = company_leader_first

    def set_company_leader_kana_last(self, company_leader_kana_last):
        self.company_leader_kana_last = company_leader_kana_last

    def set_company_leader_kana_first(self, company_leader_kana_first):
        self.company_leader_kana_first = company_leader_kana_first

    def set_insert_date(self, insert_date):
        self.insert_date = insert_date

    def set_update_date(self, update_date):
        self.update_date = update_date

    def set_delete_flg(self, delete_flg):
        self.delete_flg = delete_flg

    def set_company_leader_date_of_birth(self, company_leader_date_of_birth):
        self.company_leader_date_of_birth = company_leader_date_of_birth


M_CONTRACT = {
    # 契約ID
    'contract_id': {
        'label': '契約ID',
        'min': 10,
        'max': 10,
        'is_required': True
    },
    # 企業コード
    'company_code': {
        'label': '企業コード',
        'min': 6,
        'max': 10,
        'is_required': True
    },
    # 契約名
    'subscription_name': {
        'label': '契約名',
        'min': 0,
        'max': 85,
        'is_required': True
    },
    # 契約者名
    'contract_name': {
        'label': '契約者名',
        'min': 0,
        'max': 40,
        'is_required': True
    },
    # 契約者名カナ
    'contract_name_kana': {
        'label': '契約者名カナ',
        'min': 0,
        'max': 40,
        'is_required': True
    },
    # 契約開始日
    'subscription_start_date': {
        'label': '契約開始日',
        'min': 10,
        'max': 10,
        'is_required': False,
        'is_date': True,
        'date_format': '%Y/%m/%d',
        'date_format_description': 'yyyy/mm/dd'
    },
    # 契約終了日
    'subscription_end_date': {
        'label': '契約終了日',
        'min': 10,
        'max': 10,
        'is_required': False,
        'is_date': True,
        'date_format': '%Y/%m/%d',
        'date_format_description': 'yyyy/mm/dd'
    },
    # 送付先名
    'postal_address': {
        'label': '送付先名',
        'min': 0,
        'max': 150,
        'is_required': True
    },
    # 郵便番号
    'contract_zipcode': {
        'label': '郵便番号',
        'min': 7,
        'max': 7,
        'is_required': True
    },
    # 都道府県
    'contract_address_pref': {
        'label': '都道府県',
        'min': 0,
        'max': 4,
        'is_required': True
    },
    # 住所１
    'contract_address_1': {
        'label': '住所１',
        'min': 0,
        'max': 80,
        'is_required': True
    },
    # 住所２
    'contract_address_2': {
        'label': '住所２',
        'min': 0,
        'max': 80,
        'is_required': False
    },
    # 電話番号
    'contract_tel_1': {
        'label': '電話番号',
        'min': 10,
        'max': 11,
        'is_required': True
    },
    # メールアドレス
    'contract_email': {
        'label': 'メールアドレス',
        'min': 0,
        'max': 80,
        'is_required': True
    },
    # 部署名
    'contract_department': {
        'label': '部署名',
        'min': 0,
        'max': 20,
        'is_required': True
    },
    # 担当営業名
    'salesman_name': {
        'label': '担当営業名',
        'min': 0,
        'max': 20,
        'is_required': True
    },
    # # 適用開始日
    # 'applicable_start_date': {
    #     'label': '適用開始日',
    #     'min': 10,
    #     'max': 10,
    #     'is_required': False,
    #     'is_date': True,
    #     'date_format': '%Y/%m/%d',
    #     'date_format_description': 'yyyy/mm/dd'
    # },
    # # 適用終了日
    # 'applicable_end_date': {
    #     'label': '適用終了日',
    #     'min': 10,
    #     'max': 10,
    #     'is_required': False,
    #     'is_date': True,
    #     'date_format': '%Y/%m/%d',
    #     'date_format_description': 'yyyy/mm/dd',
    # },
    # # テキ01 プロジェクトID
    # 'new_business_system_company_id': {
    #     'label': 'テキ01 プロジェクトID',
    #     'min': 0,
    #     'max': 100,
    #     'is_required': True

    # },
    # # 新業務システムの契約番号
    # 'new_biz_sys_contract_number': {
    #     'label': '新業務システムの契約番号',
    #     'min': 0,
    #     'max': 100,
    #     'is_required': True

    # },
    # テキ05 役職(顧客)
    'contract_position': {
        'label': 'テキ05 役職(顧客)',
        'min': 0,
        'max': 100,
        'is_required': False

    },
    # テキ08 請求方法
    'payment_method': {
        'label': 'テキ08 請求方法',
        'min': 0,
        'max': 100,
        'is_required': True

    },
    # テキ09 担当営業(職番)"
    'salesman_code': {
        'label': 'テキ09 担当営業(職番)"',
        'min': 0,
        'max': 100,
        'is_required': True

    },
    # # サービスID
    # 'service_id': {
    #     'label': 'サービスID',
    #     'min': 8,
    #     'max': 8,
    #     'is_required': True

    # },
    # # system_id
    # 'system_id': {
    #     'label': 'ystem_id',
    #     'min': 8,
    #     'max': 8,
    #     'is_required': True

    # },
    # # 最終更新日時
    # 'udate': {
    #     'label': '最終更新日時',
    #     'min':1,
    #     'max':10,
    #     'is_required':True
    #
    # }
    # 備考
    'subscription_notes': {
        'label': '備考',
        'min': 0,
        'max': 200,
        'is_required': False
    },
    # 請求書の送付方法
    'invoice_sending_method': {
        'label': '請求書の送付方法',
        'min': 0,
        'max': 1,
        'is_required': False,
        'is_intger': True
    }
}


class MContract:
    def __init__(self):
        # 契約ID
        self.contract_id: str
        # 企業コード
        self.company_code: str
        # 契約名
        self.subscription_name: str
        # 契約者名
        self.contract_name: str
        # 契約者名カナ
        self.contract_name_kana: str
        # 契約開始日
        self.subscription_start_date: str
        # 契約終了日
        self.subscription_end_date: str
        # 送付先名
        self.postal_address: str
        # 郵便番号
        self.contract_zipcode: str
        # 都道府県
        self.contract_address_pref: str
        # 住所１
        self.contract_address_1: str
        # 住所２
        self.contract_address_2: str
        # 電話番号
        self.contract_tel_1: str
        # メールアドレス
        self.contract_email: str
        # 部署名
        self.contract_department: str
        # 担当営業名
        self.salesman_name: str
        # 適用開始日
        self.applicable_start_date: str
        # 適用終了日
        self.applicable_end_date: str
        # # テキ01 プロジェクトID
        # self.new_business_system_company_id: str
        # # 新業務システムの契約番号
        # self.new_biz_sys_contract_number: str
        # テキ05 役職(顧客)
        self.contract_position: str
        # テキ08 請求方法
        self.payment_method: str
        # テキ09 担当営業(職番)"
        self.salesman_code: str
        # # サービスID
        # self.service_id: str
        # # system_id
        # self.system_id: str
        # 最終更新日時
        self.udate: str
        # 備考
        self.subscription_notes: str
        # 請求書の送付方法
        self.invoice_sending_method: str
        
    def set_contract_id(self, contract_id):
        self.contract_id = contract_id

    def set_company_code(self, company_code):
        self.company_code = company_code

    def set_subscription_name(self, subscription_name):
        self.subscription_name = subscription_name

    def set_contract_name(self, contract_name):
        self.contract_name = contract_name

    def set_contract_name_kana(self, contract_name_kana):
        self.contract_name_kana = contract_name_kana

    def set_subscription_start_date(self, subscription_start_date):
        self.subscription_start_date = subscription_start_date

    def set_subscription_end_date(self, subscription_end_date):
        self.subscription_end_date = subscription_end_date

    def set_postal_address(self, postal_address):
        self.postal_address = postal_address

    def set_contract_zipcode(self, contract_zipcode):
        self.contract_zipcode = contract_zipcode

    def set_contract_address_pref(self, contract_address_pref):
        self.contract_address_pref = contract_address_pref

    def set_contract_address_1(self, contract_address_1):
        self.contract_address_1 = contract_address_1

    def set_contract_address_2(self, contract_address_2):
        self.contract_address_2 = contract_address_2

    def set_contract_tel_1(self, contract_tel_1):
        self.contract_tel_1 = contract_tel_1

    def set_contract_email(self, contract_email):
        self.contract_email = contract_email

    def set_contract_department(self, contract_department):
        self.contract_department = contract_department

    def set_salesman_name(self, salesman_name):
        self.salesman_name = salesman_name

    def set_applicable_start_date(self, applicable_start_date):
        self.applicable_start_date = applicable_start_date

    def set_applicable_end_date(self, applicable_end_date):
        self.applicable_end_date = applicable_end_date

    # def set_new_business_system_company_id(self, new_business_system_company_id):
    #     self.new_business_system_company_id = new_business_system_company_id

    # def set_new_biz_sys_contract_number(self, new_biz_sys_contract_number):
    #     self.new_biz_sys_contract_number = new_biz_sys_contract_number

    def set_contract_position(self, contract_position):
        self.contract_position = contract_position

    def set_payment_method(self, payment_method):
        self.payment_method = payment_method

    def set_salesman_code(self, salesman_code):
        self.salesman_code = salesman_code

    def set_service_id(self, service_id):
        self.service_id = service_id

    def set_system_id(self, system_id):
        self.system_id = system_id

    def set_udate(self, udate):
        self.udate = udate

    def set_subscription_notes(self, subscription_notes):
        self.subscription_notes = subscription_notes

    def set_invoice_sending_method(self, invoice_sending_method):
        self.invoice_sending_method = invoice_sending_method


M_CONTRACT_PRODUCT = {
    # 契約商品ID
    'contract_product_id': {
        'label': '契約商品ID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
    # 契約ID
    'contract_id': {
        'label': '契約ID',
        'min': 10,
        'max': 10,
        'is_required': True
    },
    # 商品ID
    'product_id': {
        'label': '商品ID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
}


class MContractProduct:
    def __init__(self):
        # 契約商品ID
        self.contract_product_id: str
        # 契約ID
        self.contract_id: str
        # 商品ID
        self.product_id: str
        # 最終更新日時
        self.udate: str

    def set_contract_product_id(self, contract_product_id):
        self.contract_product_id = contract_product_id

    def set_contract_id(self, contract_id):
        self.contract_id = contract_id

    def set_product_id(self, product_id):
        self.product_id = product_id

    def set_udate(self, udate):
        self.udate = udate


M_NEW_BIZ_SYS_INFO = {
    # 新業務システム情報マスタID
    'new_biz_sys_info_id': {
        'label': '新業務システム情報マスタID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
    # 企業コード
    'company_code': {
        'label': '企業コード',
        'min': 6,
        'max': 6,
        'is_required': True
    },
    # 新業務システムの取引先コード
    'new_biz_sys_company_id': {
        'label': '新業務システムの取引先コード',
        'min': 10,
        'max': 10,
        'is_required': False
    },
    # 新業務システムの契約番号
    'new_biz_sys_contract_number': {
        'label': '新業務システムの契約番号',
        'min': 14,
        'max': 14,
        'is_required': False
    },
    # 新業務システムのプロジェクトコード
    'new_biz_sys_project_code': {
        'label': '新業務システムのプロジェクトコード',
        'min': 7,
        'max': 7,
        'is_required': False
    },
    # 売上区分ID
    'sales_category_id': {
        'label': '売上区分ID',
        'min': 8,
        'max': 8,
        'is_required': False
    },
    # 新業務システムの契約開始日
    'new_biz_sys_contract_start_date': {
        'label': '新業務システムの契約開始日',
        'min': 10,
        'max': 10,
        'is_required': True
    },
    # 新業務システムの契約終了日
    'new_biz_sys_contract_end_date': {
        'label': '新業務システムの契約終了日',
        'min': 10,
        'max': 10,
        'is_required': False
    }
}


class MNewBizSysInfo:
    def __init__(self):
        # 新業務システム情報マスタID
        self.new_biz_sys_info_id: str
        # 企業コード
        self.company_code: str
        # 新業務システムの取引先コード
        self.new_biz_sys_company_id: str
        # 新業務システムの契約番号
        self.new_biz_sys_contract_number: str
        # 新業務システムのプロジェクトコード
        self.new_biz_sys_project_code: str
        # 売上区分ID
        self.sales_category_id: str
        # 新業務システムの契約開始日
        self.new_biz_sys_contract_start_date: str
        # 新業務システムの契約終了日
        self.new_biz_sys_contract_end_date: str
        # 最終更新日時
        self.udate: str

    def set_new_biz_sys_info_id(self, new_biz_sys_info_id):
        self.new_biz_sys_info_id = new_biz_sys_info_id

    def set_company_code(self, company_code):
        self.company_code = company_code

    def set_new_biz_sys_company_id(self, new_biz_sys_company_id):
        self.new_biz_sys_company_id = new_biz_sys_company_id

    def set_new_biz_sys_contract_number(self, new_biz_sys_contract_number):
        self.new_biz_sys_contract_number = new_biz_sys_contract_number

    def set_new_biz_sys_project_code(self, new_biz_sys_project_code):
        self.new_biz_sys_project_code = new_biz_sys_project_code

    def set_sales_category_id(self, sales_category_id):
        self.sales_category_id = sales_category_id

    def set_new_biz_sys_contract_start_date(self, new_biz_sys_contract_start_date):
        self.new_biz_sys_contract_start_date = new_biz_sys_contract_start_date

    def set_new_biz_sys_contract_end_date(self, new_biz_sys_contract_end_date):
        self.new_biz_sys_contract_end_date = new_biz_sys_contract_end_date

    def set_udate(self, udate):
        self.udate = udate


class MNewBizSysSalesCategory:
    def __init__(self):
        # 売上区分ID
        self.sales_category_id: str
        # 新業務システムのプロジェクト名
        self.new_biz_sys_project_name: str

    def set_sales_category_id(self, sales_category_id):
        self.sales_category_id = sales_category_id

    def set_new_biz_sys_project_name(self, new_biz_sys_project_name):
        self.new_biz_sys_project_name = new_biz_sys_project_name

M_SEND_MAIL = {
    # メールID
    'mail_id': {
        'label': 'メールID',
        'min': 0,
        'max': 0,
        'is_required': True
    },
    # サービスID
    'service_id': {
        'label': 'サービスID',
        'min': 0,
        'max': 0,
        'is_required': True
    },
    # メールの種類
    'mail_type': {
        'label': 'メールの種類',
        'min': 0,
        'max': 0,
        'is_required': True
    },
    # メールの送信TO
    'mail_to': {
        'label': 'メールの送信TO',
        'min': 0,
        'max': 0,
        'is_required': False,
        'is_email': True
    },
    # メールの送信CC
    'mail_cc': {
        'label': 'メールの送信CC',
        'min': 0,
        'max': 0,
        'is_required': False,
        'is_email': True
    },
    # メールの送信BCC
    'mail_bcc': {
        'label': 'メールの送信BCC',
        'min': 0,
        'max': 0,
        'is_required': False,
        'is_email': True
    },
    # 送信元
    'mail_send_from': {
        'label': '送信元',
        'min': 0,
        'max': 0,
        'is_required': True,
        'is_email': True
    },
    # 件名
    'mail_subject': {
        'label': '件名',
        'min': 0,
        'max': 0,
        'is_required': True
    },
    # 本文
    'mail_body': {
        'label': '本文',
        'min': 0,
        'max': 0,
        'is_required': True
    }
    # # 最終更新日時
    # 'udate': {
    #     'label': '最終更新日時',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': True
    # }
}

class MSendMail:
    def __init__(self):
        # メールID
        self.mail_id: str
        # サービスID
        self.service_id: str
        # メールの種類
        self.mail_type: str
        # メールの送信TO
        self.mail_to: str
        # メールの送信CC
        self.mail_cc: str
        # メールの送信BCC
        self.mail_bcc: str
        # 送信元
        self.mail_send_from: str
        # 件名
        self.mail_subject: str
        # 本文
        self.mail_body: str
        # 最終更新日時
        self.udate: str

    def set_mail_id(self, mail_id):
        self.mail_id = mail_id
        
    def set_service_id(self, service_id):
        self.service_id = service_id
        
    def set_mail_type(self, mail_type):
        self.mail_type = mail_type
        
    def set_mail_to(self, mail_to):
        self.mail_to = mail_to
        
    def set_mail_cc(self, mail_cc):
        self.mail_cc = mail_cc
        
    def set_mail_bcc(self, mail_bcc):
        self.mail_bcc = mail_bcc
        
    def set_mail_send_from(self, mail_send_from):
        self.mail_send_from = mail_send_from
        
    def set_mail_subject(self, mail_subject):
        self.mail_subject = mail_subject
        
    def set_mail_body(self, mail_body):
        self.mail_body = mail_body
        
    def set_udate(self, udate):
        self.udate = udate