from .view import Base, GV

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_services'
    primary_key_columns = ['service_id']
    exclude_search_columns = []
    is_view = True
    
    def after_get_all(self, items):

        for item in items:
            # "クライアント/サーバ型（Windows版）",
            if item.system_configuration_type == 0:
                item.system_configuration_type = 'クライアント/サーバ型（Windows版）'
            # "クライアント/サーバ型（RHEL版）",
            elif item.system_configuration_type == 1:
                item.system_configuration_type = 'クライアント/サーバ型（RHEL版）'
            # "ソルバー型",
            elif item.system_configuration_type == 2:
                item.system_configuration_type = 'ソルバー型'
            # "スタンドアローン型"
            elif item.system_configuration_type == 3:
                item.system_configuration_type = 'スタンドアローン型'
            else:
                item.system_configuration_type = ''

        pass
