from .view import Base, GV
import json

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_regular_products'
    primary_key_columns = ['product_id']
    exclude_search_columns = []
    is_view = True

    def after_get_all(self, items):

        for item in items:
            # iXybŇ^ϊ
            if item.instance_type:
                item.instance_type = json.dumps(item.instance_type, ensure_ascii=False, indent=4, sort_keys=True, separators=(',', ': '))