from .view import Base, GV

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_questionnaire_answer'
    primary_key_columns = ['questionnaire_answer_id']
    exclude_search_columns = []
    is_view = True

    QUESTIONNAIRE_TYPE = {
        'document': '資料請求',
        'trial': 'トライアル申込',
        'ma_contract': '保守契約企業利用申込',
        'workshop': 'ワークショップ申込',
        'contract': '本契約申込'
    }

    def after_get_all(self, items):
        for i in items:
            if i.questionnaire_type in self.QUESTIONNAIRE_TYPE:
                i.questionnaire_type = self.QUESTIONNAIRE_TYPE[i.questionnaire_type]
        pass