from .view import Base, GV

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_contract'
    primary_key_columns = ['manage_req_id']
    exclude_search_columns = []
    is_view = True

    def after_get_all(self, items):

        for item in items:
            
            # 請求書の送付方法
            if item.gmo_invoice_mail == 0:
                item.gmo_invoice_mail = 'PDF'
            elif item.gmo_invoice_mail == 1:
                item.gmo_invoice_mail = '郵送(書類)'
            else:
                item.gmo_invoice_mail = 'PDF'

            if item.credit_check == True:
                item.credit_check = 'OK'
            elif item.credit_check == False:
                item.credit_check = 'NG'
            else:
                item.credit_check = None

            if item.prospect_request == True:
                item.prospect_request = 'OK'
            elif item.prospect_request == False:
                item.prospect_request = 'NG'
            else:
                item.prospect_request = None

            if item.contract_id is None:
                if item.payment_method is None:
                    if item.use_gmo_payment:
                        item.payment_method = 'GMO掛け払い'
                    else:
                        item.payment_method = 'GMO掛け払い以外'

            # 申込完了メール送信日
            if item.application_completion_email_sent_date:
                item.application_completion_email_sent_date = item.application_completion_email_sent_date.strftime(
                    '%Y/%m/%d')
                
            # 代表者の生年月日
            if item.company_leader_date_of_birth:
                item.company_leader_date_of_birth = item.company_leader_date_of_birth.strftime(
                    '%Y/%m/%d')
            
            # 契約開始日
            if item.subscription_start_date:
                item.subscription_start_date = item.subscription_start_date.strftime(
                    '%Y/%m/%d')
            # 契約終了日
            if item.subscription_end_date:
                item.subscription_end_date = item.subscription_end_date.strftime(
                    '%Y/%m/%d')
            # 招待日
            if item.invitation_date:
                item.invitation_date = item.invitation_date.strftime(
                    '%Y/%m/%d')
                
            # 信用調査結果登録日
            if item.credit_check_regist_date:
                item.credit_check_regist_date = item.credit_check_regist_date.strftime(
                    '%Y/%m/%d')
                
            # プロスペクト申請結果登録日
            if item.prospect_request_regist_date:
                item.prospect_request_regist_date = item.prospect_request_regist_date.strftime(
                    '%Y/%m/%d')
                   
            # 枠保証審査依頼日時
            if item.examination_request_date:
                item.examination_request_date = item.examination_request_date.strftime(
                    '%Y/%m/%d')
            # 枠保証利用開始日
            if item.creditfacility_startdate:
                item.creditfacility_startdate = item.creditfacility_startdate.strftime(
                    '%Y/%m/%d')
            # 枠保証利用終了日
            if item.creditfacility_enddate:
                item.creditfacility_enddate = item.creditfacility_enddate.strftime(
                    '%Y/%m/%d')

            # 一時休止開始予定日
            if item.temp_service_sleep_start_date:
                item.temp_service_sleep_start_date = item.temp_service_sleep_start_date.strftime(
                    '%Y/%m/%d')
            # 一時休止からの再開予定日
            if item.temp_service_sleep_restart_date:
                item.temp_service_sleep_restart_date = item.temp_service_sleep_restart_date.strftime(
                    '%Y/%m/%d')
            # 停止予定日
            if item.ndes_service_stop_start_date:
                item.ndes_service_stop_start_date = item.ndes_service_stop_start_date.strftime(
                    '%Y/%m/%d')
            # 停止からの再開予定日
            if item.ndes_service_stop_restart_date:
                item.ndes_service_stop_restart_date = item.ndes_service_stop_restart_date.strftime(
                    '%Y/%m/%d')
            # サービスの解約メール送信日
            if item.termination_of_service_mail_send_date:
                item.termination_of_service_mail_send_date = item.termination_of_service_mail_send_date.strftime(
                    '%Y/%m/%d')
            # サービスの再開事前通知実施日
            if item.pre_notification_resumption_of_service_mael_send_date:
                item.pre_notification_resumption_of_service_mael_send_date = item.pre_notification_resumption_of_service_mael_send_date.strftime(
                    '%Y/%m/%d')
        pass
