from .model import Base, GV, CustomException, or_

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'billing_infrastructure'
    table_name = 'tax_rate'
    primary_key_columns = ['taxation_code_id']
    exclude_search_columns = []
    
    def before_new_item(self, item):
        print('m_services before_new_item ----------------')
        try:

            filters = []
            filters.append(self.model_class.taxation_name ==
                           item.taxation_name)
            filters = or_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.taxation_name == item.taxation_name:
                    raise CustomException('TR_ERR_100')

            item.taxation_code_id = self.new_id('課税区分ID', 'TC', 4)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise