from .model import Base, GV, CustomException, and_, or_

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'billing_infrastructure'
    table_name = 'm_systems'
    primary_key_columns = ['system_id']
    exclude_search_columns = []

    def before_new_item(self, item=None, data=None):
        print('m_systems before_new_item ----------------')
        try:

            filters = []
            filters.append(self.model_class.system_name ==
                           item.system_name)
            filters.append(self.model_class.prefix == item.prefix)
            filters.append(self.model_class.ad_domain_name == item.ad_domain_name)
            filters.append(self.model_class.sub_domain_name == item.sub_domain_name)
            filters = or_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.system_name == item.system_name:
                    raise CustomException('MSYS_ERR_100')
                elif tmp.prefix == item.prefix:
                    raise CustomException('MSYS_ERR_101')
                elif tmp.ad_domain_name == item.ad_domain_name:
                    raise CustomException('MSYS_ERR_102')
                elif tmp.sub_domain_name == item.sub_domain_name:
                    raise CustomException('MSYS_ERR_103')
                
            print('m_systems before_new_item ----------------1')
                
            # from ..model.m_numbering import Sub as MN
            # mnum = MN()
            MN = GV.get_module('m_numbering')
            mnum = MN()

            print('m_systems before_new_item ----------------2')
            
            nmum_item = mnum.get_new_number('システムID')
            item.system_id = 'SYS' + str(nmum_item.number).zfill(5)

            super().before_new_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    def before_update_item(self, item=None, data=None):
        print('m_systems before_update_item ----------------')
        try:
            
            filters = []
            filters.append(self.model_class.system_name ==
                           item.system_name)
            filters.append(self.model_class.prefix == item.prefix)
            filters.append(self.model_class.ad_domain_name == item.ad_domain_name)
            filters.append(self.model_class.sub_domain_name == item.sub_domain_name)
            filters = and_(
                self.model_class.system_id != item.system_id,
                or_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.system_name == item.system_name:
                    raise CustomException('MSYS_ERR_100')
                elif tmp.prefix == item.prefix:
                    raise CustomException('MSYS_ERR_101')
                elif tmp.ad_domain_name == item.ad_domain_name:
                    raise CustomException('MSYS_ERR_102')
                elif tmp.sub_domain_name == item.sub_domain_name:
                    raise CustomException('MSYS_ERR_103')
                            
            super().before_update_item(item, data)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
