from .model import Base, GV, CustomException, and_, or_

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'billing_infrastructure'
    table_name = 'm_services'
    primary_key_columns = ['service_id']
    exclude_search_columns = []
          
    def before_new_item(self, item):
        print('m_services before_new_item ----------------')
        try:

            filters = []
            filters.append(self.model_class.service_name ==
                           item.service_name)
            filters = or_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.service_name == item.service_name:
                    raise CustomException('MSRV_ERR_100')

            # item.service_id = self.new_id()
            item.service_id = self.new_id('サービスID', 'SRV', 5)

            super().before_new_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    def before_update_item(self, item=None, data=None):
        print('m_services before_update_item ----------------')
        try:
            
            filters = []
            filters.append(self.model_class.service_name ==
                           item.service_name)
            filters = and_(
                self.model_class.service_id != item.service_id,
                or_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.service_name == item.service_name:
                    raise CustomException('MSRV_ERR_100')
            
            super().before_update_item(item, data)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    # def after_update_item(self, item=None, data=None):
    #     print('after_update_item -----------------')
        
    #     from ..model.m_services_and_related_sales_categories import Sub as MSARSC
    #     m_sarsc = MSARSC()
            
    #     item_m_sarsc = {'service_id': item.service_id}
    #     m_sarsc._delete(item_m_sarsc)
        
    #     for i in item.sales_category_list:
    #         if 'service_id' in i:
    #             m_sarsc._add(i)
    #             pass
    #         else:
    #             i['service_id'] = item.service_id
    #             m_sarsc._add(i)
    
    #     return item
    
    def after_update_item(self, item=None, data=None):
        print('after_update_item -----------------')
        
        # from ..model.m_services_and_related_sales_categories import Sub as MSARSC
        # m_sarsc = MSARSC()
        MSARSC = GV.get_module('m_services_and_related_sales_categories')
        m_sarsc = MSARSC()

        item_m_sarsc = {'service_id': item.service_id}
        m_sarsc._delete(item_m_sarsc)
        
        for item_scl in item.sales_category_list:
            if 'service_id' in item_scl:
                m_sarsc._add(item_scl)
                pass
            else:
                item_scl['service_id'] = item.service_id
                m_sarsc._add(item_scl)
    
        return item