from .model import Base, GV, CustomException, and_
import json

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'billing_infrastructure'
    table_name = 'm_regular_products'
    primary_key_columns = ['product_id']
    exclude_search_columns = []
   
    def get_system_prefix(self, item):
        print('m_regular_products get_system_prefix ----------------')
        
        # from ..model.m_systems import Sub as MSys
        # msys = MSys()
        MSys = GV.get_module('m_systems')
        msys = MSys()

        filters = []
        filters.append(msys.model_class.system_id == item.system_id)
        filters = and_(*filters)
        system_item = msys._get_item_by_filters(filters)
        if system_item:
            return system_item
        else:
            raise CustomException('SYS_ERR_100')
                    
    def before_new_item(self, item):
        print('m_regular_products before_new_item ----------------')
        try:

            # 同じ「適用開始日」のデータがすでに存在します。
            filters = []
            filters.append(self.model_class.system_id == item.system_id)
            filters.append(self.model_class.product_code == item.product_code)
            filters.append(self.model_class.applicable_start_date == item.applicable_start_date)
            filters = and_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.applicable_start_date == item.applicable_start_date:
                    raise CustomException('MRP_ERR_100')
                
            # 同じ「商品名」のデータがすでに存在します。
            filters = []
            filters.append(self.model_class.system_id == item.system_id)
            filters.append(self.model_class.product_name == item.product_name)
            filters = and_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.product_name == item.product_name:
                    raise CustomException('MRP_ERR_101')
                
            # 商品コードのPrefixが正しくありません。
            system_item = self.get_system_prefix(item)
            if item.product_code[0:3] != system_item.prefix:
                raise CustomException('MRP_ERR_102')

            # 商品スペックはjsonで定義してください。
            if item.instance_type:
                try:
                    dict_data = json.loads(item.instance_type)
                    item.instance_type = dict_data
                except Exception as e:
                    raise CustomException('MRP_ERR_103')
                
            # テーブル定義がNOT NULLのため
            if item.billing_identifier is None:
                item.billing_identifier = ''

            # 採番 
            # item.product_id = self.new_id()
            item.product_id = self.new_id('商品ID', 'RP', 6)

            super().before_new_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    def before_update_item(self, item=None, data=None):
        print('m_regular_products before_update_item ----------------')
        try:
            
            # 同じ「適用開始日」のデータがすでに存在します。
            filters = []
            filters.append(self.model_class.system_id == item.system_id)
            filters.append(self.model_class.product_code == item.product_code)
            filters.append(self.model_class.applicable_start_date == item.applicable_start_date)
            filters = and_(
                self.model_class.product_id != item.product_id,
                and_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.applicable_start_date.isoformat() == item.applicable_start_date:
                    raise CustomException('MRP_ERR_100')
                
            # 同じ「商品名」のデータがすでに存在します。
            filters = []
            filters.append(self.model_class.system_id == item.system_id)
            filters.append(self.model_class.product_name == item.product_name)
            filters = and_(
                self.model_class.product_id != item.product_id,
                and_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.product_name == item.product_name:
                    raise CustomException('MRP_ERR_101')
                
            # 商品コードのPrefixが正しくありません。
            system_item = self.get_system_prefix(item)
            if item.product_code[0:3] != system_item.prefix:
                raise CustomException('MRP_ERR_102')
            
            # 商品スペックはjsonで定義してください。
            if item.instance_type:
                try:
                    dict_data = json.loads(item.instance_type)
                    item.instance_type = dict_data
                except e:
                    raise CustomException('MRP_ERR_103')
                
            # テーブル定義がNOT NULLのため
            if item.billing_identifier is None:
                item.billing_identifier = ''
            
            super().before_update_item(item, data)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise