from .model import Base, GV, CustomException, and_, or_

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_numbering'
    primary_key_columns = ['id']
    exclude_search_columns = ['cdate', 'udate']

    # 追加前の処理
    def before_new_item(self, item):
        print('m_numbering before_new_item ----------------')
        try:

            super().before_new_item(item)

            filters = []
            filters.append(self.model_class.number_id ==
                           item.number_id)
            filters.append(self.model_class.number_name ==
                           item.number_name)
            filters = or_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.number_id == item.number_id:
                    raise CustomException('MNUM_ERR_100')
                if tmp.number_name == item.number_name:
                    raise CustomException('MNUM_ERR_101')

        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    # 更新前の処理
    def before_update_item(self, item=None, data=None):
        print('m_numbering before_update_item ----------------')
        try:

            super().before_update_item(item, data)

            filters = []
            filters.append(self.model_class.number_id ==
                           item.number_id)
            filters.append(self.model_class.number_name ==
                           item.number_name)
            filters = and_(
                self.model_class.id != item.id,
                or_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.number_id == item.number_id:
                    raise CustomException('MNUM_ERR_100')
                if tmp.number_name == item.number_name:
                    raise CustomException('MNUM_ERR_101')

        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    def get_new_number(self, number_name):
        print('----------- get_new_number')
        print('----------- number_name')
        print(number_name)
        try:

            filters = []
            filters.append(self.model_class.number_name == number_name)
            filters = or_(*filters)
            tmp = self._get_item_by_filters(filters)
            print(tmp)
            if tmp:
                item = tmp
                item.number = item.number + 1

                item = self._update(item.to_dict())

                return item
            else:
                raise CustomException('SYS_ERR_100')

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
