from .model import Base, GV, CustomException, and_, or_

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_list_items'
    primary_key_columns = ['id']
    exclude_search_columns = []

    # 追加前の処理
    def before_new_item(self, item):
        print('m_list_items before_new_item ----------------')
        try:

            super().before_new_item(item)

            filters = []
            filters.append(self.model_class.label ==
                           item.label)
            filters.append(self.model_class.value ==
                           item.value)
            filters = and_(
                self.model_class.type == item.type,
                or_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.label == item.label:
                    raise CustomException('MLI_ERR_100')
                if tmp.value == item.value:
                    raise CustomException('MLI_ERR_101')

        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    # 更新前の処理
    def before_update_item(self, item=None, data=None):
        print('m_list_items before_update_item ----------------')
        try:

            super().before_update_item(item, data)

            filters = []
            filters.append(self.model_class.label ==
                           item.label)
            filters.append(self.model_class.value ==
                           item.value)
            filters = and_(
                self.model_class.id != item.id,
                self.model_class.type == item.type,
                or_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.label == item.label:
                    raise CustomException('MLI_ERR_100')
                if tmp.value == item.value:
                    raise CustomException('MLI_ERR_101')

        except Exception as e:
            print(e)
            # 例外の再送出
            raise