from .model import Base, GV

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_contract'
    primary_key_columns = ['contract_id']
    exclude_search_columns = []
    
    def before_new_item(self, item):
        print('m_contract before_new_item ----------------')
        try:

            if item.invoice_sending_method == '郵送(書類)':
                item.invoice_sending_method = 1
            elif item.invoice_sending_method == 'PDF':
                item.invoice_sending_method = 0
            else:
                item.invoice_sending_method = 0

            # 適用開始日 = 契約開始日
            item.applicable_start_date = item.subscription_start_date
            # 適用終了日 = 契約終了日
            item.applicable_end_date = item.subscription_end_date
                
            item.contract_id = self.new_id('契約ID', 'CON', 7)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        
    def before_update_item(self, item=None, data=None):
        print('m_contract before_update_item ----------------')
        try:

            if 'invoice_sending_method' in data:
                if item.invoice_sending_method == '郵送(書類)':
                    item.invoice_sending_method = 1
                elif item.invoice_sending_method == 'PDF':
                    item.invoice_sending_method = 0
                else:
                    item.invoice_sending_method = 0

            # 適用開始日 = 契約開始日
            item.applicable_start_date = item.subscription_start_date
            # 適用終了日 = 契約終了日
            item.applicable_end_date = item.subscription_end_date

            super().before_update_item(item, data)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
