# from .model import Base, GV

# class Sub(Base):
#     database = GV.DB_MSCONE_LIC
#     schema = 'mscone_lic'
#     table_name = 'm_company'
#     primary_key_columns = ['env_id']
#     exclude_search_columns = []


from .model import Base, GV, json, and_

class Sub(Base):
    
    database = GV.DB_MSCONE_LIC
    schema = 'mscone_lic'
    table_name = 'm_company'
    primary_key_columns = ['env_id']
    exclude_search_columns = []

    def __init__(self):

        if GV.SERVICE_PATH is not None:
            # if GV.SERVICE_PATH == 'simsp':
            #     self.database = GV.DB_MSCONE_LIC
            #     self.schema = GV.SCHEMA_MSCONE_LIC
            # elif GV.SERVICE_PATH == 'gradehcld':
            #     self.database = GV.DB_GRADEHULL
            #     self.schema = GV.SCHEMA_GRADEHULL
            # elif GV.SERVICE_PATH == 'beaglecld':
            #     self.database = GV.DB_BEAGLE
            #     self.schema = GV.SCHEMA_BEAGLE

            sub_domain_name = GV.SERVICE_PATH

            db_schema = GV.ENV_CONFIG[GV.ENV.upper()]['SUB_DOMAIN_NAME_DB_SCHEMA'][sub_domain_name.lower()]
            
            self.database = GV.ENV_CONFIG[GV.ENV.upper()][db_schema.upper()][GV.ENV.upper() + '_' + 'DATABASE_NAME']
            self.schema = GV.ENV_CONFIG[GV.ENV.upper()][db_schema.upper()][GV.ENV.upper() + '_' + 'DATABASE_SCHEMA']

        else:
            if GV.SYSTEM is not None:
                # if GV.SYSTEM['sub_domain_name'] == 'simsp':
                #     self.database = GV.DB_MSCONE_LIC
                #     self.schema = GV.SCHEMA_MSCONE_LIC
                # elif GV.SYSTEM['sub_domain_name'] == 'gradehcld':
                #     self.database = GV.DB_GRADEHULL
                #     self.schema = GV.SCHEMA_GRADEHULL
                # elif GV.SYSTEM['sub_domain_name'] == 'beaglecld':
                #     self.database = GV.DB_BEAGLE
                #     self.schema = GV.SCHEMA_BEAGLE
                sub_domain_name = GV.SYSTEM['sub_domain_name']

                db_schema = GV.ENV_CONFIG[GV.ENV.upper()]['SUB_DOMAIN_NAME_DB_SCHEMA'][sub_domain_name.lower()]
                
                # print('db_schema')
                # print(db_schema)

                self.database = GV.ENV_CONFIG[GV.ENV.upper()][db_schema.upper()][GV.ENV.upper() + '_' + 'DATABASE_NAME']
                self.schema = GV.ENV_CONFIG[GV.ENV.upper()][db_schema.upper()][GV.ENV.upper() + '_' + 'DATABASE_SCHEMA']

                # print('self.database')
                # print(self.database)

                # print('self.schema')
                # print(self.schema)


        print('@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@')
        print('m_company_mscone_lic.py')
        print(self.database)
        print(self.schema)
        print('@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@')

        self.table_name = 'm_company'
        self.primary_key_columns = ['env_id']
        self.exclude_search_columns = []

        super().__init__()
        
    def get_data_m_company(self, data=None):

        print('get_data_m_company')

        if type(data) is str:
            try:
                data = json.loads(data)
                pass
            except Exception as e:
                pass
        
        data_m_com = []

        if data is not None:

            if 'contract_id' in data:

                data_t_mr = None

                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                filters = []
                filters.append(t_mr.model_class.contract_id == data['contract_id'])
                filters = and_(*filters)

                tmp_t_mr = t_mr._get_item_by_filters(filters)

                if tmp_t_mr is not None:
                    data_t_mr = tmp_t_mr.to_dict()
                    print('data_t_mr')
                    print(data_t_mr)

                if data_t_mr is not None:

                    data_m_sys = None

                    MSYS = GV.get_module('m_systems')
                    m_sys = MSYS()

                    filters = []
                    filters.append(m_sys.model_class.system_id == data_t_mr['system_id'])
                    filters = and_(*filters)
                    tmp_m_sys = m_sys._get_item_by_filters(filters)

                    if tmp_m_sys is not None:
                        data_m_sys = tmp_m_sys.to_dict()
                        print('data_m_sys')
                        print(data_m_sys)

                    # if data_m_sys is not None:
                    #     if data_m_sys['sub_domain_name'] == 'simsp':
                    #         self.database = GV.DB_MSCONE_LIC
                    #         self.schema = GV.SCHEMA_MSCONE_LIC
                    #     elif data_m_sys['sub_domain_name'] == 'gradehcld':
                    #         self.database = GV.DB_GRADEHULL
                    #         self.schema = GV.SCHEMA_GRADEHULL
                    #     elif data_m_sys['sub_domain_name'] == 'beaglecld':
                    #         self.database = GV.DB_BEAGLE
                    #         self.schema = GV.SCHEMA_BEAGLE
                    if data_m_sys is not None:

                        sub_domain_name = data_m_sys['sub_domain_name']

                        db_schema = GV.ENV_CONFIG[GV.ENV.upper()]['SUB_DOMAIN_NAME_DB_SCHEMA'][sub_domain_name.lower()]
                        
                        print('db_schema')
                        print(db_schema)

                        self.database = GV.ENV_CONFIG[GV.ENV.upper()][db_schema.upper()][GV.ENV.upper() + '_' + 'DATABASE_NAME']
                        self.schema = GV.ENV_CONFIG[GV.ENV.upper()][db_schema.upper()][GV.ENV.upper() + '_' + 'DATABASE_SCHEMA']

                        print('self.database')
                        print(self.database)

                        print('self.schema')
                        print(self.schema)

                        super().__init__()

                if 'company_code' in data:

                    filters = []
                    filters.append(self.model_class.company_code == data['company_code'])
                    filters = and_(*filters)
                    tmp_m_com = self._get_item_by_filters(filters, get_all=True)

                    for t in tmp_m_com:
                        data_m_com.append(t.to_dict())

        print(data_m_com)

        res = {}
        res['result'] = data_m_com

        return res