from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, datetime

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'workshop_event_date'

    def get_all(self, event, context):

        # from ..view.view_workshop_event_date import Sub as VWED
        # v_wed = VWED()
        VWED = GV.get_module('view_workshop_event_date')
        v_wed = VWED()

        return v_wed.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_workshop_event_date import Sub as VWED
        # v_wed = VWED()
        VWED = GV.get_module('view_workshop_event_date')
        v_wed = VWED()

        v_wed.table_config = self.table_name
        return v_wed.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        print(data['workshop_event_date'])

        if data['workshop_event_time_division'] == '午前':
            data['workshop_event_date'] = data['workshop_event_date'] + ' ' + '10:00:00'
        elif data['workshop_event_time_division'] == '午後':
            data['workshop_event_date'] = data['workshop_event_date'] + ' ' + '14:00:00'

        MWED = GV.get_module('m_workshop_event_date')
        m_wed = MWED()

        tmp_m_wed = m_wed._add(data)

        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # https://redmine-comn.ndes-dx.com/issues/4673　対応
        if data['workshop_event_time_division'] == '午前':
            data['workshop_event_date'] = data['workshop_event_date'] + ' ' + '10:00:00'
        elif data['workshop_event_time_division'] == '午後':
            data['workshop_event_date'] = data['workshop_event_date'] + ' ' + '14:00:00'

        # from ..model.m_workshop_event_date import Sub as MWED
        # m_wed = MWED()
        MWED = GV.get_module('m_workshop_event_date')
        m_wed = MWED()

        tmp_m_wed = m_wed._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_workshop_event_date import Sub as MWED
        # m_wed = MWED()
        MWED = GV.get_module('m_workshop_event_date')
        m_wed = MWED()

        tmp_m_wed = m_wed._delete(data)

        return {}