from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, datetime
from pprint import pprint

import re

logger = logging.getLogger(__name__)

logger.setLevel(logging.DEBUG)


class Sub(Base):

    table_name = 'trial'

    def get_all(self, event, context):

        # from ..view.view_trial import Sub as VT
        # v_t = VT()
        VT = GV.get_module('view_trial')
        v_t = VT()

        return v_t.get_all(event, context)

        pass

    def get_table_schema(self):

        # from ..view.view_trial import Sub as VT
        # v_t = VT()
        VT = GV.get_module('view_trial')
        v_t = VT()

        v_t.table_config = self.table_name
        return v_t.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        try:
            logger.debug(GV.EVENT_BODY)
            if GV.EVENT_BODY is None:
                raise CustomException('SYS_ERR_100')
            
            logger.debug('# ************0704******************') 
            if "tenant" in GV.EVENT_BODY:
                params = {
                    'table_name': 'm_auth0_management',
                    'filters': {
                        'tenant': GV.EVENT_BODY["tenant"]
                    }
                }
                data_m_am = self.get_data(params)
                logger.debug(data_m_am)
    
                if data_m_am:
                    logger.debug('# ************Auth0情報を設定する******************')
                    GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                    GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                    GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                    GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                    GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                    GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                    logger.debug(GV.CONFIG)
                    pass
                else:
                    return {"error": "tenant:" + GV.EVENT_BODY["tenant"] + " は存在しないので、システム者にご連絡ください。"}
            logger.debug('# ************0704******************') 


            data = GV.EVENT_BODY

            is_not_request_user = False

            logger.debug('# ******************************')

            data_t_trh = None

            if '# データを検証する。':

                logger.debug('# データを検証する。')

                data_t_trh = {}
                data_t_trh = data.copy()
                data_t_trh['trial_req_id'] = None
                data_t_trh['system_id'] = GV.SYSTEM_ID
                data_t_trh['service_id'] = GV.SERVICE_ID
                data_t_trh['trial_manage_id'] = None
                data_t_trh['company_code'] = None
                data_t_trh['trial_start_date'] = None
                data_t_trh['trial_end_date'] = None
                data_t_trh['cdate'] = None
                data_t_trh['udate'] = None

                res_validate = self.validate(
                    't_trial_request_history', data_t_trh)
                if res_validate != True:
                    return res_validate

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# トライアル環境に利用可能なユーザの空きが無いか確認する':

                logger.debug('# 「トライアル環境ストックマスタ」からデータ取得')
                logger.debug('# m_trial_env_stock')

                params = {
                    'table_name': 'm_trial_env_stock',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'use_flg': False
                    }
                }
                tmp_m_tes = self.get_data(params, is_get_dict=False)

                if tmp_m_tes is None:

                    logger.debug('# ******************************')
                    logger.debug('# 申し込んだが空きユーザ無し フリートライアルの申込受付ができない メール送信')
                    
                    data_email = {}
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['mail_type'] = 'フリートライアルの申込受付ができない'
                    data_email['email_address'] = data['email_address']

                    data_email['company_name'] = data['company_name']
                    data_email['last_name'] = data['last_name']
                    data_email['first_name'] = data['first_name']
                    data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                    self.send_email_trial(data_email)

                    logger.debug('# ##############################')

                    res = {}
                    res = GV.INFO_CODE['TRIAL_I_BUSY']
                    return res
                    pass

            logger.debug('# ##############################')

            auth0_user = None

            if GV.LOGGEDIN_USER:
                logger.debug('# アカウントがあり、ログインした場合')
                pass
            else:
                logger.debug('# ログインしてない場合')

                logger.debug('# ******************************')
                logger.debug('# 申込のメールアドレスのAuth0アカウントが存在するかどうかチェックする')

                # from ..auth0 import Sub as auth0_class
                # auth0 = auth0_class()
                auth0_class = GV.get_module_auth0()
                a0 = auth0_class()

                users = a0._get_users_by_email(data['email_address'])

                if users and len(users) > 0:
                    # 存在する場合

                    auth0_user = users[0]

                    logger.debug('存在する場合')
                    if auth0_user['email_verified']:

                        is_request_user = False
                        if 'user_metadata' in auth0_user:
                            if 'data' in auth0_user['user_metadata']:
                                for d in auth0_user['user_metadata']['data']:
                                    if 'roles' in d:
                                        if 'request_user' in d['roles']:
                                            is_request_user = True
                                            break
                        
                        if is_request_user == True:

                            # メールアドレス検証済の場合
                            # アカウント作成済みのメッセージを返し、
                            # クライアント側でログイン画面へ遷移するようにする
                            logger.debug('# メールアドレス検証済の場合')
                            logger.debug('# アカウント作成済みのメッセージを返し、')
                            logger.debug('# クライアント側でログイン画面へ遷移するようにする')

                            res = {}
                            res = GV.INFO_CODE['TRIAL_I_ACCOUNT_ALREADY_EXISTS']
                            return res
                        
                        else:

                            is_not_request_user = True

                        pass
                    else:
                        # メールアドレス未検証の場合
                        # 検証メールを再送信する
                        # ???
                        logger.debug('# メールアドレス未検証の場合')
                        logger.debug('# 検証メールを再送信する')

                        code = None
                        if 'app_metadata' in auth0_user:
                            if 'trial_req_vefification_code' in auth0_user['app_metadata']:
                                code = auth0_user['app_metadata']['trial_req_vefification_code']

                        if code is not None:
                            logger.debug('# トライアル申込情報がある場合')

                            logger.debug('# ******************************')
                            logger.debug('# トライアル申込完了連絡 メール送信')
                            
                            data_email = {}
                            data_email['service_id'] = GV.SERVICE_ID
                            data_email['mail_type'] = '本人認証とパスワード設定'
                            data_email['email_address'] = data['email_address']
                            data_email['company_name'] = data['company_name']
                            data_email['last_name'] = data['last_name']
                            data_email['first_name'] = data['first_name']
                            data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                            data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                            self.send_email_trial(data_email)
                            
                            logger.debug('# ##############################')

                            return {}

                        pass
                else:
                    # 存在しない場合
                    # 処理継続
                    logger.debug('# 存在しない場合')
                    logger.debug('# 処理継続')

                    pass

                pass

                logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_mr = None

            if '# テーブル「申込管理情報」からデータ検索':

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['email_address']
                    }
                }
                data_t_mr = self.get_data(params)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# ・申込者が同じシステム＋サービスで2回目のフリートライアル(1回目正常終了)を申し込んだ場合：':

                logger.debug(
                    '# ・申込者が同じシステム＋サービスで2回目のフリートライアル(1回目正常終了)を申し込んだ場合：')
                logger.debug('# エラーメッセージを表示。')
                logger.debug('# 営業とサポート(新事推サ)にメール送信。')

                if data_t_mr is not None and \
                        data_t_mr['trial_req_id'] is not None:

                    if data_t_mr['status'] == GV.STATUS['フリートライアル利用中'] or \
                            data_t_mr['status'] == GV.STATUS['フリートライアル終了']:

                        res = {}
                        res = GV.INFO_CODE['TRIAL_I_ALREADY_COMPLETED']

                        logger.debug('# ******************************')
                        logger.debug(
                            '# 2回目の申込のためエラー フリートライアル2回目の申込のためエラー メール送信')

                        data_email = {}
                        data_email['service_id'] = GV.SERVICE_ID

                        data_email['system_id'] = GV.SYSTEM_ID
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['system_name'] = GV.SYSTEM_NAME
                        data_email['service_name'] = GV.SERVICE_NAME
                        data_email['company_name'] = data['company_name']
                        data_email['company_code'] = data_t_mr['company_code']
                        data_email['last_name'] = data['last_name']
                        data_email['first_name'] = data['first_name']
                        data_email['affiliation_department'] = ''
                        data_email['email_address'] = data['email_address']
                        data_email['telephone_number'] = data['telephone_number']

                        data_email['mail_type'] = 'フリートライアル2回目の申込のためエラー'

                        self.send_email_trial(data_email, is_append_to=False)
                        logger.debug('# ##############################')

                        return res

                    pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# ・申込者が同じシステム＋サービスの他の申込中にフリートライアルを申し込んだ場合：':

                logger.debug('# ・申込者が同じシステム＋サービスの他の申込中にフリートライアルを申し込んだ場合：')
                logger.debug('# エラーメッセージを表示。')
                logger.debug('# 営業とサポート(新事推サ)にメール送信。')

                if data_t_mr is not None and \
                    (data_t_mr['workshop_req_id'] is not None or
                        data_t_mr['contract_req_id'] is not None):

                    if data_t_mr['status'] in GV.STATUS_APPLYING_WORKSHOP.keys() or \
                            data_t_mr['status'] in GV.STATUS_APPLYING_CONTRACT.keys():

                        res = {}
                        res = GV.INFO_CODE['TRIAL_I_ANOTHER_APPLYING']

                        logger.debug(
                            '# 他に申込中なのでエラー フリートライアル時、他に申込中のためエラー メール送信')
                        
                        # logger.debug('# ******************************')

                        # data_user_info = None

                        # if '# ユーザー情報を取得する':

                        #     logger.debug('# ユーザー情報を取得する')

                        #     if data_t_mr['contract_req_id'] is not None:

                        #         logger.debug('# 「本契約申込情報（確認済み）」から情報を取得する')
                                    
                        #         params = {
                        #             'table_name': 't_contract_request_confirmed',
                        #             'filters': {
                        #                 'contract_req_id': data_t_mr['contract_req_id']
                        #             }
                        #         }
                        #         data_t_crc = self.get_data(params)
                        #         if data_t_crc is not None:
                        #             data_user_info = {}
                        #             data_user_info['company_name'] = data_t_crc['company_name']
                        #             data_user_info['company_code'] = data_t_crc['company_code']
                        #             data_user_info['last_name'] = data_t_crc['contract_last_name']
                        #             data_user_info['first_name'] = data_t_crc['contract_first_name']
                        #             data_user_info['affiliation_department'] = data_t_crc['contract_affiliation_department']
                        #             data_user_info['email_address'] = data_t_crc['contract_email_address']
                        #             data_user_info['telephone_number'] = data_t_crc['contract_telephone_number']

                        #     elif data_t_mr['workshop_req_id'] is not None:
                                    
                        #         logger.debug('# 「ワークショップ申込情報（確認済み）」から情報を取得する')

                        #         params = {
                        #             'table_name': 't_workshop_request_confirmed',
                        #             'filters': {
                        #                 'workshop_req_id': data_t_mr['workshop_req_id']
                        #             }
                        #         }
                        #         data_t_wrc = self.get_data(params)
                        #         if data_t_wrc is not None:
                        #             data_user_info = {}
                        #             data_user_info['company_name'] = data_t_wrc['company_name']
                        #             data_user_info['company_code'] = data_t_wrc['company_code']
                        #             data_user_info['last_name'] = data_t_wrc['last_name']
                        #             data_user_info['first_name'] = data_t_wrc['first_name']
                        #             data_user_info['affiliation_department'] = data_t_wrc['affiliation_department']
                        #             data_user_info['email_address'] = data_t_wrc['email_address']
                        #             data_user_info['telephone_number'] = data_t_wrc['telephone_number']

                        # logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        data_email = {}
                        data_email['service_id'] = GV.SERVICE_ID

                        data_email['system_id'] = GV.SYSTEM_ID
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['system_name'] = GV.SYSTEM_NAME
                        data_email['service_name'] = GV.SERVICE_NAME
                        data_email['company_name'] = data['company_name']

                        # if data_user_info is not None:
                        #     data_email['company_code'] = data_user_info['company_code']
                        # else:
                        #     data_email['company_code'] = ''
                        data_email['company_code'] = data_t_mr['company_code']

                        data_email['last_name'] = data['last_name']
                        data_email['first_name'] = data['first_name']
                        data_email['affiliation_department'] = ''
                        data_email['email_address'] = data['email_address']
                        data_email['telephone_number'] = data['telephone_number']

                        data_email['status'] = data_t_mr['status']

                        data_email['mail_type'] = 'フリートライアル時、他に申込中のためエラー'

                        self.send_email_trial(data_email, is_append_to=False)
                        logger.debug('# ##############################')

                        return res

                    pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# ・上記以外：申込完了画面を表示する。本人認証へ進む。')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル【トライアル申込情報履歴】にデータ登録する':

                logger.debug('# テーブル【トライアル申込情報履歴】にデータ登録する')
                logger.debug('# t_trial_request_history')

                # from ..model.t_trial_request_history import Sub as TTRH
                # t_trh = TTRH()
                TTRH = GV.get_module('t_trial_request_history')
                t_trh = TTRH()

                tmp_t_trh = t_trh._add(data_t_trh)

                if tmp_t_trh:
                    logger.debug(tmp_t_trh)
                    pass
                else:
                    raise CustomException('SYS_ERR_100')
                    pass

            logger.debug('# ##############################')

            
            if is_not_request_user:

                data_tr = {}
                data_tr['auth0_user_id'] = auth0_user['user_id']
                data_tr['trial_req_id'] = tmp_t_trh.trial_req_id
                res = self.regist_trial_data(data_tr)

                pass

            elif GV.LOGGEDIN_USER:

                data_tr = {}
                data_tr['auth0_user_id'] = GV.LOGGEDIN_USER['sub']
                data_tr['trial_req_id'] = tmp_t_trh.trial_req_id
                res = self.regist_trial_data(data_tr)

                pass
            else:
                import uuid
                code = str(uuid.uuid4())

                logger.debug('# 認証コード生成')
                
                logger.debug('# ************0704******************') 
                code = 't-' + str(data_m_am['id']) + '-' + code
                logger.debug('# ************0704******************')

                # app_metadata = {
                #     'service_path': GV.SERVICE_PATH,
                #     'trial_req_id': tmp_t_trh.trial_req_id,
                #     'trial_req_vefification_code': code,
                #     'trial_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                # }
                
                if auth0_user is not None:
                    logger.debug('# Auth0アカウントがある場合')

                    # data_auth0 = {}
                    # data_auth0['app_metadata'] = app_metadata

                    # logger.debug('# data_auth0')
                    # logger.debug(data_auth0)

                    app_metadata = {}

                    if 'app_metadata' in auth0_user:

                        logger.debug(auth0_user['app_metadata'])

                        app_metadata = auth0_user['app_metadata']

                    if 'data' not in app_metadata:
                        app_metadata['data'] = []
                    
                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'trial_req_id': tmp_t_trh.trial_req_id,
                            'trial_req_vefification_code': code,
                            'trial_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )

                    data_auth0 = {}
                    data_auth0['app_metadata'] = app_metadata

                    logger.debug('# ******************************')
                    logger.debug('# atuh0 update')
                    a0._update(auth0_user['user_id'], data_auth0)
                    logger.debug('# ##############################')

                    pass
                else:
                    logger.debug('# Auth0アカウントがない場合')

                    app_metadata = {}
                    app_metadata['data'] = []
                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'trial_req_id': tmp_t_trh.trial_req_id,
                            'trial_req_vefification_code': code,
                            'trial_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )
                    
                    data_auth0 = {}
                    data_auth0['email_address'] = data['email_address']
                    data_auth0['app_metadata'] = app_metadata

                    logger.debug('# data_auth0')
                    logger.debug(data_auth0)

                    logger.debug('# ******************************')
                    logger.debug('# create_data_atuh0')
                    self.create_data_atuh0(data_auth0)
                    logger.debug('# ##############################')

                logger.debug('# ******************************')
                logger.debug('# トライアル申込完了連絡 メール送信')

                data_email = {}
                data_email['service_id'] = GV.SERVICE_ID
                data_email['mail_type'] = '本人認証とパスワード設定'
                data_email['email_address'] = data['email_address']
                data_email['company_name'] = data['company_name']
                data_email['last_name'] = data['last_name']
                data_email['first_name'] = data['first_name']
                data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                self.send_email_trial(data_email)
                
                logger.debug('# ##############################')

                pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
        pass

    def check_is_possible(self):
        try:
            res = {}

            logger.debug('# ******************************3')

            logger.debug('# 「トライアル環境ストックマスタ」からデータ取得')
            logger.debug('# m_trial_env_stock')

            params = {
                'table_name': 'm_trial_env_stock',
                'filters': {
                    'system_id': GV.SYSTEM_ID,
                    'service_id': GV.SERVICE_ID,
                    'use_flg': False
                }
            }
            tmp_m_tes = self.get_data(params, is_get_dict=False)

            if tmp_m_tes is None:
                logger.debug('# 「未使用」のデータがない場合')
                res = GV.INFO_CODE['TRIAL_I_BUSY']
                return res
                pass

            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}

    def regist_trial_data(self, data):
        try:
            logger.debug(data)
            res = {}

            logger.debug('# ******************************')

            data_t_trh = None

            if '# テーブル「トライアル申込履歴」からデータ取得':

                logger.debug('# テーブル「トライアル申込履歴」からデータ取得')
                logger.debug('# t_trial_request_history')

                params = {
                    'table_name': 't_trial_request_history',
                    'filters': {
                        'trial_req_id': data['trial_req_id']
                    }
                }
                data_t_trh = self.get_data(params)

                if data_t_trh is None:
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_tes = None

            if '# 「トライアル環境ストックマスタ」からデータ取得':

                logger.debug('# 「トライアル環境ストックマスタ」からデータ取得')
                logger.debug('# m_trial_env_stock')

                params = {
                    'table_name': 'm_trial_env_stock',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'use_flg': False
                    },
                    'order_by': {
                        'trial_user_id': 'asc'
                    }
                }
                tmp_m_tes = self.get_data(params, is_get_dict=False)

                if tmp_m_tes is None:
                    logger.debug('# 「未使用」のデータがない場合')

                    logger.debug('# ******************************')
                    logger.debug('# 申し込んだが空きユーザ無し フリートライアルの申込受付ができない メール送信')

                    data_email = {}
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['mail_type'] = 'フリートライアルの申込受付ができない'
                    data_email['email_address'] = data_t_trh['email_address']

                    data_email['company_name'] = data_t_trh['company_name']
                    data_email['last_name'] = data_t_trh['last_name']
                    data_email['first_name'] = data_t_trh['first_name']
                    data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                    self.send_email_trial(data_email)
                    
                    logger.debug('# ##############################')

                    # res = {}
                    # res = GV.INFO_CODE['TRIAL_I_BUSY']
                    # return res

                else:
                    logger.debug('# 「未使用」のデータがある場合')

                    data_m_tes = tmp_m_tes.to_dict()

                    logger.debug('# ******************************')
                    logger.debug('# 「使用フラグ」をTrueにする')
                    logger.debug('# use_flg')

                    # from ..model.m_trial_env_stock import Sub as MTES
                    # m_tes = MTES()
                    MTES = GV.get_module('m_trial_env_stock')
                    m_tes = MTES()
                    
                    data_m_tes['use_flg'] = True
                    m_tes._update(data_m_tes)
                    logger.debug('# ##############################')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_mr = None

            if '# テーブル「申込管理情報」にデータ登録':

                logger.debug('# テーブル「申込管理情報」にデータ登録')
                logger.debug('# t_manage_request')

                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                logger.debug('# 同じ「Auth0ユーザーID」のデータが登録されているかどうか確認')
                logger.debug('# 検索条件「システムID」、「サービスID」、「Auth0ユーザーID」')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

            logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # if '# テーブル「トライアル申込情報（確認済み）」からデータ検索':

            #     logger.debug('# テーブル「トライアル申込情報（確認済み）」からデータ検索')
            #     logger.debug('# t_trial_request_confirmed')

            #     params = {
            #         'table_name': 't_trial_request_confirmed',
            #         'filters': {
            #             'trial_req_id': data['trial_req_id']
            #         }
            #     }
            #     data_t_trc = self.get_data(params)

            #     if data_t_trc:
            #         logger.debug('# 存在する場合、なにもしない')
            #         return {}
            #         pass

            #     logger.debug('# 存在しない場合、履歴からのデータを登録')

            # logger.debug('# ##############################')

            data_t_trc = None

            param_t_trc = {}

            logger.debug('# 履歴のデータをコピー')
            param_t_trc = data_t_trh.copy()

            logger.debug('# ******************************')

            if '# テーブル「トライアル申込情報（確認済み）」からデータ登録':

                logger.debug('# テーブル「トライアル申込情報（確認済み）」からデータ登録')
                logger.debug('# t_trial_request_confirmed')

                logger.debug('# 「企業コード」をセットする')
                if data_t_mr is not None:
                    param_t_trc['company_code'] = data_t_mr['company_code']
                elif data_m_tes is not None:
                    param_t_trc['company_code'] = data_m_tes['trial_company_code']

                logger.debug('# 「トライアル環境ストックID」をセットする')
                if data_m_tes is not None:
                    param_t_trc['trial_env_stock_id'] = data_m_tes['trial_env_stock_id']

                logger.debug('# 「トライアル開始日」をセットする')
                param_t_trc['trial_start_date'] = self.NOW

                logger.debug('# 「トライアル終了日」をセットする')
                logger.debug('# ??? 24時間で確定？')
                param_t_trc['trial_end_date'] = self.NOW + timedelta(hours=24)

                # from ..model.t_trial_request_confirmed import Sub as TTRC
                # t_trc = TTRC()
                TTRC = GV.get_module('t_trial_request_confirmed')
                t_trc = TTRC()

                logger.debug('# データ登録')
                tmp_t_trc = t_trc._add(param_t_trc)

                if tmp_t_trc is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ登録失敗')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ登録成功')

                data_t_trc = tmp_t_trc.to_dict()
                logger.debug(data_t_trc)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】':

                logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】')
                logger.debug('# m_auth_user_info')

                # from ..model.m_auth0_user_info import Sub as MAUI
                # m_aui = MAUI()
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                param_m_aui = {}
                # # Auth0ユーザー情報管理ID
                # param_m_aui['auth_user_info_id'] = ''
                logger.debug('# **************0702****S************')
                # テナント
                param_m_aui['tenant'] = param_t_trc['tenant']
                logger.debug('# **************0702****E************')
                # Auth0ユーザーID
                param_m_aui['auth0_user_id'] = data['auth0_user_id']
                # ログイン先企業コード
                if data_m_tes is not None:
                    param_m_aui['company_code'] = data_m_tes['trial_company_code']
                # ログイン先システムID
                param_m_aui['system_id'] = GV.REQUEST_USER_SYSTEM_ID
                # ログイン先サービスID
                param_m_aui['service_id'] = GV.REQUEST_USER_SERVICE_ID

                logger.debug('# ワークショップ申し込みする際、metadataにはアプリ環境情報はセットしない。')
                # 付与ロールのリスト
                param_m_aui['roles'] = [GV.ROLES_REQUEST_USER]
                # # 作成日時
                # param_m_aui['cdate'] = ''
                # # 更新日時
                # param_m_aui['udate'] = ''

                params = {
                    'table_name': 'm_auth0_user_info',
                    'filters': {
                        'auth0_user_id': param_m_aui['auth0_user_id'],
                        'company_code': param_m_aui['company_code'],
                        'system_id': param_m_aui['system_id'],
                        'service_id': param_m_aui['service_id']
                    }
                }
                data_m_aui = self.get_data(params)
                logger.debug(data_m_aui)

                tmp_m_aui = None

                if data_m_aui:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                    param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                    tmp_m_aui = m_aui._update(param_m_aui)
                    pass
                else:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                    tmp_m_aui = m_aui._add(param_m_aui)
                    pass

                if tmp_m_aui is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ登録NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ登録OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_sys = None

            if '# テーブル「システムマスタ」からデータ取得':

                logger.debug('# テーブル「システムマスタ」からデータ取得')
                logger.debug('# m_systems')

                params = {
                    'table_name': 'm_systems',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }

                data_m_sys = self.get_data(params)

                if data_m_sys is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ取得NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ取得OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「Auth0ユーザー情報管理」にデータ登録':

                if data_m_tes is None:
                    logger.debug(
                        '# フリートライアル環境のユーザーの割り当てができていないので「フリートライアル用」のメタデータは登録しません。')
                    pass

                else:

                    logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録')
                    logger.debug('# m_auth_user_info')

                    # from ..model.m_auth0_user_info import Sub as MAUI
                    # m_aui = MAUI()
                    MAUI = GV.get_module('m_auth0_user_info')
                    m_aui = MAUI()

                    param_m_aui = {}
                    # # Auth0ユーザー情報管理ID
                    # param_m_aui['auth_user_info_id'] = ''
                    logger.debug('# **************0702****S************')
                    # テナント
                    param_m_aui['tenant'] = param_t_trc['tenant']
                    logger.debug('# **************0702****E************')
                    # Auth0ユーザーID
                    param_m_aui['auth0_user_id'] = data['auth0_user_id']
                    # ログイン先企業コード
                    param_m_aui['company_code'] = data_m_tes['trial_company_code']
                    # ログイン先システムID
                    param_m_aui['system_id'] = data_m_tes['system_id']
                    # ログイン先サービスID
                    param_m_aui['service_id'] = data_m_tes['service_id']
                    # activedirectory_username
                    # 000001.user001@simulation.space
                    tmp_adun = data_m_tes['trial_company_code']
                    tmp_adun += '.' + data_m_tes['trial_user_id']
                    tmp_adun += '@' + data_m_sys['ad_domain_name']
                    param_m_aui['activedirectory_username'] = tmp_adun
                    # appstream_stackname
                    # SYS00001-SRV00001-appstream-stack-activedirectory-000001
                    tmp_assn = data_m_tes['system_id'] + '-'
                    tmp_assn += data_m_tes['service_id'] + '-'
                    tmp_assn += 'appstream-stack-activedirectory' + '-'
                    tmp_assn += data_m_tes['trial_company_code']
                    param_m_aui['appstream_stackname'] = tmp_assn
                    # 付与ロールのリスト
                    param_m_aui['roles'] = [GV.ROLES_TRIAL_USER]
                    # # 作成日時
                    # param_m_aui['cdate'] = ''
                    # # 更新日時
                    # param_m_aui['udate'] = ''

                    params = {
                        'table_name': 'm_auth0_user_info',
                        'filters': {
                            'auth0_user_id': param_m_aui['auth0_user_id'],
                            'company_code': param_m_aui['company_code'],
                            'system_id': param_m_aui['system_id'],
                            'service_id': param_m_aui['service_id']
                        }
                    }
                    data_m_aui = self.get_data(params)
                    logger.debug(data_m_aui)

                    tmp_m_aui = None

                    if data_m_aui:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                        param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                        tmp_m_aui = m_aui._update(param_m_aui)
                        pass
                    else:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                        tmp_m_aui = m_aui._add(param_m_aui)
                        pass

                    if tmp_m_aui is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# データ登録NGの場合')
                        raise CustomException('SYS_ERR_100')

                    logger.debug('# データ登録OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録':

                logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                logger.debug('# m_user')

                params = {
                    'table_name': 'm_user',
                    'filters': {
                        'company_code': 'NONE',
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_m_u = self.get_data(params)

                if data_m_u is not None:
                    logger.debug('# 存在する場合、どうする？')

                    logger.debug('# データ更新')

                    MU = GV.get_module('m_user')
                    m_u = MU()

                    # 企業コード
                    data_m_u['company_code'] = data_m_tes['trial_company_code']
                    # 名前(姓)
                    data_m_u['name_last'] = data_t_trc['last_name']
                    # 名前(名)
                    data_m_u['name_first'] = data_t_trc['first_name']

                    tmp_m_u = m_u._update(data_m_u)

                    if tmp_m_u:
                        logger.debug(tmp_m_u.to_dict())
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録':

                if data_m_tes is None:
                    logger.debug(
                        '# フリートライアル環境のユーザーの割り当てができていないので「フリートライアル用」のメタデータは登録しません。')
                    pass

                else:

                    logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                    logger.debug('# m_user')

                    params = {
                        'table_name': 'm_user',
                        'filters': {
                            'auth0_user_id': data['auth0_user_id'],
                            'company_code': data_m_tes['trial_company_code']
                        }
                    }
                    data_m_u = self.get_data(params)

                    if data_m_u:
                        logger.debug('# 存在する場合、どうする？')
                        logger.debug('# ???')
                        pass
                    else:
                        logger.debug('# 存在しない場合、データを登録')

                        # from ..model.m_user import Sub as MU
                        # m_u = MU()
                        MU = GV.get_module('m_user')
                        m_u = MU()

                        param_m_u = {}
                        # Auth0ユーザーID
                        param_m_u['auth0_user_id'] = data['auth0_user_id']
                        # 企業コード
                        param_m_u['company_code'] = data_m_tes['trial_company_code']
                        # 名前
                        param_m_u['name_last'] = data_t_trc['last_name']
                        # 名前(姓)
                        param_m_u['name_first'] = data_t_trc['first_name']
                        # 名前(名)
                        param_m_u['name_last_kana'] = ''
                        # 名前(カナ)(姓)
                        param_m_u['name_first_kana'] = ''
                        # 部署名(カナ)(名)
                        param_m_u['department'] = ''
                        # 役職
                        param_m_u['position'] = ''
                        # メールアドレス
                        param_m_u['email'] = data_t_trc['email_address']
                        # # 電話番号
                        # param_m_u['tel'] = ''
                        # # 招待コード
                        # param_m_u['invitation_code'] = ''
                        # # 招待日時
                        # param_m_u['invitation_date'] = ''

                        logger.debug('# データ登録')
                        tmp_m_u = m_u._add(param_m_u)

                        if tmp_m_u:
                            logger.debug(tmp_m_u.to_dict())
                            pass
                        else:
                            raise CustomException('SYS_ERR_100')
                            pass

            logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # if '# テーブル「m_directory_user」にデータ登録':

            #     if data_m_tes is None:
            #         logger.debug(
            #             '# フリートライアル環境のユーザーの割り当てができていないので「フリートライアル用」のメタデータは登録しません。')
            #         pass

            #     else:

            #         logger.debug('# テーブル「m_directory_user」にデータ登録')
            #         logger.debug('# m_directory_user')

            #         params = {
            #             'table_name': 'm_directory_user',
            #             'filters': {
            #                 'company_code': data_m_tes['trial_company_code'],
            #                 'user_email': data_t_trc['email_address']
            #             }
            #         }
            #         data_m_u = self.get_data(params)

            #         if data_m_u:
            #             logger.debug('# 存在する場合、どうする？')
            #             logger.debug('# ???')
            #             pass
            #         else:
            #             logger.debug('# 存在しない場合、データを登録')

            #             # from ..model.m_directory_user import Sub as MDU
            #             # m_du = MDU()
            #             MDU = GV.get_module('m_directory_user')
            #             m_du = MDU()

            #             data_m_du_add = {}

            #             # company_code
            #             data_m_du_add['company_code'] = data_m_tes['trial_company_code']
            #             # directory_username
            #             data_m_du_add['directory_username'] = data_m_tes['trial_company_code'] + \
            #                 '.' + data_m_tes['trial_user_id']
            #             # user_email
            #             data_m_du_add['user_email'] = data_t_trc['email_address']

            #             logger.debug('# データ登録')
            #             tmp_m_du = m_du._add(data_m_du_add)

            #             if tmp_m_du:
            #                 logger.debug(tmp_m_du.to_dict())
            #                 pass
            #             else:
            #                 raise CustomException('SYS_ERR_100')
            #                 pass

            # logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「m_directory_user」にデータ登録':

                if data_m_tes is None:
                    logger.debug(
                        '# フリートライアル環境のユーザーの割り当てができていないので「フリートライアル用」のメタデータは登録しません。')
                    pass

                else:

                    logger.debug('# テーブル「m_directory_user」にデータ登録')
                    logger.debug('# m_directory_user')

                    logger.debug('# フリートライアルユーザ割り振り時に「トライアル企業コード+"."+トライアルユーザID」で')
                    logger.debug('# mscone_lic.m_directory_userのdirectory.user_nameで検索して、')
                    logger.debug('# Hitしたらuser_emailにメールアドレスを設定してください。')
                    logger.debug('# フリートライアル終了時は同じ条件で検索してuser_emailをNULLにしてください')
                    
                    params = {
                        'table_name': 'm_directory_user',
                        'filters': {
                            'company_code': data_m_tes['trial_company_code'],
                            'directory_username': data_m_tes['trial_company_code'] + '.' + data_m_tes['trial_user_id'],
                            'user_email': 'NONE'
                        },
                        'order_by': {
                            'directory_username': 'asc'
                        }
                    }
                    data_m_u = self.get_data(params)

                    if data_m_u is not None:
                        logger.debug('# 存在する場合、どうする？')
  
                        logger.debug('# 存在しない場合、データを更新')

                        MDU = GV.get_module('m_directory_user')
                        m_du = MDU()

                        data_m_u['user_email'] = data_t_trc['email_address']

                        logger.debug('# データ登録')
                        tmp_m_du = m_du._update(data_m_u)

                        if tmp_m_du is not None:
                            logger.debug(tmp_m_du.to_dict())
                            pass
                        else:
                            raise CustomException('SYS_ERR_100')
                            pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「申込管理情報」にデータ登録':

                logger.debug('# テーブル「申込管理情報」にデータ登録')
                logger.debug('# t_manage_request')

                # from ..model.t_manage_request import Sub as TMR
                # t_mr = TMR()
                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                logger.debug('# 同じ「Auth0ユーザーID」のデータが登録されているかどうか確認')
                logger.debug('# 検索条件「システムID」、「サービスID」、「Auth0ユーザーID」')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr:
                    logger.debug('# 存在する場合、どうする？')
                    logger.debug('# ???')

                    # トライアル申込ID
                    data_t_mr['trial_req_id'] = data['trial_req_id']
                    # # 企業コード
                    # if data_m_tes is not None:
                    #     data_t_mr['company_code'] = data_m_tes['trial_company_code']
                    # ステータス
                    if data_m_tes is not None:
                        data_t_mr['status'] = GV.STATUS['フリートライアル利用中']
                    else:
                        data_t_mr['status'] = GV.STATUS['フリートライアルキャンセル']

                    logger.debug('# データ更新')
                    tmp_t_mr_1 = t_mr._update(data_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

                    pass
                else:
                    logger.debug('# 存在しない場合、データを登録')

                    param_t_mr = {}
                    # # 申込管理ID
                    # param_t_mr['manage_req_id'] =
                    # 企業コード
                    if data_m_tes is not None:
                        param_t_mr['company_code'] = data_m_tes['trial_company_code']
                    # システムID
                    param_t_mr['system_id'] = GV.SYSTEM_ID
                    # サービスID
                    param_t_mr['service_id'] = GV.SERVICE_ID
                    # # 契約ID
                    # param_t_mr['contract_id'] =
                    # Auth0ユーザーID
                    param_t_mr['auth0_user_id'] = data['auth0_user_id']
                    # # 資料請求ID
                    # param_t_mr['document_req_id'] =
                    # # トライアル環境ストックID
                    # param_t_mr['trial_env_stock_id'] = trial_env_stock_id
                    # トライアル申込ID
                    param_t_mr['trial_req_id'] = data['trial_req_id']
                    # # ワークショップ申込ID
                    # param_t_mr['workshop_req_id'] =
                    # # 本契約申込ID
                    # param_t_mr['contract_req_id'] =
                    # # 担当営業コード
                    # param_t_mr['salesman_code'] =
                    if data_m_tes is not None:
                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                        param_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                        # ステータス
                        param_t_mr['status'] = GV.STATUS['フリートライアル利用中']
                    else:
                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                        param_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                        # ステータス
                        param_t_mr['status'] = GV.STATUS['フリートライアルキャンセル']
                    # # 作成日時
                    # param_t_mr['cdate'] =
                    # # 更新日時
                    # param_t_mr['udate'] =

                    logger.debug('# データ登録')
                    tmp_t_mr_1 = t_mr._add(param_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# 申込成功 フリートライアル申込受付 メール送信')

            data_email = {}
            data_email['service_id'] = GV.SERVICE_ID
            data_email['mail_type'] = 'フリートライアル申込受付'
            data_email['email_address'] = data_t_trc['email_address']
            data_email['company_name'] = data_t_trc['company_name']
            data_email['last_name'] = data_t_trc['last_name']
            data_email['first_name'] = data_t_trc['first_name']
            data_email['login_url'] = GV.URL_LOGIN_SIMSP

            self.send_email_trial(data_email)

            pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {
            'statusCode': 200,
            'body': 'OK'
        }
        pass

    def send_email_trial(self, data, is_append_to=True):
        logger.debug('# ******************************')
        logger.debug('# send_email_trial')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if is_append_to == True:
                if 'email_address' in data:
                    mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id']) 
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}
            
            # ???
            result = self.send_email(mail_template, mail_parameter)
           
            return result

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')

    def terminate_trial(self):
        logger.debug('# terminate_trial')
        try:

            logger.debug('# ******************************')
            logger.debug('# テーブル「トライアル申込情報（確認済み）」からデータ検索')
            logger.debug('''# 定期実行処理でフリートライアルの期間が過ぎているかチェックを行い、処理する''')
            logger.debug('# 「trial_start_date」から24時間超えたデータを検索する')

            TTRC = GV.get_module('t_trial_request_confirmed')
            t_trc = TTRC()

            VT = GV.get_module('view_trial')
            v_t = VT()

            filters = []
            filters.append(v_t.model_class.trial_env_stock_id.is_not(None))
            filters.append(v_t.model_class.trial_start_date <
                           datetime.now() + timedelta(hours=-24))
            # filters.append(v_t.model_class.trial_start_date >
            #                datetime.now() + timedelta(hours=-2))
            filters = and_(*filters)

            tmp_v_t = v_t._get_item_by_filters(filters, get_all=True)

            if tmp_v_t is None:
                logger.debug('# 存在しない場合、なにもしない')
                return {}
                pass

            logger.debug('''# トライアル環境のユーザの割り当ての解除。
                            お客様のAuth0アカウントのメタデータを更新してトライアル環境を利用不可能にする。
                            アプリ側のユーザ環境の初期化依頼メール送信。
                            フリートライアルの終了日を設定。''')

            # from ..model.m_auth0_user_info import Sub as MAUI
            # m_aui = MAUI()
            MAUI = GV.get_module('m_auth0_user_info')
            m_aui = MAUI()

            for t in tmp_v_t:
                d = t.to_dict()
                logger.debug(d)

                logger.debug('# ******************************')

                logger.debug('# トライアル環境のユーザの割り当ての解除。')

                # ???
                # 具体的にどう解除

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# お客様のAuth0アカウントのメタデータを更新してトライアル環境を利用不可能にする。')

                filters = []
                filters.append(m_aui.model_class.system_id == d['system_id'])
                filters.append(m_aui.model_class.service_id == d['service_id'])
                filters.append(m_aui.model_class.company_code ==
                               d['company_code'])
                filters.append(m_aui.model_class.auth0_user_id ==
                               d['email_address'])
                filters.append(
                    m_aui.model_class.roles.contains(GV.ROLES_TRIAL_USER))
                filters = and_(*filters)

                tmp_m_aui = m_aui._get_item_by_filters(filters, get_all=True)

                if tmp_m_aui is None:
                    logger.debug('# 存在しない場合、なにもしない')
                    pass

                for t1 in tmp_m_aui:
                    d1 = t1.to_dict()

                    logger.debug('# ************0731******************') 
                    params = {
                        'table_name': 'm_auth0_management',
                        'filters': {
                            'tenant': d1["tenant"]
                        }
                    }
                    data_m_am = self.get_data(params)
                    logger.debug(data_m_am)
        
                    if data_m_am:
                        logger.debug('# ************Auth0情報を設定する******************')
                        GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                        GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                        GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                        GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                        GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                        GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                        logger.debug(GV.CONFIG)
                        pass
                    else:
                        return {"error": "tenant:" + GV.EVENT_BODY["tenant"] + " は存在しないので、システム者にご連絡ください。"}
                    logger.debug('# ************0731******************') 

                    logger.debug('# 削除する')
                    logger.debug('# Auth0のmetadataを更新する')
                    tmp1 = m_aui._delete(d1)
                    logger.debug(tmp1)

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                trial_env_stock_id = d['trial_env_stock_id']

                if '# テーブル「申込管理情報」からデータ検索':

                    logger.debug('# テーブル「申込管理情報」からデータ検索')
                    logger.debug('# t_manage_request')

                    params = {
                        'table_name': 't_manage_request',
                        'filters': {
                            'system_id': d['system_id'],
                            'service_id': d['service_id'],
                            'auth0_user_id': d['email_address'],
                            'trial_req_id': d['trial_req_id']
                        }
                    }
                    data_t_mr = self.get_data(params)

                    if data_t_mr is not None:
                        if data_t_mr['status'] == GV.STATUS['フリートライアル利用中']:

                            data_t_mr['status'] = GV.STATUS['フリートライアル終了']

                            # from ..model.t_manage_request import Sub as TMR
                            # t_mr = TMR()
                            TMR = GV.get_module('t_manage_request')
                            t_mr = TMR()

                            # システム利用可能フラグ
                            logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                            data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                            
                            tmp_t_mr = t_mr._update(data_t_mr)

                            if tmp_t_mr:
                                data_t_mr = tmp_t_mr.to_dict()
                                logger.debug(data_t_mr)
                                pass

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# フリートライアルの終了日を設定。')
                d['trial_end_date'] = datetime.now()

                logger.debug('# トライアル環境ストックIDを空欄にする(ユーザ割り当てを解除)')
                d['trial_env_stock_id'] = None

                t_trc._update(d)

                logger.debug('# ##############################')

                # logger.debug('# ******************************')

                # logger.debug('# ※通常ユーザー削除と同様の処理も必要？m_directory_userの更新など。')

                # # from ..model.m_user import Sub as MU
                # # m_u = MU()
                # MU = GV.get_module('m_user')
                # m_u = MU()

                # filters = []
                # filters.append(m_u.model_class.company_code ==
                #                d['company_code'])
                # filters.append(m_u.model_class.auth0_user_id ==
                #                d['email_address'])
                # filters = and_(*filters)

                # tmp_m_u = m_u._get_item_by_filters(filters, get_all=True)

                # if tmp_m_u is None:
                #     logger.debug('# 存在しない場合、なにもしない')
                #     pass

                # for t1 in tmp_m_u:
                #     d1 = t1.to_dict()

                #     logger.debug('# 削除する')
                #     tmp1 = m_u._delete(d1)
                #     logger.debug(tmp1)

                # logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# ※通常ユーザー削除と同様の処理も必要？m_directory_userの更新など。')

                # from ..model.m_user import Sub as MU
                # m_u = MU()
                MU = GV.get_module('m_user')
                m_u = MU()

                filters = []
                filters.append(m_u.model_class.company_code ==
                               d['company_code'])
                filters.append(m_u.model_class.auth0_user_id ==
                               d['email_address'])
                filters = and_(*filters)

                tmp_m_u = m_u._get_item_by_filters(filters)

                if tmp_m_u is None:
                    logger.debug('# 存在しない場合、なにもしない')
                    pass

                if tmp_m_u is not None:
                    data_m_u = tmp_m_u.to_dict()

                    data_m_u['company_code'] = None

                    logger.debug('# 更新する')
                    tmp_m_u_update = m_u._update(data_m_u)

                    logger.debug(tmp_m_u_update)

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# ※通常ユーザー削除と同様の処理も必要？m_directory_userの更新など。')

                # from ..model.m_directory_user import Sub as MDU
                # m_du = MDU()
                MDU = GV.get_module('m_directory_user')
                m_du = MDU()

                filters = []
                filters.append(m_du.model_class.company_code ==
                               d['company_code'])
                filters.append(m_du.model_class.user_email ==
                               d['email_address'])
                filters.append(m_du.model_class.directory_username ==
                               d['trial_company_code'] + '.' + d['trial_user_id'])
                filters = and_(*filters)

                tmp_m_du = m_du._get_item_by_filters(filters, get_all=True)

                if tmp_m_du is None:
                    logger.debug('# 存在しない場合、なにもしない')
                    pass

                for t1 in tmp_m_du:
                    d1 = t1.to_dict()
                    logger.debug('d1')
                    logger.debug(d1)

                    # logger.debug('# 削除する')
                    # tmp1 = m_du._delete(d1)
                    # logger.debug(tmp1)

                    d1['user_email'] = None
                    
                    m_du._update(d1)

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# アプリ側のユーザ環境の初期化依頼メール送信。')

                data_email = {}
                data_email['service_id'] = d['service_id']
                data_email['mail_type'] = 'フリートライアル後の初期化依頼'

                data_email['trial_env_stock_id'] = trial_env_stock_id
                data_email['trial_company_code'] = d['trial_company_code']
                data_email['trial_user_id'] = d['trial_user_id']
                data_email['system_id'] = d['system_id']
                data_email['service_id'] = d['service_id']
                data_email['system_name'] = d['system_name']
                data_email['service_name'] = d['service_name']

                self.send_email_trial(data_email)
        
                logger.debug('# ##############################')

                logger.debug('''# サポートが手動でユーザ環境の初期化をする。
                             終了後にユーザ管理サイトで初期化フラグをtrueにする。''')

            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
        pass
