from .controller import Base, CustomException, GV, logging

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'services'

    def get_all(self, event, context):

        # from ..view.view_services import Sub as VSRV
        # v_srv = VSRV()
        VSRV = GV.get_module('view_services')
        v_srv = VSRV()

        return v_srv.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_services import Sub as VSRV
        # v_srv = VSRV()
        VSRV = GV.get_module('view_services')
        v_srv = VSRV()

        v_srv.table_config = self.table_name
        return v_srv.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        
        strType = 0
        if data['system_configuration_type'] is not None:
            if data['system_configuration_type'] == 'クライアント/サーバ型（Windows版）':
                strType = 0
            elif data['system_configuration_type'] == 'クライアント/サーバ型（RHEL版）':
                strType = 1
            elif data['system_configuration_type'] == 'ソルバー型':
                strType = 2
            elif data['system_configuration_type'] == 'スタンドアローン型':
                strType = 3
            data['system_configuration_type'] = strType

        # from ..model.m_services import Sub as MSRV
        # m_srv = MSRV()
        MSRV = GV.get_module('m_services')
        m_srv = MSRV()
        
        tmp_m_srv = m_srv._add(data)

        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        
        strType = 0
        if data['system_configuration_type'] is not None:
            if data['system_configuration_type'] == 'クライアント/サーバ型（Windows版）':
                strType = 0
            elif data['system_configuration_type'] == 'クライアント/サーバ型（RHEL版）':
                strType = 1
            elif data['system_configuration_type'] == 'ソルバー型':
                strType = 2
            elif data['system_configuration_type'] == 'スタンドアローン型':
                strType = 3
            data['system_configuration_type'] = strType

        # from ..model.m_services import Sub as MSRV
        # m_srv = MSRV()
        MSRV = GV.get_module('m_services')
        m_srv = MSRV()

        tmp_m_srv = m_srv._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_services import Sub as MSRV
        # m_srv = MSRV()
        MSRV = GV.get_module('m_services')
        m_srv = MSRV()

        tmp_m_srv = m_srv._delete(data)

        return {}