from .controller import Base, CustomException, GV, logging, and_

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'auth0_user_info'

    def get_all(self, event, context):

        # from ..view.view_auth0_user_info import Sub as VAUI
        # v_aui = VAUI()
        VAUI = GV.get_module('view_auth0_user_info')
        v_aui = VAUI()

        return v_aui.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_auth0_user_info import Sub as VAUI
        # v_aui = VAUI()
        VAUI = GV.get_module('view_auth0_user_info')
        v_aui = VAUI()

        v_aui.table_config = self.table_name
        return v_aui.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        
        logger.debug('# ************0806******************')
        strTenant = None
        logger.debug(data)
        strTenant = data['tenant']
        logger.debug(strTenant)
        logger.debug('err')
        
        MAM = GV.get_module('m_auth0_management')
        m_am = MAM()
        
        if strTenant is not None:

            logger.debug('# 検索条件')
            filters = []
            filters.append(m_am.model_class.tenant ==
                           strTenant)
            filters = and_(*filters)

            tmp_m_am = m_am._get_item_by_filters(filters)
            
            if tmp_m_am is None:
                raise CustomException('SYS_ERR_100')
                pass

            data_m_am = tmp_m_am.to_dict()

            logger.debug(data_m_am)
                        
            if data_m_am:
                logger.debug('# ************Auth0情報を設定する******************')
                GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                logger.debug(GV.CONFIG)
                pass
            else:
                return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0806******************') 

        # from ..model.m_auth0_user_info import Sub as MAUI
        # m_aui = MAUI()
        MAUI = GV.get_module('m_auth0_user_info')
        m_aui = MAUI()

        tmp_m_aui = m_aui._add(data)

        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        
        logger.debug('# ************0806******************')
        strTenant = None
        # logger.debug(data)
        strTenant = data['tenant']
        # logger.debug(strTenant)
        # logger.debug('err')
        
        MAM = GV.get_module('m_auth0_management')
        m_am = MAM()
        
        if strTenant is not None:

            logger.debug('# 検索条件')
            filters = []
            filters.append(m_am.model_class.tenant ==
                           strTenant)
            filters = and_(*filters)

            tmp_m_am = m_am._get_item_by_filters(filters)
            
            if tmp_m_am is None:
                raise CustomException('SYS_ERR_100')
                pass

            data_m_am = tmp_m_am.to_dict()

            logger.debug(data_m_am)
                        
            if data_m_am:
                logger.debug('# ************Auth0情報を設定する******************')
                GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                logger.debug(GV.CONFIG)
                pass
            else:
                return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0806******************') 

        # from ..model.m_auth0_user_info import Sub as MAUI
        # m_aui = MAUI()
        MAUI = GV.get_module('m_auth0_user_info')
        m_aui = MAUI()

        tmp_m_aui = m_aui._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        
        logger.debug('# ************0806******************')
        strTenant = None
        # logger.debug(data)
        strTenant = data['tenant']
        # logger.debug(strTenant)
        # logger.debug('err')
        
        MAM = GV.get_module('m_auth0_management')
        m_am = MAM()
        
        if strTenant is not None:

            logger.debug('# 検索条件')
            filters = []
            filters.append(m_am.model_class.tenant ==
                           strTenant)
            filters = and_(*filters)

            tmp_m_am = m_am._get_item_by_filters(filters)
            
            if tmp_m_am is None:
                raise CustomException('SYS_ERR_100')
                pass

            data_m_am = tmp_m_am.to_dict()

            logger.debug(data_m_am)
                        
            if data_m_am:
                logger.debug('# ************Auth0情報を設定する******************')
                GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                logger.debug(GV.CONFIG)
                pass
            else:
                return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0806******************') 

        # from ..model.m_auth0_user_info import Sub as MAUI
        # m_aui = MAUI()
        MAUI = GV.get_module('m_auth0_user_info')
        m_aui = MAUI()

        tmp_m_aui = m_aui._delete(data)

        return {}