DEV_ENV = 'prod'

from decimal import Decimal
from datetime import datetime
from sqlalchemy.orm.exc import NoResultFound
from sqlalchemy.orm import sessionmaker, declarative_base
from sqlalchemy.dialects.postgresql import TIMESTAMP
from sqlalchemy.dialects import postgresql
from sqlalchemy import VARCHAR, INTEGER, DATE, DATETIME, BOOLEAN, TEXT, NUMERIC
from sqlalchemy.dialects.postgresql import JSONB
from sqlalchemy import String, Integer, Date, DateTime
from sqlalchemy import create_engine, inspect, or_, and_, cast, desc, asc
import json
import os

# 必要なモジュールをインポートする


if DEV_ENV == 'local':
    from .lambda_function import DEV_ENV, GV, CustomException, boto3, logging
else:
    from lambda_function import DEV_ENV, GV, CustomException, boto3, logging

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)


class DecimalEncoder(json.JSONEncoder):
    # logger.debug('-----DecimalEncoder-----')
    def default(self, o):
        if isinstance(o, Decimal):
            return float(o)
        return super(DecimalEncoder, self).default(o)

# データベースからテーブルをモデルとして作成する関数


def create_model_from_table(base, database, schema, table_name,  engine=None, is_view=None, primary_key_columns=None):

    insp = None

    if engine is not None:
        # logger.debug('-----engine-----')
        base.metadata.reflect(bind=engine, views=True)

        # # logger.debug('# ************************************')
        # inspector初期化
        insp = inspect(engine)
        # # logger.debug('# ************************************')

    class Model(base):
        # logger.debug('-----base-----')
        __table__ = base.metadata.tables[table_name]
        __table_args__ = {'schema': schema}

        columns = {}

        # Viewnの場合
        if is_view:
            if primary_key_columns is not None and len(primary_key_columns) > 0:
                keys = []

                for key in primary_key_columns:
                    keys.append(__table__.c[key])

                __mapper_args__ = {
                    'primary_key': keys
                }

        # モデルを辞書に変換するメソッド
        def to_dict(self):
            result = {}
            for c in self.__table__.columns:
                value = getattr(self, c.name)
                if isinstance(value, datetime):
                    value = value.isoformat()
                result[c.name] = value
            return result

    return Model


# 基底クラス
class Base:
    model_class = None
    database = None
    table_name = None
    schema = None
    primary_key_columns = []
    search_columns = []
    exclude_search_columns = []
    is_view = False

    table_config = None

    NOW = datetime.now()

    DecBase = None

    engine = None

    def __init__(self, event=None, context=None):
        # # logger.debug('__init__')
        # logger.debug('データベースに接続する')

        logger.debug('*************************')
        logger.debug('table_name')
        logger.debug(self.table_name)
        logger.debug('*************************')

        # データベースに接続する

        self.DecBase = declarative_base()

        if DEV_ENV == 'local':

            # # self.database = 'postgres'
            # self.engine = create_engine(
            #     f'postgresql+psycopg2://postgres:postgresql@localhost/{self.database}?options=-csearch_path%3D{self.schema}')

            url = 'postgresql+psycopg2://'
            url += GV.CONFIG_COMN_PF['DATABASE_USERNAME']
            url += ':'
            url += GV.CONFIG_COMN_PF['DATABASE_PASSWORD']
            url += '@'
            url += GV.CONFIG_COMN_PF['DATABASE_HOST']
            url += ':'
            url += GV.CONFIG_COMN_PF['DATABASE_PORT']
            url += '/'
            url += self.database
            url += '?'
            url += 'options=-csearch_path%3D'
            url += self.schema
            logger.debug(url)

            self.engine = create_engine(url)
        else:

            url = ''

            if self.database == 'mscone_lic':
                #     url = 'postgresql+psycopg2://'
                #     url += GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME']
                #     url += ':'
                #     url += GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD']
                #     url += '@'
                #     url += GV.CONFIG_MSCONE_LIC['DATABASE_HOST']
                #     url += '/'
                #     url += self.database
                #     url += '?'
                #     url += 'options=-csearch_path%3D'
                #     url += self.schema
                # url = f'postgresql+psycopg2://postgres:postgresql@dev-rds-sim-001.cluster-cfhdc00wr5rm.ap-northeast-1.rds.amazonaws.com/{self.database}?options=-csearch_path%3D{self.schema}'

                url = 'postgresql+psycopg2://'
                url += GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME']
                url += ':'
                url += GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD']
                url += '@'
                url += GV.CONFIG_MSCONE_LIC['DATABASE_HOST']
                url += ':'
                url += GV.CONFIG_MSCONE_LIC['DATABASE_PORT']
                url += '/'
                # url += self.database
                url += GV.DB_MSCONE_LIC
                url += '?'
                url += 'options=-csearch_path%3D'
                url += self.schema

                pass
            elif self.database == 'gradehull':

                url = 'postgresql+psycopg2://'
                url += GV.CONFIG_GRADEHULL['DATABASE_USERNAME']
                url += ':'
                url += GV.CONFIG_GRADEHULL['DATABASE_PASSWORD']
                url += '@'
                url += GV.CONFIG_GRADEHULL['DATABASE_HOST']
                url += ':'
                url += GV.CONFIG_GRADEHULL['DATABASE_PORT']
                url += '/'
                url += GV.DB_GRADEHULL
                url += '?'
                url += 'options=-csearch_path%3D'
                url += self.schema

                pass
            elif self.database == 'beagle':

                url = 'postgresql+psycopg2://'
                url += GV.CONFIG_BEAGLE['DATABASE_USERNAME']
                url += ':'
                url += GV.CONFIG_BEAGLE['DATABASE_PASSWORD']
                url += '@'
                url += GV.CONFIG_BEAGLE['DATABASE_HOST']
                url += ':'
                url += GV.CONFIG_BEAGLE['DATABASE_PORT']
                url += '/'
                url += GV.DB_BEAGLE
                url += '?'
                url += 'options=-csearch_path%3D'
                url += self.schema

                pass
            else:
                #     url = 'postgresql+psycopg2://'
                #     url += GV.CONFIG_COMN_PF['DATABASE_USERNAME']
                #     url += ':'
                #     url += GV.CONFIG_COMN_PF['DATABASE_PASSWORD']
                #     url += '@'
                #     url += GV.CONFIG_COMN_PF['DATABASE_HOST']
                #     url += '/'
                #     url += self.database
                #     url += '?'
                #     url += 'options=-csearch_path%3D'
                #     url += self.schema
                # url = f'postgresql+psycopg2://postgres:postgresql@dev-rds-comn-pf-001-instance-1.cfhdc00wr5rm.ap-northeast-1.rds.amazonaws.com/{self.database}?options=-csearch_path%3D{self.schema}'

                url = 'postgresql+psycopg2://'
                url += GV.CONFIG_COMN_PF['DATABASE_USERNAME']
                url += ':'
                url += GV.CONFIG_COMN_PF['DATABASE_PASSWORD']
                url += '@'
                url += GV.CONFIG_COMN_PF['DATABASE_HOST']
                url += ':'
                url += GV.CONFIG_COMN_PF['DATABASE_PORT']
                url += '/'
                # url += self.database
                url += GV.DB_COMN_PF
                url += '?'
                url += 'options=-csearch_path%3D'
                url += self.schema

                pass

            self.engine = create_engine(url)

        # Session = sessionmaker(bind=engine)
        Session = sessionmaker(bind=self.engine, expire_on_commit=False)

        self.session = Session()
        logger.debug('create session')
        # モデルクラスを作成する
        self.model_class = create_model_from_table(
            self.DecBase, self.database, self.schema, self.table_name, self.engine, self.is_view, self.primary_key_columns)

        self.search_columns = [
            column
            for column in self.model_class.__table__.columns
            if column.name not in self.exclude_search_columns
        ]

    def close_session(self):
        # セッションを閉じる
        self.session.close()

    def before_get_all(self, query_string_parameters):
        # デフォルトは何もしない
        pass

    def after_get_all(self, items):
        # デフォルトは何もしない
        pass

    def before_respose(self, items):
        # デフォルトは何もしない
        pass

    # 全てのアイテムを取得するメソッド
    def get_all(self, event, context):
        # logger.debug('get_all >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')

        self.before_get_all(GV.QUERY_STRING_PARAMETERS)

        # ページ番号を指定
        page = GV.QUERY_STRING_PARAMETERS['page']
        page = int(page)

        # リミットを指定
        rowsPerPage = GV.QUERY_STRING_PARAMETERS['rowsPerPage']
        rowsPerPage = int(rowsPerPage)

        # 検索キーワードを指定
        searchKeyword = GV.QUERY_STRING_PARAMETERS['searchKeyword']

        filtersStr = GV.QUERY_STRING_PARAMETERS['filters']

        filters = json.loads(filtersStr)

        sortBy = ''
        if 'sortBy' in GV.QUERY_STRING_PARAMETERS:
            sortBy = GV.QUERY_STRING_PARAMETERS['sortBy']

        descending = GV.QUERY_STRING_PARAMETERS['descending']

        if descending == 'true':
            descending = True
        else:
            descending = False

        # オフセットを計算
        offset = (page - 1) * rowsPerPage

        # モデルクラスを取得するクエリを作成
        query = self.session.query(self.model_class)

        and_conditions = []

        # もし検索キーワードが指定されていた場合
        or_conditions = []
        if searchKeyword:
            # 検索するカラムを指定
            for column in self.search_columns:
                if hasattr(column.type, 'python_type') and issubclass(column.type.python_type, datetime):
                    or_conditions.append(
                        cast(column, String).contains(searchKeyword))
                # 文字列型のカラムの場合、containsメソッドを適用
                elif isinstance(column.type, (String,)):
                    or_conditions.append(column.contains(searchKeyword))
                # 整数型のカラムの場合、検索値を整数に変換して等しいかどうかを調べる
                elif isinstance(column.type, (Integer,)):
                    try:
                        search_value = int(searchKeyword)
                        or_conditions.append(column == search_value)
                    # 検索値が整数に変換できない場合はスキップ
                    except ValueError:
                        pass
            # # 検索条件を設定
            # query = query.filter(or_(*or_conditions))

        # カラムごとに検索条件を指定する検索条件を作成
        for column_name, value in filters.items():
            column = getattr(self.model_class, column_name, None)
            if column is not None and isinstance(column.type, (String,)):
                if value is None:
                    result = {
                        'data': [],
                        'pagination': {
                            'rowsNumber': 0,
                            'rowsPerPage': rowsPerPage,
                            'page': page,
                            'totalPages': 0,
                            'sortBy': sortBy,
                            'descending': descending,
                        }
                    }
                    return result
                    pass
                elif type(value) == list:
                    if len(value) > 0:
                        and_conditions.append(column.in_(value))
                    pass
                else:
                    # query = query.filter(column.contains(value))
                    and_conditions.append(column.contains(value))
                    pass
            elif column is not None and isinstance(column.type, (Integer,)):
                try:
                    value_int = int(value)
                    # query = query.filter(column == value_int)
                    and_conditions.append(column == value_int)
                except ValueError:
                    pass

        # filters = []
        # filters = and_(*and_conditions)
        # filters = or_(*or_conditions)
        # query = query.filter(filters)
        # --> 共通PF4 サプライヤーの場合、システム名を持っているロールでフィルタ 2024/02/08 nakamura.e
        if GV.LOGGEDIN_USER_IS_SUPPLIER == True:
            if self.table_name == 'view_staff_supplier':
                if GV.SYSTEM_NAME is not None:
                    roles = getattr(self.model_class, 'roles', None)
                    if roles is not None:
                        and_conditions.append(roles.contains('"' + GV.SYSTEM_NAME.lower() + '_'))

        # <-- 共通PF4 サプライヤーの場合、システム名を持っているロールでフィルタ 2024/02/08 nakamura.e

        filters = []
        filters.append(and_(*and_conditions))
        filters.append(or_(*or_conditions))

        logger.debug('# ******************************')
        logger.debug('# ユーザー管理サイトの場合、選択したシステムIDでフィルターする')
        logger.debug('# 対象外のテーブルもある')

        # --> 共通PF4 システムIDでフィルタ 2024/02/05 nakamura.e
        # 対象外
        not_applicable_table = [
#                               'm_systems', 
                                'm_auth0_user_info',
                                'view_auth0_user_info', 
#                               'm_file_manage', 
#                               'view_file_manage', 
                                'view_systems', 
#                               'view_services',
#                               'm_regular_products',
                                'view_notice']
        # <-- 共通PF4 システムIDでフィルタ 2024/02/05 nakamura.e

        # 対象外に含まれない場合はシステムIDでフィルタ
        logger.debug(f'システムIDをフィルタに追加するか判定:{GV.SYSTEM_ID},{self.table_name}')
        if self.table_name not in not_applicable_table:
            if GV.SYSTEM_ID is not None:
                system_id = getattr(self.model_class, 'system_id', None)
                if system_id is not None:
                    filters.append(system_id == GV.SYSTEM_ID)
                    logger.debug(f'システムIDをフィルタに追加:{GV.SYSTEM_ID}')
        logger.debug('# ##############################')

        filters = and_(*filters)
        query = query.filter(filters)

        logger.debug('# ******************************')
        logger.debug('# ユーザー管理サイトの場合、ログインスタッフのロールを判定')
        logger.debug('# admin_staffの場合制限なし')

        # 対象テーブルの場合、システムマスタをJOIN
        applicable_table = ['view_contract', 'view_workshop', 'view_trial', 'view_ma_contract']
        if self.table_name in applicable_table:
            if GV.LOGGEDIN_USER_IS_ADMIN == True:
                pass
            else:
                if GV.LOGGEDIN_USER is not None and \
                        'sub' in GV.LOGGEDIN_USER:

                    logger.debug('# ******************************')
                    logger.debug('# システムマスタを JOIN する')

                    tn1 = 'view_systems'

                    VSYS = GV.get_module(tn1)
                    v_sys = VSYS()
                    query = query.join(
                        v_sys.model_class, v_sys.model_class.system_id == self.model_class.system_id)

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')
                    logger.debug('# m_auth0_user_infoを LEFT JOIN する')

                    tn2 = 'm_auth0_user_info'

                    MAUI = GV.get_module(tn2)
                    m_aui = MAUI()
                    # query = query.join(m_aui.model_class, and_(m_aui.model_class.system_id == self.model_class.system_id,
                    #                                            m_aui.model_class.service_id == self.model_class.service_id,
                    #                                            m_aui.model_class.company_code == self.model_class.company_code,
                    #                                            or_(
                    #                                                m_aui.model_class.roles.like(
                    #                                                    '%' + v_sys.model_class.sub_domain_name + '_sales' + '%'),
                    #                                                m_aui.model_class.roles.like(
                    #                                                    '%' + v_sys.model_class.sub_domain_name + '_support' + '%')
                    #                                            )))
                    query = query.join(m_aui.model_class, and_(and_(m_aui.model_class.auth0_user_id == GV.LOGGEDIN_USER['sub']),
                                                               or_(
                                                                   m_aui.model_class.roles.like(
                                                                       '%' + v_sys.model_class.sub_domain_name + '_sales' + '%'),
                                                                   m_aui.model_class.roles.like(
                                                                       '%' + v_sys.model_class.sub_domain_name + '_support' + '%')
                                                               )))
                    

                    logger.debug('# ##############################')

        logger.debug('# ##############################')

        if sortBy:

            sort_column = getattr(self.model_class, sortBy, None)
            if sort_column:

                if descending:
                    query = query.order_by(desc(sort_column))
                else:
                    query = query.order_by(asc(sort_column))

        # # 削除しない
        # # # sqlをログ出力したい場合
        # logger.debug(query.statement.compile(dialect=postgresql.dialect(),
        #                                      compile_kwargs={'literal_binds': True}))

        # ページネーション情報を含むクエリを実行
        rowsNumber = query.count()

        items = query.offset(offset).limit(rowsPerPage).all()

        self.after_get_all(items)

        items = [item.to_dict() for item in items]

        self.before_respose(items)

        totalPages = (rowsNumber + rowsPerPage - 1) // rowsPerPage

        # 結果を辞書にまとめて返す
        result = {
            'data': items,
            'pagination': {
                'rowsNumber': rowsNumber,
                'rowsPerPage': rowsPerPage,
                'page': page,
                'totalPages': totalPages,
                'sortBy': sortBy,
                'descending': descending,
            }
        }

        return result

    # IDでアイテムを取得するメソッド
    def get_item_by_id(self, event, context=None):
        # logger.debug('get_item_by_id')

        data = GV.EVENT_BODY

        return self._get_item_by_id(data)

    def _get_item_by_id(self, data):

        primary_key_values = {}
        for key in self.primary_key_columns:
            if key in data:
                primary_key_values[key] = data[key]

        primary_key_filters = [
            getattr(self.model_class, column) == value
            for column, value in primary_key_values.items()
        ]

        try:
            item = (
                self.session.query(self.model_class)
                .filter(and_(*primary_key_filters))
                .one()
            )
            return item

        except NoResultFound:
            return None

    def _get_item_by_filters(self, filters, order_by=None, get_all=False):
        logger.debug('_get_item_by_filters')
        logger.debug(filters)
        try:
            if get_all == True:
                items = (
                    self.session.query(self.model_class)
                    .filter(filters)
                    .order_by(order_by)
                    .all()
                )
                return items
            else:
                items = (
                    self.session.query(self.model_class)
                    .filter(filters)
                    .order_by(order_by)
                    .first()
                )
                return items
        except NoResultFound:
            return None
        except Exception as e:
            logger.debug(e)
            pass

    def api_get_item_by_id(self, event, context=None):
        # logger.debug('api_get_item_by_id')

        try:
            item = self.get_item_by_id(event, context)
            return {
                'body': json.dumps(item.to_dict())
            }
        except NoResultFound:
            return {
                'code': 404,
                'body': json.dumps({'error': 'Item not found'})
            }

    # フックメソッド

    def before_add(self, data=None):
        # デフォルトは何もしない
        pass

    def after_add(self, data=None, item=None):
        # デフォルトは何もしない
        return item
        pass

    def before_new_item(self, item):
        # デフォルトは何もしない

        # 作成日時
        if hasattr(item, 'cdate'):
            item.cdate = self.NOW
        # 更新日時
        if hasattr(item, 'udate'):
            item.udate = self.NOW

        pass

    def after_new_item(self, new_item):
        # デフォルトは何もしない
        pass

    # アイテムを追加するメソッド
    def add(self, event, context=None):
        # logger.debug('add')

        data = GV.EVENT_BODY

        self.before_add(data)

        item = self._add(data)

        item = self.after_add(data, item)
        # logger.debug(item)

        if hasattr(item, 'to_dict'):
            return item.to_dict()
        else:
            return item
        # return self._add(data)

    def _add(self, data):
        # logger.debug('_add')
        tmp_data = data.copy()

        try:
            if type(tmp_data) == list:
                # logger.debug('_add list')
                for d in tmp_data:
                    for key in d.keys():
                        if not key in self.model_class.__table__.columns.keys():
                            del tmp_data[key]

                    new_item = self.model_class(**d)

                    # フックメソッドは、新しいアイテムを追加する前に呼び出されます
                    self.before_new_item(new_item)

                    self.session.add(new_item)
            else:
                # logger.debug('_add one')

                for key in list(tmp_data):
                    if not key in self.model_class.__table__.columns.keys():
                        del tmp_data[key]

                new_item = self.model_class(**tmp_data)

                # フックメソッドは、新しいアイテムを追加する前に呼び出されます
                self.before_new_item(new_item)

                self.session.add(new_item)

            self.session.commit()

            self.after_new_item(new_item)

            return new_item

        except Exception as e:
            # logger.debug(e)
            pass
            # 例外の再送出
            raise

    # フックメソッド

    def before_update(self, data=None):
        # デフォルトは何もしない
        pass

    def after_update(self, data=None, item=None):
        # デフォルトは何もしない
        return item
        pass

    def before_update_item(self, item=None, data=None):
        # デフォルトは何もしない

        #
        now = datetime.now()
        # 更新日時
        if hasattr(item, 'udate'):
            item.udate = now

        pass

    def after_update_item(self, item=None, data=None):
        # デフォルトは何もしない
        pass

    # アイテムを更新するメソッド
    def update(self, event, context=None):
        # logger.debug('update')

        data = GV.EVENT_BODY

        self.before_update(data)

        item = self._update(data)

        item = self.after_update(data, item)

        return item.to_dict()

    def _update(self, data):

        try:
            primary_key_values = {}
            for key in self.primary_key_columns:
                if key in data:
                    primary_key_values[key] = data[key]

            primary_key_filters = [
                getattr(self.model_class, column) == value
                for column, value in primary_key_values.items()
            ]

            try:
                item = (
                    self.session.query(self.model_class)
                    .filter(and_(*primary_key_filters))
                    .one()
                )
            except NoResultFound:
                # logger.debug('NoResultFound')
                # return {
                #     'code': 404,
                #     'body': json.dumps({'error': 'Item not found'})
                # }
                return None

            for key, value in data.items():
                setattr(item, key, value)

            # フックメソッドは、アイテムを更新する前に呼び出されます
            self.before_update_item(item, data)

            self.session.commit()

            self.after_update_item(item, data)

            return item

        except Exception as e:
            # logger.debug(e)
            pass
            # 例外の再送出
            raise

    def before_delete_item(self, item):
        # デフォルトは何もしない
        pass

    def after_delete_item(self, item):
        # デフォルトは何もしない
        pass

    # アイテムを削除するメソッド
    def delete(self, event, context=None):
        # logger.debug('delete')

        data = GV.EVENT_BODY

        return self._delete(data)

    def _delete(self, data):
        logger.debug('_delete')
        logger.debug(data)

        primary_key_values = {}
        for key in self.primary_key_columns:
            if key in data:
                primary_key_values[key] = data[key]

        primary_key_filters = [
            getattr(self.model_class, column) == value
            for column, value in primary_key_values.items()
        ]

        try:
            items = (
                self.session.query(self.model_class)
                .filter(and_(*primary_key_filters))
            )
        except NoResultFound:
            return {
                'code': 404,
                'body': json.dumps({'error': 'Item not found'})
            }

        res = []

        for item in items:
            # フックメソッドは、アイテムを削除する前に呼び出されます
            self.before_delete_item(item)

            self.session.delete(item)

            self.after_delete_item(item)

            res.append(item.to_dict())

        self.session.commit()

        return res

    def get_table_schema(self):

        # print('get_table_schema')

        try:

            column_types = {
                VARCHAR: "varchar",
                INTEGER: "integer",
                DATE: "date",
                DATETIME: "datetime",
                BOOLEAN:  "boolean",
                TIMESTAMP: "timestamp",
                TEXT: "text",
                NUMERIC: "numeric",
                JSONB: "jsonb"
            }

            custom_column_info = None

            config_name = self.table_name
            if self.table_config is not None:
                config_name = self.table_config

            # json_file = f'{GV.CUR_PATH}/config/{config_name}.json'

            # if os.path.isfile(json_file):
            #     with open(json_file, encoding='utf-8') as f:
            #         custom_column_info = json.load(f)

            if custom_column_info is None:

                json_file = f'{GV.CUR_PATH}/config/controller/{config_name}.json'

                if os.path.isfile(json_file):
                    with open(json_file, encoding='utf-8') as f:
                        custom_column_info = json.load(f)

            if custom_column_info is None:

                json_file = f'{GV.CUR_PATH}/config/model/{config_name}.json'

                if os.path.isfile(json_file):
                    with open(json_file, encoding='utf-8') as f:
                        custom_column_info = json.load(f)

            column_info = {}
            for c in self.model_class.__table__.columns:
                col = {}

                col['name'] = c.name
                col['label'] = c.name

                if self.model_class.columns and c.name in self.model_class.columns:
                    comment = self.model_class.columns[c.name]['comment']
                    if comment is not None:
                        col['label'] = comment

                col['type'] = column_types[type(c.type)]
                if hasattr(c.type, 'length'):
                    col['length'] = c.type.length
                col['primary_key'] = c.primary_key
                # col['table'] = c.table

                column_info[c.name] = col

            columns = []
            if custom_column_info is not None and 'fieldConfig' in custom_column_info:
                for item in custom_column_info['fieldConfig']:
                    if item['name'] in column_info:
                        columns.append(column_info[item['name']] | item)
                    else:
                        columns.append(item)
                custom_column_info['fieldConfig'] = columns
            else:
                for k, v in column_info.items():
                    columns.append(v)
                custom_column_info = {}
                custom_column_info['fieldConfig'] = columns

            if 'tableName' not in custom_column_info:
                custom_column_info['tableName'] = self.table_name
            if 'tableTitle' not in custom_column_info:
                custom_column_info['tableTitle'] = self.table_name

            # print('get_table_schema1')

            return custom_column_info

        except Exception as e:
            print(e)
            pass
    #

    def new_id(self, number_name, prefix, zfill):

        # from .model.m_numbering import Sub as MN
        # mnum = MN()
        MN = GV.get_module('m_numbering')
        m_n = MN()

        item_m_n = m_n.get_new_number(number_name)
        return prefix + str(item_m_n.number).zfill(zfill)
