import boto3
from error_function import error_handling
import global_value as GV
import os
import json
import requests
import subprocess
import datetime
import csv
import inspect
import base64
 
from common.auth0.v2.component import Auth0Component

from model import user_infrastructure
# from model import mscone_lic
# from model import billing_infrastructure

from datetime import datetime as dt, timedelta

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

RESPONSE_HEADERS = GV.RESPONSE_HEADERS

# 設定ファイル
# BUCKET_NAME = 'env-mcl-mgmt-phase4'
# PATH_NAME = 'user-infrastructure/'
# OBJECT_KEY_NAME = 'config.json'
s3 = boto3.resource('s3')

record = GV.record


def lambda_handler(event, context):

    print(event)

    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None:
            event_body = json.loads(event['body'])
            logger.info(event_body)

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)

        if event['stageVariables']['env'] is None:
            res = {}
            res['error_code'] = ''
            res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
            return {
                'statusCode': 500,
                'headers': RESPONSE_HEADERS,
                'body': json.dumps(res)
            }

        GV.ENV = event['stageVariables']['env'].upper()

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/'
        OBJECT_KEY_NAME = 'config.json'

        bucket = s3.Bucket(BUCKET_NAME)
        obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
        response = obj.get()
        body = response['Body'].read()
        ENV_CONFIG = json.loads(body.decode('utf-8'))

        GV.CONFIG = {}
        GV.CONFIG['AUTH0_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_AUDIENCE']
        GV.CONFIG['AUTH0_CLIENT_ID'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_ID']
        GV.CONFIG['AUTH0_CLIENT_SECRET'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_SECRET']
        GV.CONFIG['AUTH0_DOMAIN'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_DOMAIN']
        # GV.CONFIG['AUTH0_ROLE_IDS'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLE_IDS']
        # 通常ユーザー管理者 ロール
        GV.CONFIG['AUTH0_ROLES'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLES']
        GV.CONFIG['API_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'API_AUDIENCE']
        GV.CONFIG['ALGORITHMS'] = ["RS256"]

        GV.CONFIG_MSCONE_LIC = {}
        GV.CONFIG_MSCONE_LIC['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_MSCONE_LIC['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PORT']
        # GV.CONFIG_MSCONE_LIC['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABSE_PORT']
        GV.CONFIG_MSCONE_LIC['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PASSWORD']

        GV.CONFIG_COMN_PF = {}
        GV.CONFIG_COMN_PF['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_COMN_PF['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PORT']
        # GV.CONFIG_COMN_PF['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABSE_PORT']
        GV.CONFIG_COMN_PF['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_COMN_PF['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_COMN_PF['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PASSWORD']
                                                                               
        GV.CONFIG_SERVICE_SETTING = {}
        GV.CONFIG_SERVICE_SETTING['SPECIFIED_NUMBER_DAYS'] = ENV_CONFIG[GV.ENV]['SERVICE_SETTING'][GV.ENV + '_' + 'SPECIFIED_NUMBER_DAYS']
        # GV.CONFIG_SERVICE_SETTING['SPECIFIED_NUMBER_DAYS'] = '5,3'
        
        GV.CONFIG_LOGIN_URL = {}
        GV.CONFIG_LOGIN_URL['LOGIN_URL'] = ENV_CONFIG[GV.ENV]['LOGIN_URL'][GV.ENV + '_' + 'LOGIN_URL']
        
        # フェーズ3 ------------------------S
        GV.CONFIG_SYSTEM_SERVICE = {}
        GV.CONFIG_SYSTEM_SERVICE= ENV_CONFIG[GV.ENV]['SYSTEM_SERVICE']
        # フェーズ3 ------------------------E

        # --------------------------------------------------------------------
        # Auth0 S
        
        logger.debug('# ************0704******************') 
        if event['httpMethod'] == 'GET':
            if event['path'] == '/service_setting/company_info' or event['path'] == '/service_setting/company_info/':
                result = get_data_from_user_infrastructure_m_auth0_management(event)
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    result_body = json.loads(result['body'])
                    send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                    return result
        
                result_body = json.loads(result['body'])
                print(result_body)
                if 'result' in result_body:
                    rows = result_body['result']
                    if len(rows) > 0:
                        logger.debug('# ************Auth0情報を設定する******************')
                        GV.CONFIG['AUTH0_AUDIENCE'] = rows[0]['management_api_audience']
                        GV.CONFIG['AUTH0_CLIENT_ID'] = rows[0]['api_clientid']
                        GV.CONFIG['AUTH0_CLIENT_SECRET'] = rows[0]['api_client_secret']
                        GV.CONFIG['AUTH0_DOMAIN'] = rows[0]['domain']
                        GV.CONFIG['API_AUDIENCE'] = rows[0]['api_audience']
                        GV.CONFIG['AUTH0_TENANT'] = rows[0]['tenant']
                        logger.debug(GV.CONFIG)
                        pass
                    else:
                        return {"error": + " ユーザーのデータは存在しないので、システム者にご連絡ください。"}
                        
        if event['httpMethod'] == 'PUT':
            # 画面の処理
            if event['path'] == '/service_setting/service_setting' or event['path'] == '/service_setting/service_setting/':
                result = get_data_from_user_infrastructure_m_auth0_management_list(event)
                print(result)
                if (result != {}):
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        result_body = json.loads(result['body'])
                        send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        return result
            
                    result_body = json.loads(result['body'])
                    print(result_body)
                    if 'result' in result_body:
                        rows = result_body['result']
                        if len(rows) > 0:
                            logger.debug('# ************Auth0情報を設定する******************')
                            GV.CONFIG['AUTH0_AUDIENCE'] = rows[0]['management_api_audience']
                            GV.CONFIG['AUTH0_CLIENT_ID'] = rows[0]['api_clientid']
                            GV.CONFIG['AUTH0_CLIENT_SECRET'] = rows[0]['api_client_secret']
                            GV.CONFIG['AUTH0_DOMAIN'] = rows[0]['domain']
                            GV.CONFIG['API_AUDIENCE'] = rows[0]['api_audience']
                            GV.CONFIG['AUTH0_TENANT'] = rows[0]['tenant']
                            logger.debug(GV.CONFIG)
                            pass
                        else:
                            return {"error": + " ユーザーのデータは存在しないので、システム者にご連絡ください。"}

        logger.debug('# ************0704******************') 
        
        # 通常ユーザー管理者 のみアクセス可能
        
        event_headers = {}
        if 'headers' in event and event['headers'] is not None: 
            event_headers = event['headers']
            logger.info(event_headers)

            # 検証
            if 'Authorization' not in event_headers:
                msg = '認証情報が正しくありません。'
                return error_400(msg)
            
            access_token_info = get_access_token_info(event_headers["Authorization"])
            # if 'my_roles' not in access_token_info:
            #     msg = 'アクセス権限がありません。'
            #     return error_400(msg)
            
            # # 通常ユーザー管理者 のみアクセス可能
            # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
            #     msg = 'アクセス権限がありません。'
            #     return error_400(msg)
        
            # フェーズ3 20230830 ------------------------S

            if 'user_metadata' not in access_token_info:
                msg = 'アクセス権限がありません。'
                return error_400(msg)

            user_metadata = access_token_info['user_metadata']

            if 'data' not in user_metadata:
                print(''' 'data' not in user_metadata ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)

            if type(user_metadata['data']) != list:
                print(''' type(user_metadata['data']) != list ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)
            
            if len(user_metadata['data']) < 1:
                print(''' len(user_metadata['data']) < 1 ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)
            
            # フェーズ3 20230830 ------------------------E

        # Auth0 E
        # --------------------------------------------------------------------
        
        res = {}

        print(event['httpMethod'])
        print(event['path'])
        if event['httpMethod'] == 'PUT':
            # 画面の処理
            if event['path'] == '/service_setting/service_setting' or event['path'] == '/service_setting/service_setting/':
                res = update_service_setting(event, context)
            # サービスの一時休止(Lambda) 定期実行
            elif event['path'] == '/service_setting/service_temp_sleep' or event['path'] == '/service_setting/service_temp_sleep/':
                res = regular_service_temp_sleep(event, context)
            # サービスの停止 定期実行
            elif event['path'] == '/service_setting/service_stop' or event['path'] == '/service_setting/service_stop/':
                res = regular_service_stop(event, context)
            # サービスの再開事前通知 定期実行
            elif event['path'] == '/service_setting/service_restart_pre_notification' or event['path'] == '/service_setting/service_restart_pre_notification/':
                res = regular_service_restart_pre_notification(event, context)
            # サービスの再開 定期実行
            elif event['path'] == '/service_setting/service_restart' or event['path'] == '/service_setting/service_restart/':
                res = regular_service_restart(event, context)
            # -----------障害 #4909 利用料金の上限以上------20231213-------------------S
            # サービスの上限を超えていた場合に、上限を超えた旨の通知メール送信
            elif event['path'] == '/service_setting/service_amounts' or event['path'] == '/service_setting/service_amounts/':
                res = regular_service_amounts(event, context)
            # -----------障害 #4909 利用料金の上限以上------20231213-------------------E
            # # サービスの再開後の予定日のリセット 定期実行
            # elif event['path'] == '/service_setting/service_restart_date_reset' or event['path'] == '/service_setting/service_restart_date_reset/':
            #     res = regular_service_restart_date_reset(event, context)
        elif event['httpMethod'] == 'GET':
            if event['path'] == '/service_setting/company_info' or event['path'] == '/service_setting/company_info/':
                #
                res = get_data_from_user_infrastructure_t_entry(event, context)
        logger.info(res)

        # if 'statusCode' in res and (res['statusCode'] == 400 or res['statusCode'] == 500):
        #     global record
        #     res_body = json.loads(res['body'])
        #     record['error_message'] = {}
        #     record['error_message']['value'] = res_body['error_message']
        #     send_email_on_error(event, context)

        return res

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# --------------------------------------------------------------------
# Auth0 S

def get_access_token_info(auth):
    auth0 = Auth0Component(GV.CONFIG)
    return auth0.get_access_token_info(auth)

# Auth0 E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# 画面の処理
def update_service_setting(event, context):

    logger.info('update_service_pause!!!')

    global record

    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        event_body = {}
        event_body = json.loads(event['body'])

        tmp = event_body['record']
        print(tmp)

        # 更新情報をグローバル変数「record」とマージする
        record.update(tmp)
        print(record)

        # kintoneの企業情報管理アプリ、
        # DBに一時休止開始日を登録する。
        # 更新履歴テーブル(user_infrastructure.m_update_company_info_history)に更新履歴を登録する。
        # ------------------------------------

        # DB m_contract
        result = update_m_contract()
        print(result)
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        # ------------------------------------
        
        # ------------------------------------
        # DB 更新履歴の追加
        if (record["emailType"]["value"] != '4'):
            result = insert_m_update_company_info_history()
            print(result)
    
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                return result

        # サービスの一時休止が申し込まれた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメール送信する。
        # ------------------------------------
        
        # メール送信
        result = send_update_next_month_email(event, context)

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        # # ------------------------------------

    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(res, default=str)
    }

# サービスの一時休止(Lambda) 定期実行
def regular_service_temp_sleep(event, context):

    logger.info('regular_service_temp_sleep!!!')

    global record

    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        event_body = {}

        # (user_infrastructure.m_company.system_usable_flag)を1にする。
        # サービスの一時休止/停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知する。
        # サービスの停止期間管理テーブル(新規)に企業コード、停止開始日を記録する。
        # 企業情報管理アプリ、DBでサービスのステータスを一時休止にする(停止を優先)。
        
        # ------------------------------------
        # DB m_contract
        # ステータスが利用中かつ一時休止開始予定日に処理を実行する。
        result = get_data_user_infrastructure_m_contract(event, context, '利用中', 'temp_sleep')
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # (user_infrastructure.m_company.system_usable_flag)を1にする。
                # DB m_company
                item['system_usable_flag'] = '1'
                result = update_t_manage_request(item)
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                # ------------------------------------    
                
                # サービスの一時休止/停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知する。
                # メール送信
                
                # システム管理者のメールを取得する
                # ------------------------------------
                # DB m_user
                result = get_data_user_infrastructure_m_user(item)
                
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                
                result_user_body = json.loads(result['body'])
                if 'result' in result_user_body:
                    rows_user = result_user_body['result']
                    if len(rows_user) > 0:
                        # 登録済の場合
                        item["administrator_email"] = rows_user[0]['email']
                    else:
                        item["administrator_email"] = ''
                        
                # サービスの利用ステータスを判定する        
                status_result = get_service_usable_status(item)
                print(status_result)
                if status_result  == '停止' or status_result == '一時休止':
                    if (status_result == '停止'):
                        item["emailType"] = '5'
                        item["service_usable_status"] = '停止'
                            
                    if (status_result == '一時休止'):
                        item["emailType"] = '7'
                        item["service_usable_status"] = '一時休止'
                   
                    # ------------------------------------
                    # サービスの停止期間管理テーブル(新規)に企業コード、停止開始日を記録する。
                    # ------------------------------------
                    # DB m_service_stop_history
                    # result = get_post_t_manage_request(item)
                    
                    # 申込管理情報の環境IDを取得する
                    # ------------------------------------
                    # DB t_manage_request
                    result = get_data_user_infrastructure_t_manage_request(item)
                    
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    
                    result_manage_body = json.loads(result['body'])
                    if 'result' in result_manage_body:
                        rows_manage = result_manage_body['result']
                        if len(rows_manage) > 0:
                            # 登録済の場合
                            item["env_id"] = rows_manage[0]['env_id']
                        else:
                            item["env_id"] = ''
                    
                    result = update_post_m_service_stop_history(item)
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
    
                    # ------------------------------------
                    # DBでサービスのステータスを一時休止にする(停止を優先)。
                    # ------------------------------------
                    # DB m_contract
                    result = update_put_m_contract(item,'')
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    
                    # メール送信
                    result = service_temp_sleep_email(item)
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result

    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(res, default=str)
    }

# サービスの停止 定期実行
def regular_service_stop(event, context):

    logger.info('regular_service_stop!!!')

    global record

    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        event_body = {}
        
        # -----------障害 #4909 利用料金の上限以上------20231213-------------------S
        
        # 現在の利用料金の合計値が利用料金の上限以上になったら自動的にサービスの停止状態にする(サービスの一時休止、停止、再開処理の停止処理)
        # ------------------------------------
        # DB m_contract
        #  現在の利用料金の合計値が利用料金の上限以上からデータを取得する
        result = get_data_user_infrastructure_m_contract(event, context, '停止','')
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # ------------------------------------    
                # サービスの停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知する。
                # システム管理者のメールを取得する
                # ------------------------------------
                # DB m_user
                result = get_data_user_infrastructure_m_user(item)
                
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                
                result_user_body = json.loads(result['body'])
                if 'result' in result_user_body:
                    rows_user = result_user_body['result']
                    if len(rows_user) > 0:
                        # 登録済の場合
                        item["administrator_email"] = rows_user[0]['email']
                    else:
                        item["administrator_email"] = ''
                        
                # ------------------------------------
                # DBでサービスのステータスを停止にする。。
                # ------------------------------------
                # DB m_contract
                item["service_usable_status"] = '停止'
                dt_now = datetime.datetime.now()
                item["ndes_service_stop_start_date"] = dt_now.strftime('%Y/%m/%d')
                result = update_put_m_contract(item,'amount_upper_limit')
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                    
                # 利用料金の上限以上になって停止する場合は、システム利用可能フラグを3にする。停止ボタンで停止する場合はシステム利用可能フラグは1のまま
                # (user_infrastructure.m_company.system_usable_flag)を3にする。
                # DB m_company
                item['system_usable_flag'] = '3'
                result = update_t_manage_request(item)
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                    
                # メール送信
                # ・停止予定日：「Simulation-Spaceのサービスを停止しました」
                
                item["emailType"] = '5'
                result = service_temp_sleep_email(item)

        # -----------障害 #4909 利用料金の上限以上------20231213-------------------E
    

        # ステータスが利用中かつ停止開始日に処理を実行する。

        # ------------------------------------
        # DB m_contract
        # 利用中からデータを取得する
        result = get_data_user_infrastructure_m_contract(event, context, '利用中','stop')
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # (user_infrastructure.m_company.system_usable_flag)を1にする。
                # DB m_company
                item['system_usable_flag'] = '1'
                result = update_t_manage_request(item)
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                # ------------------------------------    
                
                # サービスの停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知する。

                # システム管理者のメールを取得する
                # ------------------------------------
                # DB m_user
                result = get_data_user_infrastructure_m_user(item)
                
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                
                result_user_body = json.loads(result['body'])
                if 'result' in result_user_body:
                    rows_user = result_user_body['result']
                    if len(rows_user) > 0:
                        # 登録済の場合
                        item["administrator_email"] = rows_user[0]['email']
                    else:
                        item["administrator_email"] = ''

                # ------------------------------------
                # (user_infrastructure.m_service_stop_history)に企業コード、停止開始日を記録する。
                # ------------------------------------
                # DB m_service_stop_history
                # 申込管理情報の環境IDを取得する
                # ------------------------------------
                # DB t_manage_request
                result = get_data_user_infrastructure_t_manage_request(item)
                
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                
                result_manage_body = json.loads(result['body'])
                if 'result' in result_manage_body:
                    rows_manage = result_manage_body['result']
                    if len(rows_manage) > 0:
                        # 登録済の場合
                        item["env_id"] = rows_manage[0]['env_id']
                    else:
                        item["env_id"] = ''
                result = update_post_m_service_stop_history(item)
                print(result)
                
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result

                # ------------------------------------
                # DBでサービスのステータスを停止にする。。
                # ------------------------------------
                # DB m_contract
                item["service_usable_status"] = '停止'
                result = update_put_m_contract(item,'')
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result

                # メール送信
                # サービスの停止のLambdaの処理で一時休止予定日に停止した場合と、停止予定日に停止した場合で送信するメールを変えてください。
                # ・一時休止予定日：「Simulation-Spaceのサービスを一時休止しました」
                # ・停止予定日：「Simulation-Spaceのサービスを停止しました」
                
                # 一時休止予定日に停止した場合
                if (not item["temp_service_sleep_restart_date"] and item["temp_service_sleep_start_date"]):
                    if item["ndes_service_stop_start_date"].split(" ")[0].replace('-','/') >= item["temp_service_sleep_start_date"].split(" ")[0].replace('-','/'):
                        item["emailType"] = '7'
                        result = service_temp_sleep_email(item)
                elif (item["temp_service_sleep_restart_date"] and item["temp_service_sleep_start_date"]):
                    if item["ndes_service_stop_start_date"].split(" ")[0].replace('-','/') >= item["temp_service_sleep_start_date"].split(" ")[0].replace('-','/') and item["ndes_service_stop_start_date"].split(" ")[0].replace('-','/') <= item["temp_service_sleep_restart_date"].split(" ")[0].replace('-','/'):
                        item["emailType"] = '7'
                        result = service_temp_sleep_email(item)
                item["emailType"] = '5'
                result = service_temp_sleep_email(item)
                    
        # ステータスが一時休止かつ停止開始日の場合、企業情報管理アプリ、DBでサービスのステータスを停止にする。
        # ------------------------------------
        # DB m_contract
        # ステータスが一時休止かつ停止開始日からデータを取得する
        result = get_data_user_infrastructure_m_contract(event, context, '一時休止','stop')
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # ------------------------------------    
                
                # サービスの停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知する。

                # システム管理者のメールを取得する
                # ------------------------------------
                # DB m_user
                result = get_data_user_infrastructure_m_user(item)
                
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                
                result_user_body = json.loads(result['body'])
                if 'result' in result_user_body:
                    rows_user = result_user_body['result']
                    if len(rows_user) > 0:
                        # 登録済の場合
                        item["administrator_email"] = rows_user[0]['email']
                    else:
                        item["administrator_email"] = ''
                        
                # ------------------------------------
                # DBでサービスのステータスを停止にする。。
                # ------------------------------------
                # DB m_contract
                item["service_usable_status"] = '停止'
                result = update_put_m_contract(item,'')
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                    
                # メール送信
                # ・停止予定日：「Simulation-Spaceのサービスを停止しました」
                
                item["emailType"] = '5'
                result = service_temp_sleep_email(item)

    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(res, default=str)
    }

# サービスの再開事前通知 定期実行
def regular_service_restart_pre_notification(event, context):

    logger.info('regular_service_restart_pre_notification!!!')

    global record

    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        event_body = {}
        # サービスの再開日のConfigファイルで指定された日数前にもしくは、企業情報管理アプリ、DBの「サービスの再開事前通知日」が空欄かつConfigファイルで指定された最大の日数より今日の日付が後の場合は処理を実行する。
        # システムの環境構築依頼をサポートMLにメール送信する。
        # 企業情報管理アプリ、DBの「サービスの再開事前通知実施日」を更新する。

        # ------------------------------------
        # DB m_contract
        # サービスの再開日のConfigファイルで指定された日数前にもしくは、企業情報管理アプリ、DBの「サービスの再開事前通知日」が空欄かつConfigファイルで指定された最大の日数より今日の日付が後の場合からデータを取得する
        # Configファイルで指定された日数
        
        # 一時休止からの再開予定日場合 1
        result = get_notification_data_infrastructure_m_contract_sql(event, context, GV.CONFIG_SERVICE_SETTING['SPECIFIED_NUMBER_DAYS'], '1')

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # 一時休止からの再開予定日場合のチェック 
                # 「一時休止からの再開予定日」と「停止からの再開予定日」が同じ日付の場合メール送信は一件です、１で設定する
                if (data_restart_pre_notification_check(item['temp_service_sleep_restart_date'],item['ndes_service_stop_restart_date'],'1') == 'true'):

                    # ------------------------------------
                    # DBの「サービスの再開事前通知実施日」を更新する。
                    # ------------------------------------
                    # DB m_contract
                    dt_now = datetime.datetime.now()
                    item["pre_notification_resumption_of_service_mael_send_date"] = dt_now.strftime('%Y/%m/%d')
                    result = update_put_m_contract(item,'notification')
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result

                    # システムの環境構築依頼をサポートMLにメール送信する。。
                    # メール送信
                    # サービスの停止 "サービスの再開事前通知"
                    item["emailType"] = '6'
                    result = service_temp_sleep_email(item)

        # 停止からの再開予定日場合 2
        result = get_notification_data_infrastructure_m_contract_sql(event, context, GV.CONFIG_SERVICE_SETTING['SPECIFIED_NUMBER_DAYS'], '2')

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # 停止からの再開予定日場合のチェック 
                if (data_restart_pre_notification_check(item['ndes_service_stop_restart_date'],item['temp_service_sleep_restart_date'],'2') == 'true'):

                    # ------------------------------------
                    # DBの「サービスの再開事前通知実施日」を更新する。
                    # ------------------------------------
                    # DB m_contract
                    dt_now = datetime.datetime.now()
                    item["pre_notification_resumption_of_service_mael_send_date"] = dt_now.strftime('%Y/%m/%d')
                    result = update_put_m_contract(item,'notification')
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result

                    # システムの環境構築依頼をサポートMLにメール送信する。。
                    # メール送信
                    # サービスの停止 "サービスの再開事前通知"
                    item["emailType"] = '6'
                    result = service_temp_sleep_email(item)
                    
        # サービスの再開事前通知でConfigで設定した最短日数より再開日が短い、メール未送信の場合に処理が行われない。
        # ・サービスの再開事前通知実施日：空欄
        # ・今日の日付：2023/02/08
        # ・サービスの再開予定日：2023/02/09(1日後)
        result = get_notification_data2_infrastructure_m_contract_sql(event, context)

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # 一時休止からの再開予定日場合のチェック  or  # 停止からの再開予定日場合のチェック 
                # 「一時休止からの再開予定日」と「停止からの再開予定日」が同じ日付の場合メール送信は一件です、１、２で設定する
                if (data_restart_pre_notification_check(item['temp_service_sleep_restart_date'],item['ndes_service_stop_restart_date'],'1') == 'true' or data_restart_pre_notification_check(item['ndes_service_stop_restart_date'],item['temp_service_sleep_restart_date'],'2') == 'true'):

                    # ------------------------------------
                    # DBの「サービスの再開事前通知実施日」を更新する。
                    # ------------------------------------
                    # DB m_contract
                    dt_now = datetime.datetime.now()
                    item["pre_notification_resumption_of_service_mael_send_date"] = dt_now.strftime('%Y/%m/%d')
                    result = update_put_m_contract(item,'notification')
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                                        
                    # システムの環境構築依頼をサポートMLにメール送信する。。
                    # メール送信
                    # サービスの停止 "サービスの再開事前通知"
                    item["emailType"] = '6'
                    result = service_temp_sleep_email(item)

    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(res, default=str)
    }

# サービスの再開 定期実行
def regular_service_restart(event, context):

    logger.info('regular_service_restart!!!')

    global record

    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        event_body = {}
        amount_arr = []

        # -----------障害 #4909 利用料金の上限以上------20231213-------------------S 
        # サービスの停止中に、現在の利用料金の合計値が利用料金が上限より小さくなったらサービスを利用可能状態
        result = get_data_user_infrastructure_m_contract(event, context, '停止', 'amount_upper_limit')
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                amount_arr.append(item['contract_id'])

                # --------------------------20231225-------------------S
                # 実行日が一時休止期間か停止期間の場合。
                # サービスの利用ステータスを判定する        
                status_result = get_service_usable_status_amount(item)
                print(status_result)
                if status_result != '一時休止':

                    # 「システム情報が未設定」の判定は消し。 20240327  S
                    # システム情報が未設定の場合は処理を終了する。
                    # mscone_lic.m_company AppStreamスタック名 stack_name FSX_ID access_key ブリッジサーバーインスタンスID bridge_instance_id マウントコマンド netuse_command
                    # result = get_data_m_company(item)
                    # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    #     return result
                        
                    # result_body1 = json.loads(result['body'])
                    # print(result_body1)
                    
                    # tmp = {}
                    # if 'result' in result_body1:
                    #     rows1 = result_body1['result']
                    #     for item1 in rows1:
                    #         print(item1)
                    #         # if (item1["stack_name"] == '' or item1["access_key"] == '' or  item1["bridge_instance_id"] == '' or item1["netuse_command"] == ''):
                    #         #     logger.info('システム情報が未設定の場合は処理を終了する')
                    #         #     break
                    #         if (
                    #             ("stack_name" in item1 and (item1["stack_name"] is None or item1["stack_name"] == '')) or \
                    #             ("access_key" in item1 and (item1["access_key"] is None or item1["access_key"] == '')) or \
                    #             ("bridge_instance_id" in item1 and (item1["bridge_instance_id"] is None or item1["bridge_instance_id"] == '')) or \
                    #             ("netuse_command" in item1 and (item1["netuse_command"] is None or item1["netuse_command"] == '')) or \
                    #             ("instance_id" in item1 and (item1["instance_id"] is None or item1["instance_id"] == ''))
                    #         ):
                    #             logger.info('システム情報が未設定の場合は処理を終了する')
                    #             break
                    #         else:
                    # 「システム情報が未設定」の判定は消し。 20240327  E    
                    # m_contractテーブルのndes_service_stop_restart_dateカラムに今日の日付を入れる処理 
                    dt_now = datetime.datetime.now()
                    item["ndes_service_stop_restart_date"] = dt_now.strftime('%Y/%m/%d')
                    result = update_put_m_contract(item,'amount_upper_limit_s')
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
        
                    # (user_infrastructure.m_company.system_usable_flag)を2にする。
                    # DB m_company
                    item['system_usable_flag'] = '2'
                    result = update_t_manage_request(item)
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    # ------------------------------------    
                    
                    # サービスの再開が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメール送信する。
                    # メール送信
                    
                    # システム管理者のメールを取得する
                    # ------------------------------------
                    # DB m_user
                    result = get_data_user_infrastructure_m_user(item)
                    
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    
                    result_user_body = json.loads(result['body'])
                    if 'result' in result_user_body:
                        rows_user = result_user_body['result']
                        if len(rows_user) > 0:
                            # 登録済の場合
                            item["administrator_email"] = rows_user[0]['email']
                        else:
                            item["administrator_email"] = ''
                            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                        
                    # ------------------------------------
                    # サービスの停止期間管理テーブル(user_infrastructure.m_service_stop_history)に停止終了日(前日)を記録する(企業コードと停止開始日で検索)。
                    # ------------------------------------

                    # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    #     return result
                    # 停止予定日場合、更新する
                    # 申込管理情報の環境IDを取得する
                    # ------------------------------------
                    # DB t_manage_request
                    result = get_data_user_infrastructure_t_manage_request(item)
                    
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    
                    result_manage_body = json.loads(result['body'])
                    if 'result' in result_manage_body:
                        rows_manage = result_manage_body['result']
                        if len(rows_manage) > 0:
                            # 登録済の場合
                            item["env_id"] = rows_manage[0]['env_id']
                        else:
                            item["env_id"] = ''
                    result = update_put_ndes_m_service_stop_history(item)
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
    
                    # ------------------------------------
                    # DBでサービスのステータスを利用中にする。
                    # ------------------------------------
                    # DB m_contract
                    item["service_usable_status"] = '利用中'
                    result = update_put_m_contract(item,'')
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                        
                    # メール送信する
                    # サービスの再開 "サービスの再開通知"
                    item["emailType"] = '3'
                    result = service_temp_sleep_email(item)
                else:
                    # 上限を超えて停止中(システム利用可能フラグ3)に利用料金が上限より小さくなる＋サービスの一時休止期間中
                    # 上限を超えて停止中(システム利用可能フラグ3)に利用料金が上限より小さくなる＋停止ボタンを押して停止期間中になる
                    # (user_infrastructure.m_company.system_usable_flag)を1にする。
                    # DB m_company
                    item['system_usable_flag'] = '1'
                    result = update_t_manage_request(item)
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                # --------------------------20231225-------------------E

        # -----------障害 #4909 利用料金の上限以上------20231213-------------------E

        # 一時休止からの再開日以降かつ停止からの再開日以降に処理を実行する。
        # 実行日が一時休止期間か停止期間の場合は処理を終了する。
        # システム情報が未設定の場合は処理を終了する。 20240327 削除する

        # ------------------------------------
        # DB m_contract
        # 一時休止からの再開日以降かつ停止からの再開日以降に処理を実行する。
        result = get_data_infrastructure_m_contract_sql(event, context)
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                if item['contract_id'] in amount_arr:
                    continue
                
                # 実行日が一時休止期間か停止期間の場合は処理を終了する。
                # サービスの利用ステータスを判定する        
                status_result = get_service_usable_status(item)
                print(status_result)
                if status_result != '停止' and status_result != '一時休止':
                    # -----------障害 #4909 利用料金の上限以上------20240417-------------------S
                    # 「上限を超えて停止」場合、「service_usable_status="一時休止"」「システム利用可能フラグ=3」です
                    if (item['amount_upper_limit']  is not None):
                        if (int(item['used_amounts']) > int(item['amount_upper_limit'])  and int(item['amount_upper_limit']) != 0):
                            # m_contractテーブルの更新 
                            result = update_put_m_contract(item,'amount_upper_limit_null')
                            print(result)
                    
                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                return result
                            
                            # (user_infrastructure.m_company.system_usable_flag)を3にする。
                            # DB m_company
                            item['system_usable_flag'] = '3'
                            result = update_t_manage_request(item)
                            print(result)
                    
                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                return result
                            
                            continue
                    # -----------障害 #4909 利用料金の上限以上------20240417-------------------E
                    
                    # 「システム情報が未設定」の判定は消し。 20240327  S
                    # # システム情報が未設定の場合は処理を終了する。
                    # # mscone_lic.m_company AppStreamスタック名 stack_name FSX_ID access_key ブリッジサーバーインスタンスID bridge_instance_id マウントコマンド netuse_command
                    # result = get_data_m_company(item)
                    # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    #     return result
                        
                    # result_body1 = json.loads(result['body'])
                    # print(result_body1)
                    
                    # tmp = {}
                    # if 'result' in result_body1:
                    #     rows1 = result_body1['result']
                    #     for item1 in rows1:
                    #         print(item1)
                    #         # if (item1["stack_name"] == '' or item1["access_key"] == '' or  item1["bridge_instance_id"] == '' or item1["netuse_command"] == ''):
                    #         #     logger.info('システム情報が未設定の場合は処理を終了する')
                    #         #     break
                    #         if (
                    #             ("stack_name" in item1 and (item1["stack_name"] is None or item1["stack_name"] == '')) or \
                    #             ("access_key" in item1 and (item1["access_key"] is None or item1["access_key"] == '')) or \
                    #             ("bridge_instance_id" in item1 and (item1["bridge_instance_id"] is None or item1["bridge_instance_id"] == '')) or \
                    #             ("netuse_command" in item1 and (item1["netuse_command"] is None or item1["netuse_command"] == '')) or \
                    #             ("instance_id" in item1 and (item1["instance_id"] is None or item1["instance_id"] == ''))
                    #         ):
                    #             logger.info('システム情報が未設定の場合は処理を終了する')
                    #             break
                    #         else:
                    # 「システム情報が未設定」の判定は消し。 20240327  E
                    # (user_infrastructure.m_company.system_usable_flag)を2にする。
                    # DB m_company
                    item['system_usable_flag'] = '2'
                    result = update_t_manage_request(item)
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    # ------------------------------------    
                    
                    # サービスの再開が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメール送信する。
                    # メール送信
                    
                    # システム管理者のメールを取得する
                    # ------------------------------------
                    # DB m_user
                    result = get_data_user_infrastructure_m_user(item)
                    
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    
                    result_user_body = json.loads(result['body'])
                    if 'result' in result_user_body:
                        rows_user = result_user_body['result']
                        if len(rows_user) > 0:
                            # 登録済の場合
                            item["administrator_email"] = rows_user[0]['email']
                        else:
                            item["administrator_email"] = ''
                            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                        
                    # ------------------------------------
                    # サービスの停止期間管理テーブル(user_infrastructure.m_service_stop_history)に停止終了日(前日)を記録する(企業コードと停止開始日で検索)。
                    # ------------------------------------

                    # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    #     return result
                    # 停止予定日場合、更新する
                    # 申込管理情報の環境IDを取得する
                    # ------------------------------------
                    # DB t_manage_request
                    result = get_data_user_infrastructure_t_manage_request(item)
                    
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    
                    result_manage_body = json.loads(result['body'])
                    if 'result' in result_manage_body:
                        rows_manage = result_manage_body['result']
                        if len(rows_manage) > 0:
                            # 登録済の場合
                            item["env_id"] = rows_manage[0]['env_id']
                        else:
                            item["env_id"] = ''
                    result = update_put_ndes_m_service_stop_history(item)
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
    
                    # ------------------------------------
                    # DBでサービスのステータスを利用中にする。
                    # ------------------------------------
                    # DB m_contract
                    item["service_usable_status"] = '利用中'
                    result = update_put_m_contract(item,'')
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                        
                    # メール送信する
                    # サービスの再開 "サービスの再開通知"
                    item["emailType"] = '3'
                    result = service_temp_sleep_email(item)
                            
        # ステータスが利用中かつ処理の実行日が一時休止からの再開予定日以降の場合、一時休止開始日と一時休止からの再開予定日を空欄にする。
        # ステータスが利用中、処理の実行日が停止からの再開予定日以降の場合、停止開始日と停止からの再開予定日を空欄にする。
        # ------------------------------------
        # DB m_contract
        # ステータスが利用中かつ処理の実行日が一時休止からの再開予定日以降からデータを取得する
        dt_now = datetime.datetime.now()
        
        result = get_data_user_infrastructure_m_contract(event, context, '利用中', 'restart')
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                # 処理の実行日が一時休止からの再開予定日以降からデータを取得する 
                if (item["temp_service_sleep_restart_date"]):
                    if dt_now.strftime('%Y/%m/%d') >= item["temp_service_sleep_restart_date"].split(" ")[0].replace('-','/'):
                        item['temp_service_sleep_start_date'] = ''
                        item['temp_service_sleep_restart_date'] = ''
                        result = update_put_m_contract(item,'temp_restart')
                        print(result)
                
                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            return result

                # 処理の実行日が停止からの再開予定日以降からデータを取得する 
                if (item["ndes_service_stop_restart_date"]):
                    if dt_now.strftime('%Y/%m/%d') >= item["ndes_service_stop_restart_date"].split(" ")[0].replace('-','/'):
                        item['ndes_service_stop_start_date'] = ''
                        item['ndes_service_stop_restart_date'] = ''
                        result = update_put_m_contract(item,'ndes_restart')
                        print(result)
                
                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            return result
                            
    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(res, default=str)
    }

# -----------障害 #4909 利用料金の上限以上------20231213-------------------S 
# サービスの上限を超えていた場合に、上限を超えた旨の通知メール送信
def regular_service_amounts(event, context):

    logger.info('regular_service_amounts!!!')

    global record

    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        event_body = {}
        
        # 現在の利用料金の合計値が利用料金の上限以上になったら自動的にサービスの停止状態にする(サービスの一時休止、停止、再開処理の停止処理)
        # ------------------------------------
        # DB m_contract
        #  現在の利用料金の合計値が利用料金の上限以上からデータを取得する
        result = get_data_user_infrastructure_m_contract(event, context, '停止','')
        
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        if 'result' in result_body:
            rows = result_body['result']
            for item in rows:
                print(item)
                
                # ------------------------------------    
                # サービスの停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知する。
                # システム管理者のメールを取得する
                # ------------------------------------
                # DB m_user
                result = get_data_user_infrastructure_m_user(item)
                
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                
                result_user_body = json.loads(result['body'])
                if 'result' in result_user_body:
                    rows_user = result_user_body['result']
                    if len(rows_user) > 0:
                        # 登録済の場合
                        item["administrator_email"] = rows_user[0]['email']
                    else:
                        item["administrator_email"] = ''

                # メール送信
                # 上限金額を超えた際の事前通知
                item["emailType"] = '8'
                result = service_temp_sleep_email(item)

    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(res, default=str)
    }
# -----------障害 #4909 利用料金の上限以上------20231213-------------------E

# サービスの一時休止/停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知する。
def service_temp_sleep_email(itemData):
    # サービスの一時休止/停止が行われた旨を契約者、システム管理者、営業ML、サポートML、メールの証跡保存にメールで通知す

    logger.info('service_temp_sleep_email!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 申込番号
        "entry_code",
        # 企業コード
        "company_code",
        # 企業名
        "company_name",
        # 契約者部署名
        "contract_department",
        # 契約者名 姓
        "contract_last_name",
        # 契約者名 名
        "contract_first_name",
        # 契約者役職
        "contract_position",
        # 契約者のメールアドレス
        "contract_email",
        # 担当営業名
        "salesman_name",
        # システム管理者名 姓
        "administrator_name_last",
        # システム管理者名 名
        "administrator_name_first",
        # システム管理者のメールアドレス
        "administrator_email",
        # 一時休止開始予定日
        "temp_service_sleep_start_date",
        # 一時休止からの再開予定日
        "temp_service_sleep_restart_date",
        # 停止予定日
        "ndes_service_stop_start_date",
        # 停止からの再開予定日
        "ndes_service_stop_restart_date",
        # 解約理由
        "reason_for_termination",
        # 営業コード
        "salesman_code",
        # 企業名(カナ)
        "company_name_kana",
        # 郵便番号
        "company_zipcode",
        # 住所(都道府県)
        "company_address_pref",
        # 住所1
        "company_address_1",
        # 住所2
        "company_address_2",
        # 住所3
        "company_address_3",
        # 住所1(カナ)
        "company_address_1_kana",
        # 住所2(カナ)
        "company_address_2_kana",
        # 住所3(カナ)
        "company_address_3_kana",
        # 電話番号1
        "company_tel_1",
        # FAX1
        "company_fax_1",
        # 代表者名(姓)
        "company_leader_last",
        # 代表者名(名)
        "company_leader_first",
        # 代表者名(姓)(カナ)
        "company_leader_kana_last",
        # 代表者名(名)(カナ)
        "company_leader_kana_first",
        # 削除フラグ
        "delete_flg",
        "system_usable_flag",
        # 代表者の生年月日
        "company_leader_date_of_birth",
        # フェーズ2 
        # 企業備考欄
        "customer_notes",
        # LOGIN_URL
        "login_url",
        # GMO掛け払いのデータ更新あり
        "need_gmo_ps_creditfacility_modifybuyer",
        # 「来月から一時休止」ボタンを押した際の処理  1
        # 一時休止予定の状態の時に 「来月から再開」ボタンを押した際の処理、「翌日から再開」ボタンを押した際の処理  2
        # 一時休止中の時に 「来月から再開」ボタンを押した際の処理、「翌日から再開」ボタンを押した際の処理  3
        # メール
        "emailType"
    ]
    
    if (itemData["emailType"] == '6'):
        itemData["administrator_email"] = ''
        
    itemData["login_url"] = GV.CONFIG_LOGIN_URL['LOGIN_URL'] 
    
    mail_parameter = {}
    print(itemData)
    
    # 企業情報を取得する
    res_m_company = getMail_t_entry(itemData)
    
    if 'statusCode' in res_m_company and (res_m_company['statusCode'] == 400 or res_m_company['statusCode'] == 500):
        return res_m_company
        
    result_body = json.loads(res_m_company['body'])
    print(result_body)
        
    tmp = {}
    if 'result' in result_body:
        rows = result_body['result']
        for item in rows:
            print(item)
            for key in SEND_EMAIL_FIELD_IDS:
                if key in item:
                    mail_parameter[key] = item[key]
                    if not mail_parameter[key]:
                        mail_parameter[key] = ''
   
    for key in SEND_EMAIL_FIELD_IDS:
        if key in itemData:
            mail_parameter[key] = itemData[key]
            if not mail_parameter[key]:
                mail_parameter[key] = ''
    
            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = itemData[key]
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = itemData[key]

    print(mail_parameter['contract_name_last'])
    print(mail_parameter['contract_name_first'])

    # バグ #2835 ------------------------S
    # # 契約者
    # mail_parameter["to_address"] = []
    # if (mail_parameter["contract_email"]):
    #     mail_parameter["to_address"].append(mail_parameter["contract_email"])
        
    # # システム管理者
    # if (mail_parameter["administrator_email"]):
    #     mail_parameter["to_address"].append(mail_parameter["administrator_email"])
    
    # 1 一時休止の設定完了通知
    # 2 一時休止のキャンセル通知
    # 3 サービスの再開通知
    # 5 サービスの停止通知
    # 7 サービスの一時休止通知
    # 8 利用上限金額を超えたためサービス休止通知
    if mail_parameter["emailType"] in ['1', '2', '3', '5', '7' ,'8']:
        # 契約者
        mail_parameter["to_address"] = []
        if (mail_parameter["contract_email"]):
            mail_parameter["to_address"].append(mail_parameter["contract_email"])
        # システム管理者
        if (mail_parameter["administrator_email"]):
            mail_parameter["to_address"].append(mail_parameter["administrator_email"])
    # 4 サービスの解約通知
    if mail_parameter["emailType"] in ['4']:
        # 契約者
        mail_parameter["to_address"] = []
        if (mail_parameter["contract_email"]):
            mail_parameter["to_address"].append(mail_parameter["contract_email"])
    # バグ #2835 ------------------------E

    # DB t_manage_request
    strService_id = ''
    result_service = get_data_user_infrastructure_t_manage_request_service_id(itemData)
    
    if 'statusCode' in result_service and (result_service['statusCode'] == 400 or result_service['statusCode'] == 500):
        return result_service
    
    result_manage_body = json.loads(result_service['body'])
    if 'result' in result_manage_body:
        rows_manage = result_manage_body['result']
        if len(rows_manage) > 0:
            # 登録済の場合
            strService_id = rows_manage[0]['service_id']
        else:
            strService_id = 'SRV00001'
    
    # Kintoneにしか定義されてない。
    # RDS側にもテーブルにするかどうか？
    # 定数で定義するか？
    mail_parameter["invitation_url"] = 'invitation_url'
    
    if (mail_parameter["emailType"] == '1'):
        result = get_email_template(strService_id, '一時休止の設定完了通知')
    if (mail_parameter["emailType"] == '2'):
        result = get_email_template(strService_id, '一時休止のキャンセル通知')
    if (mail_parameter["emailType"] == '3'):
        result = get_email_template(strService_id, 'サービスの再開通知')
    if (mail_parameter["emailType"] == '4'):
        result = get_email_template(strService_id, 'サービスの解約通知')
    if (mail_parameter["emailType"] == '5'):
        result = get_email_template(strService_id, 'サービスの停止通知')
    if (mail_parameter["emailType"] == '6'):
        result = get_email_template(strService_id, 'サービスの再開事前通知')
    if (mail_parameter["emailType"] == '7'):
        result = get_email_template(strService_id, 'サービスの一時休止通知')
    # -----------障害 #4909 利用料金の上限以上------20231213-------------------S 
    if (mail_parameter["emailType"] == '8'):
        result = get_email_template(strService_id, '上限金額を超えた際の事前通知')
    # -----------障害 #4909 利用料金の上限以上------20231213-------------------E
    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            # print(rows)
            # print(rows[0])
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

#  ステータスが利用中かつデータを取得する。
def get_data_user_infrastructure_m_contract(event, context, strStatus, strType):

    logger.info('get_data_user_infrastructure_m_contract!!!')
    
    dt_now = datetime.datetime.now()
    print(dt_now.strftime('%Y/%m/%d'))

    res = {}

    try:
        # サービスの一時休止 ステータスが利用中かつ一時休止開始予定日に処理を実行する。
        if (strStatus == '利用中' and strType == 'temp_sleep'):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract',
                'queryStringParameters': {
                    'service_usable_status': {
                        'value': strStatus
                    },
                    'temp_service_sleep_start_date': {
                        'value': dt_now.strftime('%Y/%m/%d')
                    }
                }
            }
            
        if (strStatus == '利用中' and strType == 'stop'):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract',
                'queryStringParameters': {
                    'service_usable_status': {
                        'value': strStatus
                    },
                    'ndes_service_stop_start_date': {
                        'value': dt_now.strftime('%Y/%m/%d')
                    }
                }
            }
        # ステータスが利用中   
        if (strStatus == '利用中' and strType == 'restart'):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract_after_restart',
                'queryStringParameters': {
                }
            }    

        if (strStatus == '一時休止' and strType == 'stop'):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract',
                'queryStringParameters': {
                    'service_usable_status': {
                        'value': strStatus
                    },
                    'ndes_service_stop_start_date': {
                        'value': dt_now.strftime('%Y/%m/%d')
                    }
                }
            }
        # -----------障害 #4909 利用料金の上限以上------20231213-------------------S    
        # 現在の利用料金の合計値が利用料金の上限以上   停止処理
        if (strStatus == '停止' and strType == ''):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract_stop',
                'queryStringParameters': {
                }
            }
            
        # 現在の利用料金の合計値が利用料金の上限以上   停止処理
        # サービスの停止中に、現在の利用料金の合計値が利用料金が上限より小さくなったらサービスを利用可能状態
        if (strStatus == '停止' and strType == 'amount_upper_limit'):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract_stop_amount',
                'queryStringParameters': {
                }
            }
        # -----------障害 #4909 利用料金の上限以上------20231213-------------------E
        # # サービスの再開
        # if (strStatus == '' and strType == ''):
        #     input_event = {
        #         'stageVariables': {
        #             'env': GV.ENV
        #         },
        #         'httpMethod': 'GET',
        #         'path': '/rds/user_infrastructure/m_contract',
        #         'queryStringParameters': {
        #         }
        #     }


        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  Db m_contractデータを取得する。
def get_data_infrastructure_m_contract_sql(event, context):

    logger.info('get_data_infrastructure_m_contract_sql!!!')
    
    res = {}

    try:
        
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_contract_sql',
            'queryStringParameters': {
            }
        }


        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  Db m_contractデータを取得する。
def get_notification_data_infrastructure_m_contract_sql(event, context, strSpecifiedNumberDays,strType):

    logger.info('get_notification_data_infrastructure_m_contract_sql!!!')
    
    res = {}

    try:
        
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_contract_notification_sql',
            'queryStringParameters': {
                'specified_number_days': {
                    'value': strSpecifiedNumberDays
                },
                'specified_number_days_type': {
                    'value': strType
                }
            }
        }


        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  Db m_contractデータを取得する。
def get_notification_data2_infrastructure_m_contract_sql(event, context):

    logger.info('get_notification_data2_infrastructure_m_contract_sql!!!')
    
    res = {}

    try:
        
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_contract_notification_sql2',
            'queryStringParameters': {
            }
        }


        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# システム管理者のメールを取得する
def get_data_user_infrastructure_m_user(itemData):

    logger.info('get_data_user_infrastructure_m_user!!!')
    
    res = {}

    try:
          
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_user',
            'queryStringParameters': {
                'company_code': {
                    'value': itemData["company_code"]
                }
            }
        }
    
        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)
    
        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)
    
        res = response
    
        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:
    
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload
    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


# 申込管理情報の環境IDを取得する
def get_data_user_infrastructure_t_manage_request(itemData):

    logger.info('get_data_user_infrastructure_t_manage_request!!!')
    
    res = {}

    try:
          
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_manage_request_sql',
            'queryStringParameters': {
                'company_code': {
                    'value': itemData["company_code"]
                }
            }
        }
    
        Payload = json.dumps(input_event)
        # print("---01: Payload:", Payload)
    
        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        # print("---02: response:", response)
    
        res = response
    
        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:
    
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            # print("---03: body:", Payload)
            res = Payload
    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# 申込管理情報の環service_idを取得する
def get_data_user_infrastructure_t_manage_request_service_id(itemData):

    logger.info('get_data_user_infrastructure_t_manage_request_service_id!!!')
    print(itemData)
    
    res = {}

    try:
          
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_manage_request_service_id_sql',
            'queryStringParameters': {
                'contract_id': {
                    'value': itemData["contract_id"]
                }
            }
        }
    
        Payload = json.dumps(input_event)
        # print("---01: Payload:", Payload)
    
        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        # print("---02: response:", response)
    
        res = response
    
        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:
    
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            # print("---03: body:", Payload)
            res = Payload
    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# # m_companyデータを取得
# def get_data_m_company(itemData):

#     logger.info('get_data_m_company!!!')

#     res = {}

#     try:
#         record = {}
        
#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'GET',
#             'path': '/rds/mscone_lic/m_company',
#             'queryStringParameters': {
#                 'company_code': {
#                     'value': itemData["company_code"]
#                 }
#             }
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             FunctionName='evo-lam-sys-rds',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# m_companyデータを取得
# def get_data_m_company(itemData):

#     logger.info('get_data_m_company!!!')

#     res = {}

#     try:
#         record = {}
        
#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'GET',
#             'path': '/api/m_company_mscone_lic',
#             'queryStringParameters': {
#                 'func': 'get_data_m_company',
#                 'data' : { 
#                     'contract_id': itemData["contract_id"],
#                     'company_code': itemData["company_code"]
#                 }
#             }
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             FunctionName='evo-lam-sys-comn-pf',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# t_entryデータ取得する
def getMail_t_entry(itemData):

    logger.info('getMail_t_entry!!!')

    res = {}

    try:
        
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_entry_mail_sql',
            'queryStringParameters': {
                'company_code': {
                    'value': itemData['company_code']
                }
            }
        }


        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  (user_infrastructure.m_company.system_usable_flag)をitemData['system_usable_flag']にする。
def update_t_manage_request(itemData):

    logger.info('update_t_manage_request!!!')
    logger.info(itemData)

    res = {}

    try:

        record = {}
        
        record['condition_value'] = {
            'company_code': {
                'value': itemData['company_code']
            },
            'contract_id': {
                'value': itemData['contract_id']
            }
        }
        record['new_value'] = {
            'system_usable_flag': {
                'value': itemData['system_usable_flag']
            }
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'PUT',
            'path': '/rds/user_infrastructure/t_manage_request',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# サービスの停止期間管理テーブル(新規)に企業コード、停止開始日を記録する。
def update_post_m_service_stop_history(itemData):

    logger.info('update_post_m_service_stop_history!!!')

    res = {}

    try:

        record_m_service_stop_history = {
            # 企業コード
            'company_code': {
                'value': itemData["company_code"]
            },
            # 停止開始日
            'service_stop_start_date': {
                'value': datetime.datetime.now().strftime('%Y/%m/%d')
            },
            # 環境ID
            'env_id': {
                'value': itemData["env_id"]
            }
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_service_stop_history',
            'body': json.dumps(
                {
                    'record': record_m_service_stop_history
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  (user_infrastructure.m_service_stop_history)に停止終了日(前日)を記録する(企業コードと停止開始日で検索)。
def update_put_temp_m_service_stop_history(itemData):

    logger.info('update_put_temp_m_service_stop_history!!!')
    logger.info(itemData)

    res = {}

    try:

        record = {}
        startDate = ''
        # 停止開始日
        if (itemData['temp_service_sleep_start_date']):
            startDate = itemData['temp_service_sleep_start_date'].split(" ")[0].replace('-','/')
        # 停止終了日(前日)
        dt_now = datetime.datetime.now()
        endDate = (dt_now - timedelta(1)).strftime('%Y/%m/%d')
        
        record['condition_value'] = {
            'company_code': {
                'value': itemData['company_code']
            },
            'service_stop_start_date': {
                'value': startDate
            }
        }
        
        record['new_value'] = {
            'service_stop_end_date': {
                'value': endDate
            },
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'PUT',
            'path': '/rds/user_infrastructure/m_service_stop_history',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  (user_infrastructure.m_service_stop_history)に停止終了日(前日)を記録する(企業コードと停止開始日で検索)。
def update_put_ndes_m_service_stop_history(itemData):

    logger.info('update_put_ndes_m_service_stop_history!!!')
    logger.info(itemData)

    res = {}

    try:

        record = {}
        startDate = ''
        endDate = ''
        dt_now = datetime.datetime.now()
        # 一時休止のみ
        if (itemData['temp_service_sleep_restart_date'] and not itemData['ndes_service_stop_restart_date']):
            # 一時休止予定日
            if (itemData['temp_service_sleep_start_date']):
                startDate = itemData['temp_service_sleep_start_date'].split(" ")[0].replace('-','/')
                # 停止終了日(前日)
                endDate = (datetime.datetime.strptime(itemData['temp_service_sleep_restart_date'].split(" ")[0].replace('-','/'), '%Y/%m/%d') - timedelta(1)).strftime('%Y/%m/%d')
                
        # 停止のみ
        if (itemData['ndes_service_stop_restart_date'] and not itemData['temp_service_sleep_restart_date']):
            # 停止開始日予定日
            if (itemData['ndes_service_stop_start_date']):
                startDate = itemData['ndes_service_stop_start_date'].split(" ")[0].replace('-','/')
                # 停止終了日(前日)
                endDate = (datetime.datetime.strptime(itemData['ndes_service_stop_restart_date'].split(" ")[0].replace('-','/'), '%Y/%m/%d') - timedelta(1)).strftime('%Y/%m/%d')
                
        # 一時休止と停止が重複する場合
        if (itemData['temp_service_sleep_restart_date'] and itemData['ndes_service_stop_restart_date']):
            # 開始日予定日
            if (itemData['temp_service_sleep_start_date']):
                if (itemData['ndes_service_stop_start_date']):
                    if (itemData['ndes_service_stop_start_date'] >= itemData['temp_service_sleep_start_date']):
                        startDate = itemData['ndes_service_stop_start_date'].split(" ")[0].replace('-','/')
                    else:
                        startDate = itemData['temp_service_sleep_start_date'].split(" ")[0].replace('-','/')
                else:
                    startDate = itemData['temp_service_sleep_start_date'].split(" ")[0].replace('-','/')
            else:
                if (itemData['ndes_service_stop_start_date']):
                    startDate = itemData['ndes_service_stop_start_date'].split(" ")[0].replace('-','/')
                    
             # 停止終了日(前日)        
            if (itemData['temp_service_sleep_restart_date'] >= itemData['ndes_service_stop_restart_date']):
                endDate = (datetime.datetime.strptime(itemData['temp_service_sleep_restart_date'].split(" ")[0].replace('-','/'), '%Y/%m/%d') - timedelta(1)).strftime('%Y/%m/%d')
            else:
                endDate = (datetime.datetime.strptime(itemData['ndes_service_stop_restart_date'].split(" ")[0].replace('-','/'), '%Y/%m/%d') - timedelta(1)).strftime('%Y/%m/%d') 
           
        record['condition_value'] = {
            'company_code': {
                'value': itemData['company_code']
            },
            'service_stop_start_date': {
                'value': startDate
            },
            # 環境ID
            'env_id': {
                'value': itemData["env_id"]
            }
        }
        
        record['new_value'] = {
            'service_stop_end_date': {
                'value': endDate
            },
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'PUT',
            'path': '/rds/user_infrastructure/m_service_stop_history',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  DBでサービスのステータスを一時休止にする(停止を優先)。
def update_put_m_contract(itemData,strType):

    logger.info('update_put_m_contract!!!')
    logger.info(itemData)

    res = {}

    try:

        record = {}
        
        record['condition_value'] = {
            'company_code': {
                'value': itemData['company_code']
            },
            'contract_id': {
                'value': itemData['contract_id']
            }
        }
        if (strType == 'temp_restart'):
            record['new_value'] = {
                'temp_service_sleep_start_date': {
                    'value': itemData['temp_service_sleep_start_date']
                },
                'temp_service_sleep_restart_date': {
                    'value': itemData['temp_service_sleep_restart_date']
                }
            }
        if (strType == 'ndes_restart'):
            record['new_value'] = {
                'ndes_service_stop_start_date': {
                    'value': itemData['ndes_service_stop_start_date']
                },
                'ndes_service_stop_restart_date': {
                    'value': itemData['ndes_service_stop_restart_date']
                }
            }
        if (strType == 'notification'):
            record['new_value'] = {
                'pre_notification_resumption_of_service_mael_send_date': {
                    'value': itemData['pre_notification_resumption_of_service_mael_send_date']
                }
            }   
        if (strType == ''):
            record['new_value'] = {
                'service_usable_status': {
                    'value': itemData['service_usable_status']
                },
            }
        # -----------障害 #4909 利用料金の上限以上------20231213-------------------S
        if (strType == 'amount_upper_limit'):
            record['new_value'] = {
                'service_usable_status': {
                    'value': itemData['service_usable_status']
                },
                'ndes_service_stop_start_date': {
                    'value': itemData['ndes_service_stop_start_date']
                }
            }
        # サービスの停止中に、現在の利用料金の合計値が利用料金が上限より小さくなったらサービスを利用可能状態
        if (strType == 'amount_upper_limit_s'):
            record['new_value'] = {
                'ndes_service_stop_restart_date': {
                    'value': itemData['ndes_service_stop_restart_date']
                }
            }
        # -----------障害 #4909 利用料金の上限以上------20231213-------------------E
        
        # -----------障害 #4909 利用料金の上限以上------20240417-------------------S
        if (strType == 'amount_upper_limit_null'):
            record['new_value'] = {
                'temp_service_sleep_start_date': {
                    'value': ''
                },
                'temp_service_sleep_restart_date': {
                    'value': ''
                }
            }
        # -----------障害 #4909 利用料金の上限以上------20240417-------------------E 

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'PUT',
            'path': '/rds/user_infrastructure/m_contract',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# サービスの利用ステータスを判定する
def get_service_usable_status(itemData):

    logger.info('get_service_usable_status!!!')
    tempData1 = ''
    tempData2 = ''
    ndesData1 = ''
    ndesData2 = ''
    retrunStatus = '利用中'
    
    if (itemData['temp_service_sleep_start_date']):
        tempData1 = itemData['temp_service_sleep_start_date'].split(" ")[0].replace('-','/')
    if (itemData['temp_service_sleep_restart_date']):
        tempData2 = itemData['temp_service_sleep_restart_date'].split(" ")[0].replace('-','/')
    if (itemData['ndes_service_stop_start_date']):
        ndesData1 = itemData['ndes_service_stop_start_date'].split(" ")[0].replace('-','/')
    if (itemData['ndes_service_stop_restart_date']):
        ndesData2 = itemData['ndes_service_stop_restart_date'].split(" ")[0].replace('-','/')
    
    dt_now = datetime.datetime.now()
    yyyymmdd = dt_now.strftime('%Y/%m/%d')
    
    if (tempData1 != '' and tempData2 != '' ):
        if (yyyymmdd >= tempData1 and yyyymmdd < tempData2):
            retrunStatus = "一時休止"
            
    if (tempData1 != '' and tempData2 == '' ):
        if (yyyymmdd >= tempData1 ):
          retrunStatus = "一時休止"
          
    if (tempData1 == '' and tempData2 != '' ):
        if (yyyymmdd == tempData1 ):
          retrunStatus = "利用中"
          
    if (ndesData1 != '' and ndesData2 != '' ):
        if (yyyymmdd >= ndesData1 and yyyymmdd < ndesData2):
          retrunStatus = "停止"
        if (yyyymmdd >= ndesData1 and yyyymmdd == ndesData2):
          retrunStatus = "利用中"

    if (ndesData1 != '' and ndesData2 == '' ):
        if (yyyymmdd >= ndesData1 ):
            retrunStatus = "停止"
            
    if (ndesData1 == '' and ndesData2 != '' ):
        if (yyyymmdd == ndesData2 ):
            retrunStatus = "利用中"
            
    # 一時休止中かつ停止中に、停止が終わった場合は、一時休止中になります。
    if (tempData1 != '' and tempData2 == '' and ndesData1 != '' and ndesData2 != ''):
        if (yyyymmdd >= tempData1 and yyyymmdd >= ndesData1 and yyyymmdd >= ndesData2):
            retrunStatus = "一時休止"
    
    # 一時休止中かつ停止中に、一時休止が終わった場合は、停止中になります。
    if (tempData1 != '' and tempData2 != '' and ndesData1 != '' and ndesData2 == ''):
        if (yyyymmdd >= tempData1 and yyyymmdd < tempData2 and yyyymmdd >= ndesData1):
            retrunStatus = "停止"

    return retrunStatus

# 利用料金が上限より小さくなる サービスの利用ステータスを判定する
def get_service_usable_status_amount(itemData):

    logger.info('get_service_usable_status_amount!!!')
    tempData1 = ''
    tempData2 = ''
    ndesData1 = ''
    ndesData2 = ''
    retrunStatus = '利用中'
    
    if (itemData['temp_service_sleep_start_date']):
        tempData1 = itemData['temp_service_sleep_start_date'].split(" ")[0].replace('-','/')
    if (itemData['temp_service_sleep_restart_date']):
        tempData2 = itemData['temp_service_sleep_restart_date'].split(" ")[0].replace('-','/')
    if (itemData['ndes_service_stop_start_date']):
        ndesData1 = itemData['ndes_service_stop_start_date'].split(" ")[0].replace('-','/')
    if (itemData['ndes_service_stop_restart_date']):
        ndesData2 = itemData['ndes_service_stop_restart_date'].split(" ")[0].replace('-','/')
    
    dt_now = datetime.datetime.now()
    yyyymmdd = dt_now.strftime('%Y/%m/%d')
    
    if (tempData1 != '' and tempData2 != '' ):
        if (yyyymmdd >= tempData1 and yyyymmdd < tempData2):
            retrunStatus = "一時休止"
            
    if (tempData1 != '' and tempData2 == '' ):
        if (yyyymmdd >= tempData1 ):
          retrunStatus = "一時休止"
          
    if (tempData1 == '' and tempData2 != '' ):
        if (yyyymmdd == tempData1 ):
          retrunStatus = "利用中"
          
    if (ndesData1 != '' and ndesData2 != '' ):
        if (yyyymmdd >= ndesData1 and yyyymmdd < ndesData2):
          retrunStatus = "停止"
        if (yyyymmdd >= ndesData1 and yyyymmdd == ndesData2):
          retrunStatus = "利用中"

    if (ndesData1 != '' and ndesData2 == '' ):
        if (yyyymmdd >= ndesData1 ):
            retrunStatus = "停止"
            
    if (ndesData1 == '' and ndesData2 != '' ):
        if (yyyymmdd == ndesData2 ):
            retrunStatus = "利用中"

    return retrunStatus

# 一時休止からの再開予定日場合と停止からの再開予定日場合のチェック 
def data_restart_pre_notification_check(strData1,strData2,strType):

    logger.info('data_restart_pre_notification_check!!!')

    retrunStatus = 'false'
    
    if (strData2):
        if (strData1 >= strData2):
            retrunStatus = 'true'
    else:
        retrunStatus = 'true'
    
    # 「一時休止からの再開予定日」と「停止からの再開予定日」が同じ日付の場合 メール1件
    if (strData1 == strData2 and strType == '2'):
        retrunStatus = 'false'
    
    return retrunStatus

#  DBでm_contract更新    
def update_m_contract():

    logger.info('update_m_contract!!!')

    res = {}

    try:

        record_m_contract = {}

        record_m_contract["invoice_sending_method"] = {}

        # 契約ID
        record_m_contract['contract_id'] = record["contract_id"]
        # 企業コード
        record_m_contract['company_code'] = record["company_code"]

        record_m_contract['subscription_start_date'] = record["subscription_start_date"]
        record_m_contract['subscription_end_date'] = record["subscription_end_date"]
        record_m_contract['subscription_name'] = record["subscription_name"]
        record_m_contract['contract_name'] = record["contract_name"]
        record_m_contract['contract_name_kana'] = record["contract_name_kana"]
        record_m_contract['postal_address'] = record["postal_address"]
        record_m_contract['contract_zipcode'] = record["contract_zipcode"]
        record_m_contract['contract_address_pref'] = record["contract_address_pref"]
        record_m_contract['contract_address_1'] = record["contract_address_1"]
        record_m_contract['contract_tel_1'] = record["contract_tel_1"]
        record_m_contract['contract_email'] = record["contract_email"]
        record_m_contract['contract_department'] = record["contract_department"]
        record_m_contract['salesman_name'] = record["salesman_name"]
        record_m_contract['payment_method'] = record["payment_method"]
        record_m_contract['salesman_code'] = record["salesman_code"]
        record_m_contract['invoice_sending_method'] = record["invoice_sending_method"]
        
        # 一時休止予定日
        record_m_contract['temp_service_sleep_start_date'] = record["temp_service_sleep_start_date"]
        # 一時休止からの再開予定日
        record_m_contract['temp_service_sleep_restart_date'] = record["temp_service_sleep_restart_date"]
        # 解約理由
        record_m_contract['reason_for_termination'] = record["reason_for_termination"]
        
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_contract',
            'body': json.dumps(
                {
                    'record': record_m_contract
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

#  メール送信情報を設定
def send_email(mail_template, mail_parameter):
    from_address = ''
    to_address = []
    cc_address = []
    bcc_address = []
    title = ""
    message = ""

    if "mail_send_from" in mail_template:
        from_address = mail_template["mail_send_from"]

    if not from_address:
        return error_400("送信元アドレスが設定されていません。")

    if "mail_to" in mail_template:
        if not mail_template["mail_to"] is None and len(mail_template["mail_to"]) > 0:
            arr_value = mail_template["mail_to"].split(';')
            for val in arr_value:
                to_address.append(val)

    if "to_address" in mail_parameter:
        to_address.extend(mail_parameter["to_address"])
        set(to_address)

    if len(to_address) < 1:
        return error_400("宛先アドレスが設定されていません。")

    if "mail_cc" in mail_template:
        if not mail_template["mail_cc"] is None and len(mail_template["mail_cc"]) > 0:
            arr_value = mail_template["mail_cc"].split(';')
            for val in arr_value:
                cc_address.append(val)

    if "cc_address" in mail_parameter:
        cc_address.extend(mail_parameter["cc_address"])
        set(cc_address)

    if "mail_bcc" in mail_template:
        if not mail_template["mail_bcc"] is None and len(mail_template["mail_bcc"]) > 0:
            arr_value = mail_template["mail_bcc"].split(';')
            for val in arr_value:
                bcc_address.append(val)

    if "bcc_address" in mail_parameter:
        bcc_address.extend(mail_parameter["bcc_address"])
        set(bcc_address)

    if "mail_subject" in mail_template:
        title = mail_template["mail_subject"]

    if not title:
        return error_400("メールのタイトルが空です。")

    if "mail_body" in mail_template:
        message = mail_template["mail_body"]

    if not message:
        return error_400("メールの本文が空です。")

    if 'to_address' in mail_parameter:
        del mail_parameter['to_address']
    if 'cc_address' in mail_parameter:
        del mail_parameter['cc_address']
    if 'bcc_address' in mail_parameter:
        del mail_parameter['bcc_address']

    for key in mail_parameter:
        title = title.replace("{{" + key + "}}", mail_parameter[key])

    for key in mail_parameter:
        message = message.replace("{{" + key + "}}", mail_parameter[key])

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/email/send',
            'body': json.dumps(
                {
                    'from_address': from_address,
                    'to_address': to_address,
                    'cc_address': cc_address,
                    'bcc_address': bcc_address,
                    'title': title,
                    'message': message
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-email',
            FunctionName='prod-lam-sys-email',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

logger.debug('# ************0704******************') 
def get_data_from_user_infrastructure_m_auth0_management(event):

    logger.info('get_data_from_user_infrastructure_m_auth0_management!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        strservice = ''
        strCompany_code = ''
        tmp = {}
    
        if 'serviceId' in query_string_parameters:
            if type(query_string_parameters['serviceId']) is str:
                tmp = json.loads(query_string_parameters['serviceId'])
                if 'value' in tmp:
                    strservice = tmp['value']
            else:
                if 'value' in query_string_parameters['serviceId']:
                    strservice = query_string_parameters['serviceId']['value']
        if (strservice == ''):
            strservice = record["serviceId"]['value']
            
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    strCompany_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    strCompany_code = query_string_parameters['company_code']['value']
        if (strCompany_code == ''):
            strCompany_code = record["company_code"]['value']
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_auth0_management',
            'queryStringParameters': {
                 'service': {
                    'value': strservice
                },
                'company_code': {
                    'value': strCompany_code
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_data_from_user_infrastructure_m_auth0_management_list(event):

    logger.info('get_data_from_user_infrastructure_m_auth0_management_list!!!')
    
    logger.info(event)

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        strtenant = ''
        tmp = {}
    
        if 'tenant' in query_string_parameters:
            if type(query_string_parameters['tenant']) is str:
                tmp = json.loads(query_string_parameters['tenant'])
                if 'value' in tmp:
                    strtenant = tmp['value']
            else:
                if 'value' in query_string_parameters['tenant']:
                    strtenant = query_string_parameters['tenant']['value']
        
        if strtenant == '':
            event_body = {}
            if 'body' in event and event['body'] is not None:
                event_body = json.loads(event['body'])
                logger.info(event_body)
    
                tmp = event_body['record']
                if "tenant" in tmp and "value" in tmp["tenant"]:
                    strtenant = tmp["tenant"]['value']
                
        if (strtenant != ''):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_auth0_management_list',
                'queryStringParameters': {
                     'tenant': {
                        'value': strtenant
                    }
                }
            }
    
            Payload = json.dumps(input_event)
            print("---01: Payload:", Payload)
    
            # 呼び出し
            response = boto3.client('lambda').invoke(
                FunctionName='prod-lam-sys-rds',
                InvocationType='RequestResponse',
                Payload=Payload
            )
            print("---02: response:", response)
    
            res = response
    
            result = None
            if 'StatusCode' in response and response['StatusCode'] == 200:
    
                # レスポンス読出し
                Payload = json.loads(response['Payload'].read())
                print("---03: body:", Payload)
                res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

logger.debug('# ************0704******************') 

#  メール送信
def get_email_template(service_id, mail_type):

    logger.info('get_email_template!!!')

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_send_mail',
            'queryStringParameters': {
                'service_id': service_id,
                'mail_type': mail_type,
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# #  メール送信
# def get_invitation_code(event, context):

#     logger.info('get_invitation_code!!!')

#     res = {}

#     try:

#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'GET',
#             'path': '/common/invitation_code',
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             FunctionName='lam-sys-common',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# 画面側にサービスの一時休止が申し込まれた旨メール送信 契約者、システム管理者
def send_update_next_month_email(event, context):
    logger.info('send_update_next_month_email!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 申込番号
        "entry_code",
        # 企業コード
        "company_code",
        # 企業名
        "company_name",
        # 契約者部署名
        "contract_department",
        # 契約者名 姓
        "contract_last_name",
        # 契約者名 名
        "contract_first_name",
        # 契約者役職
        "contract_position",
        # 契約者のメールアドレス
        "contract_email",
        # 担当営業名
        "salesman_name",
        # システム管理者名 姓
        "administrator_name_last",
        # システム管理者名 名
        "administrator_name_first",
        # システム管理者のメールアドレス
        "administrator_email",
        # 一時休止開始予定日
        "temp_service_sleep_start_date",
        # 一時休止からの再開予定日
        "temp_service_sleep_restart_date",
        # 解約理由
        "reason_for_termination",
        # メール解約申込日
        "today",
        # 「来月から一時休止」ボタンを押した際の処理  1
        # 一時休止予定の状態の時に 「来月から再開」ボタンを押した際の処理、「翌日から再開」ボタンを押した際の処理  2
        # 一時休止中の時に 「来月から再開」ボタンを押した際の処理、「翌日から再開」ボタンを押した際の処理  3
        # メール
        "emailType"
    ]

    mail_parameter = {}

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']

    print(mail_parameter['contract_name_last'])
    print(mail_parameter['contract_name_first'])

    # 契約者
    mail_parameter["to_address"] = []
    mail_parameter["to_address"].append(mail_parameter["contract_email"])
    # システム管理者
    mail_parameter["to_address"].append(mail_parameter["administrator_email"])
    # メール解約申込日
    dt_now = datetime.datetime.now()
    yyyymmdd = dt_now.strftime('%Y/%m/%d')
    mail_parameter["today"] = yyyymmdd
    

    # Kintoneにしか定義されてない。
    # RDS側にもテーブルにするかどうか？
    # 定数で定義するか？
    mail_parameter["invitation_url"] = 'invitation_url'
    
    if (mail_parameter["emailType"] == '1'):
        result = get_email_template(record["service_id"]['value'], '一時休止の設定完了通知')
    if (mail_parameter["emailType"] == '2'):
        result = get_email_template(record["service_id"]['value'], '一時休止のキャンセル通知')
    if (mail_parameter["emailType"] == '3'):
        result = get_email_template(record["service_id"]['value'], 'サービスの利用再開設定完了通知')
    if (mail_parameter["emailType"] == '4'):
        result = get_email_template(record["service_id"]['value'], 'サービスの解約申込完了通知')
    
    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            # print(rows)
            # print(rows[0])
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# エラー発生通知 S
def send_email_on_error(func_name, err):

    logger.info('send_email_on_error!!!')
    logger.info(err)

    import traceback
    traceback.print_exc()

    error_message = ''
    error_message = '\n'
    # 関数名
    error_message += '【関数名】' + '\n'
    error_message += func_name + '\n'
    # エラー内容
    error_message += '【エラー内容】' + '\n'
    tmp = traceback.format_exc()
    print('tmp')
    print(tmp)
    print('tmp')
    if str.strip(tmp) != 'NoneType: None':
        error_message += tmp
    if 'error' in err:
        error_message += err['error'] + '\n'
    if 'message' in err:
        error_message += err['message'] + '\n'
    record['error_message'] = {}
    record['error_message']['value'] = error_message

    SEND_EMAIL_FIELD_IDS = [
        # エラーメッセージ
        'error_message',
        # # 申込番号
        # 'entry_code',
        # 企業コード
        'company_code',
        # 会社名
        'company_name',
        # 契約者名
        'contract_last_name',
        'contract_first_name'
    ]

    mail_parameter = {}

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

    # mail_parameter['error_message'] = 'test'

    result = get_email_template('SRV00001', 'エラー発生通知')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# 更新履歴の追加 S
def insert_m_update_company_info_history():

    logger.info('insert_m_update_company_info_history!!!')

    res = {}

    try:

        # 更新履歴ID
        # record["update_history_id"] = -
        # 企業コード
        record["company_code"] = record["company_code"]
        # Auth0ユーザーID
        record["auth0_user_id"] = record["auth0_user_id"]
        # 名前(姓)
        record["name_last"] = {}
        record["name_last"] = record["administrator_name_last"]
        # 名前(名)
        record["name_first"] = {}
        record["name_first"] = record["administrator_name_first"]
        # メールアドレス
        record["email"] = {}
        record["email"] = record["administrator_email"]
        # 更新元
        record["update_from"] = {}
        record["update_from"]["value"] = 'サービス一時休止サイト'
        # 一時休止開始予定日
        record["temp_service_sleep_start_date"] =  record["temp_service_sleep_start_date"]
        # 一時休止からの再開予定日
        record["temp_service_sleep_restart_date"] =  record["temp_service_sleep_restart_date"]
        # 更新日時
        # record["update_date"] = {}
        # record["update_date"]["value"] = datetime.datetime.now()

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_update_company_info_history',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# ------------------------------------
# t_entry S

def get_data_from_user_infrastructure_t_entry(event, context):

    logger.info('get_data_from_user_infrastructure_t_entry!!!')

    result = {}

    try:

        # ------------------------------------
        # DB 
        # service_id_system_idを取得する
        result = get_data_service_id_system_id(event, context)
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result

        result_body = json.loads(result['body'])
        print(result_body)
        
        tmp = {}
        strService_id = ""
        strSystem_id = ""
        if 'result' in result_body:
            rows = result_body['result']
            strService_id = rows[0]['service_id']
            strSystem_id = rows[0]['system_id']
        # ------------------------------------
        
        # DB 
        # 
        result = get_data_from_user_infrastructure_t_manage_request(event, context, strService_id, strSystem_id)
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        result_body = json.loads(result['body'])
        
        # ユーザー権限のチェック
        #  admin_user アプリ側のシステム管理者
        if (user_data_role_cheku(event, result_body['result']) == False):
            msg = 'アクセス権限がありません。'
            return error_400(msg)


    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return result

# t_entry E

# ユーザー権限のチェック
def user_data_role_cheku(event,listData):
    logger.info('user_data_role_cheku!!!')

    resType = False
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        access_token_info = get_access_token_info(event_headers["Authorization"])
        if 'user_metadata' not in access_token_info :
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        for metadataList in access_token_info['user_metadata']['data']:
            if 'company_code' in metadataList and 'system_id' in metadataList and 'service_id' in metadataList:
                if listData[0]['company_code'] == metadataList['company_code'] and listData[0]['system_id']  == metadataList['system_id'] and listData[0]['service_id']  == metadataList['service_id'] :
                    if GV.CONFIG['AUTH0_ROLES']['ROLES_ADMIN_USER'] in metadataList['roles']:
                        resType = True
                        return resType
    return resType

def get_data_from_user_infrastructure_t_manage_request(event, context, strService_id, strSystem_id):

    logger.info('get_data_from_user_infrastructure_t_manage_request!!!')

    res = {}

    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None:
            event_body = json.loads(event['body'])
            logger.info(event_body)

            tmp = event_body['record']
            if "auth0_user_id" in tmp and "value" in tmp["auth0_user_id"]:
                record["auth0_user_id"]["value"] = tmp["auth0_user_id"]["value"]

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        auth0_user_id = None
        if 'auth0_user_id' in query_string_parameters:
            if type(query_string_parameters['auth0_user_id']) is str:
                tmp = json.loads(query_string_parameters['auth0_user_id'])
                if 'value' in tmp:
                    auth0_user_id = tmp['value']
            else:
                if 'value' in query_string_parameters['auth0_user_id']:
                    auth0_user_id = query_string_parameters['auth0_user_id']['value']
                    
        if auth0_user_id is not None:
            record["auth0_user_id"]["value"] = auth0_user_id
            
        
        company_code = None
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    company_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    company_code = query_string_parameters['company_code']['value']
                    
        if company_code is not None:
            record["company_code"]["value"] = company_code
                

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_entry',
            'queryStringParameters': {
                'auth0_user_id': {
                    'value': record["auth0_user_id"]["value"]
                },
                'service_id': {
                    'value': strService_id
                },
                'system_id': {
                    'value': strSystem_id
                },
                'company_code': {
                    'value': record["company_code"]["value"]
                },
                 'tenant': {
                    'value': GV.CONFIG['AUTH0_TENANT']
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# 
def get_data_service_id_system_id(event, context):

    logger.info('get_data_service_id_system_id!!!')
    res = {}

    try:
        
        serviceId = None
        strService_name = ''
        strSystem_name = ''
        event_body = {}

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
            if 'serviceId' in query_string_parameters:
                if type(query_string_parameters['serviceId']) is str:
                    tmp = json.loads(query_string_parameters['serviceId'])
                    if 'value' in tmp:
                        serviceId = tmp['value']
                else:
                    if 'value' in query_string_parameters['serviceId']:
                        serviceId = query_string_parameters['serviceId']['value']
                    

            company_code = None
            if 'company_code' in query_string_parameters:
                if type(query_string_parameters['company_code']) is str:
                    tmp = json.loads(query_string_parameters['company_code'])
                    if 'value' in tmp:
                        company_code = tmp['value']
                else:
                    if 'value' in query_string_parameters['company_code']:
                        company_code = query_string_parameters['company_code']['value']
                        
            if company_code is not None:
                record["company_code"]["value"] = company_code
        # logger.info(serviceId)    
        strService_name = GV.CONFIG_SYSTEM_SERVICE[serviceId]['service_name']
        strSystem_name = GV.CONFIG_SYSTEM_SERVICE[serviceId]['system_name']
        # logger.info(strService_name)
        # logger.info(strSystem_name)

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/service_id_system_id_SQL',
            'queryStringParameters': {
                'service_name': {
                    'value': strService_name
                },
                'system_name': {
                    'value': strSystem_name
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# ------------------------------------

#  エラー処理
def error_400(message, code=None):
    body = {
        'error_code': code,
        'error_message': message
    }
    return {
        'statusCode': 400,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(body)
    }

#  処理
def get_value(key, items):

    value = None

    if key in items:

        # Kintoneからのデータの場合
        if 'value' in items[key]:
            value = items[key]['value']
        else:
            value = items[key]

        if isinstance(value, str):
            value = value.strip()

    return value

#  処理
def set_value(key, value, items):

    if key in items:
        # Kintoneからのデータの場合
        if 'value' in items[key]:
            items[key]['value'] = value
        else:
            items[key] = value

    return items

#  処理
def validate(def_validation, record):

    for key in def_validation:

        item = def_validation[key]

        value = get_value(key, record)

        if 'label' not in item or \
            'is_required' not in item or \
            'min' not in item or \
                'max' not in item:
            return f'''システムエラー'''
        if 'is_date' in item and \
                ('date_format' not in item or 'date_format_description' not in item):
            return f'''システムエラー'''

        label = item['label']
        if value is None or value == '':
            if item['is_required']:
                return f'''「{label}」を指定してください。'''
            else:
                if 'is_not_null' in item and item['is_not_null']:
                    if value is None:
                        if 'is_intger' in item and item['is_intger']:
                            value = 0
                        else:
                            value = ''
                else:
                    if value is None:
                        pass
                    elif value == '':
                        value = None
                        pass
        else:
            if 'is_email' in item and item['is_email']:
                import re
                pattern = "^[A-Za-z0-9]{1}[A-Za-z0-9_.-]*@{1}[A-Za-z0-9_.-]{1,}\.[A-Za-z0-9]{1,}$"
                if ';' in value:
                    for v in value.split(';'):
                        if re.match(pattern, v):
                            pass
                        else:
                            return f'''「{label}」を正しく指定してください。(メールアドレス)'''
                else:
                    if re.match(pattern, value):
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。(メールアドレス)'''
            elif 'is_intger' in item and item['is_intger']:
                try:
                    value = int(value)
                except Exception as err:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                except TypeError:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                except ValueError:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if isinstance(value, int) == False:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if value < int(item['min']) or value > int(item['max']):
                    return f'''「{label}」を正しく指定してください。最小値:{item['min']}～最大値:{item['max']}'''
            elif 'is_bool' in item and item['is_bool']:
                try:
                    if str(value).lower() in ['true', 'false', '0', '1']:
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。'''
                except ValueError:
                    return f'''「{label}」を正しく指定してください。'''
            else:
                if item['min'] == 0 and item['max'] == 0:
                    pass
                elif len(value) < item['min'] or len(value) > item['max']:
                    return f'''「{label}」を正しく指定してください。({item['max']}桁)'''

                if 'is_date' in item and item['is_date']:
                    if 'date_format' in item:
                        try:
                            datetime.datetime.strptime(
                                value, item['date_format'])
                        except ValueError:
                            if 'date_format_description' in item:
                                return f'''「{label}」を正しく指定してください。({item['date_format_description']})'''
                            else:
                                return f'''「{label}」を正しく指定してください。'''
                if 'is_in' in item and item['is_in']:
                    if value not in item['is_in']:
                        return f'''「{label}」を正しく指定してください。'''

        set_value(key, value, record)

    return True
