import os
import json
import inspect

from common.auth0.v2.component import Auth0Component
from common.auth0.v2.parameters import *

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

import global_value as GV

RESPONSE_HEADERS = GV.RESPONSE_HEADERS

from error_function import error_handling

# 設定ファイル
import boto3
# BUCKET_NAME = 'env-mcl-mgmt'
# PATH_NAME = 'user-infrastructure/'
# OBJECT_KEY_NAME = 'config.json'
s3 = boto3.resource('s3')

def lambda_handler(event, context):
    
    print(event)
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if event['stageVariables']['env'] is None:
            res = {}
            res['error_code'] = ''
            res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
            return {
                'statusCode': 500,
                'headers': RESPONSE_HEADERS,
                'body': json.dumps(res)
            }
        
        GV.ENV = event['stageVariables']['env'].upper()

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/'
        OBJECT_KEY_NAME = 'config.json'
        
        bucket = s3.Bucket(BUCKET_NAME)
        obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
        response = obj.get()    
        body = response['Body'].read()
        ENV_CONFIG = json.loads(body.decode('utf-8'))
        
        GV.CONFIG['AUTH0_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_AUDIENCE']
        GV.CONFIG['AUTH0_CLIENT_ID'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_ID']
        GV.CONFIG['AUTH0_CLIENT_SECRET'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_SECRET']
        GV.CONFIG['AUTH0_DOMAIN'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_DOMAIN']
        GV.CONFIG['API_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'API_AUDIENCE']
        
        res = {}
        
        if event['httpMethod'] == 'GET':
            if event['path'] == '/auth0/get_users_by_email/' or event['path'] == '/auth0/get_users_by_email':
                res = get_users_by_email(event, context)
        elif event['httpMethod'] == 'POST':
            if event['path'] == '/auth0/assign_roles_to_a_user' or event['path'] == '/auth0/assign_roles_to_a_user/':
                res = assign_roles_to_a_user(event, context)
            elif event['path'] == '/auth0/change_user_block_status' or event['path'] == '/auth0/change_user_block_status/':
                res = change_user_block_status(event, context)
            # フェーズ2 ------------------------S
            elif event['path'] == '/auth0/remove_roles_from_a_user' or event['path'] == '/auth0/remove_roles_from_a_user/':
                res = remove_roles_from_a_user(event, context)
            # フェーズ2 ------------------------E
            else:
                res = create_user(event, context)
        elif event['httpMethod'] == 'PUT':
            res = update_user(event, context)
        elif event['httpMethod'] == 'DELETE':
            res = delete_user(event, context)
            
        tmp = {}
        if 'getheaders' in dir(res):
            headers = {}
            for header in res.getheaders():
                headers[header[0]] = header[1]
            tmp = {
                # "statusCode": res.getcode(),
                "statusCode": 200,
                "headers": headers,
                "body": res.readline().decode( "UTF-8" ),
                "isBase64Encoded": False
            };
        else:
            # tmp = {
            #     "statusCode": 200,
            #     "headers": {},
            #     "body": json.dumps(res),
            #     "isBase64Encoded": False
            # };
            tmp = res
        logger.debug(tmp)
        
        res = tmp

        logger.info(res)

        return res
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

def create_user(event, context):
    
    logger.info('create_user!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        auth0 = Auth0Component(GV.CONFIG)
        users_param = CreateUserParam()
        users_param.user_id = event_body['email'] #???!!! バグ #2113対応
        users_param.email = event_body['email']
        users_param.blocked = event_body['blocked']
        users_param.connection = event_body['connection']
        users_param.given_name = event_body['given_name']
        users_param.family_name = event_body['family_name']
        users_param.password = event_body['password']
        users_param.verify_email = event_body['verify_email']
        users_param.username = event_body['username']
        # users_param.user_metadata = {
        #     # "activedirectory_username": "「企業ID（新業務企業）」+「.user000@simulation.space」",
        #     # "appstream_stackname": "「mscone-appstream-stack-activedirectory-」＋「企業ID（新業務企業）」"
        #     # フェーズ2 ------------------------S
        #     # 'activedirectory_username': event_body['company_code'] + '.user000@simulation.space',
        #     # 'appstream_stackname': 'mscone-appstream-stack-activedirectory-' + event_body['company_code']
        #     # 課題 #2636
        #     # 開発環境のAuth0のmetadataのドメイン、スタック名の指定を変更する必要がある
        #     # ・ドメイン
        #     # 本番：simulation.space
        #     # 開発：appstream.msc
        #     # ・スタック名
        #     # 本番：appstream_stackname
        #     # 開発：stack
        #     'activedirectory_username': event_body['company_code'] + '.user000@appstream.msc',
        #     'stack': 'mscone-appstream-stack-activedirectory-' + event_body['company_code']
        #     # フェーズ2 ------------------------E
        # }
        new_user = auth0.create_user(users_param)
        
        res = new_user
        print(res)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return res

# def assign_roles_to_a_user(event, context):
    
#     logger.info('assign_roles_to_a_user!!!')
    
#     res = {}
#     res['error_code'] = None
#     res['error_message'] = None
    
#     try:
        
#         event_body = {}
#         event_body = json.loads(event['body'])
        
#         user_id = ''
#         if 'user_id' in event_body:
#             user_id = event_body['user_id']
#         else:
#             res = {}
#             res['error_code'] = ''
#             res['error_message'] = '「user_id」が指定されていません。'
#             return {
#                 'statusCode': 400,
#                 'headers': RESPONSE_HEADERS,
#                 'body': json.dumps(res)
#             }
        
#         assign_role_ids = []
#         if 'assign_role_ids' in event_body:
#             assign_role_ids = event_body['assign_role_ids']
#         else:
#             assign_role_ids.append(GV.CONFIG['AUTH0_ROLE_IDS']['ROLES_MEMBER_ADMINISTRATOR'])
        
#         auth0 = Auth0Component(GV.CONFIG)
               
#         res = auth0.assign_roles_to_a_user(user_id, assign_role_ids)
        
#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)
    
#     return res

# フェーズ2 ------------------------S
def remove_roles_from_a_user(event, context):
    
    logger.info('remove_roles_from_a_user!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        user_id = ''
        if 'user_id' in event_body:
            user_id = event_body['user_id']
        else:
            res = {}
            res['error_code'] = ''
            res['error_message'] = '「user_id」が指定されていません。'
            return {
                'statusCode': 400,
                'headers': RESPONSE_HEADERS,
                'body': json.dumps(res)
            }
        
        remove_role_ids = []
        if 'remove_role_ids' in event_body:
            remove_role_ids = event_body['remove_role_ids']
        
        auth0 = Auth0Component(GV.CONFIG)
               
        res = auth0.remove_roles_from_a_user(user_id, remove_role_ids)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return res
# フェーズ2 ------------------------E

def update_user(event, context):
    
    logger.info('update_user!!!')
    
    res = {}
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        auth0 = Auth0Component(GV.CONFIG)
        auth0_update_condition = UpdateUserParam()
        auth0_update_condition.id = event_body['auth0_user_id']
        auth0_update_condition.email = event_body['email'] # ???
        auth0_update_condition.user_metadata = event_body['user_metadata']
        auth0_update_condition.given_name = event_body['given_name']
        auth0_update_condition.family_name = event_body['family_name']
        auth0_update_condition.blocked = False
        # auth0_update_condition.user_metadata = {
        #     # "activedirectory_username": "「企業ID（新業務企業）」+「.user000@simulation.space」",
        #     # "appstream_stackname": "「mscone-appstream-stack-activedirectory-」＋「企業ID（新業務企業）」"
        #     # フェーズ2 ------------------------S
        #     # 'activedirectory_username': event_body['company_code'] + '.user000@simulation.space',
        #     # 'appstream_stackname': 'mscone-appstream-stack-activedirectory-' + event_body['company_code']
        #     # 課題 #2636
        #     # 開発環境のAuth0のmetadataのドメイン、スタック名の指定を変更する必要がある
        #     # ・ドメイン
        #     # 本番：simulation.space
        #     # 開発：appstream.msc
        #     # ・スタック名
        #     # 本番：appstream_stackname
        #     # 開発：stack
        #     'activedirectory_username': event_body['company_code'] + '.user000@appstream.msc',
        #     'stack': 'mscone-appstream-stack-activedirectory-' + event_body['company_code']
        #     # フェーズ2 ------------------------E
        # }
        res = auth0.update_user(auth0_update_condition)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res
    
def delete_user(event, context):
    
    logger.info('delete_user!!!')
    
    res = {}
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if 'auth0_user_id' in query_string_parameters:
            #削除
            auth0 = Auth0Component(GV.CONFIG)
            auth0_update_condition = UpdateUserParam()
            auth0_update_condition.id = query_string_parameters['auth0_user_id']
            
            res = auth0.delete_user(auth0_update_condition)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


def get_users_by_email(event, context):
    
    logger.info('get_users_by_email!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if 'email' in query_string_parameters:
            auth0 = Auth0Component(GV.CONFIG)
            users_param = GetUsersByEmailParam()
            users_param.email = query_string_parameters['email']
            # フェーズ2 ------------------------S
            # users_param.fields = 'username,user_id'
            # ・入力されたのがAuth0に登録済みのメールアドレスならAuth0に再登録せずに、
            # ログイン用のURLを記載したメールを送信する。ブロックされていた場合は有効化する。
            users_param.fields = 'username,user_id,blocked'
            # フェーズ2 ------------------------E
            users = auth0.get_users_by_email(users_param)
            
            res = users
        else:
            res['error_code'] = 400
            res['error_message'] = 'メールアドレスが指定されていません。'
            
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return res

def change_user_block_status(event, context):
    
    logger.info('change_user_block_status!!!')
    
    res = {}
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
                    
        auth0 = Auth0Component(GV.CONFIG)
        auth0_update_condition = UpdateUserParam()
        auth0_update_condition.id = event_body['auth0_user_id']
        auth0_update_condition.blocked = event_body['blocked']
        res = auth0.update_user(auth0_update_condition)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res