import boto3
from botocore.exceptions import ClientError

class MailComponent:

    def sendmail_text(self, from_address, to_address, bcc_address, title, text, return_path):
        client = boto3.client('ses', region_name='ap-northeast-1')
        try:
            response = client.send_email(
                Source = from_address,
                Destination = {
                    'ToAddresses': to_address,
                    #'CcAddresses': [
                    #    'CC_ADDRESS@example.com',
                    #],
                    'BccAddresses': bcc_address
                },
                Message = {
                    'Subject': {
                        'Data': title,
                        'Charset': 'UTF-8'
                    },
                    'Body': {
                        'Text': {
                            'Data': text,
                            'Charset': 'UTF-8'
                        }#,
                        #'Html': {
                        #    'Data': '<h1>This is Html Mail</h1>',
                        #    'Charset': 'UTF-8'
                        #}
                    }
                },
                ReturnPath = return_path
            )
            return response
        except ClientError as e:
            print(e.response['Error']['Message'])
        else:
            print("Email sent! Message ID:"),
            print(response['MessageId'])