from src.component.common.entraid.component import Auth0Component
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.model.platform import user_infrastructure as pui
from src.component.model.simsp import mscone_lic as sml
from src.component.common.constants import constants
import string
import secrets
import requests
from flask import Flask, Blueprint, render_template, current_app
from src.component.common.mail import mail
from src.component.common.pdbc import pdbc
from src.component.common.pdbc import db_hosts
from src.component.common.aws import aws
import datetime
from pytz import timezone

def get_trial_systemusableflag(company_code, user_id):
     print('引数企業コード[get_systemusableflag]: ' + company_code)
     print('current_app_config ; ' + current_app.config['SYSTEM_ID'])
     return pdbc.select_param(db_hosts.platform(),
             '''
                 SELECT
                     system_usable_flag
                 FROM
                     user_infrastructure.t_manage_request uitmr
                 WHERE
                     uitmr.company_code = %(company_code)s
                 AND
                     uitmr.system_id = %(system_id)s
                 AND 
                     uitmr.auth0_user_id =  %(user_id)s
             ''', {'company_code' : company_code, 'system_id' : current_app.config['SYSTEM_ID'], 'user_id': user_id})[0]['system_usable_flag']

def get_systemusableflag(company_code):
     print('引数企業コード[get_systemusableflag]: ' + company_code)
     print('current_app_config ; ' + current_app.config['SYSTEM_ID'])
     return pdbc.select_param(db_hosts.platform(),
             '''
                 SELECT
                     system_usable_flag
                 FROM
                     user_infrastructure.t_manage_request uitmr
                 WHERE
                     uitmr.company_code = %(company_code)s
                 AND
                     uitmr.system_id = %(system_id)s
             ''', {'company_code' : company_code, 'system_id' : current_app.config['SYSTEM_ID']})[0]['system_usable_flag']

def get_display_panels(roles, company_code):
    tag_ids = ['panel-entry-edit']
    now_date = datetime.datetime.now().astimezone(timezone('Asia/Tokyo')).replace(tzinfo=None)
    if (current_app.config['METADATA_ROLES_ADMIN_USER'] in roles) and ( now_date < get_subscription_start_date(company_code)):
        print('本契約日までお待ちください。')
        return tag_ids
    elif (current_app.config['METADATA_ROLES_WORKSHOP_USER'] in roles) and ( now_date < get_workshop_event_date(company_code)):
        print('ワークショップ開催日までお待ちください。')
        return tag_ids
    else:
        tag_ids = ['']
        return tag_ids

def get_subscription_start_date(company_code):
    return pdbc.select_param(db_hosts.platform(),
            '''
                SELECT
                    uimc.subscription_start_date
                FROM
                    user_infrastructure.t_manage_request uitmr
                INNER JOIN
                   user_infrastructure.m_contract uimc
                   ON uitmr.contract_id = uimc.contract_id
                WHERE
                    uitmr.company_code = %(company_code)s
                AND
                    uitmr.system_id = %(system_id)s
            ''', {'company_code' : company_code, 'system_id' : current_app.config['SYSTEM_ID']})[0]['subscription_start_date']

def get_workshop_event_date(company_code):
     return pdbc.select_param(db_hosts.platform(),
             '''
                 SELECT
                    uimwed.workshop_event_date
                 FROM
                    user_infrastructure.t_manage_request uitmr
                 INNER JOIN
                    user_infrastructure.t_workshop_request_confirmed uitwrc
                    ON uitmr.workshop_req_id = uitwrc.workshop_req_id
                 INNER JOIN
                    user_infrastructure.m_workshop_event_date uimwed
                    ON uitwrc.workshop_event_date_id = uimwed.workshop_event_date_id
                 WHERE
                     uitmr.company_code = %(company_code)s
                 AND
                     uitmr.system_id = %(system_id)s
             ''', {'company_code' : company_code, 'system_id' : current_app.config['SYSTEM_ID']})[0]['workshop_event_date']

def get_user_roles(user_metadata, company_code):
    roles = []
    try:
        for data in user_metadata['data']:
            if data['system_id'] == current_app.config['SYSTEM_ID'] and data['company_code'] == company_code:
                roles = data['roles']
    except Exception as e:
        pass
    return roles

def get_user_service_id(user_metadata, company_code):
    try:
        for data in user_metadata['data']:
            if data['system_id'] == current_app.config['SYSTEM_ID'] and data['company_code'] == company_code:
                return data['service_id']
    except Exception as e:
        pass
    return None
def get_user_metadata(user_metadata, company_code,name):
    try:
        for data in user_metadata['data']:
            if data['system_id'] == current_app.config['SYSTEM_ID'] and data['company_code'] == company_code:
                return data[name]
    except Exception as e:
        pass
    return None

def get_user_status(user_metadata, company_code):
    status_blocked = False
    for data in user_metadata.get('data'):
        if data['system_id'] == current_app.config['SYSTEM_ID'] and data['company_code'] == company_code:
            try:
                if data['blocked'] == True:
                    status_blocked = True
            except KeyError:
                pass
    return status_blocked

def get_user_info(auth):
    auth0 = Auth0Component()
    return auth0.get_user_by_auth(auth)

# def get_company_code(email):
#     m_user_condition = pui.MUser()
#     m_user_condition.email = email
#     return pdbc.select(db_hosts.platform(), m_user_condition)[0]['company_code']

# def get_metadata_company_code(user_metadata):
#     company_code = ''
#     for data in user_metadata.get('data'):
#         if data['system_id'] == current_app.config['SYSTEM_ID']:
#             company_code = data['company_code']
#     return company_code

def get_directory_user(email):
    m_directory_user_condition = sml.MDirectoryUser()
    m_directory_user_condition.user_email = email
    return pdbc.select(db_hosts.simsp(), m_directory_user_condition)[0]['directory_username']

def get_company_users(company_code):
    return pdbc.select_param(
            db_hosts.platform(),
            '''
                SELECT DISTINCT
                    mlmdu.user_email AS user_id,
                    ifmc.company_code AS company_code,
                    ifmc.company_name AS company_name,
                    ifmaui.blocked AS is_invalid
                FROM
                    user_infrastructure.m_company ifmc
                INNER JOIN
                    mscone_lic.m_directory_user mlmdu
                    ON ifmc.company_code = mlmdu.company_code
                LEFT JOIN
                    user_infrastructure.m_auth0_user_info ifmaui
                    ON mlmdu.company_code = ifmaui.company_code
                    AND mlmdu.user_email = ifmaui.auth0_user_id
                WHERE 
                    ifmc.company_code = %(company_code)s
                AND
                    mlmdu.user_email IS NOT NULL
                AND 
                    ifmaui.blocked IS NOT NULL
            ''',
            {'company_code':company_code}
        )
    # return pdbc.select_param(
    #         db_hosts.platform(),
    #         '''
    #             SELECT
    #                 ifmu.auth0_user_id AS auth0_user_id,
    #                 ifmc.company_code AS company_code,
    #                 ifmc.company_name AS company_name,
    #                 ifmu.email AS user_id
    #             FROM
    #                 user_infrastructure.m_company ifmc
    #             INNER JOIN
    #                 user_infrastructure.m_user ifmu
    #                 ON ifmc.company_code = ifmu.company_code
    #             WHERE
    #                 ifmc.company_code = %(company_code)s
    #         ''',
    #         {'company_code':company_code}
    #     )

def check_email_exist(email, company_code):
    m_user_condition = pui.MUser()
    m_user_condition.email = email
    m_user_condition.company_code = company_code
    result = pdbc.select(db_hosts.platform(), m_user_condition)
    # m_userに情報がなければFalseを返してエラーとしない
    if len(result) <= 0:
        #存在しない
        return False
    # m_userに情報があればSimSpのユーザーかどうかを判断する
    else:
        user = result[0]
        auth0 = Auth0Component()
        user_param = GetUserParam()
        user_param.id = user['auth0_user_id']
        auth0_userdata = auth0.get_user(user_param)
        user_metadata = auth0_userdata.get('user_metadata')
        # SimSpのユーザーメタデータロールが存在しない場合はFalseを返してエラーとしない
        if ( user_metadata is None or set(get_user_roles(user_metadata, company_code)) == set([]) ) :
            #存在しない
            return False
        # SimSpのユーザーメタデータロールが存在した場合はTrueを返してエラーとする
        else:
            #存在する
            return True

# def check_user_limit(company_code):
#     user_count = pdbc.select_param(db_hosts.platform(),
#                         '''
#                         SELECT
#                             COUNT(*)
#                         FROM
#                             user_infrastructure.m_user
#                         WHERE
#                             company_code = %(company_code)s
#                         ''',
#                         {'company_code':company_code}
#                     )[0]['count']
#     return int(current_app.config['USER_LIMIT']) >= int(user_count)

def check_user_limit(company_code):
    company_users = get_company_users(company_code)
    auth0 = Auth0Component()
    user_list = []
    for user in company_users:
        user_param = GetUserParam()
        user_param.id = user['auth0_user_id']
        auth0_userdata = auth0.get_user(user_param)
        user_metadata = auth0_userdata.get('user_metadata')
        # SimSpのユーザーメタデータロールが存在しなければ除外
        if ( user_metadata is None or set(get_user_roles(user_metadata, company_code)) == set([]) ) :
            continue
        user_list.append(user)
    user_count = len(user_list)
    return int(current_app.config['USER_LIMIT']) >= int(user_count)

def create_invitation_code():
    chars = string.ascii_uppercase + string.ascii_lowercase + string.digits
    return ''.join(secrets.choice(chars) for x in range(30))

def invitation(invitation_code, to_address, company_code, dryrun=False):

    text_message = ''
    with open('src/component/function/user/mail_invitation_text.txt','r',encoding="utf-8_sig") as f:
        text_message = f.read()
    text_message = text_message.replace('--UserName',to_address).replace('--InvitationUrl', current_app.config["INVITATION_URL"]).replace('--Invitationcode', invitation_code)
    mail.sendmail(current_app.config["MAIL_FROM_INVITATION"], [to_address], constants.MAIL_USER_INVITATION_TITLE, text_message, None)

    #データベース登録
    now_date = datetime.datetime.now().astimezone(timezone('Asia/Tokyo'))
    m_user_param = pui.MUser()
    m_user_param.auth0_user_id = invitation_code
    m_user_param.email = to_address
    m_user_param.company_code = company_code
    m_user_param.invitation_code = invitation_code
    m_user_param.invitation_date = now_date
    m_user_param.cdate = now_date
    m_user_param.udate = now_date
    pdbc.insert(db_hosts.platform(), m_user_param, dryrun)

def check_invitationcode(invitation_code):
    check = False
    username = ''
    new_user = True
    m_user_condition = pui.MUser()
    m_user_condition.invitation_code = invitation_code
    m_user = pdbc.select(db_hosts.platform(), m_user_condition)
    message = True
    if len(m_user) == 1:
        check = True
        username = m_user[0]['email'].split('@')[0]
        new_user = check_new_user(m_user[0]['email'])
        auth0 = Auth0Component()
        message = auth0.check_invitation_user(m_user[0]['email'])
    return {
        "status": check,
        "username": username,
        "new_user": new_user,
        "message": message
    }

# ユーザー登録時、他のサービスを使用しているかどうかの確認
def check_new_user(email):
    new_user = True
    m_user_condition = pui.MUser()
    m_user_condition.auth0_user_id =  email
    m_user = pdbc.select(db_hosts.platform(), m_user_condition)
    if len(m_user) > 0:
        new_user = False
    return new_user

def confirm(invitation_code, password, tenant, dryrun=False):
    print(tenant)
    #招待ユーザー情報
    m_user_condition = pui.MUser()
    m_user_condition.invitation_code = invitation_code
    inv_userdata = pdbc.select(db_hosts.platform(), m_user_condition)[0]

    #企業情報
    pl_m_company_codition = pui.MCompany()
    pl_m_company_codition.company_code = inv_userdata['company_code']
    pl_company = pdbc.select(db_hosts.platform(), pl_m_company_codition)[0]

    # Auth0ユーザー追加
    auth_api_create_user(inv_userdata['email'], '', '', inv_userdata['company_code'], [current_app.config['METADATA_ROLES_GENERAL_USER']], tenant)
    # パスワード設定
    if not password == '':
        auth0 = Auth0Component()
        user_update_param = UpdateUserParam()
        user_update_param.id = inv_userdata['email']
        user_update_param.password = password
        auth0.update_user(user_update_param)

    #データベース登録
    now_date = datetime.datetime.now().astimezone(timezone('Asia/Tokyo'))
    m_user_param = pui.MUser()
    m_user_param.auth0_user_id = inv_userdata['email']
    m_user_param.udate = now_date
    m_user_condition = pui.MUser()
    m_user_condition.invitation_code = invitation_code
    pdbc.update(db_hosts.platform(), m_user_param, m_user_condition, dryrun)

    #メール送信
    with open('src/component/function/user/mail_activate_text.txt','r',encoding="utf-8_sig") as f:
        text_message = f.read()
    text_message = text_message.replace('--UserName',inv_userdata['email']).replace('--LoginUrl', current_app.config["LOGIN_URL"]).replace('--CompanyName',pl_company['company_name'])
    mail.sendmail(
                 current_app.config["MAIL_FROM_INVITATION"],
                 [inv_userdata['email']],
                 constants.MAIL_USER_REGIST_TITLE,
                 text_message,
                 None
                 )

def update(company_code, user_email, update_user_email, update_method, tenant, dryrun=False):

    update_user_condition = pui.MUser()
    update_user_condition.company_code = company_code
    update_user_condition.email = update_user_email
    update_user = pdbc.select(db_hosts.platform(), update_user_condition)

    company_condition = pui.MCompany()
    company_condition.company_code = company_code
    company = pdbc.select(db_hosts.platform(), company_condition)[0]

    if len(update_user) <= 0:
        #存在しないユーザー、もしくは異なる企業のユーザー
        return {
            "status":"error",
            "error_reason":"ユーザーが存在しませんでした。"
        }

    if update_method == 'DELETE':
        #削除
        auth_api_delete_user(company_code, update_user_email, tenant)
        #メール送信
        with open('src/component/function/user/mail_alert_delete_text.txt','r',encoding="utf-8_sig") as f:
            text_message = f.read()
        text_message = text_message.replace('--UserName',update_user_email).replace('--CompanyName', company['company_name'])
        mail.sendmail(current_app.config["MAIL_FROM_INVITATION"], [update_user_email], constants.MAIL_USER_DELETE_TITLE, text_message, None)
    
    elif update_method == 'INVALID':
        #無効化
        auth_api_update_user(update_user_email, company_code, True, tenant)
        #メール送信
        with open('src/component/function/user/mail_alert_invalid_text.txt','r',encoding="utf-8_sig") as f:
            text_message = f.read()
        text_message = text_message.replace('--UserName',update_user_email).replace('--CompanyName', company['company_name'])
        mail.sendmail(current_app.config["MAIL_FROM_INVITATION"], [update_user_email], constants.MAIL_USER_INVALID_TITLE, text_message, None)
    
    elif update_method == 'VALID':
        #有効化
        auth_api_update_user(update_user_email, company_code, False, tenant)

    return {
        "status":"success"
    }

"""
Phase3 共通API ユーザー追加、更新、削除
"""
def auth_api_create_user(email, last_name, first_name, company_code, roles, tenant):
    try:
        input_event = {
            'stageVariables': {
                'env': current_app.config["LAMBDA_ENV"]
            },
            'httpMethod': 'POST',
            'path': current_app.config["LAMBDA_USER_MANAGEMENT_PATH"],
            'body': json.dumps(
                {
                    "email_address": email,
                    "last_name": last_name,
                    "first_name": first_name,
                    "company_code": company_code,
                    "roles": roles,
                    "tenant": tenant
                }
            )
        }
        print(input_event)
        Payload = json.dumps(input_event, ensure_ascii=False)
        print("---01: Payload:")
        print(Payload)

        # 呼び出し
        response = aws.invoke_lambda(
            'RequestResponse',
            current_app.config['LAMBDA_USER_MANAGEMENT'],
            Payload
        )
        print("---02: response:")
        print(response)

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:")
            print(Payload)
            if 'statusCode' in json.loads(Payload['body']) and json.loads(Payload['body'])['statusCode'] != 200:
                raise Exception(json.loads(Payload['body'])['body'])
            res = Payload
        else:
            raise Exception('StatusCode is not 200')

        # 成功    
        return res
    
    except Exception as e:
        print(e)
        raise e

def auth_api_update_metadata(payload):
    try:
        input_event = {
            'stageVariables': {
                'env': current_app.config["LAMBDA_ENV"]
            },
            'httpMethod': 'PUT',
            'path': current_app.config["LAMBDA_METADATA_MANAGEMENT_PATH"],
            'body': json.dumps(
                payload
            )
        }
        Payload = json.dumps(input_event, ensure_ascii=False)
        print("---01: Payload:")
        print(Payload)

        # 呼び出し
        response = aws.invoke_lambda(
            'RequestResponse',
            current_app.config['LAMBDA_USER_MANAGEMENT'],
            Payload
        )
        print("---02: response:")
        print(response)

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:")
            print(Payload)
            if 'statusCode' in json.loads(Payload['body']) and json.loads(Payload['body'])['statusCode'] != 200:
                raise Exception(json.loads(Payload['body'])['body'])
            res = Payload
        else:
            raise Exception('StatusCode is not 200')

        # 成功    
        return res
    
    except Exception as e:
        print(e)
        raise e

def auth_api_update_user(email, company_code, blocked, tenant):
    try:
        input_event = {
            'stageVariables': {
                'env': current_app.config["LAMBDA_ENV"]
            },
            'httpMethod': 'PUT',
            'path': current_app.config["LAMBDA_USER_MANAGEMENT_PATH"],
            'body': json.dumps(
                {
                    "email_address": email,
                    "company_code": company_code,
                    "blocked": blocked,
                    "tenant": tenant
                }
            )
        }
        Payload = json.dumps(input_event, ensure_ascii=False)
        print("---01: Payload:")
        print(Payload)

        # 呼び出し
        response = aws.invoke_lambda(
            'RequestResponse',
            current_app.config['LAMBDA_USER_MANAGEMENT'],
            Payload
        )
        print("---02: response:")
        print(response)

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:")
            print(Payload)
            if 'statusCode' in json.loads(Payload['body']) and json.loads(Payload['body'])['statusCode'] != 200:
                raise Exception(json.loads(Payload['body'])['body'])
            res = Payload
        else:
            raise Exception('StatusCode is not 200')

        # 成功    
        return res
    
    except Exception as e:
        print(e)
        raise e

def auth_api_delete_user(company_code, email, tenant):
    try:
        input_event = {
            'stageVariables': {
                'env': current_app.config["LAMBDA_ENV"]
            },
            'httpMethod': 'DELETE',
            'path': current_app.config["LAMBDA_USER_MANAGEMENT_PATH"],
            'body': json.dumps(
                {
                    "company_code": company_code,
                    "email_address": email,
                    "tenant": tenant
                }
            )
        }
        Payload = json.dumps(input_event, ensure_ascii=False)
        print("---01: Payload:")
        print(Payload)

        # 呼び出し
        response = aws.invoke_lambda(
            'RequestResponse',
            current_app.config['LAMBDA_USER_MANAGEMENT'],
            Payload
        )
        print("---02: response:")
        print(response)

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:")
            print(Payload)
            if 'statusCode' in json.loads(Payload['body']) and json.loads(Payload['body'])['statusCode'] != 200:
                raise Exception(json.loads(Payload['body'])['body'])
            res = Payload
        else:
            raise Exception('StatusCode is not 200')

        # 成功    
        return res
    
    except Exception as e:
        print(e)
        raise e

'''
Phase4+ 
保守契約ユーザ ロール、mainte_contract_userのとき、
count<=available_dateなら、true
'''
def check_datecount_remains(user,company_code, tenant):
    # env_id = ssm.get_env_id(company_code)
    # print('env_id=' + env_id)
    # print('user=' + str(user))
    user_metadata = user['user_metadata']
    email = user['email']
    print('email=' + email)
    auth0_user_id = user['user_id']
    print('auth0_user_id=' + auth0_user_id)
    system_id = current_app.config['SYSTEM_ID']

    # 「t_ma_contract_request_confirmed」からデータ検索、既に使用中(ma_contract_env_stock_id)に値が入っている)なら
    dbres = pdbc.select_param(
            db_hosts.platform(),
            '''
                SELECT
                    iftrm.ma_contract_env_stock_id AS stockId,
                    iftrm.count<iftrm.available_date AS isRemain,
                    iftrm.ma_contract_req_id AS reqId
                FROM
                    user_infrastructure.t_ma_contract_request_confirmed iftrm
                WHERE
                    iftrm.company_code = %(company_code)s
                    and iftrm.system_id = %(system_id)s
                    and iftrm.email_address = %(mail)s
            ''',
            {'company_code':company_code,'system_id':system_id,'mail':email}
        )
    print('dbres=' + str(dbres))
    if( dbres[0]['stockid'] != None) : # ma_contract_env_stock_id)に値が入っている)なら利用可
        return [True,'']
    req_id=dbres[0]['reqid']
    now = datetime.datetime.now()
    start = datetime.datetime(now.year,now.month,now.day,0,0)
    end = datetime.datetime(now.year,now.month,now.day,8,59)
    if(start < now and now < end) : # 現在の時間が 00:00～08:59 → 利用不可
        return [False,'大変申し訳ございません。現在、メンテナンス中のためご利用いただけません。9:00-23:59の間にご利用をお試しください。'] 
    if(dbres == None) :
        return [False,'DB接続に障害があり現在使用できません']
    if(dbres[0]['isremain'] == False ) : # 利用回数の上限(available_date)を超える → 利用不可
        return [False,'今月の利用回数が上限を超えているため、現在はご利用いただけません。保守契約期間中は翌月1日に利用可能回数がリセットされますので再度ご利用をお試しください。']
    service_id = get_user_service_id(user_metadata, company_code)
    print('serviceId=' + service_id)
    print('kiteiruno?')
    dbres = pdbc.select_param(
            db_hosts.platform(),
            '''
                SELECT
                    ifmes.ma_contract_env_stock_id AS stockId,
                    ifmes.ma_contract_company_code AS company_code,
                    ifmes.ma_contract_user_id AS userId
                FROM
                    user_infrastructure.m_ma_contract_env_stock ifmes
                WHERE
                    ifmes.ma_contract_company_code = %(company_code)s
                    and ifmes.service_id = %(service_id)s
                    and ifmes.use_flg != true
            ''',
            {'company_code':company_code,'service_id':service_id}
        )
    print('dbres=' + str(dbres))
    if(dbres == []) :
        print('no stock id')
        return [False,'大変申し訳ございません。現在、利用可能な環境に空きがございません。翌日以降に再度ご利用をお試しください。']
    nextId = dbres[0]['stockid']
    print('nextId=' + str(nextId))
    adCompanyCode = dbres[0]['company_code']
    print('adCompanyCode=' + adCompanyCode)
    adUserId = dbres[0]['userid']
    print('adUserId=' + adUserId)
    # 空きがある → 利用可能
    #「m_ma_contract_env_stock」テーブルの割り振られた環境のIDのレコードのuse_flgをtrueにする
    #「m_ma_contract_env_stock」テーブルのma_contract_start_dateを現在の時間で設定、ma_contract_end_dateをNULLにする。
    pdbc.update_param(
        db_hosts.platform(),
        '''
        update user_infrastructure.m_ma_contract_env_stock
        set use_flg = true
        where ma_contract_env_stock_id = %(nextId)s
        ''',
        {'nextId':nextId}
     )
    #「t_ma_contract_request_confirmed」テーブルのma_contract_env_stock_idに割り振られた環境のIDを設定
    #「t_ma_contract_request_confirmed」テーブルのcount+1
    pdbc.update_param(
        db_hosts.platform(),
        '''
        update user_infrastructure.t_ma_contract_request_confirmed
        set count = count + 1
        ,ma_contract_env_stock_id = %(nextId)s
        ,ma_contract_start_date = current_date
        ,ma_contract_end_date = null
        where company_code = %(company_code)s
            and system_id = %(system_id)s
            and email_address = %(email)s
        ''',
        {'nextId':nextId,'company_code':company_code,'system_id':system_id,'email':email}
     )
    # billing_infrastructure.m_systemsテーブルからad_domain_nameを取得
    dbres = pdbc.select_param(
            db_hosts.platform(),
            '''
                SELECT
                    bms.ad_domain_name AS adDomainName
                FROM
                    billing_infrastructure.m_systems bms
                WHERE
                    bms.system_id = %(system_id)s
            ''',
            {'system_id':system_id}
        )
    adDomainname = dbres[0]['addomainname']
    print('adDomainname=' + adDomainname)
    adUsername = adCompanyCode + '.' + adUserId + '@' + adDomainname
    print('adUsername=' + adUsername)
    appStackname = system_id + '-' + service_id + '-' +  'appstream-stack-activedirectory' 
    appStackname += '-' + adCompanyCode
    print('appStackname=' + appStackname)
    # phase6 lam-sys-comp-pfで書き換えを実施し、entraのメタデータが書き換わるように修正
    auth0_user = pdbc.select_param(
        db_hosts.platform(),
        '''
        select
          *
        from 
          user_infrastructure.m_auth0_user_info
        where company_code = %(company_code)s
            and system_id = %(system_id)s
            and service_id = %(service_id)s
            and auth0_user_id = %(auth0_user_id)s
        ''',
        {'auth0_user_id':auth0_user_id,'company_code':company_code,'system_id':system_id,'service_id':service_id}
    )
    update_data = auth0_user[0]
    update_data['activedirectory_username'] = adUsername
    update_data['appstream_stackname'] = appStackname
    update_data['cdate'] = update_data['cdate'].isoformat()
    update_data['udate'] = datetime.datetime.now().astimezone(timezone('Asia/Tokyo')).replace(tzinfo=None).isoformat()
    print(update_data)
    auth_api_update_metadata(update_data)
    """
    # user_infrastructure.m_auth0_user_infoに書き込み activedirectory_username appstream_stackname
    pdbc.update_param(
        db_hosts.platform(),
        '''
        update user_infrastructure.m_auth0_user_info
        set activedirectory_username = %(adUsername)s
        ,appstream_stackname = %(appStackname)s
        where company_code = %(company_code)s
            and system_id = %(system_id)s
            and service_id = %(service_id)s
            and auth0_user_id = %(auth0_user_id)s
        ''',
        {'auth0_user_id':auth0_user_id,'company_code':company_code,'system_id':system_id,'service_id':service_id
         ,'adUsername':adUsername,'appStackname':appStackname
         }
     )
    """
    # 「user_infrastructure.t_manage_request」テーブルのstatusを「保守契約企業利用中」にする
    # ma_contract_req_idが該当する行
    pdbc.update_param(
        db_hosts.platform(),
        '''
        update user_infrastructure.t_manage_request
        set status = '保守契約企業利用中'
        where ma_contract_req_id = %(req_id)s
        ''',
        {'req_id':req_id}
     )
    # mscone_lic.m_directory_userのdirectory.user_nameで検索して、 Hitしたらuser_emailにメールアドレスを設定
    dirUsername = adCompanyCode + '.' + adUserId
    print('dirUsername=' + dirUsername)
    pdbc.update_param(
        db_hosts.simsp(),
        '''
        update mscone_lic.m_directory_user
        set user_email = %(email)s
        where directory_username = %(dirUsername)s
        ''',
        {'email':email,'dirUsername':dirUsername }
     )
    print('start auth0 update')
    auth_api_update_user(user['email'], company_code, False, tenant) # True=>False
    print('finished auth0 update')
    return [True,'']
    

    
def get_user_company(auth):
    auth0 = Auth0Component()
    """
    auth0.AUTH0_AUDIENCE =  current_app.config["API_AUDIENCE"]
    auth0.AUTH0_CLIENT_ID = current_app.config["AUTH0_CLIENT_ID"]
    auth0.AUTH0_CLIENT_SECRET = current_app.config["AUTH0_CLIENT_SECRET"]
    auth0.get_token()
    print(auth0.AUTH0_CLIENT_ID)
    """
    metadata = auth0.get_user_by_auth(auth)['user_metadata']['data']
    list_name_service = []
    list_service_code = []
    roles = []
    for row in metadata:
        if (row['company_code'] != current_app.config['STAFF_COMPANY_CODE']):
            if ((row['service_id'] not in list_service_code) & (row['system_id'] == current_app.config['SYSTEM_ID'])):
                list_name_service.append({'company_code': row['company_code'], 'service_id': row['service_id']})
                list_service_code.append(row['service_id'])
                for role in row['roles']:
                    roles.append(role)
    list_service_code = tuple(list_service_code)
    roles = tuple(roles)
    print('roles')
    print(roles)
    service_names = pdbc.select_param(db_hosts.platform(),
            '''
                SELECT
                    service_id,
                    service_name
                FROM
                    billing_infrastructure.m_services
                WHERE
                    service_id in %(service_id)s

            ''', { 'service_id' : list_service_code})
    role_menu = pdbc.select_param(db_hosts.simsp(),
            '''
                SELECT
                    menu_id
                FROM
                    mscone_lic.m_menu_control
                WHERE
                    role_name in %(roles)s

            ''', { 'roles' : roles})
    print(role_menu)
    return_data = {}
    service = {}
    for name_service in list_name_service:
        com = name_service['company_code']
        ser = name_service['service_id']
        if com not in service:
            service[com] = {'company_code': '', 'services': {}}
        service[com]['services'][ser] = {}
        for service_name in service_names:
            if (service_name['service_id'] == ser):
                service[com]['services'][ser]['service_name'] = service_name['service_name']
    menus = []
    for menu in role_menu:
        menus.append(menu['menu_id'])
    menus = list(set(menus))
    return_data['menus'] = menus
    return_data['service'] = service
    return return_data

