from asyncio import constants
from flask import Blueprint, render_template
from src.component.common.entraid.component import Auth0Component
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.model.tables import *
from src.component.function.user import user_logic
from src.component.common.storage import fsx
from src.component.common.storage import ssm, fsx_ontap
from flask_cors import cross_origin
from pytz import timezone
from dateutil import parser
from src.component.common.constants import constants
import json
import re
import datetime
from src.component.common.aws import aws
from src.component.common.pdbc import pdbc

user_bp = Blueprint('user', __name__, url_prefix='/user')

@user_bp.route('/authinfo', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
def authinfo():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    tenant = request.headers.get('tenant')
    company_code = request.headers.get("ccode")
    user_roles = user_logic.get_user_roles(user['user_metadata'], company_code)
    panel_ids = user_logic.get_display_panels(user_roles, company_code)
    if current_app.config['METADATA_ROLES_TRIAL_USER'] in user_roles:
        user_id = user['user_id']
        system_usable_flag = user_logic.get_trial_systemusableflag(company_code, user_id)
        user_not_trial = False
    elif current_app.config['METADATA_ROLES_MCONTRACT_USER'] in user_roles:
        user_id = user['user_id']
        system_usable_flag = user_logic.get_trial_systemusableflag(company_code, user_id)
        user_not_trial = True
    elif current_app.config['METADATA_ROLES_SUPPORT_STAFF'] in user_roles:
        system_usable_flag = 2
        user_not_trial = True
    elif current_app.config['METADATA_ROLES_SUPPORT_STAFF'] in user_roles:
        system_usable_flag = 2
        user_not_trial = True
    elif 'admin_staff' in user_roles:
        system_usable_flag = 2
        user_not_trial = True  
    else:
        system_usable_flag = user_logic.get_systemusableflag(company_code)
        user_not_trial = True
    count_remains = [True,'']
    print('kokoha_')
    if current_app.config['METADATA_ROLES_MCONTRACT_USER'] in user_roles:
        print('haitteru ?')
        count_remains = user_logic.check_datecount_remains(user,company_code, tenant)

    return {
        "paymentStatus": str(system_usable_flag),
        'userNotTrial': user_not_trial,
        'countRemains': count_remains,
        'panel_ids': panel_ids
    }

@user_bp.route('/reset_password', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
def reset_password():
    auth0 = Auth0Component()
    auth0.send_change_password(request.form.get('email'))
    return 'ok'

@user_bp.route('/info', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def info():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    tenant = request.headers.get('tenant')
    print(user)
    company_code = request.headers.get("ccode")
    print('user.info(): クエリパラメータから企業コード取得：' + company_code)
    user_roles = user_logic.get_user_roles(user['user_metadata'], company_code)
    if current_app.config['METADATA_ROLES_TRIAL_USER'] in user_roles:
        system_usable_flag = 2
        user_not_trial = False
    else:
        system_usable_flag = user_logic.get_systemusableflag(company_code)
        user_not_trial = True
    panel_ids = user_logic.get_display_panels(user_roles, company_code)
    # count_remains　ロールが保守契約でなければ、True,使用可能回数あれば、True,それ以外、False
    count_remains = [True,'']
    if current_app.config['METADATA_ROLES_MCONTRACT_USER'] in user_roles:
        count_remains = user_logic.check_datecount_remains(user,company_code, tenant)
    print('count_remains=' + str(count_remains))
    now_date = datetime.datetime.now().astimezone(timezone('Asia/Tokyo'))
    #size = fsx.get_size(company_code, '/')
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        size = fsx_ontap.get_size(company_code, '/')
    else:
        size = ssm.get_size(company_code, '/')
    # print(size)
    # print(size[1])
    try:
        last_change_pass_date = parser.parse(user['last_password_reset']).astimezone(timezone('Asia/Tokyo'))
    except Exception:
        last_change_pass_date = parser.parse(user['created_at']).astimezone(timezone('Asia/Tokyo'))
    tokenResponse = aws.invoke_lambda(
                        'RequestResponse',
                        current_app.config['LAMBDA_GET_TOKEN_CONSUMPTION_NOTIFY_USER'],
                        json.dumps({})
                    )
    for i in range(2):
        if size[i][-1] != 'B' :
            size[i] = size[i] + 'B'
    return {
        "paymentStatus": str(system_usable_flag),
        'quota': size[1],
        #'size': size + ' GB',  # フェーズ4対応
        #'size': size[0],
        #'fileSizeAlert': 80 <= int(float(size)),   # フェーズ4対応
        # 'fileSizeAlert': 80 <= int(size[1]),
        'size': size[0],
        'fileSizeAlert': 80 <= int(size[2]),
        'lastLogin': str(parser.parse(user['last_login']).astimezone(timezone('Asia/Tokyo')))[:-13],
        'changePass': (now_date - last_change_pass_date).days > 90,
        'affordTokenStatus': json.loads(tokenResponse['Payload'].read()),
        'panelIds': panel_ids,
        'service': current_app.config['SERVICE'],
        'companyCode': company_code,
        'userNotTrial': user_not_trial,
        'countRemains': count_remains
    }

@user_bp.route('/auth', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
def auth():
    return {
        "status": True
    }

@user_bp.route('/menu', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@newRequiredAuth
def menu():
    role = user_logic.get_user_company(request.headers.get("Authorization", None))
    return role

@user_bp.route('/list', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminWorkshopUser
def list():
    # user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    company_users = user_logic.get_company_users(company_code)
    # auth0 = Auth0Component()
    # user_list = []
    # for user in company_users:
    #     #Auth0登録情報取得
    #     user_param = GetUserParam()
    #     user_param.id = user['auth0_user_id']
    #     auth0_userdata = auth0.get_user(user_param)
    #     try:
    #         user_metadata = auth0_userdata.get('user_metadata')
    #     except:
    #         continue
    #     # SimSpのユーザーメタデータロールが存在しなければ除外
    #     if ( user_metadata is None or set(user_logic.get_user_roles(user_metadata, company_code)) == set([]) ) :
    #         continue
    #     #最終ログイン
    #     try: 
    #         # user['last_login'] = str(auth0_userdata['last_login']).replace('T', ' ').replace('Z','')
    #         user['last_login'] = str(parser.parse(auth0_userdata['last_login']).astimezone(timezone('Asia/Tokyo')))[:-13]
    #     except Exception as e:
    #         user['last_login'] = constants.USER_MESSAGE_NOT_LOGIN_HISTORY
    #     #ステータス
    #     status_blocked = user_logic.get_user_status(auth0_userdata.get('user_metadata'), company_code)
    #     try: 
    #         # if auth0_userdata['blocked'] == True:
    #         if status_blocked == True:
    #             user['is_invalid'] = True
    #         else :
    #             user['is_invalid'] = False
    #     except Exception as e:
    #         user['is_invalid'] = False
    #     user_list.append(user)
    return json.dumps(company_users)
    # return json.dumps(user_list)

@user_bp.route('/invitation', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminWorkshopUser
def invitation():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    create_user_email = request.form.get('create_user_email')

    pattern = "^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+$"
    if not re.match(pattern, create_user_email):
        return {
            "status":"error",
            "error_reason":constants.USER_ERROR_INVITATION_INVALID_EMAIL
        }

    if user_logic.check_email_exist(create_user_email, company_code):
        return {
            "status":"error",
            "error_reason":constants.USER_ERROR_INVITATION_EXIST_EMAIL
        }

    if not user_logic.check_user_limit(company_code):
        return {
            "status":"error",
            "error_reason":constants.USER_ERROR_INVITATION_LIMIT_USERS
        }
    invitation_code = user_logic.create_invitation_code()
    user_logic.invitation(invitation_code, create_user_email, company_code)

    return {
        "status":"success"
    }

@user_bp.route('/check_confirm', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
def check_confirm():
    invitation_code = request.form.get('invitationcode')
    return user_logic.check_invitationcode(invitation_code)

@user_bp.route('/confirm', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
def confirm():
    invitation_code = request.form.get('invitationcode')
    password = request.form.get('password')
    tenant = request.form.get('tenant')
    print(tenant)
    if not user_logic.check_invitationcode(invitation_code):
        return {
            "status":"error"
        }

    user_logic.confirm(invitation_code, password, tenant)
    return {
        "status":"success"
    }

@user_bp.route('/update', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminWorkshopUser
def update_user():
    tenant = request.headers.get("tenant", None)
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    update_user_email = request.form.get('update_user_id')
    update_method = request.form.get('update_method')
    if user['email'] == update_user_email:
        return {
            "status":"error",
            "error_reason":constants.USER_ERROR_DO_NOT_CHANGE_MY_ACCOUNT
        }

    return user_logic.update(company_code, user['email'], update_user_email, update_method, tenant)