from flask import Flask, Blueprint, render_template, current_app
from src.component.model.simsp import mscone_lic as sml
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.common.pdbc import pdbc, db_hosts
from src.component.common.storage import ssm
from src.component.common.storage import fsx_ontap
import time
import os
def get_solverlist(username):
    sql = '''
        SELECT
            t_solver_list_id                                -- ソルバーリストID
            , username                                      -- ユーザー名
            , data_filename                                  -- データファイル名
            , dat_path                                      -- データファイルパス(S3)
            , ecs_taskname                                  -- ECSタスク名
            , jobname                                       -- JOB名称
            , to_char(end_time::timestamp - start_time::timestamp, 'dd日 HH24:MI:SS.MS') AS calculation_time -- ソルバー処理時間
            , to_char(start_time::timestamp, 'yyyy/mm/dd HH24:MI:SS') AS start_time -- ソルバー開始日時
            , to_char(end_time::timestamp, 'yyyy/mm/dd HH24:MI:SS') AS end_time -- ソルバー終了日時
            , status                                        -- ステータス
            , error_reason                                  -- error_reason
            , product                                       -- 製品名
            , log_progress                                  -- ログから取得した進捗率
            , night_process_flag                            -- 夜間実行
        FROM
            mscone_lic.t_solver_list 
        WHERE
            LOWER(username) = LOWER(%(username)s)
            AND
            flg_deleted = FALSE
        ORDER BY
            t_solver_list_id DESC
    '''
    return pdbc.select_param(db_hosts.simsp(), sql, {'username' : username})

def delete(username, t_solver_list_id, dryrun=False):
    t_solver_list_condition = sml.TSolverList()
    t_solver_list_condition.t_solver_list_id = t_solver_list_id
    t_solver_list_condition.username = username
    t_solver_list_param = sml.TSolverList()
    t_solver_list_param.flg_deleted = True
    return pdbc.update(db_hosts.simsp(), t_solver_list_param, t_solver_list_condition, dryrun)

def cancel(username, t_solver_list_id, dryrun=False):
    t_solver_list_condition = sml.TSolverList()
    t_solver_list_condition.t_solver_list_id = t_solver_list_id
    t_solver_list_condition.username = username
    t_solver_list_param = sml.TSolverList()
    t_solver_list_param.status = 'キャンセル'
    return pdbc.update(db_hosts.simsp(), t_solver_list_param, t_solver_list_condition, dryrun)

def changetime(username, t_solver_list_id, night_process_flag, dryrun=False):

    sql = '''
        SELECT
            t_solver_list_id                                -- ソルバーリストID
            , status                                        -- ステータス
        FROM
            mscone_lic.t_solver_list 
        WHERE
            t_solver_list_id = %(t_solver_list_id)s 
    '''
    job = pdbc.select_param(db_hosts.simsp(), sql, {'t_solver_list_id' : t_solver_list_id})

    if len(job) == 1:
        if job[0]['status'] == '計算待ち':
            t_solver_list_condition = sml.TSolverList()
            t_solver_list_condition.t_solver_list_id = t_solver_list_id
            t_solver_list_condition.username = username
            t_solver_list_param = sml.TSolverList()
            t_solver_list_param.night_process_flag = night_process_flag
            pdbc.update(db_hosts.simsp(), t_solver_list_param, t_solver_list_condition, dryrun)
        else:
            return "計算待ちではないジョブの時間指定は変更できません。"
    else:
        return "ジョブIDの値が不正です。"
    
    return None
def get_one_log(user_email, company_code, t_solver_list_id, log_file_name, limitFlg):
    logs = []
    solver_condition = sml.TSolverList()
    solver_condition.username = user_email
    solver_condition.t_solver_list_id = t_solver_list_id
    row = pdbc.select(db_hosts.simsp(), solver_condition)[0]
    target_logfilename = log_file_name.replace(' ','').replace('\n','')
    logfilepath = row['dat_path'][3:]
    logfilepath = logfilepath[:logfilepath.rfind('/')] + '/' + target_logfilename
    print(target_logfilename, logfilepath)
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        if (limitFlg):
            try:
                logs.append({
                            'log_filename':target_logfilename,
                            'log_text':fsx_ontap.get_text_limit(company_code, logfilepath)
                            })
            except Exception:
                print(Exception)
        else:
                logs.append({
                            'log_filename':target_logfilename,
                            'log_text':fsx_ontap.get_text(company_code, logfilepath)
                            })
    else:
        if (limitFlg):
            try:
                logs.append({
                            'log_filename':target_logfilename,
                            'log_text':ssm.get_text_limit(company_code, logfilepath)
                            })
            except Exception:
                print(Exception)
        else:
                logs.append({
                            'log_filename':target_logfilename,
                            'log_text':ssm.get_text(company_code, logfilepath)
                            })
    return json.dumps(logs)

def get_log(user_email, company_code, t_solver_list_id):
    target_logfilenames = []
    logs = []
    solver_condition = sml.TSolverList()
    solver_condition.username = user_email
    solver_condition.t_solver_list_id = t_solver_list_id
    row = pdbc.select(db_hosts.simsp(), solver_condition)[0]
    print(row)
    #必要ログファイル
    if row['product'] == 'simufact':
        #SimufactForming
        target_logfilenames.append(row['jobname'] + '.sts')
        target_logfilenames.append(row['jobname'] + '.log')
        target_logfilenames.append(row['jobname'] + '.out')
        for num in range(10):
            target_logfilenames.append(str(num) + row['jobname'] + '.out')
    elif row['product'] == 'marc':
        #MarcMentat
        target_logfilenames.append(row['jobname'] + '.out')
        target_logfilenames.append(row['jobname'] + '.sts')
        target_logfilenames.append(row['jobname'] + '.log')
        target_logfilenames.append(row['jobname'] + '_std.log')
        for num in range(9):
            target_logfilenames.append(str(num+1) + row['jobname'] + '.out')
    elif row['product'] == 'nastran':
        #Nastran
        target_logfilenames.append(row['jobname'] + '.log')
        target_logfilenames.append(row['jobname'] + '_std.log')
    else:
        #Cradle
        target_logfilenames.append(row['jobname'] + '.l')
        target_logfilenames.append(row['jobname'] + '.log')
        target_logfilenames.append(row['jobname'] + '_std.log')

    for target_logfilename in target_logfilenames:
        target_logfilename = target_logfilename.replace(' ','').replace('\n','')
        logfilepath = row['dat_path'][3:]
        logfilepath = logfilepath[:logfilepath.rfind('/')] + '/' + target_logfilename
        try:
            if current_app.config.get('STORAGE_FSX_ONTAP'):
                logs.append({
                            'log_filename':target_logfilename,
                            'log_text':fsx_ontap.get_text(company_code, logfilepath)
                            })
            else:
                logs.append({
                            'log_filename':target_logfilename,
                            'log_text':ssm.get_text(company_code, logfilepath)
                            })
        except Exception:
            continue

    return json.dumps(logs)

def get_log_list(user_email):
    select_sql = '''
        SELECT
            t_solver_list_id                                -- ソルバーリストID
            , username                                      -- ユーザー名
            , to_char(start_time::timestamp, 'yyyy/mm/dd HH24:MI:SS') AS start_time -- ソルバー開始日時
            , product                                       -- 製品名
        FROM
            mscone_lic.t_solver_list 
        WHERE
            LOWER(username) = LOWER(%(username)s)
            AND
            flg_deleted = FALSE
            AND
            status != %(status)s
            AND
            start_time IS NOT NULL
        ORDER BY
            t_solver_list_id DESC
    '''
    rows = pdbc.select_param(db_hosts.simsp(), select_sql, {'username': user_email, 'status': '計算待ち'})
    print(rows)
    return json.dumps(rows)

def get_logfile_list(user_email, company_code, t_solver_id):
    target_logfilenames = []
    select_sql = '''
        SELECT
            t_solver_list_id                                -- ソルバーリストID
            , username                                      -- ユーザー名
            , data_filename                                  -- データファイル名
            , dat_path                                      -- データファイルパス(S3)
            , ecs_taskname                                  -- ECSタスク名
            , jobname                                       -- JOB名称
            , to_char(end_time::timestamp - start_time::timestamp, 'dd日 HH24:MI:SS.MS') AS calculation_time -- ソルバー処理時間
            , to_char(start_time::timestamp, 'yyyy/mm/dd HH24:MI:SS') AS start_time -- ソルバー開始日時
            , to_char(end_time::timestamp, 'yyyy/mm/dd HH24:MI:SS') AS end_time -- ソルバー終了日時
            , status                                        -- ステータス
            , error_reason                                  -- error_reason
            , product                                       -- 製品名
            , log_progress                                  -- ログから取得した進捗率
            , night_process_flag                            -- 夜間実行
        FROM
            mscone_lic.t_solver_list 
        WHERE
            t_solver_list_id = %(t_solver_id)s
            AND
            LOWER(username) = LOWER(%(username)s)
            AND
            flg_deleted = FALSE
            AND
            status != %(status)s
            AND
            start_time IS NOT NULL
        ORDER BY
            t_solver_list_id DESC
    '''
    rows = pdbc.select_param(db_hosts.simsp(), select_sql, {'t_solver_id': t_solver_id, 'username': user_email, 'status': '計算待ち'})
    #必要ログファイル
    new_rows = []
    print(rows)
    for row in rows:
        if row['jobname'] == '':
            continue
        logfilepath = row['dat_path'][3:]
        logfilepath = logfilepath[:logfilepath.rfind('/')] + '/' 
        if row['product'] == 'simufact':
            #SimufactForming
            target_logfilenames.append(logfilepath + (row['jobname'] + '.sts').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '.log').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '.out').replace(' ','').replace('\n',''))
            for num in range(10):
                target_logfilenames.append(logfilepath + (str(num) + row['jobname'] + '.out').replace(' ','').replace('\n',''))
        elif row['product'] == 'marc':
            #MarcMentat
            target_logfilenames.append(logfilepath + (row['jobname'] + '.out').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '.sts').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '.log').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '_std.log').replace(' ','').replace('\n',''))
            for num in range(9):
                target_logfilenames.append(logfilepath + (str(num+1) + row['jobname'] + '.out').replace(' ','').replace('\n',''))
        elif row['product'] == 'nastran':
            #Nastran
            target_logfilenames.append(logfilepath + (row['jobname'] + '.log').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '_std.log').replace(' ','').replace('\n',''))
        else:
            #Cradle
            target_logfilenames.append(logfilepath + (row['jobname'] + '.l').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '.log').replace(' ','').replace('\n',''))
            target_logfilenames.append(logfilepath + (row['jobname'] + '_std.log').replace(' ','').replace('\n',''))
    #linuxから取得したいログファイルのパス情報（存在するかわからないもの含め）を取得
    print(target_logfilenames)
    print(target_logfilenames)
    for target_logfilename in target_logfilenames:
        target_logfilename = target_logfilename.replace(' ','').replace('\n','')
        logfilepath = row['dat_path'][3:]
        logfilepath = logfilepath[:logfilepath.rfind('/')] + '/' + target_logfilename
    target_logfilenames = list(set(target_logfilenames))
    #linuxから各ログファイル情報（存在するもののみ）を取得
    files_dict = {}
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        logs = fsx_ontap.get_loglist(company_code, target_logfilenames)
        for data in logs:
            dir_path = os.path.dirname(data['filename'])
            file_name = os.path.basename(data['filename'])
            if dir_path in files_dict:
                files_dict[dir_path].append(file_name)
            else:
                files_dict[dir_path] = [file_name]
    else:
        logs = ssm.get_loglist(company_code, target_logfilenames)
        for data in logs:
            dir_path = "/".join(data['filename'].split("/")[5:-1])
            file_name = data['filename'].split("/")[-1]
            if dir_path in files_dict:
                files_dict[dir_path].append(file_name)
            else:
                files_dict[dir_path] = [file_name]

    for key in files_dict:
        for row in rows:
            dat_path = "/".join(row['dat_path'][3:].split("/")[:-1])
            if (key == dat_path):
                for logs in files_dict[key]:
                    new_row = row.copy()
                    new_row['log_file_name'] = logs
                    new_rows.append(new_row)
    print(new_rows)

    return json.dumps(new_rows)