from flask import Flask, Blueprint, render_template, current_app
from flask import Blueprint, render_template
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.model.tables import *
from src.component.function.solver import solver_logic
from src.component.common.aws import aws
from src.component.function.user import user_logic
from flask_cors import cross_origin
import boto3
from src.component.common.storage import ssm, fsx_ontap # env_id取得のため

solver_bp = Blueprint('solver', __name__, url_prefix='/solver')


@solver_bp.route('/loglist', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def loglist():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    return solver_logic.get_log_list(user['email'])

@solver_bp.route('/logfilelist', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def logfilelist():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    t_solver_id = request.headers.get("t_solver_list_id")
    print(t_solver_id)
    return solver_logic.get_logfile_list(user['email'], company_code, t_solver_id)

@solver_bp.route('/list', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
# Redmine 5760 のため修正
def list():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    rows = solver_logic.get_solverlist(user['email'])
    for row in rows:
        project_file_path = ''
        dat_path_org = row['dat_path']
        product = row['product']
        if(product == None):
            product = ''
        else:
            product = product.upper()
        if product == 'SIMUFACT':
            # Simufact Formingの場合
            #・Simufact：プロジェクトファイル*.sfpの保存場所
            project_file_path = dat_path_org
            replace_str = project_file_path.split('/')[len(project_file_path.split('/'))-6] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-5] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-4] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-3] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-2] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-1]
            project_file_path = project_file_path.replace(replace_str, '')
        elif product == 'NASTRAN' or product == 'MARC' \
            or product == 'CRADLE' or product == 'CRADLE_MESH' \
            or product == 'ST' or product == 'SCFLOW':
            # Nastranの場合、Marcの場合、Cradleの場合
            #・Cradle：入力データ(scFLOWは*.gph, .*sph、STREAMは*.s)の保存場所
            #・Marc：入力データ(*.dat)の保存場所
            project_file_path = dat_path_org.replace(dat_path_org.split('/')[len(dat_path_org.split('/'))-1],'')
        row['project_file_path'] = project_file_path
    return json.dumps(rows)

@solver_bp.route('/delete', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def delete():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    solver_logic.delete(user['email'], request.form.get('t_solver_list_id'))
    return 'Okay!'

@solver_bp.route('/cancel', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def cancel():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    solver_logic.cancel(user['email'], request.form.get('t_solver_list_id'))
    return 'Okay!'

@solver_bp.route('/changetime', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def changetime():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    result = solver_logic.changetime(user['email'], request.form.get('t_solver_list_id'), request.form.get('night_process_flag'))
    if result:
        return {'result' : 'NG', 'error' : result}

    return {'result' : 'OK'}

@solver_bp.route('/logs', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def log():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    t_solver_list_id = request.args.get('t_solver_list_id')
    limitFlg = request.args.get('limitFlg')
    if limitFlg == 'false':
        limitFlg = False
    else:
        limitFlg = True
    if ('log_file_name' in request.args):
        log_file_name = request.args.get('log_file_name')
        if (log_file_name[-1] == '*'):
            log_file_name = log_file_name[:-1]
        return solver_logic.get_one_log(user['email'], company_code, t_solver_list_id, log_file_name, limitFlg)
    else:
        return solver_logic.get_log(user['email'], company_code, t_solver_list_id)

@solver_bp.route('/start', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def start():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    env_id = ssm.get_env_id(company_code)
    print('env_id取得：' + env_id)
    directory_username = user_logic.get_directory_user(user['email']) + '@' + current_app.config["DOMAIN_NAME"]
    system_id = current_app.config['SYSTEM_ID']
    service_id = user_logic.get_user_service_id(user['user_metadata'], company_code)

    job_command = request.form.get('job_command')
    if job_command != '':
        job_command = ' ' + job_command

    # ファイルをS3に保存
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        file_path = fsx_ontap.get_file(company_code, request.form.get('s3_path'))
    else:
        file_path = ssm.get_file(company_code, request.form.get('s3_path'))
    #if 'nastran' == request.form.get('solver_type'):
    #    s3 = boto3.resource('s3')
    #    bucket = s3.Bucket(current_app.config['STORAGE_SOLVER_BUCKET_NAME'])
    #    bucket.upload_file(file_path, 'solver_bat_files/' + file_path.split('/')[len(file_path.split('/')) -1])

    response = aws.invoke_lambda(
        'RequestResponse',
        current_app.config['LAMBDA_SOLVER_START'],
        json.dumps({
                    'job_command': job_command,
                    's3_path': 'S:/' + request.form.get('s3_path'),
                    'solver_type': request.form.get('solver_type'),
                    'version': request.form.get('version'),
                    'system_id': system_id,
                    'service_id': service_id,
                    # 'project_id': company_code, #<=====env_idに修正すべきでは？
                    'project_id': env_id,
                    'username': directory_username,
                    # 'product_code': request.form.get('product_code'), // product_codeは不要
                    'night_process_flag': request.form.get('night_process_flag'),
                    'job_ddm_number': request.form.get('job_ddm_number'),
                    'job_smp_number': request.form.get('job_smp_number'),           # アセンブリーとリカバリー
                    'job_thread_number': request.form.get('job_thread_number'),     # マトリクスソルバー
                    'job_core_number': request.form.get('job_core_number')
                    })
    )
    return 'Okay!'