from flask import Flask, Blueprint, render_template, current_app
from src.component.model.simsp import mscone_lic as sml
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.common.pdbc import pdbc, db_hosts
from src.component.common.storage import ssm
import time
from src.component.common.entraid.component import Auth0Component
from datetime import datetime

def get_notice(services):
    now = datetime.now()
    now = now.strftime('%Y-%m-%d')
    services_tuple = tuple(services)
    notice = pdbc.select_param(db_hosts.platform(),
            '''
                SELECT
                    to_char(udate, 'YYYY/MM/DD'),
                    notice_type,
                    overview,
                    notice_path
                FROM
                    user_infrastructure.m_notice
                WHERE
                    (service_id in %(service_id)s 
                    OR (system_id is null AND service_id is null)
                    OR system_all = true)
                    AND notice_valid = true
                Order by udate desc

            ''', { 'service_id' : services_tuple})
    print(notice)
    return json.dumps(notice)

def get_user_info(auth):
    auth0 = Auth0Component()
    """
    entra切り替えのためいらなくなった
    auth0.AUTH0_AUDIENCE =  current_app.config["PORTAL_API_AUDIENCE"]
    auth0.AUTH0_CLIENT_ID = current_app.config["PORTAL_AUTH0_CLIENT_ID"]
    auth0.AUTH0_CLIENT_SECRET = current_app.config["PORTAL_AUTH0_CLIENT_SECRET"]
    """
    auth0.get_token()
    metadata = auth0.get_user_by_auth(auth)['user_metadata']['data']
    list_name_service = []
    list_service_code = []
    roles = []
    for row in metadata:
        if (row['company_code'] != current_app.config['STAFF_COMPANY_CODE']):
            if ((row['service_id'] not in list_service_code) & (row['service_id'] != current_app.config['STAFF_SERVICE_ID']) & (row['service_id'] != current_app.config['NON_SERVICE_ID'])):
                list_name_service.append({'company_code': row['company_code'], 'service_id': row['service_id']})
                list_service_code.append(row['service_id'])
                for role in row['roles']:
                    roles.append(role)
        else:
            if ('admin_staff' in row['roles']):
               for role in row['roles']:
                    roles.append(role)
    if roles == []:
        return { 'none': '' }
    roles =  list(set(roles))
    list_service_code = tuple(list_service_code)
    roles = tuple(roles)
    service_names = pdbc.select_param(db_hosts.platform(),
            '''
                SELECT
                    service_id,
                    service_name
                FROM
                    billing_infrastructure.m_services
                WHERE
                    service_id in %(service_id)s

            ''', { 'service_id' : list_service_code})
    role_menu = pdbc.select_param(db_hosts.simsp(),
            '''
                SELECT
                    menu_id
                FROM
                    mscone_lic.m_menu_control
                WHERE
                    role_name in %(roles)s

            ''', { 'roles' : roles})
    print(role_menu)
    return_data = {}
    service = {}
    if (len(list_name_service) > 0):
        for name_service in list_name_service:
            com = name_service['company_code']
            ser = name_service['service_id']
            if com not in service:
                service[com] = {'company_code': '', 'services': {}}
            service[com]['services'][ser] = {}
            for service_name in service_names:
                if (service_name['service_id'] == ser):
                    service[com]['services'][ser]['service_name'] = service_name['service_name']
    menus = []
    for menu in role_menu:
        menus.append(menu['menu_id'])
    menus = list(set(menus))
    return_data['menus'] = menus
    return_data['service'] = service
    return return_data

def get_notice_file(ref):
    #with open('src/component/function/portal/notice/' + ref + '.txt','r',encoding="utf-8_sig") as f:
    with open('src/component/function/portal/notice/' + 'ndes' + '.txt','r',encoding="utf-8_sig") as f:
        text_message = f.read()
    return { 'text_message': text_message }

def edit_notice_file(ref, text):
    print(text)
    #with open('src/component/function/portal/notice/' + ref + '.txt','w',encoding="utf-8_sig") as f:
    with open('src/component/function/portal/notice/' + 'ndes' + '.txt','w',encoding="utf-8_sig") as f:
        f.write(text)
    return {'text_message': 'OK!'}