from flask import Flask, Blueprint, render_template, current_app
from flask import Blueprint, render_template
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.common.aws import aws
from src.component.model.tables import *
from src.component.function.app import app_logic
from src.component.function.portal import portal_logic
from flask_cors import cross_origin

portal_bp = Blueprint('api', __name__, url_prefix='/api')

@portal_bp.route('/account', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuthPortal
def account():
    role = portal_logic.get_user_info(request.headers.get("Authorization", None))
    print(role)

    return json.dumps(role)

@portal_bp.route('/notice', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuthPortal
def get_notice():
    referrer = request.headers.get("Referer")
    ref_list = referrer.split('/')
    print(referrer)
    ref = ref_list[-1]
    role = portal_logic.get_user_info(request.headers.get("Authorization", None))
    service_list = []
    if 'service' not in role:
        return { 'text_message': '' }
    for kye in role['service']:
        services = role['service'][kye]
        for service in services:
            service_list.append(service)
    return portal_logic.get_notice_file(ref)

@portal_bp.route('/edit_notice', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuthPortal
def edit_notice():
    referrer = request.headers.get("Referer")
    ref_list = referrer.split('/')
    text = request.json['text']
    print(referrer)
    ref = ref_list[-1]
    role = portal_logic.get_user_info(request.headers.get("Authorization", None))
    service_list = []
    for kye in role['service']:
        services = role['service'][kye]
        for service in services:
            service_list.append(service)
    return portal_logic.edit_notice_file(ref, text)
