from ast import Constant
from flask import Flask, Blueprint, render_template, send_file, current_app
from src.component.decorator.authenticate import *
from src.component.common.pdbc import db_hosts, pdbc
from src.component.common.constants import constants
from src.component.function.app import app_logic
from src.component.common.aws import aws
from flask_cors import cross_origin
from decimal import Decimal
import math
    
def get_history(company_code, year, month):

    data = {
        'company_code' : company_code,
        'year' : year,
        'month' : month
    }
    return json.dumps(get_summary(data), default=decimal_default_proc)

def get_pre_total_duration(data):
    sql = '''
        SELECT
            uimc.company_code,
            CEIL(coalesce(cast(SUM(bibi.usage) as REAL), 0) / cast(60 as REAL)) AS usage_h
        FROM
            user_infrastructure.m_contract uimc
        LEFT JOIN
            user_infrastructure.m_contract_product uimp
            ON uimp.contract_id = uimc.contract_id
        LEFT JOIN
            billing_infrastructure.billing_information bibi
            ON bibi.contract_product_id = uimp.contract_product_id
        WHERE
            uimc.company_code = %(company_code)s AND
            extract(year FROM start_date) = %(year)s AND
            lpad(CAST(extract(month FROM start_date) AS text) , 2 ,'0') = %(month)s AND
            uimp.product_id IN ('RP000003','RP000004','RP000005')
        GROUP BY
            uimc.company_code,
            uimc.contract_id
        UNION ALL
            SELECT
                %(company_code)s AS company_code,
                '0' AS usage_h
    '''
    return pdbc.select_param(db_hosts.platform(), sql, data)[0]['usage_h']

def get_solver_total_duration(data):
    sql = '''
        SELECT
            uimc.company_code,
            CEIL(coalesce(cast(SUM(bibi.usage) as REAL), 0) / cast(60 as REAL)) AS usage_h
        FROM
            user_infrastructure.m_contract uimc
        LEFT JOIN
            user_infrastructure.m_contract_product uimp
            ON uimp.contract_id = uimc.contract_id
        LEFT JOIN
            billing_infrastructure.billing_information bibi
            ON bibi.contract_product_id = uimp.contract_product_id
        WHERE
            uimc.company_code = %(company_code)s AND
            extract(year FROM start_date) = %(year)s AND
            lpad(CAST(extract(month FROM start_date) AS text) , 2 ,'0') = %(month)s AND
            uimp.product_id IN ('RP000006','RP000007','RP000008','RP000009')
        GROUP BY
            uimc.company_code,
            uimc.contract_id
        UNION ALL
            SELECT
                %(company_code)s AS company_code,
                '0' AS usage_h
    '''
    return pdbc.select_param(db_hosts.platform(), sql, data)[0]['usage_h']

def get_summary(data):
    durations = {}
    sql = '''
        SELECT
            uimp.product_id as product_id,
            bibi.usage as usage_min, /*利用分数*/
            cast(split_part(brp.calc_unit,'　',1) as integer) as unit_num,
            split_part(brp.calc_unit,'　',2) as unit_name
        FROM
            user_infrastructure.m_contract uimc
        LEFT JOIN
            user_infrastructure.m_contract_product uimp
            ON uimp.contract_id = uimc.contract_id
        LEFT JOIN
            billing_infrastructure.billing_information bibi
            ON bibi.contract_product_id = uimp.contract_product_id
        LEFT JOIN
            billing_infrastructure.m_regular_products brp
            ON uimp.product_id = brp.product_id
        WHERE
            uimc.company_code = %(company_code)s AND
            extract(year FROM start_date) = %(year)s AND
            lpad(CAST(extract(month FROM start_date) AS text) , 2 ,'0') = %(month)s AND
            uimp.product_id IN ('RP000003','RP000004','RP000005','RP000006','RP000007','RP000008','RP000009')
    '''
    results = pdbc.select_param(db_hosts.platform(), sql, data)
    print('summary res=' + str(results))
    if results == None or len(results) == 0:
        durations['no_data_message'] = constants.USAGE_MESSAGES_NO_DATA
        return durations

    # product_id,usage_min, /*利用分数*/ unit_num, unit_name
    pidusages = {}
    for r in results:
        pid = r['product_id']
        umin = r['usage_min']
        unum = r['unit_num']
        uname = r['unit_name']
        rate = 1 #単位によって時数に変換する倍率
        if uname == '秒':
            rate = 1 / 60
        elif uname == '時':
            rate = 60
        uh = math.ceil(umin / (unum*rate))
        # print('pid='+pid+ ' uh='+str(uh))
        if( pid in pidusages ):
            pidusages[pid] +=uh
        else:
            pidusages[pid] =uh
    print('pidusages=' + str(pidusages)) # product_id毎に集計した結果

    #prepost 'RP000003','RP000004','RP000005'
    pusage_h = 0
    for pid in ['RP000003','RP000004','RP000005']:
        if pid in pidusages:
            pusage_h += pidusages[pid]
    #solver 'RP000006','RP000007','RP000008','RP000009'
    susage_h = 0
    for pid in ['RP000006','RP000007','RP000008','RP000009']:
        if pid in pidusages:
            susage_h += pidusages[pid]

    durations['no_data_message'] = ''
    if constants.PRODUCT_ID_SIMUFACT_PRE in pidusages:
        durations['row_Simufact_Forming_pre'] = {'application_name' : constants.PRODUCT_LABEL_SIMUFACT_FORMING, 'duration' : pidusages[constants.PRODUCT_ID_SIMUFACT_PRE]}
    else:
        durations['row_Simufact_Forming_pre'] = {'application_name' : constants.PRODUCT_LABEL_SIMUFACT_FORMING, 'duration' : 0}
    if constants.PRODUCT_ID_SIMUFACT_SOLVER in pidusages:
        durations['row_Simufact_Forming_solver'] = {'application_name' : constants.PRODUCT_LABEL_SIMUFACT_FORMING, 'duration' : pidusages[constants.PRODUCT_ID_SIMUFACT_SOLVER]}
    else:
        durations['row_Simufact_Forming_solver'] = {'application_name' : constants.PRODUCT_LABEL_SIMUFACT_FORMING, 'duration' : 0}
    if constants.PRODUCT_ID_MARC_PRE in pidusages:
        durations['row_Marc_Mentat_pre'] = {'application_name' : constants.PRODUCT_LABEL_MARC_MENTAT, 'duration' : pidusages[constants.PRODUCT_ID_MARC_PRE]}
    else:
        durations['row_Marc_Mentat_pre'] = {'application_name' : constants.PRODUCT_LABEL_MARC_MENTAT, 'duration' : 0}
    if constants.PRODUCT_ID_MARC_SOLVER in pidusages:
        durations['row_Marc_Mentat_solver'] = {'application_name' : constants.PRODUCT_LABEL_MARC_MENTAT, 'duration' : pidusages[constants.PRODUCT_ID_MARC_SOLVER]}
    else:
        durations['row_Marc_Mentat_solver'] = {'application_name' : constants.PRODUCT_LABEL_MARC_MENTAT, 'duration' : 0}
    if constants.PRODUCT_ID_CRADLE_CFD_PRE in pidusages:
        durations['row_Cradle_CFD_pre'] = {'application_name' : constants.PRODUCT_LABEL_CRADLE_CFD, 'duration' : pidusages[constants.PRODUCT_ID_CRADLE_CFD_PRE]}
    else:
        durations['row_Cradle_CFD_pre'] = {'application_name' : constants.PRODUCT_LABEL_CRADLE_CFD, 'duration' : 0}
    if constants.PRODUCT_ID_CRADLE_CFD_SOLVER in pidusages:
        durations['row_Cradle_CFD_solver'] = {'application_name' : constants.PRODUCT_LABEL_CRADLE_CFD, 'duration' : pidusages[constants.PRODUCT_ID_CRADLE_CFD_SOLVER]}
    else:
        durations['row_Cradle_CFD_solver'] = {'application_name' : constants.PRODUCT_LABEL_CRADLE_CFD, 'duration' : 0}
    if constants.PRODUCT_ID_NASTRAN_SOLVER in pidusages:
        durations['row_MSC_Nastran_solver'] = {'application_name' : constants.PRODUCT_LABEL_NASTRAN, 'duration' : pidusages[constants.PRODUCT_ID_NASTRAN_SOLVER]}
    else:
        durations['row_MSC_Nastran_solver'] = {'application_name' : constants.PRODUCT_LABEL_NASTRAN, 'duration' : 0}
    durations['row_pre_total_duration'] = pusage_h
    durations['row_solver_total_duration'] = susage_h

    print(durations)
    return durations


# 利用上限金額・利用金額の取得
def get_amounts(company_code, system_id, service_id):
    data = {
        'company_code' : company_code,
        'system_id' : system_id,
        'service_id': service_id
    }


    # 利用上限金額・利用金額の取得の取得
    amount_upper_limit = comma_separated_yen(get_amount_upper_limit(data))
    used_amounts, is_used  = get_used_amounts(data)
    used_amounts  = comma_separated_yen(used_amounts)

    amounts = {
        'amount_upper_limit': amount_upper_limit,
        'used_amounts': used_amounts
    }
    return json.dumps(amounts, default=decimal_default_proc), is_used

# 利用上限金額の取得
def get_amount_upper_limit(data):
    sql = '''
        SELECT
            uimc.company_code,
            uimc.amount_upper_limit_flg,
            uimc.amount_upper_limit
        FROM
            user_infrastructure.m_contract uimc
        INNER JOIN
            user_infrastructure.t_manage_request uitmr
            ON uimc.contract_id = uitmr.contract_id
        WHERE
            uimc.company_code = %(company_code)s AND
            uitmr.system_id = %(system_id)s
    '''
    results = pdbc.select_param(db_hosts.platform(), sql, data)

    if results[0]['amount_upper_limit_flg'] == True:
        return results[0]['amount_upper_limit']
    elif results[0]['amount_upper_limit_flg'] == False:
        return 'なし'


# 利用金額の取得
def get_used_amounts(data):
    contract_id = app_logic.get_contract_id(data['company_code'], data['system_id'], data['service_id'])
    #Lambda呼び出し
    Payload = json.dumps({'contract_id': contract_id})
    response = aws.invoke_lambda(
            'RequestResponse',
            current_app.config['LAMBDA_CALCULATE_MONTHLY_CHARGES'],
            Payload
        )
    results = None
    is_used = False
    if 'StatusCode' in response and response['StatusCode'] == 200:
        # レスポンス読出し
        Payload = json.loads(response['Payload'].read())
        print("---03: body:")
        print(Payload)
        results = json.loads(Payload['body'])
        if 'total_amount' in results and int(results['total_amount']) > 0:
            is_used = True

    if not results or 'total_amount' not in results:
        return 0, is_used
    else:
        return int(results['total_amount']), is_used

# 数値をコンマ区切りにして"円"を追加
def comma_separated_yen(num):
    if type(num) is str:
        return num
    else:
        num = f"{num:,}" + ' 円'
        return num

def decimal_default_proc(obj):
    if isinstance(obj, Decimal):
        return float(obj)
    raise TypeError('TypeError')