from flask import Blueprint, render_template
from src.component.decorator.authenticate import *
from flask_cors import cross_origin
import time
import boto3
import os
import uuid
import datetime
from src.component.function.history import history_logic
from src.component.function.user import user_logic
from src.component.common.constants import constants
from pytz import timezone

history_bp = Blueprint('history', __name__, url_prefix='/history')

@history_bp.route('/list', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@AdminGeneralUser
@RequiredAuth
def nodes_get():
    year = request.args.get('year')
    month = request.args.get('month')
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)    
    user_metadata = user['user_metadata']
    service_id = user_logic.get_user_service_id(user_metadata, company_code)

    # 利用時間取得
    history = {}
    # history = history_logic.get_history(company_code, year, month)
    # print('### history -------')
    # print(history)

    # 今月かどうかの確認
    current_date = datetime.datetime.now().astimezone(timezone('Asia/Tokyo')).replace(tzinfo=None)
    current_year = str(current_date.year)
    if current_date.month < 10:
        current_month = '0' + str(current_date.month)
    else:
        current_month = str(current_date.month)
    print('year: ' + year)
    print('month: ' + month)
    print('current_year: ' + current_year)
    print('current_month: ' + current_month)
    if year == current_year and month == current_month:
        # 利用金額・利用上限金額取得
        amounts, is_used = history_logic.get_amounts(company_code, current_app.config['SYSTEM_ID'], service_id)
        print('### amounts -------')
        print(amounts)

        if is_used:
            history['no_data_message'] = ''
        else:
            history['no_data_message'] = constants.USAGE_MESSAGES_NO_DATA
        history = json.dumps(history)
        current_year_month_flg = True
    else:
        amounts = json.dumps([])
        history = json.dumps([])
        current_year_month_flg = False

    return {
        'history': json.loads(history),
        'amounts': json.loads(amounts),
        'currentYearMonthFlg': current_year_month_flg
    }
