from warnings import catch_warnings
from flask import Flask, Blueprint, render_template, send_file, current_app, make_response, Response, request
from src.component.common.entraid.component import Auth0Component
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.model.tables import *
from src.component.common.storage import fsx
from src.component.common.storage import fsx_ontap
from src.component.common.storage import ssm
import boto3
import uuid
import os
import base64
import time

def node_get(company_code, prefix):
    #return fsx.get_list(company_code, prefix)
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        return fsx_ontap.get_list(company_code, prefix)
    else:
        return ssm.get_list(company_code, prefix)

def create_directory(company_code, prefix):
    #return fsx.make_dir(company_code, prefix)
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        return fsx_ontap.make_dir(company_code, prefix)
    else:
        return ssm.make_dir(company_code, prefix)

def rename(company_code, old_name, new_name):
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        return fsx_ontap.rename(company_code, old_name, new_name)
    else:
        return ssm.rename(company_code, old_name, new_name)

def delete(company_code, folder_name, prefixes):
    if current_app.config.get('STORAGE_FSX_ONTAP'):
        return fsx_ontap.delete(company_code, folder_name, prefixes)
    else:
        return ssm.delete(company_code, folder_name, prefixes)

def upload(company_code, folder_name, request):
    if current_app.config.get('FILE_UPDOWN_ONTAP'):
        return fsx_ontap.upload(company_code, folder_name, request)
    else:
        return ssm.upload(company_code, folder_name, request)

def download(company_code, prefix, items):
    if current_app.config.get('FILE_UPDOWN_ONTAP'):
        return fsx_ontap.download(company_code, prefix, items)
    else:
        return ssm.download(company_code, prefix, items)
