from flask import Blueprint, render_template, request
from src.component.decorator.authenticate import *
from flask_cors import cross_origin
from src.component.function.folder import folder_logic
from src.component.function.user import user_logic
from src.component.common.aws import aws
from src.component.model.simsp import mscone_lic as sml
from src.component.common.pdbc import db_hosts, pdbc
from src.component.common.constants import constants
from datetime import datetime as dt
from datetime import timedelta
import random, string

folder_bp = Blueprint('folder', __name__, url_prefix='/folder')

@folder_bp.route('/nodes', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def nodes_get():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    print(request.args.get('folder_name').replace('//', '/'))
    return folder_logic.node_get(company_code, request.args.get('folder_name').replace('//', '/'))

@folder_bp.route('/new', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopUser
def new():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    folder_name = request.form.get('folder_name')
    if folder_name.startswith("/"):
        folder_name = folder_name[1:]
    prefix = folder_name
    folder_logic.create_directory(company_code, prefix)

    return 'Okay!'

@folder_bp.route('/rename', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopUser
def rename():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    old_name = request.form.get('old_name')
    new_name = request.form.get('new_name')

    return folder_logic.rename(company_code, old_name, new_name)

@folder_bp.route('/delete', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopUser
def delete():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    folder_name = request.form.get('folder_name')
    prefixes = json.loads(request.form.get('prefixes'))

    folder_logic.delete(company_code, folder_name, prefixes)

    return 'Okay!'

@folder_bp.route('/upload', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopUser
def upload():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    folder_name = request.args.get('folder_name')
    return folder_logic.upload(company_code, folder_name, request)

@folder_bp.route('/download', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopUser
def download():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    prefix = request.args.get('prefix')
    items = json.loads(request.args.get('items'))

    return folder_logic.download(company_code, prefix, items)

@folder_bp.route('/ftp', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopUser
def ftp():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    replace_flg = False
    #DB取得
    ftpusers_condition = sml.TFtpUsers()
    ftpusers_condition.username = user['email']
    ftp_access_info_list = pdbc.select(db_hosts.simsp(), ftpusers_condition)
    if request.form.get('delete_check') != 'null':
        replace_flg = True
    if len(ftp_access_info_list) == 1 and not replace_flg:
        #取得
        return {
            'ftp_host_port':current_app.config["STORAGE_SUPPORT_FTP_HOST_PORT"],
            'ftp_username':ftp_access_info_list[0]['ftp_username'],
            'ftp_password':ftp_access_info_list[0]['ftp_password'],
            'ftp_expiration_date':ftp_access_info_list[0]['ftp_expiration_date'].strftime('%Y/%m/%d %H:%M')
        }
    else:
        if len(ftp_access_info_list) != 0:
            #ユーザー情報削除(DB)
            ftpusers_condition = sml.TFtpUsers()
            ftpusers_condition.username = user['email']
            pdbc.delete(db_hosts.simsp(), ftpusers_condition)
            #ユーザー情報削除(サーバー)
            aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'userdel -rf ' + ftp_access_info_list[0]['ftp_username'])
            aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'rm -rf /etc/vsftpd/conf/' + ftp_access_info_list[0]['ftp_username'])
        #FTPユーザー作成
        ftp_username = randomname(12)
        ftp_password = randomname(24)
        filename = randomname(36)
        exp_time = dt.now().replace(minute=0, second=0, microsecond=0) + timedelta(hours=49)
        userinfo = ftp_username+':'+ftp_password+':1001:1001::/home/'+ftp_username+':/bin/bash'
        aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'touch /root/adduser/' + filename)
        aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'echo ' +  userinfo + ' > /root/adduser/'  + filename)
        aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'newusers /root/adduser/' + filename)
        aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'usermod -G root ' + ftp_username)
        aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'touch /etc/vsftpd/conf/' + ftp_username)
        # aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'echo local_root=/home/admin@appstream.msc/mnt/' + company_code + '/ > /etc/vsftpd/conf/' + ftp_username)
        aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'echo local_root=/home/admin@' + current_app.config["STORAGE_DOMAIN_NAME"] + '/mnt/' + company_code + '/ > /etc/vsftpd/conf/' + ftp_username)
        aws.run_command(current_app.config["STORAGE_SUPPORT_FTP_SERVER_INSTANCE_ID"], 'AWS-RunShellScript', 'rm -rf /root/adduser/' + filename)
        #ユーザー情報登録
        ftpusers_condition = sml.TFtpUsers()
        ftpusers_condition.company_code = company_code
        ftpusers_condition.username = user['email']
        ftpusers_condition.ftp_username = ftp_username
        ftpusers_condition.ftp_password = ftp_password
        ftpusers_condition.ftp_expiration_date = exp_time
        pdbc.insert(db_hosts.simsp(), ftpusers_condition)
        return  {
            'ftp_host_port':current_app.config["STORAGE_SUPPORT_FTP_HOST_PORT"],
            'ftp_username':ftp_username,
            'ftp_password':ftp_password,
            'ftp_expiration_date':exp_time.strftime('%Y/%m/%d %H:%M')
        }

def randomname(n):
   randlst = [random.choice(string.ascii_letters + string.digits) for i in range(n)]
   return ''.join(randlst)