import json
import os
import boto3
from flask import current_app
from flask import current_app, request
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
import psycopg2
import numpy as np
import re
import datetime
#import openai
#from pgvector.psycopg2 import register_vector

#ローカルでLmabda疑似実装用
#from src.component.function import faq_lambda
#from src.component.function import faq_lambda_vec 

import datetime
#from pgvector.psycopg import register_vector



def db_conn(): 
    host = current_app.config["DATABASE_HOST"]
    port = current_app.config["DATABSE_PORT"]
    dbname = current_app.config["DATABASE_NAME"]
    user = current_app.config["DATABASE_USERNAME"]
    password = current_app.config["DATABASE_PASSWORD"]
    
    conn = psycopg2.connect(" host=" + host +
                            " port=" + port +
                            " dbname=" + dbname +
                            " user=" + user +
                            " password=" + password)
    #追加・編集 ローカル用
    """
    conn = psycopg2.connect(host='localhost',
                user='postgres',
                password='NDESpass0',
                database='postgres',
                port=5432)
    """ 
    return conn


def status_check(system_id):
    conn = db_conn()
    cur = conn.cursor()
    #追加・編集　ローカル用
    cur.execute(f"""SELECT * FROM user_infrastructure.t_file_info WHERE system_id = %s ORDER BY file_id DESC LIMIT 1""", (system_id,))
    #cur.execute("SELECT * FROM user_infrastructure.t_file_info ORDER BY file_id DESC LIMIT 1")
    conn.commit()
    file_info = cur.fetchone()
    if file_info != None:
        file_info = list(file_info or [])
        if file_info[2] is None:
            return json.dumps(file_info)
        file_info[2] = file_info[2].strftime('%y/%m/%d')
    return json.dumps(file_info)


def reload(request):
    service_id = request.args.get('system_id')
    system_id = get_system_id(service_id)
    file_info = json.loads(status_check(system_id))
    conn_faq = db_conn()
    if file_info == None:
        return json.dumps(None)
    
    if file_info[4] == 'ベクトル化実施中':
        cur_embedding_check = conn_faq.cursor()
        sql_embedding_check = f"""SELECT COUNT (*) FROM user_infrastructure.t_tickets WHERE system_id=%s and embedding IS NULL"""

        cur_embedding_check.execute(sql_embedding_check,(system_id,))
        conn_faq.commit()
        embedding_info = cur_embedding_check.fetchone()  
        embedding_info=int((str(embedding_info)).replace(',','').replace('(','').replace(')',''))

        if embedding_info < 1:
            conn = db_conn()
            cur = conn.cursor()
            sql = f"""UPDATE user_infrastructure.t_file_info SET status = 'ベクトル化済み' WHERE file_id=%s AND  status = 'ベクトル化未実施'"""

            cur.execute(sql,(file_info[5],))
            return status_check(system_id)
        else:
            return 'ベクトル化実施中です'


    elif file_info[4] == 'FAQ自動生成中':
        cur_faq_check = conn_faq.cursor()
        sql_faq_check = f"""SELECT COUNT (*) FROM user_infrastructure.t_generate_faq INNER JOIN ( SELECT MAX(faq_cdate) AS max_date FROM user_infrastructure.t_generate_faq WHERE system_id=%s) AS latest_date ON user_infrastructure.t_generate_faq.faq_cdate = latest_date.max_date;"""
        cur_faq_check.execute(sql_faq_check,(system_id,))
        conn_faq.commit()
        faq_info =cur_faq_check.fetchone()
        faq_info =int((str(faq_info)).replace(',','').replace('(','').replace(')',''))
        print(faq_info)

        if faq_info > 0:
            conn = db_conn()
            cur = conn.cursor()
            sql = f"""UPDATE user_infrastructure.t_file_info SET status = 'FAQ自動生成済み' WHERE file_id=%s """
            cur.execute(sql,(file_info[5],))
            return status_check(system_id)
        else:
            return 'FAQ自動生成中です'
        
    elif file_info[4] == 'FAQ自動生成済み':
        conn = db_conn()
        cur = conn.cursor()
        #★
        sql = f"""SELECT t1.inquiry, t1.answer, t2.faq_question, t2.faq_answer, t1.id FROM user_infrastructure.t_tickets t1 INNER JOIN user_infrastructure.t_generate_faq t2 ON t1.id = t2.id_t_support_inquiry_record WHERE t1.system_id = %s"""
        cur.execute(sql, (system_id,))
        conn.commit()
        faq_info = cur.fetchall()
        faq_info = list(faq_info)
        Question=[]
        Q_ref=[]
        Answer=[]
        A_ref=[]
        Check=[]
        id = []
        faq_display_info = []

        for i in range(len(faq_info)):
            Question.append(faq_info[i][0])
            Q_ref.append(faq_info[i][1])
            Answer.append(faq_info[i][2])
            A_ref.append(faq_info[i][3])
            Check.append('')
            id.append(faq_info[i][4])
            file_info = json.loads(status_check(system_id))
            faq_display_info=[Question,Q_ref,Answer,A_ref,Check,id,file_info]
        return json.dumps(faq_display_info) 

    else:
        return json.dumps(file_info)
    

def upload(request, user_id):
    service_id = request.form.get('system_id')
    system_id = get_system_id(service_id)
    
    file_info = json.loads(status_check(system_id))
    if file_info != None:
        status = file_info[4]
        print(status)
    if file_info == None or status == 'ファイルなし' or status == 'CSV出力済み' or status == 'FAQ自動生成済み':
        print("upload first")
        
        #ステータス管理'ファイルなし'->'ベクトル化未実施'
        status = 'ベクトル化未実施'
        upload_date = datetime.datetime.now()
        for key in request.files:
            print(key)
        filename = key
        size = request.files.__sizeof__()

        conn = db_conn()
        cur = conn.cursor()
        cur.execute(f"""INSERT INTO user_infrastructure.t_file_info (filename, changer_name, upload_date, size, status, system_id) VALUES(%s,%s,%s,%s,%s,%s)""",
                    (filename,user_id,upload_date,size,status, system_id))
        conn.commit() 
        file_info = json.loads(status_check(system_id))
        
        #ファイルの中身の情報を取得(ファイル名、サイズ、中身など)
        for key in request.files:
            print(key)
        file = request.files.get(key)
        file_contents = file.read()

        data = re.split('\r\n',file_contents.decode())
        data.pop(0)

        post_data =[]
        for i in range(len(data)):
            data[i] = re.split(',',data[i])
            #csv修正による影響？
            if len(data[i]) == 10:
                post_data += data[i]
            else:
                continue  
        #ここもカラムが8列から10列に変わった
        post_data = np.array(post_data).reshape(int(len(post_data)/10),10)
         
        return register_data(post_data, system_id, file_info)                    
    elif status == 'ベクトル化未実施':
        return 'ベクトル化を実施してください'
    elif status == 'ベクトル化実施中':
        return 'ベクトル化が完了するまでお待ちください'
    elif status =='ベクトル化済み':
        return 'FAQ自動生成を実施してください'
    elif status== 'FAQ自動生成中':
        return 'FAQ自動生成が完了するまでお待ちください'
    else:
        return 'error'


def register_data(data, system_id, file_info):
    system_id = str(system_id)
    conn_faq = db_conn()
    cur_faq = conn_faq.cursor()
    file_id = file_info[5]
    print("チケット登録処理")
    #チケット番号がデータベースに存在しないデータだけのリストを作成する
    register_list=[]
    ###ここの処理はリクエストが増えてしまうのであんまりよくない
    for verification in data:
        ver_num = verification[0]
        cur_faq.execute(f"""SELECT EXISTS(SELECT * FROM user_infrastructure.t_tickets WHERE inquiry_number = %s and system_id = %s)""", (ver_num, system_id))
        #↑ここのselect_param
        result = cur_faq.fetchone()
        if not result[0]:
            register_list.append(verification)


    #データベースに存在しないデータをデータベースに追加する
    for reg_data in register_list:
        #Phase8ように変更する必要有
        reg_num = str(reg_data[0])
        reg_title = reg_data[1]
        reg_inquiry = reg_data[2]
        reg_answer = reg_data[3]
        reg_date = reg_data[4]
        reg_user = reg_data[5]
        reg_manager = reg_data[6]
        reg_reference = reg_data[7]
        #phase8ように追加
        reg_project = reg_data[8]
        reg_company = reg_data[9]

        date_now = datetime.datetime.now()
        print(reg_num)
        cur_faq.execute(F"""INSERT INTO user_infrastructure.t_tickets(inquiry_number, title, inquiry, Answer, inquiry_date, inquiry_user,inquiry_manager, reference, system_id, file_id, cdate,project,inquiry_company) VALUES(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s) """,
                        (reg_num, reg_title, reg_inquiry, reg_answer, reg_date, reg_user, reg_manager, reg_reference, system_id, file_id, date_now, reg_project,reg_company))
        conn_faq.commit()
    conn_faq.close()
    return json.dumps(file_info)

def embedding(request):
    service_id = request.args.get('system_id')
    system_id = get_system_id(service_id)
    file_info = json.loads(status_check(system_id))
    status = file_info[4]

    if status == 'ベクトル化未実施':
        conn = db_conn()
        cur = conn.cursor()
        sql = "UPDATE user_infrastructure.t_file_info SET status = 'ベクトル化実施中' WHERE file_id=%s "
        cur.execute(sql,(file_info[5],))
        conn.commit()
        os.environ
        ###ここからベクトル化の処理----------
        Payload = json.dumps({'mode': 'vec', 'file_id': file_info[5], "system_id": system_id,'OpenAI_Base':current_app.config['OPENAI_BASE']})
        region_name = 'ap-northeast-1'
        
        event = json.dumps({
            "Records": [
                {
                    "body": Payload
                }
            ]
        })
        """
        faq_lambda_vec.lambda_handler(event,"")
        return status_check(system_id)
        """
        session = boto3.session.Session(region_name=region_name)
        session.client('lambda').invoke(
                FunctionName=current_app.config['LAMBDA_CREATE_GENERATE_VEC'],
                InvocationType='Event',
                Payload=event
                )
        return status_check(system_id)
    elif status == 'ファイルなし':
        return 'ファイルをアップロードしてください'                     
    elif status == 'ベクトル化実施中':
        return 'ベクトル化が完了するまでお待ちください'
    elif status == 'ベクトル化済み':
        return 'FAQ自動生成を実施してください'
    elif status == 'FAQ自動生成中':
        return 'FAQ自動生成が完了するまでお待ちください'
    elif status == 'FAQ自動生成済み':
        return 'ファイルをアップロードしてください'
    elif status == 'CSV出力済み':
        return 'ファイルをアップロードしてください'
    else:
        return 'CSVを出力してください'
    

def period_selection(request):
    period_data = (request.get_json('ary'))
    date  = []
    date.append(period_data['from'])
    date.append(period_data['to'])
    print(date)

    return faq_generate(request,date)

def faq_generate(request,date):
    service_id = request.args.get('system_id')
    system_id = get_system_id(service_id)
    file_info = json.loads(status_check(system_id))
    status = file_info[4]
    print(status)
    if status == 'ベクトル化済み' :
        #statusが'ベクトル化済み'ならFAQ自動生成実行
        #status:'ベクトル化済み'->FAQ自動生成中'
        conn = db_conn()
        cur = conn.cursor()
        sql = f"""UPDATE user_infrastructure.t_file_info SET status = 'FAQ自動生成中' WHERE file_id=%s """
        cur.execute(sql,(file_info[5],))
        conn.commit() 

        #FAQ自動生成処理-------
        date_st = str(date[0])
        date_ed = str(date[1])
        print('faq generate start')

        Payload = json.dumps({'mode': 'faq', 'file_id': file_info[5], 'system_id': system_id, 'date_st': date_st, 'date_ed': date_ed, 'OpenAI_Base':current_app.config['OPENAI_BASE']})
        region_name = 'ap-northeast-1'
        
        event = json.dumps({
            "Records": [
                {
                    "body": Payload
                }
            ]
        })
        """
        faq_lambda.lambda_handler(event, "")
        """
        session = boto3.session.Session(region_name=region_name)
        session.client('lambda').invoke(
                FunctionName=current_app.config['LAMBDA_CREATE_GENERATE_FAQ'],
                InvocationType='Event',
                Payload=event
                )
        file_info = json.loads(status_check(system_id))
        return json.dumps(file_info)
    elif status == 'ファイルなし':
        return 'ファイルをアップロードしてください' 
    elif status == 'ベクトル化未実施':
        return 'ベクトル化を実施してください'
    elif status == 'ベクトル化実施中':
        return 'ベクトル化が完了するまでお待ちください'
    elif status== 'FAQ自動生成中':
        return 'FAQ自動生成が完了するまでお待ちください'
    elif status == 'CSV出力済み':
        return 'ファイルをアップロードしてください'
    else :
        return 'FAQ自動生成済みです'


def changeQ(request): 
    print('changeQ')
    post_data=request.get_json('ary')
    print(post_data)
    conn_faq =db_conn()
    cur_faq = conn_faq.cursor()
    for i in range(len(post_data)):
        faq_checked_question = post_data[i]['Question']
        faq_register = post_data[i]['Check']
        if faq_register=='〇':
            faq_register=0
        else:
            faq_register=1
        id = post_data[i]['id']
        date_now = datetime.datetime.now()
        print(date_now)
        sql = f"""UPDATE user_infrastructure.t_generate_faq SET faq_checked_question=%s, faq_register=%s, faq_udate=%s WHERE id_t_support_inquiry_record=%s """
        cur_faq.execute(sql,(faq_checked_question, faq_register, date_now, id))
        conn_faq.commit()
    conn_faq.close()
    return 'OK'

def changeA(request): 
    print('changeA')
    post_data=request.get_json('ary')
    conn_faq = db_conn()
    cur_faq = conn_faq.cursor()
    for i in range(len(post_data)):
        faq_checked_answer = post_data[i]['Answer']
        faq_register = post_data[i]['Check']
        if faq_register=='〇':
            faq_register=0
        else:
            faq_register=1
        id = post_data[i]['id']
        date_now = datetime.datetime.now()
        sql = f"""UPDATE user_infrastructure.t_generate_faq SET faq_checked_answer=%s, faq_register=%s, faq_udate=%s WHERE id_t_support_inquiry_record=%s """
        cur_faq.execute(sql,(faq_checked_answer, faq_register, date_now, id))
        conn_faq.commit()
    conn_faq.close()
    return 'OK'

def save(request):
    body = request.get_json()
    post_data=body.get('qac_list')
    service_id = body.get('system_id')
    system_id = get_system_id(service_id)
    conn_faq = db_conn()
    cur_faq = conn_faq.cursor()
    file_info = json.loads(status_check(system_id))
    status = file_info[4]
    print(file_info[5])
    print(status)
    if status == 'FAQ自動生成済み':
        
        for i in range(len(post_data)):
            faq_checked_question = post_data[i]['Question']
            faq_checked_answer = post_data[i]['Answer']
            faq_register = post_data[i]['Check']
            if faq_register=='〇':
                faq_register=0
            else:
                faq_register=1
            id = post_data[i]['id']
            date_now = datetime.datetime.now()
            sql = f"""UPDATE user_infrastructure.t_generate_faq SET faq_checked_question=%s, faq_checked_answer=%s, faq_register=%s, faq_udate=%s WHERE id_t_support_inquiry_record=%s """
            cur_faq.execute(sql,(faq_checked_question, faq_checked_answer, faq_register, date_now, id))
            conn_faq.commit()
        conn_faq.close()
    
        conn = db_conn()
        cur = conn.cursor()
        sql = f"""UPDATE user_infrastructure.t_file_info SET status = 'CSV出力済み' WHERE file_id=%s """
        cur.execute(sql,(file_info[5],)) 
        conn.commit()
        return status_check(system_id)
    
    elif status == 'ファイルなし':
        return 'ファイルをアップロードしてください' 
    elif status == 'ベクトル化未実施':
        return 'ベクトル化を実施してください'
    elif status == 'ベクトル化実施中':
        return 'ベクトル化が完了するまでお待ちください'
    elif status == 'ベクトル化済み':
        return 'FAQ自動生成を実施してください'
    elif status== 'FAQ自動生成中':
        return 'FAQ自動生成が完了するまでお待ちください'
    elif status == 'CSV出力済み':
        return 'ファイルをアップロードしてください'
    else :
        return 'QuestionとAnswerを編集後CSV出力してください'
    

def get_system_id(service_id):
    #システムIDを取得する
    conn = db_conn()
    cur = conn.cursor()
    sql = f"""SELECT system_id FROM billing_infrastructure.m_services WHERE service_id = %s;"""
    cur.execute(sql, (service_id,))
    system_id = cur.fetchone()[0]
    return system_id


