from flask import Flask, Blueprint, render_template, current_app
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.model.tables import *
from flask_cors import cross_origin
import boto3
import time
from src.component.common.pdbc import db_hosts, pdbc
from datetime import datetime as dt
from datetime import time as d_time
import datetime

def get_data(company_code, start_day, end_day):
    end_day = dt.strptime(end_day, '%Y-%m-%d')
    print('引数企業コード[get_systemusableflag]: ' + company_code)
    #プロジェクトIDの取得
    pjcode_sql = '''
        SELECT 
            distinct substring(directory_username from 1 for position('.' in directory_username)-1) AS project_id
        From 
            mscone_lic.m_directory_user 
        Where 
            company_code = %(company_code)s 
    '''
    output_pjcode = pdbc.select_param(db_hosts.simsp(), pjcode_sql, {'company_code': company_code})
    print('output_pjcode')
    print(output_pjcode)
    print(len(output_pjcode))
    if (len(output_pjcode) == 0):
        return []
    params = {
        'project_id': output_pjcode[0]['project_id'],
        'start_day': start_day,
        'end_day': end_day
        }
    #ライセンスの履歴を取得
    exec_sql = '''
        SELECT 
            exec_type, 
            session_type, 
            username, 
            billing_code, 
            cdate,
            image_name,
            t_solver_list_id
        From 
            mscone_lic.t_exec_history 
        Where  
            project_id = %(project_id)s 
            AND cdate > %(start_day)s 
            AND cdate <= %(end_day)s + INTERVAL '1' DAY 
        ORDER BY
            exec_history_id
    '''
    exec_data = pdbc.select_param(db_hosts.simsp(), exec_sql, params)
    print('exec_data')
    print(exec_data)
    if (len(exec_data) == 0):
        return []

    start_list = []
    returnData = []
    if exec_data != []:
        for i in range(len(exec_data)):
            row = exec_data[i]
            #アプリの種類確認
            if row['exec_type'] == 'app':
                code = row['billing_code'].split('-')[-1] + '(' + row['image_name'].split('-')[-1][2:] + ')'
            else:
                code = row['billing_code'].split('_')[0] + '_solver'

            #ENDが先に来た場合ずっと使っている想定で利用時間取得
            if start_list == [] and row['session_type'] == 'END':
                diff_last = row['cdate'] - row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0)
                diff_last = int(diff_last.total_seconds() / 60)
                print(diff_last)
                returnData.append({'user': row['username'], 'app': code, 'date': row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0).strftime('%Y-%m-%d'),'time': diff_last, 'func': row['exec_type']})
            
            #STARTが来た場合、リストに追加していく
            elif row['session_type'] == 'START':
                start_list.append({'username': row['username'], 'code': code, 'cdate':row['cdate'], 'func': row['exec_type'], 'solver_id': row['t_solver_list_id']})
            #ENDになった場合、同一ユーザー同一アプリの開始時間と比較をする
            else:
                for j in range(len(start_list)):
                    s_row = start_list[j]
                    if (s_row['username'] == row['username']) and (s_row['code'] == code) and (s_row['solver_id'] == row['t_solver_list_id']):
                        if row['cdate'].date() == s_row['cdate'].date():
                            diff_time = row['cdate'] - s_row['cdate']
                            diff_time = int(diff_time.total_seconds() / 60)
                            print(diff_time)
                            returnData.append({'user': row['username'], 'app': code, 'date': s_row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0).strftime('%Y-%m-%d'),'time': diff_time, 'func': row['exec_type']})
                        else:
                            #開始日作業時間の取得
                            diff_time = s_row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0) + datetime.timedelta(days=1) - s_row['cdate']
                            diff_time = int(diff_time.total_seconds() / 60)
                            print(diff_time)
                            returnData.append({'user': row['username'], 'app': code, 'date': s_row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0).strftime('%Y-%m-%d'),'time': diff_time, 'func': row['exec_type']})
                            #開始日終了日の差を取得
                            one_day = datetime.timedelta(days=1)
                            diff_day = row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0) - s_row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0)
                            diff_int = int(diff_day / one_day) - 1
                            #1日以上空いている場合、1440分の活動とする
                            for day in range(diff_int):
                                date = s_row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0) + datetime.timedelta(days=day+1)
                                returnData.append({'user': row['username'], 'app': code, 'date': date.strftime('%Y-%m-%d'), 'time': 1440, 'func': row['exec_type']})
                            #終了日作業時間の取得     
                            diff_last = row['cdate'] - row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0)
                            diff_last = int(diff_last.total_seconds() / 60)
                            print(diff_last)
                            returnData.append({'user': row['username'], 'app': code, 'date': row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0).strftime('%Y-%m-%d'),'time': diff_last, 'func': row['exec_type']})
                        del start_list[j]
                        break
    if (start_list != []):
        now = dt.now()
        for i in range(len(start_list)):
            row = start_list[i]
            if (now.date() == row['cdate'].date()):
                print('onazi')
                diff_time = now - row['cdate']
                print(now)
                print(row['cdate'])
                diff_time = int(diff_time.total_seconds() / 60)
                print(diff_time)
                returnData.append({'user': row['username'], 'app': row['code'], 'date': row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0).strftime('%Y-%m-%d'),'time': diff_time, 'func': row['func']})
            else:
                print('chigau')
                #開始日作業時間の取得
                diff_time = row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0) + datetime.timedelta(days=1) - row['cdate']
                diff_time = int(diff_time.total_seconds() / 60)
                print(diff_time)
                returnData.append({'user': row['username'], 'app': row['code'], 'date': row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0).strftime('%Y-%m-%d'),'time': diff_time, 'func': row['func']})
                #開始日終了日の差を取得
                one_day = datetime.timedelta(days=1)
                diff_day = now.replace(hour=0, minute=0, second=0, microsecond=0) - row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0)
                diff_int = int(diff_day / one_day) - 1
                #1日以上空いている場合、1440分の活動とする
                for day in range(diff_int):
                    date = row['cdate'].replace(hour=0, minute=0, second=0, microsecond=0) + datetime.timedelta(days=day+1)
                    returnData.append({'user': row['username'], 'app': row['code'], 'date': date.strftime('%Y-%m-%d'),'time': 1440, 'func': row['func']})
                #終了日作業時間の取得     
                diff_time = now - now.replace(hour=0, minute=0, second=0, microsecond=0)
                diff_time = int(diff_time.total_seconds() / 60)
                print(diff_time)
                returnData.append({'user': row['username'], 'app': row['code'], 'date': now.replace(hour=0, minute=0, second=0, microsecond=0).strftime('%Y-%m-%d'),'time': diff_time, 'func': row['func']})
    return returnData


def get_amount_data(company_code, start_day, end_day):
    returnData = []
    pjcode_sql = '''
        SELECT 
            distinct substring(directory_username from 1 for position('.' in directory_username)-1) AS project_id
        From 
            mscone_lic.m_directory_user 
        Where 
            company_code = %(company_code)s 
    '''
    output_pjcode = pdbc.select_param(db_hosts.simsp(), pjcode_sql, {'company_code': company_code})
    params = {
        'project_id': output_pjcode[0]['project_id'],
        'start_day': start_day,
        'end_day': end_day
        }
    
    exec_sql = '''
        SELECT DISTINCT
            ui.contract_id,
            rp.product_name,
            rp.billing_code,
            CASE 
                WHEN rp.instance_type->>'exec_type' IS NOT NULL THEN rp.instance_type->>'exec_type'
                ELSE (SELECT DISTINCT instance_type->>'exec_type' FROM billing_infrastructure.m_regular_products WHERE billing_code = rp.billing_code AND instance_type->>'exec_type' IS NOT NULL)
            END AS exec_type,
            bi.usage,
            bi.amount,
            bi.dateandtimeofoccurrence,
            uc.company_code,uc.company_name 
        FROM 
            user_infrastructure.m_contract ui
        INNER JOIN 
            billing_infrastructure.t_qs_billing_information bi 
        ON 
            ui.contract_id = bi.contract_id
        INNER JOIN 
            user_infrastructure.m_company uc 
        ON 
            ui.company_code = uc.company_code
        INNER JOIN 
            user_infrastructure.m_contract_product cp 
        ON 
            cp.contract_product_id = bi.contract_product_id
        INNER JOIN 
            billing_infrastructure.m_regular_products rp 
        ON 
            rp.product_id = cp.product_id
		Where  
            ui.company_code = %(project_id)s 
            AND bi.dateandtimeofoccurrence >= %(start_day)s 
            AND bi.dateandtimeofoccurrence <= %(end_day)s   
        ORDER BY bi.dateandtimeofoccurrence
        '''
    exec_data = pdbc.select_param(db_hosts.simsp(), exec_sql, params)
    print('exec_data-*-*-*-*-*-*-*',type(exec_data),exec_data)
    if exec_data != []:
        for i in range(len(exec_data)):
                row = exec_data[i]
                #アプリの種類確認
                if row['exec_type'] == 'app':
                    code = row['billing_code'].split('-')[-1]
                else:
                    code = row['billing_code'].split('_')[0] + '_solver'

                returnData.append({
                                    'app': code,
                                    'date': row['dateandtimeofoccurrence'].strftime('%Y-%m-%d'),
                                    'time': row['amount'],
                                    'func': row['exec_type']})

    return returnData