from flask import Blueprint, render_template, make_response
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.model.tables import *
from flask_cors import cross_origin
from src.component.model.user_infrastructure import *
from src.component.function.billing import billing_logic
from src.component.function.user import user_logic
import datetime
import requests
import string
import secrets

billing_bp = Blueprint('billing', __name__, url_prefix='/billing')

@billing_bp.route('/list', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@AdminUser
@RequiredAuth
def list():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    #取得リスト作成
    date_list = []
    dt = datetime.datetime.now()
    now_year = str(dt.year)
    now_month = str(dt.month).zfill(2)
    #date_list.append(str(now_year)+str(now_month)) 当月は除外
    for i in range(12):
        if str(int(now_month) -1).zfill(2) == '00':
            now_year = int(now_year) - 1
            now_month = 12
        else:
            now_month = str(int(now_month) -1).zfill(2)
        date_list.append(str(now_year)+'年'+str(now_month)+'月')
    rows = []
    for date in date_list:
        rows.append({'output_date': date})
    return json.dumps(rows)

@billing_bp.route('/download', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@AdminUser
@RequiredAuth
def download():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('クエリパラメータから企業コード取得：' + company_code)
    request_params = request.get_json()
    # API呼び出し
    #params = {'aggregate_date': request_params['date'].replace('年','').replace('月',''), 'company_id': company_code}
    params = {'aggregate_date': '202208', 'company_id': '22000004'}#, 'stage':'eval'}
    headers = {'Accept': 'application/pdf'}
    res = requests.get(current_app.config["API_GATEWAY_BILLING_REPORT"], params=params, headers=headers)

    output = make_response()
    output.data = res.content
    output.headers["Content-Disposition"] = "attachment"
    output.headers["Content-type"] = "application/pdf"
    return output

@billing_bp.route('/data', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@AdminGeneralWorkshopTrialUser
@RequiredAuth
def data():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    start_day = request.headers.get("sday")
    end_day = request.headers.get("eday")
    print('クエリパラメータから企業コード取得：' + company_code)
    #取得リスト作成
    dbdata = billing_logic.get_data(company_code, start_day, end_day)
    print(dbdata)
    return {'data': dbdata}

@billing_bp.route('/amount_data', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@AdminGeneralWorkshopTrialUser
@RequiredAuth
def amount_data():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    start_day = request.headers.get("sday")
    end_day = request.headers.get("eday")
    print('クエリパラメータから企業コード取得：' + company_code)
    #取得リスト作成
    dbdata = billing_logic.get_amount_data(company_code, start_day, end_day)
    print(dbdata)
    return {'data': dbdata}

def create_filename():
    chars = string.ascii_uppercase + string.ascii_lowercase + string.digits
    return ''.join(secrets.choice(chars) for x in range(30))