from flask import Flask, Blueprint, render_template, current_app
from src.component.model.simsp import mscone_lic as sml
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.common.pdbc import pdbc, db_hosts
from src.component.common.storage import ssm
import time

def get_applist(company_code, service_id):
    print('引数企業コード[get_systemusableflag]: ' + company_code)
    print('current_app_config ; ' + current_app.config['SYSTEM_ID'])
    contract_id = get_contract_id(company_code, current_app.config['SYSTEM_ID'], service_id)
    sql = '''
        -- 現在の起動数を取得(対象商品が所属する商品グループの起動数の合計を計算。課金コードが同じものは同一とする。)
        WITH prod_cur_num AS (
            WITH cur_num as (
                SELECT DISTINCT
                    mcp.contract_id,
                    mrp.product_group_id,
                    mcp.quantity,
                    COALESCE(mcc.current_launches,0) AS current_launches,
                    mrp.billing_code
                FROM user_infrastructure.m_contract_product mcp 
                    JOIN billing_infrastructure.m_regular_products mrp ON mcp.product_id = mrp.product_id
                    LEFT JOIN user_infrastructure.m_app_concurrent_count mcc ON mcp.contract_product_id = mcc.contract_product_id
                WHERE mcp.contract_id = %(contract_id)s AND mcp.quantity IS NOT NULL
                    AND ((mrp.applicable_start_date < now() AND mrp.applicable_end_date IS NULL)
                    OR (mrp.applicable_start_date < now() AND mrp.applicable_end_date > now()))
                    AND ((mcp.use_start_date < now() AND mcp.use_end_date IS NULL)
                    OR (mcp.use_start_date < now() AND mcp.use_end_date > now()))
            )
            SELECT 
                cur_num.contract_id, 
                cur_num.product_group_id, 
                cur_num.quantity,
                SUM(cur_num.current_launches) AS current_launches
            FROM cur_num
            GROUP BY cur_num.contract_id, cur_num.product_group_id, cur_num.quantity
        )
        -- 契約している商品グループのメイン商品の商品情報を取得
        SELECT
            mcp.contract_id,
            mcp.contract_product_id,
            mcp.product_id,
            mrp.product_code,
			mer.software,
			mer.version,
            mer.stack_name,
            mer.app_name,
            concat(mrp.billing_identifier,' Ver.',mer.version) AS display_name,
            mrp.instance_type->'exec_type' AS exec_type,
            mcp.quantity AS contract_launches,
            prod_cur_num.current_launches,
            macc.users,
            mpg.image_url
        FROM user_infrastructure.m_contract_product mcp
            JOIN billing_infrastructure.m_regular_products mrp ON mrp.product_id = mcp.product_id
            JOIN billing_infrastructure.m_product_groups mpg ON mpg.main_product_id = mrp.product_id
            LEFT JOIN user_infrastructure.m_app_concurrent_count macc ON macc.contract_product_id = mcp.contract_product_id
            LEFT JOIN prod_cur_num ON prod_cur_num.product_group_id = mpg.product_group_id
			INNER JOIN mscone_lic.m_env_resource mer ON mer.software = mrp.instance_type->>'product'
        WHERE mcp.contract_id = %(contract_id)s
            AND mpg.display_flag = TRUE
            AND ((mrp.applicable_start_date < now() AND mrp.applicable_end_date IS NULL)
            OR (mrp.applicable_start_date < now() AND mrp.applicable_end_date > now()))
            AND ((mcp.use_start_date < now() AND mcp.use_end_date IS NULL)
            OR (mcp.use_start_date < now() AND mcp.use_end_date > now()))
        ORDER BY mcp.product_id
    '''
    rows = pdbc.select_param(db_hosts.platform(), sql, {'contract_id' : contract_id})
    print(rows)
    return rows

def get_contract_id(company_code, system_id, service_id):
    sql = '''
        SELECT DISTINCT
            mc.contract_id
        FROM
            user_infrastructure.m_contract_product mcp
        JOIN user_infrastructure.m_contract mc ON mc.contract_id = mcp.contract_id
        JOIN billing_infrastructure.m_regular_products mrp ON mrp.product_id = mcp.product_id
        WHERE
            mc.company_code = %(company_code)s
        AND
            mrp.system_id = %(system_id)s
        AND
            mrp.service_id = %(service_id)s
        AND
            ((mc.subscription_start_date < now() AND mc.subscription_end_date IS NULL)
            OR (mc.subscription_start_date < now() AND mc.subscription_end_date > now()))
    '''
    
    rows = pdbc.select_param(db_hosts.platform(), sql, {
        'company_code' : company_code, 
        'system_id' : system_id, 
        'service_id' : service_id})

    if len(rows) == 1 and 'contract_id' in rows[0]:
        return rows[0]['contract_id']
    
    return None
