from flask import Flask, Blueprint, render_template, current_app
from flask import Blueprint, render_template
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.common.aws import aws
from src.component.model.tables import *
from src.component.function.app import app_logic
from src.component.function.user import user_logic
from flask_cors import cross_origin
from src.component.common.storage import ssm # env_id取得のため

app_bp = Blueprint('app', __name__, url_prefix='/app')

@app_bp.route('/list', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def list():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('user.info(): クエリパラメータから企業コード取得：' + company_code)
    user_metadata = user['user_metadata']
    service_id = user_logic.get_user_service_id(user_metadata, company_code)
    rows = app_logic.get_applist(company_code, service_id)
    for row in rows:
        print(row)

    # AppStream2.0の起動状況更新
    env_id = ssm.get_env_id(company_code)
    print('env_id取得：' + env_id)
    response = aws.invoke_lambda(
        'RequestResponse',
        current_app.config['LAMBDA_APPSTREAM_CHECK'],
        json.dumps({'project_id': env_id})
    )

    return json.dumps(rows)

@app_bp.route('/check', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@RequiredAuth
@AdminGeneralWorkshopTrialUser
def check():
    user = user_logic.get_user_info(request.headers.get("Authorization", None))
    company_code = request.headers.get("ccode")
    print('user.info(): クエリパラメータから企業コード取得：' + company_code)
    user_metadata = user['user_metadata']
    print(user_metadata)
    service_id = user_logic.get_user_service_id(user_metadata, company_code)
    product_code = request.headers.get("product_code")
    print('user.info(): クエリパラメータから商品コード取得：' + product_code)
    contract_id = app_logic.get_contract_id(company_code, current_app.config['SYSTEM_ID'], service_id)
    
    response = aws.invoke_lambda(
        'RequestResponse',
        current_app.config['LAMBDA_CHECK_EXECUTION'],
        json.dumps({
                    'contract_id': contract_id,
                    'product_code': product_code
                    })
    )
    print("---02: response:")
    print(response)

    if 'StatusCode' in response and response['StatusCode'] == 200:
        # レスポンス読出し
        Payload = json.loads(response['Payload'].read())
        print("---03: body:")
        print(Payload)
        if 'statusCode' in json.loads(Payload['body']) and json.loads(Payload['body'])['statusCode'] != 200:
            raise Exception(json.loads(Payload['body'])['body'])
        res = Payload
    else:
        raise Exception('StatusCode is not 200')
    
    return res
