from flask import Flask, Blueprint, render_template, current_app, jsonify, abort, abort
from werkzeug.exceptions import HTTPException
import werkzeug

exception_bp = Blueprint('exception_bp', __name__)

class SystemErrorException(Exception):
    code = 400
    description = "Bad Request!"
@exception_bp.errorhandler(SystemErrorException)
def system_err_handle_exception(err):
    response = {'error': err.description, 'message': ''}
    if len(err.args) > 0:
        response["message"] = err.args[0]
    exception_bp.logger.error(err)
    return jsonify(response), err.code

class AuthErrorException(werkzeug.exceptions.HTTPException):
    code = 507
    description = "Bad Auth Request!"
def handle_507(e):
    return 'Not enough storage space.', 507
exception_bp.register_error_handler(AuthErrorException, handle_507)
"""
@exception_bp.errorhandler(AuthErrorException)
def auth_err_handle_exception(err):
    response = {'error': err.description, 'message': ''}
    if len(err.args) > 0:
        response["message"] = err.args[0]
    exception_bp.logger.error(err)
    return jsonify(response), err.code
"""