import json
from urllib.request import urlopen
from jose import jwt
from functools import wraps
from flask import Flask, Blueprint, render_template, current_app, _request_ctx_stack, request, abort
from src.component.exception.authenticate import *
from src.component.common.entraid.component import Auth0Component
from src.component.common.entraid.parameters import *
from src.component.function.user import user_logic
import http
import base64

def get_user_metadata_roles(auth0_usesr_id, company_code):
    #ユーザーIDからMetadataの中のRole情報を取得
    auth0_component = Auth0Component()
    user_param = GetUserParam()
    #auth0|が入らないためreplaceを削除
    #user_param.id = auth0_usesr_id.replace('auth0|', '')
    user_param.id = auth0_usesr_id
    user_info = auth0_component.get_user(user_param)
    print('userinfo')
    print(user_info)
    user_roles = user_logic.get_user_roles(user_info.get('user_metadata'), company_code)
    return user_roles

def get_user_metadata_status(auth0_usesr_id, company_code):
    #ユーザーIDからMetadataの中のステータス(blocked)を取得
    auth0_component = Auth0Component()
    user_param = GetUserParam()
    #auth0|が入らないためreplaceを削除
    #user_param.id = auth0_usesr_id.replace('auth0|', '')
    user_param.id = auth0_usesr_id
    user_info = auth0_component.get_user(user_param)
    print(user_info)
    status_blocked = user_logic.get_user_status(user_info.get('user_metadata'), company_code)
    return status_blocked

def get_token_auth_header():
    """Obtains the access token from the Authorization Header
    """
    auth = request.headers.get("Authorization", None)
    if not auth:
        raise AuthError({"code": "authorization_header_missing",
                        "description":
                            "Authorization header is expected"}, 401)

    parts = auth.split()

    if parts[0].lower() != "bearer":
        raise AuthError({"code": "invalid_header",
                        "description":
                            "Authorization header must start with"
                            " Bearer"}, 401)
    elif len(parts) == 1:
        raise AuthError({"code": "invalid_header",
                        "description": "Token not found"}, 401)
    elif len(parts) > 2:
        raise AuthError({"code": "invalid_header",
                        "description":
                            "Authorization header must be"
                            " Bearer token"}, 401)

    token = parts[1]
    return token

def RequiredAuth(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']={'data': []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
 
            conn.close()
 
            #ユーザーIDからMetadata中のステータス(blocked)を取得します
            status_blocked = auth_dic['blocked']
 
            # 無効ユーザー
            if status_blocked:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception:
            raise AuthError({"code": "invalid_header",
                            "description":
                                "Unable to get authentication"
                                " token."}, 400)
 
        _request_ctx_stack.top.current_user = auth_dic
 
        return f(*args, **kwargs)
 
    return decorated

def newRequiredAuth(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']={'data': []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
 
            conn.close()
        except:
            print("metadata error")
        
        payload = auth_dic
        print('payload', payload)

        try:
            #ユーザーIDからMetadata中のステータス(blocked)を取得します
            company_code = list(set([com['company_code'] for com in payload['user_metadata']['data']]))
            if current_app.config["STAFF_COMPANY_CODE"] in company_code:
                company_code.remove(current_app.config["STAFF_COMPANY_CODE"])
            print(company_code)
            print(payload)
            status_blocked = get_user_metadata_status(payload['user_id'], company_code[0])
            # 無効ユーザー
            if status_blocked:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except jwt.ExpiredSignatureError:
            raise AuthError({"code": "token_expired",
                            "description": "token is expired"}, 401)
        except jwt.JWTClaimsError:
            raise AuthError({"code": "invalid_claims",
                            "description":
                                "incorrect claims,"
                                "please check the audience and issuer"}, 401)
        except Exception:
            raise AuthError({"code": "invalid_header",
                            "description":
                                "Unable to parse authentication"
                                " token."}, 400)

        _request_ctx_stack.top.current_user = payload
        return f(*args, **kwargs)

    return decorated

def RequiredAuthPortal(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']={'data': []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
 
            conn.close()
 
            #ユーザーIDからMetadata中のステータス(blocked)を取得します
            status_blocked = auth_dic['blocked']
 
            # 無効ユーザー
            if status_blocked:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception:
            raise AuthError({"code": "invalid_header",
                            "description":
                                "Unable to get authentication"
                                " token."}, 400)
 
        _request_ctx_stack.top.current_user = auth_dic
 
        return f(*args, **kwargs)
 
    return decorated

def AdminGeneralWorkshopTrialUser(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']= {"data": []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
            
            conn.close()

            has_role = False
            for role in user_logic.get_user_roles(auth_dic['user_metadata'], company_code):
                if role in [
                    current_app.config['METADATA_ROLES_ADMIN_USER']
                    ,current_app.config['METADATA_ROLES_GENERAL_USER']
                    ,current_app.config['METADATA_ROLES_WORKSHOP_USER']
                    ,current_app.config['METADATA_ROLES_TRIAL_USER']
                    ,current_app.config['METADATA_ROLES_MCONTRACT_USER']
                ]:
                    has_role = True
            if not has_role:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception as e:
            print(e)

        _request_ctx_stack.top.current_user = auth_dic
        return f(*args, **kwargs)

    return decorated

def AdminGeneralWorkshopUser(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']= {"data": []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
            
            conn.close()

            has_role = False
            for role in user_logic.get_user_roles(auth_dic['user_metadata'], company_code):
                if role in [
                    current_app.config['METADATA_ROLES_ADMIN_USER']
                    ,current_app.config['METADATA_ROLES_GENERAL_USER']
                    ,current_app.config['METADATA_ROLES_WORKSHOP_USER']
                    ,current_app.config['METADATA_ROLES_MCONTRACT_USER']
                ]:
                    has_role = True
            if not has_role:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception as e:
            print(e)

        _request_ctx_stack.top.current_user = auth_dic
        return f(*args, **kwargs)

    return decorated

def SupportStaffWorkshopUser(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']= {"data": []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
            
            conn.close()

            has_role = False
            for role in user_logic.get_user_roles(auth_dic['user_metadata'], company_code):
                if role in [
                    current_app.config['METADATA_ROLES_SUPPORT_STAFF']
                ]:
                    has_role = True
            if not has_role:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception as e:
            print(e)

        _request_ctx_stack.top.current_user = auth_dic
        return f(*args, **kwargs)

    return decorated

def AdminWorkshopUser(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']= {"data": []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
            
            conn.close()

            has_role = False
            for role in user_logic.get_user_roles(auth_dic['user_metadata'], company_code):
                if role in [
                    current_app.config['METADATA_ROLES_ADMIN_USER']
                    ,current_app.config['METADATA_ROLES_WORKSHOP_USER']
                ]:
                    has_role = True
            if not has_role:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception as e:
            print(e)

        _request_ctx_stack.top.current_user = auth_dic
        return f(*args, **kwargs)

    return decorated

def AdminGeneralUser(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']= {"data": []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
            
            conn.close()

            has_role = False
            for role in user_logic.get_user_roles(auth_dic['user_metadata'], company_code):
                if role in [
                    current_app.config['METADATA_ROLES_ADMIN_USER']
                    ,current_app.config['METADATA_ROLES_GENERAL_USER']
                ]:
                    has_role = True
            if not has_role:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception as e:
            print(e)

        _request_ctx_stack.top.current_user = auth_dic
        return f(*args, **kwargs)

    return decorated

def AdminUser(f):
    """Determines if the access token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
 
        ENTRA_ISSUER = 'https://sts.windows.net/1e054624-48c8-4633-823e-57f6c918bcbd/' #テナントID
        ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        ENTRA_AUTHORITY="https://login.microsoftonline.com/1e054624-48c8-4633-823e-57f6c918bcbd/oauth2/v2.0/token" #修正
        ENTRA_OIDC_AUTORITY="https://login.contoso.com/1e054624-48c8-4633-823e-57f6c918bcbd/v2.0" #使用しない（マルチテナント時に利用）
        ENTRA_CLIENT_ID="742274e4-c498-4825-83e3-2fbb737e9347"
        ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        ENTRA_CLIENT_SECRET="UUj8Q~oHHn~7PH3LpZGcBLPJmeY4o.eRZ1aIzaaO"
        ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        ENTRA_DOMAIN = 'login.microsoftonline.com'
        ENTRA_TENANT_ID = '1e054624-48c8-4633-823e-57f6c918bcbd'
        ENTRA_ENDPOINT="graph.microsoft.com"
 
 
        email = request.headers.get("email", None)
        company_code = request.headers.get("company_code")
       
        #print('クエリパラメータから企業コード取得：' + company_code)
       
        #with current_app.app_context():
        #    client_id = current_app.config['AUTH0_CLIENT_ID']
       
        client_id = ENTRA_CLIENT_ID
        token = get_token_auth_header()
        try:
            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {token}'  
            }
 
            #logging.info(headers)
 
            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            data = res.read().decode("utf-8")
 
            conv_dic = json.loads(data)
            print(conv_dic)
            auth_dic={}
 
            auth_dic['user_id']=conv_dic['mail']
            auth_dic['username']=conv_dic['userPrincipalName']
            auth_dic['family_name']=conv_dic['surname']
            auth_dic['email']=conv_dic['mail']
            auth_dic['given_name']=conv_dic['givenName']
            auth_dic['blocked']=not conv_dic['accountEnabled']
            auth_dic['name']=conv_dic['displayName']
 
            #Attribute1はJSONのためでbase64でencodeされている        
            if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']= {"data": []}
            else :
                base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
 
            #Attribute2はJSONではないと仮定
            auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']
            
            conn.close()

            has_role = False
            for role in user_logic.get_user_roles(auth_dic['user_metadata'], company_code):
                if role in [
                    current_app.config['METADATA_ROLES_ADMIN_USER']
                ]:
                    has_role = True
            if not has_role:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
        except Exception as e:
            print(e)

        _request_ctx_stack.top.current_user = auth_dic
        return f(*args, **kwargs)

    return decorated