from flask import Flask, Blueprint, render_template, send_file, current_app
from flask import Flask, Blueprint, render_template, send_file, current_app, make_response, Response, request
from src.component.common.entraid.parameters import *
from src.component.decorator.authenticate import *
from src.component.model.platform import user_infrastructure as pui
from src.component.model.simsp import mscone_lic as sml
from src.component.model.tables import *
from src.component.common.mail import mail
from src.component.common.pdbc import pdbc
from src.component.common.pdbc import db_hosts
from src.component.common.aws import aws
import boto3
import uuid
import os
import time
import csv
import shutil

def get_loglist(company_code, names):
    loglist = []
    env_id = get_env_id(company_code)
    prefixs = ''
    for name in names:
        prefixs += "'/home/admin@" + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + name + "' "

    ls_command = "ls -lFkn --full-time "+ prefixs + " | awk -v 'OFS=,' 'BEGIN{print \"filename\",\"size\",\"date\",\"time\"} {print $9,$5,$6,$7}'"
    instance_id = get_bridge_instance_id(company_code)
    command_id = aws.run_command(instance_id, "AWS-RunShellScript", ls_command)
    ls_output_key = 'ls/' + command_id + '/' + instance_id + '/awsrunShellScript/0.awsrunShellScript/stdout'
    try:
        print('リソース作成')
        s3 = boto3.resource('s3')
        print('バケット作成')
        test = s3.Bucket(current_app.config["STORAGE_SUPPORT_BUCKET_NAME"])
        print(test)
        test.download_file(Filename=current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, Key=ls_output_key)
        with open(current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, encoding='utf-8') as f:
            csvreader = csv.DictReader(f)
            for row in csvreader:
                loglist.append(row)
        return loglist
        
    except Exception as e:
        raise Exception("")

def get_env_id(company_code):
    company_condition = sml.MCompany()
    company_condition.company_code = company_code
    return pdbc.select(db_hosts.simsp(), company_condition)[0]['env_id']

def get_bridge_instance_id(company_code):
    company_condition = sml.MCompany()
    company_condition.company_code = company_code
    return pdbc.select(db_hosts.simsp(), company_condition)[0]['bridge_instance_id']

def get_text(company_code, filepath):
    env_id = get_env_id(company_code)
    bridge_filepath = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + filepath
    print(bridge_filepath)
    cat_command = 'cat "' + bridge_filepath + '"'
    instance_id = get_bridge_instance_id(company_code)
    command_id = aws.run_command(instance_id, "AWS-RunShellScript", cat_command)
    cat_output_key = 'ls/' + command_id + '/' + instance_id + '/awsrunShellScript/0.awsrunShellScript/stdout'
    try:
        s3 = boto3.resource('s3')
        print(current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id)
        print(cat_output_key)
        s3.Bucket(current_app.config["STORAGE_SUPPORT_BUCKET_NAME"]).download_file(Filename=current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, Key=cat_output_key)
        with open(current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, encoding='utf-8') as f:
            return f.read()
    except Exception as e:
        return ''

def get_text_limit(company_code, filepath):
    env_id = get_env_id(company_code)
    bridge_filepath = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + filepath

    cat_command = 'tail -n 100 "' + bridge_filepath + '"' 
    instance_id = get_bridge_instance_id(company_code)
    command_id = aws.run_command(instance_id, "AWS-RunShellScript", cat_command)
    cat_output_key = 'ls/' + command_id + '/' + instance_id + '/awsrunShellScript/0.awsrunShellScript/stdout'
    try:
        s3 = boto3.resource('s3')
        s3.Bucket(current_app.config["STORAGE_SUPPORT_BUCKET_NAME"]).download_file(Filename=current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, Key=cat_output_key)
        with open(current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, encoding='utf-8') as f:
            return f.read()
    except Exception as e:
        return ''

def get_list(company_code, prefix):
    env_id = get_env_id(company_code)
    print('env_id = ' + env_id)
    prefix = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + prefix

    file_list = []
    folder_list = []
    
    instance_id = get_bridge_instance_id(company_code)
    #ls_command = "ls -lFkn --full-time '"+ prefix + "' | jc --ls -p"
    ###
    # 新規作成のファイルサーバ―でjcコマンドがls標準出力結果をうまく取得できないことから
    # 以下のコマンドに変更し、json形式からCSV形式に変更した
    # フォーマット：カンマ区切り
    # ヘッダー：filename,size,date,time
    ###
    ls_command = "ls -lFkn --full-time '"+ prefix + "' | awk -v 'OFS=,' 'BEGIN{print \"filename\",\"size\",\"date\",\"time\"} {print $9,$5,$6,$7}'"
    print(instance_id)
    command_id = aws.run_command(instance_id, "AWS-RunShellScript", ls_command)
    ls_output_key = 'ls/' + command_id + '/' + instance_id + '/awsrunShellScript/0.awsrunShellScript/stdout'
    try:
        print('リソース作成')
        s3 = boto3.resource('s3')
        print('バケット作成')
        test = s3.Bucket(current_app.config["STORAGE_SUPPORT_BUCKET_NAME"])
        print(test)
        test.download_file(Filename=current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, Key=ls_output_key)
        with open(current_app.config["STORAGE_SUPPORT_RUN_COMMAND_LOG_DIR"] + command_id, encoding='utf-8') as f:
            ## CSV形式への変更
            print('コマンド結果読取り')
            csvreader = csv.DictReader(f)
            for row in csvreader:
                print(row)
                # lsコマンドの[合計xxxx]が出力されないため、1行目が空となる
                if len(row['filename']) == 0:
                    print('空----------------------------------------NEXT')
                    continue
                
                if row['filename'][len(row['filename'])-1] == '/':
                    folder_obj = {}
                    print('フォルダー ----------------------------')
                    folder_obj['name'] = row['filename'].replace('/','')
                    folder_obj['size'] = row['size']
                    folder_obj['date'] = row['date'] + ' ' + row['time'].split('.')[0]
                    folder_list.append(folder_obj)
                else:
                    file_obj = {}
                    print('ファイル ----------------------------')
                    file_obj['name'] = row['filename'].replace('*','')
                    file_obj['size'] = row['size']
                    file_obj['date'] = row['date'] + ' ' + row['time'].split('.')[0]
                    file_list.append(file_obj)
            ## 上記の変更により以下をコメントアウト
            """
            for file in json.loads(f.read()):
                if file['filename'][len(file['filename'])-1] == '*':
                    file_obj = {}
                    file_obj['name'] = file['filename'].replace('*','')
                    file_obj['size'] = file['size']
                    file_obj['date'] = file['date'].split('.')[0]
                    file_list.append(file_obj)
                if file['filename'][len(file['filename'])-1] != '*':
                    folder_obj = {}
                    folder_obj['name'] = file['filename'].replace('/','')
                    folder_obj['size'] = file['size']
                    folder_obj['date'] = file['date'].split('.')[0]
                    folder_list.append(folder_obj)
            """
    except Exception as e:
        print(type(e))
        print(e.args)
        print(e)
        pass

    list = {}
    list['folders'] = folder_list
    list['files'] = file_list
    data = []
    for folder in list['folders']:
        item = {}
        item['name'] = folder['name']
        item['cal_start'] = ''
        item['cal_end'] = ''
        item['status'] = 0
        item['last_modified'] = ''
        item['size'] = ''
        item['is_folder'] = True
        data.append(item)

    for file in list['files']:
        item = {}
        item['name'] = file['name']
        item['cal_start'] = ''
        item['cal_end'] = ''
        item['status'] = 0
        item['last_modified'] = file['date']
        item['size'] = file['size']
        item['is_folder'] = False
        data.append(item)
        # フェーズ4　確認用
        print(data)
    return json.dumps(data)

def make_dir(company_code, prefix):
    instance_id = get_bridge_instance_id(company_code)
    env_id = get_env_id(company_code)
    copy_command = 'mkdir ' + '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + prefix
    return aws.run_command(instance_id, "AWS-RunShellScript", copy_command)

# 20250910 
# murakami.ak.pm
# Upload path to EFS
# /root/efs-mount-point/storage-support/{SYSTEM_ID}/upload/
def upload(company_code, folder_name, request):
    try:
        instance_id = get_bridge_instance_id(company_code)
        file_cnt = 0
        if request.form.get('path'):
            path_list = request.form.get('path').split('|')
        #ファイルサイズチェック
        size = 0
        for key in request.files:
            file = request.files.get(key)
            pos = file.tell()
            file.seek(0, os.SEEK_END)
            size = (size + file.tell())
            file.seek(pos)
        if 10737418240 < size:
            return Response(status=500, mimetype='application/json')
        upload_key = str(uuid.uuid4())
        # 20250715 EFSに変更
        # ローカルのマウントパス
        upload_target_path = current_app.config['EFS_MOUNT_PATH'] + current_app.config['SYSTEM_ID'] + '/upload/' + upload_key + '/'
        mkdir_command = 'mkdir -p ' + upload_target_path
        print(mkdir_command)
        command_id = aws.run_command(instance_id, "AWS-RunShellScript", mkdir_command)
        print(command_id)

        #アップロード処理
        for key in dict(request.files.lists()):
            try:
                for f in dict(request.files.lists())[key]:
                    if request.form.get('path'):
                        file_name = path_list[file_cnt]
                    else:
                        file_name = os.path.basename(f.name)
                    if file_name.startswith("/"):
                        file_name = file_name[1:]
                    if folder_name != '':
                        file_name = folder_name + '/' + file_name
                    # 20250715 コメントアウト
                    #aws.s3_upload(f, current_app.config["STORAGE_SUPPORT_BUCKET_NAME"], 'upload/' + upload_key + '/' + file_name)
                    ##### 20250715 追加
                    if not os.path.isdir(os.path.dirname(upload_target_path + file_name)):
                        os.makedirs(os.path.dirname(upload_target_path + file_name))
                    f.save(upload_target_path + file_name)
                    file_cnt += 1
            except Exception as e:
                return Response(status=500, mimetype='application/json')
        #original_upload_path = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/s3-mscone-upload/upload/' + upload_key + '/*'
        original_upload_path = current_app.config['BRIGH_EFS_MOUNT_PATH'] + current_app.config['SYSTEM_ID'] + '/upload/' + upload_key + '/*'
        env_id = get_env_id(company_code)
        #dist_upload_path = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id
        # ファイルサーバ―のFSxのマウントパス
        dist_upload_path = current_app.config['BRIGH_ONTAP_MOUNT_PATH'] + env_id
        
        copy_command = 'cp -r ' + original_upload_path + ' ' + dist_upload_path
        aws.run_command(instance_id, "AWS-RunShellScript", copy_command)
        return Response(status=200, mimetype='application/json')
    except Exception as e:
        print(e)
        return Response(status=500, mimetype='application/json')

def rename(company_code, old_name, new_name):

    instance_id = get_bridge_instance_id(company_code)
    if old_name.startswith("/"):
        old_name = old_name[1:]

    if new_name.startswith("/"):
        new_name = new_name[1:]

    if old_name.endswith("/"):
        old_name = old_name[:-1]

    if new_name.endswith("/"):
        new_name = new_name[:-1]

    env_id = get_env_id(company_code)
    old_name = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + old_name
    new_name = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + new_name


    check_command = 'find "' + new_name + '" | wc -l'
    command_id = aws.run_command(instance_id, "AWS-RunShellScript", check_command)

    ##チェック結果参照
    invocations = aws.list_command_invocations(command_id)
    filecount = invocations[0]['CommandPlugins'][0]['Output'][0]
    messages = {}
    print(check_command)
    print(filecount)
    if filecount == '0':
        rename_command = 'mv "' + old_name + '" "' + new_name + '"'
        aws.run_command(instance_id, "AWS-RunShellScript", rename_command)
        messages = {'status': 'ok','msg': 'ファイル名の更新が完了しました。'}
    else:
        messages = {'status': 'ng','msg': 'この名前はすでに使われています。'}

    return json.dumps(messages)

def delete(company_code, folder_name, prefixes):
    instance_id = get_bridge_instance_id(company_code)
    env_id = get_env_id(company_code)
    for del_prefix in prefixes:
        del_prefix = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + folder_name + '/' + del_prefix

        delete_command = 'rm -rf "' + del_prefix + '"'
        aws.run_command(instance_id, "AWS-RunShellScript", delete_command)

    return 'Okey!'

###
# 2024/03/08 Update Fase4
# author: murakami.ak.pm
# comment: Change S3 to EFS
#          Add compress zip
# UPDATE 2025/0718 Fhase8
# author: murakami.ak.pm
# comment: Tempディレクトリの容量逼迫のためEFSをマウント
#          ブリッジサーバ―上で処理を簡潔するように変更
###
def download(company_code, prefix, items):
    print('ssm.py download() ------------------------')
    print(prefix)
    print(items)
    print('Create Directory -------------')
    try:
        #ダウンロードID取得
        download_key = str(uuid.uuid4())
        # env_idの取得
        env_id = get_env_id(company_code)
        #コピー先ディレクトリ作成
        instance_id = get_bridge_instance_id(company_code)
        efs_archive_path = f"{current_app.config['BRIGH_EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/download/"
        mkdir_command = 'mkdir -p ' + efs_archive_path
        print('aws.run_command: ' + mkdir_command)
        aws.run_command(instance_id, "AWS-RunShellScript", mkdir_command)
        print(f'First directory created: {efs_archive_path}')
        current_download_path = f"{current_app.config['EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/download/"
        print(f'Directory exists: {os.path.exists(current_download_path)}')
        print(f'Directory permissions: {oct(os.stat(current_download_path).st_mode)[-3:]}')
        # 少し待機
        time.sleep(0.5)

        touch_command = 'touch ' + efs_archive_path
        print('aws.run_command: ' + touch_command)
        aws.run_command(instance_id, "AWS-RunShellScript", touch_command)
    except Exception as e:
        print(e)
        print('[Error] Faild Create download directory ---------------')
        raise Exception("run_command failed")
    try:
        print('file copy -----------')
        for item in items:
            start_time = time.time()
            donwload_target_path = f"{current_app.config['BRIGH_ONTAP_MOUNT_PATH']}{env_id}/{prefix}/{item['name']}"
            # done.flagファイルのパス
            done_flag_path = f"{current_app.config['BRIGH_EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/"
            #copy_command = 'cp -arf "' + donwload_target_path + '" "' + efs_archive_path + '"'
            copy_command = 'cp -arf "' + donwload_target_path + '" "' + efs_archive_path + '" && touch "' + done_flag_path + 'done.flag"'
            print('aws.run_command: ' + copy_command)
            aws.run_command(instance_id, "AWS-RunShellScript", copy_command)
            # コピー完了の確認
            max_wait_time = 600  # 最大待機時間 10分 (600秒)
            # done.flag存在チェック
            while True:
                if os.path.exists(f"{current_app.config['EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/done.flag"):
                    # 存在したら次の処理へ
                    print('---------- finished copy command -------------')
                    time.sleep(1)
                    break
                if time.time() - start_time >= max_wait_time:
                    raise TimeoutError("ファイルコピーの待機時間が超過しました。")
    except Exception as e:
        print('[ERROR] Faile copy comand ')
        print(e)
        raise Exception("run_command failed")
    try:
        if len(items) == 1 and not items[0]['is_folder']:
            #単一ファイルの場合
            print(f"{current_app.config['EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/download/{items[0]['name']}")
            response = send_file(
                    f"{current_app.config['EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/download/{items[0]['name']}",
                    as_attachment=True,
                    download_name=items[0]['name'],
                    mimetype='application/octet-stream')
            response.direct_passthrough = True
            print(response)
            return response
            #return send_file(f"{current_app.config['EFS_MOUNT_PATH']}storage-support/download/{download_key}/download/{items[0]['name']}")
        else:
            try:
                # アーカイブディレクトリ作成
                efs_archive_path = f"{current_app.config['BRIGH_EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/archive/"
                mkdir_command = 'mkdir -p ' + efs_archive_path
                print('aws.run_command: ' + mkdir_command)
                aws.run_command(instance_id, "AWS-RunShellScript", mkdir_command)
                print(mkdir_command)
                zip_command = f"cd {current_app.config['BRIGH_EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/download && zip -r {efs_archive_path}archive.zip ./"
                print('aws.run_command : ' + zip_command)
                aws.run_command(instance_id, "AWS-RunShellScript", zip_command)
                delete_touch_command = f"rm -rf {current_app.config['EFS_MOUNT_PATH']}{current_app.config['SYSTEM_ID']}/download/{download_key}/download"
                print(f"aws.run_command : {delete_touch_command}")
                aws.run_command(instance_id, "AWS-RunShellScript", delete_touch_command)

                response = send_file(
                        current_app.config['EFS_MOUNT_PATH'] + current_app.config['SYSTEM_ID'] + '/download/' + download_key + '/archive/archive.zip',
                        as_attachment=True,
                        download_name=items[0]['name'],
                        mimetype='application/octet-stream',
                        attachment_filename = 'simsp_download.zip')
                response.direct_passthrough = True
                print(response)
                return response
                #return send_file(current_app.config['EFS_MOUNT_PATH'] + 'storage-support/download/' + download_key + '/archive/archive.zip', as_attachment=False, attachment_filename = 'simsp_download.zip')
            except Exception as e:
                print(e)
                raise Exception(e)
    except Exception as e:
        print(e)
        return Response(status=500, mimetype='application/json')
    

#####
# 2024/03/04 フェーズ4対応
# 企業のEBSボリューム使用量を取得する
# Create: murakami.ak.pm
#####
def get_size(company_code, dname):

    ssm_ = boto3.client('ssm','ap-northeast-1')

    env_id = get_env_id(company_code)
    print('env_id = ' + env_id)
    instance_id = get_bridge_instance_id(company_code)
    print(instance_id)
    # 取得する順番：サイズ,使用,残り,使用%,マウント位置
    # 1行目はラベル
    # カンマ区切り
    df_command = "df -hT -txfs | awk -v 'OFS=,' '{print $3,$4,$5,$6,$7}'"
    response = ssm_.send_command(
        InstanceIds = [get_bridge_instance_id(company_code)],
        DocumentName = 'AWS-RunShellScript',
        Parameters = {'commands': [df_command]}
    )

    command_id = response['Command']['CommandId']
    # コマンドが完了するまで待つ
    time.sleep(5)  # 5秒待つ例
    print(command_id)
    try:
        output = ssm_.get_command_invocation(
            CommandId=command_id,
            InstanceId=instance_id
        )
    except ssm_.exceptions.InvocationDoesNotExist as e:
        print("Error: Command invocation does not exist or is not available yet.")
        print(output['StandardOutputContent'])
        return '0.0'

    output_lines = output['StandardOutputContent'].splitlines()
    size = []
    for line in output_lines:
        low = line.split(',')
        if low[4].endswith(env_id):
            size.append(low[1]) # 使用量 10M
            size.append(low[0]) # 総容量 100M
            size.append(low[3].replace("%", "")) # 使用% 10%
    return size

#####
# 2024/06/14 フェーズ5対応
# EBSからファイルを取得する
# Create: nakano
#####
def get_file(company_code, file_path):
    prefix = os.path.dirname(file_path)
    name = file_path.split('/')[len(file_path.split('/')) -1]
    #ダウンロードID取得
    download_key = str(uuid.uuid4())
    #コピー先ディレクトリ作成
    instance_id = get_bridge_instance_id(company_code)
    download_dist_path = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/efs-mscone/mscone/' + download_key + '/archive'
    mkdir_command = 'mkdir -p ' + download_dist_path
    command_id = aws.run_command(instance_id, "AWS-RunShellScript", mkdir_command)
    env_id = get_env_id(company_code)
    #コピー
    touch_command = 'touch ' + download_dist_path
    aws.run_command(instance_id, "AWS-RunShellScript", touch_command)
    donwload_target_path = '/home/admin@' + current_app.config["DOMAIN_NAME"] + '/mnt/' + env_id + '/' + prefix + '/' + name.replace('*', '')
    copy_command = 'cp -arf "' + donwload_target_path + '" "' + download_dist_path + '"'
    aws.run_command(instance_id, "AWS-RunShellScript", copy_command)

    return '/root/efs-mount-point/mscone/' + download_key + '/archive/' + name