import json
from xml.etree.ElementInclude import include
from src.component.model.tables import MCompany
from src.component.model.tables import MUser
import math
from flask import Flask, Blueprint, render_template, current_app
import platform
from src.component.common.pdbc import pdbc, db_hosts
from src.component.model.simsp import mscone_lic as sml
from src.component.common.aws import aws
import datetime

app = Flask(__name__)

"""
def connection(company_code):
    company_condition = sml.MCompany()
    company_condition.company_code = company_code
    company = pdbc.select(db_hosts.simsp(), company_condition)[0]
    conn = SMBConnection(
        current_app.config['DOMAIN_USERNAME'],
        current_app.config['DOMAIN_PASSWORD'],
        platform.uname().node,
        current_app.config['STORAGE_SHARE_NAME'],
        domain=current_app.config['STORAGE_DOMAIN_NAME'],
        use_ntlm_v2=True,
        is_direct_tcp=True)
    if 'LOCAL' == current_app.config['ENV']:
        conn.connect('localhost', 445)
    else:
        conn.connect(company['access_key'], 445)
    return conn
"""

def close(conn):
    conn.close()

def get_size(company_code, dname):
    response = aws.invoke_lambda(
        'RequestResponse',
        current_app.config['LAMBDA_STORAGE_SUPPORT_SIZE'],
        json.dumps({'company_code' : company_code})
    )
    return convert_size(json.loads(response['Payload'].read()), unit="GB")

def convert_size(size, unit="B"):
    try:
        units = ("B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB")
        i = units.index(unit.upper())
        size = round(size / 1024 ** i, 2)
        return f"{size}"
    except Exception as ex:
        return '0.0'

"""
class StorageComponent:
    ACCESS_KEY = ''
    SHARE_NAME = ''

    def __init__(self, user_email):
        pdbc = PDBCComponent()
        user_condition = MUser()
        user_condition.email = user_email
        company_code =  pdbc.select(current_app.config['SCHEMA_USER_INFRASTRUCTURE'], user_condition)[0]['company_code']
        company_condition = MCompany()
        company_condition.company_code = company_code
        result = pdbc.select(current_app.config['SCHEMA_MSCONE_LIC'], company_condition)[0]
        self.ACCESS_KEY = result['access_key']
        self.SHARE_NAME = result['share_name']

    def convert_size(self, size, unit="B"):
        units = ("B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB")
        i = units.index(unit.upper())
        size = round(size / 1024 ** i, 2)

        return f"{size} {units[i]}"

    def get_state(self):
        share_client = ShareClient.from_connection_string(
            self.ACCESS_KEY,
            self.SHARE_NAME
        )
        size = share_client.get_share_stats()
        return {
            'quota': share_client.get_share_properties()['quota'],
            'size': self.convert_size(size, "GB").replace(' GB', '')
        }

    def list_files_and_dirs(self, dir_name):
        try:
            # Create a ShareClient from a connection string
            share_client = ShareClient.from_connection_string(
                self.ACCESS_KEY,
                self.SHARE_NAME
            )
            folder_list = []
            file_list = []
            for item in list(share_client.list_directories_and_files(dir_name, include = ["timestamps"])):
                if item["is_directory"]:
                    folder_list.append(item)
                else:
                    file_list.append(item)

            item_list = {}
            item_list['folders'] = folder_list
            item_list['files'] = file_list
            data = []
            for folder in item_list['folders']:
                item = {}
                item['name'] = folder['name']
                item['cal_start'] = ''
                item['cal_end'] = ''
                item['status'] = 0
                item['last_modified'] = ''
                item['size'] = ''
                item['is_folder'] = True
                data.append(item)

            for file in item_list['files']:
                item = {}
                item['name'] = file['name']
                item['cal_start'] = ''
                item['cal_end'] = ''
                item['status'] = 0
                item['last_modified'] = str(file['last_modified'] + datetime.timedelta(hours=9))[:-6]
                item['size'] = file['size']
                item['is_folder'] = False
                data.append(item)

            return json.dumps(data)

        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)

    def upload_file(self, data, dest_file_path):
        try:
            print('start-upload')
            # Create a ShareFileClient from a connection string
            file_client = ShareFileClient.from_connection_string(
                        self.ACCESS_KEY,
                        self.SHARE_NAME,
                        dest_file_path)
            directory_list = dest_file_path.split('/')
            directory_list.pop(-1)
            directory_path = ''
            print(directory_list)
            for directory in directory_list:
                directory_path += directory + '/'
                print(directory_path)
                try:
                    # Create a ShareDirectoryClient from a connection string
                    dir_client = ShareDirectoryClient.from_connection_string(
                        self.ACCESS_KEY,
                        self.SHARE_NAME,
                        directory_path)
                    dir_client.create_directory()
                except ResourceExistsError as ex:
                    #print("ResourceExistsError:", ex.message)
                    pass
            try :
                file_client.upload_file(data, timeout=10)
            except TypeError as e:
                if str(e) == "'NoneType' object is not iterable":
                    pass
            return True
        except ResourceExistsError as ex:
            print("ResourceExistsError:", ex.message)
        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)
        except Exception as e:
            print(e)

    def rename_file(self, target_path, new_file_path):
        try:
            # Create a ShareFileClient from a connection string
            file_client = ShareFileClient.from_connection_string(
                        self.ACCESS_KEY,
                        self.SHARE_NAME,
                        target_path)
            file_client.rename_file(new_file_path)
            return {'status': 'ok','msg': 'ファイル名の更新が完了しました。'}
        except ResourceExistsError as ex:
            print("ResourceExistsError:", ex.message)
            return {'status': 'ng','msg': 'この名称はすでに使われています。'}
        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)
            return {'status': 'ng','msg': 'このファイルは存在しません。'}

    def rename_directory(self, old_directory, new_directory):
        try:
            # Create a ShareFileClient from a connection string
            dir_client = ShareDirectoryClient.from_connection_string(
                self.ACCESS_KEY,
                self.SHARE_NAME,
                old_directory)
            dir_client.rename_directory(new_directory)
            return {'status': 'ok','msg': 'ファイル名の更新が完了しました。'}
        except ResourceExistsError as ex:
            return {'status': 'ng','msg': 'この名称はすでに使われています。'}
        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)
            return {'status': 'ng','msg': 'このフォルダは存在しません。'}

    def download_file(self, download_file_path):
        try:
            # Create a ShareFileClient from a connection string
            file_client = ShareFileClient.from_connection_string(
                self.ACCESS_KEY,
                self.SHARE_NAME,
                download_file_path)
            # Open a file for writing bytes on the local system
            print(download_file_path)
            return file_client.download_file().readall()
        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)

    def delete_file(self, delete_file_path):
        if delete_file_path[0] == '/':
            delete_file_path = delete_file_path[1:]
        print(delete_file_path)
        try:
            # Create a ShareFileClient from a connection string
            file_client = ShareFileClient.from_connection_string(
                self.ACCESS_KEY,
                self.SHARE_NAME,
                delete_file_path)
            # Delete the file
            file_client.delete_file()
        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)

    def delete_directory(self, delete_directory_path):
        try:
            dir_client = ShareDirectoryClient.from_connection_string(
                self.ACCESS_KEY,
                self.SHARE_NAME,
                delete_directory_path)
            dir_client.delete_directory()
        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)

    def create_directory(self, create_directory_path):
        try:
            dir_client = ShareDirectoryClient.from_connection_string(
                self.ACCESS_KEY,
                self.SHARE_NAME,
                create_directory_path)
            dir_client.create_directory()
        except ResourceNotFoundError as ex:
            print("ResourceNotFoundError:", ex.message)
"""