import json
from typing import List
import psycopg2
import psycopg2.extras
import datetime
import re
from flask import Flask, Blueprint, render_template, current_app
from src.component.common.pdbc.db_hosts import HostTemplete
import src.component.model.platform
import src.component.model.simsp


app = Flask(__name__)

"""
Connection
"""
def connection(host:HostTemplete, dryrun=False):
    con = None
    try:
        con = psycopg2.connect("host=" + host.host +
                        " port=" + host.port +
                        " dbname=" + host.dbname +
                        " user=" + host.user +
                        " password=" + host.password)
    except Exception as e:
        app.logger.warning('Failed to connection. Check the details. : %s', e)
    con.autocommit = not dryrun
    return con

"""
Close Connection
"""
def close(connection:psycopg2):
    try:
        connection.close
    except Exception as e:
        app.logger.warning('Failed to destroy connection. Check the details.: %s', e)

"""
SELECT Parameter
"""
def select_param(host, sql, param):
    con = connection(host)
    try:
        #辞書型でSelect結果を返却する
        with con.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
            if param is None:
                cur.execute(sql)
            else:
                cur.execute(sql, param)
            results = cur.fetchall()
            rows = []
            
            for row in results:
                rows.append(dict(row))
        return rows
    except Exception as e:
        app.logger.warning('Failed to select execution. Check the details.: %s', e)
    finally:
        close(con)

"""
SELECT Model
"""
def select(host, condition):
    table_name = type(condition).__name__
    table_columns = vars(condition)
    table_schema = table_columns['schema']
    #SQL生成
    sql = 'SELECT * FROM '
    if (table_name == 'TSolverList'):
        sql += table_schema+'.'
        sql += camel_to_snake(table_name)
        condition_columns = vars(condition)
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in table_columns:
                if column == 'schema':
                    sql += '1 = 1 AND '
                    continue
                if table_columns[column] == None:
                    sql += column + ' IS NULL AND '
                elif (column == 'username'): 
                    sql += 'LOWER(' + column + ') = LOWER(' + '%(' + column + ')s) AND ' 
                else :
                    sql += column + ' = ' + '%('+column + ')s AND '
            sql = sql[:-5]
    else:
        sql += table_schema+'.'
        sql += camel_to_snake(table_name)
        condition_columns = vars(condition)
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in table_columns:
                if column == 'schema':
                    sql += '1 = 1 AND '
                    continue
                if table_columns[column] == None:
                    sql += column + ' IS NULL AND '
                else :
                    sql += column + ' = ' + '%('+column + ')s AND '
            sql = sql[:-5]
    sql += ';'
    con = connection(host)
    try:
        #辞書型でSelect結果を返却する
        with con.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
            cur.execute(sql, condition.__dict__)
            results = cur.fetchall()
            rows = []
            for row in results:
                rows.append(dict(row))
        return rows
    except Exception as e:
        app.logger.warning('Failed to select execution. Check the details.: %s', e)
    finally:
        close(con)

"""
INSERT Parameter
"""
def insert_param(host, sql, param, dryrun=False):
    con = connection(host, dryrun)
    try:
        new_id = None
        with con.cursor() as cur:
            cur.execute(sql, param)
            new_id = cur.fetchone()[0]
        if dryrun:
            con.rollback()
        else:
            con.commit()
        return new_id
    except Exception as e:
        app.logger.warning('Failed to insertSingle execution. Check the details.: %s', e)
    finally:
        close(con)

"""
INSERT Model
"""
def insert(host, param, dryrun=False):
    table_name = type(param).__name__
    table_columns = vars(param)
    table_schema = table_columns['schema']
    #SQL生成
    sql = 'INSERT INTO '
    sql += table_schema+'.'
    sql += camel_to_snake(table_name)
    sql += ' '
    column_names = '('
    values = '('
    for column in table_columns:
        if column == 'schema':
            continue
        column_names += (column + ',')
        values += '%('+column + ')s,'

    column_names = column_names[:-1]
    values = values[:-1]
    column_names += ') VALUES '
    values += ');'

    sql += column_names
    sql += values

    con = connection(host, dryrun)
    try:
        new_id = None
        with con.cursor() as cur:
            cur.execute(sql,  param.__dict__)
            new_id = cur.fetchone()[0]
        if dryrun:
            con.rollback()
        else:
            con.commit()
        return new_id
    except Exception as e:
        app.logger.warning('Failed to insertSingle execution. Check the details.: %s', e)
    finally:
        close(con)

"""
UPDATE Parameter
"""
def update_param(host, sql, param, dryrun=False):
    con = connection(host, dryrun)
    try:
        with con.cursor() as cur:
            cur.execute(sql, param)
        if dryrun:
            con.rollback()
        else:
            con.commit()
    except Exception as e:
        app.logger.warning('Failed to update execution. Check the details.: %s', e)
    finally:
        close(con)

"""
UPDATE Model
"""
def update(host, param, condition, dryrun=False):
    table_name = type(param).__name__
    param_columns = vars(param)
    condition_columns = vars(condition)
    table_schema = param_columns['schema']
    print('update')
    #SQL生成
    sql = ''
    print(table_name)
    if (table_name == 'TSolverList'):
        print('t_solver_list')
        sql = 'UPDATE '
        sql += table_schema+'.'
        sql += camel_to_snake(table_name)
        #更新値
        sql += ' SET '
        for column in param_columns:
            if column == 'schema':
                continue
            sql += column + ' = ' + '%('+column + ')s,'
        sql = sql[:-1]
        #条件値
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in condition_columns:
                if column == 'schema':
                    sql += '1 = 1 AND '
                    continue
                if condition_columns[column] == None:
                    sql += column + ' IS NULL AND '
                else :
                    if (column == 'username'): 
                        print('haitteru?')
                        sql += 'LOWER(' + column + ') = LOWER(' + param_replace(condition_columns[column]).lower() + ') AND '
                    else:
                        sql += column + ' = ' + param_replace(condition_columns[column]) + ' AND '
            sql = sql[:-5]
        sql += ';'
    else :
        sql = 'UPDATE '
        sql += table_schema+'.'
        sql += camel_to_snake(table_name)
        #更新値
        sql += ' SET '
        for column in param_columns:
            if column == 'schema':
                continue
            sql += column + ' = ' + '%('+column + ')s,'
        sql = sql[:-1]
        #条件値
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in condition_columns:
                if column == 'schema':
                    sql += '1 = 1 AND '
                    continue
                if condition_columns[column] == None:
                    sql += column + ' IS NULL AND '
                else :
                    sql += column + ' = ' + param_replace(condition_columns[column]) + ' AND '
            sql = sql[:-5]
        sql += ';'

    con = connection(host, dryrun)
    try:
        with con.cursor() as cur:
            cur.execute(sql, param.__dict__)
        if dryrun:
            con.rollback()
        else:
            con.commit()
    except Exception as e:
        app.logger.warning('Failed to update execution. Check the details.: %s', e)
    finally:
        close(con)

"""
DELETE Parameter
"""
def delete_param(host, sql, param, dryrun=False):
    con = connection(host ,dryrun)
    try:
        with con.cursor() as cur:
            cur.execute(sql, param)
        if dryrun:
            con.rollback()
        else:
            con.commit()
    except Exception as e:
        app.logger.warning('Failed to update execution. Check the details.: %s', e)
    finally:
        close(con)

"""
DELETE Model
"""
def delete(host, condition, dryrun=False):
    table_name = type(condition).__name__
    table_columns = vars(condition)
    table_schema = table_columns['schema']
    #SQL生成
    sql = 'DELETE FROM '
    sql += table_schema+'.'
    sql += camel_to_snake(table_name)
    #条件値
    sql += ' WHERE '
    for column in table_columns:
        if column == 'schema':
            sql += '1 = 1 AND '
            continue
        sql += column + ' = ' + param_replace(table_columns[column]) + ' AND '
    sql = sql[:-5]
    sql += ';'

    con = connection(host, dryrun)
    try:
        with con.cursor() as cur:
            cur.execute(sql, None)
        if dryrun:
            con.rollback()
        else:
            con.commit()
    except Exception as e:
        app.logger.warning('Failed to update execution. Check the details.: %s', e)
    finally:
        close(con)
"""
class PDBCComponent:

    def connection(self):
        con = None
        try:
            con = psycopg2.connect("host=" + current_app.config["DATABASE_HOST"] +
                            " port=" + current_app.config["DATABSE_PORT"] +
                            " dbname=" + current_app.config["DATABASE_NAME"] +
                            " user=" + current_app.config["DATABASE_USERNAME"] +
                            " password=" + current_app.config["DATABASE_PASSWORD"])
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to connection. Check the details.: %s, e)
        con.autocommit = True
        return con

    def close(self, connection:psycopg2):
        try:
            connection.close
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to destroy connection. Check the details.: %s, e)

    def select_param(self, sql, param):
        con = self.connection()
        try:
            #辞書型でSelect結果を返却する
            with con.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
                if param is None:
                    cur.execute(sql)
                else:
                    cur.execute(sql, param)
                results = cur.fetchall()
                rows = []
                
                for row in results:
                    rows.append(dict(row))
            return rows
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to select execution. Check the details.: %s, e)
        finally:
            self.close(con)

    def select(self, schema, condition:tables):

        table_name = type(condition).__name__
        table_columns = vars(condition)
        #SQL生成
        sql = 'SELECT * FROM '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        condition_columns = vars(condition)
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in table_columns:
                if table_columns[column] == None:
                    sql += column + ' IS NULL AND '
                else :
                    sql += column + ' = ' + '%('+column + ')s AND '
            sql = sql[:-5]
        sql += ';'
        con = self.connection()
        try:
            #辞書型でSelect結果を返却する
            with con.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
                cur.execute(sql, condition.__dict__)
                results = cur.fetchall()
                rows = []
                
                for row in results:
                    rows.append(dict(row))
            return rows
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to select execution. Check the details.: %s, e)
        finally:
            self.close(con)

    def insert_param(self, sql, param):
        con = self.connection()
        try:
            new_id = None
            with con.cursor() as cur:
                cur.execute(sql, param)
                new_id = cur.fetchone()[0]
            con.commit()
            return new_id
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to insertSingle execution. Check the details.: %s, e)
        finally:
            self.close(con)


    def insert(self, schema, param:tables):
        table_name = type(param).__name__
        table_columns = vars(param)
        #SQL生成
        sql = 'INSERT INTO '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        sql += ' '
        column_names = '('
        values = '('
        for column in table_columns:
            column_names += (column + ',')
            values += '%('+column + ')s,'

        column_names = column_names[:-1]
        values = values[:-1]
        column_names += ') VALUES '
        values += ');'

        sql += column_names
        sql += values

        con = self.connection()
        try:
            new_id = None
            with con.cursor() as cur:
                cur.execute(sql,  param.__dict__)
                new_id = cur.fetchone()[0]
            con.commit()
            return new_id
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to insertSingle execution. Check the details.: %s, e)
        finally:
            self.close(con)

    def update_param(self, sql, param):
        con = self.connect()
        try:
            with con.cursor() as cur:
                cur.execute(sql, param)
            con.commit()
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to update execution. Check the details.: %s, e)
        finally:
            self.close(con)

    def update(self, schema, param:tables, condition:tables):
        table_name = type(param).__name__
        param_columns = vars(param)
        condition_columns = vars(condition)
        #SQL生成
        sql = 'UPDATE '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        #更新値
        sql += ' SET '
        for column in param_columns:
            sql += column + ' = ' + '%('+column + ')s,'
        sql = sql[:-1]
        #条件値
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in condition_columns:
                if condition_columns[column] == None:
                    sql += column + ' IS NULL AND '
                else :
                    sql += column + ' = ' + self.param_replace(condition_columns[column]) + ' AND '
            sql = sql[:-5]
        sql += ';'

        con = self.connection()
        try:
            with con.cursor() as cur:
                cur.execute(sql, param.__dict__)
            con.commit()
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to update execution. Check the details.: %s, e)
        finally:
            self.close(con)

    def delete_param(self, sql, param):
        con = self.connection()
        try:
            with con.cursor() as cur:
                cur.execute(sql, param)
            con.commit()
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to update execution. Check the details.: %s, e)
        finally:
            self.close(con)

    def delete(self, schema, condition:tables):
        table_name = type(condition).__name__
        table_columns = vars(condition)
        #SQL生成
        sql = 'DELETE FROM '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        #条件値
        condition_columns = vars(condition)
        sql += ' WHERE '
        for column in table_columns:
            sql += column + ' = ' + self.param_replace(table_columns[column]) + ' AND '
        sql = sql[:-5]
        sql += ';'

        con = self.connection()
        try:
            with con.cursor() as cur:
                cur.execute(sql, None)
            con.commit()
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to update execution. Check the details.: %s, e)
        finally:
            self.close(con)

    def camel_to_snake(self, s):
        return re.sub("((?<=[a-z0-9])[A-Z]|(?!^)[A-Z](?=[a-z]))", r"_\1", s).lower()

    def param_replace(self, val):
        if type(val) is str:
            val = val.replace("'", "''")
            val = val.replace("\\", "\\\\")
            return "'" + val + "'"
        return str(val)

class DatamartPDBCComponent(PDBCComponent):

    def connection(self):
        con = None
        try:
            con = psycopg2.connect("host=" + current_app.config["DATAMART_DATABASE_HOST"] +
                            " port=" + current_app.config["DATAMART_DATABSE_PORT"] +
                            " dbname=" + current_app.config["DATAMART_DATABASE_NAME"] +
                            " user=" + current_app.config["DATAMART_DATABASE_USERNAME"] +
                            " password=" + current_app.config["DATAMART_DATABASE_PASSWORD"])
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to connection. Check the details.: %s, e)
        con.autocommit = True
        return con

class PlatformPDBCComponent(PDBCComponent):

    def connection(self):
        con = None
        try:
            con = psycopg2.connect("host=" + current_app.config["PLATFORM_DATABASE_HOST"] +
                            " port=" + current_app.config["PLATFORM_DATABSE_PORT"] +
                            " dbname=" + current_app.config["PLATFORM_DATABASE_NAME"] +
                            " user=" + current_app.config["PLATFORM_DATABASE_USERNAME"] +
                            " password=" + current_app.config["PLATFORM_DATABASE_PASSWORD"])
        except Exception as e:
            print(e)
            #app.logger.warning('Failed to connection. Check the details.: %s, e)        
        con.autocommit = True
        return con
"""

"""
Utility
"""
def camel_to_snake(s):
    return re.sub("((?<=[a-z0-9])[A-Z]|(?!^)[A-Z](?=[a-z]))", r"_\1", s).lower()

def param_replace(val):
    if type(val) is str:
        val = val.replace("'", "''")
        val = val.replace("\\", "\\\\")
        return "'" + val + "'"
    return str(val)