import json
import http.client
from src.component.common.entraid.parameters import *
from urllib.request import urlopen
from src.component.model.user_infrastructure import *
from src.component.exception.authenticate import *
from jose import jwt
from flask import Flask, Blueprint, render_template, current_app, session
import requests
import logging
from logging import StreamHandler, FileHandler, Formatter
from logging import INFO, DEBUG, NOTSET
import base64
import urllib.parse

def get_token_auth_header():
    #Flaskのsessionで取得
    access_token = session.get('access_token')

    if not access_token:
        raise AuthError({"code": "authorization_header_missing",
                        "description":
                            "Authorization header is expected"}, 401)

    return access_token

# ----------------------------------------------------------------
# Error handler
class AuthError(Exception):
    def __init__(self, error, status_code):
        self.error = error
        self.status_code = status_code

###############################################################################
#####     名前:main(引数なし)  
#####     内容： 単体デバッグ用
#####     作成日：2024/9/18　　作成者：宅美仁史（新事）
#####     更新日：XXXX/XX/XX　　更新者：XXXXX
#####     更新内容：XXXXXXXXXXXXXXXXXXXXXXXX
###############################################################################
class Auth0Component:
    # ストリームハンドラの設定
    stream_handler = StreamHandler()
    stream_handler.setLevel(INFO)
    stream_handler.setFormatter(Formatter("%(message)s"))

    # ルートロガーの設定   
    logging.basicConfig(level=NOTSET, handlers=[stream_handler])

    ###############################################################################
    ###### 初期化処理
    ###### トークンの発行を行う
    ###### 
    ###############################################################################
    def __init__(self):
        #EntraIDの設定
        '''
        self.ENTRA_ISSUER = current_app.config["ENTRA_ISSUER"]
        self.ENTRA_API_AUDIENCE = current_app.config["ENTRA_API_AUDIENCE"]
        self.ENTRA_AUTHORITY = current_app.config["ENTRA_AUTHORITY"]
        self.ENTRA_OIDC_AUTORITY = current_app.config["ENTRA_OIDC_AUTORITY"]
        self.ENTRA_SCOPE = current_app.config["ENTRA_SCOPE"]
        self.ENTRA_CLIENT_ID = current_app.config["AUTH0_CLIENT_ID"]
        self.ENTRA_CLIENT_SECRET = current_app.config["ENTRA_CLIENT_SECRET"]
        self.ENTRA_JSON_URL = current_app.config["ENTRA_JSON_URL"]
        self.ENTRA_DOMAIN = current_app.config["ENTRA_DOMAIN"]
        self.ENTRA_TENANT_ID = current_app.config["ENTRA_TENANT_ID"]
        self.ENTRA_ENDPOINT=current_app.config["ENTRA_ENDPOINT"]
        '''
        self.ENTRA_ISSUER = 'https://sts.windows.net/a3a5fb7d-bb6f-4d7d-b1cb-ac44d39c0f84/' #テナントID
        self.ENTRA_API_AUDIENCE = 'https://graph.microsoft.com'
        self.ENTRA_AUTHORITY="https://login.microsoftonline.com/a3a5fb7d-bb6f-4d7d-b1cb-ac44d39c0f84/oauth2/v2.0/token" #修正
        self.ENTRA_OIDC_AUTORITY="https://login.contoso.com/a3a5fb7d-bb6f-4d7d-b1cb-ac44d39c0f84/v2.0" #使用しない（マルチテナント時に利用）
        self.ENTRA_CLIENT_ID="4442ccb6-14b5-483e-8a34-a9da8c5c5850"
        self.ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ]
        self.ENTRA_CLIENT_SECRET="U_08Q~636AtJxpoBibgku2PGjdS4vQXSyIfoLb_h"
        self.ENTRA_ENDPOINT="https://graph.microsoft.com/v1.0/users"
        self.ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        self.ENTRA_DOMAIN = 'login.microsoftonline.com'
        self.ENTRA_TENANT_ID = 'a3a5fb7d-bb6f-4d7d-b1cb-ac44d39c0f84'
        self.ENTRA_ENDPOINT="graph.microsoft.com"

        # トークンを取得するためのデータ
        payload = {
            'client_id': self.ENTRA_CLIENT_ID,
            'client_secret': self.ENTRA_CLIENT_SECRET,
            'scope': self.ENTRA_SCOPE,
            'grant_type': 'client_credentials'
        }

        # トークンを取得
        token_response = requests.post(self.ENTRA_AUTHORITY, data=payload)
        token_response_json = token_response.json()

        if 'access_token' in token_response_json:
            self.TOKEN = token_response_json['access_token']
            logging.info("Get token")
        else:
            self.TOKEN = json.loads("Could not acquire token")
            logging.info("Could not acquire token")

    def get_token(self):
        # トークンを取得するためのデータ
        payload = {
            'client_id': self.ENTRA_CLIENT_ID,
            'client_secret': self.ENTRA_CLIENT_SECRET,
            'scope': self.ENTRA_SCOPE,
            'grant_type': 'client_credentials'
        }

        # トークンを取得
        token_response = requests.post(self.ENTRA_AUTHORITY, data=payload)
        token_response_json = token_response.json()

        if 'access_token' in token_response_json:
            self.TOKEN = token_response_json['access_token']
            logging.info("Get token")
        else:
            self.TOKEN = json.loads("Could not acquire token")
            logging.info("Could not acquire token")
    ###############################################################################
    ###### ユーザーリスト取得
    ###### パラメータに応じたユーザーリストを取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user_list(self, parameter:GetUsersParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        path=f"/v1.0/users?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes,signInActivity"

        auth_list=[]
        while path:
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            print(res.status)
            # エラー処理
            if (200 <= res.status < 300):
                data = res.read().decode("utf-8")
                conn.close()
                '''
                # 読み替え Entra -> Auth0
                id -> user_id
                userPrincipalName -> username,
                surname -> family_name
                mail -> email
                givenName -> given_name
                accountEnabled -> blocked
                displayName -> name
                onPremisesExtensionAttributes
                    extensionAttribute1  -> user_metadata
                    extensionAttribute2  -> app_metadata
                '''
                # JSONデータを辞書型に変換
                conv_dic = json.loads(data)
                user_list = conv_dic['value']
                path = conv_dic.get('@odata.nextLink', None)
                auth_dic={}
                
                for user_dic in user_list:
                    #print(user)
                    #user_dic = json.loads(user)
                    auth_dic['user_id']=user_dic['mail']
                    auth_dic['username']=user_dic['userPrincipalName']
                    auth_dic['family_name']=user_dic['surname']
                    auth_dic['email']=user_dic['mail']
                    auth_dic['given_name']=user_dic['givenName']
                    auth_dic['blocked']=not user_dic['accountEnabled']
                    auth_dic['name']=user_dic['displayName']
                    # auth_dic['last_login']=user_dic['signInActivity']['lastSuccessfulSignInDateTime']
        
                    #Attribute1はJSONのためでbase64でencodeされている        
                    if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                        auth_dic['user_metadata']={'data': []}
                    else :
                        base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                        decode_str_1=base64_decode_1.decode()
                        auth_dic['user_metadata']=json.loads(decode_str_1)
                        #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
        
                    #Attribute2はJSONではないと仮定
                    if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
                        auth_dic['app_metadata']={'data': []}
                    else :
                        base64_decode_2= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
                        decode_str_2=base64_decode_2.decode()
                        auth_dic['app_metadata']=json.loads(decode_str_2)
        
                    #Attribute3はJSONではないと仮定
                    auth_dic['appstream']=user_dic['onPremisesExtensionAttributes']['extensionAttribute3']
        
                    auth_list.append(auth_dic)
                    auth_dic={}
            else:
                logging.info("Error occured at 'get_users_by_email:users'.")
                print(f"Error: {res.status}")
                print(res.read().decode())
                break

            conn.close()
        # 結果を表示
        return auth_list
    
    ###############################################################################
    ###### ユーザー情報取得
    ###### 個別ユーザー情報を取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user(self, parameter:GetUserParam):

        param_mail = GetUsersByEmailParam()
        param_mail.email = parameter.id
        result = self.get_users_by_email(param_mail)
        if 'id' in result:
            id = result['id']
        else:
            return {}
        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
        path=f"/v1.0/users/{id}?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes,signInActivity"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")

        conv_dic = json.loads(data)
        
        auth_dic={}

        auth_dic['user_id']=conv_dic['mail']
        auth_dic['username']=conv_dic['userPrincipalName']
        auth_dic['family_name']=conv_dic['surname']
        auth_dic['email']=conv_dic['mail']
        auth_dic['given_name']=conv_dic['givenName']
        auth_dic['blocked']=not conv_dic['accountEnabled']
        auth_dic['name']=conv_dic['displayName']
        # auth_dic['last_login']=conv_dic['signInActivity']['lastSuccessfulSignInDateTime']

        #Attribute1はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
            auth_dic['user_metadata']={'data': []}
        else :
            base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
            decode_str_1=base64_decode_1.decode()
            auth_dic['user_metadata']=json.loads(decode_str_1)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

        #Attribute2はJSONではないと仮定
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
            auth_dic['app_metadata']={'data': []}
        else :
            base64_decode_2= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
            decode_str_2=base64_decode_2.decode()
            auth_dic['app_metadata']=json.loads(decode_str_2)
        #Attribute3はJSONではないと仮定
        auth_dic['appstream']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute3']

        conn.close()

        # 結果を表示
        return auth_dic

    ###############################################################################
    ###### ユーザー情報取得　(Tokenチェック)
    ###### 個別ユーザー情報を取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user_by_auth(self, auth):

        try:
            token = auth.split()[1]
        except:    
            token = auth
        #try:
        # HTTPSConnectionを使用してAPIを呼び出す
        self.ENTRA_ENDPOINT = "graph.microsoft.com"
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {token}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
        path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")

        conv_dic = json.loads(data)
        print(conv_dic)
        auth_dic={}

        auth_dic['user_id']=conv_dic['mail']
        auth_dic['username']=conv_dic['userPrincipalName']
        auth_dic['family_name']=conv_dic['surname']
        auth_dic['email']=conv_dic['mail']
        auth_dic['given_name']=conv_dic['givenName']
        auth_dic['blocked']=not conv_dic['accountEnabled']
        auth_dic['name']=conv_dic['displayName']

        #Attribute1はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
            auth_dic['user_metadata']={'data': []}
        else :
            base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
            decode_str_1=base64_decode_1.decode()
            auth_dic['user_metadata']=json.loads(decode_str_1)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

        #Attribute2はJSONではないと仮定
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
            auth_dic['app_metadata']={'data': []}
        else :
            base64_decode_2= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
            decode_str_2=base64_decode_2.decode()
            auth_dic['app_metadata']=json.loads(decode_str_2)


        conn.close()
        """
        except Exception:
            raise AuthError({"code": "invalid_header",
                            "description":
                                "Unable to get authentication"
                                " token."}, 400)"""
        print(auth_dic)
        return auth_dic

    ###############################################################################
    ###### ユーザー新規登録　
    ###### ユーザーを新規登録する
    ###### ※拡張属性はUpdateで追加
    ###############################################################################
    def create_user(self, parameter:CreateUserParam):
        '''
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }

        conn.request("POST", "/api/v2/users", json.dumps(parameter.__dict__).encode(), headers)
        res = conn.getresponse()
        return json.load(res)
        '''
        '''
        class CreateUserParam:
        #https://auth0.com/docs/api/management/v2#!/Users/post_users
        def __init__(self):
        self.email: str
        self.phone_number: str
        self.user_metadata: list
        self.blocked: bool
        self.email_verified: bool
        self.phone_verified: bool
        self.app_metadata: list
        self.given_name: str
        self.family_name: str
        self.name: str
        self.nickname: str
        self.picture: str
        self.user_id: str
        self.connection: str
        self.password: str
        self.verify_email: bool
        self.username: str
        '''

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # ユーザを作成するためのデータ(EntraID向け)
        user_data = json.dumps({
            "accountEnabled": True,
            "accountEnabled": not parameter.blocked, 
            "displayName": parameter.name,
            "mailNickname": parameter.family_name+parameter.given_name,
            "givenName": parameter.given_name,
            "mail": parameter.email,
            "businessPhones": [parameter.phone_number],
            "surname": parameter.family_name,
            "userPrincipalName": parameter.username,
            "passwordProfile": {
                "forceChangePasswordNextSignIn": True,
                "password": parameter.password
            }
        })

        logging.info(user_data)

        # POSTリクエストでユーザを作成
        conn.request("POST", "/v1.0/users", body=user_data, headers=headers)
        response = conn.getresponse()
        data = response.read().decode("utf-8")
        conn.close()

        # 結果を表示
        return json.loads(data)

    ###############################################################################
    ###### ユーザー削除　
    ###### ユーザーを削除する
    ###### ※
    ###############################################################################
    def delete_user(self, parameter:CreateUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # 検索クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}"
        conn.request("DELETE", path, headers=headers)

        # POSTリクエストでユーザを作成
        response = conn.getresponse()
        #data = response.read().decode("utf-8")
        conn.close()

        return response

    ###############################################################################
    ###### ユーザー更新　
    ###### 既存のユーザーを更新する（拡張領域を含む）
    ###### ※UpdateUserParamの拡張領域がLISTではなくSTRになっている
    ###############################################################################
    def get_users_by_email(self, parameter:GetUsersByEmailParam):
        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        logging.info(parameter.email)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        #conn.request("GET", "/api/v2/users-by-email?fields=" + parameter.fields + "&email=" + parameter.email.lower() , None, headers)
        #path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes&$filter=mail%20eq%20'" + urllib.parse.quote(parameter.email) + "'"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logging.info("Error occured at 'get_users_by_email:users'.")
            logging.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        user_list = conv_dic['value']

        auth_dic={}
        #logging.info(user_list)

        for user_dic in user_list:
            #logging.info(str(user_dic['mail']).lower())
            #指定メールアドレスと検索IDのメールアドレスが一致しているか確認
            if parameter.email.lower() == str(user_dic['mail']).lower() :
                auth_dic['id']=user_dic['id']
                return auth_dic
        return ''

    def update_user(self, parameter:UpdateUserParam):

        '''
        class UpdateUserParam:
        #https://auth0.com/docs/api/management/v2#!/Users/patch_users_by_id
        def __init__(self):
        self.id: str
        self.blocked: bool
        self.email_verified: bool
        self.email: str
        self.phone_number: str
        self.phone_verified: bool
        self.user_metadata: str
        self.app_metadata: str
        self.given_name: str
        self.family_name: str
        self.name: str
        self.nickname: str
        self.picture: str
        self.verify_email: bool
        self.verify_phone_number: bool
        self.username: str
        self.connection: str
        self.client_id: str
        self.username: str
        self.password: str
        #2024.10.09 Added
        self.appstream : str
        '''

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # JSONデータを文字列に変換 user_metadata
        # 文字列をバイナリに変換
        binary_data1 =  json.dumps(parameter.user_metadata).encode('utf-8')
        data_encode_str1 = base64.b64encode(binary_data1).decode('utf-8')

        logging.info(data_encode_str1)

        # JSONデータを文字列に変換 app_metadata
        # 文字列をバイナリに変換
        binary_data2 =  json.dumps(parameter.app_metadata).encode('utf-8')
        data_encode_str2 = base64.b64encode(binary_data2).decode('utf-8')

        logging.info(data_encode_str2)

        #対象ID設定：email(userPrincipalName)
        # 更新するユーザのIDと更新データを設定(EntraID向け)
        update_data = {
            'accountEnabled': not parameter.blocked,
            "onPremisesExtensionAttributes": {
                #"extensionAttribute1": json.dumps(parameter.user_metadata).encode('utf-8'),
                "extensionAttribute1": data_encode_str1,
                "extensionAttribute2": data_encode_str2,
                "extensionAttribute3": parameter.appstream,
            }
        }

        # 検索クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}"
        conn.request("PATCH", path, body=json.dumps(update_data), headers=headers)
        response = conn.getresponse()
        conn.close()

        # 結果を表示
        return response

    #ENTRA_ENDPOINT="https://graph.microsoft.com/v1.0/users"
    def check_invitation_user(self, email):

        entra = Auth0Component()
        user_param = GetUsersByEmailParam()
        user_param.email = email

        result = entra.get_users_by_email(user_param)
        res_user = result

        if res_user :

            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {self.TOKEN}'  
            }

            #logging.info(headers)

            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path = f"/v1.0/users/{res_user['id']}?$select=id,mail,accountEnabled,externalUserState"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()

            # エラー処理
            if not 200 <= res.status < 300 :
                logging.info("Error occured at 'check_invitation_user:invitations'.")
                logging.info(vars(res))
                conn.close()
                # 結果を表示
                return ''
            else :
                data = json.loads(res.read().decode())
                conn.close()
                print(data.keys())
                auth_dic={}
                auth_dic['id']=data.get('id')
                auth_dic['email']=data.get('mail')
                auth_dic['status']=data.get('externalUserState')

                #承認済みの場合
                if auth_dic['status'] == 'Accepted' :
                    logging.info("User accepted.")
                        # 結果を表示
                    return json.dumps(auth_dic)
                else :
                    logging.info(f"Invitation Status : {auth_dic['id']} / {auth_dic['email']} / {auth_dic['status']}")
                    return ''
