import json
from typing import List
import psycopg2
import psycopg2.extras
from src.component.model import tables
import datetime
import re
from flask import Flask, Blueprint, render_template, current_app
import boto3
import time

app = Flask(__name__)

def invoke_lambda(invocation_type, function_name, payload):
    return boto3.client('lambda','ap-northeast-1').invoke(
        FunctionName=function_name,
        InvocationType=invocation_type,
        Payload=payload
    )

def run_command(target_instance, document_name, runcommand):
    ssm = boto3.client('ssm', 'ap-northeast-1')
    r = ssm.send_command(
            InstanceIds = [target_instance],
            DocumentName = document_name,
            Parameters = {
                "commands": [
                    runcommand
                ]    
            },
            OutputS3Region='ap-northeast-1',
            OutputS3BucketName=current_app.config["STORAGE_SUPPORT_BUCKET_NAME"],
            OutputS3KeyPrefix='ls',
        )
    command_id = r['Command']['CommandId']
    for x in range(200):
        time.sleep(1)
        res = ssm.list_command_invocations(
                CommandId = command_id,
                Details = True
            )
        invocations = res['CommandInvocations']
        status = invocations[0]['Status']

        if status == "Success" or status == "Failed":
            return command_id
    raise Exception("run_command failed")

def list_command_invocations(command_id):
    ssm = boto3.client('ssm', 'ap-northeast-1')
    res = ssm.list_command_invocations(
            CommandId = command_id,
            Details = True
        )
    return res['CommandInvocations']

def s3_upload(f, bucket_name, object_name):
    s3 = boto3.client('s3')
    s3.upload_fileobj(f, bucket_name, object_name)