import json
import http.client
from src.component.common.auth0.v2.parameters import *
from urllib.request import urlopen
from src.component.model.user_infrastructure import *
from jose import jwt
from flask import Flask, Blueprint, render_template, current_app

class Auth0Component:
    TOKEN = ''
    AUTH0_API_DOMAIN = ''
    AUTH0_DOMAIN = ''
    AUTH0_AUDIENCE = ''
    AUTH0_CLIENT_ID = ''
    AUTH0_CLIENT_SECRET = ''

    """
    初期化処理
    ・トークンの発行を行う
    """
    def __init__(self):
        #認証情報取得
        self.AUTH0_API_DOMAIN = current_app.config["AUTH0_API_DOMAIN"]
        self.AUTH0_DOMAIN = current_app.config["AUTH0_API_DOMAIN"]
        self.AUTH0_AUDIENCE = current_app.config["AUTH0_API_AUDIENCE"]
        self.AUTH0_CLIENT_ID = current_app.config["AUTH0_CLIENT_ID"]
        self.AUTH0_CLIENT_SECRET = current_app.config["AUTH0_CLIENT_SECRET"]
        #APIトークン取得
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = { 'content-type': "application/json" }
        payload = {
            'client_id': self.AUTH0_CLIENT_ID,
            'client_secret': self.AUTH0_CLIENT_SECRET,
            'audience': self.AUTH0_AUDIENCE,
            'grant_type': 'client_credentials'
        }
        conn.request("POST", "/oauth/token", json.dumps(payload).encode(), headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")
        self.TOKEN = json.loads(data)["access_token"]
    """
    接続情報の更新
    """
    def get_token(self):
        # APIトークン取得
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = { 'content-type': "application/json" }
        payload = {
            'client_id': self.AUTH0_CLIENT_ID,
            'client_secret': self.AUTH0_CLIENT_SECRET,
            'audience': self.AUTH0_AUDIENCE,
            'grant_type': 'client_credentials'
        }
        conn.request("POST", "/oauth/token", json.dumps(payload).encode(), headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")
        self.TOKEN = json.loads(data)["access_token"]

    """
    パスワード再発行
    """
    def send_change_password(self, email):
        conn = http.client.HTTPSConnection(self.AUTH0_API_DOMAIN)
        headers = {
            'Content-Type': 'application/json'
        }
        conn.request("POST", "/dbconnections/change_password", json.dumps({'client_id': self.AUTH0_CLIENT_ID, 'email': email, 'connection': 'Username-Password-Authentication'}).encode(), headers)
        res = conn.getresponse()
        #return True
        return res

    """
    ユーザーリスト取得
    ・パラメータに応じたユーザーリストを取得する
    """
    def get_user_list(self, parameter:GetUsersParam):
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }
        conn.request("GET", "/api/v2/users", json.dumps(parameter.__dict__).encode(), headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")
        return json.loads(data)

    """
    ユーザー情報取得
    ・個別ユーザー情報を取得する
    """
    def get_user(self, parameter:GetUserParam):
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }
        conn.request("GET", "/api/v2/users/auth0|"+parameter.id, json.dumps(parameter.__dict__).encode(), headers)
        res = conn.getresponse()
        return json.load(res)

    """
    ユーザー情報取得
    ・個別ユーザー情報を取得する
    """
    def get_user_by_auth_portal(self, auth):
        parts = auth.split()
        token = parts[1]
        jsonurl = urlopen("https://"+current_app.config["AUTH0_DOMAIN"]+"/.well-known/jwks.json")
        jwks = json.loads(jsonurl.read())
        unverified_header = jwt.get_unverified_header(token)
        rsa_key = {}
        for key in jwks["keys"]:
            if key["kid"] == unverified_header["kid"]:
                rsa_key = {
                    "kty": key["kty"],
                    "kid": key["kid"],
                    "use": key["use"],
                    "n": key["n"],
                    "e": key["e"]
                }
        payload = jwt.decode(
            token,
            rsa_key,
            algorithms=current_app.config["ALGORITHMS"],
            audience=self.AUTH0_AUDIENCE,
            issuer="https://"+current_app.config["AUTH0_DOMAIN"]+"/"
        )
        return payload
    
    def get_user_by_auth(self, auth):
        parts = auth.split()
        token = parts[1]
        jsonurl = urlopen("https://"+current_app.config["AUTH0_DOMAIN"]+"/.well-known/jwks.json")
        jwks = json.loads(jsonurl.read())
        unverified_header = jwt.get_unverified_header(token)
        rsa_key = {}
        for key in jwks["keys"]:
            if key["kid"] == unverified_header["kid"]:
                rsa_key = {
                    "kty": key["kty"],
                    "kid": key["kid"],
                    "use": key["use"],
                    "n": key["n"],
                    "e": key["e"]
                }
        payload = jwt.decode(
            token,
            rsa_key,
            algorithms=current_app.config["ALGORITHMS"],
            audience=current_app.config["API_AUDIENCE"],
            issuer="https://"+current_app.config["AUTH0_DOMAIN"]+"/"
        )
        user_param = GetUserParam()
        user_param.id = payload['sub'].replace('auth0|', '')
        return self.get_user(user_param)

    """
    ユーザー新規登録
    ・ユーザーを新規登録する
    """
    def create_user(self, parameter:CreateUserParam):
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }
        conn.request("POST", "/api/v2/users", json.dumps(parameter.__dict__).encode(), headers)
        res = conn.getresponse()
        return json.load(res)

    """
    ユーザー削除
    ・ユーザーを削除する
    """
    def delete_user(self, parameter:CreateUserParam):
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }
        conn.request("DELETE", "/api/v2/users/auth0|"+parameter.id, json.dumps(parameter.__dict__).encode(), headers)
        res = conn.getresponse()
        return res

    """
    ユーザー更新
    ・既存のユーザーを更新する
    """
    def update_user(self, parameter:UpdateUserParam):
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }
        id = parameter.id
        json.dumps(parameter.__dict__.pop('id')).encode()
        conn.request("PATCH", "/api/v2/users/auth0|"+id, json.dumps(parameter.__dict__).encode(), headers)
        res = conn.getresponse()
        return json.load(res)

    """
    ユーザーロール取得
    """
    def get_user_roles(self, id):
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }
        parameter = GetUsersRoles()
        parameter.id = id
        conn.request("GET", "/api/v2/users/"+str(id)+"/roles",json.dumps(parameter.__dict__).encode(), headers)
        res = conn.getresponse()
        return json.load(res)

    """
    ユーザーロール追加
    """
    def add_user_roles(self, id, role_ids):
        conn = http.client.HTTPSConnection(self.AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + self.TOKEN
        }
        conn.request("POST", "/api/v2/users/"+str(id)+"/roles",json.dumps({'roles' : [role_ids]}).encode(), headers)
        res = conn.getresponse()
        return res
"""
    def get_auth0_user_id(self, email):
        pdbc = PDBCComponent()
        user_infrastructure_m_user = user_infrastructure.MUser()
        user_infrastructure_m_user.email = email
        return pdbc.select(current_app.config['SCHEMA_USER_INFRASTRUCTURE'], user_infrastructure_m_user)[0]['auth0_user_id']
"""