import os

from flask import Flask, render_template
app = Flask(__name__)

from src.component.exception.base import exception_bp
app.register_blueprint(exception_bp)

from src.component.function.user.user import user_bp
app.register_blueprint(user_bp)

from src.component.function.solver.solver import solver_bp
app.register_blueprint(solver_bp)

from src.component.function.folder.folder import folder_bp
app.register_blueprint(folder_bp)

from src.component.function.history.history import history_bp
app.register_blueprint(history_bp)

from src.component.function.billing.billing import billing_bp
app.register_blueprint(billing_bp)

from src.component.function.app.app import app_bp
app.register_blueprint(app_bp)

from src.component.function.portal.portal import portal_bp
app.register_blueprint(portal_bp)

from src.component.function.faq.faq import faq_bp
app.register_blueprint(faq_bp)

@app.route('/healthcheck', methods=['GET'])
def get_healthcheck():
    return '200'

if __name__ == '__main__':
    app.config.from_object("config.EvolutionConfig")
    certfile = os.path.dirname(__file__) + '/openssl/server.crt'
    keyfile = os.path.dirname(__file__) + '/openssl/server.key'
    app.run(host='0.0.0.0', port='5556',ssl_context=(certfile, keyfile), threaded=True, debug=True)