import json
import csv
from flask import Flask, request, make_response, abort, jsonify, send_file, after_this_request, _request_ctx_stack
from werkzeug.utils import secure_filename
from werkzeug.datastructures import  FileStorage
from flask_cors import CORS
import os
from collections import OrderedDict
import base64
# from PIL import Image as PIL_IMG
import boto3
import sqlite3
# from PIL import Image
from pathlib import Path
import datetime
import psycopg2
import psycopg2.extras
from decimal import Decimal
import shutil
import boto3
import re
import hashlib
from zipfile import ZipFile
import http.client
# import python-dotenv
# import python-jose
from flask_cors import cross_origin
from jose import jwt
import string
import secrets
import ssl
import smtplib
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
import uuid

from urlopen import urlopen
from functools import wraps

import urllib
import time

BUCKET_NAME = 'mscone-apptream-s3-bucket-mscone'#'appstream2-36fb080bb8-ap-northeast-1-965166023933'
PREFIX = ''#'user/federated/'
#####DEVELOP
"""
AUTH0_DOMAIN = 'mscone-ndes-dx.jp.auth0.com'
API_AUDIENCE = 'https://54.250.108.221:5556'
ALGORITHMS = ["RS256"]
INVITATION_URL = "https://54.250.108.221:8889/#/invitation/?"
VERIFY_URL = "https://54.250.108.221:8889/#/verify/?"
LOGIN_URL = "https://54.250.108.221:8889/"
AUTH0_CLIENT_ID = 'kOayGQHo1JL1su1pgONXevSVXgtbzrgO'
AUTH0_CLIENT_SECRET = 'BvONm0-vtTXr7yOk0l64ACEW0VeM82d1UhyGmKiozM6pvVGyBZLo1745c1pla4Q5'
ACCOUNT = "AKIA6BODAYT6UNFPKV5V"
PASSWORD = "BB2hnqPHq1KB7Gi/POyzpHE0yeMS9Vyu6MMubaDMafjK"
SMPTSERVER = 'email-smtp.ap-northeast-1.amazonaws.com'
FROM_ADDRESS = 'invivation@mscone-cloud-license.ndes-dx.com'
"""
#####PILOT
AUTH0_DOMAIN = 'mscone-eval-ndes-dx.jp.auth0.com'
API_AUDIENCE = 'https://eval-mscone-cloud-license.ndes-dx.com:5556'
ALGORITHMS = ["RS256"]
INVITATION_URL = "https://eval-mscone-cloud-license.ndes-dx.com/#/invitation/?"
VERIFY_URL = "https://eval-mscone-cloud-license.ndes-dx.com/#/verify/?"
LOGIN_URL = "https://eval-mscone-cloud-license.ndes-dx.com/"
AUTH0_CLIENT_ID = ''
AUTH0_CLIENT_SECRET = ''
ACCOUNT = "AKIA6BODAYT6UNFPKV5V"
PASSWORD = "BB2hnqPHq1KB7Gi/POyzpHE0yeMS9Vyu6MMubaDMafjK"
SMPTSERVER = 'email-smtp.ap-northeast-1.amazonaws.com'
FROM_ADDRESS = 'invivation@mscone-cloud-license.ndes-dx.com'
#####PROD
#AUTH0_DOMAIN = ''
#API_AUDIENCE = ''
#ALGORITHMS = ["RS256"]
#INVITATION_URL = ""
#VERIFY_URL = ""
#LOGIN_URL = ""
#ACCOUNT = ""
#PASSWORD = ""
#SMPTSERVER = ''
#FROM_ADDRESS = ''

app = Flask(__name__, static_folder='uploads')

# This is necessary because QUploader uses an AJAX request
# to send the file
cors = CORS()
cors.init_app(app, resource={r"/api/*": {"origins": "*"}})

UPLOAD_FOLDER = './uploads/'

client = None
    
# ----------------------------------------------------------------
# Error handler
class AuthError(Exception):
    def __init__(self, error, status_code):
        self.error = error
        self.status_code = status_code

@app.errorhandler(AuthError)
def handle_auth_error(ex):
    response = jsonify(ex.error)
    response.status_code = ex.status_code
    return response

# ----------------------------------------------------------------
# Format error response and append status code
def get_token_auth_header():
    """Obtains the Access Token from the Authorization Header
    """
    auth = request.headers.get("Authorization", None)
    if not auth:
        raise AuthError({"code": "authorization_header_missing",
                        "description":
                            "Authorization header is expected"}, 401)

    parts = auth.split()

    if parts[0].lower() != "bearer":
        raise AuthError({"code": "invalid_header",
                        "description":
                            "Authorization header must start with"
                            " Bearer"}, 401)
    elif len(parts) == 1:
        raise AuthError({"code": "invalid_header",
                        "description": "Token not found"}, 401)
    elif len(parts) > 2:
        raise AuthError({"code": "invalid_header",
                        "description":
                            "Authorization header must be"
                            " Bearer token"}, 401)

    token = parts[1]
    return token

def get_api_token_auth_header():
    conn = http.client.HTTPSConnection(AUTH0_DOMAIN)
    payload = "{\"client_id\":\"kOayGQHo1JL1su1pgONXevSVXgtbzrgO\",\"client_secret\":\"BvONm0-vtTXr7yOk0l64ACEW0VeM82d1UhyGmKiozM6pvVGyBZLo1745c1pla4Q5\",\"audience\":\"https://mscone-ndes-dx.jp.auth0.com/api/v2/\",\"grant_type\":\"client_credentials\"}"
    #BAD payload = "{\"client_id\":\"D1biL7SPlbqVmvCOqrEaLrC8RtiUm9Ia\",\"client_secret\":\"1-Nlt7hK0r-FW2S-wCMItpc5IRmhFXPlT7-HDQtvSkLYf9gqid-22OvtIzbQBhw6\",\"audience\":\"https://eval-mscone-cloud-license.ndes-dx.com:5556\",\"grant_type\":\"client_credentials\"}"
    #payload = "{\"client_id\":\"1JQrWzT7fEQbEYamyuYBXYyZ81maDsSY\",\"client_secret\":\"-v9AKQaIErRBZXHen_nPmd5SgglpAPNEFcwlUmpIIYvQmtBQdC7hgKu1Zy3KVm5l\",\"audience\":\"https://mscone-eval-ndes-dx.jp.auth0.com/api/v2/\",\"grant_type\":\"client_credentials\"}"

    headers = { 'content-type': "application/json" }
    conn.request("POST", "/oauth/token", payload, headers)
    res = conn.getresponse()
    data = res.read().decode("utf-8")
    print('----------------------')
    print(data)
    print('----------------------')
    return json.loads(data)["access_token"]

def requires_auth(f):
    """Determines if the Access Token is valid
    """
    @wraps(f)
    def decorated(*args, **kwargs):
        token = get_token_auth_header()
        jsonurl = urlopen("https://"+AUTH0_DOMAIN+"/.well-known/jwks.json")
        jwks = json.loads(jsonurl.read())
        unverified_header = jwt.get_unverified_header(token)
        rsa_key = {}
        for key in jwks["keys"]:
            if key["kid"] == unverified_header["kid"]:
                rsa_key = {
                    "kty": key["kty"],
                    "kid": key["kid"],
                    "use": key["use"],
                    "n": key["n"],
                    "e": key["e"]
                }
        if rsa_key:
            try:
                payload = jwt.decode(
                    token,
                    rsa_key,
                    algorithms=ALGORITHMS,
                    audience=API_AUDIENCE,
                    issuer="https://"+AUTH0_DOMAIN+"/"
                )
            except jwt.ExpiredSignatureError:
                raise AuthError({"code": "token_expired",
                                "description": "token is expired"}, 401)
            except jwt.JWTClaimsError:
                raise AuthError({"code": "invalid_claims",
                                "description":
                                    "incorrect claims,"
                                    "please check the audience and issuer"}, 401)
            except Exception:
                raise AuthError({"code": "invalid_header",
                                "description":
                                    "Unable to parse authentication"
                                    " token."}, 401)

            _request_ctx_stack.top.current_user = payload
            return f(*args, **kwargs)
        raise AuthError({"code": "invalid_header",
                        "description": "Unable to find appropriate key"}, 401)
    return decorated

def requires_scope(required_scope):
    """Determines if the required scope is present in the Access Token
    Args:
        required_scope (str): The scope required to access the resource
    """
    token = get_token_auth_header()
    unverified_claims = jwt.get_unverified_claims(token)
    if unverified_claims.get("scope"):
            token_scopes = unverified_claims["scope"].split()
            for token_scope in token_scopes:
                if token_scope == required_scope:
                    return True
    return False

def permission(auth):
    def _permission(f):
        def _wrapper(*args, **keywords):
            data = {}
            data['user_email'] = request.headers.get('email')
            #ユーザー権限取得
            sql = '''
                SELECT
                    is_manager
                FROM
                    m_user
                WHERE
                    user_id = %(user_email)s
                    AND
                    is_manager = True
            '''

            con = connect()
            rows = []
            rows = select_execute(con, sql, data)
            try:
                if not rows[0]['is_manager']:
                    abort(401)
            except Exception as e:
                abort(401)
            v = f(*args, **keywords)
            return v
        return _wrapper
    return _permission

# ----------------------------------------------------------------
# # This needs authentication
# @app.route("/list", methods=['GET'])
# @cross_origin(headers=["Content-Type", "Authorization"])
# @requires_auth
# def private():
#     response = "Hello from a private endpoint! You need to be authenticated to see this."
#     return jsonify(message=response)

# ----------------------------------------------------------------
def my_print(obj):
    # print(obj)
    pass

# ----------------------------------------------------------------
@app.errorhandler(400)
@app.errorhandler(401)
@app.errorhandler(404)
@app.errorhandler(500)
def error_handler(error):
    response = jsonify({ 'message': error.name, 'result': error.code })
    return response, error.code

# ----------------------------------------------------------------
def get_user_hash_id():
    for ui in user_ids:
        hs = hashlib.sha256(ui.encode()).hexdigest()
        user_hash_id[ui] = hs
# ----------------------------------------------------------------
@app.route('/healthcheck', methods=['GET'])
def get_healthcheck():
    return ''

# ----------------------------------------------------------------
@app.route('/nodes', methods=['GET'])
# @cross_origin(headers=["Content-Type", "Authorization"])
# @requires_auth
def get_nodes():

    user_id = ''
    user_email = ''
    
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')
    
    prefix = '/home/admin@appstream.msc/mnt/fsx-mscone/'
    prefix += request.args.get('folder_name').replace('//', '/')

    file_list = []
    folder_list = []
    
    ls_command = "ls -lFk --full-time '"+ prefix + "' | jc --ls -p"
    ssm = boto3.client('ssm')
    r = ssm.send_command(
            #InstanceIds = ['i-0fc7121e4bc3febab'],
            InstanceIds = [get_bridge_instance_id(user_email)],
            DocumentName = "AWS-RunShellScript",
            Parameters = {
                "commands": [
                    ls_command
                ]    
            },
            OutputS3Region='ap-northeast-1',
            OutputS3BucketName='mscone-apptream-s3-bucket-mscone',
            OutputS3KeyPrefix='ls',
        )
    command_id = r['Command']['CommandId']
    #ls_output_key = 'ls/' + command_id + '/i-0fc7121e4bc3febab/awsrunShellScript/0.awsrunShellScript/stdout'
    ls_output_key = 'ls/' + command_id + '/' + get_bridge_instance_id(user_email) + '/awsrunShellScript/0.awsrunShellScript/stdout'
    print(ls_output_key)
    for x in range(30):
        time.sleep(1)
        res = ssm.list_command_invocations(
                CommandId = command_id,
                Details = True
            )
        invocations = res['CommandInvocations']
        status = invocations[0]['Status']

        if status == "Success" or status == "Failed":
            ls_output = None
            try:
                files = invocations[0]['CommandPlugins'][0]['Output']
                s3 = boto3.resource('s3')
                s3.Bucket('mscone-apptream-s3-bucket-mscone').download_file(Filename='/home/ec2-user/ls_logs/' + command_id, Key=ls_output_key)
                #s3.Bucket('mscone-apptream-s3-bucket-mscone').download_file(Filename='C:\\Users\\NDES\\docker\\logs\\' + command_id, Key=ls_output_key)
                #ls_output = open('C:\\Users\\NDES\\docker\\logs\\' + command_id, encoding='utf-8')
                ls_output = open('/home/ec2-user/ls_logs/' + command_id, encoding='utf-8')
                files = ls_output.read()
                for file in json.loads(files):
                    if file['filename'][len(file['filename'])-1] == '*':
                        file_obj = {}
                        file_obj['name'] = file['filename'].replace('*','')
                        file_obj['size'] = file['size']
                        file_obj['date'] = file['date'].split('.')[0]
                        file_list.append(file_obj)
                    if file['filename'][len(file['filename'])-1] != '*':
                        folder_obj = {}
                        folder_obj['name'] = file['filename'].replace('/','')
                        folder_obj['size'] = file['size']
                        folder_obj['date'] = file['date'].split('.')[0]
                        folder_list.append(folder_obj)
            except Exception as e:
                print(e)
            finally:
                if ls_output != None:
                    ls_output.close()
            break

    list = {}
    list['folders'] = folder_list
    list['files'] = file_list

    objs = list
    print(objs)

    data = []

    for folder in objs['folders']:
        item = {}
        item['name'] = folder['name']
        item['cal_start'] = ''
        item['cal_end'] = ''
        item['status'] = 0
        item['last_modified'] = ''
        item['size'] = ''
        item['is_folder'] = True
        data.append(item)

    for file in objs['files']:
        item = {}
        item['name'] = file['name']
        item['cal_start'] = ''
        item['cal_end'] = ''
        item['status'] = 0
        item['last_modified'] = file['date']
        item['size'] = file['size']
        item['is_folder'] = False
        data.append(item)

    return json.dumps(data)


# ----------------------------------------------------------------
@app.route('/nodes', methods=['DELETE'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def delete_nodes():

    user_id = ''
    user_email = ''
    
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')

    folder_name = request.args.get('folder_name')
    prefixes = json.loads(request.args.get('prefixes'))
    for del_prefix in prefixes:
        del_prefix = '/home/admin@appstream.msc/mnt/fsx-mscone/' + folder_name + '/' + del_prefix
        #mv command
        ssm = boto3.client('ssm')
        ##Command投入
        delete_command = 'rm -rf ' + del_prefix
        r = ssm.send_command(
                #InstanceIds = ['i-0fc7121e4bc3febab'],
                InstanceIds = [get_bridge_instance_id(user_email)],
                DocumentName = "AWS-RunShellScript",
                Parameters = {
                    "commands": [
                        delete_command
                    ]    
                }
            )
        command_id = r['Command']['CommandId']
        for x in range(2000):
            time.sleep(3)
            res = ssm.list_command_invocations(
                    CommandId = command_id,
                    Details = True
                )
            invocations = res['CommandInvocations']
            status = invocations[0]['Status']

            if status == "Success" or status == "Failed":
                break
            

    return 'Okey!'

# ----------------------------------------------------------------
    
@app.route('/create_new_folder', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def create_new_folder():
    print('create_new_folder')
    user_id = ''
    user_email = ''
    
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')
    folder_name = request.form.get('folder_name')

    print(folder_name)
    if folder_name.startswith("/"):
        folder_name = folder_name[1:]

    s3 = boto3.client('s3')

    print(folder_name)
    #mv command
    ssm = boto3.client('ssm')
    ##Command投入
    mkdir_command = 'mkdir /home/admin@appstream.msc/mnt/fsx-mscone/' + folder_name
    r = ssm.send_command(
            #InstanceIds = ['i-0fc7121e4bc3febab'],
            InstanceIds = [get_bridge_instance_id(user_email)],
            DocumentName = "AWS-RunShellScript",
            Parameters = {
                "commands": [
                    mkdir_command
                ]    
            }
        )
    command_id = r['Command']['CommandId']
    for x in range(2000):
        time.sleep(3)
        res = ssm.list_command_invocations(
                CommandId = command_id,
                Details = True
            )
        invocations = res['CommandInvocations']
        status = invocations[0]['Status']

        if status == "Success" or status == "Failed":
            break

    return 'Okay!'

# ----------------------------------------------------------------

@app.route('/upload', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def upload():
    print('upload-------------------------')

    user_id = ''
    user_email = ''
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')

    folder_name = request.args.get('folder_name')
    s3 = boto3.client('s3')
    for key in request.files:
        upload_key = str(uuid.uuid4())
        f = request.files.get(key)
        if request.form.get('path'):
            file_name = request.form.get('path')
        else:
            file_name = os.path.basename(f.name)
        if file_name.startswith("/"):
            file_name = file_name[1:]

        s3_file_name = upload_key
        if folder_name != '':
            s3_file_name += '/' + folder_name

        if file_name != '':
            s3_file_name += '/' + file_name
        s3.upload_fileobj(f, BUCKET_NAME + '-upload', s3_file_name)

        #mv command
        ssm = boto3.client('ssm')
        ##Command投入
        original_upload_path = '/home/admin@appstream.msc/mnt/s3-mscone-upload/' + upload_key + '/*'
        dist_upload_path = '/home/admin@appstream.msc/mnt/fsx-mscone'
        copy_command = 'cp -r ' + original_upload_path + ' ' + dist_upload_path
        r = ssm.send_command(
                #InstanceIds = ['i-0fc7121e4bc3febab'],
                InstanceIds = [get_bridge_instance_id(user_email)],
                DocumentName = "AWS-RunShellScript",
                Parameters = {
                    "commands": [
                        copy_command
                    ]    
                }
            )
        command_id = r['Command']['CommandId']
        for x in range(2000):
            time.sleep(3)
            res = ssm.list_command_invocations(
                    CommandId = command_id,
                    Details = True
                )
            invocations = res['CommandInvocations']
            status = invocations[0]['Status']

            if status == "Success" or status == "Failed":
                break

    return 'Okay!'

# ----------------------------------------------------------------
@app.route('/download_multiple', methods=['GET'])
# @cross_origin(headers=["Content-Type", "Authorization"])
# @requires_auth
def download_multiple():
    user_id = ''
    user_email = ''
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')
    prefix = request.args.get('prefix')

    #ダウンロードID取得
    download_key = str(uuid.uuid4())
    data_download = {}
    data_download['user_id'] = user_email
    data_download['zip_start_time'] = datetime.datetime.now()
    data_download['local_path'] = download_key + '/original'
    data_download['download_path'] = '/root/efs-mount-point/mscone/' + download_key + '/archive'
    t_download_job_id = insert_download(data_download)
    ssm = boto3.client('ssm')
    #コピー先ディレクトリ作成
    mkdir_command = 'mkdir -p /home/admin@appstream.msc/mnt/s3-mscone-upload/' + download_key + '/original'
    r = ssm.send_command(
            #InstanceIds = ['i-0fc7121e4bc3febab'],
            InstanceIds = [get_bridge_instance_id(user_email)],
            DocumentName = "AWS-RunShellScript",
            Parameters = {
                "commands": [
                    mkdir_command
                ]    
            }
        )
    command_id = r['Command']['CommandId']
    for x in range(2000):
        time.sleep(3)
        res = ssm.list_command_invocations(
                CommandId = command_id,
                Details = True
            )
        invocations = res['CommandInvocations']
        status = invocations[0]['Status']

        if status == "Success" or status == "Failed":
            break
    #コピー
    for item in json.loads(request.args.get('items')):
        donwload_target_path = '/home/admin@appstream.msc/mnt/fsx-mscone/' + prefix + '/' + item['name'].replace('*', '')
        download_dist_path = '/home/admin@appstream.msc/mnt/s3-mscone-upload/' + download_key + '/original'
        copy_command = 'cp -r ' + donwload_target_path + ' ' + download_dist_path
        r = ssm.send_command(
                #InstanceIds = ['i-0fc7121e4bc3febab'],
                InstanceIds = [get_bridge_instance_id(user_email)],
                DocumentName = "AWS-RunShellScript",
                Parameters = {
                    "commands": [
                        copy_command
                    ]    
                }
            )
        command_id = r['Command']['CommandId']
        for x in range(2000):
            time.sleep(3)
            res = ssm.list_command_invocations(
                    CommandId = command_id,
                    Details = True
                )
            invocations = res['CommandInvocations']
            status = invocations[0]['Status']

            if status == "Success" or status == "Failed":
                break
    #Lambda呼び出し
    Payload = json.dumps({'t_download_job_id': int(t_download_job_id), 'prefix': request.args.get('prefix'), 'download_target': json.dumps(json.loads(request.args.get('items')))})
    response = boto3.client('lambda').invoke(
        FunctionName='eval-lam-msc1-003-download',
        #FunctionName='stg-lam-msc1-013-download',
        #FunctionName='poc-lam-msc1-013-download',
        InvocationType='Event',
        Payload=Payload
    )
    #ダウンロードステータスpolling
    download_data = None
    while True:
        time.sleep(3)
        data_download = {}
        data_download['t_download_job_id'] = t_download_job_id
        download_data = select_download(data_download)
        if str(download_data[0]['status']) == 'F' or str(download_data[0]['status']) == 'E':
            #完了or エラー
            print(download_data)
            break
    print(download_data[0])
    if len(json.loads(request.args.get('items'))) == 1 and not json.loads(request.args.get('items'))[0]['is_folder']:
        #単一ファイルの場合
        print('/root/efs-mount-point/mscone/' + str(download_data[0]['local_path']) + '/' + str(json.loads(request.args.get('items'))[0]['name']))
        return send_file('/root/efs-mount-point/mscone/' + str(download_data[0]['local_path']) + '/' + str(json.loads(request.args.get('items'))[0]['name']))
    else:
        print(str(download_data[0]['download_path']) + '/archive.zip')
        return send_file(str(download_data[0]['download_path']) + '/archive.zip', as_attachment=False, attachment_filename = 'mscone_download.zip')

def insert_download(data):
    print('insert_download')
    sql = '''
        INSERT INTO 
            t_download_job (user_id, zip_start_time, local_path, download_path, status) 
        VALUES
            (%(user_id)s,%(zip_start_time)s,%(local_path)s,%(download_path)s, 'P')
        RETURNING t_download_job_id
    '''
    rows = []
    con = connect()
    return insert_execute(con, sql, data)

def select_download(data):
    print('select_download')
    sql = '''
        SELECT
            *
        FROM
            t_download_job
        WHERE
            t_download_job_id = %(t_download_job_id)s
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows

# ----------------------------------------------------------------
@app.route('/check_confirm_user', methods=['POST'])
def check_confirm_user():
    print('check_confirm_user')
    invitation_code = request.form.get('invitationcode')
    data_invitation = {}
    data_invitation['invitation_code'] = invitation_code

    return {
        "status": exist_invitationcode(data_invitation)
    }

@app.route('/check_activate_user', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def check_activate_user():
    print('check_activate_user')
    authorization = request.headers.get('Authorization')
    invitation_code = request.form.get('invitationcode')
    user_email = request.headers.get('email')
    data_invitation = {}
    data_invitation['invitation_code'] = invitation_code
    data_user = {}
    data_user['user_id'] = user_email
    data_confirm = {}
    data_confirm['invitation_user_id'] = select_user_by_user_id(data_user)['m_user_id']
    data_confirm['invitation_code'] = invitation_code

    return {
        "status": is_invitation_confirm(data_confirm),
        "target_user_email": select_user_by_invitation_code(data_invitation)['user_id']
    }

@app.route('/update_user', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def update_user():
    print('update_user')
    
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')
    update_user_email = request.form.get('update_user_id')
    update_method = request.form.get('update_method')
    if user_email == update_user_email:
        return {
            "status":"error",
            "error_reason":"ログインしているユーザー情報は変更できません。"
        }

    data = {}
    data['user_id'] = user_email
    data_company = {}
    data_company['m_company_id'] = select_company_by_user_id(data)['m_company_id']
    select_user_list_by_company_id(data_company)
    for user in select_user_list_by_company_id(data_company):
        if user['user_id'] == update_user_email:
            conn = http.client.HTTPSConnection(AUTH0_DOMAIN)
            headers = {
                'Content-Type': 'application/json',
                'authorization': ' Bearer ' + get_api_token_auth_header()
            }
            if update_method == 'DELETE':
                #削除
                request_url = "/api/v2/users/auth0|" + str(user['auth0_user_id'])
                conn.request("DELETE", request_url, None, headers)
                res = conn.getresponse()
                conn.close
                directory_update = {}
                directory_update['user_id'] = user['user_id']
                delete_directory_user_by_email(directory_update)
                data_delete = {}
                data_delete['delete_user_email'] = user['user_id']
                delete_user_by_email(data_delete)
                return {
                    "status":"success"
                }
            elif update_method == 'INVALID':
                #無効化
                request_url = "/api/v2/users/auth0|" + str(user['auth0_user_id'])
                print(request_url)
                payload = '''
                    {\r\n
                        \"blocked\":true\r\n
                    }'''
                conn.request("PATCH", request_url, payload, headers)
                res = conn.getresponse()
                conn.close
                return {
                    "status":"success"
                }
            elif update_method == 'VALID':
                #有効化
                request_url = "/api/v2/users/auth0|" + str(user['auth0_user_id'])
                payload = '''
                    {\r\n
                        \"blocked\":false\r\n
                    }'''
                conn.request("PATCH", request_url, payload, headers)
                res = conn.getresponse()
                conn.close        
                return {
                    "status":"success"
                }
    #存在しないユーザー、もしくは異なる企業のユーザー
    return {
        "status":"error",
        "error_reason":"ユーザーが存在しませんでした。"
    }

@app.route('/user_list', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def user_list():
    print('user_list')
    
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')
    data = {}
    data['user_id'] = user_email
    data_company = {}
    data_company['m_company_id'] = select_company_by_user_id(data)['m_company_id']
    userdata_array = []
    api_token = get_api_token_auth_header()
    for user in select_user_list_by_company_id(data_company):
        userdata = {}
        userdata['company_name'] = user['company_name']
        userdata['user_id'] = user['user_id']
        #last_login
        conn = http.client.HTTPSConnection(AUTH0_DOMAIN)
        headers = {
            'Content-Type': 'application/json',
            'authorization': ' Bearer ' + api_token
        }
        request_url = "/api/v2/users/auth0|" + str(user['auth0_user_id'])
        conn.request("GET", request_url, None, headers)
        res = conn.getresponse()
        userdata_reponse = json.load(res)
        #最終ログイン
        last_login = userdata_reponse.get("last_login")
        if str(last_login) == 'None':
            userdata['last_login'] = 'ログイン履歴なし'
        else:
            userdata['last_login'] = str(last_login).replace('T', ' ').replace('Z','')
        #有効化
        if not user['is_confirm']:
            userdata['is_invalid'] = True
        elif userdata_reponse.get("blocked") == None:
            userdata['is_invalid'] = False
        else:
            userdata['is_invalid'] = userdata_reponse.get("blocked")
        #招待登録
        if user['is_confirm'] == False:
            userdata['is_confirm'] = '招待中'
        elif user['is_confirm'] == True:
            userdata['is_confirm'] = '登録完了'
        userdata_array.append(userdata)
    return json.dumps(userdata_array)

@app.route('/user_auth', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
@permission(True)
def user_auth():
    return {
        "status":"success"
    }

# ----------------------------------------------------------------

@app.route('/solver_start', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def solver_start():
    user_id = ''
    user_email = ''
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')
    user_id = hashlib.sha256(user_email.encode()).hexdigest()

    data = {}
    data['username'] = user_email
    data['dat_path'] = PREFIX + user_id + '/' + request.form.get('s3_path')
    rows = select_solver_list_is_started(data)
    if len(rows) > 0:
        result = {
            'status': 1,
            'msg': '現在計算中のため計算実行できません。'
        }
        return json.dumps(result)

    job_command = ''
    if job_command != '':
        job_command = ' ' + request.form.get('job_command')
    request.form.get('job_command')
    Payload = json.dumps({'job_command': job_command, 's3_path': request.form.get('s3_path'), 'solver_type': request.form.get('solver_type'), 'project_id': request.form.get('project_id'), 'username': user_email})
    response = boto3.client('lambda').invoke(
        FunctionName='stg-lam-msc1-011-solver-start',
        InvocationType='Event',
        Payload=Payload
    )
    return 'Okay!'

# ----------------------------------------------------------------

@app.route('/solver_cancel', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def solver_cancel():
    # try:
    #     authorization = request.headers.get('Authorization')

    #     # Introspect Token
    #     token_info = keycloak_openid.introspect(authorization)

    #     if token_info['active']:
    #         user_id = token_info['sub']
    #     else:
    #         abort(401)
    # except Exception as e:
    #     abort(401)

    conn = http.client.HTTPSConnection("4d3jywy5hb.execute-api.ap-northeast-1.amazonaws.com")
    payload = '''
        {\r\n
            \"solverid\":\"''' + request.form.get('solverid') + '''\"\r\n
        }'''
    headers = {
    'x-api-key': 'iSL1N0wGGA1nCMgDleMJb72hUK3Xv2xT482U5f4h',
    'Content-Type': 'application / json'
    }
    conn.request("POST", "/stg_msc1/solver/cancel", payload, headers)
    res = conn.getresponse()
    data = res.read()
    print(data.decode("utf-8"))

    return 'Okay!'

# ----------------------------------------------------------------

@app.route('/solver_delete', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def solver_delete():
    user_email = ''
    
    user_email = request.headers.get('email')
    print('user_email================')
    print(user_email)

    t_solver_list_id = ''
    
    t_solver_list_id = request.form.get('t_solver_list_id')
    print('t_solver_list_id================')
    print(t_solver_list_id)

    data = {}
    data['t_solver_list_id'] = t_solver_list_id
    data['username'] = user_email
    rows = update_solver_list_flg_deleted(data)

    print(rows)

    return 'Okay!'

# ----------------------------------------------------------------
@app.route('/solver_list', methods=['GET'])
# @cross_origin(headers=["Content-Type", "Authorization"])
# @requires_auth
def solver_list():
    print('solver_list')

    user_email = ''
    
    user_email = request.headers.get('email')
    print('user_email================')
    print(user_email)

    data = {}
    data['username'] = user_email
    rows = select_solver_list(data)

    #project_file_path = 'D:/PhotonUser/Home Folder/'
    project_file_path = ''

    for row in rows:
        dat_path_org = row['dat_path']
        if row['product'] == 'simufact':
            # Simufact Formingの場合
            #・Simufact：プロジェクトファイル*.sfpの保存場所
            project_file_path = dat_path_org
            replace_str = project_file_path.split('/')[len(project_file_path.split('/'))-6] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-5] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-4] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-3] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-2] + '/' + project_file_path.split('/')[len(project_file_path.split('/'))-1]
            project_file_path = project_file_path.replace(replace_str, '')
        elif row['product'] == 'nastran' or row['product'] == 'marc' or row['product'] == 'cradle' or row['product'] == 'cradle_mesh':
            # Nastranの場合、Marcの場合、Cradleの場合
            #・Cradle：入力データ(scFLOWは*.gph, .*sph、STREAMは*.s)の保存場所
            #・Marc：入力データ(*.dat)の保存場所
            project_file_path = dat_path_org.replace(dat_path_org.split('/')[len(dat_path_org.split('/'))-1],'')
        #row['project_file_path'] = row['dat_path'].replace(row['dat_path'].split('/')[len(row['dat_path'].split('/'))-1])
        row['project_file_path'] = project_file_path

    return json.dumps(rows)

# ----------------------------------------------------------------

# ----------------------------------------------------------------
def exist_user_email(data):
    print('exist_user_email')
    sql = '''
        SELECT
            COUNT(*)
        FROM
            m_user 
        WHERE
            user_id = %(create_user_email)s
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows[0]['count'] >= 1

def exist_invitationcode(data):
    print('exist_invitationcode')
    sql = '''
        SELECT
            COUNT(*)
        FROM
            m_user 
        WHERE
            invitation_code = %(invitation_code)s
            AND
            is_confirm IS FALSE
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows[0]['count'] >= 1

def is_invitation_confirm(data):
    print('is_invitation_confirm')
    sql = '''
        SELECT
            COUNT(*)
        FROM
            m_user 
        WHERE
            invitation_code = %(invitation_code)s
            AND
            invitation_user_id = %(invitation_user_id)s
            AND
            is_confirm = true
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows[0]['count'] == 1

def select_user_list_by_company_id(data):
    print('select_user_list_by_company_id')
    sql = '''
        SELECT
            mu.user_id,
            mu.auth0_user_id,
            mu.is_confirm,
            company_name
        FROM
            m_user mu
        INNER JOIN
            m_company mc
            ON mc.m_company_id = mu.m_company_id 
        WHERE
            mc.m_company_id = %(m_company_id)s 
        ORDER BY
            m_user_id
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows

def select_user_by_user_id(data):
    print('select_user_by_user_id')
    print(data)
    sql = '''
        SELECT
            *
        FROM
            m_user
        WHERE
            user_id = %(user_id)s
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows[0]

def select_user_by_m_user_id(data):
    print('select_user_by_m_user_id')
    print(data)
    sql = '''
        SELECT
            *
        FROM
            m_user
        WHERE
            m_user_id = %(m_user_id)s
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows[0]

def select_user_by_invitation_code(data):
    print('select_user_by_invitation_code')
    print(data)
    sql = '''
        SELECT
            *
        FROM
            m_user
        WHERE
            invitation_code = %(invitation_code)s 
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    return rows[0]

def select_company_by_user_id(data):
    print('select_company_by_user_id')
    sql = '''
        SELECT
            mc.m_company_id AS m_company_id,
            mc.company_name AS company_name,
            mc.company_stack AS company_stack
        FROM
            m_user mu
        INNER JOIN
            m_company mc
            ON mc.m_company_id = mu.m_company_id 
        WHERE
            user_id = %(user_id)s 
    '''
    rows = []
    con = connect()
    rows = select_execute(con, sql, data)
    print(rows[0])
    return rows[0]

def delete_user_by_email(data):
    print('delete_user_by_email')
    con = connect()
    sql = '''
        DELETE FROM
            m_user
        WHERE
            user_id = %(delete_user_email)s
    '''
    update_execute(con, sql, data)
    con.close

def delete_directory_user_by_email(data):
    print('delete_directory_user_by_email')
    con = connect()
    sql = '''
        UPDATE 
            m_directory_user 
        SET
            m_user_id = NULL
        WHERE
            m_user_id = (SELECT m_user_id FROM m_user WHERE user_id = %(user_id)s)
    '''
    update_execute(con, sql, data)
    con.close

def update_directory_user_by_email(data):
    print('delete_user_by_email')
    con = connect()
    sql = '''
        UPDATE 
            m_directory_user 
        SET
            m_user_id = (SELECT m_user_id FROM m_user WHERE user_id = %(user_id)s)
        WHERE
            m_directory_user_id = (SELECT m_directory_user_id FROM m_directory_user WHERE m_user_id IS NULL LIMIT 1)
        RETURNING
            directory_username
    '''
    print('-------------------------------------------------')
    rows = update_execute_returning(con, sql, data)
    print('-------------------------------------------------')
    print(rows)
    con.close
    print(rows)
    return rows

def count_directory_user_by_company_id(data):
    print('delete_user_by_email')
    con = connect()
    sql = '''
        SELECT
            COUNT(*)
        FROM
            m_directory_user
        WHERE
            m_company_id = %(m_company_id)s
            AND
            m_user_id IS NULL
    '''
    rows = select_execute(con, sql, data)
    for row in rows:
        con.close
        return row['count']

def insert_user(data):
    print('insert_user')
    sql = '''
        INSERT INTO 
            m_user (user_id, auth0_user_id, m_company_id, is_manager, invitation_code, invitation_user_id) 
        VALUES
            (%(create_user_email)s,%(create_user_email)s,%(create_user_company_id)s,%(is_manager)s,%(create_user_invitation_code)s,%(create_user_invitation_user_id)s)
        RETURNING m_user_id
    '''
    rows = []
    con = connect()
    return insert_execute(con, sql, data)

def confirm_by_invitation_code(data):
    print('confirm_by_invitationcode')
    sql = '''
        UPDATE m_user
            SET is_confirm = true
        WHERE
            invitation_code = %(invitation_code)s
    '''
    rows = []
    con = connect()
    rows = update_execute(con, sql, data)
    return rows

def get_bridge_instance_id(username):
    print('get_bridge_instance_id')
    data = {}
    data['username'] = username
    con = connect()
    sql = '''
        SELECT
            mc.bridge_instance_id
        FROM
            m_company mc
        INNER JOIN
            m_user mu
            ON mu.m_company_id = mc.m_company_id
        WHERE
            mu.user_id = %(username)s
    '''
    rows = select_execute(con, sql, data)
    for row in rows:
        con.close
        return row['bridge_instance_id']

# ----------------------------------------------------------------

# ----------------------------------------------------------------
def select_solver_list_is_started(data):
    print('select_solver_list')
    sql = '''
        SELECT
            t_solver_list_id
        FROM
            t_solver_list 
        WHERE
            username = %(username)s 
            AND
            dat_path = %(dat_path)s
            AND
            ( status = '計算準備中' OR status = '計算中' )
        ORDER BY
            t_solver_list_id DESC
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
def select_solver_list(data):
    print('select_solver_list')
    sql = '''
        SELECT
            t_solver_list_id                                -- ソルバーリストID
            , username                                      -- ユーザー名
            , dat_filename                                  -- データファイル名
            , dat_path                                      -- データファイルパス(S3)
            , ecs_taskname                                  -- ECSタスク名
            , jobname AS jobname                            -- JOB名称
            , to_char(end_time::timestamp - start_time::timestamp, 'dd日 HH24:MI:SS.MS') AS calculation_time
            , to_char(start_time::timestamp, 'yyyy/mm/dd HH24:MI:SS') AS start_time -- ソルバー開始日時
            , to_char(end_time::timestamp, 'yyyy/mm/dd HH24:MI:SS') AS end_time -- ソルバー終了日時
            , status                                        -- ステータス
            , error_reason                                  -- error_reason
            , product                                       -- 
            , log_progress                                  -- ログから取得した進捗率
        FROM
            t_solver_list 
        WHERE
            username = %(username)s 
            AND
            flg_deleted = FALSE
        ORDER BY
            t_solver_list_id DESC
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

def select_solver_logdata(data):
    print('select_solver_logdata')
    sql = '''
        SELECT
            dat_path,
            product,
            jobname
        FROM
            t_solver_list
        WHERE
            t_solver_list_id = %(t_solver_list_id)s 
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_01：ユーザー、月ごとのAppStream2.0のアクセス履歴の使用時間(H)、使用回数
def select_app_event_01(data):
    print('select_app_event_01')
    sql = '''
        SELECT
            user_name                                       -- user_name
            , "year"                                        -- year
            , "month"                                       -- month
            , use_hour                                      -- use_hour
            , use_count                                     -- use_count
        FROM
            app_event_01
        WHERE
            user_name = %(user_name)s 
            AND
            "year" = %(year)s 
            AND
            "month" = %(month)s 
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_01：ユーザー、月ごとのAppStream2.0のアクセス履歴の使用時間(H)、使用回数
def select_app_event_01_all_user(data):
    print('select_app_event_01_all_user')
    sql = '''
        SELECT
            user_name                                       -- user_name
            , "year"                                        -- year
            , "month"                                       -- month
            , use_hour                                      -- use_hour
            , use_count                                     -- use_count
        FROM
            app_event_01
            INNER JOIN public.m_company 
                ON app_event_01.company_code = public.m_company.company_code 
            INNER JOIN public.m_user 
                ON public.m_user.m_company_id = public.m_company.m_company_id 
        WHERE
            "year" = %(year)s 
            AND
            "month" = %(month)s 
            AND 
            public.m_user.user_id = %(user_name)s
        ORDER BY
            user_name
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_02：企業(プロジェクトID)、月ごとのAppStream2.0のアクセス履歴の使用時間(H)、使用回数
def select_app_event_02(data):
    print('select_app_event_02')
    sql = '''
        SELECT
            app_event_02.company_code                                    -- company_code
            , app_event_02."year"                                        -- year
            , app_event_02."month"                                       -- month
            , app_event_02.use_hour                                      -- use_hour
            , app_event_02.use_count                                     -- use_count
        FROM
            app_event_02 
            INNER JOIN m_company 
                ON app_event_02.company_code = m_company.company_code 
            INNER JOIN m_user 
                ON m_company.m_company_id = m_user.m_company_id 
        WHERE
            m_user.user_id = %(user_name)s
            AND
            app_event_02."year" = %(year)s 
            AND
            app_event_02."month" = %(month)s 
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_03：ユーザー、月ごとのAppStream2.0で使用したアプリケーションの使用回数
def select_app_event_03(data):
    print('select_app_event_03')
    sql = '''
        SELECT
            user_name                                       -- user_name
            , "year"                                        -- year
            , "month"                                       -- month
            , application_name                              -- application_name
            , count                                         -- count
        FROM
            app_event_03
        WHERE
            user_name = %(user_name)s 
            AND
            "year" = %(year)s 
            AND
            "month" = %(month)s 
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_03：ユーザー、月ごとのAppStream2.0で使用したアプリケーションの使用回数
def select_app_event_03_all_user(data):
    print('select_app_event_03_all_user')
    sql = '''
        SELECT
            user_name                                       -- user_name
            , "year"                                        -- year
            , "month"                                       -- month
            , application_name                              -- application_name
            , count                                         -- count
        FROM
            app_event_03
            INNER JOIN public.m_user 
                ON app_event_03.user_name = public.m_user.user_id 
        WHERE
            "year" = %(year)s 
            AND
            "month" = %(month)s 
            AND 
            public.m_user.m_company_id = ( 
                SELECT
                    public.m_user.m_company_id 
                FROM
                    public.m_user 
                WHERE
                    public.m_user.user_id = %(user_name)s
            )
        ORDER BY
            user_name
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_04：企業(プロジェクトID)、月ごとのAppStream2.0で使用したアプリケーションの使用回数
def select_app_event_04(data):
    print('select_app_event_04')
    sql = '''
        SELECT
            app_event_04.company_code                                    -- company_code
            , app_event_04."year"                                        -- year
            , app_event_04."month"                                       -- month
            , app_event_04.application_name                              -- application_name
            , app_event_04.count                                         -- count
        FROM
            app_event_04
            INNER JOIN m_company 
                ON app_event_04.company_code = m_company.company_code 
            INNER JOIN m_user 
                ON m_company.m_company_id = m_user.m_company_id 
        WHERE
            m_user.user_id = %(user_name)s
            AND
            app_event_04."year" = %(year)s 
            AND
            app_event_04."month" = %(month)s 
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_05：シルバーの計算回数、合計時間
def select_app_event_05_01(data):
    print('select_app_event_05_01')
    sql = '''
        SELECT
            -- app_event_05.company_name                                    -- company_name
            app_event_05.company_code                                  -- company_code
            -- , app_event_05.username                                      -- username
            , app_event_05."year"                                        -- year
            , app_event_05."month"                                       -- month
            , app_event_05.product                                       -- product
            , app_event_05.count                                         -- count
            , app_event_05.duration_hour                                 -- duration_hour
        FROM
            app_event_05
            INNER JOIN m_company 
                ON app_event_05.company_code = m_company.company_code 
            INNER JOIN m_user 
                ON app_event_05.username = m_user.user_id
				AND m_company.m_company_id = m_user.m_company_id 
        WHERE
            m_user.user_id = %(user_name)s
            AND
            app_event_05."year" = %(year)s 
            AND
            app_event_05."month" = %(month)s 
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_05：シルバーの計算回数、合計時間
def select_app_event_05_01_all_user(data):
    print('select_app_event_05_01_all_user')
    sql = '''
        SELECT
            -- app_event_05.company_name                                    -- company_name
            app_event_05.company_code                                  -- company_code
            , app_event_05.username AS user_name                                    -- username
            , app_event_05."year"                                        -- year
            , app_event_05."month"                                       -- month
            , app_event_05.product                                       -- product
            , app_event_05.count                                         -- count
            , app_event_05.duration_hour                                 -- duration_hour
        FROM
            app_event_05
            INNER JOIN m_company 
                ON app_event_05.company_code = m_company.company_code 
            INNER JOIN m_user 
                -- ON app_event_05.username = m_user.user_id
				-- AND m_company.m_company_id = m_user.m_company_id
                ON m_company.m_company_id = m_user.m_company_id 
        WHERE
            app_event_05."year" = %(year)s 
            AND
            app_event_05."month" = %(month)s 
            AND 
            public.m_user.user_id = %(user_name)s
        ORDER BY
            user_name
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# app_event_05：シルバーの計算回数、合計時間
def select_app_event_05_02(data):
    print('select_app_event_05_02')
    sql = '''
        SELECT
            -- app_event_05.company_name                                    -- company_name
            app_event_05.company_code                                  -- company_code
            -- , app_event_05.username                                      -- username
            , app_event_05."year"                                        -- year
            , app_event_05."month"                                       -- month
            , app_event_05.product                                       -- product
            , SUM(app_event_05.count) AS count                                         -- count
            , SUM(app_event_05.duration_hour) AS duration_hour                                 -- duration_hour
        FROM
            app_event_05
            INNER JOIN m_company 
                ON app_event_05.company_code = m_company.company_code 
            INNER JOIN m_user 
                ON m_company.m_company_id = m_user.m_company_id
                AND 
                m_user.user_id = %(user_name)s
        WHERE
            app_event_05."year" = %(year)s 
            AND
            app_event_05."month" = %(month)s 
		GROUP BY 
            app_event_05.company_code                                  -- company_code
            , app_event_05."year"                                        -- year
            , app_event_05."month"                                       -- month
            , app_event_05.product                                       -- product
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
# 
def select_m_user_is_manager_true(data):
    print('select_m_user_is_manager_true')
    sql = '''
        SELECT
            is_manager
        FROM
            m_user
        WHERE
            user_id = %(user_name)s
            AND
            is_manager = True
    '''

    rows = []

    con = connect()

    rows = select_execute(con, sql, data)
    # print(rows)
    
    return rows

# ----------------------------------------------------------------
def update_solver_list_flg_deleted(data):
    print('update_solver_list_flg_deleted')
    sql = '''
        UPDATE
            t_solver_list
        SET
            flg_deleted = TRUE
        WHERE
            t_solver_list_id = %(t_solver_list_id)s 
            AND
            username = %(username)s 
            AND
            ( status = '計算完了' OR status = 'エラー' OR status = 'キャンセル' )
        RETURNING *
    '''

    rows = []

    con = connect()

    rows = update_execute(con, sql, data)
    print(rows)
    
    return rows

# ----------------------------------------------------------------
def connect():
    #con = psycopg2.connect("host=" + "eval-tmp-mscone-ssh-dc7231c5c60a319d.elb.ap-northeast-1.amazonaws.com" +
    con = psycopg2.connect("host=" + "18.177.195.4" +
    #con = psycopg2.connect("host=" + "localhost" +
                           " port=" + "5432" +
                           " dbname=" + "mscone" +
                           " user=" + "postgres" +
                           " password=" + "BBT2kni3mEGLjirqQ7jLbk3P")
                           #" password=" + "XyuCr8TtGB3pf8fGebiqmXBb")

    return con

# ----------------------------------------------------------------
def select_execute(con, sql, data = None):
    with con.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
        if data is None:
            cur.execute(sql)
        else:
            cur.execute(sql, data)
        results = cur.fetchall()
        rows = []
        
        for row in results:
            rows.append(dict(row))
    return rows

# ----------------------------------------------------------------
def insert_execute(con, sql, data):
    new_id = None

    with con.cursor() as cur:
        cur.execute(sql, data)
        new_id = cur.fetchone()[0]
    con.commit()
    return new_id

# ----------------------------------------------------------------
def update_execute(con, sql, data):
    with con.cursor() as cur:
        cur.execute(sql, data)
    con.commit()

def update_execute_returning(con, sql, data):
    rows = None
    with con.cursor() as cur:
        cur.execute(sql, data)
        rows = cur.fetchone()[0]
    con.commit()
    return rows

# ----------------------------------------------------------------
def decimal_default_proc(obj):
    if isinstance(obj, Decimal):
        return float(obj)
    raise TypeError


def lambda_handler(event, context):
    # TODO implement
    # return context.client_context.custom
    user_id = ''
    user_prefix = ''
    if context.client_context:
        if context.client_context.custom:
            if 'user_id' in context.client_context.custom:
                user_id = context.client_context.custom['user_id']
            if 'user_prefix' in context.client_context.custom:
                user_prefix = context.client_context.custom['user_prefix']                
    if user_id == '':
        return []
    
    prefix = PREFIX + user_id + '/'
    
    if user_prefix != '':
        prefix = prefix + user_prefix + '/'
    
    bucket = s3.Bucket(BUCKET_NAME)
    objs = bucket.meta.client.list_objects(Bucket=bucket.name, Prefix=prefix, Delimiter='/')
    # print(objs)
    # return json.dumps(objs)
    file_list = []
    if objs.get('Contents'):
        for o in objs.get('Contents'):
            # if o.get('Key') != objs.get('Prefix'):
            if o.get('Key') != prefix:
                file = {}
                # key = o.get('Key').replace(objs.get('Prefix'), '').replace('/', '')
                key = o.get('Key').replace(prefix, '').replace('/', '')
                size = o.get('Size')
                date = o.get('LastModified')
                file['name'] = key
                file['size'] = size
                file['date'] = str(date)
                file_list.append(file)

    folder_list = []
    if objs.get('CommonPrefixes'):
        for o in objs.get('CommonPrefixes'):
            folder = {}
            name = o.get('Prefix').replace(objs.get('Prefix'), '').replace('/', '')
            folder['name'] = name
            folder['size'] = ''
            folder['date'] = ''
            folder_list.append(folder)

    list = {}
    list['folders'] = folder_list
    list['files'] = file_list
    return json.dumps(list)
    
# ----------------------------------------------------------------
@app.route('/api/faqs', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def get_faqs():
    json_list = []
    keys = ('id', 'q', 'a') # 列数と要素数を一致させる

    # CSV ファイルの読み込み
    with open('faqs/mscone-faq.csv', 'r', encoding='utf-8') as f:
        rd = csv.DictReader(f, keys)
        next(rd)
        for row in rd:
            json_list.append(row)

    return json.dumps(json_list)

# ----------------------------------------------------------------
@app.route('/api/logs', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def get_logs():
    user_email = request.headers.get('email')
    target_logfilenames = []
    logs = []
    data = {}
    data['t_solver_list_id'] = request.args.get('t_solver_list_id')
    rows = select_solver_logdata(data)
    if rows[0]['product'] == 'simufact':
        target_logfilenames.append(rows[0]['jobname'] + '.sts')
        target_logfilenames.append(rows[0]['jobname'] + '.log')
        target_logfilenames.append(rows[0]['jobname'] + '.out')
    elif rows[0]['product'] == 'marc':
        target_logfilenames.append(rows[0]['jobname'] + '.out')
        target_logfilenames.append(rows[0]['jobname'] + '.sts')
        target_logfilenames.append(rows[0]['jobname'] + '_std.log')
    elif rows[0]['product'] == 'cradle' or rows[0]['product'] == 'cradle_mesh':
        target_logfilenames.append(rows[0]['jobname'] + '.l')
        target_logfilenames.append(rows[0]['jobname'] + '_std.log')
    for target_logfilename in target_logfilenames:
        print(target_logfilename)
        print(rows[0]['dat_path'].replace(rows[0]['dat_path'].split('/')[len(rows[0]['dat_path'].split('/'))-1],target_logfilename))
        #ls_command = "cat " + rows[0]['dat_path'].replace(rows[0]['dat_path'].split('/')[len(rows[0]['dat_path'].split('/'))-1],target_logfilename).replace('S:/', '/home/admin@appstream.msc/mnt/fsx-mscone/')
        ls_command = "cat " + rows[0]['dat_path'].replace(rows[0]['dat_path'].split('/')[len(rows[0]['dat_path'].split('/'))-1],target_logfilename).replace('S:/', '/home/admin@appstream.msc/mnt/fsx-mscone/').replace('\n', '')
        ssm = boto3.client('ssm')
        r = ssm.send_command(
                InstanceIds = [get_bridge_instance_id(user_email)],
                DocumentName = "AWS-RunShellScript",
                Parameters = {
                    "commands": [
                        ls_command
                    ]    
                },
                OutputS3Region='ap-northeast-1',
                OutputS3BucketName='mscone-apptream-s3-bucket-mscone',
                OutputS3KeyPrefix='ls',
            )
        command_id = r['Command']['CommandId']
        ls_output_key = 'ls/' + command_id + '/' + get_bridge_instance_id(user_email) + '/awsrunShellScript/0.awsrunShellScript/stdout'
        print(ls_output_key)
        for x in range(30):
            time.sleep(1)
            res = ssm.list_command_invocations(
                    CommandId = command_id,
                    Details = True
                )
            invocations = res['CommandInvocations']
            status = invocations[0]['Status']

            if status == "Success" or status == "Failed":
                ls_output = None
                try:
                    files = invocations[0]['CommandPlugins'][0]['Output']
                    s3 = boto3.resource('s3')
                    s3.Bucket('mscone-apptream-s3-bucket-mscone').download_file(Filename='/home/ec2-user/ls_logs/' + command_id, Key=ls_output_key)
                    #s3.Bucket('mscone-apptream-s3-bucket-mscone').download_file(Filename='C:\\Users\\NDES\\docker\\logs\\' + command_id, Key=ls_output_key)
                    #ls_output = open('C:\\Users\\NDES\\docker\\logs\\' + command_id, encoding='utf-8')
                    ls_output = open('/home/ec2-user/ls_logs/' + command_id, encoding='utf-8')
                    logdata = ls_output.read()
                    logs.append({'log_filename':target_logfilename,'log_text':logdata})
                except Exception as e:
                    print(e)
                    try:
                        ls_output = open('/home/ec2-user/ls_logs/' + command_id, encoding='Shift-JIS')
                        logdata = ls_output.read()
                        logs.append({'log_filename':target_logfilename,'log_text':logdata})
                    except Exception as e2:
                        pass
                finally:
                    if ls_output != None:
                        ls_output.close()
                break
    return json.dumps(logs)

# ----------------------------------------------------------------
@app.route('/api/news', methods=['GET'])
# @cross_origin(headers=["Content-Type", "Authorization"])
# @requires_auth
def get_news():
    json_list = []
    keys = ('id', 'q', 'a') # 列数と要素数を一致させる

    # CSV ファイルの読み込み
    with open('news/mscone-news.csv', 'r', encoding='utf-8') as f:
        rd = csv.DictReader(f, keys)
        next(rd)
        for row in rd:
            json_list.append(row)

    return json.dumps(json_list)

# ----------------------------------------------------------------
@app.route('/api/rename', methods=['POST'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def rename():
    print('rename')

    user_id = ''
    user_email = ''
    authorization = request.headers.get('Authorization')
    user_email = request.headers.get('email')
    old_name = request.form.get('old_name')
    new_name = request.form.get('new_name')

    if old_name.startswith("/"):
        old_name = old_name[1:]

    if new_name.startswith("/"):
        new_name = new_name[1:]

    old_name = '/home/admin@appstream.msc/mnt/fsx-mscone/' + old_name
    new_name = '/home/admin@appstream.msc/mnt/fsx-mscone/' + new_name

    #mv command
    ssm = boto3.client('ssm')
    ##Command投入
    check_command = 'find "' + new_name + '" | wc -l'
    r = ssm.send_command(
            InstanceIds = ['i-0fc7121e4bc3febab'],
            DocumentName = "AWS-RunShellScript",
            Parameters = {
                "commands": [
                    check_command
                ]    
            }
        )
    command_id = r['Command']['CommandId']
    for x in range(2000):
        time.sleep(3)
        res = ssm.list_command_invocations(
                CommandId = command_id,
                Details = True
            )
        invocations = res['CommandInvocations']
        status = invocations[0]['Status']

        if status == "Success" or status == "Failed":
            filecount = invocations[0]['CommandPlugins'][0]['Output'][0]
            print(filecount)
            if filecount == '0':
                rename_command = 'mv "' + old_name + '" "' + new_name + '"'
                r = ssm.send_command(
                        InstanceIds = ['i-0fc7121e4bc3febab'],
                        DocumentName = "AWS-RunShellScript",
                        Parameters = {
                            "commands": [
                                rename_command
                            ]    
                        }
                    )
                command_id = r['Command']['CommandId']
                for x in range(2000):
                    time.sleep(3)
                    res = ssm.list_command_invocations(
                            CommandId = command_id,
                            Details = True
                        )
                    invocations = res['CommandInvocations']
                    status = invocations[0]['Status']

                    if status == "Success" or status == "Failed":
                        res = {
                            'status': 'ok',
                            'msg': ''
                        }
                        return json.dumps(res)
            else:
                res = {
                    'status': 'ng',
                    'msg': '新しい名称のフォルダ或いはファイルはすでに存在します。'
                }
                return json.dumps(res)
    """
    s3_client = boto3.client('s3')
    if check_s3_key_exists(s3_client, BUCKET_NAME, new_name):
        res = {
            'status': 'ng',
            'msg': '新しい名称のフォルダ或いはファイルはすでに存在します。'
        }
        return json.dumps(res)

    copy_all_keys_v2(s3_client, BUCKET_NAME, old_name, BUCKET_NAME, new_name)

    s3_resource = boto3.resource('s3')
    bucket = s3_resource.Bucket(BUCKET_NAME)
    bucket.objects.filter(Prefix=old_name).delete()

    res = {
        'status': 'ok',
        'msg': ''
    }
    return json.dumps(res)
    """

def copy_all_keys_v2(s3_client=None, source_bucket='', source_prefix='', target_bucket='', target_prefix='', dryrun=False):

    contents_count = 0
    next_token = ''

    while True:
        if next_token == '':
            response = s3_client.list_objects_v2(Bucket=source_bucket, Prefix=source_prefix)
        else:
            response = s3_client.list_objects_v2(Bucket=source_bucket, Prefix=source_prefix, ContinuationToken=next_token)

        if 'Contents' in response:
            contents = response['Contents']
            contents_count = contents_count + len(contents)
        for content in contents:
            relative_prefix = re.sub('^' + source_prefix, '', content['Key'])
            if not dryrun:
                print('Copying: s3://' + source_bucket + '/' + content['Key'])
                print('To s3://' + target_bucket + '/' + target_prefix + relative_prefix)
                s3_client.copy_object(Bucket=target_bucket, Key=target_prefix + relative_prefix, CopySource={'Bucket': source_bucket, 'Key': content['Key']})
            else:
                print('DryRun: s3://' + source_bucket + '/' + content['Key'])
                print('To s3://' + target_bucket + '/' + target_prefix + relative_prefix)

        if 'NextContinuationToken' in response:
            next_token = response['NextContinuationToken']
        else:
            break

    print(contents_count)

from botocore.errorfactory import ClientError

def check_s3_key_exists(s3_client, bucket_name, key):
    try:
        s3_client.head_object(Bucket=bucket_name, Key=key)
        return True
    except ClientError:
        return False

def pass_generator(size=12):
   chars = string.ascii_uppercase + string.ascii_lowercase + string.digits
   #chars += ''
   return ''.join(secrets.choice(chars) for x in range(size))

def sendmail(to_address, title, text, html):

    msg = MIMEMultipart('alternative')
    msg['Subject'] = title
    msg['From'] = FROM_ADDRESS
    msg['To'] = to_address
    msg.attach(MIMEText(text, 'plain'))
    msg.attach(MIMEText(html, 'html'))

    context = ssl.create_default_context()
    server = smtplib.SMTP_SSL(SMPTSERVER, 465, context=context)
    server.login(ACCOUNT, PASSWORD)
    server.sendmail(FROM_ADDRESS, to_address, msg.as_string())
    server.quit()

# ----------------------------------------------------------------
@app.route('/api/app_event', methods=['GET'])
@cross_origin(headers=["Content-Type", "Authorization"])
@requires_auth
def get_app_event():
    user_email = request.headers.get('email')

    APPLICATION = ['SimufactForming', 'Cradle', 'Marc/Mentat']
    PRODUCT = ['simufact', 'cradle', 'nastran', 'marc']

    is_data_ok = True

    data = {}

    data['user_name'] = user_email

    rows_m_user = []  
    rows_m_user = select_m_user_is_manager_true(data)
    is_manager = False
    if len(rows_m_user) > 0:
        is_manager = True

    year = request.args.get('year')
    if year is not None:
        data['year'] = year
    else:
        is_data_ok = False

    month = request.args.get('month')
    if month is not None:
        data['month'] = month
    else:
        is_data_ok = False

    rows_1 = None
    rows_1_all_user = None
    rows_2 = []
    rows_3 = None
    rows_3_all_user = None
    rows_4 = []
    rows_5_1 = None
    rows_5_1_all_user = None
    rows_5_2 = []

    if is_data_ok:
        
        if is_manager:
            rows_1_all_user = select_app_event_01_all_user(data)
        else:
            rows_1 = select_app_event_01(data)
            
        rows_2 = select_app_event_02(data)
        
        if is_manager:
            rows_3_all_user = select_app_event_03_all_user(data)
        else:
            rows_3 = select_app_event_03(data)

        rows_4 = select_app_event_04(data)
        
        if is_manager:
            rows_5_1_all_user = select_app_event_05_01_all_user(data)
        else:
            rows_5_1 = select_app_event_05_01(data)

        rows_5_2 = select_app_event_05_02(data)

    rows = {}

    if not is_manager:
        if len(rows_1) < 1:
            row = {}
            row['user_name'] = user_email
            row['year'] = year
            row['month'] = month
            row['use_hour'] = 0
            row['use_count'] = 0
            rows_1.append(row)
    rows['rows_1'] = rows_1

    if is_manager:
        if len(rows_1_all_user) < 1:
            row = {}
            row['user_name'] = ''
            row['year'] = year
            row['month'] = month
            row['use_hour'] = 0
            row['use_count'] = 0
            rows_1_all_user.append(row)
    rows['rows_1_all_user'] = rows_1_all_user

    if len(rows_2) < 1:
        row = {}
        row['company_code'] = ''
        row['year'] = year
        row['month'] = month
        row['use_hour'] = 0
        row['use_count'] = 0
        rows_2.append(row)
    rows['rows_2'] = rows_2

    if not is_manager:
        if len(rows_3) < 1:
            for item in APPLICATION:
                row = {}
                row['user_name'] = user_email
                row['year'] = year
                row['month'] = month
                row['application_name'] = item
                row['count'] = 0
                rows_3.append(row)
        else:
            tmp = []
            for item in APPLICATION:
                item_exists = False
                for row in rows_3:
                    if item == row['application_name']:
                        tmp.append(row)
                        item_exists = True
                        break
                if not item_exists:
                    row = {}
                    row['user_name'] = user_email
                    row['year'] = year
                    row['month'] = month
                    row['application_name'] = item
                    row['count'] = 0
                    tmp.append(row)
            rows_3 = tmp
    rows['rows_3'] = rows_3

    if is_manager:
        if len(rows_3_all_user) < 1:
            tmp_user = {}
            tmp = []
            for item in APPLICATION:
                row = {}
                row['user_name'] = ''
                row['year'] = year
                row['month'] = month
                row['application_name'] = item
                row['count'] = 0
                tmp.append(row)
            tmp_user[''] = tmp
            rows_3_all_user = tmp_user
        else:
            tmp_user = {}
            for row1 in rows_3_all_user:
                user_name = row1['user_name']
                if not user_name in tmp_user.keys():
                    tmp = []
                    for item in APPLICATION:
                        item_exists = False
                        for row in rows_3_all_user:
                            if item == row['application_name'] and user_name == row['user_name']:
                                tmp.append(row)
                                item_exists = True
                                break
                        if not item_exists:
                            row = {}
                            row['user_name'] = user_name
                            row['year'] = year
                            row['month'] = month
                            row['application_name'] = item
                            row['count'] = 0
                            tmp.append(row)
                    tmp_user[user_name] = tmp
            rows_3_all_user = tmp_user
    rows['rows_3_all_user'] = rows_3_all_user

    if len(rows_4) < 1:
        for item in APPLICATION:
            row = {}
            row['user_name'] = user_email
            row['year'] = year
            row['month'] = month
            row['application_name'] = item
            row['count'] = 0
            rows_4.append(row)
    else:
        tmp = []
        for item in APPLICATION:
            item_exists = False
            for row in rows_4:
                if item == row['application_name']:
                    tmp.append(row)
                    item_exists = True
                    break
            if not item_exists:
                row = {}
                row['user_name'] = user_email
                row['year'] = year
                row['month'] = month
                row['application_name'] = item
                row['count'] = 0
                tmp.append(row)
        rows_4 = tmp
    rows['rows_4'] = rows_4

    if not is_manager:
        if len(rows_5_1) < 1:
            for item in PRODUCT:
                row = {}
                row['company_code'] = ''
                row['year'] = year
                row['month'] = month
                row['product'] = item
                row['count'] = 0
                row['duration_hour'] = 0
                rows_5_1.append(row)
        else:
            tmp = []
            for item in PRODUCT:
                item_exists = False
                for row in rows_5_1:
                    if item == row['product']:
                        tmp.append(row)
                        item_exists = True
                        break
                if not item_exists:
                    row = {}
                    row['company_code'] = ''
                    row['year'] = year
                    row['month'] = month
                    row['product'] = item
                    row['count'] = 0
                    row['duration_hour'] = 0
                    tmp.append(row)
            rows_5_1 = tmp
    rows['rows_5_1'] = rows_5_1
    
    if is_manager:
        if len(rows_5_1_all_user) < 1:
            tmp_user = {}
            tmp = []
            for item in PRODUCT:
                row = {}
                row['company_code'] = ''
                row['year'] = year
                row['month'] = month
                row['product'] = item
                row['count'] = 0
                row['duration_hour'] = 0
                tmp.append(row)
            tmp_user[''] = tmp
            rows_5_1_all_user = tmp_user
        else:
            tmp_user = {}
            for row1 in rows_5_1_all_user:
                user_name = row1['user_name']
                if not user_name in tmp_user.keys():
                    tmp = []
                    for item in PRODUCT:
                        item_exists = False
                        for row in rows_5_1_all_user:
                            if item == row['product'] and user_name == row['user_name']:
                                tmp.append(row)
                                item_exists = True
                                break
                        if not item_exists:
                            row = {}
                            row['company_code'] = ''
                            row['year'] = year
                            row['month'] = month
                            row['product'] = item
                            row['count'] = 0
                            row['duration_hour'] = 0
                            tmp.append(row)
                    tmp_user[user_name] = tmp
            rows_5_1_all_user = tmp_user
    rows['rows_5_1_all_user'] = rows_5_1_all_user

    if len(rows_5_2) < 1:
        for item in PRODUCT:
            row = {}
            row['company_code'] = ''
            row['year'] = year
            row['month'] = month
            row['product'] = item
            row['count'] = 0
            row['duration_hour'] = 0
            rows_5_2.append(row)
    else:
        tmp = []
        for item in PRODUCT:
            item_exists = False
            for row in rows_5_2:
                if item == row['product']:
                    tmp.append(row)
                    item_exists = True
                    break
            if not item_exists:
                row = {}
                row['company_code'] = ''
                row['year'] = year
                row['month'] = month
                row['product'] = item
                row['count'] = 0
                row['duration_hour'] = 0
                tmp.append(row)
        rows_5_2 = tmp
    rows['rows_5_2'] = rows_5_2

    print(rows)

    return json.dumps(rows, default=decimal_default_proc)

# ----------------------------------------------------------------
if __name__ == '__main__':
    # if not os.path.exists(UPLOAD_FOLDER):
    #     os.mkdir(UPLOAD_FOLDER)
    now = datetime.datetime.now()
    b2d = now - datetime.timedelta(days=2)
    b2d_folder = '/tmp/' + b2d.strftime("%Y%m%d")
    if os.path.exists(b2d_folder):
        shutil.rmtree(b2d_folder)

    # get_user_hash_id()

    certfile = os.path.dirname(__file__) + '/openssl/server.crt'
    keyfile = os.path.dirname(__file__) + '/openssl/server.key'
    # app.run(debug=True, host='0.0.0.0', port='5556')
    app.run(host='0.0.0.0', port='5556',ssl_context=(certfile, keyfile), threaded=True, debug=True)
