import requests
import json
import os
import inspect
from array import array

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

import global_value as GV

RESPONSE_HEADERS = GV.RESPONSE_HEADERS

from error_function import error_handling

# 設定ファイル
import boto3
# BUCKET_NAME = 'env-mcl-mgmt'
# PATH_NAME = 'user-infrastructure/'
# OBJECT_KEY_NAME = 'config.json'
s3 = boto3.resource('s3')

def lambda_handler(event, context):
    
    try:
        logger.info(event)

        event_body = {}
        # テスト
        # event_body = event
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)

        if event['stageVariables']['env'] is None:
            res = {}
            res['error_code'] = ''
            res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
            return {
                'statusCode': 500,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res)
                'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
            }
        
        GV.ENV = event['stageVariables']['env'].upper()
        logger.info(GV.ENV)

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/'
        OBJECT_KEY_NAME = 'config.json'

        bucket = s3.Bucket(BUCKET_NAME)
        obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)

        response = obj.get()
        body = response['Body'].read()
        ENV_CONFIG = json.loads(body.decode('utf-8'))
        # S3 PAYMENT0
        GV.PAYMENT0_AUTHENTICATIONID = ''
        GV.PAYMENT0_AUTHENTICATIONID = ENV_CONFIG[GV.ENV]['PAYMENT0'][GV.ENV + '_' + 'PAYMENT_AUTHENTICATIONID']
        GV.PAYMENT0_CONNECTPASSWORD = ''
        GV.PAYMENT0_CONNECTPASSWORD = ENV_CONFIG[GV.ENV]['PAYMENT0'][GV.ENV + '_' + 'PAYMENT_CONNECTPASSWORD']
        GV.PAYMENT0_GMOURL = ''
        GV.PAYMENT0_GMOURL = ENV_CONFIG[GV.ENV]['PAYMENT0'][GV.ENV + '_' + 'PAYMENT_GMOURL']
        GV.PAYMENT0_SHOPCODE = ''
        GV.PAYMENT0_SHOPCODE = ENV_CONFIG[GV.ENV]['PAYMENT0'][GV.ENV + '_' + 'PAYMENT_SHOPCODE']
        # S3 PAYMENT1
        GV.PAYMENT1_AUTHENTICATIONID = ''
        GV.PAYMENT1_AUTHENTICATIONID = ENV_CONFIG[GV.ENV]['PAYMENT1'][GV.ENV + '_' + 'PAYMENT_AUTHENTICATIONID']
        GV.PAYMENT1_CONNECTPASSWORD = ''
        GV.PAYMENT1_CONNECTPASSWORD = ENV_CONFIG[GV.ENV]['PAYMENT1'][GV.ENV + '_' + 'PAYMENT_CONNECTPASSWORD']
        GV.PAYMENT1_GMOURL = ''
        GV.PAYMENT1_GMOURL = ENV_CONFIG[GV.ENV]['PAYMENT1'][GV.ENV + '_' + 'PAYMENT_GMOURL']
        GV.PAYMENT1_SHOPCODE = ''
        GV.PAYMENT1_SHOPCODE = ENV_CONFIG[GV.ENV]['PAYMENT1'][GV.ENV + '_' + 'PAYMENT_SHOPCODE']
        
        res = {}

        if event['httpMethod'] == 'POST':
            if event['path'] == '/payment/creditfacility_registerbuyer': #削除予定
                # 購入企業登録API
                res = payment_creditfacility_registerbuyer_post(event, context)
            elif event['path'] == '/payment/creditfacility/registerbuyer':
                # 購入企業登録API
                res = payment_creditfacility_registerbuyer_post(event, context)
            elif event['path'] == '/payment/creditfacility/modifybuyer':
                # 購入企業変更API
                res = payment_creditfacility_modifybuyer_post(event, context)
            elif event['path'] == '/payment/creditfacility_getbuyercreditfacility': #削除予定
                # 枠保証状況取得API
                res = payment_creditfacility_getbuyercreditfacility_post(event, context)
            elif event['path'] == '/payment/creditfacility/getbuyercreditfacility':
                # 枠保証状況取得API
                res = payment_creditfacility_getbuyercreditfacility_post(event, context)
            elif event['path'] == '/payment/transaction':
                # 取引登録API
                res = payment_transaction_post(event, context)
            elif event['path'] == '/payment/fixrequest':
                # 請求確定API
                res = payment_fixrequest_post(event, context)
            elif event['path'] == '/payment/creditfacility_getbuyercreditfacility_status': #削除予定
                # 枠保証状況ステータス取得API
                res = payment_creditfacility_getbuyercreditfacility_status_post(event, context)
            elif event['path'] == '/payment/creditfacility/getbuyercreditfacility/status':
                # 枠保証状況ステータス取得API
                res = payment_creditfacility_getbuyercreditfacility_status_post(event, context)
            else:
                if 'api_name' in event_body:
                    if event_body['api_name'] == 'payment_creditfacility_registerbuyer':
                        # 購入企業登録API
                        res = payment_creditfacility_registerbuyer_post(event, context)
                    if event_body['api_name'] == 'payment_creditfacility_modifybuyer':
                        # 購入企業変更API
                        res = payment_creditfacility_modifybuyer_post(event, context)
                    if event_body['api_name'] == 'payment_creditfacility_getbuyercreditfacility':
                        # 枠保証状況取得API
                        res = payment_creditfacility_getbuyercreditfacility_post(event, context)
                    if event_body['api_name'] == 'payment_transaction':
                        # 取引登録API
                        res = payment_transaction_post(event, context)
                    if event_body['api_name'] == 'payment_fixrequest':
                        # 請求確定API
                        res = payment_fixrequest_post(event, context)
                    if event_body['api_name'] == 'payment_creditfacility_getbuyercreditfacility_status':
                        # 枠保証状況ステータス取得API
                        res = payment_creditfacility_getbuyercreditfacility_status_post(event, context)

        logger.info(res)

        return res
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

#  認証情報のエラー
error_payment_usercheck_post = {
    'SP0001': '認証 ID が未入力です。',
    'SP0002': ' 認証 ID の文字数が異なります。',
    'SP0003': ' 認証 ID の値が不正です。',
    'SP0004': '加盟店コードが未入力です。 ',
    'SP0005': '加盟店コードの文字数が異なります。',
    'SP0006': '加盟店コードの値が不正です。',
    'SP0007': '接続パスワードが未入力です。',
    'SP0008': '接続パスワードの文字数が異なります。',
    'SP0009': '接続パスワードの値が不正です。',
    'SP0010': '加盟店認証に失敗しました。',
    'SP0011': '取引登録不可です。',
    'SP0012': '与信審査結果取得不可です。',
    'SP0013': '請求確定不可です。',
    'SP0014': '取引修正・キャンセル不可です。',
    'SP0015': '取引更新種別が未入力です。',
    'SP0016': '取引更新種別の文字数が異なります。',
    'SP0017': '取引更新種別の値が不正です。',
    'SP0018': '請求確定修正・キャンセル不可です。',
    'SP0019': '請求減額不可です。',
    'SP0044': '一定期間内に規定回数を超えたため、APIがロックされました。APIのロックを解除するには support_kb@gmo-ps.comにお問い合わせください。',
    'SP0045': 'APIがロックされています。APIのロックを解除するにはsupport_kb@gmo-ps.comにお問い合わせください。'
}

# 購入企業情報のエラー
error_payment_creditfacility_post = {
    'CT0001': '加盟店取引 ID が未入力です。',
    'CT0002': '加盟店取引 ID の文字数が異なります。',
    'CT0003': '加盟店取引 ID の値が不正です。',
    'CT0004': '注文日が未入力です。',
    'CT0005': '注文日の文字数が異なります。',
    'CT0006': '注文日の値が不正です。 ',
    'CT0007': '購入企業情報の氏名（漢字）が未入力です。',
    'CT0008': '購入企業情報の氏名（漢字）の文字数が異なります。',
    'CT0009': '購入企業情報の氏名（漢字）の値が不正です。',
    'CT0010': '購入企業情報の氏名（カナ）の文字数が異なります。',
    'CT0011': '購入企業情報の氏名（カナ）の値が不正です。',
    'CT0012': '購入企業情報の郵便番号が未入力です。',
    'CT0013': '購入企業情報の郵便番号の文字数が異なります。',
    'CT0014': '購入企業情報の郵便番号の値が不正です。',
    'CT0015': '購入企業情報の住所が未入力です。',
    'CT0016': '購入企業情報の住所の文字数が異なります。',
    'CT0017': '購入企業情報の住所の値が不正です。',
    'CT0018': '購入企業情報の企業名の文字数が異なります。',
    'CT0019': '購入企業情報の企業名の値が不正です。',
    'CT0020': '購入企業情報の部署名の文字数が異なります。',
    'CT0021': '購入企業情報の部署名の値が不正です。',
    'CT0022': '購入企業情報の電話番号1が未入力です。',
    'CT0023': '購入企業情報の電話番号 1の文字数が異なります。',
    'CT0024': '購入企業情報の電話番号 1の値が不正です。',
    'CT0025': '購入企業情報の電話番号 2の文字数が異なります。',
    'CT0026': '購入企業情報の電話番号 2の値が不正です。',
    'CT0027': '購入企業情報のメールアドレス 1 の文字数が異なります。',
    'CT0028': '購入企業情報のメールアドレス 1 の値が不正です。',
    'CT0029': '購入企業情報のメールアドレス 2 の文字数が異なります。',
    'CT0030': '購入企業情報のメールアドレス 2 の値が不正です。',
    'CT0031': '顧客請求額が未入力です。 ',
    'CT0032': '顧客請求額の文字数が異なります。',
    'CT0033': '顧客請求額の値が不正です。 ',
    'CT0034': '決済種別が未入力です。 ',
    'CT0035': '決済種別の値が不正です。',
    'CT0036': 'GMO 取引 ID が未入力です。', 
    'CT0037': 'GMO 取引 ID の文字数が異なります。',
    'CT0038': 'GMO 取引 ID のデータ型が異なります。',
    'CT0039': '該当の GMO 取引 ID が存在しません。',
    'CT0040': '運送会社コードが未入力です。',
    'CT0041': '運送会社コードの文字数が異なります。',
    'CT0042': '運送会社コードのデータ型が異なります。',
    'CT0043': '利用できない運送会社コードです。',
    'CT0044': '配送伝票番号が未入力です。',
    'CT0045': '配送伝票番号の文字数が異なります。',
    'CT0046': '配送伝票番号のデータ型が異なります。',
    'CT0047': '購入企業情報の郵便番号と住所が一致しません。',
    'CT0048': '請求書発行日の値が不正です。',
    'CT0050': '請求書発行日が請求書印字データ取得日以前です。',
    'CT0051': '1ヶ月内に登録された配送伝票番号は登録できません。',
    'CT0053': '登録不可能な決済種別です。 ',
    'CT0055': '決済種別の文字数が異なります。',
    'CT0056': '請求書発行日の修正ができません。',
    'CT0057': '購入企業情報の丁番地または建造物名／号室等を入力してください。',
    'CT0059': '性別の文字数が異なります。 ',
    'CT0060': '性別の値が不正です。',
    'CT0061': '誕生日の文字数が異なります。',
    'CT0062': '誕生日の値が不正です。 ',
    'CT0063': '会員登録日の文字数が異なります。',
    'CT0064': '会員登録日の値が不正です。 ',
    'CT0065': '購入回数の文字数が異なります。',
    'CT0066': '購入回数の値が不正です。 ',
    'CT0075': '購入金額総額の文字数が異なります。',
    'CT0076': '購入金額総額の値が不正です。',
    'CT0077': '会員 ID の文字数が異なります。',
    'CT0078': '会員 ID の値が不正です。 ',
    'CT0082': '購入企業情報の企業名が未入力です。',
    'BCT0001': '購入企業情報の担当者姓（漢字）が未入力です。',
    'BCT0002': '購入企業情報の担当者姓（漢字）の文字数が異なります。',
    'BCT0003': '購入企業情報の担当者姓（漢字）の値が不正です。',
    'BCT0004': '購入企業情報の担当者名（漢字）が未入力です。',
    'BCT0005': '購入企業情報の担当者名（漢字）の値が不正です。',
    'BCT0006': '購入企業情報の担当者姓（カナ）の文字数が異なります。',
    'BCT0007': '購入企業情報の担当者姓（カナ）の値が不正です。',
    'BCT0008': '購入企業情報の担当者名（カナ）の値が不正です。',
    'BCT0009': '購入企業情報の企業名が未入力です。',
    'BCT0010': '購入企業情報のメールアドレス１が未入力です。',
    'BCT0011': '購入企業情報の代表者姓（漢字）が未入力です。',
    'BCT0012': '購入企業情報の代表者姓（漢字）の文字数が異なります。',
    'BCT0013': '購入企業情報の代表者姓（漢字）の値が不正です。',
    'BCT0014': '購入企業情報の代表者名（漢字）が未入力です。',
    'BCT0015': '購入企業情報の代表者名（漢字）の値が不正です。',
    'BCT0016': '購入企業情報の代表者姓（カナ）の文字数が異なります。',
    'BCT0017': '購入企業情報の代表者姓（カナ）の値が不正です。',
    'BCT0018': '購入企業情報の代表者名（カナ）の値が不正です。',
    'BCT0019': '購入企業情報の購入回数の文字数が異なります。',
    'BCT0020': '購入企業情報の購入回数の値が不正です。',
    'BCT0021': '購入企業情報の購入企業 IDが未入力です。',
    'BCT0022': '購入企業情報の購入企業 IDの文字数が異なります。',
    'BCT0023': '購入企業情報の購入企業 IDの値が不正です。',
    'BCT0024': '購入企業情報の代表者氏名（漢字）の文字数が異なります。',
    'BCT0025': '購入企業情報の代表者氏名（カナ）の文字数が異なります。',
    'BCT0029': '誕生日が未入力です。 ',
    'BCT0030': '与信枠が設定されている、或いは枠保証ステータスが審査中・保留の購入企業に対して属性を変更することは出来ません。',
    'BCT0031': '枠保証ステータスが利用不可のため取引登録できません。',
    'BCT0032': '枠保証ステータスが利用不可のため取引修正できません。',
    'BCT0033': '購入企業 ID が重複しています。',
    'BCT0034': '購入企業が見つかりません。',
    'BCT0035': '法人番号の文字数が異なります。',
    'BCT0036': '法人番号の値が不正です。 ',
    'BCT0037': '購入企業情報の代表者姓（カナ）が未入力です。',
	'BCT0038': '購入企業情報の代表者名（カナ）が未入力です。',
	'BCT0039': '購入企業情報の希望上限金額が未入力です。',
	'BCT0040': '取引情報の請求確定日が未入力です。'
}

# 購入企業情報新規（枠保証用）API
def payment_creditfacility_registerbuyer_post(event, context, cim_app_info = None, event_body = None):
    
    logger.info('payment_creditfacility_registerbuyer_post!!!')
    
    try:
        if event_body is None:
            event_body = {}
            event_body = json.loads(event['body'])
            # テスト
            # event_body = event

        # url = GV.PAYMENT0_GMOURL + 'creditfacility/registerbuyer'
        
        # # 環境変数の読み込み
        # authenticationId = GV.PAYMENT0_AUTHENTICATIONID
        # shopCode = GV.PAYMENT0_SHOPCODE
        # connectPassword = GV.PAYMENT0_CONNECTPASSWORD

        url = GV.PAYMENT1_GMOURL + 'creditfacility/registerbuyer'
        
        # 6708----------10/16----------S
        # 環境変数の読み込み
        relatedData = None
        relatedData = get_value('relatedData', event_body)
        
        if relatedData is not None:
            authenticationIdData = None
            authenticationIdData = get_value('authenticationId', event_body['relatedData'])
            if authenticationIdData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            shopCodeData = None
            shopCodeData = get_value('shopCode', event_body['relatedData'])
            if shopCodeData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            connectPasswordData = None
            connectPasswordData = get_value('connectPassword', event_body['relatedData'])
            if connectPasswordData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            authenticationId = authenticationIdData
            shopCode = shopCodeData
            connectPassword = connectPasswordData
        else:
            authenticationId = GV.PAYMENT1_AUTHENTICATIONID
            shopCode = GV.PAYMENT1_SHOPCODE
            connectPassword = GV.PAYMENT1_CONNECTPASSWORD

        logger.info('GMO認証データのチェック!!!')
        logger.info(authenticationId)
        logger.info(shopCode)
        logger.info(connectPassword)
        # 6708----------10/16----------E
        
        # データのチェック
        errArr = []
        errBody = {
            "result" : "NG",
            "errors" : errArr
        }
        # 購入企業情報
        buyer = None
        buyer = get_value('buyer', event_body)
        
        if buyer is None:
            return error_400('「購入企業情報 」を指定してください。')
            
        # 購入企業情報
        creditFacility = None
        creditFacility = get_value('creditFacility', event_body)
        
        if creditFacility is None:
            return error_400('「枠保証情報」を指定してください。')
            
        # 必須
        # 担当者姓（漢字）
        buyerNameFamily = None
        buyerNameFamily = get_value('buyerNameFamily', event_body['buyer'])
        if buyerNameFamily is None:
            res = {}
            res['errCode'] = 'BCT0001'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0001']
            errArr.append(res)
        # 担当者名（漢字） 
        buyerName = None
        buyerName = get_value('buyerName', event_body['buyer'])
        if buyerName is None:
            res = {}
            res['errCode'] = 'BCT0004'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0004']
            errArr.append(res)
        # 郵便番号  
        zipCode = None
        zipCode = get_value('zipCode', event_body['buyer'])
        if zipCode is None:
            res = {}
            res['errCode'] = 'CT0012'
            res['errorMessage'] = error_payment_creditfacility_post['CT0012']
            errArr.append(res)
        # 住所 
        address = None
        address = get_value('address', event_body['buyer'])
        if address is None:
            res = {}
            res['errCode'] = 'CT0015'
            res['errorMessage'] = error_payment_creditfacility_post['CT0015']
            errArr.append(res)
        # 企業名  
        companyName = None
        companyName = get_value('companyName', event_body['buyer'])
        if companyName is None:
            res = {}
            res['errCode'] = 'BCT0009'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0009']
            errArr.append(res)
        # 電話番号１
        tel1 = None
        tel1 = get_value('tel1', event_body['buyer'])
        if tel1 is None:
            res = {}
            res['errCode'] = 'CT0022'
            res['errorMessage'] = error_payment_creditfacility_post['CT0022']
            errArr.append(res)
        # メールアドレス１
        email1 = None
        email1 = get_value('email1', event_body['buyer'])
        if email1 is None:
            res = {}
            res['errCode'] = 'BCT0010'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0010']
            errArr.append(res)
        # 購入企業 ID
        shopCustomerId = None
        shopCustomerId = get_value('shopCustomerId', event_body['buyer'])
        if shopCustomerId is None:
            res = {}
            res['errCode'] = 'BCT0021'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
            errArr.append(res)
        # カケバライ
        buyerNameFamilyKana = None
        if 'buyerNameFamilyKana' in event_body['buyer'] :
            buyerNameFamilyKana = event_body['buyer']['buyerNameFamilyKana']
        # タロウ
        buyerNameKana = None
        if 'buyerNameKana' in event_body['buyer'] :
            buyerNameKana = event_body['buyer']['buyerNameKana']
        # サンプル部
        departmentName = None
        if 'departmentName' in event_body['buyer'] :
            departmentName = event_body['buyer']['departmentName']
        # tel2
        tel2 = None
        if 'tel2' in event_body['buyer'] :
            tel2 = event_body['buyer']['tel2']
        # email2
        email2 = None
        if 'email2' in event_body['buyer'] :
            email2 = event_body['buyer']['email2']
        # corpNumber
        corpNumber = None
        if 'corpNumber' in event_body['buyer'] :
            corpNumber = event_body['buyer']['corpNumber']
        # reqUpperLimit
        reqUpperLimit = None
        if 'reqUpperLimit' in event_body['creditFacility'] :
            reqUpperLimit = event_body['creditFacility']['reqUpperLimit']
            
        # 代表者姓（漢字）
        presidentNameFamily = None
        presidentNameFamily = get_value('presidentNameFamily', event_body['buyer'])
        # 代表者名（漢字） 
        presidentName = None
        presidentName = get_value('presidentName', event_body['buyer'])
        # 代表者姓（カナ） 
        presidentNameFamilyKana = None
        presidentNameFamilyKana = get_value('presidentNameFamilyKana', event_body['buyer'])
        # 代表者名（カナ） 
        presidentNameKana = None
        presidentNameKana = get_value('presidentNameKana', event_body['buyer'])
        # 代表者生年月日 
        birthday = None
        birthday = get_value('birthday', event_body['buyer'])
        # 希望上限金額
        reqUpperLimit = None
        reqUpperLimit = get_value('reqUpperLimit', event_body['creditFacility'])

        # 枠保証申込     
        apply = None
        apply = get_value('apply', event_body['creditFacility'])
        if apply is None :
            apply = "0"
        elif event_body['creditFacility']['apply'] == "1" :
            if presidentNameFamily is None :
                res = {}
                res['errCode'] = 'BCT0011'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0011']
                errArr.append(res)
            if presidentName is None :
                res = {}
                res['errCode'] = 'BCT0014'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0014']
                errArr.append(res)
            if presidentNameFamilyKana is None :
                res = {}
                res['errCode'] = 'BCT0037'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0037']
                errArr.append(res)
            if presidentNameKana is None :
                res = {}
                res['errCode'] = 'BCT0038'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0038']
                errArr.append(res)
            if birthday is None :
                res = {}
                res['errCode'] = 'BCT0029'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0029']
                errArr.append(res)
            if reqUpperLimit is None :
                res = {}
                res['errCode'] = 'BCT0039'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0039']
                errArr.append(res)

        if len(errArr) > 0 :
            return {
                    'statusCode': 400,
                    'headers': RESPONSE_HEADERS,
                    # 'body': json.dumps(errBody)
                    'body': json.dumps(errBody, default=str, ensure_ascii=False, indent=2)
                }

        #params
        params = {
            'shopInfo': {
                'authenticationId': authenticationId,
                'shopCode': shopCode,
                'connectPassword': connectPassword
             },
            'buyer': {
                # "buyerNameFamily": "掛払",
                "buyerNameFamily": event_body['buyer']['buyerNameFamily'],
                # "buyerName": "太郎",
                "buyerName": event_body['buyer']['buyerName'],
                "buyerNameFamilyKana": buyerNameFamilyKana,
                "buyerNameKana": buyerNameKana,
                # "zipCode": "150-0043",
                "zipCode": event_body['buyer']['zipCode'],
                # "address": "東京都渋谷区道玄坂 1−14−6",
                "address": event_body['buyer']['address'],
                # "companyName": "サンプル株式会社",
                "companyName": event_body['buyer']['companyName'],
                # "departmentName": "サンプル部",
                "departmentName": departmentName,
                # "tel1": "01234567",
                "tel1": event_body['buyer']['tel1'],
                # "tel2": "01234567",
                "tel2": tel2,
                # "email1": "sample1@localhost.localdomain",
                "email1": event_body['buyer']['email1'],
                # "email2": "sample1@localhost.localdomain",
                "email2": email2,
                # "presidentNameFamily": "代表",
                "presidentNameFamily": presidentNameFamily,
                # "presidentName": "花子",
                "presidentName": presidentName,
                # "presidentNameFamilyKana": "ダイヒョウ",
                "presidentNameFamilyKana": presidentNameFamilyKana,
                # "presidentNameKana": "ハナコ",
                "presidentNameKana": presidentNameKana,
                # "birthday": "20201029",
                "birthday": birthday,
                # "shopCustomerId": "5",
                "shopCustomerId": event_body['buyer']['shopCustomerId'],
                # "corpNumber": "1234567890123"
                "corpNumber": corpNumber
            },
            'creditFacility': {
                # "apply": "1",
                "apply": apply,
                # "reqUpperLimit": 10000000
                "reqUpperLimit": reqUpperLimit,
             }
        }
        logger.debug(params)

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    #データ送信
    try:
        headers = {
          'Content-Type': 'application/json',
          'Accept': 'application/json'
        }
        # headers = {
        #   'Content-Type': 'text/plain'
        # }
        res = requests.request('POST', url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # res = requests.post(url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # ステータスコード4XX, 5XX時に例外を発生させる
        # res.raise_for_status()
        # print(res)
        
        # logging.info(res.json())
        
        # HTTPのステータスコード取得
        logger.debug(res.status_code)    
        # レスポンスのHTMLを文字列で取得
        logger.debug(res.text)
        
        if res.status_code == 500 :
            return error_500()
        if res.status_code == 503 :
            return error_503()
        
        # res_json = xmljson.yahoo.data(res.getroot())
        res_json = res.json()
        # logger.debug("111")
        # print(res_json)
        
        res = {}
        res['error_code'] = None
        res['error_message'] = None

        if len(res_json['errors']) > 0 :
            res['error_code'] = res_json['errors'][0]['errCode']
            res['error_message'] = res_json['errors'][0]['errorMessage']
            return {
                'statusCode': 400,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res_json)
                'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
            }

        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            # 'body': json.dumps(res_json)
            'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# 購入企業情報変更（枠保証用）API
def payment_creditfacility_modifybuyer_post(event, context, cim_app_info = None, event_body = None):
    
    logger.info('payment_creditfacility_modifybuyer_post!!!')
    
    try:
        if event_body is None:
            event_body = {}
            event_body = json.loads(event['body'])
            # テスト
            # event_body = event

        # url = GV.PAYMENT0_GMOURL + 'creditfacility/modifybuyer'
        
        # # 環境変数の読み込み
        # authenticationId = GV.PAYMENT0_AUTHENTICATIONID
        # shopCode = GV.PAYMENT0_SHOPCODE
        # connectPassword = GV.PAYMENT0_CONNECTPASSWORD

        url = GV.PAYMENT1_GMOURL + 'creditfacility/modifybuyer'

        # 6708----------10/16----------S
        # 環境変数の読み込み
        relatedData = None
        relatedData = get_value('relatedData', event_body)
        
        if relatedData is not None:
            authenticationIdData = None
            authenticationIdData = get_value('authenticationId', event_body['relatedData'])
            if authenticationIdData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            shopCodeData = None
            shopCodeData = get_value('shopCode', event_body['relatedData'])
            if shopCodeData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            connectPasswordData = None
            connectPasswordData = get_value('connectPassword', event_body['relatedData'])
            if connectPasswordData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            authenticationId = authenticationIdData
            shopCode = shopCodeData
            connectPassword = connectPasswordData
        else:
            # 環境変数の読み込み
            authenticationId = GV.PAYMENT1_AUTHENTICATIONID
            shopCode = GV.PAYMENT1_SHOPCODE
            connectPassword = GV.PAYMENT1_CONNECTPASSWORD
        logger.info('GMO認証データのチェック!!!')
        logger.info(authenticationId)
        logger.info(shopCode)
        logger.info(connectPassword)
        # 6708----------10/16----------E
        
        # データのチェック
        errArr = []
        errBody = {
            "result" : "NG",
            "errors" : errArr
        }
        # 購入企業情報
        targetBuyer = None
        targetBuyer = get_value('targetBuyer', event_body)
        
        if targetBuyer is None:
            return error_400('「変更前の購入企業情報 」を指定してください。')
        
        # 必須    
        # 購入企業 ID
        shopCustomerId = None
        shopCustomerId = get_value('shopCustomerId', event_body['targetBuyer'])
        if shopCustomerId is None:
            res = {}
            res['errCode'] = 'BCT0021'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
            errArr.append(res)
        
        # 購入企業情報
        buyer = None
        buyer = get_value('buyer', event_body)
        
        if buyer is None:
            return error_400('「購入企業情報 」を指定してください。')
            
        # 枠保証情報
        creditFacility = None
        creditFacility = get_value('creditFacility', event_body)
        print(creditFacility)
        print("aaa")
        if creditFacility is None:
            return error_400('「枠保証情報」を指定してください。')
            
        # 必須
        # 担当者姓（漢字）
        buyerNameFamily = None
        buyerNameFamily = get_value('buyerNameFamily', event_body['buyer'])
        if buyerNameFamily is None:
            res = {}
            res['errCode'] = 'BCT0001'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0001']
            errArr.append(res)
        # 担当者名（漢字） 
        buyerName = None
        buyerName = get_value('buyerName', event_body['buyer'])
        if buyerName is None:
            res = {}
            res['errCode'] = 'BCT0004'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0004']
            errArr.append(res)
        # 郵便番号  
        zipCode = None
        zipCode = get_value('zipCode', event_body['buyer'])
        if zipCode is None:
            res = {}
            res['errCode'] = 'CT0012'
            res['errorMessage'] = error_payment_creditfacility_post['CT0012']
            errArr.append(res)
        # 住所 
        address = None
        address = get_value('address', event_body['buyer'])
        if address is None:
            res = {}
            res['errCode'] = 'CT0015'
            res['errorMessage'] = error_payment_creditfacility_post['CT0015']
            errArr.append(res)
        # 企業名  
        companyName = None
        companyName = get_value('companyName', event_body['buyer'])
        if companyName is None:
            res = {}
            res['errCode'] = 'BCT0009'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0009']
            errArr.append(res)
        # 電話番号１
        tel1 = None
        tel1 = get_value('tel1', event_body['buyer'])
        if tel1 is None:
            res = {}
            res['errCode'] = 'CT0022'
            res['errorMessage'] = error_payment_creditfacility_post['CT0022']
            errArr.append(res)
        # メールアドレス１
        email1 = None
        email1 = get_value('email1', event_body['buyer'])
        if email1 is None:
            res = {}
            res['errCode'] = 'BCT0010'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0010']
            errArr.append(res)
        # 購入企業 ID
        shopCustomerId = None
        shopCustomerId = get_value('shopCustomerId', event_body['buyer'])
        if shopCustomerId is None:
            res = {}
            res['errCode'] = 'BCT0021'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
            errArr.append(res)
            
        # カケバライ
        buyerNameFamilyKana = None
        if 'buyerNameFamilyKana' in event_body['buyer'] :
            buyerNameFamilyKana = event_body['buyer']['buyerNameFamilyKana']
        # タロウ
        buyerNameKana = None
        if 'buyerNameKana' in event_body['buyer'] :
            buyerNameKana = event_body['buyer']['buyerNameKana']
        # サンプル部
        departmentName = None
        if 'departmentName' in event_body['buyer'] :
            departmentName = event_body['buyer']['departmentName']
        # tel2
        tel2 = None
        if 'tel2' in event_body['buyer'] :
            tel2 = event_body['buyer']['tel2']
        # email2
        email2 = None
        if 'email2' in event_body['buyer'] :
            email2 = event_body['buyer']['email2']
        # corpNumber
        corpNumber = None
        if 'corpNumber' in event_body['buyer'] :
            corpNumber = event_body['buyer']['corpNumber']
        # reqUpperLimit
        reqUpperLimit = None
        if 'reqUpperLimit' in event_body['creditFacility'] :
            reqUpperLimit = event_body['creditFacility']['reqUpperLimit']
            
        # 代表者姓（漢字）
        presidentNameFamily = None
        presidentNameFamily = get_value('presidentNameFamily', event_body['buyer'])
        # 代表者名（漢字） 
        presidentName = None
        presidentName = get_value('presidentName', event_body['buyer'])
        # 代表者姓（カナ） 
        presidentNameFamilyKana = None
        presidentNameFamilyKana = get_value('presidentNameFamilyKana', event_body['buyer'])
        # 代表者名（カナ） 
        presidentNameKana = None
        presidentNameKana = get_value('presidentNameKana', event_body['buyer'])
        # 代表者生年月日 
        birthday = None
        birthday = get_value('birthday', event_body['buyer'])
        # 希望上限金額
        reqUpperLimit = None
        reqUpperLimit = get_value('reqUpperLimit', event_body['creditFacility'])

        # 枠保証申込     
        apply = None
        apply = get_value('apply', event_body['creditFacility'])
        if apply is None :
            apply = "0"
        elif event_body['creditFacility']['apply'] == "1" :
            if presidentNameFamily is None :
                res = {}
                res['errCode'] = 'BCT0011'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0011']
                errArr.append(res)
            if presidentName is None :
                res = {}
                res['errCode'] = 'BCT0014'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0014']
                errArr.append(res)
            if presidentNameFamilyKana is None :
                res = {}
                res['errCode'] = 'BCT0037'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0037']
                errArr.append(res)
            if presidentNameKana is None :
                res = {}
                res['errCode'] = 'BCT0038'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0038']
                errArr.append(res)
            if birthday is None :
                res = {}
                res['errCode'] = 'BCT0029'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0029']
                errArr.append(res)
            if reqUpperLimit is None :
                res = {}
                res['errCode'] = 'BCT0039'
                res['errorMessage'] = error_payment_creditfacility_post['BCT0039']
                errArr.append(res)

        if len(errArr) > 0 :
            return {
                    'statusCode': 400,
                    'headers': RESPONSE_HEADERS,
                    # 'body': json.dumps(errBody)
                    'body': json.dumps(errBody, default=str, ensure_ascii=False, indent=2)
                }

        #params
        params = {
            'shopInfo': {
                'authenticationId': authenticationId,
                'shopCode': shopCode,
                'connectPassword': connectPassword
             },
             "targetBuyer": {
                # "shopCustomerId": "1"
                "shopCustomerId": event_body['targetBuyer']['shopCustomerId']
             },
            'buyer': {
                # "buyerNameFamily": "掛払",
                "buyerNameFamily": event_body['buyer']['buyerNameFamily'],
                # "buyerName": "太郎",
                "buyerName": event_body['buyer']['buyerName'],
                # "buyerNameFamilyKana": "カケバライ",
                "buyerNameFamilyKana": buyerNameFamilyKana,
                # "buyerNameKana": "タロウ",
                "buyerNameKana": buyerNameKana,
                # "zipCode": "150-0043",
                "zipCode": event_body['buyer']['zipCode'],
                # "address": "東京都渋谷区道玄坂 1−14−6",
                "address": event_body['buyer']['address'],
                # "companyName": "サンプル株式会社",
                "companyName": event_body['buyer']['companyName'],
                # "departmentName": "サンプル部",
                "departmentName": departmentName,
                # "tel1": "01234567",
                "tel1": event_body['buyer']['tel1'],
                # "tel2": "01234567",
                "tel2": tel2,
                # "email1": "sample1@localhost.localdomain",
                "email1": event_body['buyer']['email1'],
                # "email2": "sample1@localhost.localdomain",
                "email2": email2,
                # "presidentNameFamily": "代表",
                "presidentNameFamily": presidentNameFamily,
                # "presidentName": "花子",
                "presidentName": presidentName,
                # "presidentNameFamilyKana": "ダイヒョウ",
                "presidentNameFamilyKana": presidentNameFamilyKana,
                # "presidentNameKana": "ハナコ",
                "presidentNameKana": presidentNameKana,
                # "birthday": "20201029",
                "birthday": birthday,
                # "shopCustomerId": "5",
                "shopCustomerId": shopCustomerId,
                # "corpNumber": "1234567890123"
                "corpNumber": corpNumber,
            },
            'creditFacility': {
                # "apply": "1",
                "apply": apply,
                # "reqUpperLimit": 10000000
                "reqUpperLimit": reqUpperLimit,
             }
        }
        logger.debug(params)

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    #データ送信
    try:
        headers = {
          'Content-Type': 'application/json',
          'Accept': 'application/json'
        }
        # headers = {
        #   'Content-Type': 'text/plain'
        # }
        res = requests.request('POST', url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # res = requests.post(url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # ステータスコード4XX, 5XX時に例外を発生させる
        # res.raise_for_status()
        # print(res)
        
        # logging.info(res.json())
        
        # HTTPのステータスコード取得
        logger.debug(res.status_code)    
        # レスポンスのHTMLを文字列で取得
        logger.debug(res.text)
        
        if res.status_code == 500 :
            return error_500()
        if res.status_code == 503 :
            return error_503()
        
        # res_json = xmljson.yahoo.data(res.getroot())
        res_json = res.json()
        # logger.debug("111")
        print(res_json)
        
        res = {}
        res['error_code'] = None
        res['error_message'] = None
  
        if len(res_json['errors']) > 0 :
            res['error_code'] = res_json['errors'][0]['errCode']
            res['error_message'] = res_json['errors'][0]['errorMessage']
            # res['error_message'] = error_payment_creditfacility_registerbuyer_post[str(res['error_code'])]
            return {
                'statusCode': 400,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res_json)
                'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
            }

        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            # 'body': json.dumps(res_json)
            'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# 枠保証状況取得API
def payment_creditfacility_getbuyercreditfacility_post(event, context, cim_app_info = None, event_body = None):
    
    logger.info('payment_creditfacility_getbuyercreditfacility_post!!!')
    
    try:
        if event_body is None:
            event_body = {}
            event_body = json.loads(event['body'])
            # テスト
            # event_body = event

        # url = GV.PAYMENT0_GMOURL + 'creditfacility/getbuyercreditfacility'
        
        # # 環境変数の読み込み
        # authenticationId = GV.PAYMENT0_AUTHENTICATIONID
        # shopCode = GV.PAYMENT0_SHOPCODE
        # connectPassword = GV.PAYMENT0_CONNECTPASSWORD

        url = GV.PAYMENT1_GMOURL + 'creditfacility/getbuyercreditfacility'
        
        # 6708----------10/16----------S
        # 環境変数の読み込み
        relatedData = None
        relatedData = get_value('relatedData', event_body)
        
        if relatedData is not None:
            authenticationIdData = None
            authenticationIdData = get_value('authenticationId', event_body['relatedData'])
            if authenticationIdData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            shopCodeData = None
            shopCodeData = get_value('shopCode', event_body['relatedData'])
            if shopCodeData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            connectPasswordData = None
            connectPasswordData = get_value('connectPassword', event_body['relatedData'])
            if connectPasswordData is None:
                return error_400('「GMO掛け払いを使う場合の接続先情報」を指定してください。')
            
            authenticationId = authenticationIdData
            shopCode = shopCodeData
            connectPassword = connectPasswordData
        else:
            # 環境変数の読み込み
            authenticationId = GV.PAYMENT1_AUTHENTICATIONID
            shopCode = GV.PAYMENT1_SHOPCODE
            connectPassword = GV.PAYMENT1_CONNECTPASSWORD
        logger.info('GMO認証データのチェック!!!')
        logger.info(authenticationId)
        logger.info(shopCode)
        logger.info(connectPassword)
        # 6708----------10/16----------E
        
        # データのチェック
        errArr = []
        errBody = {
            "result" : "NG",
            "errors" : errArr
        }
        # 購入企業情報
        targetBuyer = None
        targetBuyer = get_value('targetBuyer', event_body)
        
        if targetBuyer is None:
            return error_400('「購入企業情報 」を指定してください。')
        
        # 必須    
        # 購入企業 ID
        shopCustomerId = None
        shopCustomerId = get_value('shopCustomerId', event_body['targetBuyer'])
        if shopCustomerId is None:
            res = {}
            res['errCode'] = 'BCT0021'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
            errArr.append(res)
            
        if len(errArr) > 0 :
            return {
                    'statusCode': 400,
                    'headers': RESPONSE_HEADERS,
                    # 'body': json.dumps(errBody)
                    'body': json.dumps(errBody, default=str, ensure_ascii=False, indent=2)
                }

        #params
        params = {
            'shopInfo': {
                'authenticationId': authenticationId,
                'shopCode': shopCode,
                'connectPassword': connectPassword
             },
             "targetBuyer": {
                # "shopCustomerId": "1"
                "shopCustomerId": event_body['targetBuyer']['shopCustomerId']
             }
        }
        logger.debug(params)

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    #データ送信
    try:
        headers = {
          'Content-Type': 'application/json',
          'Accept': 'application/json'
        }
        # headers = {
        #   'Content-Type': 'text/plain'
        # }
        res = requests.request('POST', url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # res = requests.post(url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # ステータスコード4XX, 5XX時に例外を発生させる
        # res.raise_for_status()
        # print(res)
        
        # logging.info(res.json())
        
        # HTTPのステータスコード取得
        logger.debug(res.status_code)    
        # レスポンスのHTMLを文字列で取得
        logger.debug(res.text)
        
        if res.status_code == 500 :
            return error_500()
        if res.status_code == 503 :
            return error_503()
            
        # res_json = xmljson.yahoo.data(res.getroot())
        res_json = res.json()
        # logger.debug("111")
        # print(res_json)
        
        res = {}
        res['error_code'] = None
        res['error_message'] = None
     
        if len(res_json['errors']) > 0 :
            res['error_code'] = res_json['errors'][0]['errCode']
            res['error_message'] = res_json['errors'][0]['errorMessage']
            # res['error_message'] = error_payment_creditfacility_registerbuyer_post[str(res['error_code'])]
            return {
                'statusCode': 400,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res_json)
                'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
            }

        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            # 'body': json.dumps(res_json)
            'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# 配送先情報のエラー
error_payment_transaction_post = {
    'DL0001': '配送先{1}の氏名（漢字）が未入力です。',
    'DL0002': '配送先{1}の氏名（漢字）の文字数が異なります。',
    'DL0003': '配送先{1}の氏名（漢字）の値が不正です。',
    'DL0004': '配送先{1}の氏名（カナ）が未入力です。',
    'DL0005': '配送先{1}の氏名（カナ）の文字数が異なります。',
    'DL0006': '配送先{1}の氏名（カナ）の値が不正です。',
    'DL0007': '配送先{1}の郵便番号が未入力です。',
    'DL0008': '配送先{1}の郵便番号の文字数が異なります。',
    'DL0009': '配送先{1}の郵便番号の値が不正です。',
    'DL0010': '配送先{1}の住所が未入力です。',
    'DL0011': '配送先{1}の住所の文字数が異なります。',
    'DL0012': '配送先{1}の住所の値が不正です。',
    'DL0013': '配送先{1}の企業名の文字数が異なります。',
    'DL0014': '配送先{1}の企業名の値が不正です。',
    'DL0015': '配送先{1}の部署名の文字数が異なります。',
    'DL0016': '配送先{1}の部署名の値が不正です。',
    'DL0017': '配送先{1}の電話番号の文字数が異なります。',
    'DL0018': '配送先{1}の電話番号の値が不正です。',
    'DL0019': '配送先{1}の郵便番号と住所が一致しません。',
    'DL0020': '配送先情報は{0}箇所のみ登録可能です。',
    'DL0021': '配送先{1}の丁番地または建造物名／号室等を入力してください。',
    'DL0022': '配送先{1}の企業名が未入力です。',
    'BDL0001': '配送先{0}の企業名が未入力です。',
    'BDL0002': '配送先{0}の部署名が未入力です。',
    'BDL0003': '配送先{0}の電話番号が未入力です。'
}

# 商品明細情報のエラー
error_payment_transaction_post1_5 = {
    'DT0001': '配送先{1}明細｛1｝の明細名が未入力です。',
    'DT0002': '配送先{1}明細｛1｝の明細名の文字数が異なります。',
    'DT0003': '配送先{1}明細｛1｝の明細名の値が不正です。',
    'DT0004': '配送先{1}明細｛1｝の単価が未入力です。',
    'DT0005': '配送先{1}明細｛1｝の単価の文字数が異なります。',
    'DT0006': '配送先{1}明細｛1｝の単価の値が不正です。',
    'DT0007': '配送先{1}明細｛1｝の数量が未入力です。',
    'DT0008': '配送先{1}明細｛1｝の数量の文字数が異なります。',
    'DT0009': '配送先{1}明細｛1｝の数量の値が不正です。',
    'DT0010': '商品情報は{0}個まで登録可能です。',
    'DT0014': '配送先{1}明細｛1｝のブランドの文字数が異なります。',
    'DT0015': '配送先{1}明細｛1｝のブランドの値が不正です。',
    'DT0016': '配送先{1}明細｛1｝のカテゴリの文字数が異なります。',
    'DT0017': '配送先{1}明細｛1｝のカテゴリの値が不正です。',
    'BDT0001': '配送先{0}明細{1}の消費税区分が未入力です。',
    'BDT0002': '配送先{0}明細{1}の消費税区分の文字数が異なります。',
    'BDT0003': '配送先{0}明細{1}の消費税区分の値が不正です。',
    'BDT0004': '拡張項目チェックエラーです。リクエスト ID:{0}。',
    'BDT0005': '配送先{0}明細{1}の明細金額が未入力です。',
    'BDT0006': '配送先{0}明細{1}の明細金額の文字数が異なります。',
    'BDT0007': '配送先{0}明細{1}の明細金額の値が不正です。'
}

# 消費税のエラー
error_payment_transaction_post1_6 = {
    'BTX0001': '消費税の税区分が未入力です。',
    'BTX0002': '消費税の税区分の文字数が異なります。',
    'BTX0003': '消費税の税区分の値が不正です。',
    'BTX0004': '消費税の税額が未入力です。',
    'BTX0005': '消費税の税額の文字数が異なります。',
    'BTX0006': '消費税の税額の値が不正です。'
}

# 取引登録API
def payment_transaction_post(event, context, cim_app_info = None, event_body = None):
    
    logger.info('payment_transaction_post!!!')
    
    try:
        if event_body is None:
            event_body = {}
            event_body = json.loads(event['body'])
            # テスト
            # event_body = event
            
        # 環境変数の読み込み    
        url = None
        authenticationId = None
        shopCode = None
        connectPassword = None
        if 'GmoCreditAccount' in event_body:
            if event_body['GmoCreditAccount'] == '0':
                url = GV.PAYMENT0_GMOURL + 'transaction'
                authenticationId = GV.PAYMENT0_AUTHENTICATIONID
                shopCode = GV.PAYMENT0_SHOPCODE
                connectPassword = GV.PAYMENT0_CONNECTPASSWORD
            elif event_body['GmoCreditAccount'] == '1':
                url = GV.PAYMENT1_GMOURL + 'transaction'
                authenticationId = GV.PAYMENT1_AUTHENTICATIONID
                shopCode = GV.PAYMENT1_SHOPCODE
                connectPassword = GV.PAYMENT1_CONNECTPASSWORD
            else:
                return error_400('「アカウント」を指定してください。0:枠保証なしアカウント、1:枠保証ありアカウント')
        else:
            return error_400('「アカウント」を指定してください。0:枠保証なしアカウント、1:枠保証ありアカウント')

        
        # データのチェック
        errArr = []
        errBody = {
            "result" : "NG",
            "errors" : errArr
        }
        # # 端末識別情報
        # httpInfo = None
        # httpInfo = get_value('httpInfo', event_body)
        
        # if httpInfo is None:
        #     return error_400('「端末識別情報 」を指定してください。')
        
        # 税項目 
        taxes = None
        taxes = get_value('taxes', event_body)
        if taxes is None:
            return error_400('「税項目 」を指定してください。')
            
        # 消費税別合計  
        taxesSum = None
        taxesSum = get_value('taxesSum', event_body)
        if taxesSum is None:
            return error_400('「消費税別合計  」を指定してください。')

        # 配送先項目 
        deliveries = None
        deliveries = get_value('deliveries', event_body)
        if deliveries is None:
            return error_400('「配送先項目 」を指定してください。')
        
        # 配送先情報 
        delivery = None
        delivery = get_value('delivery', event_body['deliveries'])
        if delivery is None:
            return error_400('「配送先項目の配送先情報 」を指定してください。')
            
        # 必須    
        # # HTTP ヘッダ情報 
        # httpHeader = None
        # httpHeader = get_value('httpHeader', event_body['httpInfo'])
        # if httpHeader is None:
        #     res = {}
        #     res['errCode'] = 'BCT0021'
        #     res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
        #     errArr.append(res)
            
        # # デバイス情報 
        # deviceInfo = None
        # deviceInfo = get_value('deviceInfo', event_body['httpInfo'])
        # if deviceInfo is None:
        #     res = {}
        #     res['errCode'] = 'BCT0021'
        #     res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
        #     errArr.append(res)
            
        # 購入企業情報 
        buyer = None
        buyer = get_value('buyer', event_body)
        
        if buyer is None:
            return error_400('「購入企業情報 」を指定してください。')
        
        # 必須    
        # 加盟店取引 ID
        shopTransactionId = None
        shopTransactionId = get_value('shopTransactionId', event_body['buyer'])
        if shopTransactionId is None:
            res = {}
            res['errCode'] = 'CT0001'
            res['errorMessage'] = error_payment_creditfacility_post['CT0001']
            errArr.append(res)
            
        # 加盟店注文日 
        shopOrderDate = None
        shopOrderDate = get_value('shopOrderDate', event_body['buyer'])
        if shopOrderDate is None:
            res = {}
            res['errCode'] = 'CT0004'
            res['errorMessage'] = error_payment_creditfacility_post['CT0004']
            errArr.append(res)
            
        # 担当者姓（漢字） 
        buyerNameFamily = None
        buyerNameFamily = get_value('buyerNameFamily', event_body['buyer'])
        if buyerNameFamily is None:
            res = {}
            res['errCode'] = 'BCT0001'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0001']
            errArr.append(res)
            
        # 担当者名（漢字）  
        buyerName = None
        buyerName = get_value('buyerName', event_body['buyer'])
        if buyerName is None:
            res = {}
            res['errCode'] = 'BCT0004'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0004']
            errArr.append(res)
            
        # 郵便番号 
        zipCode = None
        zipCode = get_value('zipCode', event_body['buyer'])
        if zipCode is None:
            res = {}
            res['errCode'] = 'CT0012'
            res['errorMessage'] = error_payment_creditfacility_post['CT0012']
            errArr.append(res)
            
        # 住所 
        address = None
        address = get_value('address', event_body['buyer'])
        if address is None:
            res = {}
            res['errCode'] = 'CT0015'
            res['errorMessage'] = error_payment_creditfacility_post['CT0015']
            errArr.append(res)
            
        # 企業名 
        companyName = None
        companyName = get_value('companyName', event_body['buyer'])
        if companyName is None:
            res = {}
            res['errCode'] = 'BCT0009'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0009']
            errArr.append(res)
        
        # 電話番号１  
        tel1 = None
        tel1 = get_value('tel1', event_body['buyer'])
        if tel1 is None:
            res = {}
            res['errCode'] = 'CT0022'
            res['errorMessage'] = error_payment_creditfacility_post['CT0022']
            errArr.append(res)
        
        # メールアドレス１ 
        email1 = None
        email1 = get_value('email1', event_body['buyer'])
        if email1 is None:
            res = {}
            res['errCode'] = 'BCT0010'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0010']
            errArr.append(res)
            
        # 顧客請求額 
        billedAmount = None
        billedAmount = get_value('billedAmount', event_body['buyer'])
        if billedAmount is None:
            res = {}
            res['errCode'] = 'CT0031'
            res['errorMessage'] = error_payment_creditfacility_post['CT0031']
            errArr.append(res)
            
        # 購入企業 ID 
        shopCustomerId = None
        shopCustomerId = get_value('shopCustomerId', event_body['buyer'])
        if shopCustomerId is None:
            res = {}
            res['errCode'] = 'BCT0021'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
            errArr.append(res)
            
         # カケバライ
        buyerNameFamilyKana = None
        if 'buyerNameFamilyKana' in event_body['buyer'] :
            buyerNameFamilyKana = event_body['buyer']['buyerNameFamilyKana']
        # タロウ
        buyerNameKana = None
        if 'buyerNameKana' in event_body['buyer'] :
            buyerNameKana = event_body['buyer']['buyerNameKana']
        # サンプル部
        departmentName = None
        if 'departmentName' in event_body['buyer'] :
            departmentName = event_body['buyer']['departmentName']
        # tel2
        tel2 = None
        if 'tel2' in event_body['buyer'] :
            tel2 = event_body['buyer']['tel2']
        # email2
        email2 = None
        if 'email2' in event_body['buyer'] :
            email2 = event_body['buyer']['email2']
            
        # GMO 拡張項目１ 
        gmoExtend1 = None
        if 'gmoExtend1' in event_body['buyer'] :
            gmoExtend1 = event_body['buyer']['gmoExtend1']
        # 代表者姓（漢字） 
        presidentNameFamily = None
        if 'presidentNameFamily' in event_body['buyer'] :
            presidentNameFamily = event_body['buyer']['presidentNameFamily']
        # 代表者名（漢字） 
        presidentName = None
        if 'presidentName' in event_body['buyer'] :
            presidentName = event_body['buyer']['presidentName']
        # 代表者姓（カナ）
        presidentNameFamilyKana = None
        if 'presidentNameFamilyKana' in event_body['buyer'] :
            presidentNameFamilyKana = event_body['buyer']['presidentNameFamilyKana']
        # 代表者名（カナ）
        presidentNameKana = None
        if 'presidentNameKana' in event_body['buyer'] :
            presidentNameKana = event_body['buyer']['presidentNameKana']
        # 代表者生年月日 
        birthday = None
        if 'birthday' in event_body['buyer'] :
            birthday = event_body['buyer']['birthday']
        # 会員登録日
        memberRegistDate = None
        if 'memberRegistDate' in event_body['buyer'] :
            memberRegistDate = event_body['buyer']['memberRegistDate']
        # 購入回数  
        buyCount = None
        if 'buyCount' in event_body['buyer'] :
            buyCount = event_body['buyer']['buyCount']
        # 購入金額総額
        buyAmountTotal = None
        if 'buyAmountTotal' in event_body['buyer'] :
            buyAmountTotal = event_body['buyer']['buyAmountTotal']

        # print(event_body['deliveries'])
        # print(event_body['deliveries']['delivery'])
        # # 明細項目  
        # details = None
        # details = get_value('details', event_body['deliveries']['delivery'])
        # if details is None:
        #     return error_400('「配送先項目の配送先情報の明細項 」を指定してください。')  
            
        # # 明細詳細情報 
        # detail = None
        # detail = get_value('detail', event_body['deliveries']['delivery']['details'])
        # if detail is None:
        #     return error_400('「配送先項目の配送先情報の明細項の明細詳細情報 」を指定してください。')  
        
        # # 明細名 
        # detailName = None
        # detailName = get_value('detailName', event_body['deliveries']['delivery']['details']['detail'])
        # if detailName is None:
        #     res = {}
        #     res['errCode'] = 'DT0001'
        #     res['errorMessage'] = error_payment_transaction_post1_5['DT0001']
        #     errArr.append(res)
            
        # # 単価  
        # detailPrice = None
        # detailPrice = get_value('detailPrice', event_body['deliveries']['delivery']['details']['detail'])
        # if detailPrice is None:
        #     res = {}
        #     res['errCode'] = 'DT0004'
        #     res['errorMessage'] = error_payment_transaction_post1_5['DT0004']
        #     errArr.append(res)
            
        # # 数量
        # detailQuantity = None
        # detailQuantity = get_value('detailQuantity', event_body['deliveries']['delivery']['details']['detail'])
        # if detailQuantity is None:
        #     res = {}
        #     res['errCode'] = 'DT0007'
        #     res['errorMessage'] = error_payment_transaction_post1_5['DT0007']
        #     errArr.append(res)
            
        # # 明細金額
        # itemPrice = None
        # itemPrice = get_value('itemPrice', event_body['deliveries']['delivery']['details']['detail'])
        # if itemPrice is None:
        #     res = {}
        #     res['errCode'] = 'BDT0005'
        #     res['errorMessage'] = error_payment_transaction_post1_5['BDT0005']
        #     errArr.append(res)
            
        # # 税区分 
        # feeTaxType = None
        # feeTaxType = get_value('feeTaxType', event_body['deliveries']['delivery']['details']['detail'])
        # if feeTaxType is None:
        #     res = {}
        #     res['errCode'] = 'BDT0001'
        #     res['errorMessage'] = error_payment_transaction_post1_5['BDT0001']
        #     errArr.append(res)
            
        if len(errArr) > 0 :
            return {
                    'statusCode': 400,
                    'headers': RESPONSE_HEADERS,
                    # 'body': json.dumps(errBody)
                    'body': json.dumps(errBody, default=str, ensure_ascii=False, indent=2)
                }

        #params
        params = {
            'shopInfo': {
                'authenticationId': authenticationId,
                'shopCode': shopCode,
                'connectPassword': connectPassword
             },
             "httpInfo": {
                 "httpHeader": "httpHeader",
                #  "httpHeader": event_body['httpInfo']['httpHeader'],
                 "deviceInfo": "deviceInfo"
                #  "deviceInfo": event_body['httpInfo']['deviceInfo']
             },
             "buyer": {
                #  "shopTransactionId": "test",
                 "shopTransactionId": event_body['buyer']['shopTransactionId'],
                #  "shopOrderDate": "2020/09/11",
                 "shopOrderDate": event_body['buyer']['shopOrderDate'],
                #  "buyerNameFamily": "姓",
                 "buyerNameFamily": event_body['buyer']['buyerNameFamily'],
                #  "buyerName": "名",
                 "buyerName": event_body['buyer']['buyerName'],
                #  "buyerNameFamilyKana": "セイ",
                 "buyerNameFamilyKana": buyerNameFamilyKana,
                #  "buyerNameKana": "メイ",
                 "buyerNameKana": buyerNameKana,
                #  "zipCode": "0010915",
                 "zipCode": event_body['buyer']['zipCode'],
                #  "address": "北海道札幌市北区新琴似町",
                 "address": event_body['buyer']['address'],
                #  "companyName": "カイシャメイ",
                 "companyName": event_body['buyer']['companyName'],
                #  "departmentName": "部署名",
                 "departmentName": departmentName,
                #  "tel1": "01000020003",
                 "tel1": event_body['buyer']['tel1'],
                #  "tel2": null,
                 "tel2": tel2,
                #  "email1": "gmo@gmo.biz",
                 "email1": event_body['buyer']['email1'],
                #  "email2": null,
                 "email2": email2,
                #  "billedAmount": "99999",
                 "billedAmount": event_body['buyer']['billedAmount'],
                #  "gmoExtend1": null,
                 "gmoExtend1": gmoExtend1,
                #  "presidentNameFamily": "代表姓",
                 "presidentNameFamily": presidentNameFamily,
                #  "presidentName": "代表名",
                 "presidentName": presidentName,
                #  "presidentNameFamilyKana": "ダイヒョウセイ",
                 "presidentNameFamilyKana": presidentNameFamilyKana,
                #  "presidentNameKana": "ダイヒョウメイ",
                 "presidentNameKana": presidentNameKana,
                #  "birthday": "1999/01/01",
                 "birthday": birthday,
                #  "memberRegistDate": "2000/03/31",
                 "memberRegistDate": memberRegistDate,
                #  "buyCount": "1",
                 "buyCount": buyCount,
                #  "buyAmountTotal": "10000",
                 "buyAmountTotal": buyAmountTotal,
                #  "shopCustomerId": "cusId"
                 "shopCustomerId": event_body['buyer']['shopCustomerId']
            },
            # "taxes": [
            #     {
            #         # "taxType": "1",
            #         "taxType": event_body['taxes'][0]['taxType'],
            #         # "taxAmount": "800"
            #         "taxAmount": event_body['taxes'][0]['taxAmount']
            #     },
            #     {
            #         # "taxType": "2",
            #         "taxType": event_body['taxes'][1]['taxType'],
            #         # "taxAmount": "1000"
            #         "taxAmount": event_body['taxes'][1]['taxAmount']
            #     }
            # ],
            "taxes": event_body['taxes'],
            # "taxesSum": [
            #     {
            #         # "taxType": "1",
            #         "taxType": event_body['taxesSum'][0]['taxType'],
            #         # "taxSumAmount": "8888"
            #         "taxSumAmount": event_body['taxesSum'][0]['taxSumAmount']
            #     },
            #     {
            #         # "taxType": "2",
            #         "taxType": event_body['taxesSum'][1]['taxType'],
            #         # "taxSumAmount": "11111"
            #         "taxSumAmount": event_body['taxesSum'][1]['taxSumAmount']
            #     }
            # ],
            "taxesSum": event_body['taxesSum'],
            "deliveries": {
                "delivery": event_body['deliveries']['delivery']
                # "delivery": [
                #     {
                #         "deliveryCustomer": {
                #             # "fullName": "田中 太郎",
                #             "fullName": event_body['deliveries']['delivery'][0]['deliveryCustomer']['fullName'],
                #             # "fullKanaName": "タナカ タロウ",
                #             "fullKanaName": event_body['deliveries']['delivery'][0]['deliveryCustomer']['fullKanaName'],
                #             # "zipCode": "0010045",
                #             "zipCode": event_body['deliveries']['delivery'][0]['deliveryCustomer']['zipCode'],
                #             # "address": "北海道札幌市北区麻生町",
                #             "address": event_body['deliveries']['delivery'][0]['deliveryCustomer']['address'],
                #             # "companyName": "配送先会社",
                #             "companyName": event_body['deliveries']['delivery'][0]['deliveryCustomer']['companyName'],
                #             # "departmentName": "配送先部署",
                #             "departmentName": event_body['deliveries']['delivery'][0]['deliveryCustomer']['departmentName'],
                #             # "tel": "03000040005"
                #             "tel": event_body['deliveries']['delivery'][0]['deliveryCustomer']['tel']
                #         },
                #         "details": {
                #             "detail": [
                #                 {
                #                     # "detailName": "商品名",
                #                     "detailName": event_body['deliveries']['delivery'][0]['details']['detail'][0]['detailName'],
                #                     # "detailPrice": "1000",
                #                     "detailPrice": event_body['deliveries']['delivery'][0]['details']['detail'][0]['detailPrice'],
                #                     # "detailQuantity": "3",
                #                     "detailQuantity": event_body['deliveries']['delivery'][0]['details']['detail'][0]['detailQuantity'],
                #                     # "itemPrice": "3000",
                #                     "itemPrice": event_body['deliveries']['delivery'][0]['details']['detail'][0]['itemPrice'],
                #                     # "feeTaxType": "1",
                #                     "feeTaxType": event_body['deliveries']['delivery'][0]['details']['detail'][0]['feeTaxType'],
                #                     # "gmoExtend2": null,
                #                     "gmoExtend2": event_body['deliveries']['delivery'][0]['details']['detail'][0]['gmoExtend2'],
                #                     # "gmoExtend3": null,
                #                     "gmoExtend3": event_body['deliveries']['delivery'][0]['details']['detail'][0]['gmoExtend3'],
                #                     # "gmoExtend4": null,
                #                     "gmoExtend4": event_body['deliveries']['delivery'][0]['details']['detail'][0]['gmoExtend4'],
                #                     # "detailBrand": "ブランド",
                #                     "detailBrand": event_body['deliveries']['delivery'][0]['details']['detail'][0]['detailBrand'],
                #                     # "detailCategory": "カテゴリー"
                #                     "detailCategory": event_body['deliveries']['delivery'][0]['details']['detail'][0]['detailCategory']
                #                 }
                #             ]
                #         }
                #     }
                # ]
            }
        }
        logger.debug(params)

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    #データ送信
    try:
        headers = {
          'Content-Type': 'application/json',
          'Accept': 'application/json'
        }
        # headers = {
        #   'Content-Type': 'text/plain'
        # }
        res = requests.request('POST', url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # res = requests.post(url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # ステータスコード4XX, 5XX時に例外を発生させる
        # res.raise_for_status()
        # print(res)
        
        # logging.info(res.json())
        
        # HTTPのステータスコード取得
        logger.debug(res.status_code)    
        # レスポンスのHTMLを文字列で取得
        logger.debug(res.text)
        
        if res.status_code == 500 :
            return error_500()
        if res.status_code == 503 :
            return error_503()
        
        # res_json = xmljson.yahoo.data(res.getroot())
        res_json = res.json()
        # logger.debug("111")
        # print(res_json)
        
        res = {}
        res['error_code'] = None
        res['error_message'] = None

        if len(res_json['errors']) > 0 :
            res['error_code'] = res_json['errors'][0]['errCode']
            res['error_message'] = res_json['errors'][0]['errorMessage']
            # res['error_message'] = error_payment_creditfacility_registerbuyer_post[str(res['error_code'])]
            return {
                'statusCode': 400,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res_json)
                'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
            }

        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            # 'body': json.dumps(res_json)
            'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# 請求確定API
def payment_fixrequest_post(event, context, cim_app_info = None, event_body = None):
    
    logger.info('payment_fixrequest_post!!!')
    
    try:
        if event_body is None:
            event_body = {}
            event_body = json.loads(event['body'])
            # テスト
            # event_body = event

        # 環境変数の読み込み    
        url = None
        authenticationId = None
        shopCode = None
        connectPassword = None
        
        # アカウント情報
        gmoCreditAccount = None
        gmoCreditAccount = get_value('GmoCreditAccount', event_body)
        if gmoCreditAccount is None:
            return error_400('「アカウント」を指定してください。0:枠保証なしアカウント、1:枠保証ありアカウント')
        if gmoCreditAccount == '0':
            url = GV.PAYMENT0_GMOURL + 'fixrequest'
            authenticationId = GV.PAYMENT0_AUTHENTICATIONID
            shopCode = GV.PAYMENT0_SHOPCODE
            connectPassword = GV.PAYMENT0_CONNECTPASSWORD
        elif gmoCreditAccount == '1':
            url = GV.PAYMENT1_GMOURL + 'fixrequest'
            authenticationId = GV.PAYMENT1_AUTHENTICATIONID
            shopCode = GV.PAYMENT1_SHOPCODE
            connectPassword = GV.PAYMENT1_CONNECTPASSWORD
        else:
            return error_400('「アカウント」を指定してください。0:枠保証なしアカウント、1:枠保証ありアカウント')

        # 取引情報
        transaction = None
        transaction = get_value('transaction', event_body)
        
        if transaction is None:
            return error_400('「取引情報 」を指定してください。')
            
        # データのチェック
        errArr = []
        errBody = {
            "result" : "NG",
            "errors" : errArr
        }

        # 必須
        # GMO 取引 ID
        gmoTransactionId = None
        gmoTransactionId = get_value('gmoTransactionId', event_body['transaction'])
        if gmoTransactionId is None:
            res = {}
            res['errCode'] = 'CT0036'
            res['errorMessage'] = error_payment_creditfacility_post['CT0036']
            errArr.append(res)
        # 請求確定日 
        fixRequestDate = None
        fixRequestDate = get_value('fixRequestDate', event_body['transaction'])
        if fixRequestDate is None:
            res = {}
            res['errCode'] = 'BCT0040'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0040']
            errArr.append(res)

        if len(errArr) > 0 :
            return {
                    'statusCode': 400,
                    'headers': RESPONSE_HEADERS,
                    # 'body': json.dumps(errBody)
                    'body': json.dumps(errBody, default=str, ensure_ascii=False, indent=2)
                }

        #params
        params = {
            'shopInfo': {
                'authenticationId': authenticationId,
                'shopCode': shopCode,
                'connectPassword': connectPassword
             },
             "transaction": {
                #  "gmoTransactionId":"123456789012345",
                 "gmoTransactionId": event_body['transaction']['gmoTransactionId'],
                #  "fixRequestDate":"2020/09/13"
                 "fixRequestDate": event_body['transaction']['fixRequestDate']
             }
        }
        logger.debug(params)

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    #データ送信
    try:
        headers = {
          'Content-Type': 'application/json',
          'Accept': 'application/json'
        }
        # headers = {
        #   'Content-Type': 'text/plain'
        # }
        res = requests.request('POST', url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # res = requests.post(url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # ステータスコード4XX, 5XX時に例外を発生させる
        # res.raise_for_status()
        # print(res)
        
        # logging.info(res.json())
        
        # HTTPのステータスコード取得
        logger.debug(res.status_code)    
        # レスポンスのHTMLを文字列で取得
        logger.debug(res.text)
        
        if res.status_code == 500 :
            return error_500()
        if res.status_code == 503 :
            return error_503()
            
        # res_json = xmljson.yahoo.data(res.getroot())
        res_json = res.json()
        # logger.debug("111")
        # print(res_json)
        
        res = {}
        res['error_code'] = None
        res['error_message'] = None

                
        if len(res_json['errors']) > 0 :
            res['error_code'] = res_json['errors'][0]['errCode']
            res['error_message'] = res_json['errors'][0]['errorMessage']
            # res['error_message'] = error_payment_creditfacility_registerbuyer_post[str(res['error_code'])]
            return {
                'statusCode': 400,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res_json)
                'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
            }

        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            # 'body': json.dumps(res_json)
            'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# 枠保証状況ステータス取得API
def payment_creditfacility_getbuyercreditfacility_status_post(event, context, cim_app_info = None, event_body = None):
    
    logger.info('payment_creditfacility_getbuyercreditfacility_status_post!!!')
    
    try:
        if event_body is None:
            event_body = {}
            event_body = json.loads(event['body'])
            # テスト
            # event_body = event

        # url = GV.PAYMENT0_GMOURL + 'creditfacility/getbuyercreditfacilitystatus'
        
        # # 環境変数の読み込み
        # authenticationId = GV.PAYMENT0_AUTHENTICATIONID
        # shopCode = GV.PAYMENT0_SHOPCODE
        # connectPassword = GV.PAYMENT0_CONNECTPASSWORD

        url = GV.PAYMENT1_GMOURL + 'creditfacility/getbuyercreditfacilitystatus'
        
        # 環境変数の読み込み
        authenticationId = GV.PAYMENT1_AUTHENTICATIONID
        shopCode = GV.PAYMENT1_SHOPCODE
        connectPassword = GV.PAYMENT1_CONNECTPASSWORD
        
        # データのチェック
        errArr = []
        errBody = {
            "result" : "NG",
            "errors" : errArr
        }
        # 購入企業情報
        targetBuyer = None
        targetBuyer = get_value('targetBuyer', event_body)
        
        if targetBuyer is None:
            return error_400('「購入企業情報 」を指定してください。')
        
        # 必須    
        # 購入企業 ID
        shopCustomerId = None
        shopCustomerId = get_value('shopCustomerId', event_body['targetBuyer'])
        if shopCustomerId is None:
            res = {}
            res['errCode'] = 'BCT0021'
            res['errorMessage'] = error_payment_creditfacility_post['BCT0021']
            errArr.append(res)
            
        if len(errArr) > 0 :
            return {
                    'statusCode': 400,
                    'headers': RESPONSE_HEADERS,
                    # 'body': json.dumps(errBody)
                    'body': json.dumps(errBody, default=str, ensure_ascii=False, indent=2)
                }

        #params
        params = {
            'shopInfo': {
                'authenticationId': authenticationId,
                'shopCode': shopCode,
                'connectPassword': connectPassword
             },
             "targetBuyer": {
                #  "shopCustomerId":"1234567890",
                 "shopCustomerId": event_body['targetBuyer']['shopCustomerId']
             }
        }
        logger.debug(params)

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    #データ送信
    try:
        headers = {
          'Content-Type': 'application/json',
          'Accept': 'application/json'
        }
        # headers = {
        #   'Content-Type': 'text/plain'
        # }
        res = requests.request('POST', url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # res = requests.post(url, headers=headers, data=json.dumps(params).encode('utf-8'))
        # ステータスコード4XX, 5XX時に例外を発生させる
        # res.raise_for_status()
        # print(res)
        
        # logging.info(res.json())
        
        # HTTPのステータスコード取得
        logger.debug(res.status_code)    
        # レスポンスのHTMLを文字列で取得
        logger.debug(res.text)
        
        if res.status_code == 500 :
            return error_500()
        if res.status_code == 503 :
            return error_503()
            
        # res_json = xmljson.yahoo.data(res.getroot())
        res_json = res.json()
        # logger.debug("111")
        # print(res_json)
        
        res = {}
        res['error_code'] = None
        res['error_message'] = None
  
        if len(res_json['errors']) > 0 :
            res['error_code'] = res_json['errors'][0]['errCode']
            res['error_message'] = res_json['errors'][0]['errorMessage']
            # res['error_message'] = error_payment_creditfacility_registerbuyer_post[str(res['error_code'])]
            return {
                'statusCode': 400,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res_json)
                'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
            }
        
        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            # 'body': json.dumps(res_json)
            'body': json.dumps(res_json, default=str, ensure_ascii=False, indent=2)
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

def get_value(key, items):
    value = None
    if key in items:
        value = items[key]
        if isinstance(value, str):
            value = value.strip()
    return value

def error_400(message, code = None):
    body = {
        "result" : "NG",
        "errors" :[{
            'errCode': code,
            'errorMessage': message
        }]
    }
        
    return {
        'statusCode': 400,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(body)
        'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
    }
    
def error_503(code = None):
    body = {
        "result" : "NG",
        "errors" :[{
            'errCode': code,
            'errorMessage': 'Service Temporarily Unavailable'
        }]
    }
        
    return {
        'statusCode': 503,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(body)
        'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
    }
    
def error_500(code = None):
    body = {
        "result" : "NG",
        "errors" :[{
            'errCode': code,
            'errorMessage': 'システム管理者ご連絡してください。'
        }]
    }
        
    return {
        'statusCode': 500,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(body)
        'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
    }

        