import os
import json
import requests
import subprocess
import datetime
import csv
import inspect
from Crypto.Cipher import AES
from Crypto.Random import get_random_bytes
from Crypto.Util import Padding
from hashlib import pbkdf2_hmac

from datetime import datetime as dt

from common.auth0.v2.component import Auth0Component

from common.pdbc.component import *
from model import user_infrastructure
from model import mscone_lic
from model import billing_infrastructure

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

import global_value as GV

RESPONSE_HEADERS = GV.RESPONSE_HEADERS

from error_function import error_handling

# 設定ファイル
import boto3
# BUCKET_NAME = 'env-mcl-mgmt-phase3'
# PATH_NAME = 'user-infrastructure/'
# OBJECT_KEY_NAME = 'config.json'
s3 = boto3.resource('s3')
 
def lambda_handler(event, context):
    
    print(event)
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)

        if event['stageVariables']['env'] is None:
            res = {}
            res['error_code'] = ''
            res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
            return {
                'statusCode': 500,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res)
                'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
            }
        
        GV.ENV = event['stageVariables']['env'].upper()

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/'
        OBJECT_KEY_NAME = 'config.json'

        bucket = s3.Bucket(BUCKET_NAME)
        obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
        response = obj.get()    
        body = response['Body'].read()
        ENV_CONFIG = json.loads(body.decode('utf-8'))
        
        GV.CONFIG = {}
        GV.CONFIG['AUTH0_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_AUDIENCE']
        GV.CONFIG['AUTH0_CLIENT_ID'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_ID']
        GV.CONFIG['AUTH0_CLIENT_SECRET'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_SECRET']
        GV.CONFIG['AUTH0_DOMAIN'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_DOMAIN']
        # GV.CONFIG['AUTH0_ROLE_IDS'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLE_IDS']
        # フェーズ2 ------------------------S
        GV.CONFIG['AUTH0_ROLES'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLES']
        # フェーズ2 ------------------------E
        GV.CONFIG['API_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'API_AUDIENCE']
        GV.CONFIG['ALGORITHMS'] = ["RS256"]
        
        GV.CONFIG_MSCONE_LIC = {}
        GV.CONFIG_MSCONE_LIC['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_MSCONE_LIC['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PORT']
        GV.CONFIG_MSCONE_LIC['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PASSWORD']
        
        GV.CONFIG_COMN_PF = {}
        GV.CONFIG_COMN_PF['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_COMN_PF['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PORT']
        GV.CONFIG_COMN_PF['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_COMN_PF['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_COMN_PF['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PASSWORD']
        
        GV.CONFIG_PASSPHRASE = {}
        # GV.CONFIG_PASSPHRASE['PASSPHRASE'] = 'password123'
        GV.CONFIG_PASSPHRASE['PASSPHRASE'] = ENV_CONFIG[GV.ENV]['PASSPHRASE']['PASSPHRASE']
        
        res = {}
        
        print(event['httpMethod'])
        print(event['path'])
        if event['httpMethod'] == 'GET':
            # GETの場合最後に"/"が付く
            if event['path'] == '/rds/user_infrastructure/m_contract_product/':
                # 
                res = get_data_from_user_infrastructure_m_contract_product(event, context)
            elif event['path'] == '/rds/user_infrastructure/t_entry/' or event['path'] == '/rds/user_infrastructure/t_entry':
                # 
                res = get_data_from_user_infrastructure_t_entry(event, context)
            # フェーズ3 ------------------------S
            elif event['path'] == '/rds/user_infrastructure/t_manage_request/' or event['path'] == '/rds/user_infrastructure/t_manage_request':
                # 
                res = get_data_from_user_infrastructure_t_manage_request(event, context)
            elif event['path'] == '/rds/user_infrastructure/t_manage_request_contract/' or event['path'] == '/rds/user_infrastructure/t_manage_request_contract':
                # 
                res = get_data_from_user_infrastructure_t_manage_request_contract(event, context)
            elif event['path'] == '/rds/user_infrastructure/t_manage_request_workshop/' or event['path'] == '/rds/user_infrastructure/t_manage_request_workshop':
                # 
                res = get_data_from_user_infrastructure_t_manage_request_workshop(event, context)
            # フェーズ3 ------------------------E    
            elif event['path'] == '/rds/user_infrastructure/m_send_mail/' or event['path'] == '/rds/user_infrastructure/m_send_mail':
                # 
                res = get_data_from_user_infrastructure_m_send_mail(event, context)
            elif event['path'] == '/rds/billing_infrastructure/m_services_and_related_sales_categories/' or event['path'] == '/rds/billing_infrastructure/m_services_and_related_sales_categories':
                # 
                res = get_data_from_billing_infrastructure_m_services_and_related_sales_categories(event, context)
            elif event['path'] == '/rds/billing_infrastructure/m_services/' or event['path'] == '/rds/billing_infrastructure/m_services':
                # 
                res = get_data_from_billing_infrastructure_m_services(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_company/' or event['path'] == '/rds/user_infrastructure/m_company':
                # 
                res = get_data_from_user_infrastructure_m_company(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract/' or event['path'] == '/rds/user_infrastructure/m_contract':
                # 
                res = get_data_from_user_infrastructure_m_contract(event, context)
            elif event['path'] == '/rds/user_infrastructure/t_entry_1/' or event['path'] == '/rds/user_infrastructure/t_entry_1':
                # 
                res = get_data_from_user_infrastructure_t_entry_1(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_user/' or event['path'] == '/rds/user_infrastructure/m_user':
                # 
                res = get_data_from_user_infrastructure_m_user(event, context)
            elif event['path'] == '/rds/mscone_lic/m_company' or event['path'] == '/rds/mscone_lic/m_company/':
                # 
                res = get_data_from_mscone_lic_m_company(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_sql' or event['path'] == '/rds/user_infrastructure/m_contract_sql/':
                # 
                res = get_data_user_infrastructure_m_contract_sql(event, context)    
            elif event['path'] == '/rds/user_infrastructure/m_contract_notification_sql' or event['path'] == '/rds/user_infrastructure/m_contract_notification_sql/':
                # 
                res = get_data_user_infrastructure_m_contract_notification_sql(event, context) 
            elif event['path'] == '/rds/user_infrastructure/m_contract_notification_sql2' or event['path'] == '/rds/user_infrastructure/m_contract_notification_sql2/':
                # 
                res = get_data_user_infrastructure_m_contract_notification_sql2(event, context)  
            elif event['path'] == '/rds/user_infrastructure/t_manage_request_sql' or event['path'] == '/rds/user_infrastructure/t_manage_request_sql/':
                # 
                res = get_data_user_infrastructure_t_manage_request_sql(event, context) 
            elif event['path'] == '/rds/user_infrastructure/t_manage_request_service_id_sql' or event['path'] == '/rds/user_infrastructure/t_manage_request_service_id_sql/':
                # 
                res = get_data_user_infrastructure_t_manage_request_service_id_sql(event, context) 
            elif event['path'] == '/rds/user_infrastructure/t_entry_mail_sql' or event['path'] == '/rds/user_infrastructure/t_entry_mail_sql/':
                # 
                res = get_data_mail_t_entry_sql(event, context)  
            elif event['path'] == '/rds/user_infrastructure/m_update_company_info_history' or event['path'] == '/rds/user_infrastructure/m_update_company_info_history/':
                # 
                res = get_data_from_m_update_company_info_history_sql(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_after_restart' or event['path'] == '/rds/user_infrastructure/m_contract_after_restart/':
                # 
                res = get_data_user_infrastructure_m_contract_after_restart_sql(event, context)
            # -----------障害 #4909 利用料金の上限以上------20231213-------------------S     
            elif event['path'] == '/rds/user_infrastructure/m_contract_stop' or event['path'] == '/rds/user_infrastructure/m_contract_stop/':
                # 
                res = get_data_user_infrastructure_m_contract_stop_sql(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_stop_amount' or event['path'] == '/rds/user_infrastructure/m_contract_stop_amount/':
                # 
                res = get_data_user_infrastructure_m_contract_stop_amount_sql(event, context)
            # -----------障害 #4909 利用料金の上限以上------20231213-------------------E
            # フェーズ2 ------------------------E
            elif event['path'] == '/rds/user_infrastructure/service_id_system_id_SQL' or event['path'] == '/rds/user_infrastructure/service_id_system_id_SQL/':
                # 
                res = get_data_service_id_system_id_sql(event, context) 
            elif event['path'] == '/rds/user_infrastructure/m_cloud_strage' or event['path'] == '/rds/user_infrastructure/m_cloud_strage/':
                # クラウドストレージマスタ
                res = get_data_user_infrastructure_m_cloud_strage_sql(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_cloud_strage_check' or event['path'] == '/rds/user_infrastructure/m_cloud_strage_check/':
                # クラウドストレージマスタ
                res = get_data_user_infrastructure_m_cloud_strage_check_sql(event, context)
            
            # 申込ポータルサイト 申込ポータルサイトアプリ確定設定
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_app_settings_confirmed' or event['path'] == '/rds/user_infrastructure/m_entry_site_app_settings_confirmed/':
                # 
                res = get_data_user_infrastructure_m_entry_site_app_settings_confirmed(event, context) 
            # 申込ポータルサイト 申込ポータルサイトアンケート確定管理
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_questionnaire_manage_confirmed' or event['path'] == '/rds/user_infrastructure/m_entry_site_questionnaire_manage_confirmed/':
                # 
                res = get_data_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(event, context)
            # 申込ポータルサイト 申込ポータルサイト資料請求確定管理
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed' or event['path'] == '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed/':
                # 
                res = get_data_user_infrastructure_m_entry_site_document_request_manage_confirmed(event, context)
            elif event['path'] == '/rds/mscone_lic/bridge_instance_id_SQL' or event['path'] == '/rds/mscone_lic/bridge_instance_id_SQL/':
                # 
                res = get_data_mscone_lic_bridge_instance_id_SQL(event, context)
            # --------------------0611---------------S
            elif event['path'] == '/rds/user_infrastructure/view_product_groups_billing_identifier' or event['path'] == '/rds/user_infrastructure/view_product_groups_billing_identifier/':
                # クラウドストレージマスタ
                res = get_data_user_infrastructure_view_product_groups_billing_identifier(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_product_check/' or event['path'] == '/rds/user_infrastructure/m_contract_product_check':
                # 
                res = get_data_from_user_infrastructure_m_contract_product_check(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_regular_products/' or event['path'] == '/rds/user_infrastructure/m_regular_products':
                # 
                res = get_data_from_user_infrastructure_m_regular_products(event, context)
            # --------------------0611---------------E
            # --------------------0704---------------S
            elif event['path'] == '/rds/user_infrastructure/m_auth0_management' or event['path'] == '/rds/user_infrastructure/m_auth0_management/':
                # Auth0のtenant一覧
                res = get_data_user_infrastructure_m_auth0_management_sql(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_auth0_management_list' or event['path'] == '/rds/user_infrastructure/m_auth0_management_list/':
                # Auth0のtenant一覧
                res = get_data_user_infrastructure_m_auth0_management_list_sql(event, context)
            # --------------------0704---------------E

        elif event['httpMethod'] == 'POST':
            if event['path'] == '/rds/user_infrastructure/t_entry':
                # 
                res = set_data_to_user_infrastructure_t_entry(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_company':
                # 
                res = set_data_to_user_infrastructure_m_company(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_user':
                # 
                res = set_data_to_user_infrastructure_m_user(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_app_settings_confirmed':
                # 
                res = set_data_to_user_infrastructure_m_entry_site_app_settings_confirmed(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed':
                # 
                res = set_data_to_user_infrastructure_m_entry_site_document_request_manage_confirmed(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_questionnaire_manage_confirmed':
                # 
                res = set_data_to_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed_del':
                # 
                res = del_data_to_user_infrastructure_m_entry_site_document_request_manage_confirmed(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_entry_site_del':
                # 
                res = del_data_to_user_infrastructure_m_entry_site(event, context)
            # フェーズ2 ------------------------S
            elif event['path'] == '/rds/user_infrastructure/m_update_company_info_history' or event['path'] == '/rds/user_infrastructure/m_update_company_info_history/':
                # 
                res = set_data_to_user_infrastructure_m_update_company_info_history(event, context)
            # フェーズ2 ------------------------E
            elif event['path'] == '/rds/user_infrastructure/m_contract':
                # 
                res = set_data_to_user_infrastructure_m_contract(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_product':
                # 
                res = set_data_to_user_infrastructure_m_contract_product(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_new_biz_sys_sales_category':
                # 
                res = set_data_to_user_infrastructure_m_new_biz_sys_sales_category(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_new_biz_sys_info':
                # 
                res = set_data_to_user_infrastructure_m_new_biz_sys_info(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_send_mail':
                # 
                res = set_data_to_user_infrastructure_m_send_mail(event, context)
            # フェーズ2 ------------------------S
            elif event['path'] == '/rds/user_infrastructure/m_service_stop_history' or event['path'] == '/rds/user_infrastructure/m_service_stop_history/':
                # 
                res = set_data_to_user_infrastructure_m_service_stop_history(event, context)
            # フェーズ2 ------------------------E
            elif event['path'] == '/rds/mscone_lic/m_company':
                # 
                res = set_data_to_mscone_lic_m_company(event, context)
            elif event['path'] == '/rds/mscone_lic/m_directory_user':
                # 
                res = set_data_to_mscone_lic_m_directory_user(event, context)
            elif event['path'] == '/rds/billing_infrastructure/m_systems':
                # 
                res = set_data_to_billing_infrastructure_m_systems(event, context)
            elif event['path'] == '/rds/billing_infrastructure/m_services':
                # 
                res = set_data_to_billing_infrastructure_m_services(event, context)
            elif event['path'] == '/rds/billing_infrastructure/m_regular_products':
                # 
                res = set_data_to_billing_infrastructure_m_regular_products(event, context)
            # フェーズ2 ------------------------S
            elif event['path'] == '/rds/billing_infrastructure/m_services_and_related_sales_categories' or event['path'] == '/rds/billing_infrastructure/m_services_and_related_sales_categories/':
                # 
                res = set_data_to_billing_infrastructure_m_services_and_related_sales_categories(event, context)
            elif event['path'] == '/rds/billing_infrastructure/m_estimated_order_amounts' or event['path'] == '/rds/billing_infrastructure/m_estimated_order_amounts/':
                # 
                res = set_data_to_billing_infrastructure_m_estimated_order_amounts(event, context)
            elif event['path'] == '/rds/billing_infrastructure/tax_rate' or event['path'] == '/rds/billing_infrastructure/tax_rate/':
                # 
                res = set_data_to_billing_infrastructure_tax_rate(event, context)
            # フェーズ2 ------------------------E
            elif event['path'] == '/rds/user_infrastructure/m_cloud_strage':
                # 
                res = set_data_to_user_infrastructure_m_cloud_strage(event, context)
            #  ------0611------------------S
            elif event['path'] == '/rds/user_infrastructure/t_contract_request_confirmed':
                # 
                res = set_data_to_user_infrastructure_t_contract_request_confirmed(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_product_post':
                # 
                res = set_data_to_user_infrastructure_m_contract_product_post(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_product_insert':
                # 
                res = set_data_to_user_infrastructure_m_contract_product_insert(event, context)    

                
            #  -------0611-----------------S
        elif event['httpMethod'] == 'PUT':
            if event['path'] == '/rds/mscone_lic/m_directory_user' or event['path'] == '/rds/mscone_lic/m_directory_user/':
                # 
                res = update_data_to_mscone_lic_m_directory_user(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_company' or event['path'] == '/rds/user_infrastructure/m_company/':
                # 
                res = update_data_to_user_infrastructure_m_company(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract' or event['path'] == '/rds/user_infrastructure/m_contract/':
                # 
                res = update_data_to_user_infrastructure_m_contract(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_service_stop_history' or event['path'] == '/rds/user_infrastructure/m_service_stop_history/':
                # 
                res = update_data_to_user_infrastructure_m_service_stop_history(event, context)
                 # フェーズ3 ------------------------S
            elif event['path'] == '/rds/user_infrastructure/t_manage_request' or event['path'] == '/rds/user_infrastructure/t_manage_request/':
                # 
                res = update_data_to_user_infrastructure_t_manage_request(event, context)     
                 # フェーズ3 ------------------------E
            
        # フェーズ2 ------------------------E
        elif event['httpMethod'] == 'DELETE':
            print(event['httpMethod'])
            print(event['path'])
            # DELETEの場合最後に"/"が付く
            if event['path'] == '/rds/billing_infrastructure/m_services/':
                # 
                res = delete_data_from_billing_infrastructure_m_services(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_contract_product/':
                # 
                res = delete_data_from_user_infrastructure_m_contract_product(event, context)
            # フェーズ2 ------------------------S
            elif event['path'] == '/rds/user_infrastructure/m_user':
                # 
                res = delete_data_from_user_infrastructure_m_user(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_new_biz_sys_info' or event['path'] == '/rds/user_infrastructure/m_new_biz_sys_info/':
                # 
                res = delete_data_from_user_infrastructure_m_new_biz_sys_info(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_new_biz_sys_info' or event['path'] == '/rds/user_infrastructure/m_new_biz_sys_info/':
                # 
                res = delete_data_from_user_infrastructure_m_new_biz_sys_info(event, context)
            elif event['path'] == '/rds/user_infrastructure/m_new_biz_sys_sales_category' or event['path'] == '/rds/user_infrastructure/m_new_biz_sys_sales_category/':
                # 
                res = delete_data_from_user_infrastructure_m_new_biz_sys_sales_category(event, context)
            elif event['path'] == '/rds/billing_infrastructure/tax_rate' or event['path'] == '/rds/billing_infrastructure/tax_rate/':
                # 
                res = delete_data_from_billing_infrastructure_tax_rate(event, context)
            elif event['path'] == '/rds/billing_infrastructure/m_estimated_order_amounts' or event['path'] == '/rds/billing_infrastructure/m_estimated_order_amounts/':
                # 
                res = delete_data_from_billing_infrastructure_m_estimated_order_amounts(event, context)
            # フェーズ2 ------------------------E
        logger.info(res)
    
        return res
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# --------------------------------------------------------------------
# Auth0 S

def get_access_token_info(auth):
    auth0 = Auth0Component(GV.CONFIG)
    return auth0.get_access_token_info(auth)

# Auth0 E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure S

# --------------------------------------------------------------------
# user_infrastructure t_entry S

# フェーズ2 ------------------------S

def get_data_from_user_infrastructure_t_entry_1(event, context):
    
    logger.info('get_data_from_user_infrastructure_t_entry_1!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                        
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
                    
        m_param = user_infrastructure.TEntry()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key]['value'])
        result = pdbc.select('user_infrastructure', m_param)
        
        # print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_from_user_infrastructure_t_manage_request(event, context):
    
    logger.info('get_data_from_user_infrastructure_t_manage_request!!!')

    # フェーズ3 20230830 ------------------------S
    user_metadata = None
    # フェーズ3 20230830 ------------------------E

    # --------------------------------------------------------------------
    # Auth0 S
    
    # 通常ユーザー管理者 のみアクセス可能
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        logger.info(event_headers)

        # 検証
        if 'Authorization' not in event_headers:
            msg = '認証情報が正しくありません。'
            return error_400(msg)
        
        access_token_info = get_access_token_info(event_headers["Authorization"])
        
        # if 'my_roles' not in access_token_info:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        # フェーズ3 20230830 ------------------------S

        if 'user_metadata' not in access_token_info:
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        user_metadata = access_token_info['user_metadata']

        if 'data' not in user_metadata:
            print(''' 'data' not in user_metadata ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        if type(user_metadata['data']) != list:
            print(''' type(user_metadata['data']) != list ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        if len(user_metadata['data']) < 1:
            print(''' len(user_metadata['data']) < 1 ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------E
        
    # Auth0 E
    # --------------------------------------------------------------------
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_CONTRACT_PRODUCT_WHERE, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        #データベース登録
        logger.info(GV.CONFIG_COMN_PF)
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        auth0_user_id = ''
        service_id = ''
        system_id = ''
        company_code = ''
        if 'auth0_user_id' in event_body:
            if 'value' in event_body['auth0_user_id']:
                auth0_user_id = event_body['auth0_user_id']['value']
            
        if 'auth0_user_id' in query_string_parameters:
            if type(query_string_parameters['auth0_user_id']) is str:
                tmp = json.loads(query_string_parameters['auth0_user_id'])
                if 'value' in tmp:
                    auth0_user_id = tmp['value']
            else:
                if 'value' in query_string_parameters['auth0_user_id']:
                    auth0_user_id = query_string_parameters['auth0_user_id']['value']
                    
        if 'service_id' in query_string_parameters:
            if type(query_string_parameters['service_id']) is str:
                tmp = json.loads(query_string_parameters['service_id'])
                if 'value' in tmp:
                    service_id = tmp['value']
            else:
                if 'value' in query_string_parameters['service_id']:
                    service_id = query_string_parameters['service_id']['value']
                    
        if 'system_id' in query_string_parameters:
            if type(query_string_parameters['system_id']) is str:
                tmp = json.loads(query_string_parameters['system_id'])
                if 'value' in tmp:
                    system_id = tmp['value']
            else:
                if 'value' in query_string_parameters['system_id']:
                    system_id = query_string_parameters['system_id']['value']
                    
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    company_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    company_code = query_string_parameters['company_code']['value']
        
        if auth0_user_id == '':
            msg = 'パラメーター「auth0_user_id」が正しく設定されていません。'
            return error_400(msg)
        if system_id == '':
            msg = 'パラメーター「system_id」が正しく設定されていません。'
            return error_400(msg)
        if service_id == '':
            msg = 'パラメーター「service_id」が正しく設定されていません。'
            return error_400(msg)
        if company_code == '':
            msg = 'パラメーター「company_code」が正しく設定されていません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------S
        
        if user_metadata is not None:
            is_admin_user = False
            for d in user_metadata['data']:
                if 'company_code' in d and 'system_id' in d and 'service_id' in d:
                    if d['company_code'] == company_code and d['system_id'] == system_id and d['service_id'] == service_id:
                        if 'roles' in d:
                            if type(d['roles']) == list:
                                if 'admin_user' in d['roles']:
                                    is_admin_user = True
            
            if is_admin_user == False:
                print('is_admin_user')
                print(is_admin_user)
                msg = 'アクセス権限がありません。'
                return error_400(msg)

        # フェーズ3 20230830 ------------------------E

        if auth0_user_id != '':
            sql = '''
                 SELECT
                    user_infrastructure.t_manage_request.status  --システムID                    
                FROM
                    user_infrastructure.t_manage_request
                WHERE
                    user_infrastructure.t_manage_request.auth0_user_id = %(auth0_user_id)s
                and user_infrastructure.t_manage_request.system_id = %(system_id)s
                and user_infrastructure.t_manage_request.service_id = %(service_id)s
                and user_infrastructure.t_manage_request.company_code = %(company_code)s
                LIMIT 1
            '''
            param = {}
            param["auth0_user_id"] = auth0_user_id
            param["system_id"] = system_id
            param["service_id"] = service_id
            param["company_code"] = company_code
            result = pdbc.select_param(sql, param)
        
            if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
                return result
            
            res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_from_user_infrastructure_t_manage_request_contract(event, context):
    
    logger.info('get_data_from_user_infrastructure_t_manage_request_contract!!!')

    # フェーズ3 20230830 ------------------------S
    user_metadata = None
    # フェーズ3 20230830 ------------------------E

    # --------------------------------------------------------------------
    # Auth0 S
    
    # 通常ユーザー管理者 のみアクセス可能
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        logger.info(event_headers)

        # 検証
        if 'Authorization' not in event_headers:
            msg = '認証情報が正しくありません。'
            return error_400(msg)
        
        access_token_info = get_access_token_info(event_headers["Authorization"])
        
        # if 'my_roles' not in access_token_info:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        # フェーズ3 20230830 ------------------------S

        if 'user_metadata' not in access_token_info:
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        user_metadata = access_token_info['user_metadata']

        if 'data' not in user_metadata:
            print(''' 'data' not in user_metadata ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        if type(user_metadata['data']) != list:
            print(''' type(user_metadata['data']) != list ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        if len(user_metadata['data']) < 1:
            print(''' len(user_metadata['data']) < 1 ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------E
        
    # Auth0 E
    # --------------------------------------------------------------------
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_CONTRACT_PRODUCT_WHERE, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        #データベース登録
        logger.info(GV.CONFIG_COMN_PF)
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        auth0_user_id = ''
        service_id = ''
        system_id = ''
        company_code = ''
        if 'auth0_user_id' in event_body:
            if 'value' in event_body['auth0_user_id']:
                auth0_user_id = event_body['auth0_user_id']['value']
            
        if 'auth0_user_id' in query_string_parameters:
            if type(query_string_parameters['auth0_user_id']) is str:
                tmp = json.loads(query_string_parameters['auth0_user_id'])
                if 'value' in tmp:
                    auth0_user_id = tmp['value']
            else:
                if 'value' in query_string_parameters['auth0_user_id']:
                    auth0_user_id = query_string_parameters['auth0_user_id']['value']
                    
        if 'service_id' in query_string_parameters:
            if type(query_string_parameters['service_id']) is str:
                tmp = json.loads(query_string_parameters['service_id'])
                if 'value' in tmp:
                    service_id = tmp['value']
            else:
                if 'value' in query_string_parameters['service_id']:
                    service_id = query_string_parameters['service_id']['value']
                    
        if 'system_id' in query_string_parameters:
            if type(query_string_parameters['system_id']) is str:
                tmp = json.loads(query_string_parameters['system_id'])
                if 'value' in tmp:
                    system_id = tmp['value']
            else:
                if 'value' in query_string_parameters['system_id']:
                    system_id = query_string_parameters['system_id']['value']
                    
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    company_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    company_code = query_string_parameters['company_code']['value']
        
        if auth0_user_id == '':
            msg = 'パラメーター「auth0_user_id」が正しく設定されていません。'
            return error_400(msg)
        if system_id == '':
            msg = 'パラメーター「system_id」が正しく設定されていません。'
            return error_400(msg)
        if service_id == '':
            msg = 'パラメーター「service_id」が正しく設定されていません。'
            return error_400(msg)
        if company_code == '':
            msg = 'パラメーター「company_code」が正しく設定されていません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------S
        
        if user_metadata is not None:
            is_admin_user = False
            for d in user_metadata['data']:
                if 'company_code' in d and 'system_id' in d and 'service_id' in d:
                    if d['company_code'] == company_code and d['system_id'] == system_id and d['service_id'] == service_id:
                        if 'roles' in d:
                            if type(d['roles']) == list:
                                if 'admin_user' in d['roles']:
                                    is_admin_user = True
            
            if is_admin_user == False:
                print('is_admin_user')
                print(is_admin_user)
                msg = 'アクセス権限がありません。'
                return error_400(msg)

        # フェーズ3 20230830 ------------------------E

        if auth0_user_id != '':
            sql = '''
                 SELECT
                    user_infrastructure.m_contract.entry_code        -- 申込みコード
                    ,user_infrastructure.t_manage_request.system_id  --システムID
                    ,user_infrastructure.t_manage_request.service_id  --サービスID
                    ,user_infrastructure.t_manage_request.status  --ステータス
                    ,user_infrastructure.t_manage_request.status as entry_name  -- ステータス
                    ,user_infrastructure.m_workshop_event_date.workshop_event_date  -- ワークショップ開催日
                    ,user_infrastructure.m_workshop_event_date.workshop_event_time_division  -- ワークショップ時刻区分
                    , user_infrastructure.m_company.company_name    -- 企業名
                    , user_infrastructure.m_company.company_name_kana -- 企業名(カナ)
                    , user_infrastructure.m_company.company_zipcode -- 郵便番号
                    , user_infrastructure.m_company.company_address_pref -- 住所(都道府県)
                    , user_infrastructure.m_company.company_address_1 -- 住所1
                    , user_infrastructure.m_company.company_address_2 -- 住所2
                    , user_infrastructure.m_company.company_address_3 -- 住所3
                    , user_infrastructure.m_company.company_address_1_kana -- 住所1(カナ)
                    , user_infrastructure.m_company.company_address_2_kana -- 住所2(カナ)
                    , user_infrastructure.m_company.company_address_3_kana -- 住所3(カナ)
                    , user_infrastructure.m_company.company_tel_1   -- 電話番号1
                    , user_infrastructure.m_company.company_fax_1   -- FAX1
                    , user_infrastructure.m_company.company_leader_last -- 代表者名(姓)
                    , user_infrastructure.m_company.company_leader_first -- 代表者名(名)
                    , user_infrastructure.m_company.company_leader_kana_last -- 代表者名(姓)(カナ)
                    , user_infrastructure.m_company.company_leader_kana_first -- 代表者名(名)(カナ)
                    , user_infrastructure.m_contract.contract_last_name   -- 契約者名(姓)
                    , user_infrastructure.m_contract.contract_first_name   -- 契約者名(名)
                    , user_infrastructure.m_contract.contract_last_name_kana   -- 契約者名(姓)(カナ)
                    , user_infrastructure.m_contract.contract_first_name_kana   -- 契約者名(名)(カナ)
                    , user_infrastructure.m_contract.contract_department -- 契約者部署名
                    , user_infrastructure.m_contract.contract_position -- 契約者役職
                    , user_infrastructure.m_contract.contract_email -- 契約者メールアドレス
                    , user_infrastructure.m_contract.contract_zipcode -- 契約者郵便番号
                    , user_infrastructure.m_contract.contract_address_pref -- 契約者都道府県
                    , user_infrastructure.m_contract.contract_address_1 -- 契約者住所1
                    , user_infrastructure.m_contract.contract_address_2 -- 契約者住所2
                    , user_infrastructure.m_contract.contract_address_3 -- 契約者住所3
                    , user_infrastructure.m_contract.contract_tel_1 -- 契約者電話番号1
                    , user_infrastructure.m_user.name_last AS administrator_name_last -- 管理者名(姓)
                    , user_infrastructure.m_user.name_first AS administrator_name_first -- 管理者名(名)
                    , user_infrastructure.m_user.name_last_kana AS administrator_name_last_kana -- 管理者名(姓)(カナ)
                    , user_infrastructure.m_user.name_first_kana AS administrator_name_first_kana -- 管理者名(名)(カナ)
                    , user_infrastructure.m_user.department AS administrator_department -- 管理者部署名
                    , user_infrastructure.m_user.position AS administrator_position -- 管理者役職
                    , user_infrastructure.m_user.email AS administrator_email -- 管理者メールアドレス
                    , user_infrastructure.m_user.tel AS administrator_tel_1 -- 管理者電話番号1
                    , user_infrastructure.m_contract.invoice_sending_method -- 請求書の送付方法
                    , user_infrastructure.m_company.company_leader_date_of_birth -- 代表者の生年月日
                    , user_infrastructure.m_company.customer_notes -- 備考欄
                    , user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyer -- GMO掛け払いのデータ更新あり
                    , user_infrastructure.m_contract.contract_id
                    , user_infrastructure.m_contract.salesman_name
                    , user_infrastructure.m_contract.payment_method
                    , user_infrastructure.m_contract.subscription_start_date
                    , user_infrastructure.m_contract.subscription_end_date
                    , user_infrastructure.m_contract.subscription_name
                    , user_infrastructure.m_contract.subscription_notes -- 備考
                    , user_infrastructure.m_contract.udate -- 最終更新日時
                    , user_infrastructure.m_contract.temp_service_sleep_start_date -- 一時休止予定日
                    , user_infrastructure.m_contract.temp_service_sleep_restart_date -- 一時休止からの再開予定日
                    , user_infrastructure.m_contract.ndes_service_stop_start_date -- 停止予定日
                    , user_infrastructure.m_contract.ndes_service_stop_restart_date -- 停止からの再開予定日
                    , user_infrastructure.m_contract.reason_for_termination -- 解約理由
                    , user_infrastructure.m_contract.termination_of_service_mail_send_date -- サービスの解約メール送信日
                    , user_infrastructure.m_user.auth0_user_id 
                    , billing_infrastructure.m_systems.system_name   -- システム名
                    , billing_infrastructure.m_services.service_name   -- サービス名
                    , billing_infrastructure.m_services.use_amount_upper_limit_setting_flag   -- 利用上限金額設定使用フラグ
                    , user_infrastructure.m_company.update_date        -- 最終更新日時
                    , user_infrastructure.m_company.company_code       -- 企業コード
                    , user_infrastructure.m_contract.salesman_code      -- 担当営業(職番)
                    , user_infrastructure.m_update_company_info_history.update_history_id AS m_update_company_info_history_update_history_id  -- 更新履歴ID
                    , user_infrastructure.m_update_company_info_history.company_code AS m_update_company_info_history_company_code  -- company_code
                    , user_infrastructure.m_update_company_info_history.auth0_user_id AS m_update_company_info_history_auth0_user_id  -- Auth0ユーザーID
                    , user_infrastructure.m_update_company_info_history.name_last AS m_update_company_info_history_name_last  -- 名前(姓)
                    , user_infrastructure.m_update_company_info_history.name_first AS m_update_company_info_history_name_first  -- 名前(名)
                    , user_infrastructure.m_update_company_info_history.email AS m_update_company_info_history_email  -- メールアドレス
                    , user_infrastructure.m_update_company_info_history.update_from AS m_update_company_info_history_update_from  -- 更新元
                    , user_infrastructure.m_update_company_info_history.update_date AS m_update_company_info_history_update_date  -- 更新日                    
        -- バグ #6962, user_infrastructure.m_file_manage.file_path AS terms_of_use_url -- 利用規約URL
                    , user_infrastructure.m_entry_site_app_settings_confirmed.contract_terms_file_url AS terms_of_use_url -- 利用規約URL -- バグ #6962
                    , user_infrastructure.m_contract.amount_upper_limit_flg -- 利用料金上限設定フラグ   2023/12/13
                    , user_infrastructure.m_contract.amount_upper_limit -- 利用料金上限金額   2023/12/13
                    , user_infrastructure.m_contract.amount_upper_limit_stop_flg -- 利用中止フラグ   2023/12/13
                    , billing_infrastructure.view_used_amounts_this_month.used_amounts -- 利用料金の合計値   2023/12/13
                    , billing_infrastructure.m_services.system_configuration_type     ---システム構成タイプ
                    , user_infrastructure.m_env_stock.env_id  --環境ストックID
                    , t_contract_request_confirmed.contract_product_request  -- 契約商品内容  2024/06/11
                FROM
                    user_infrastructure.t_manage_request    
                    INNER JOIN user_infrastructure.m_company 
                        ON user_infrastructure.t_manage_request.company_code = user_infrastructure.m_company.company_code
                    INNER JOIN user_infrastructure.m_user 
                        ON user_infrastructure.m_user.auth0_user_id = user_infrastructure.t_manage_request.auth0_user_id
                        AND user_infrastructure.m_user.company_code = user_infrastructure.t_manage_request.company_code 
                    INNER JOIN user_infrastructure.m_contract 
                        ON user_infrastructure.m_contract.contract_id = user_infrastructure.t_manage_request.contract_id
                    INNER JOIN user_infrastructure.m_auth0_user_info
                        ON user_infrastructure.m_auth0_user_info.auth0_user_id = user_infrastructure.t_manage_request.auth0_user_id
                    INNER JOIN billing_infrastructure.m_systems
                        ON user_infrastructure.t_manage_request.system_id = billing_infrastructure.m_systems.system_id
                    LEFT JOIN billing_infrastructure.view_used_amounts_this_month -- 利用料金の合計値   2023/12/13
                        ON billing_infrastructure.view_used_amounts_this_month.company_code = user_infrastructure.m_contract.company_code -- 利用料金の合計値   2023/12/13
                        AND billing_infrastructure.view_used_amounts_this_month.system_name = billing_infrastructure.m_systems.system_name  -- 利用料金の合計値   2023/12/13
                    LEFT JOIN user_infrastructure.m_update_company_info_history
                        ON user_infrastructure.t_manage_request.auth0_user_id = user_infrastructure.m_update_company_info_history.auth0_user_id
                        AND user_infrastructure.t_manage_request.company_code = user_infrastructure.m_update_company_info_history.company_code
                        AND user_infrastructure.m_update_company_info_history.update_date IS NOT NULL
                    LEFT JOIN user_infrastructure.t_workshop_request_confirmed    
                        ON user_infrastructure.t_workshop_request_confirmed.workshop_req_id = user_infrastructure.t_manage_request.workshop_req_id
                    LEFT JOIN user_infrastructure.m_workshop_event_date    
                        ON user_infrastructure.m_workshop_event_date.workshop_event_date_id = user_infrastructure.t_workshop_request_confirmed.workshop_event_date_id
                    INNER JOIN billing_infrastructure.m_services
                        ON user_infrastructure.t_manage_request.service_id = billing_infrastructure.m_services.service_id
                --バグ #6962  LEFT JOIN user_infrastructure.m_file_manage 
                --バグ #6962      ON user_infrastructure.m_file_manage.system_id = user_infrastructure.t_manage_request.system_id 
                --バグ #6962      and user_infrastructure.m_file_manage.service_id = user_infrastructure.t_manage_request.service_id 
                --バグ #6962      and user_infrastructure.m_file_manage.file_type = 'terms'
                --バグ #6962      and user_infrastructure.m_file_manage.file_explain = '利用規約'
                LEFT JOIN user_infrastructure.m_entry_site_app_settings_confirmed -- バグ #6962
                        ON user_infrastructure.m_entry_site_app_settings_confirmed.system_id = user_infrastructure.t_manage_request.system_id -- バグ #6962
                    LEFT JOIN user_infrastructure.m_env_stock
                        ON user_infrastructure.m_env_stock.system_id = user_infrastructure.t_manage_request.system_id
                        AND user_infrastructure.m_env_stock.service_id = user_infrastructure.t_manage_request.service_id
                        AND user_infrastructure.m_env_stock.company_code = user_infrastructure.t_manage_request.company_code
                    LEFT JOIN user_infrastructure.t_contract_request_confirmed
                        ON user_infrastructure.t_contract_request_confirmed.contract_req_id = user_infrastructure.t_manage_request.contract_req_id
                WHERE
                    user_infrastructure.m_user.auth0_user_id = %(auth0_user_id)s
                and user_infrastructure.t_manage_request.system_id = %(system_id)s
                and user_infrastructure.t_manage_request.service_id = %(service_id)s
                and user_infrastructure.t_manage_request.company_code = %(company_code)s
                ORDER BY
                    user_infrastructure.m_update_company_info_history.update_date DESC
                LIMIT 1
            '''
            param = {}
            param["auth0_user_id"] = auth0_user_id
            param["system_id"] = system_id
            param["service_id"] = service_id
            param["company_code"] = company_code
            logger.info('sql')
            logger.info(sql)
            logger.info('param')
            logger.info(param)
            result = pdbc.select_param(sql, param)
        
            if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
                return result
            
            res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_from_user_infrastructure_t_manage_request_workshop(event, context):
    
    logger.info('get_data_from_user_infrastructure_t_manage_request_workshop!!!')

    # フェーズ3 20230830 ------------------------S
    user_metadata = None
    # フェーズ3 20230830 ------------------------E

    # --------------------------------------------------------------------
    # Auth0 S
    
    # 通常ユーザー管理者 のみアクセス可能
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        logger.info(event_headers)

        # 検証
        if 'Authorization' not in event_headers:
            msg = '認証情報が正しくありません。'
            return error_400(msg)
        
        access_token_info = get_access_token_info(event_headers["Authorization"])
        
        # if 'my_roles' not in access_token_info:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        # フェーズ3 20230830 ------------------------S

        if 'user_metadata' not in access_token_info:
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        user_metadata = access_token_info['user_metadata']

        if 'data' not in user_metadata:
            print(''' 'data' not in user_metadata ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        if type(user_metadata['data']) != list:
            print(''' type(user_metadata['data']) != list ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        if len(user_metadata['data']) < 1:
            print(''' len(user_metadata['data']) < 1 ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------E
        
    # Auth0 E
    # --------------------------------------------------------------------
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_CONTRACT_PRODUCT_WHERE, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        #データベース登録
        logger.info(GV.CONFIG_COMN_PF)
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        auth0_user_id = ''
        service_id = ''
        system_id = ''
        company_code = ''
        if 'auth0_user_id' in event_body:
            if 'value' in event_body['auth0_user_id']:
                auth0_user_id = event_body['auth0_user_id']['value']
            
        if 'auth0_user_id' in query_string_parameters:
            if type(query_string_parameters['auth0_user_id']) is str:
                tmp = json.loads(query_string_parameters['auth0_user_id'])
                if 'value' in tmp:
                    auth0_user_id = tmp['value']
            else:
                if 'value' in query_string_parameters['auth0_user_id']:
                    auth0_user_id = query_string_parameters['auth0_user_id']['value']
                    
        if 'service_id' in query_string_parameters:
            if type(query_string_parameters['service_id']) is str:
                tmp = json.loads(query_string_parameters['service_id'])
                if 'value' in tmp:
                    service_id = tmp['value']
            else:
                if 'value' in query_string_parameters['service_id']:
                    service_id = query_string_parameters['service_id']['value']
                    
        if 'system_id' in query_string_parameters:
            if type(query_string_parameters['system_id']) is str:
                tmp = json.loads(query_string_parameters['system_id'])
                if 'value' in tmp:
                    system_id = tmp['value']
            else:
                if 'value' in query_string_parameters['system_id']:
                    system_id = query_string_parameters['system_id']['value']
                    
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    company_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    company_code = query_string_parameters['company_code']['value']
        
        if auth0_user_id == '':
            msg = 'パラメーター「auth0_user_id」が正しく設定されていません。'
            return error_400(msg)
        if system_id == '':
            msg = 'パラメーター「system_id」が正しく設定されていません。'
            return error_400(msg)
        if service_id == '':
            msg = 'パラメーター「service_id」が正しく設定されていません。'
            return error_400(msg)
        if company_code == '':
            msg = 'パラメーター「company_code」が正しく設定されていません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------S
        
        if user_metadata is not None:
            is_admin_user = False
            for d in user_metadata['data']:
                if 'company_code' in d and 'system_id' in d and 'service_id' in d:
                    if d['company_code'] == company_code and d['system_id'] == system_id and d['service_id'] == service_id:
                        if 'roles' in d:
                            if type(d['roles']) == list:
                                if 'admin_user' in d['roles']:
                                    is_admin_user = True
            
            if is_admin_user == False:
                print('is_admin_user')
                print(is_admin_user)
                msg = 'アクセス権限がありません。'
                return error_400(msg)

        # フェーズ3 20230830 ------------------------E

        if auth0_user_id != '':
            sql = '''
                 SELECT
                     user_infrastructure.t_manage_request.system_id  --システムID
                    ,user_infrastructure.t_manage_request.service_id  --サービスID
                    ,user_infrastructure.t_manage_request.status  --ステータス
                    ,user_infrastructure.t_manage_request.status as entry_name  -- ステータス
                    ,user_infrastructure.m_workshop_event_date.workshop_event_date  -- ワークショップ開催日
                    ,user_infrastructure.m_workshop_event_date.workshop_event_time_division  -- ワークショップ時刻区分
                    , user_infrastructure.m_company.company_name    -- 企業名
                    , user_infrastructure.m_company.company_name_kana -- 企業名(カナ)
                    , user_infrastructure.m_company.company_zipcode -- 郵便番号
                    , user_infrastructure.m_company.company_address_pref -- 住所(都道府県)
                    , user_infrastructure.m_company.company_address_1 -- 住所1
                    , user_infrastructure.m_company.company_address_2 -- 住所2
                    , user_infrastructure.m_company.company_address_3 -- 住所3
                    , user_infrastructure.m_company.company_address_1_kana -- 住所1(カナ)
                    , user_infrastructure.m_company.company_address_2_kana -- 住所2(カナ)
                    , user_infrastructure.m_company.company_address_3_kana -- 住所3(カナ)
                    , user_infrastructure.m_company.company_tel_1   -- 電話番号1
                    , user_infrastructure.m_company.company_fax_1   -- FAX1
                    , user_infrastructure.m_company.company_leader_last -- 代表者名(姓)
                    , user_infrastructure.m_company.company_leader_first -- 代表者名(名)
                    , user_infrastructure.m_company.company_leader_kana_last -- 代表者名(姓)(カナ)
                    , user_infrastructure.m_company.company_leader_kana_first -- 代表者名(名)(カナ)
                    , user_infrastructure.m_user.name_last AS administrator_name_last -- 管理者名(姓)
                    , user_infrastructure.m_user.name_first AS administrator_name_first -- 管理者名(名)
                    , user_infrastructure.m_user.name_last_kana AS administrator_name_last_kana -- 管理者名(姓)(カナ)
                    , user_infrastructure.m_user.name_first_kana AS administrator_name_first_kana -- 管理者名(名)(カナ)
                    , user_infrastructure.m_user.department AS administrator_department -- 管理者部署名
                    , user_infrastructure.m_user.position AS administrator_position -- 管理者役職
                    , user_infrastructure.m_user.email AS administrator_email -- 管理者メールアドレス
                    , user_infrastructure.m_user.tel AS administrator_tel_1 -- 管理者電話番号1
                    , user_infrastructure.m_company.company_leader_date_of_birth -- 代表者の生年月日
                    , user_infrastructure.m_company.customer_notes -- 備考欄
                    , user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyer -- GMO掛け払いのデータ更新あり
                    , user_infrastructure.m_user.auth0_user_id 
                    , billing_infrastructure.m_systems.system_name   -- システム名
                    , billing_infrastructure.m_services.service_name   -- サービス名
                    , billing_infrastructure.m_services.use_amount_upper_limit_setting_flag   -- 利用上限金額設定使用フラグ
                    , user_infrastructure.m_company.update_date        -- 最終更新日時
                    , user_infrastructure.m_company.company_code       -- 企業コード
                    , user_infrastructure.m_update_company_info_history.update_history_id AS m_update_company_info_history_update_history_id  -- 更新履歴ID
                    , user_infrastructure.m_update_company_info_history.company_code AS m_update_company_info_history_company_code  -- company_code
                    , user_infrastructure.m_update_company_info_history.auth0_user_id AS m_update_company_info_history_auth0_user_id  -- Auth0ユーザーID
                    , user_infrastructure.m_update_company_info_history.name_last AS m_update_company_info_history_name_last  -- 名前(姓)
                    , user_infrastructure.m_update_company_info_history.name_first AS m_update_company_info_history_name_first  -- 名前(名)
                    , user_infrastructure.m_update_company_info_history.email AS m_update_company_info_history_email  -- メールアドレス
                    , user_infrastructure.m_update_company_info_history.update_from AS m_update_company_info_history_update_from  -- 更新元
                    , user_infrastructure.m_update_company_info_history.update_date AS m_update_company_info_history_update_date  -- 更新日
                    , null as entry_code        -- 申込みコード
                    , null as contract_last_name   -- 契約者名(姓)
                    , null as contract_first_name   -- 契約者名(名)
                    , null as contract_last_name_kana   -- 契約者名(姓)(カナ)
                    , null as contract_first_name_kana   -- 契約者名(名)(カナ)
                    , null as contract_department -- 契約者部署名
                    , null as contract_position -- 契約者役職
                    , null as contract_email -- 契約者メールアドレス
                    , null as contract_zipcode -- 契約者郵便番号
                    , null as contract_address_pref -- 契約者都道府県
                    , null as contract_address_1 -- 契約者住所1
                    , null as contract_address_2 -- 契約者住所2
                    , null as contract_address_3 -- 契約者住所3
                    , null as contract_tel_1 -- 契約者電話番号1
                    , null as invoice_sending_method -- 請求書の送付方法
                    , null as contract_id
                    , null as salesman_name
                    , null as payment_method
                    , null as subscription_start_date
                    , null as subscription_end_date
                    , null as subscription_name
                    , null as subscription_notes -- 備考
                    , null as udate -- 最終更新日時
                    , null as temp_service_sleep_start_date -- 一時休止予定日
                    , null as temp_service_sleep_restart_date -- 一時休止からの再開予定日
                    , null as ndes_service_stop_start_date -- 停止予定日
                    , null as ndes_service_stop_restart_date -- 停止からの再開予定日
                    , null as reason_for_termination -- 解約理由
                    , null as termination_of_service_mail_send_date -- サービスの解約メール送信日
                    , null as salesman_code      -- 担当営業(職番)
                    , user_infrastructure.m_file_manage.file_path AS terms_of_use_url -- 利用規約URL
                FROM
                    user_infrastructure.t_manage_request    
                    INNER JOIN user_infrastructure.m_company 
                        ON user_infrastructure.t_manage_request.company_code = user_infrastructure.m_company.company_code
                    INNER JOIN user_infrastructure.m_user 
                        ON user_infrastructure.m_user.auth0_user_id = user_infrastructure.t_manage_request.auth0_user_id
                        AND user_infrastructure.m_user.company_code = user_infrastructure.t_manage_request.company_code 
                    INNER JOIN user_infrastructure.m_auth0_user_info
                        ON user_infrastructure.m_auth0_user_info.auth0_user_id = user_infrastructure.t_manage_request.auth0_user_id
                    INNER JOIN billing_infrastructure.m_systems
                        ON user_infrastructure.t_manage_request.system_id = billing_infrastructure.m_systems.system_id
                    LEFT JOIN user_infrastructure.m_update_company_info_history
                        ON user_infrastructure.t_manage_request.auth0_user_id = user_infrastructure.m_update_company_info_history.auth0_user_id
                        AND user_infrastructure.t_manage_request.company_code = user_infrastructure.m_update_company_info_history.company_code
                        AND user_infrastructure.m_update_company_info_history.update_date IS NOT NULL
                    LEFT JOIN user_infrastructure.t_workshop_request_confirmed    
                        ON user_infrastructure.t_workshop_request_confirmed.workshop_req_id = user_infrastructure.t_manage_request.workshop_req_id
                    LEFT JOIN user_infrastructure.m_workshop_event_date    
                        ON user_infrastructure.m_workshop_event_date.workshop_event_date_id = user_infrastructure.t_workshop_request_confirmed.workshop_event_date_id
                    INNER JOIN billing_infrastructure.m_services
                        ON user_infrastructure.t_manage_request.service_id = billing_infrastructure.m_services.service_id
                    LEFT JOIN user_infrastructure.m_file_manage 
                        ON user_infrastructure.m_file_manage.system_id = user_infrastructure.t_manage_request.system_id 
                        and user_infrastructure.m_file_manage.service_id = user_infrastructure.t_manage_request.service_id 
                        and user_infrastructure.m_file_manage.file_type = 'terms'
                        and user_infrastructure.m_file_manage.file_explain = '利用規約'
                WHERE
                    user_infrastructure.m_user.auth0_user_id = %(auth0_user_id)s
                and user_infrastructure.t_manage_request.system_id = %(system_id)s
                and user_infrastructure.t_manage_request.service_id = %(service_id)s
                and user_infrastructure.t_manage_request.company_code = %(company_code)s
                ORDER BY
                    user_infrastructure.m_update_company_info_history.update_date DESC
                LIMIT 1
            '''
            param = {}
            param["auth0_user_id"] = auth0_user_id
            param["system_id"] = system_id
            param["service_id"] = service_id
            param["company_code"] = company_code
            logger.info('sql')
            logger.info(sql)
            logger.info('param')
            logger.info(param)
            result = pdbc.select_param(sql, param)
        
            if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
                return result
            
            res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_from_user_infrastructure_t_entry(event, context):
    
    logger.info('get_data_from_user_infrastructure_t_entry!!!')

    # フェーズ3 20230830 ------------------------S
    user_metadata = None
    # フェーズ3 20230830 ------------------------E

    # --------------------------------------------------------------------
    # Auth0 S
    
    # 通常ユーザー管理者 のみアクセス可能
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        logger.info(event_headers)

        # 検証
        if 'Authorization' not in event_headers:
            msg = '認証情報が正しくありません。'
            return error_400(msg)
        
        access_token_info = get_access_token_info(event_headers["Authorization"])
        
        # if 'my_roles' not in access_token_info:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        # フェーズ3 20230830 ------------------------S

        if 'user_metadata' not in access_token_info:
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        user_metadata = access_token_info['user_metadata']

        if 'data' not in user_metadata:
            print(''' 'data' not in user_metadata ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        if type(user_metadata['data']) != list:
            print(''' type(user_metadata['data']) != list ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        if len(user_metadata['data']) < 1:
            print(''' len(user_metadata['data']) < 1 ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------E
        
    # Auth0 E
    # --------------------------------------------------------------------
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_CONTRACT_PRODUCT_WHERE, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        #データベース登録
        logger.info(GV.CONFIG_COMN_PF)
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        auth0_user_id = ''
        service_id = ''
        system_id = ''
        company_code = ''
        tenant = ''
        if 'auth0_user_id' in event_body:
            if 'value' in event_body['auth0_user_id']:
                auth0_user_id = event_body['auth0_user_id']['value']
            
        if 'auth0_user_id' in query_string_parameters:
            if type(query_string_parameters['auth0_user_id']) is str:
                tmp = json.loads(query_string_parameters['auth0_user_id'])
                if 'value' in tmp:
                    auth0_user_id = tmp['value']
            else:
                if 'value' in query_string_parameters['auth0_user_id']:
                    auth0_user_id = query_string_parameters['auth0_user_id']['value']
                    
        if 'service_id' in query_string_parameters:
            if type(query_string_parameters['service_id']) is str:
                tmp = json.loads(query_string_parameters['service_id'])
                if 'value' in tmp:
                    service_id = tmp['value']
            else:
                if 'value' in query_string_parameters['service_id']:
                    service_id = query_string_parameters['service_id']['value']
                    
        if 'system_id' in query_string_parameters:
            if type(query_string_parameters['system_id']) is str:
                tmp = json.loads(query_string_parameters['system_id'])
                if 'value' in tmp:
                    system_id = tmp['value']
            else:
                if 'value' in query_string_parameters['system_id']:
                    system_id = query_string_parameters['system_id']['value']
                    
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    company_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    company_code = query_string_parameters['company_code']['value']
        
        if 'tenant' in event_body:
            if 'value' in event_body['tenant']:
                tenant = event_body['tenant']['value']
            
        if 'tenant' in query_string_parameters:
            if type(query_string_parameters['tenant']) is str:
                tmp = json.loads(query_string_parameters['tenant'])
                if 'value' in tmp:
                    tenant = tmp['value']
            else:
                if 'value' in query_string_parameters['tenant']:
                    tenant = query_string_parameters['tenant']['value']
        if auth0_user_id == '':
            msg = 'パラメーター「auth0_user_id」が正しく設定されていません。'
            return error_400(msg)
        if system_id == '':
            msg = 'パラメーター「system_id」が正しく設定されていません。'
            return error_400(msg)
        if service_id == '':
            msg = 'パラメーター「service_id」が正しく設定されていません。'
            return error_400(msg)
        if company_code == '':
            msg = 'パラメーター「company_code」が正しく設定されていません。'
            return error_400(msg)
        if tenant == '':
            msg = 'パラメーター「tenant」が正しく設定されていません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------S
        
        if user_metadata is not None:
            is_admin_user = False
            for d in user_metadata['data']:
                if 'company_code' in d and 'system_id' in d and 'service_id' in d:
                    if d['company_code'] == company_code and d['system_id'] == system_id and d['service_id'] == service_id:
                        if 'roles' in d:
                            if type(d['roles']) == list:
                                if 'admin_user' in d['roles']:
                                    is_admin_user = True
            
            if is_admin_user == False:
                print('is_admin_user')
                print(is_admin_user)
                msg = 'アクセス権限がありません。'
                return error_400(msg)

        # フェーズ3 20230830 ------------------------E
        
        if auth0_user_id != '':
            sql = '''
                 SELECT
                    user_infrastructure.m_contract.entry_code        -- 申込みコード
                    ,user_infrastructure.t_manage_request.system_id  --システムID
                    ,user_infrastructure.t_manage_request.service_id  --サービスID
                    ,user_infrastructure.t_manage_request.status  --ステータス
                    ,user_infrastructure.t_manage_request.status as entry_name  -- ステータス
                    ,user_infrastructure.m_workshop_event_date.workshop_event_date  -- ワークショップ開催日
                    ,user_infrastructure.m_workshop_event_date.workshop_event_time_division  -- ワークショップ時刻区分
                    , user_infrastructure.m_company.company_name    -- 企業名
                    , user_infrastructure.m_company.company_name_kana -- 企業名(カナ)
                    , user_infrastructure.m_company.company_zipcode -- 郵便番号
                    , user_infrastructure.m_company.company_address_pref -- 住所(都道府県)
                    , user_infrastructure.m_company.company_address_1 -- 住所1
                    , user_infrastructure.m_company.company_address_2 -- 住所2
                    , user_infrastructure.m_company.company_address_3 -- 住所3
                    , user_infrastructure.m_company.company_address_1_kana -- 住所1(カナ)
                    , user_infrastructure.m_company.company_address_2_kana -- 住所2(カナ)
                    , user_infrastructure.m_company.company_address_3_kana -- 住所3(カナ)
                    , user_infrastructure.m_company.company_tel_1   -- 電話番号1
                    , user_infrastructure.m_company.company_fax_1   -- FAX1
                    , user_infrastructure.m_company.company_leader_last -- 代表者名(姓)
                    , user_infrastructure.m_company.company_leader_first -- 代表者名(名)
                    , user_infrastructure.m_company.company_leader_kana_last -- 代表者名(姓)(カナ)
                    , user_infrastructure.m_company.company_leader_kana_first -- 代表者名(名)(カナ)
                    , user_infrastructure.m_contract.contract_last_name   -- 契約者名(姓)
                    , user_infrastructure.m_contract.contract_first_name   -- 契約者名(名)
                    , user_infrastructure.m_contract.contract_last_name_kana   -- 契約者名(姓)(カナ)
                    , user_infrastructure.m_contract.contract_first_name_kana   -- 契約者名(名)(カナ)
                    , user_infrastructure.m_contract.contract_department -- 契約者部署名
                    , user_infrastructure.m_contract.contract_position -- 契約者役職
                    , user_infrastructure.m_contract.contract_email -- 契約者メールアドレス
                    , user_infrastructure.m_contract.contract_zipcode -- 契約者郵便番号
                    , user_infrastructure.m_contract.contract_address_pref -- 契約者都道府県
                    , user_infrastructure.m_contract.contract_address_1 -- 契約者住所1
                    , user_infrastructure.m_contract.contract_address_2 -- 契約者住所2
                    , user_infrastructure.m_contract.contract_tel_1 -- 契約者電話番号1
                    , user_infrastructure.m_user.name_last AS administrator_name_last -- 管理者名(姓)
                    , user_infrastructure.m_user.name_first AS administrator_name_first -- 管理者名(名)
                    , user_infrastructure.m_user.name_last_kana AS administrator_name_last_kana -- 管理者名(姓)(カナ)
                    , user_infrastructure.m_user.name_first_kana AS administrator_name_first_kana -- 管理者名(名)(カナ)
                    , user_infrastructure.m_user.department AS administrator_department -- 管理者部署名
                    , user_infrastructure.m_user.position AS administrator_position -- 管理者役職
                    , user_infrastructure.m_user.email AS administrator_email -- 管理者メールアドレス
                    , user_infrastructure.m_user.tel AS administrator_tel_1 -- 管理者電話番号1
                    , user_infrastructure.m_contract.invoice_sending_method -- 請求書の送付方法
                    , user_infrastructure.m_company.company_leader_date_of_birth -- 代表者の生年月日
                    , user_infrastructure.m_company.customer_notes -- 備考欄
                    , user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyer -- GMO掛け払いのデータ更新あり
                    , user_infrastructure.m_contract.contract_id
                    , user_infrastructure.m_contract.salesman_name
                    , user_infrastructure.m_contract.payment_method
                    , user_infrastructure.m_contract.subscription_start_date
                    , user_infrastructure.m_contract.subscription_end_date
                    , user_infrastructure.m_contract.subscription_name
                    , user_infrastructure.m_contract.subscription_notes -- 備考
                    , user_infrastructure.m_contract.udate -- 最終更新日時
                    , user_infrastructure.m_contract.temp_service_sleep_start_date -- 一時休止予定日
                    , user_infrastructure.m_contract.temp_service_sleep_restart_date -- 一時休止からの再開予定日
                    , user_infrastructure.m_contract.ndes_service_stop_start_date -- 停止予定日
                    , user_infrastructure.m_contract.ndes_service_stop_restart_date -- 停止からの再開予定日
                    , user_infrastructure.m_contract.reason_for_termination -- 解約理由
                    , user_infrastructure.m_contract.termination_of_service_mail_send_date -- サービスの解約メール送信日
                    , user_infrastructure.m_user.auth0_user_id 
                    , billing_infrastructure.m_systems.system_name   -- システム名
                    , billing_infrastructure.m_services.service_name   -- サービス名
                    , billing_infrastructure.m_services.use_amount_upper_limit_setting_flag   -- 利用上限金額設定使用フラグ
                    , user_infrastructure.m_company.update_date        -- 最終更新日時
                    , user_infrastructure.m_company.company_code       -- 企業コード
                    , user_infrastructure.m_contract.salesman_code      -- 担当営業(職番)
                    , user_infrastructure.m_update_company_info_history.update_history_id AS m_update_company_info_history_update_history_id  -- 更新履歴ID
                    , user_infrastructure.m_update_company_info_history.company_code AS m_update_company_info_history_company_code  -- company_code
                    , user_infrastructure.m_update_company_info_history.auth0_user_id AS m_update_company_info_history_auth0_user_id  -- Auth0ユーザーID
                    , user_infrastructure.m_update_company_info_history.name_last AS m_update_company_info_history_name_last  -- 名前(姓)
                    , user_infrastructure.m_update_company_info_history.name_first AS m_update_company_info_history_name_first  -- 名前(名)
                    , user_infrastructure.m_update_company_info_history.email AS m_update_company_info_history_email  -- メールアドレス
                    , user_infrastructure.m_update_company_info_history.update_from AS m_update_company_info_history_update_from  -- 更新元
                    , user_infrastructure.m_update_company_info_history.update_date AS m_update_company_info_history_update_date  -- 更新日  
                    , user_infrastructure.m_contract.amount_upper_limit_flg -- 利用料金上限設定フラグ   2023/12/13
                    , user_infrastructure.m_contract.amount_upper_limit -- 利用料金上限金額   2023/12/13
                    , user_infrastructure.m_contract.amount_upper_limit_stop_flg -- 利用中止フラグ   2023/12/13
                    , billing_infrastructure.view_used_amounts_this_month.used_amounts -- 利用料金の合計値   2023/12/13
                    , %(tenant)s as tenant
                FROM
                    user_infrastructure.t_manage_request    
                    INNER JOIN user_infrastructure.m_company 
                        ON user_infrastructure.t_manage_request.company_code = user_infrastructure.m_company.company_code
                    INNER JOIN user_infrastructure.m_user 
                        ON user_infrastructure.m_user.auth0_user_id = user_infrastructure.t_manage_request.auth0_user_id
                        AND user_infrastructure.m_user.company_code = user_infrastructure.t_manage_request.company_code 
                    INNER JOIN user_infrastructure.m_contract 
                        ON user_infrastructure.m_contract.contract_id = user_infrastructure.t_manage_request.contract_id
                    INNER JOIN user_infrastructure.m_auth0_user_info
                        ON user_infrastructure.m_auth0_user_info.auth0_user_id = user_infrastructure.t_manage_request.auth0_user_id
                    INNER JOIN billing_infrastructure.m_systems
                        ON user_infrastructure.t_manage_request.system_id = billing_infrastructure.m_systems.system_id
                    LEFT JOIN billing_infrastructure.view_used_amounts_this_month -- 利用料金の合計値   2023/12/13
                        ON billing_infrastructure.view_used_amounts_this_month.company_code = user_infrastructure.m_contract.company_code -- 利用料金の合計値   2023/12/13
                        AND billing_infrastructure.view_used_amounts_this_month.system_name = billing_infrastructure.m_systems.system_name  -- 利用料金の合計値   2023/12/13
                    LEFT JOIN user_infrastructure.m_update_company_info_history
                        ON user_infrastructure.t_manage_request.auth0_user_id = user_infrastructure.m_update_company_info_history.auth0_user_id
                        AND user_infrastructure.t_manage_request.company_code = user_infrastructure.m_update_company_info_history.company_code
                        AND user_infrastructure.m_update_company_info_history.update_date IS NOT NULL
                    LEFT JOIN user_infrastructure.t_workshop_request_confirmed    
                        ON user_infrastructure.t_workshop_request_confirmed.workshop_req_id = user_infrastructure.t_manage_request.workshop_req_id
                    LEFT JOIN user_infrastructure.m_workshop_event_date    
                        ON user_infrastructure.m_workshop_event_date.workshop_event_date_id = user_infrastructure.t_workshop_request_confirmed.workshop_event_date_id
                    INNER JOIN billing_infrastructure.m_services
                        ON user_infrastructure.t_manage_request.service_id = billing_infrastructure.m_services.service_id 
                WHERE
                    user_infrastructure.m_user.auth0_user_id = %(auth0_user_id)s
                and user_infrastructure.t_manage_request.system_id = %(system_id)s
                and user_infrastructure.t_manage_request.service_id = %(service_id)s
                and user_infrastructure.t_manage_request.company_code = %(company_code)s
                ORDER BY
                    user_infrastructure.m_update_company_info_history.update_date DESC
                LIMIT 1
            '''
            param = {}
            param["auth0_user_id"] = auth0_user_id
            param["system_id"] = system_id
            param["service_id"] = service_id
            param["company_code"] = company_code
            param["tenant"] = tenant
            result = pdbc.select_param(sql, param)
        
            if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
                return result
            
            res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_m_contract_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_contract_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment
            SELECT
                m_contract.contract_id                                  -- 契約ID
                , m_contract.entry_code                                 -- 申込コード
                , m_contract.company_code                               -- 企業コード
                , m_contract.subscription_name                          -- 契約名
                , m_contract.contract_last_name                         -- 契約者名(姓)
                , m_contract.contract_first_name                        -- 契約者名(名)
                , m_contract.contract_last_name_kana                    -- 契約者名カナ(姓)
                , m_contract.contract_first_name_kana                   -- 契約者名カナ(名)
                , m_contract.subscription_start_date                   -- 契約開始日
                , m_contract.subscription_end_date                     -- 契約終了日
                , m_contract.postal_address                            -- 送付先名
                , m_contract.contract_zipcode                          -- 郵便番号
                , m_contract.contract_address_pref                     -- 都道府県
                , m_contract.contract_address_1                        -- 住所１
                , m_contract.contract_address_2                        -- 住所２
                , m_contract.contract_tel_1                            -- 電話番号
                , m_contract.contract_email                            -- メールアドレス
                , m_contract.contract_department                       -- 部署名
                , m_contract.salesman_name                             -- 担当営業名
                , m_contract.applicable_start_date                     -- 適用開始日
                , m_contract.applicable_end_date                       -- 適用終了日
                , m_contract.contract_position                         -- テキ05 役職(顧客)
                , m_contract.payment_method                            -- テキ08 請求方法
                , m_contract.salesman_code                             -- テキ09 担当営業(職番)"
                , m_contract.udate                                     -- 最終更新日時
                , m_contract.subscription_notes                        -- 備考
                , m_contract.invoice_sending_method                    -- invoice_sending_method
                , m_contract.temp_service_sleep_start_date             -- 一時休止予定日
                , m_contract.temp_service_sleep_restart_date           -- 一時休止からの再開予定日
                , m_contract.ndes_service_stop_start_date              -- 停止予定日
                , m_contract.ndes_service_stop_restart_date            -- 停止からの再開予定日
                , m_contract.termination_of_service_mail_send_date     -- サービスの解約メール送信日
                , m_contract.service_usable_status                     -- サービスの利用ステータス
                --, account_registration_only                 -- アカウント登録のみ
                , m_contract.reason_for_termination                    -- 解約理由
                , m_contract.pre_notification_resumption_of_service_mael_send_date -- サービスの再開事前通知実施日
                , m_contract.application_completion_email_sent_date -- 申込完了メール送信日
                , m_contract.cancellation_email_sent_date -- 商談中止メール送信日
                , IN_AMOUNTS.USED_AMOUNTS
				, M_CONTRACT.AMOUNT_UPPER_LIMIT
            FROM
                user_infrastructure.m_contract
            INNER JOIN USER_INFRASTRUCTURE.T_MANAGE_REQUEST AS UI_T_MANAGE_REQUEST ON UI_T_MANAGE_REQUEST.contract_id = m_contract.contract_id
                AND UI_T_MANAGE_REQUEST.SYSTEM_USABLE_FLAG <> '3'
            INNER JOIN
	            (SELECT UI_T_MANAGE_REQUEST.CONTRACT_ID,
		            	VI_USED_AMOUNTS_THIS_MONTH.COMPANY_CODE,
		            	VI_USED_AMOUNTS_THIS_MONTH.STATUS,
	            		VI_USED_AMOUNTS_THIS_MONTH.SYSTEM_NAME,
	            		VI_USED_AMOUNTS_THIS_MONTH.USED_AMOUNTS,
		            	BI_M_SYSTEMS.SYSTEM_ID AS SYSTEM_ID
	            	FROM BILLING_INFRASTRUCTURE.VIEW_USED_AMOUNTS_THIS_MONTH AS VI_USED_AMOUNTS_THIS_MONTH
	            	INNER JOIN BILLING_INFRASTRUCTURE.M_SYSTEMS AS BI_M_SYSTEMS ON BI_M_SYSTEMS.SYSTEM_NAME = VI_USED_AMOUNTS_THIS_MONTH.SYSTEM_NAME
	            	INNER JOIN USER_INFRASTRUCTURE.T_MANAGE_REQUEST AS UI_T_MANAGE_REQUEST ON VI_USED_AMOUNTS_THIS_MONTH.COMPANY_CODE = UI_T_MANAGE_REQUEST.COMPANY_CODE
	            	AND BI_M_SYSTEMS.SYSTEM_ID = UI_T_MANAGE_REQUEST.SYSTEM_ID) AS IN_AMOUNTS ON IN_AMOUNTS.COMPANY_CODE = M_CONTRACT.COMPANY_CODE
            AND IN_AMOUNTS.CONTRACT_ID = M_CONTRACT.CONTRACT_ID
            WHERE
                 -- 一時休止からの再開日以降かつ停止からの再開日以降に処理を実行する。
                 (to_char(now(),'YYYY/MM/DD') >= to_char(m_contract.temp_service_sleep_restart_date,'YYYY/MM/DD')  and m_contract.ndes_service_stop_restart_date is null)              
            OR   (to_char(now(),'YYYY/MM/DD') >= to_char(m_contract.ndes_service_stop_restart_date,'YYYY/MM/DD')  and m_contract.temp_service_sleep_restart_date is null)
            OR   (to_char(now(),'YYYY/MM/DD') >= to_char(m_contract.temp_service_sleep_restart_date,'YYYY/MM/DD') AND to_char(now(),'YYYY/MM/DD') >= to_char(m_contract.ndes_service_stop_restart_date,'YYYY/MM/DD') ) 
            ORDER BY
                m_contract.contract_id
        '''
        param = {}
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# サービスの再開後の予定日のリセット
def get_data_user_infrastructure_m_contract_after_restart_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_contract_after_restart_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment
            SELECT
                contract_id                                 -- 契約ID
                , entry_code                                -- 申込コード
                , company_code                              -- 企業コード
                , subscription_name                         -- 契約名
                , contract_last_name                        -- 契約者名(姓)
                , contract_first_name                       -- 契約者名(名)
                , contract_last_name_kana                   -- 契約者名(姓)(カナ)
                , contract_first_name_kana                  -- 契約者名(名)(カナ)
                , subscription_start_date                   -- 契約開始日
                , subscription_end_date                     -- 契約終了日
                , postal_address                            -- 送付先名
                , contract_zipcode                          -- 郵便番号
                , contract_address_pref                     -- 都道府県
                , contract_address_1                        -- 住所１
                , contract_address_2                        -- 住所２
                , contract_tel_1                            -- 電話番号
                , contract_email                            -- メールアドレス
                , contract_department                       -- 部署名
                , salesman_name                             -- 担当営業名
                , applicable_start_date                     -- 適用開始日
                , applicable_end_date                       -- 適用終了日
                , contract_position                         -- テキ05 役職(顧客)
                , payment_method                            -- テキ08 請求方法
                , salesman_code                             -- テキ09 担当営業(職番)"
                , udate                                     -- 最終更新日時
                , subscription_notes                        -- 備考
                , invoice_sending_method                    -- invoice_sending_method
                , temp_service_sleep_start_date             -- 一時休止予定日
                , temp_service_sleep_restart_date           -- 一時休止からの再開予定日
                , ndes_service_stop_start_date              -- 停止予定日
                , ndes_service_stop_restart_date            -- 停止からの再開予定日
                , termination_of_service_mail_send_date     -- サービスの解約メール送信日
                , service_usable_status                     -- サービスの利用ステータス
               -- , account_registration_only                 -- アカウント登録のみ
                , reason_for_termination                    -- 解約理由
                , pre_notification_resumption_of_service_mael_send_date -- サービスの再開事前通知実施日
                , application_completion_email_sent_date    -- 申込完了メール送信日
                , cancellation_email_sent_date              -- 商談中止メール送信日
            FROM
                user_infrastructure.m_contract 
            WHERE
                 -- ステータスが利用中かつ処理の実行日が一時休止からの再開予定日以降の場合
                 -- ステータスが利用中、処理の実行日が停止からの再開予定日以降の場合
                 (service_usable_status = '利用中'  or service_usable_status = '停止')
            AND  (
                to_char(now(),'YYYY/MM/DD') >= to_char(temp_service_sleep_restart_date,'YYYY/MM/DD')             
                OR   to_char(now(),'YYYY/MM/DD') >= to_char(ndes_service_stop_restart_date,'YYYY/MM/DD')
            )
            ORDER BY
                contract_id
        '''
        param = {}
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# 
def get_data_service_id_system_id_sql(event, context):
    
    logger.info('get_data_service_id_system_id_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        system_name = ''
        system_name = query_string_parameters['system_name']['value']
        service_name = ''
        service_name = query_string_parameters['service_name']['value']
        
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            SELECT
                tab1.service_id as service_id,
                tab2.system_id as system_id
            FROM
                (SELECT service_id  FROM  billing_infrastructure.m_services WHERE service_name = %(service_name)s ) as tab1
            CROSS JOIN
                (SELECT system_id   FROM  billing_infrastructure.m_systems WHERE system_name =%(system_name)s ) as tab2
            LIMIT 1
        '''
        param = {}
        
        param["system_name"] = system_name
        param["service_name"] = service_name
        result = pdbc.select_param(sql, param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_m_contract_notification_sql2(event, context):
    
    logger.info('get_data_user_infrastructure_m_contract_notification_sql2!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment
            SELECT
                contract_id                                 -- 契約ID
                , entry_code                              -- 申込コード
                , company_code                              -- 企業コード
                , subscription_name                         -- 契約名
                , contract_last_name                             -- 契約者名(姓)
                , contract_first_name                             -- 契約者名(名)
                , contract_last_name_kana                        -- 契約者名カナ(姓)
                , contract_first_name_kana                        -- 契約者名カナ(名)
                , subscription_start_date                   -- 契約開始日
                , subscription_end_date                     -- 契約終了日
                , postal_address                            -- 送付先名
                , contract_zipcode                          -- 郵便番号
                , contract_address_pref                     -- 都道府県
                , contract_address_1                        -- 住所１
                , contract_address_2                        -- 住所２
                , contract_tel_1                            -- 電話番号
                , contract_email                            -- メールアドレス
                , contract_department                       -- 部署名
                , salesman_name                             -- 担当営業名
                , applicable_start_date                     -- 適用開始日
                , applicable_end_date                       -- 適用終了日
                , contract_position                         -- テキ05 役職(顧客)
                , payment_method                            -- テキ08 請求方法
                , salesman_code                             -- テキ09 担当営業(職番)"
                , udate                                     -- 最終更新日時
                , subscription_notes                        -- 備考
                , invoice_sending_method                    -- invoice_sending_method
                , temp_service_sleep_start_date             -- 一時休止予定日
                , temp_service_sleep_restart_date           -- 一時休止からの再開予定日
                , ndes_service_stop_start_date              -- 停止予定日
                , ndes_service_stop_restart_date            -- 停止からの再開予定日
                , termination_of_service_mail_send_date     -- サービスの解約メール送信日
                , service_usable_status                     -- サービスの利用ステータス
              --  , account_registration_only                 -- アカウント登録のみ
                , reason_for_termination                    -- 解約理由
                , pre_notification_resumption_of_service_mael_send_date -- サービスの再開事前通知実施日
                , application_completion_email_sent_date    -- 申込完了メール送信日
                , cancellation_email_sent_date              -- 商談中止メール送信日
            FROM
                user_infrastructure.m_contract 
            WHERE
                 -- 一時休止からの再開日以降かつ停止からの再開日以降に処理を実行する。
                 pre_notification_resumption_of_service_mael_send_date  is null
                AND (to_char(temp_service_sleep_restart_date,'YYYY/MM/DD') = to_char(now() + interval '1d','YYYY/MM/DD') OR to_char(ndes_service_stop_restart_date,'YYYY/MM/DD') = to_char(now() + interval '1d','YYYY/MM/DD')  )
            ORDER BY
                contract_id
        '''
        param = {}
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_t_manage_request_sql(event, context):
    
    logger.info('get_data_user_infrastructure_t_manage_request_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        company_code = ''
        company_code = query_string_parameters['company_code']['value']
        
        if company_code == '':
            msg = '企業コード「company_code」が正しく設定されていません。'
            return error_400(msg)
        
        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment

            SELECT
                user_infrastructure.t_manage_request.company_code                             -- 企業コード
               ,user_infrastructure.t_manage_request.contract_id                              -- 契約ID
               ,user_infrastructure.t_manage_request.system_id                              -- システムID
               ,user_infrastructure.t_manage_request.service_id                              -- サービスID
               ,user_infrastructure.t_manage_request.auth0_user_id                              -- Auth0ユーザーID
               ,user_infrastructure.t_manage_request.document_req_id                              -- 資料請求ID
               ,user_infrastructure.m_env_stock.env_id                              -- 環境ID
            FROM
                user_infrastructure.t_manage_request
                LEFT JOIN user_infrastructure.m_env_stock
                ON user_infrastructure.m_env_stock.system_id = user_infrastructure.t_manage_request.system_id
                AND user_infrastructure.m_env_stock.service_id = user_infrastructure.t_manage_request.service_id
                AND user_infrastructure.m_env_stock.company_code = user_infrastructure.t_manage_request.company_code
            WHERE
                user_infrastructure.t_manage_request.company_code = %(company_code)s             -- 企業コード
            ORDER BY
                user_infrastructure.t_manage_request.company_code
            LIMIT 1
        '''
        
        param = {}
        param['company_code'] = company_code
        result = pdbc.select_param(sql,param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_t_manage_request_service_id_sql(event, context):
    
    logger.info('get_data_user_infrastructure_t_manage_request_service_id_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        contract_id = ''
        contract_id = query_string_parameters['contract_id']['value']
        
        if contract_id == '':
            msg = '契約ID「contract_id」が正しく設定されていません。'
            return error_400(msg)
        
        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment

            SELECT
                user_infrastructure.t_manage_request.company_code                             -- 企業コード
               ,user_infrastructure.t_manage_request.contract_id                              -- 契約ID
               ,user_infrastructure.t_manage_request.system_id                              -- システムID
               ,user_infrastructure.t_manage_request.service_id                              -- サービスID
               ,user_infrastructure.t_manage_request.auth0_user_id                              -- Auth0ユーザーID
               ,user_infrastructure.t_manage_request.document_req_id                              -- 資料請求ID
               ,user_infrastructure.m_env_stock.env_id                              -- 環境ID
            FROM
                user_infrastructure.t_manage_request
                LEFT JOIN user_infrastructure.m_env_stock
                ON user_infrastructure.m_env_stock.system_id = user_infrastructure.t_manage_request.system_id
                AND user_infrastructure.m_env_stock.service_id = user_infrastructure.t_manage_request.service_id
                AND user_infrastructure.m_env_stock.company_code = user_infrastructure.t_manage_request.company_code
            WHERE
                user_infrastructure.t_manage_request.contract_id = %(contract_id)s             -- 企業コード
            ORDER BY
                user_infrastructure.t_manage_request.contract_id
            LIMIT 1
        '''
        
        param = {}
        param['contract_id'] = contract_id
        result = pdbc.select_param(sql,param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_m_cloud_strage_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_cloud_strage_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        contract_id = ''
        contract_id = query_string_parameters['contract_id']['value']
        
        if contract_id == '':
            msg = '契約ID「contract_id」が正しく設定されていません。'
            return error_400(msg)
        
        sql = '''
            --*CaptionFromComment

            SELECT
                cloud_strage_id                             -- クラウドストレージID
                , m_cloud_strage.contract_id                               -- 契約ID
                , cloud_strage_domain                       -- クラウドストレージドメイン
                , user_name                                 -- ユーザ名
                , password                                  -- パスワード
                , salt
                , iv
                , folder_id
                , enable_flg                                -- 有効化フラグ
                , cloud_strage_type                         -- クラウドストレージ種類
                , m_services.system_configuration_type
            FROM
                user_infrastructure.m_cloud_strage 
                LEFT JOIN user_infrastructure.t_manage_request ON t_manage_request.contract_id = m_cloud_strage.contract_id
                LEFT JOIN billing_infrastructure.m_services ON m_services.service_id = t_manage_request.service_id
            WHERE
                m_cloud_strage.contract_id = %(contract_id)s             -- 契約ID
        '''
        
        param = {}
        param['contract_id'] = contract_id
        result = pdbc.select_param(sql,param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        for row in result:
        
            if 'password' in row and row['password'] is not None and row['cloud_strage_type'] == 'GoogleDrive':
                # 復号
                passPhrase = GV.CONFIG_PASSPHRASE['PASSPHRASE']
                oldPassword = decrypt(row, passPhrase)
                # row['password'] = oldPassword.replace('\f','').replace('\t','').replace('\b','').replace('\u0010','').replace('\u0003','').replace('\u000b','')
                row['password'] = oldPassword

        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# --------------------0704---------------S
def get_data_user_infrastructure_m_auth0_management_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_auth0_management_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        service = ''
        service = query_string_parameters['service']['value']
        
        if service == '':
            msg = 'システム「service」が正しく設定されていません。'
            return error_400(msg)
            
        company_code = ''
        company_code = query_string_parameters['company_code']['value']
        
        if company_code == '':
            msg = '企業コード「company_code」が正しく設定されていません。'
            return error_400(msg)
        
        sql = '''
            --*CaptionFromComment
            
            
            SELECT
                id                                          -- id
                , m_auth0_management.tenant                 -- テナント
                , m_auth0_management.domain                 -- ドメイン
                , app_clientid                              -- クライアントID
                , api_clientid                              -- クライアントID
                , api_audience                              -- APIオーディエンス
                , api_client_secret                         -- クライアントシークレット
                , management_api_audience                   -- オーディエンス
                , m_systems.system_id
                , m_systems.sub_domain_name
                , m_auth0_user_info.company_code
            FROM
                user_infrastructure.m_auth0_management
                LEFT JOIN user_infrastructure.m_auth0_user_info
                     ON user_infrastructure.m_auth0_user_info.tenant = m_auth0_management.tenant
                LEFT JOIN billing_infrastructure.m_systems
                     ON billing_infrastructure.m_systems.system_id = m_auth0_user_info.system_id
            WHERE
                m_systems.sub_domain_name = %(service)s             -- システム名前
                and m_auth0_user_info.company_code = %(company_code)s             -- 企業コード
            LIMIT 1
        '''
        
        param = {}
        param['company_code'] = company_code
        param['service'] = service
        result = pdbc.select_param(sql,param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        for row in result:
        
            if 'password' in row and row['password'] is not None and row['cloud_strage_type'] == 'GoogleDrive':
                # 復号
                passPhrase = GV.CONFIG_PASSPHRASE['PASSPHRASE']
                oldPassword = decrypt(row, passPhrase)
                # row['password'] = oldPassword.replace('\f','').replace('\t','').replace('\b','').replace('\u0010','').replace('\u0003','').replace('\u000b','')
                row['password'] = oldPassword

        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_m_auth0_management_list_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_auth0_management_list_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        tenant = ''
        tenant = query_string_parameters['tenant']['value']
        
        if tenant == '':
            msg = 'テナント「tenant」が正しく設定されていません。'
            return error_400(msg)

        sql = '''
            --*CaptionFromComment
            
            
            SELECT
                id                                          -- id
                , tenant                                    -- テナント
                , domain                                    -- ドメイン
                , app_clientid                              -- クライアントID
                , api_clientid                              -- クライアントID
                , api_audience                              -- APIオーディエンス
                , api_client_secret                         -- クライアントシークレット
                , management_api_audience                   -- オーディエンス
            FROM
                user_infrastructure.m_auth0_management 
            WHERE
                m_auth0_management.tenant = %(tenant)s      -- テナント
            LIMIT 1
        '''
        
        param = {}
        param['tenant'] = tenant
        result = pdbc.select_param(sql,param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        for row in result:
        
            if 'password' in row and row['password'] is not None and row['cloud_strage_type'] == 'GoogleDrive':
                # 復号
                passPhrase = GV.CONFIG_PASSPHRASE['PASSPHRASE']
                oldPassword = decrypt(row, passPhrase)
                # row['password'] = oldPassword.replace('\f','').replace('\t','').replace('\b','').replace('\u0010','').replace('\u0003','').replace('\u000b','')
                row['password'] = oldPassword

        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
# --------------------0704---------------E
def get_data_user_infrastructure_m_cloud_strage_check_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_cloud_strage_check_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        contract_id = ''
        contract_id = query_string_parameters['contract_id']['value']
        
        if contract_id == '':
            msg = '契約ID「contract_id」が正しく設定されていません。'
            return error_400(msg)
        
        cloud_strage_type = ''
        cloud_strage_type = query_string_parameters['cloud_strage_type']['value']
        
        if cloud_strage_type == '':
            msg = 'クラウドストレージ種類「cloud_strage_type」が正しく設定されていません。'
            return error_400(msg)
        
        sql = '''
            --*CaptionFromComment

            SELECT
                cloud_strage_id                             -- クラウドストレージID
                , m_cloud_strage.contract_id                               -- 契約ID
                , cloud_strage_domain                       -- クラウドストレージドメイン
                , user_name                                 -- ユーザ名
                , password                                  -- パスワード
                , salt
                , iv
                , folder_id
                , enable_flg                                -- 有効化フラグ
                , cloud_strage_type                         -- クラウドストレージ種類
                , m_services.system_configuration_type
            FROM
                user_infrastructure.m_cloud_strage 
                LEFT JOIN user_infrastructure.t_manage_request ON t_manage_request.contract_id = m_cloud_strage.contract_id
                LEFT JOIN billing_infrastructure.m_services ON m_services.service_id = t_manage_request.service_id
                
            WHERE
                m_cloud_strage.contract_id = %(contract_id)s             -- 契約ID
            and cloud_strage_type = %(cloud_strage_type)s             -- クラウドストレージ種類
        '''
        
        param = {}
        param['contract_id'] = contract_id
        param['cloud_strage_type'] = cloud_strage_type
        result = pdbc.select_param(sql,param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result

        for row in result:

            if 'password' in row and row['password'] is not None and row['cloud_strage_type'] == 'GoogleDrive' :
                # 復号
                passPhrase = GV.CONFIG_PASSPHRASE['PASSPHRASE']
                oldPassword = decrypt(row, passPhrase)
                # row['password'] = oldPassword.replace('\f','').replace('\t','').replace('\b','').replace('\u0010','').replace('\u0003','').replace('\u000b','')
                row['password'] = oldPassword

        res['result'] = result

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
    
# 暗号
def encrypt(text, passPhrase):
    salt = get_random_bytes(16)
    iv = get_random_bytes(16)

    # AESキーの生成(128bit、5万回)
    key = pbkdf2_hmac('sha256', bytes(passPhrase, encoding='utf-8'), salt, 50000, int(128 / 8))

    # 暗号
    aes = AES.new(key, AES.MODE_CBC, iv)
    
    data = Padding.pad(text.encode('utf-8'), AES.block_size, 'pkcs7')
    encrypted = aes.encrypt(data)

    data = {
        'password': encrypted, 'salt': salt, 'iv': iv
    }

    return data
    
# 復号
def decrypt(dataItem, passPhrase):

    encryptedData = {}
    encryptedData['salt'] = dataItem['salt']
    encryptedData['iv'] = dataItem['iv']
    encryptedData['encrypted'] = dataItem['password']

    # AESキーの生成(128bit、5万回)
    key = pbkdf2_hmac('sha256', bytes(passPhrase, encoding='utf-8'), encryptedData['salt'], 50000, int(128 / 8))
    
    # 復号
    aes = AES.new(key, AES.MODE_CBC, encryptedData['iv'])
    # plaintext = aes.decrypt(encryptedData['encrypted'])
    plaintext = Padding.unpad(aes.decrypt(encryptedData['encrypted']), AES.block_size, 'pkcs7')

    return plaintext.decode(encoding='utf-8')


def get_data_user_infrastructure_m_contract_notification_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_contract_notification_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        str1 = ''
        if (query_string_parameters['specified_number_days_type']['value'] == '1'):
            # 一時休止からの再開予定日
            for strArr in query_string_parameters['specified_number_days']['value'].split(','):
                # to_char(temp_service_sleep_restart_date,'YYYY/MM/DD') = to_char(now() + interval '2d','YYYY/MM/DD')
                str1 = str1 + "to_char(temp_service_sleep_restart_date,'YYYY/MM/DD') = to_char(now() + interval '" + strArr + "d','YYYY/MM/DD') or "
        if (query_string_parameters['specified_number_days_type']['value'] == '2'):
            # 停止からの再開予定日    
            for strArr1 in query_string_parameters['specified_number_days']['value'].split(','):
                # to_char(ndes_service_stop_restart_date,'YYYY/MM/DD') = to_char(now() + interval '2d','YYYY/MM/DD')
                str1 = str1 + "to_char(ndes_service_stop_restart_date,'YYYY/MM/DD') = to_char(now() + interval '" + strArr1 + "d','YYYY/MM/DD') or "

        print('------------------------------')

        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment
            SELECT
                contract_id                                 -- 契約ID
                , entry_code                              -- 申込コード
                , company_code                              -- 企業コード
                , subscription_name                         -- 契約名
                , contract_last_name                             -- 契約者名(姓)
                , contract_first_name                             -- 契約者名(名)
                , contract_last_name_kana                        -- 契約者名カナ(姓)
                , contract_first_name_kana                        -- 契約者名カナ(名)
                , subscription_start_date                   -- 契約開始日
                , subscription_end_date                     -- 契約終了日
                , postal_address                            -- 送付先名
                , contract_zipcode                          -- 郵便番号
                , contract_address_pref                     -- 都道府県
                , contract_address_1                        -- 住所１
                , contract_address_2                        -- 住所２
                , contract_tel_1                            -- 電話番号
                , contract_email                            -- メールアドレス
                , contract_department                       -- 部署名
                , salesman_name                             -- 担当営業名
                , applicable_start_date                     -- 適用開始日
                , applicable_end_date                       -- 適用終了日
                , contract_position                         -- テキ05 役職(顧客)
                , payment_method                            -- テキ08 請求方法
                , salesman_code                             -- テキ09 担当営業(職番)"
                , udate                                     -- 最終更新日時
                , subscription_notes                        -- 備考
                , invoice_sending_method                    -- invoice_sending_method
                , temp_service_sleep_start_date             -- 一時休止予定日
                , temp_service_sleep_restart_date           -- 一時休止からの再開予定日
                , ndes_service_stop_start_date              -- 停止予定日
                , ndes_service_stop_restart_date            -- 停止からの再開予定日
                , termination_of_service_mail_send_date     -- サービスの解約メール送信日
                , service_usable_status                     -- サービスの利用ステータス
               -- , account_registration_only                 -- アカウント登録のみ
                , reason_for_termination                    -- 解約理由
                , pre_notification_resumption_of_service_mael_send_date -- サービスの再開事前通知実施日
                , application_completion_email_sent_date    -- 申込完了メール送信日
                , cancellation_email_sent_date              -- 商談中止メール送信日
            FROM
                user_infrastructure.m_contract 
            WHERE
                 -- 一時休止からの再開日以降かつ停止からの再開日以降に処理を実行する。
        ''' + str1[:-3] + '''
            ORDER BY
                contract_id
        '''
        
        param = {}
        
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# メールのユーザー情報を取得する
def get_data_mail_t_entry_sql(event, context):
    
    logger.info('get_data_mail_t_entry_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
        
        company_code = ''
        company_code = query_string_parameters['company_code']['value']
        
        if company_code == '':
            msg = '企業コード「company_code」が正しく設定されていません。'
            return error_400(msg)
            
        roles = '%admin_user%' 
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        str1 = ''
        print('------------------------------')

        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment
            SELECT
                user_infrastructure.m_company.company_code                              -- 企業コード
               ,user_infrastructure.m_company.company_name                              -- 企業名前
               ,user_infrastructure.m_contract.entry_code
               ,user_infrastructure.m_contract.contract_last_name
               ,user_infrastructure.m_contract.contract_first_name
               ,user_infrastructure.m_user.name_last as administrator_name_last
               ,user_infrastructure.m_user.name_first as administrator_name_first
            FROM
                user_infrastructure.m_company
                INNER JOIN user_infrastructure.m_user 
                        ON user_infrastructure.m_user.company_code = user_infrastructure.m_company.company_code 
                INNER JOIN user_infrastructure.m_contract 
                        ON user_infrastructure.m_contract.company_code = user_infrastructure.m_company.company_code
                INNER JOIN user_infrastructure.m_auth0_user_info 
                        ON user_infrastructure.m_auth0_user_info.company_code = user_infrastructure.m_company.company_code
                        and user_infrastructure.m_auth0_user_info.system_id <>'SYS00000'  
                        and user_infrastructure.m_auth0_user_info.roles like %(roles)s
                        and user_infrastructure.m_auth0_user_info.auth0_user_id = user_infrastructure.m_user.auth0_user_id
            WHERE
                user_infrastructure.m_company.company_code = %(company_code)s                 -- 企業コード
            ORDER BY
                user_infrastructure.m_company.company_code
        '''
        
        param = {}
        param['company_code'] = company_code
        param['roles'] = roles
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E


def set_data_to_user_infrastructure_t_entry(event, context):
    
    logger.info('set_data_to_user_infrastructure_t_entry!!!')
        
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        print(record)
        tmp = {}
        for key in record:
            if key in user_infrastructure.T_ENTRY:
               tmp[key] = record[key]
        record = tmp
        
        # 請求書の送付方法
        print(record['invoice_sending_method']['value'])
        if len(record['invoice_sending_method']['value']) > 0 and record['invoice_sending_method']['value'][0] == '書面で請求書を郵送する。':
            del record['invoice_sending_method']
            record['invoice_sending_method'] = {'value':''}
            # record['invoice_sending_method']['value'] = "郵送(書類)"
            record['invoice_sending_method']['value'] = 1
        else:
            del record['invoice_sending_method']
            record['invoice_sending_method'] = {'value':''}
            # record['invoice_sending_method']['value'] = "PDF"
            record['invoice_sending_method']['value'] = 0
        
        # フェーズ2 ------------------------S
        # アカウント登録のみ
        print(record['account_registration_only']['value'])
        if len(record['account_registration_only']['value']) > 0 and record['account_registration_only']['value'][0] == 'アカウント登録のみ行う。':
            del record['account_registration_only']
            record['account_registration_only'] = {'value':''}
            record['account_registration_only']['value'] = 1
        else:
            del record['account_registration_only']
            record['account_registration_only'] = {'value':''}
            record['account_registration_only']['value'] = 0
        # フェーズ2 ------------------------E
                   
        # 検証
        res_validation = validate(user_infrastructure.T_ENTRY, record)
        if res_validation != True:
            print(res_validation)
            return error_400(res_validation)
       
        dt_now = datetime.datetime.now()
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.TEntry()
        m_param.entry_code = record['entry_code']['value']
        rows = pdbc.select('user_infrastructure', m_param)
        
        m_param = user_infrastructure.TEntry()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])

        # not null
        m_param.salesman_code = '' # 営業コード
        m_param.ticket_id = '' # チケットID
        
        # サーバー時間
        m_param.insert_date = dt_now

        # m_param.udate = dt_now
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = user_infrastructure.TEntry()
            m_condition_param.entry_code = record['entry_code']['value']
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# user_infrastructure t_entry E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_company S

# フェーズ2 ------------------------S

def get_data_from_user_infrastructure_m_company(event, context):
    
    logger.info('get_data_from_user_infrastructure_m_company!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_SEND_MAIL, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
                    
        m_param = user_infrastructure.MCompany()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key]['value'])
        result = pdbc.select('user_infrastructure', m_param)
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

def set_data_to_user_infrastructure_m_company(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_company!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_COMPANY:
               tmp[key] = record[key]
        record = tmp
        
        # 検証
        res_validation = validate(user_infrastructure.M_COMPANY, record)
        if res_validation != True:
            return error_400(res_validation)
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        # m_param = user_infrastructure.MCompany()
        # m_param.company_code = record['company_code']['value']
        # rows = pdbc.select('user_infrastructure', m_param)
        
        # if len(rows) > 0:
        #     if rows[0]['entry_code'] != record['entry_code']['value']:
        #         res['error_code'] = ''
        #         res['error_message'] = '同じ企業コードのデータがすでに存在します。'
        #         return {
        #             'statusCode': 400,
        #             'headers': RESPONSE_HEADERS,
        #             # 'body': json.dumps(res)
        #             'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
        #         }
        
        # m_param = user_infrastructure.MCompany()
        # m_param.entry_code = record['entry_code']['value']
        # rows = pdbc.select('user_infrastructure', m_param)
        
        # if len(rows) > 0:
        #     if rows[0]['company_code'] != record['company_code']['value']:
        #         res['error_code'] = ''
        #         res['error_message'] = '同じ申込コードのデータがすでに存在します。'
        #         return {
        #             'statusCode': 400,
        #             'headers': RESPONSE_HEADERS,
        #             # 'body': json.dumps(res)
        #             'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
        #         }
        
        dt_now = datetime.datetime.now()
        m_param = user_infrastructure.MCompany()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.delete_flg = False
                    
        m_param.update_date = dt_now
        
        m_condition_param = user_infrastructure.MCompany()
        m_condition_param.company_code = record['company_code']['value']
        result = pdbc.update('user_infrastructure', m_param, m_condition_param)

        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def update_data_to_user_infrastructure_m_company(event, context):
    
    logger.info('update_data_to_user_infrastructure_m_company!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
                
        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        is_insert = False
        res_validation = validate(user_infrastructure.M_COMPANY, record['condition_value'], is_insert)
        if res_validation != True:
            return error_400(res_validation)
        res_validation = validate(user_infrastructure.M_COMPANY, record['new_value'], is_insert)
        if res_validation != True:
            return error_400(res_validation)
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        # 検索
        m_param = user_infrastructure.MCompany()
        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
        rows = pdbc.select('user_infrastructure', m_param)
        
        # 値セット
        m_param = user_infrastructure.MCompany()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            # データ更新
            m_condition_param = user_infrastructure.MCompany()
            for key in record['condition_value']:
                if 'value' in record['condition_value'][key]:
                    setattr(m_condition_param, key, record['condition_value'][key]['value'])
            if len(m_condition_param.__dict__) > 0:
                result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# フェーズ3 ------------------------S

def update_data_to_user_infrastructure_t_manage_request(event, context):
    
    logger.info('update_data_to_user_infrastructure_t_manage_request!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']

        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        is_insert = False
        res_validation = validate(user_infrastructure.T_MANAGE_REQUEST, record['condition_value'], is_insert)
        if res_validation != True:

            return error_400(res_validation)
        res_validation = validate(user_infrastructure.T_MANAGE_REQUEST, record['new_value'], is_insert)
        if res_validation != True:

            return error_400(res_validation)
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
 
        # 検索
        m_param = user_infrastructure.TManageRequest()

        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
        rows = pdbc.select('user_infrastructure', m_param)
        # 値セット
        m_param = user_infrastructure.TManageRequest()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            # データ更新
            m_condition_param = user_infrastructure.TManageRequest()
            for key in record['condition_value']:
                if 'value' in record['condition_value'][key]:
                    setattr(m_condition_param, key, record['condition_value'][key]['value'])
            if len(m_condition_param.__dict__) > 0:
                dt_now = datetime.datetime.now()
                m_param.udate = dt_now
                result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ3 ------------------------E

# user_infrastructure T_MANAGE_REQUEST E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_user S

# フェーズ2 ------------------------S

def get_data_from_user_infrastructure_m_user(event, context):
    
    logger.info('get_data_from_user_infrastructure_m_user!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
       
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
                    
        m_param = user_infrastructure.MUser()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key]['value'])
        result = pdbc.select('user_infrastructure', m_param)
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

def set_data_to_user_infrastructure_m_user(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_user!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_USER:
               tmp[key] = record[key]
        record = tmp
        
        # 検証
        res_validation = validate(user_infrastructure.M_USER, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MUser()
        m_param.auth0_user_id = record['auth0_user_id']['value']
        m_param.company_code = record['company_code']['value']
        rows = pdbc.select('user_infrastructure', m_param)
                
        # if len(rows) > 0:
        #     if rows[0]['company_code'] != record['company_code']['value']:
        #         res['error_code'] = ''
        #         res['error_message'] = '同じユーザーIDのデータがすでに存在します。'
        #         return {
        #             'statusCode': 400,
        #             'headers': RESPONSE_HEADERS,
        #             # 'body': json.dumps(res)
        #             'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
        #         }
                
        m_param = user_infrastructure.MUser()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        
        logger.info(m_param)
        
        if len(rows) > 0:
            m_condition_param = user_infrastructure.MUser()
            m_condition_param.auth0_user_id = record['auth0_user_id']['value']
            m_condition_param.company_code = record['company_code']['value']
            m_param.udate = dt_now
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            m_param.cdate = dt_now
            m_param.udate = dt_now
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# m_entry_site_app_settings_confirmed 登録    
def set_data_to_user_infrastructure_m_entry_site_app_settings_confirmed(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_entry_site_app_settings_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_ENTRY_SITE_APP_SETTINGS_CONFIRMED:
               tmp[key] = record[key]
        record = tmp

        # 検証
        res_validation = validate(user_infrastructure.M_ENTRY_SITE_APP_SETTINGS_CONFIRMED, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MEntrySiteAppSettingsConfirmed()
        m_param.entry_site_app_setting_id = record['entry_site_app_setting_id']['value']
        m_param.supplier_id = record['supplier_id']['value']
        m_param.system_id = record['system_id']['value']
        rows = pdbc.select('user_infrastructure', m_param)
                
        m_param = user_infrastructure.MEntrySiteAppSettingsConfirmed()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        
        logger.info(m_param)
        
        if len(rows) > 0:
            m_condition_param = user_infrastructure.MEntrySiteAppSettingsConfirmed()
            m_condition_param.entry_site_app_setting_id = record['entry_site_app_setting_id']['value']
            m_condition_param.supplier_id = record['supplier_id']['value']
            m_condition_param.system_id = record['system_id']['value']
            m_param.udate = dt_now
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            m_param.cdate = dt_now
            m_param.udate = dt_now
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# m_entry_site_document_request_manage_confirmed 登録
def set_data_to_user_infrastructure_m_entry_site_document_request_manage_confirmed(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_ENTRY_SITE_DOCUMENT_REQUEST_MANAGE_CONFIRMED:
               tmp[key] = record[key]
        record = tmp
        
        # 検証
        res_validation = validate(user_infrastructure.M_ENTRY_SITE_DOCUMENT_REQUEST_MANAGE_CONFIRMED, record)
        if res_validation != True:
            return error_400(res_validation)

        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MEntrySiteDocumentRequestManageConfirmed()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        
        logger.info(m_param)

        result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# m_entry_site_questionnaire_manage_confirmed 登録
def set_data_to_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_entry_site_questionnaire_manage_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_ENTRY_SITE_QUESTIONNAIRE_MANAGE_CONFIRMED:
               tmp[key] = record[key]
        record = tmp
        
        # 検証
        res_validation = validate(user_infrastructure.M_ENTRY_SITE_QUESTIONNAIRE_MANAGE_CONFIRMED, record)
        if res_validation != True:
            return error_400(res_validation)

        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MEntrySiteQuestionnaireManageConfirmed()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        
        logger.info(m_param)

        result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
       
# テーブルデータ m_entry_site_document_request_manage_confirmed を削除する
def del_data_to_user_infrastructure_m_entry_site_document_request_manage_confirmed(event, context):
    
    logger.info('del_data_to_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_ENTRY_SITE_DOCUMENT_REQUEST_MANAGE_CONFIRMED:
               tmp[key] = record[key]
        record = tmp
        
        # 検証
        res_validation = validate(user_infrastructure.M_ENTRY_SITE_DOCUMENT_REQUEST_MANAGE_CONFIRMED, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース削除
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MEntrySiteDocumentRequestManageConfirmed()
        
        m_param.system_id = record['system_id']['value']

        result = pdbc.delete('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# テーブルデータを削除する
def del_data_to_user_infrastructure_m_entry_site(event, context):
    
    logger.info('del_data_to_user_infrastructure_m_entry_site!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        # dt_now = datetime.datetime.now()
        #データベース削除
        # 申込ポータルサイトアプリ確定設定
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MEntrySiteAppSettingsConfirmed()
        result = pdbc.delete('user_infrastructure', m_param)
        
        # 申込ポータルサイト資料請求確定管理
        m_param1 = user_infrastructure.MEntrySiteDocumentRequestManageConfirmed()
        result = pdbc.delete('user_infrastructure', m_param1)
        
        # 申込ポータルサイトアンケート確定管理
        m_param2 = user_infrastructure.MEntrySiteQuestionnaireManageConfirmed()
        result = pdbc.delete('user_infrastructure', m_param2)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def set_data_to_user_infrastructure_m_cloud_strage(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_cloud_strage!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        

        if 'system_configuration_type' in record and record is not None: 
            intType = record['system_configuration_type']['value']

        tmp = {}
        for key in record:
            if key in user_infrastructure.M_CLOUD_STRAGE:
               tmp[key] = record[key]
        record = tmp

        # 検証
        res_validation = validate(user_infrastructure.M_CLOUD_STRAGE, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MCloudStrage()
        m_param.cloud_strage_type = record['cloud_strage_type']['value']
        m_param.contract_id = record['contract_id']['value']
        rows = pdbc.select('user_infrastructure', m_param)
                
        m_param = user_infrastructure.MCloudStrage()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
                
        # 暗号化
        # print("aaaaaaaaaaaaaaaaaaaa")
        # print(record)
        # print("aaaaaaaaaaaaaaaaaaaa")
        if record["password"]['value'] is not None and record['cloud_strage_type']['value'] == 'GoogleDrive':
            # print("暗号化")
            passPhrase = GV.CONFIG_PASSPHRASE['PASSPHRASE']
            encryptedData = encrypt(record["password"]['value'], passPhrase)
            m_param.password = encryptedData['password']
            m_param.salt = encryptedData['salt']
            m_param.iv = encryptedData['iv']
            # print("aaaaaaaaaaa暗号化aaaaaaaaa")
            # print(record)
            # print("aaaaaaaaaaa暗号化aaaaaaaaa")
        
        logger.info(m_param)
        
        if len(rows) > 0:
            m_condition_param = user_infrastructure.MCloudStrage()
            m_condition_param.cloud_strage_type = record['cloud_strage_type']['value']
            m_condition_param.contract_id = record['contract_id']['value']
            m_param.udate = dt_now
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            m_param.cdate = dt_now
            m_param.udate = dt_now
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def delete_data_from_user_infrastructure_m_user(event, context):
    
    logger.info('delete_data_from_user_infrastructure_m_user!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:

        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MUser()
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
            if 'record' in event_body:
                record = event_body['record']
                
                if 'condition_value' not in record:
                    return error_400('条件の値が設定されていません。')
        
                for key in record['condition_value']:
                    if 'value' in record['condition_value'][key]:
                        setattr(m_param, key, record['condition_value'][key]['value'])
                logger.info(m_param.__dict__)
                if len(m_param.__dict__) < 1:
                    return error_400('条件の値が設定されていません。')
                
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
      
            for key in query_string_parameters:
                    setattr(m_param, key, query_string_parameters[key])
                    
            if len(m_param.__dict__) < 1:
                return error_400('条件の値が設定されていません。')
                        
        # m_param.contract_id = query_string_parameters['contract_id']
        # m_param.product_id = query_string_parameters['product_id']
        result = pdbc.delete('user_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        print(result)
        
        res['result'] = result
        
        print(res)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# user_infrastructure m_user E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_update_company_info_history S

# フェーズ2 ------------------------S

def get_data_from_m_update_company_info_history_sql(event, context):
    
    logger.info('get_data_from_m_update_company_info_history_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        # if type(query_string_parameters) is str:
        #     query_string_parameters = json.loads(query_string_parameters)
        
        company_code = ''
        company_code = query_string_parameters['company_code']
        
        if company_code:
            pass
        else:
            msg = '企業コード「company_code」が正しく設定されていません。'
            return error_400(msg)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        print('------------------------------')

        sql = '''
            --*DataTitle 企業情報更新履歴
            --*CaptionFromComment
            SELECT
              update_history_id                               -- 更新履歴ID
              , company_code                                  -- company_code
              , auth0_user_id                                 -- Auth0ユーザーID
              , name_last                                     -- 名前(姓)
              , name_first                                    -- 名前(名)
              , email                                         -- メールアドレス
              , update_from                                   -- 更新元
              , update_date                                   -- 更新日
              , temp_service_sleep_start_date                 -- 一時休止開始予定日
              , temp_service_sleep_restart_date               -- 一時休止からの再開予定日
            FROM
              user_infrastructure.m_update_company_info_history 
            WHERE
              company_code = %(company_code)s
            ORDER BY
              update_history_id DESC
            LIMIT 1
        '''
               
        param = {}
        param['company_code'] = company_code
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# -----------障害 #4909 利用料金の上限以上------20231213-------------------S 
def get_data_user_infrastructure_m_contract_stop_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_contract_stop_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment
            SELECT 
                IN_M_CONTRACT.CONTRACT_ID
               ,IN_M_CONTRACT.COMPANY_CODE
               ,IN_M_CONTRACT.AMOUNT_UPPER_LIMIT
               ,IN_M_CONTRACT.contract_last_name
               ,IN_M_CONTRACT.contract_first_name
               ,IN_M_CONTRACT.contract_email           -- メールアドレス
               ,IN_M_CONTRACT.entry_code           -- メールアドレス
               ,IN_AMOUNTS.USED_AMOUNTS
            FROM USER_INFRASTRUCTURE.M_CONTRACT AS IN_M_CONTRACT
            INNER JOIN
            	(SELECT UI_T_MANAGE_REQUEST.CONTRACT_ID,
            			VI_USED_AMOUNTS_THIS_MONTH.COMPANY_CODE,
            			VI_USED_AMOUNTS_THIS_MONTH.STATUS,
            			VI_USED_AMOUNTS_THIS_MONTH.SYSTEM_NAME,
            			VI_USED_AMOUNTS_THIS_MONTH.USED_AMOUNTS,
            			BI_M_SYSTEMS.SYSTEM_ID AS SYSTEM_ID
            		FROM BILLING_INFRASTRUCTURE.VIEW_USED_AMOUNTS_THIS_MONTH AS VI_USED_AMOUNTS_THIS_MONTH
            		INNER JOIN BILLING_INFRASTRUCTURE.M_SYSTEMS AS BI_M_SYSTEMS ON BI_M_SYSTEMS.SYSTEM_NAME = VI_USED_AMOUNTS_THIS_MONTH.SYSTEM_NAME
            		INNER JOIN USER_INFRASTRUCTURE.T_MANAGE_REQUEST AS UI_T_MANAGE_REQUEST ON VI_USED_AMOUNTS_THIS_MONTH.COMPANY_CODE = UI_T_MANAGE_REQUEST.COMPANY_CODE
            		AND BI_M_SYSTEMS.SYSTEM_ID = UI_T_MANAGE_REQUEST.SYSTEM_ID) AS IN_AMOUNTS ON IN_AMOUNTS.COMPANY_CODE = IN_M_CONTRACT.COMPANY_CODE
            AND IN_AMOUNTS.CONTRACT_ID = IN_M_CONTRACT.CONTRACT_ID
            AND IN_AMOUNTS.USED_AMOUNTS >= IN_M_CONTRACT.AMOUNT_UPPER_LIMIT  
            AND IN_M_CONTRACT.AMOUNT_UPPER_LIMIT <> 0 
            AND IN_AMOUNTS.USED_AMOUNTS IS NOT NULL
            AND IN_M_CONTRACT.SERVICE_USABLE_STATUS <> '停止'
        '''
        param = {}
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# サービスの停止中に、現在の利用料金の合計値が利用料金が上限より小さくなったらサービスを利用可能状態
def get_data_user_infrastructure_m_contract_stop_amount_sql(event, context):
    
    logger.info('get_data_user_infrastructure_m_contract_stop_amount_sql!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '契約情報'
            --*CaptionFromComment
            SELECT IN_M_CONTRACT.CONTRACT_ID,
	            IN_M_CONTRACT.COMPANY_CODE,
	            IN_M_CONTRACT.AMOUNT_UPPER_LIMIT,
	            IN_M_CONTRACT.CONTRACT_LAST_NAME,
	            IN_M_CONTRACT.CONTRACT_FIRST_NAME,
	            IN_M_CONTRACT.CONTRACT_EMAIL, -- メールアドレス
	            IN_M_CONTRACT.TEMP_SERVICE_SLEEP_START_DATE, -- 一時休止予定日
                IN_M_CONTRACT.TEMP_SERVICE_SLEEP_RESTART_DATE, -- 一時休止からの再開予定日
                IN_M_CONTRACT.NDES_SERVICE_STOP_START_DATE, -- 停止予定日
                IN_M_CONTRACT.NDES_SERVICE_STOP_RESTART_DATE, -- 停止からの再開予定日
 	            IN_AMOUNTS.USED_AMOUNTS
            FROM USER_INFRASTRUCTURE.M_CONTRACT AS IN_M_CONTRACT
            INNER JOIN
	            (SELECT UI_T_MANAGE_REQUEST.CONTRACT_ID,
		            	VI_USED_AMOUNTS_THIS_MONTH.COMPANY_CODE,
		            	VI_USED_AMOUNTS_THIS_MONTH.STATUS,
	            		VI_USED_AMOUNTS_THIS_MONTH.SYSTEM_NAME,
	            		VI_USED_AMOUNTS_THIS_MONTH.USED_AMOUNTS,
		            	BI_M_SYSTEMS.SYSTEM_ID AS SYSTEM_ID
	            	FROM BILLING_INFRASTRUCTURE.VIEW_USED_AMOUNTS_THIS_MONTH AS VI_USED_AMOUNTS_THIS_MONTH
	            	INNER JOIN BILLING_INFRASTRUCTURE.M_SYSTEMS AS BI_M_SYSTEMS ON BI_M_SYSTEMS.SYSTEM_NAME = VI_USED_AMOUNTS_THIS_MONTH.SYSTEM_NAME
	            	INNER JOIN USER_INFRASTRUCTURE.T_MANAGE_REQUEST AS UI_T_MANAGE_REQUEST ON VI_USED_AMOUNTS_THIS_MONTH.COMPANY_CODE = UI_T_MANAGE_REQUEST.COMPANY_CODE
	            	AND UI_T_MANAGE_REQUEST.SYSTEM_USABLE_FLAG = '3'
	            	AND BI_M_SYSTEMS.SYSTEM_ID = UI_T_MANAGE_REQUEST.SYSTEM_ID) AS IN_AMOUNTS ON IN_AMOUNTS.COMPANY_CODE = IN_M_CONTRACT.COMPANY_CODE
            AND IN_AMOUNTS.CONTRACT_ID = IN_M_CONTRACT.CONTRACT_ID
            AND (IN_AMOUNTS.USED_AMOUNTS < IN_M_CONTRACT.AMOUNT_UPPER_LIMIT
            					OR IN_M_CONTRACT.AMOUNT_UPPER_LIMIT = '0' OR IN_M_CONTRACT.AMOUNT_UPPER_LIMIT is null)
          --  AND IN_M_CONTRACT.SERVICE_USABLE_STATUS = '停止'
        '''
        param = {}
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# -----------障害 #4909 利用料金の上限以上------20231213-------------------E

# 更新履歴の追加
def set_data_to_user_infrastructure_m_update_company_info_history(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_update_company_info_history!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_UPDATE_COMPANY_INFO_HISTORY:
               tmp[key] = record[key]
        record = tmp
        # 検証
        res_validation = validate(user_infrastructure.M_UPDATE_COMPANY_INFO_HISTORY, record)
        if res_validation != True:
            return error_400(res_validation)

        dt_now = datetime.datetime.now()
        # logger.info(dt_now)
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MUpdateCompanyInfoHistory()

        m_param.auth0_user_id = record['auth0_user_id']['value']
        # m_param.update_from = '企業情報修正サイト'
        m_param.update_date = dt_now
        
        if 'temp_service_sleep_start_date' in record and 'value' in record['temp_service_sleep_start_date']:
            if record['temp_service_sleep_start_date']['value'] == '':
                record['temp_service_sleep_start_date']['value'] = None
        if 'temp_service_sleep_restart_date' in record and 'value' in record['temp_service_sleep_restart_date']:
            if record['temp_service_sleep_restart_date']['value'] == '':
                record['temp_service_sleep_restart_date']['value'] = None

        # rows = pdbc.select('user_infrastructure', m_param)

        # m_param = user_infrastructure.MUpdateCompanyInfoHistory()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.update_date = dt_now
        logger.info(m_param)
        
        result = pdbc.insert('user_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# user_infrastructure m_update_company_info_history E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_contract S

# フェーズ2 ------------------------S

def get_data_from_user_infrastructure_m_contract(event, context):
    
    logger.info('get_data_from_user_infrastructure_m_contract!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_SEND_MAIL, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
            
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = user_infrastructure.MContract()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key]['value'])
        result = pdbc.select('user_infrastructure', m_param)
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

def set_data_to_user_infrastructure_m_contract(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_contract!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        print(record)
        tmp = {}
        for key in record:
            if key in user_infrastructure.M_CONTRACT:
               tmp[key] = record[key]
        record = tmp
           
        # 検証
        res_validation = validate(user_infrastructure.M_CONTRACT, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MContract()
        m_param.company_code = record['company_code']['value']
        m_param.contract_id = record['contract_id']['value']
        # m_param.applicable_start_date = record['applicable_start_date']['value']
        rows = pdbc.select('user_infrastructure', m_param)

        # フェーズ2 ------------------------S
        # if record['subscription_start_date']['value'] == '':
        #     record['subscription_start_date']['value'] = None
        # if record['subscription_end_date']['value'] == '':
        #     record['subscription_end_date']['value'] = None
        if 'subscription_start_date' in record and 'value' in record['subscription_start_date']:
            if record['subscription_start_date']['value'] == '':
                record['subscription_start_date']['value'] = None
        if 'subscription_end_date' in record and 'value' in record['subscription_end_date']:
            if record['subscription_end_date']['value'] == '':
                record['subscription_end_date']['value'] = None
        # フェーズ2 ------------------------E

        # フェーズ2 ------------------------S
        # バグ #2794 ------------------------S
        # 適用終了日に契約終了日が設定されない。
        # 適用終了日にも契約終了日と同じ日を設定する必要がある。
        if 'subscription_end_date' in record and 'value' in record['subscription_end_date']:
            record["applicable_end_date"] = {}
            record["applicable_end_date"]["value"] = record["subscription_end_date"]["value"]
        # バグ #2794 ------------------------E
        # フェーズ2 ------------------------E
          
        m_param = user_infrastructure.MContract()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.udate = dt_now
        logger.info(m_param.__dict__)
        
        logger.info(m_param)
        
        if len(rows) > 0:
            m_condition_param = user_infrastructure.MContract()
            m_condition_param.company_code = record['company_code']['value']
            m_condition_param.contract_id = record['contract_id']['value']
            # m_condition_param.applicable_start_date = record['applicable_start_date']['value']
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            
            # 2022-09-14
            # 初回登録時に適用開始日に月初を入れて、適用終了日は空欄固定になりました。
            # 適用開始日
            m_param.applicable_start_date = dt_now.replace(day=1).date()
            # 適用終了日
            m_param.applicable_end_date = None
            
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        'body': json.dumps(res)
        # 'body': json.dumps(res, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def update_data_to_user_infrastructure_m_contract(event, context):
    
    logger.info('update_data_to_user_infrastructure_m_contract!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
       
        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        is_insert = False
        res_validation = validate(user_infrastructure.M_CONTRACT, record['condition_value'], is_insert)
        if res_validation != True:
            return error_400(res_validation)
        res_validation = validate(user_infrastructure.M_CONTRACT, record['new_value'], is_insert)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        # 検索
        m_param = user_infrastructure.MContract()
        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
        rows = pdbc.select('user_infrastructure', m_param)
        
        # 値セット
        m_param = user_infrastructure.MContract()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            # データ更新
            m_condition_param = user_infrastructure.MContract()
            for key in record['condition_value']:
                if 'value' in record['condition_value'][key]:
                    setattr(m_condition_param, key, record['condition_value'][key]['value'])
            if len(m_condition_param.__dict__) > 0:
                result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E
  
# user_infrastructure m_contract E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_contract_product S

def get_data_from_user_infrastructure_m_contract_product(event, context):
    
    logger.info('get_data_from_user_infrastructure_m_contract_product!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_CONTRACT_PRODUCT_WHERE, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}

        if "contract_id" in query_string_parameters:
            sql = '''
                SELECT
                    contract_product_id,
                    contract_id,
                    product_id
                FROM
                    user_infrastructure.m_contract_product
                WHERE
                    contract_id = %(contract_id)s
            '''
            print(sql)
            param = {}
            param["contract_id"] = query_string_parameters["contract_id"]
            result = pdbc.select_param(sql, param)
            print(result)
        
            if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
                return result
            
            res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def set_data_to_user_infrastructure_m_contract_product(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_contract_product!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
                
        # 検証
        res_validation = validate(user_infrastructure.M_CONTRACT_PRODUCT, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
       
        m_param = user_infrastructure.MContractProduct()
        m_param.contract_id = record['contract_id']['value']
        m_param.product_id = record['product_id']['value']
        rows = pdbc.select('user_infrastructure', m_param)
        
        # 値セット
        m_param = user_infrastructure.MContractProduct()
        # m_param.contract_product_id = contract_product_id
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.udate = dt_now
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            pass
        else:
            # データ追加
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def delete_data_from_user_infrastructure_m_contract_product(event, context):
    
    logger.info('delete_data_from_user_infrastructure_m_contract_product!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
      
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MContractProduct()
        m_param.contract_id = query_string_parameters['contract_id']
        m_param.product_id = query_string_parameters['product_id']
        result = pdbc.delete('user_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        print(result)
        
        res['result'] = result
        
        print(res)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# user_infrastructure m_contract_product E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure　m_new_biz_sys_sales_category S
  
def set_data_to_user_infrastructure_m_new_biz_sys_sales_category(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_new_biz_sys_sales_category!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        # フェーズ2 ------------------------S
        # 検証
        res_validation = validate(user_infrastructure.M_NEW_BIZ_SYS_SALES_CATEGORY, record)
        if res_validation != True:
            return error_400(res_validation)
        # フェーズ2 ------------------------E
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MNewBizSysSalesCategory()
        m_param.sales_category_id = record['sales_category_id']['value']
        rows = pdbc.select('user_infrastructure', m_param)
       
        m_param = user_infrastructure.MNewBizSysSalesCategory()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = user_infrastructure.MNewBizSysSalesCategory()
            m_condition_param.sales_category_id = record['sales_category_id']['value']
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def delete_data_from_user_infrastructure_m_new_biz_sys_sales_category(event, context):
    
    logger.info('delete_data_from_user_infrastructure_m_new_biz_sys_sales_category!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        if 'sales_category_id' in query_string_parameters:
            pass
        else:
            return error_400('「売上区分ID」の値が設定されていません。')
                
        #データベース接続
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = user_infrastructure.MNewBizSysSalesCategory()
        m_param.sales_category_id = query_string_parameters['sales_category_id']
        result = pdbc.delete('user_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        print(result)
        
        res['result'] = result
        
        print(res)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# user_infrastructure　m_new_biz_sys_sales_category E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_new_biz_sys_info S

def set_data_to_user_infrastructure_m_new_biz_sys_info(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_new_biz_sys_info!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
                
        # 検証
        res_validation = validate(user_infrastructure.M_NEW_BIZ_SYS_INFO, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MNewBizSysInfo()
        m_param.new_biz_sys_info_id = record['new_biz_sys_info_id']['value']
        rows = pdbc.select('user_infrastructure', m_param)
        
        m_param = user_infrastructure.MNewBizSysInfo()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.udate = dt_now
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = user_infrastructure.MNewBizSysInfo()
            m_condition_param.new_biz_sys_info_id = record['new_biz_sys_info_id']['value']
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def delete_data_from_user_infrastructure_m_new_biz_sys_info(event, context):
    
    logger.info('delete_data_from_user_infrastructure_m_new_biz_sys_info!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        else:
            return error_400('パラメーターの設定が正しくありません。')
    
        if 'new_biz_sys_info_id' in query_string_parameters:
            pass
        else:
            return error_400('新業務システム情報マスタIDの値が設定されていません。')
                
        #データベース接続
        
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = user_infrastructure.MNewBizSysInfo()
        m_param.new_biz_sys_info_id = query_string_parameters['new_biz_sys_info_id']
        result = pdbc.delete('user_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        print(result)
        
        res['result'] = result
        
        print(res)
                    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# user_infrastructure m_new_biz_sys_info E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_send_mail S

def set_data_to_user_infrastructure_m_send_mail(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_send_mail!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
                
        # 検証
        res_validation = validate(user_infrastructure.M_SEND_MAIL, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MSendMail()
        m_param.mail_id = record['mail_id']['value']
        rows = pdbc.select('user_infrastructure', m_param)
        print('rows---------------------------')
        print(rows)
        
        m_param = user_infrastructure.MSendMail()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.udate = dt_now
        logger.info(m_param.__dict__)
                
        # !!!
        if m_param.mail_to is None:
            m_param.mail_to = ''
            
        if len(rows) > 0:
            m_condition_param = user_infrastructure.MSendMail()
            m_condition_param.mail_id = record['mail_id']['value']
            result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def get_data_from_user_infrastructure_m_send_mail(event, context):
    
    logger.info('get_data_from_user_infrastructure_m_send_mail!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_SEND_MAIL, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = user_infrastructure.MSendMail()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key])
        result = pdbc.select('user_infrastructure', m_param)
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# user_infrastructure m_send_mail E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# user_infrastructure m_service_stop_history S

# フェーズ2 ------------------------S

def set_data_to_user_infrastructure_m_service_stop_history(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_service_stop_history!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']

        tmp = {}
        for key in record:
            if key in user_infrastructure.M_SERVICE_STOP_HISTORY:
               tmp[key] = record[key]
        record = tmp
        
        # 検証
        res_validation = validate(user_infrastructure.M_SERVICE_STOP_HISTORY, record)
        if res_validation != True:
            return error_400(res_validation)

        dt_now = datetime.datetime.now()
        # logger.info(dt_now)
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = user_infrastructure.MServiceStopHistory()

        if 'service_stop_start_date' in record and 'value' in record['service_stop_start_date']:
            if record['service_stop_start_date']['value'] == '':
                record['service_stop_start_date']['value'] = None
        if 'service_stop_end_date' in record and 'value' in record['service_stop_end_date']:
            if record['service_stop_end_date']['value'] == '':
                record['service_stop_end_date']['value'] = None

        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])

        m_param.cdate = dt_now
        m_param.udate = dt_now
        
        logger.info(m_param)
        
        result = pdbc.insert('user_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def update_data_to_user_infrastructure_m_service_stop_history(event, context):
    
    logger.info('update_data_to_user_infrastructure_m_service_stop_history!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        dt_now = datetime.datetime.now()
                
        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        is_insert = False
        res_validation = validate(user_infrastructure.M_SERVICE_STOP_HISTORY, record['condition_value'], is_insert)
        if res_validation != True:
            return error_400(res_validation)
        res_validation = validate(user_infrastructure.M_SERVICE_STOP_HISTORY, record['new_value'], is_insert)
        if res_validation != True:
            return error_400(res_validation)
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        # 検索
        m_param = user_infrastructure.MServiceStopHistory()
        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
        rows = pdbc.select('user_infrastructure', m_param)
        
        # 値セット
        m_param = user_infrastructure.MServiceStopHistory()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            # データ更新
            m_condition_param = user_infrastructure.MServiceStopHistory()
            for key in record['condition_value']:
                if 'value' in record['condition_value'][key]:
                    setattr(m_condition_param, key, record['condition_value'][key]['value'])
            if len(m_condition_param.__dict__) > 0:
                m_param.udate = dt_now
                result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E
    
# user_infrastructure m_service_stop_history E
# --------------------------------------------------------------------

# user_infrastructure E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# billing_infrastructure S

# --------------------------------------------------------------------
# billing_infrastructure m_systems S

def set_data_to_billing_infrastructure_m_systems(event, context):
    
    logger.info('set_data_to_billing_infrastructure_m_systems!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
               
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']

        # 検証
        res_validation = validate(billing_infrastructure.M_SYSTEMS, record)
        if res_validation != True:
            return error_400(res_validation)
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = billing_infrastructure.MSystems()
        m_param.system_id = record['system_id']['value']
        rows = pdbc.select('billing_infrastructure', m_param)
         
        m_param = billing_infrastructure.MSystems()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = billing_infrastructure.MSystems()
            m_condition_param.system_id = record['system_id']['value']
            result = pdbc.update('billing_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('billing_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# billing_infrastructure m_systems E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# billing_infrastructure m_services S

# フェーズ2 ------------------------S

# m_services GET
def get_data_from_billing_infrastructure_m_services(event, context):
    
    logger.info('get_data_from_billing_infrastructure_m_services!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        dt_now = datetime.datetime.now()
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = billing_infrastructure.MServices()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key]['value'])
        result = pdbc.select('billing_infrastructure', m_param)
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# m_services DELETE
def delete_data_from_billing_infrastructure_m_services(event, context):
    
    logger.info('delete_data_from_billing_infrastructure_m_services!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
      
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = billing_infrastructure.MServices()
        m_param.service_id = query_string_parameters['service_id']
        m_param.service_name = query_string_parameters['service_name']
        m_param.system_id = query_string_parameters['system_id']
        result = pdbc.delete('billing_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        print(result)
        
        res['result'] = result
        
        print(res)
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
      
# m_services POST
def set_data_to_billing_infrastructure_m_services(event, context):
    
    logger.info('set_data_to_billing_infrastructure_m_services!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']

        # 検証
        res_validation = validate(billing_infrastructure.M_SERVICES, record)
        if res_validation != True:
            return error_400(res_validation)

        dt_now = datetime.datetime.now()
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = billing_infrastructure.MServices()
        m_param.service_id = record['service_id']['value']
        rows = pdbc.select('billing_infrastructure', m_param)
       
        m_param = billing_infrastructure.MServices()
        for key in record:
            # フェーズ2 ------------------------S
            # if 'value' in record[key]:
            if key != 'sales_category_id_list' and 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
            # フェーズ2 ------------------------E
        use_smartbilling = False
        if record['use_smartbilling']['value'] == '使う':
            use_smartbilling = True
        else:
            use_smartbilling = False
        m_param.use_smartbilling = use_smartbilling
        m_param.udate = dt_now
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = billing_infrastructure.MServices()
            m_condition_param.service_id = record['service_id']['value']
            result = pdbc.update('billing_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('billing_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# billing_infrastructure m_services E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# billing_infrastructure m_regular_products S

# m_regular_products POST
def set_data_to_billing_infrastructure_m_regular_products(event, context):
    
    logger.info('set_data_to_billing_infrastructure_m_regular_products!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
                
        # 検証
        res_validation = validate(billing_infrastructure.M_REGULAR_PRODUCTS, record)
        if res_validation != True:
            return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        m_param = billing_infrastructure.MRegularProducts()
        m_param.product_id = record['product_id']['value']
        # m_param.product_code = record['product_code']['value']
        # m_param.applicable_start_date = record['applicable_start_date']['value']
        rows = pdbc.select('billing_infrastructure', m_param)
        
        m_param = billing_infrastructure.MRegularProducts()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.udate = dt_now
        logger.info(m_param.__dict__)
        
        # # 適用開始日
        # if m_param.applicable_start_date == '' or m_param.applicable_start_date is None:
        #     res = {}
        #     res['error_code'] = ''
        #     res['error_message'] = '「適用開始日」が正しくありません。'
        #     return {
        #         'statusCode': 400,
        #         'headers': RESPONSE_HEADERS,
        #         'body': json.dumps(res)
        #     }
                            
        # 適用終了日
        if m_param.applicable_end_date == '':
            m_param.applicable_end_date = None
        else:
            if m_param.applicable_end_date is not None:
                try:
                    datetime.datetime.strptime(m_param.applicable_end_date,"%Y/%m/%d")
                except ValueError:
                    res = {}
                    res['error_code'] = ''
                    res['error_message'] = '「適用終了日」が正しくありません。'
                    return {
                        'statusCode': 400,
                        'headers': RESPONSE_HEADERS,
                        # 'body': json.dumps(res)
                        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
                    }

        # 単金（円）
        if m_param.one_off_payment == '':
            m_param.one_off_payment = None
        # カタログ金額（円)
        if m_param.catalog_amount == '':
            m_param.catalog_amount = None
        # テキ05 売上報告出力位置
        if m_param.sales_report_position == '':
            m_param.sales_report_position = None
        # テキ06 利用明細表示順番
        if m_param.itemized_account_position == '':
            m_param.itemized_account_position = None
        
        logger.info(m_param)
        
        result = {}
        
        if len(rows) > 0:
            m_condition_param = billing_infrastructure.MRegularProducts()
            m_condition_param.product_id = record['product_id']['value']
            # m_condition_param.product_code = record['product_code']['value']
            # m_condition_param.applicable_start_date = record['applicable_start_date']['value']
            result = pdbc.update('billing_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('billing_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# billing_infrastructure m_regular_products E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# billing_infrastructure m_services_and_related_sales_categories S

# フェーズ2 ------------------------S

# m_services_and_related_sales_categories GET
def get_data_from_billing_infrastructure_m_services_and_related_sales_categories(event, context):
    
    logger.info('get_data_from_billing_infrastructure_m_services_and_related_sales_categories!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        # res_validation = validate(user_infrastructure.M_SEND_MAIL, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        dt_now = datetime.datetime.now()
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = billing_infrastructure.MServicesAndRelatedSalesCategories()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key])
        result = pdbc.select('billing_infrastructure', m_param)
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# m_services_and_related_sales_categories POST
def set_data_to_billing_infrastructure_m_services_and_related_sales_categories(event, context):
    
    logger.info('set_data_to_billing_infrastructure_m_services_and_related_sales_categories!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        if 'service_id' in record and 'value' in record['service_id'] and record['service_id']['value']:
            pass
        else:
            return error_400('サービスIDの値が設定されていません。')

        result = delete_data_from_billing_infrastructure_m_services_and_related_sales_categories(event, context)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
                    
        if 'sales_category_id_list' in record and 'value' in record['sales_category_id_list'] and len(record['sales_category_id_list']['value']) > 0:
                   
            for sales_category_id in record['sales_category_id_list']['value']:
                
                tmp_record = {}
                tmp_record['service_id'] = {}
                tmp_record['service_id']['value'] = record['service_id']['value']
                tmp_record['sales_category_id'] = {}
                tmp_record['sales_category_id']['value'] = sales_category_id

                # 検証
                res_validation = validate(billing_infrastructure.M_SERVICES_AND_RELATED_SALES_CATEGORIES, tmp_record)
                if res_validation != True:
                    return error_400(res_validation)

                #データベース登録
            
                pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
            
                m_param = billing_infrastructure.MServicesAndRelatedSalesCategories()
                m_param.service_id = tmp_record['service_id']['value']
                m_param.sales_category_id = tmp_record['sales_category_id']['value']
                result = pdbc.insert('billing_infrastructure', m_param)
                
                if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
                    return result
        
                res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# m_services_and_related_sales_categories DELETE
def delete_data_from_billing_infrastructure_m_services_and_related_sales_categories(event, context):
    
    logger.info('delete_data_from_billing_infrastructure_m_services_and_related_sales_categories!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        if 'service_id' in record and 'value' in record['service_id'] and record['service_id']['value']:
            pass
        else:
            return error_400('サービスIDの値が設定されていません。')
        
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
            
        m_param = billing_infrastructure.MServicesAndRelatedSalesCategories()
        m_param.service_id = record['service_id']['value']
        result = pdbc.delete('billing_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
                
        res['result'] = result
                    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# billing_infrastructure m_services_and_related_sales_categories E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# billing_infrastructure m_estimated_order_amounts S

# フェーズ2 ------------------------S

# m_estimated_order_amounts POST
def set_data_to_billing_infrastructure_m_estimated_order_amounts(event, context):
    
    logger.info('set_data_to_billing_infrastructure_m_estimated_order_amounts!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        # 検証
        res_validation = validate(billing_infrastructure.M_ESTIMATED_ORDER_AMOUNTS, record)
        if res_validation != True:
            return error_400(res_validation)

        #データベース登録
        
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = billing_infrastructure.MEstimatedOrderAmounts()
        m_param.company_code = record['company_code']['value']
        m_param.sales_category_id = record['sales_category_id']['value']
        rows = pdbc.select('billing_infrastructure', m_param)
        
        m_param = billing_infrastructure.MEstimatedOrderAmounts()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = billing_infrastructure.MEstimatedOrderAmounts()
            m_condition_param.company_code = record['company_code']['value']
            m_condition_param.sales_category_id = record['sales_category_id']['value']
            result = pdbc.update('billing_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('billing_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# m_estimated_order_amounts DELETE
def delete_data_from_billing_infrastructure_m_estimated_order_amounts(event, context):
    
    logger.info('delete_data_from_billing_infrastructure_m_estimated_order_amounts!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        else:
            return error_400('パラメーターの設定が正しくありません。')
    
        if 'company_code' in query_string_parameters:
            pass
        else:
            return error_400('企業コードの値が設定されていません。')
        
        if 'sales_category_id' in query_string_parameters:
            pass
        else:
            return error_400('売上区分IDの値が設定されていません。')
        
        #データベース登録
        
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = billing_infrastructure.MEstimatedOrderAmounts()
        m_param.company_code = query_string_parameters['company_code']
        m_param.sales_category_id = query_string_parameters['sales_category_id']
        result = pdbc.delete('billing_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        print(result)
        
        res['result'] = result
        
        print(res)
                    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# billing_infrastructure m_estimated_order_amounts E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# billing_infrastructure tax_rate S

# フェーズ2 ------------------------S

# tax_rate POST
def set_data_to_billing_infrastructure_tax_rate(event, context):
    
    logger.info('set_data_to_billing_infrastructure_tax_rate!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        # 検証
        res_validation = validate(billing_infrastructure.tax_rate, record)
        if res_validation != True:
            return error_400(res_validation)

        #データベース登録
        
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = billing_infrastructure.TaxRate()
        m_param.taxation_code_id = record['taxation_code_id']['value']
        rows = pdbc.select('billing_infrastructure', m_param)
        
        m_param = billing_infrastructure.TaxRate()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = billing_infrastructure.TaxRate()
            m_condition_param.taxation_code_id = record['taxation_code_id']['value']
            result = pdbc.update('billing_infrastructure', m_param, m_condition_param)
        else:
            result = pdbc.insert('billing_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# tax_rate DELETE
def delete_data_from_billing_infrastructure_tax_rate(event, context):
    
    logger.info('delete_data_from_billing_infrastructure_tax_rate!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        else:
            return error_400('パラメーターの設定が正しくありません。')
    
        if 'taxation_code_id' in query_string_parameters:
            pass
        else:
            return error_400('課税区分IDの値が設定されていません。')
        
        #データベース登録
        
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = billing_infrastructure.TaxRate()
        m_param.taxation_code_id = query_string_parameters['taxation_code_id']
        result = pdbc.delete('billing_infrastructure', m_param)

        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        print(result)
        
        res['result'] = result
        
        print(res)
                    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# billing_infrastructure tax_rate E
# --------------------------------------------------------------------

# billing_infrastructure E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# mscone_lic S

# --------------------------------------------------------------------
# mscone_lic m_company S

# m_company POST
def set_data_to_mscone_lic_m_company(event, context):
    
    logger.info('set_data_to_mscone_lic_m_company!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']

        # 検証
        # フェーズ2 ------------------------S
        # res_validation = validate(mscone_lic.M_COMPANY, record)
        # if res_validation != True:
        #     return error_400(res_validation)
        if 'account_registration_only' in record and 'value' in record['account_registration_only']:
            del record['account_registration_only']
        else:
            res_validation = validate(mscone_lic.M_COMPANY, record)
            if res_validation != True:
                return error_400(res_validation)
        # フェーズ2 ------------------------E
        
        dt_now = datetime.datetime.now()
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_MSCONE_LIC)
        m_param = mscone_lic.MCompany()
        m_param.company_code = record['company_code']['value']
        rows = pdbc.select('mscone_lic', m_param)
 
        # m_param = mscone_lic.MCompany()
        # m_param.stack_name = record['stack_name']['value']
        # m_param.netuse_command = record['netuse_command']['value']
        # m_param.access_key = record['access_key']['value']
        # m_param.bridge_instance_id = record['bridge_instance_id']['value']
        # m_param.update_date = dt_now
        
        m_param = mscone_lic.MCompany()
        for key in record:
            if 'value' in record[key]:
                setattr(m_param, key, record[key]['value'])
        m_param.update_date = dt_now
        logger.info(m_param.__dict__)
        
        if len(rows) > 0:
            m_condition_param = mscone_lic.MCompany()
            m_condition_param.company_code = record['company_code']['value']
            result = pdbc.update('mscone_lic', m_param, m_condition_param)
        else:
            m_param.insert_date = dt_now
            m_param.company_code = record['company_code']['value']
            logger.info('m_param')
            logger.info(m_param)
            result = pdbc.insert('mscone_lic', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def get_data_from_mscone_lic_m_company(event, context):
    
    logger.info('get_data_from_mscone_lic_m_company!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
       
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_MSCONE_LIC)
        
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
                    
        m_param = mscone_lic.MCompany()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key]['value'])
        result = pdbc.select('mscone_lic', m_param)
        
        # print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# mscone_lic m_company E
# --------------------------------------------------------------------

# --------------------------------------------------------------------
# mscone_lic m_directory_user S

def set_data_to_mscone_lic_m_directory_user(event, context):
    
    logger.info('set_data_to_mscone_lic_m_directory_user!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_MSCONE_LIC)
        m_directory_user_param = mscone_lic.MDirectoryUser()
        m_directory_user_param.company_code = record['company_code']['value']
        rows = pdbc.select('mscone_lic', m_directory_user_param)
       
        if len(rows) > 0:
            # for item in rows:  
            #     if item['directory_username'].endswith('.user000') and record['user_email']['value'] != '':
            #         m_directory_user_condition_param = mscone_lic.MDirectoryUser()
            #         m_directory_user_condition_param.company_code = item['company_code']
            #         m_directory_user_condition_param.directory_username = item['directory_username']

            #         m_directory_user_param = mscone_lic.MDirectoryUser()
            #         # m_directory_user_param.directory_username = record['directory_username']['value']
            #         m_directory_user_param.user_email = record['user_email']['value']
        
            #         result = pdbc.update('mscone_lic', m_directory_user_param, m_directory_user_condition_param)
            #         break
            result = None
            pass
        else:
            new_ids = []
            # for i in range(5):
            for i in range(10):
                m_directory_user_param = mscone_lic.MDirectoryUser()
                m_directory_user_param.company_code = record['company_code']['value']
                m_directory_user_param.directory_username = record['company_code']['value'] + '.user' + str(i).zfill(3)
                # if i == 0:
                #     #管理者ユーザー登録
                #     m_directory_user_param.user_email = record['user_email']['value']
                id = pdbc.insert('mscone_lic', m_directory_user_param)
                new_ids.append(id)
            result = new_ids
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------S

def update_data_to_mscone_lic_m_directory_user(event, context):
    
    logger.info('update_data_to_mscone_lic_m_directory_user!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
                
        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        # is_insert = False
        # res_validation = validate(mscone_lic.M, record['condition_value'], is_insert)
        # if res_validation != True:
        #     return error_400(res_validation)
        # res_validation = validate(mscone_lic.MDirectoryUser, record['new_value'], is_insert)
        # if res_validation != True:
        #     return error_400(res_validation)
        
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_MSCONE_LIC)

        # 検索
        m_param = mscone_lic.MDirectoryUser()
        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
        rows = pdbc.select('mscone_lic', m_param)
        
        # 値セット
        m_param = mscone_lic.MDirectoryUser()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            # データ更新
            m_condition_param = mscone_lic.MDirectoryUser()
            for key in record['condition_value']:
                if 'value' in record['condition_value'][key]:
                    setattr(m_condition_param, key, record['condition_value'][key]['value'])
            if len(m_condition_param.__dict__) > 0:
                result = pdbc.update('mscone_lic', m_param, m_condition_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# フェーズ2 ------------------------E

# mscone_lic m_directory_user E
# --------------------------------------------------------------------

# mscone_lic E
# --------------------------------------------------------------------


def get_value(key, items):
    
    value = None
    
    if key in items:
        
        # Kintoneからのデータの場合
        if 'value' in items[key]:
            value = items[key]['value']
        else:
            value = items[key]
            
        if isinstance(value, str):
            value = value.strip()
            
    return value

def set_value(key, value, items):
    
    if key in items:
        # Kintoneからのデータの場合
        if 'value' in items[key]:
            items[key]['value'] = value
        else:
            items[key] = value
           
    return items

def error_400(message, code = None):
    body = {
        'error_code': code,
        'error_message': message
    }
    return {
        'statusCode': 400,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(body)
        'body': json.dumps(body, ensure_ascii=False, indent=2)
    }

def check_hankaku_eisu_kigo(target):
    MOJI = """ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~"""
    for c in target:
        if c not in MOJI:
            return False
    return True
        
def check_account_name(account_name):
    MOJI = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789ｦｧｨｩｪｫｬｭｮｯ-ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾂﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝｶﾞｷﾞｸﾞｹﾞｺﾞｻﾞｼﾞｽﾞｾﾞｿﾞﾀﾞﾁﾞﾂﾞﾃﾞﾄﾞﾊﾞﾋﾞﾌﾞﾍﾞﾎﾞﾊﾟﾋﾟﾌﾟﾍﾟﾎﾟ,. )(\/｢｣-'
    for c in account_name:
        if c not in MOJI:
            return False
    return True

def get_data_user_infrastructure_m_entry_site_app_settings_confirmed(event, context):
    
    logger.info('get_data_user_infrastructure_m_entry_site_app_settings_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '画面'
            --*CaptionFromComment
            SELECT 
                M_SYSTEMS.SUB_DOMAIN_NAME AS ID,
	            M_SYSTEMS.SUB_DOMAIN_NAME || '.json' AS FILENAME ,
	            M_ENTRY_SITE_APP_SETTINGS_CONFIRMED.*
            FROM USER_INFRASTRUCTURE.M_ENTRY_SITE_APP_SETTINGS_CONFIRMED
                LEFT JOIN BILLING_INFRASTRUCTURE.M_SYSTEMS ON M_SYSTEMS.SYSTEM_ID = M_ENTRY_SITE_APP_SETTINGS_CONFIRMED.SYSTEM_ID
            ORDER BY M_ENTRY_SITE_APP_SETTINGS_CONFIRMED.ENTRY_SITE_APP_SETTING_ID
        '''
        param = {}
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(event, context):
    
    logger.info('get_data_user_infrastructure_m_entry_site_questionnaire_manage_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    system_id = ''
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if 'system_id' in query_string_parameters:
            if type(query_string_parameters['system_id']) is str:
                tmp = json.loads(query_string_parameters['system_id'])
                if 'value' in tmp:
                    system_id = tmp['value']
            else:
                if 'value' in query_string_parameters['system_id']:
                    system_id = query_string_parameters['system_id']['value']
                    
        if query_string_parameters['system_id']:
            pass
        else:
            msg = 'システムID「system_id」が正しく設定されていません。'
            return error_400(msg)    
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '画面'
            --*CaptionFromComment
              SELECT SYSTEM_ID -- サービスID
             ,QUESTIONNAIRE_LOCATION -- サービス名
             ,QUESTIONNAIRE_QUESTION -- ユーザポータルサイトの表示名
             ,QUESTIONNAIRE_ANSWER_CHOICES -- GMO掛け払いの枠保証額の申請時の上限額
             ,REQUIRED -- サブディレクトリ名
             ,CASE QUESTIONNAIRE_ANSER_TYPE
            					WHEN 'チェックボックス' THEN 'checkbox'
            					WHEN 'ラジオボタン' THEN 'radio'
            					WHEN '自由記入欄' THEN 'textarea'
            					ELSE 'text'
            	END AS QUESTIONNAIRE_ANSER_TYPE
            FROM USER_INFRASTRUCTURE.M_ENTRY_SITE_QUESTIONNAIRE_MANAGE_CONFIRMED
            WHERE SYSTEM_ID = %(system_id)s
            ORDER BY M_ENTRY_SITE_QUESTIONNAIRE_MANAGE_CONFIRMED.questionnaire_temp_id    
        '''
        param = {}
        param['system_id'] = system_id
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_user_infrastructure_m_entry_site_document_request_manage_confirmed(event, context):
    
    logger.info('get_data_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    system_id = ''
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if 'system_id' in query_string_parameters:
            if type(query_string_parameters['system_id']) is str:
                tmp = json.loads(query_string_parameters['system_id'])
                if 'value' in tmp:
                    system_id = tmp['value']
            else:
                if 'value' in query_string_parameters['system_id']:
                    system_id = query_string_parameters['system_id']['value']
                    
        if query_string_parameters['system_id']:
            pass
        else:
            msg = 'システムID「system_id」が正しく設定されていません。'
            return error_400(msg)    
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '画面'
            --*CaptionFromComment
            SELECT SYSTEM_ID --
             ,	DOCUMENT_REQUEST_FILE_TITLE --
             ,	DOCUMENT_REQUEST_FILE_DESCRIPTION --
             ,	DOCUMENT_REQUEST_FILE_IMAGE_URL --
             ,	DOCUMENT_REQUEST_FILE_URL --
            FROM USER_INFRASTRUCTURE.M_ENTRY_SITE_DOCUMENT_REQUEST_MANAGE_CONFIRMED
            WHERE SYSTEM_ID = %(system_id)s
            ORDER BY DOCUMENT_REQUEST_FILE_TEMP_ID  
        '''
        param = {}
        param['system_id'] = system_id
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }


def get_data_mscone_lic_bridge_instance_id_SQL(event, context):
    logger.info('get_data_mscone_lic_bridge_instance_id_SQL!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    company_code = ''
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    company_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    company_code = query_string_parameters['company_code']['value']
                    
        if query_string_parameters['company_code']:
            pass
        else:
            msg = 'システムID「company_code」が正しく設定されていません。'
            return error_400(msg)    
        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_MSCONE_LIC)

        res['result'] = {}
        
        sql = '''
            --*DataTitle '画面'
            --*CaptionFromComment
            SELECT company_code --
             ,	bridge_instance_id
            FROM mscone_lic.m_company
            WHERE company_code = %(company_code)s
        '''
        param = {}
        param['company_code'] = company_code
        result = pdbc.select_param(sql,param)
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# ------------0611-------------S
def get_data_user_infrastructure_view_product_groups_billing_identifier(event, context):
    logger.info('get_data_user_infrastructure_view_product_groups_billing_identifier!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    system_id = ''
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
            
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        if 'system_id' in query_string_parameters:
            if type(query_string_parameters['system_id']) is str:
                tmp = json.loads(query_string_parameters['system_id'])
                if 'value' in tmp:
                    system_id = tmp['value']
            else:
                if 'value' in query_string_parameters['system_id']:
                    system_id = query_string_parameters['system_id']['value']
                    
        if query_string_parameters['system_id']:
            pass
        else:
            msg = 'システムID「system_id」が正しく設定されていません。'
            return error_400(msg)  
        #データベース登録
        print('-------データベース登録-------------')
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
        sql = '''
            --*CaptionFromComment
            SELECT product_group_id
             ,	product_group_name
             ,  main_product_id
             ,  display_flag
             ,  billing_identifier
            FROM user_infrastructure.view_product_groups_billing_identifier
            WHERE system_id = %(system_id)s
        '''
        print('-------sql-------------')
        param = {}
        param['system_id'] = system_id
        result = pdbc.select_param(sql,param)
        print('-------sqlresult-------------')
    
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
    
def set_data_to_user_infrastructure_t_contract_request_confirmed(event, context):
    logger.info('set_data_to_user_infrastructure_t_contract_request_confirmed!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
                
        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        # 検索
        m_param = user_infrastructure.TContractRequestConfirmed()
        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
        rows = pdbc.select('user_infrastructure', m_param)
        
        # 値セット
        m_param = user_infrastructure.TContractRequestConfirmed()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            # データ更新
            m_condition_param = user_infrastructure.TContractRequestConfirmed()
            for key in record['condition_value']:
                if 'value' in record['condition_value'][key]:
                    setattr(m_condition_param, key, record['condition_value'][key]['value'])
            if len(m_condition_param.__dict__) > 0:
                result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def set_data_to_user_infrastructure_m_contract_product_post(event, context):
    logger.info('set_data_to_user_infrastructure_m_contract_product_post!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        # print("-----------record['condition_value']-------------------")
        # print(record['condition_value'])
        # print("-----------record['new_value']-------------------")
        # print(record['condition_value'])
    
                
        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        # 検索
        m_param = user_infrastructure.MContractProduct()
        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
        rows = pdbc.select('user_infrastructure', m_param)
        
        # 値セット
        m_param = user_infrastructure.MContractProduct()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        logger.info(m_param.__dict__)
               
        result = None
        
        if len(rows) > 0:
            # データ更新
            m_condition_param = user_infrastructure.MContractProduct()
            for key in record['condition_value']:
                if 'value' in record['condition_value'][key]:
                    setattr(m_condition_param, key, record['condition_value'][key]['value'])
            if len(m_condition_param.__dict__) > 0:
                print("-----------recor-------------------")
                print(record)
                result = pdbc.update('user_infrastructure', m_param, m_condition_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_from_user_infrastructure_m_contract_product_check(event, context):
    
    logger.info('get_data_from_user_infrastructure_m_contract_product_check!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
                
        # # 検証
        if type(query_string_parameters) is str:
            query_string_parameters = json.loads(query_string_parameters)
            
        #データベース
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
        
        m_param = user_infrastructure.MContractProduct()
        for key in query_string_parameters:
            setattr(m_param, key, query_string_parameters[key]['value'])
        result = pdbc.select('user_infrastructure', m_param)
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_data_from_user_infrastructure_m_regular_products(event, context):
    
    logger.info('get_data_from_user_infrastructure_m_regular_products!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
                
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        if 'product_group_id' in query_string_parameters:
            if type(query_string_parameters['product_group_id']) is str:
                tmp = json.loads(query_string_parameters['product_group_id'])
                if 'value' in tmp:
                    product_group_id = tmp['value']
            else:
                if 'value' in query_string_parameters['product_group_id']:
                    product_group_id = query_string_parameters['product_group_id']['value']
                    
        if product_group_id == '':
            msg = 'パラメーター「product_group_id」が正しく設定されていません。'
            return error_400(msg)
            
        print('product_group_id-----------')
        print(product_group_id)
                
        #データベース登録
        print('-------データベース登録-------------')
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        res['result'] = {}
        
    #   product_group_id_str = ','.join(product_group_id)
        
        sql = '''
            --*CaptionFromComment
            SELECT product_group_id
             ,	product_code
             ,  product_id
            FROM billing_infrastructure.m_regular_products
            WHERE
                billing_infrastructure.m_regular_products.product_group_id = ANY( %(product_group_id)s )
        '''
        print('-------sql-------------')
        param = {}
        param["product_group_id"] = product_group_id
        result = pdbc.select_param(sql,param)
        print('-------sqlresult-------------')
        
        print(result)   
            
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        res['result'] = result
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
    
def set_data_to_user_infrastructure_m_contract_product_insert(event, context):
    
    logger.info('set_data_to_user_infrastructure_m_contract_product_insert!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
                
        event_body = {}
        event_body = json.loads(event['body'])
        
        record = event_body['record']
        # print("-----------record['condition_value']-------------------")
        # print(record['condition_value'])
        # print("-----------record['new_value']-------------------")
        # print(record['new_value'])
    
                
        # 検証
        if 'condition_value' not in record:
            return error_400('更新条件の値が設定されていません。')
        if 'new_value' not in record:
            return error_400('更新の値が設定されていません。')

        #データベース登録
        pdbc = PDBCComponent(GV.CONFIG_COMN_PF)

        # 
        m_param = user_infrastructure.MContractProduct()
        for key in record['condition_value']:
            if 'value' in record['condition_value'][key]:
                setattr(m_param, key, record['condition_value'][key]['value'])
                
        # 採番管理検索
        logger.info('採番管理検索S')
        contract_product_idCount = None
        m_param1 = user_infrastructure.MNumbering()
        m_param1.number_id = 'contract_product_id'
        rows = pdbc.select('user_infrastructure', m_param1)
        if len(rows) > 0:
            logger.info('採番管理検索')
            logger.info(rows)
            contract_product_idCount = rows[0]['number']

        
        # 値セット
        m_param = user_infrastructure.MContractProduct()
        for key in record['new_value']:
            if 'value' in record['new_value'][key]:
                setattr(m_param, key, record['new_value'][key]['value'])
        
        logger.info('採番管理検索number')
        logger.info('CP' + str(contract_product_idCount + 1).zfill(6))
        
        m_param.contract_product_id = 'CP' + str(contract_product_idCount + 1).zfill(6)
        logger.info(m_param.__dict__)
        
        result = None
        
        print(len(rows))

        dt_now = datetime.datetime.now()
        m_param.cdate = dt_now
        m_param.udate = dt_now

        result = pdbc.insert('user_infrastructure', m_param)
        
        if result is not None and type(result) is dict and 'statusCode' in result and result['statusCode'] == 500:
            return result
        
        # 成功場合、採番管理更新する
        logger.info('成功場合、採番管理更新する')
        m_paramWhere = user_infrastructure.MNumbering()
        m_paramWhere.number_id = 'contract_product_id'
        
        logger.info(contract_product_idCount + 1)
        m_condition_param = user_infrastructure.MNumbering()
        m_condition_param.number = int(contract_product_idCount) + 1
        result1 = pdbc.update('user_infrastructure', m_condition_param ,m_paramWhere)
        
        if result1 is not None and type(result1) is dict and 'statusCode' in result1 and result1['statusCode'] == 500:
            return result1
            
        res['result'] = result

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# ------------0611-------------E

# フェーズ2 ------------------------S
# def validate(def_validation,record):
def validate(def_validation, record, is_insert = True):
# フェーズ2 ------------------------E  
    # logger.info(def_validation)
    for key in def_validation:
        
        item = def_validation[key]

        value = get_value(key, record)
        
        # logger.info(item)
        
        if 'label' not in item or \
            'is_required' not in item or \
            'min' not in item or \
            'max' not in item:
            return f'''システムエラー'''
        if 'is_date' in item and \
            ('date_format' not in item or 'date_format_description' not in item):
            return f'''システムエラー'''
        
        label = item['label']
        if value is None or value == '':
            # フェーズ2 ------------------------S
            # if item['is_required']:
            if item['is_required'] and is_insert:
            # フェーズ2 ------------------------E
                return f'''「{label}」を指定してください。'''
            else:
                if 'is_not_null' in item and item['is_not_null']:
                    if value is None:
                        if 'is_intger' in item and item['is_intger']:
                            value = 0
                        else:
                            value = ''
                else:
                    if value is None:
                        pass
                    elif value == '':
                        value = None
                        pass
        else:
            if 'is_email' in item and item['is_email']:
                import re
                pattern = "^[A-Za-z0-9]{1}[A-Za-z0-9_.-]*@{1}[A-Za-z0-9_.-]{1,}\.[A-Za-z0-9]{1,}$"
                if ';' in value:
                    for v in value.split(';'):
                        if re.match(pattern, v):
                            pass
                        else:
                            return f'''「{label}」を正しく指定してください。(メールアドレス)'''    
                else:
                    if re.match(pattern, value):
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。(メールアドレス)'''
            elif 'is_intger' in item and item['is_intger']:
                try:
                    value = int(value)
                except ValueError:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if isinstance(value, int) == False:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if value < int(item['min']) or value > int(item['max']):
                    return f'''「{label}」を正しく指定してください。最小値:{item['min']}～最大値:{item['max']}'''
            # フェーズ2 ------------------------S
            elif 'is_float' in item and item['is_float']:
                try:
                    value = float(value)
                except ValueError:
                    return f'''「{label}」を正しく指定してください。(小数)'''
                if isinstance(value, float) == False:
                    return f'''「{label}」を正しく指定してください。(小数)'''
                if value < float(item['min']) or value > float(item['max']):
                    return f'''「{label}」を正しく指定してください。最小値:{item['min']}～最大値:{item['max']}'''
            # フェーズ2 ------------------------E
            elif 'is_bool' in item and item['is_bool']:
                try:
                    if str(value).lower() in ['true', 'false', '0', '1']:
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。'''
                except ValueError:
                    return f'''「{label}」を正しく指定してください。'''
            else:
                if item['min'] == 0 and item['max'] == 0:
                    pass
                elif len(value) < item['min'] or len(value) > item['max']:
                    return f'''「{label}」を正しく指定してください。({item['max']}桁)'''
                
                if 'is_date' in item and item['is_date']:
                    if 'date_format' in item:
                        try:
                            datetime.datetime.strptime(value, item['date_format'])
                        except ValueError:
                            if 'date_format_description' in item:
                                return f'''「{label}」を正しく指定してください。({item['date_format_description']})'''
                            else:
                                return f'''「{label}」を正しく指定してください。'''
                if 'is_in' in item and item['is_in']:
                    if value not in item['is_in']:
                        return f'''「{label}」を正しく指定してください。'''
    
        set_value(key, value, record)
        
    return True
                