import os
import json
import requests
import subprocess
import datetime
import csv
import inspect
import base64

from datetime import datetime as dt

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

from common.auth0.v2.component import Auth0Component
from common.pdbc.component import *
from model import user_infrastructure

import global_value as GV

RESPONSE_HEADERS = GV.RESPONSE_HEADERS

from error_function import error_handling

# 設定ファイル
import boto3
# BUCKET_NAME = 'env-mcl-mgmt-phase3'
# PATH_NAME = 'user-infrastructure/'
# OBJECT_KEY_NAME = 'config.json'
s3 = boto3.resource('s3')

def lambda_handler(event, context):
    
    print(event)
    
    try:
        
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)

        if event['stageVariables']['env'] is None:
            res = {}
            res['error_code'] = ''
            res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
            return {
                'statusCode': 500,
                'headers': RESPONSE_HEADERS,
                # 'body': json.dumps(res)
                'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
            }
        
        GV.ENV = event['stageVariables']['env'].upper()

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/'
        OBJECT_KEY_NAME = 'config.json'

        bucket = s3.Bucket(BUCKET_NAME)
        obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
        response = obj.get()    
        body = response['Body'].read()
        ENV_CONFIG = json.loads(body.decode('utf-8'))
        
        GV.CONFIG = {}
        GV.CONFIG['AUTH0_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_AUDIENCE']
        GV.CONFIG['AUTH0_CLIENT_ID'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_ID']
        GV.CONFIG['AUTH0_CLIENT_SECRET'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_SECRET']
        GV.CONFIG['AUTH0_DOMAIN'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_DOMAIN']
        # GV.CONFIG['AUTH0_ROLE_IDS'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLE_IDS']
        # フェーズ2 ------------------------S
        GV.CONFIG['AUTH0_ROLES'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLES']
        # フェーズ2 ------------------------E
        GV.CONFIG['API_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'API_AUDIENCE']
        GV.CONFIG['ALGORITHMS'] = ["RS256"]
        
        GV.CONFIG_MSCONE_LIC = {}
        GV.CONFIG_MSCONE_LIC['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_MSCONE_LIC['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PORT']
        # GV.CONFIG_MSCONE_LIC['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABSE_PORT']
        GV.CONFIG_MSCONE_LIC['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PASSWORD']
        
        GV.CONFIG_COMN_PF = {}
        GV.CONFIG_COMN_PF['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_COMN_PF['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PORT']
        # GV.CONFIG_COMN_PF['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABSE_PORT']
        GV.CONFIG_COMN_PF['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_COMN_PF['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_COMN_PF['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PASSWORD']

        GV.SYSTEM_SERVICE = {}
        GV.SYSTEM_SERVICE = ENV_CONFIG[GV.ENV]['SYSTEM_SERVICE']
        
        res = {}
        
        print(event['httpMethod'])
        print(event['path'])
        if event['httpMethod'] == 'GET':
            # GETの場合最後に"/"が付く
            
            logger.debug('# ************0704******************') 
            result = get_data_from_user_infrastructure_m_auth0_management(event)
            print(result)
    
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                result_body = json.loads(result['body'])
                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                return result
    
            result_body = json.loads(result['body'])
            print(result_body)
            if 'result' in result_body:
                rows = result_body['result']
                if len(rows) > 0:
                    logger.debug('# ************Auth0情報を設定する******************')
                    GV.CONFIG['AUTH0_AUDIENCE'] = rows[0]['management_api_audience']
                    GV.CONFIG['AUTH0_CLIENT_ID'] = rows[0]['api_clientid']
                    GV.CONFIG['AUTH0_CLIENT_SECRET'] = rows[0]['api_client_secret']
                    GV.CONFIG['AUTH0_DOMAIN'] = rows[0]['domain']
                    GV.CONFIG['API_AUDIENCE'] = rows[0]['api_audience']
                    GV.CONFIG['AUTH0_TENANT'] = rows[0]['tenant']
                    logger.debug(GV.CONFIG)
                    pass
                else:
                    return {"error": + " ユーザーのデータは存在しないので、システム者にご連絡ください。"}
            logger.debug('# ************0704******************') 
            
            if event['path'] == '/billing/list/' or event['path'] == '/billing/list':
                # 
                res = get_list(event, context)
            elif event['path'] == '/billing/download/' or event['path'] == '/billing/download':
                # 
                res = get_download(event, context)
                
        logger.info(res)
    
        return res
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# --------------------------------------------------------------------

def get_list(event, context):
            
    logger.info('get_list!!!')
    print('get_list!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_headers = {}
        if 'headers' in event and event['headers'] is not None: 
            event_headers = event['headers']
            logger.info(event_headers)
            
            # フェーズ2 ------------------------S
            # --------------------------------------------------------------------
            # Auth0 S
            
            # 通常ユーザー管理者 のみアクセス可能
    
            # 検証
            if 'Authorization' not in event_headers:
                msg = '認証情報が正しくありません。'
                return error_400(msg)
            
            access_token_info = get_access_token_info(event_headers["Authorization"])
            
            # if 'my_roles' not in access_token_info:
            #     msg = 'アクセス権限がありません。'
            #     return error_400(msg)
            
            # # 通常ユーザー管理者 のみアクセス可能
            # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
            #     msg = 'アクセス権限がありません。'
            #     return error_400(msg)
            
            # Auth0 E
            # --------------------------------------------------------------------
            # フェーズ2 ------------------------E

            # フェーズ3 20230830 ------------------------S

            if 'user_metadata' not in access_token_info:
                msg = 'アクセス権限がありません。'
                return error_400(msg)

            user_metadata = access_token_info['user_metadata']

            if 'data' not in user_metadata:
                print(''' 'data' not in user_metadata ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)

            if type(user_metadata['data']) != list:
                print(''' type(user_metadata['data']) != list ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)
            
            if len(user_metadata['data']) < 1:
                print(''' len(user_metadata['data']) < 1 ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)
            
            # フェーズ3 20230830 ------------------------E
            
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)

        # 3840 権限の設定方法変更による影響範囲の確認と修正 の対応  In
        if 'service' not in query_string_parameters:
            msg = '「サービス情報」のパラメーターの指定が正しくありません。'
            return error_400(msg)
        
        service = query_string_parameters['service']
        print('service')
        print(service)
 
        if 'company_code' not in query_string_parameters:
            msg = '「企業コード」のパラメーターの指定が正しくありません。'
            return error_400(msg)
        
        company_code = query_string_parameters['company_code']
        print('company_code')
        print(company_code)    

        
        # システムID、サービスID取得
        system_name = GV.SYSTEM_SERVICE[service]['system_name']
        service_name = GV.SYSTEM_SERVICE[service]['service_name']
        system_ids = get_system_id(system_name)
        if len(system_ids) < 1:
            msg = 'system_idの取得に失敗しました。'
            return error_400(msg)
        service_ids = get_service_id(service_name)
        if len(service_ids) < 1:
            msg = 'service_idの取得に失敗しました。'
            return error_400(msg)
        system_id = system_ids[0]['system_id']
        service_id = service_ids[0]['service_id']

        # ユーザー権限のチェック
        #  admin_user アプリ側のシステム管理者
        if (user_data_role_cheku(event, company_code, system_id, service_id) == False):
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        # 3840 権限の設定方法変更による影響範囲の確認と修正 の対応  Out
        
        #取得リスト作成
        date_list = []
        dt = datetime.datetime.now()
        now_year = str(dt.year)
        now_month = str(dt.month).zfill(2)
        #date_list.append(str(now_year)+str(now_month)) 当月は除外
        for i in range(12):
            if str(int(now_month) -1).zfill(2) == '00':
                now_year = int(now_year) - 1
                now_month = 12
            else:
                now_month = str(int(now_month) -1).zfill(2)
            date_list.append(str(now_year)+'年'+str(now_month)+'月')
        rows = []
        for date in date_list:
            rows.append({'output_date': date})
        
        res['rows'] = rows
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
    
def get_download(event, context):
            
    logger.info('get_download!!!')

    res = {}
    res['error_code'] = None
    res['error_message'] = None
    
    try:
        
        event_headers = {}
        if 'headers' in event and event['headers'] is not None: 
            event_headers = event['headers']
            logger.info(event_headers)
            
            # フェーズ2 ------------------------S
            # --------------------------------------------------------------------
            # Auth0 S
            
            # 通常ユーザー管理者 のみアクセス可能
    
            # 検証
            if 'Authorization' not in event_headers:
                msg = '認証情報が正しくありません。'
                return error_400(msg)
            
            access_token_info = get_access_token_info(event_headers["Authorization"])
            
            # if 'my_roles' not in access_token_info:
            #     msg = 'アクセス権限がありません。'
            #     return error_400(msg)
            
            # # 通常ユーザー管理者 のみアクセス可能
            # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
            #     msg = 'アクセス権限がありません。'
            #     return error_400(msg)
            
            # Auth0 E
            # --------------------------------------------------------------------
            # フェーズ2 ------------------------E
            
            # フェーズ3 20230830 ------------------------S

            if 'user_metadata' not in access_token_info:
                msg = 'アクセス権限がありません。'
                return error_400(msg)

            user_metadata = access_token_info['user_metadata']

            if 'data' not in user_metadata:
                print(''' 'data' not in user_metadata ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)

            if type(user_metadata['data']) != list:
                print(''' type(user_metadata['data']) != list ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)
            
            if len(user_metadata['data']) < 1:
                print(''' len(user_metadata['data']) < 1 ''')
                msg = 'アクセス権限がありません。'
                return error_400(msg)
            
            # フェーズ3 20230830 ------------------------E

        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        # user = get_user_info(event_headers["Authorization"])
        
        # if 'email' not in user:
        #     msg = 'ユーザー情報取得に失敗しました。'
        #     return error_400(msg)

        if 'service' not in query_string_parameters:
            msg = '「サービス情報」のパラメーターの指定が正しくありません。'
            return error_400(msg)
        
        service = query_string_parameters['service']
        print('service')
        print(service)
 
        if 'company_code' not in query_string_parameters:
            msg = '「企業コード」のパラメーターの指定が正しくありません。'
            return error_400(msg)
        
        company_code = query_string_parameters['company_code']
        print('company_code')
        print(company_code)    

        if 'date' not in query_string_parameters:
            msg = 'パラメーターの指定が正しくありません。'
            return error_400(msg)
        
        aggregate_date = query_string_parameters['date'].replace('年','').replace('月','')
        print('aggregate_date')
        print(aggregate_date)
        
        if len(aggregate_date) != 6:
            msg = '「利用年月」のパラメーターの指定が正しくありません。'
            return error_400(msg)
            
        # rows = get_company_code_by_email(user['email'])
        # rows = get_company_code_by_auth0_user_id(user['user_id'])
        # if 'statusCode' in rows:
        #     return rows
        
        # if len(rows) < 1:
        #     msg = '企業情報取得に失敗しました。'
        #     return error_400(msg)
        
        # company_code = rows[len(rows) - 1]['company_code']
        # print('company_code')
        # print(company_code)

        # システムID、サービスID取得
        system_name = GV.SYSTEM_SERVICE[service]['system_name']
        service_name = GV.SYSTEM_SERVICE[service]['service_name']
        system_ids = get_system_id(system_name)
        if len(system_ids) < 1:
            msg = 'system_idの取得に失敗しました。'
            return error_400(msg)
        service_ids = get_service_id(service_name)
        if len(service_ids) < 1:
            msg = 'service_idの取得に失敗しました。'
            return error_400(msg)
        system_id = system_ids[0]['system_id']
        service_id = service_ids[0]['service_id']
        
        # 契約ID取得
        rows = get_cntract_id_by_company_code_system_id_service_id(company_code, system_id, service_id)
        if len(rows) < 1:
            msg = 'contract_idの取得に失敗しました。'
            return error_400(msg)
        contract_id = rows[0]['contract_id']
        
        # 3840 権限の設定方法変更による影響範囲の確認と修正 の対応  In
        # ユーザー権限のチェック
        #  admin_user アプリ側のシステム管理者
        if (user_data_role_cheku(event, company_code, system_id, service_id) == False):
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        # 3840 権限の設定方法変更による影響範囲の確認と修正 の対応  Out
        
        # company_code = '22000004'
        
        logger.debug('# ******************************')
        # # API_GATEWAY_BILLING_REPORT = 'https://n8cgchmf6f.execute-api.ap-northeast-1.amazonaws.com/eval/invoices/file-download/get'
        # # API_GATEWAY_BILLING_REPORT = 'https://vpce-029986df414d3dadd-cbkhlxnq.execute-api.ap-northeast-1.vpce.amazonaws.com/' + GV.ENV.lower() + '/invoices/file-download/get'
        # if GV.ENV == 'DEV':
        #     API_GATEWAY_BILLING_REPORT = 'https://vpce-029986df414d3dadd-cbkhlxnq.execute-api.ap-northeast-1.vpce.amazonaws.com/' + GV.ENV.lower() + '/invoices/file-download/get'
        # elif GV.ENV == 'VERI':
        #     API_GATEWAY_BILLING_REPORT = 'https://vpce-0b9110efa2e9b3a68-mp5nke4p.execute-api.ap-northeast-1.vpce.amazonaws.com/' + GV.ENV.lower() + '/invoices/file-download/get'
        # print(API_GATEWAY_BILLING_REPORT)

        # # API呼び出し
        # params = {'aggregate_date': aggregate_date, 'system_id': system_id, 'contract_id': contract_id}
        # # params = {'aggregate_date': '202207', 'company_id': '22000004'}#, 'stage':'eval'}
        # headers = {'Accept': 'application/pdf'}
        # # headers = {'x-apigw-api-id': 'n8cgchmf6f'}
        # if GV.ENV == 'DEV':
        #     headers['x-apigw-api-id'] = 'n8cgchmf6f'
        # elif GV.ENV == 'VERI':
        #     headers['x-apigw-api-id'] = 'dlt794wb5d'
        # res = requests.get(API_GATEWAY_BILLING_REPORT, params=params, headers=headers)
        # print(res)
        # print(res.content)
        # # print(base64.b64encode(res.content).decode('utf-8'))
        
        # print(res.status_code)
        # if res.ok == False:
        #     # return res
        #     msg = '失敗しました。'
        #     return error_400(msg)
        
        # プライベートAPIを呼び出すより、直接Lambda関数を呼び出す方が簡単で
        # 複雑な環境設定が必要ない
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'requestContext': {
                'stage': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/invoices/file-download/get',
            'queryStringParameters': {
                'aggregate_date': aggregate_date, 
                'system_id': system_id, 
                'contract_id': contract_id
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-pro-getInvoiceFile',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            # print("---03: body:", Payload)
            if 'statusCode' in Payload:
                if Payload['statusCode'] == 400:
                    msg = '失敗しました。'
                    return error_400(msg)
                    
            res = Payload
        logger.debug('# ##############################')
            
        # output = make_response()
        # output.data = res.content
        # output.headers["Content-Disposition"] = "attachment"
        # output.headers["Content-type"] = "application/pdf"
        # return output
        
        headers = RESPONSE_HEADERS
        headers["Content-Disposition"] = "attachment"
        headers["Content-type"] = "application/pdf"
        
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    
    logger.debug('# ******************************')
    # プライベートAPIを呼び出すより、直接Lambda関数を呼び出す方が簡単で
    # 複雑な環境設定が必要ない
    # return {
    #     'statusCode': 200,
    #     'headers': headers,
    #     'body': res.content
    #     # 'body': base64.b64encode(res.content).decode('utf-8'),
    #     # 'isBase64Encoded': True
    # }
    return {
        'statusCode': 200,
        'headers': headers,
        'body': res['body']
        # 'body': base64.b64encode(res.content).decode('utf-8'),
        # 'isBase64Encoded': True
    }


# 3840 権限の設定方法変更による影響範囲の確認と修正 の対応  In
# ユーザー権限のチェック
def user_data_role_cheku(event,strCompany_code, strSystem_id, strService_id):
    logger.info('user_data_role_cheku!!!')

    resType = False
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        
        access_token_info = get_access_token_info(event_headers["Authorization"])
        
        # if 'my_roles' not in access_token_info or 'user_metadata' not in access_token_info :
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        for metadataList in access_token_info['user_metadata']['data']:
            if 'company_code' in metadataList and 'system_id' in metadataList and 'service_id' in metadataList:
                if strCompany_code == metadataList['company_code'] and strSystem_id  == metadataList['system_id'] and strService_id  == metadataList['service_id'] :
                    if GV.CONFIG['AUTH0_ROLES']['ROLES_ADMIN_USER'] in metadataList['roles']:
                        resType = True
                        return resType
    return resType
# 3840 権限の設定方法変更による影響範囲の確認と修正 の対応  Out

def get_company_code_by_email(email):
    pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
    m_param = user_infrastructure.MUser()
    m_param.email = email
    rows = pdbc.select('user_infrastructure', m_param)
    return rows

def get_company_code_by_auth0_user_id(auth0_user_id):
    pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
    m_param = user_infrastructure.MUser()
    m_param.auth0_user_id = auth0_user_id
    rows = pdbc.select('user_infrastructure', m_param)
    return rows

def get_system_id(system_name):
    pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
    sql = '''
        SELECT 
            m_systems.system_id
        FROM 
            billing_infrastructure.m_systems
        WHERE 
            m_systems.system_name = %(system_name)s
    '''
    param = {}
    param["system_name"] = system_name
    rows = pdbc.select_param(sql, param)
    return rows

def get_service_id(service_name):
    pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
    sql = '''
        SELECT 
            m_services.service_id
        FROM 
            billing_infrastructure.m_services
        WHERE 
            m_services.service_name = %(service_name)s
    '''
    param = {}
    param["service_name"] = service_name
    rows = pdbc.select_param(sql, param)
    return rows

logger.debug('# ************0704******************') 
def get_data_from_user_infrastructure_m_auth0_management(event):

    logger.info('get_data_from_user_infrastructure_m_auth0_management!!!')

    res = {}

    try:
    
        service = ''
        company_code = ''
        tmp = {}
    
        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
            logger.info(event_body)
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if 'service' not in query_string_parameters:
            msg = '「サービス情報」のパラメーターの指定が正しくありません。'
            return error_400(msg)
        
        service = query_string_parameters['service']
        print('service')
        print(service)
 
        if 'company_code' not in query_string_parameters:
            msg = '「企業コード」のパラメーターの指定が正しくありません。'
            return error_400(msg)
        
        company_code = query_string_parameters['company_code']
        print('company_code')
        print(company_code)  
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_auth0_management',
            'queryStringParameters': {
                 'service': {
                    'value': service
                },
                'company_code': {
                    'value': company_code
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

logger.debug('# ************0704******************') 

def get_cntract_id_by_company_code_system_id_service_id(company_code, system_id, service_id):
    pdbc = PDBCComponent(GV.CONFIG_COMN_PF)
    sql = '''
        SELECT 
            t_manage_request.contract_id
        FROM 
            user_infrastructure.t_manage_request
        WHERE 
            t_manage_request.company_code = %(company_code)s 
            AND t_manage_request.system_id = %(system_id)s 
            AND t_manage_request.service_id = %(service_id)s 
            AND t_manage_request.system_usable_flag != 0  -- バグ #6964
    '''
    param = {}
    param["company_code"] = company_code
    param["system_id"] = system_id
    param["service_id"] = service_id
    rows = pdbc.select_param(sql, param)
    return rows 

def get_user_info(auth):
    auth0 = Auth0Component(GV.CONFIG)
    return auth0.get_user_by_auth(auth)

def get_access_token_info(auth):
    auth0 = Auth0Component(GV.CONFIG)
    return auth0.get_access_token_info(auth)

def get_value(key, items):
    
    value = None
    
    if key in items:
        
        # Kintoneからのデータの場合
        if 'value' in items[key]:
            value = items[key]['value']
        else:
            value = items[key]
            
        if isinstance(value, str):
            value = value.strip()
            
    return value

def set_value(key, value, items):
    
    if key in items:
        # Kintoneからのデータの場合
        if 'value' in items[key]:
            items[key]['value'] = value
        else:
            items[key] = value
           
    return items

def error_400(message, code = None):
    body = {
        'error_code': code,
        'error_message': message
    }
    return {
        'statusCode': 400,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(body)
        'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
    }

def check_hankaku_eisu_kigo(target):
    MOJI = """ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~"""
    for c in target:
        if c not in MOJI:
            return False
    return True
        
def check_account_name(account_name):
    MOJI = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789ｦｧｨｩｪｫｬｭｮｯ-ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾂﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝｶﾞｷﾞｸﾞｹﾞｺﾞｻﾞｼﾞｽﾞｾﾞｿﾞﾀﾞﾁﾞﾂﾞﾃﾞﾄﾞﾊﾞﾋﾞﾌﾞﾍﾞﾎﾞﾊﾟﾋﾟﾌﾟﾍﾟﾎﾟ,. )(\/｢｣-'
    for c in account_name:
        if c not in MOJI:
            return False
    return True

def validate(def_validation,record):
    
    for key in def_validation:
        
        item = def_validation[key]
        
        value = get_value(key, record)
        
        if 'label' not in item or \
            'is_required' not in item or \
            'min' not in item or \
            'max' not in item:
            return f'''システムエラー'''
        if 'is_date' in item and \
            ('date_format' not in item or 'date_format_description' not in item):
            return f'''システムエラー'''
        
        label = item['label']
        if value is None or value == '':
            if item['is_required']:
                return f'''「{label}」を指定してください。'''
            else:
                if 'is_not_null' in item and item['is_not_null']:
                    if value is None:
                        if 'is_intger' in item and item['is_intger']:
                            value = 0
                        else:
                            value = ''
                else:
                    if value is None:
                        pass
                    elif value == '':
                        value = None
                        pass
        else:
            if 'is_email' in item and item['is_email']:
                import re
                pattern = "^[A-Za-z0-9]{1}[A-Za-z0-9_.-]*@{1}[A-Za-z0-9_.-]{1,}\.[A-Za-z0-9]{1,}$"
                if ';' in value:
                    for v in value.split(';'):
                        if re.match(pattern, v):
                            pass
                        else:
                            return f'''「{label}」を正しく指定してください。(メールアドレス)'''    
                else:
                    if re.match(pattern, value):
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。(メールアドレス)'''
            elif 'is_intger' in item and item['is_intger']:
                try:
                    value = int(value)
                except ValueError:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if isinstance(value, int) == False:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if value < int(item['min']) or value > int(item['max']):
                    return f'''「{label}」を正しく指定してください。最小値:{item['min']}～最大値:{item['max']}'''
            elif 'is_bool' in item and item['is_bool']:
                try:
                    if str(value).lower() in ['true', 'false', '0', '1']:
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。'''
                except ValueError:
                    return f'''「{label}」を正しく指定してください。'''
            else:
                if item['min'] == 0 and item['max'] == 0:
                    pass
                elif len(value) < item['min'] or len(value) > item['max']:
                    return f'''「{label}」を正しく指定してください。({item['max']}桁)'''
                
                if 'is_date' in item and item['is_date']:
                    if 'date_format' in item:
                        try:
                            datetime.datetime.strptime(value, item['date_format'])
                        except ValueError:
                            if 'date_format_description' in item:
                                return f'''「{label}」を正しく指定してください。({item['date_format_description']})'''
                            else:
                                return f'''「{label}」を正しく指定してください。'''
                if 'is_in' in item and item['is_in']:
                    if value not in item['is_in']:
                        return f'''「{label}」を正しく指定してください。'''
    
        set_value(key, value, record)
        
    return True
# テストコード            
# def main():
#     event = {
#         "body": '{"value": 100}',
#         "httpMethod": "GET",
#         "path": "/billing/download/",
#         "stageVariables": { "env": "dev" },
#         "queryStringParameters": { "date": "2023年02月", "service": "simsp" }
#     }
#     response = lambda_handler(event, None)
#     print(response)
#     return response

# if __name__ == "__main__":
#     main()