import boto3
from error_function import error_handling
import global_value as GV
import json
import datetime
import inspect
from Crypto.Cipher import AES
from hashlib import pbkdf2_hmac
import base64
import zlib
from pathlib import Path
import zipfile
import os
import io
import requests
from time import sleep
import http.server
import socketserver
from cgi import FieldStorage
import cgi
import codecs
import glob
import copy
# from flask import Flask,  request
# from flask import  request

from common.auth0.v2.component import Auth0Component

from model import user_infrastructure

from datetime import datetime as dt

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

RESPONSE_HEADERS = GV.RESPONSE_HEADERS

# 設定ファイル
# BUCKET_NAME = 'env-mcl-mgmt-phase3'
# PATH_NAME = 'user-infrastructure/'
# OBJECT_KEY_NAME = 'config.json'
s3 = boto3.resource('s3')
# bots3 = boto3.client('s3')

record = GV.record


def lambda_handler(event, context):

    print(event)

    try:
                   
        # event_body = {}
        # if 'body' in event and event['body'] is not None:
        #     event_body = json.loads(event['body'])
        #     logger.info(event_body)

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)

        if event['stageVariables']['env'] is None:
            res = {}
            res['error_code'] = ''
            res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
            return {
                'statusCode': 500,
                'headers': RESPONSE_HEADERS,
                'body': json.dumps(res)
            }

        GV.ENV = event['stageVariables']['env'].upper()

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/'
        OBJECT_KEY_NAME = 'config.json'

        bucket = s3.Bucket(BUCKET_NAME)
        obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
        response = obj.get()
        body = response['Body'].read()
        ENV_CONFIG = json.loads(body.decode('utf-8'))

        GV.CONFIG = {}
        GV.CONFIG['AUTH0_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_AUDIENCE']
        GV.CONFIG['AUTH0_CLIENT_ID'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_ID']
        GV.CONFIG['AUTH0_CLIENT_SECRET'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_SECRET']
        GV.CONFIG['AUTH0_DOMAIN'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_DOMAIN']
        # GV.CONFIG['AUTH0_ROLE_IDS'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLE_IDS']
        # フェーズ2 ------------------------S
        GV.CONFIG['AUTH0_ROLES'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLES']
        # フェーズ2 ------------------------E
        GV.CONFIG['API_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'API_AUDIENCE']
        GV.CONFIG['ALGORITHMS'] = ["RS256"]
        
        logger.debug('# ************0704******************') 
        
        if event['httpMethod'] != 'POST' and event['path'] != '/company_info/file_upload':
            result = get_data_from_user_infrastructure_m_auth0_management_list(event)
            print(result)
            if (result != {}):
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    result_body = json.loads(result['body'])
                    send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                    return result
        
                result_body = json.loads(result['body'])
                print(result_body)
                if 'result' in result_body:
                    rows = result_body['result']
                    if len(rows) > 0:
                        logger.debug('# ************Auth0情報を設定する******************')
                        GV.CONFIG['AUTH0_AUDIENCE'] = rows[0]['management_api_audience']
                        GV.CONFIG['AUTH0_CLIENT_ID'] = rows[0]['api_clientid']
                        GV.CONFIG['AUTH0_CLIENT_SECRET'] = rows[0]['api_client_secret']
                        GV.CONFIG['AUTH0_DOMAIN'] = rows[0]['domain']
                        GV.CONFIG['API_AUDIENCE'] = rows[0]['api_audience']
                        GV.CONFIG['AUTH0_TENANT'] = rows[0]['tenant']
                        logger.debug(GV.CONFIG)
                        pass
                    else:
                        return {"error": + " ユーザーのデータは存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0704******************') 

        GV.CONFIG_MSCONE_LIC = {}
        GV.CONFIG_MSCONE_LIC['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_MSCONE_LIC['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PORT']
        # GV.CONFIG_MSCONE_LIC['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABSE_PORT']
        GV.CONFIG_MSCONE_LIC['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PASSWORD']

        GV.CONFIG_COMN_PF = {}
        GV.CONFIG_COMN_PF['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_HOST']
        GV.CONFIG_COMN_PF['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PORT']
        # GV.CONFIG_COMN_PF['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABSE_PORT']
        GV.CONFIG_COMN_PF['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_NAME']
        GV.CONFIG_COMN_PF['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_USERNAME']
        GV.CONFIG_COMN_PF['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PASSWORD']

        # フェーズ2 ------------------------S
        GV.CONFIG['LOGIN_URL'] = ENV_CONFIG[GV.ENV]['LOGIN_URL'][GV.ENV + '_' + 'LOGIN_URL']
        GV.CONFIG['INVITATION_URL'] = ENV_CONFIG[GV.ENV]['INVITATION_URL'][GV.ENV + '_' + 'INVITATION_URL']
        # フェーズ2 ------------------------E
        
        # フェーズ3 ------------------------S
        GV.CONFIG_SYSTEM_SERVICE = {}
        GV.CONFIG_SYSTEM_SERVICE= ENV_CONFIG[GV.ENV]['SYSTEM_SERVICE']
        # フェーズ3 ------------------------E
        
        res = {}

        print(event['httpMethod'])
        print(event['path'])
        if event['httpMethod'] == 'POST':
            if event['path'] == '/need_gmo_ps_creditfacility_modifybuyer' or event['path'] == '/need_gmo_ps_creditfacility_modifybuyer/':
                #
                res = need_gmo_ps_creditfacility_modifybuyer(event, context)
            if event['path'] == '/company_info/file_upload':
                #
                res = get_data_file_upload(event, context) 
            if event['path'] == '/company_info/kintone_file_to_s3':
                #
                res = post_data_to_s3file(event, context)
            if event['path'] == '/company_info/kintonefile_to_s3':
                #
                res = kintone_post_data_to_s3file(event, context)
        elif event['httpMethod'] == 'PUT':
            if event['path'] == '/company_info' or event['path'] == '/company_info/':
                #
                res = update_company_info(event, context)
            if event['path'] == '/company_info/file_download':
                #
                res = get_data_file_file_download(event, context) 
        elif event['httpMethod'] == 'GET':
           
            if event['path'] == '/company_info' or event['path'] == '/company_info/':
                
                logger.debug('# ************0704******************') 
                result = get_data_from_user_infrastructure_m_auth0_management(event)
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    result_body = json.loads(result['body'])
                    send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                    return result
        
                result_body = json.loads(result['body'])
                print(result_body)
                if 'result' in result_body:
                    rows = result_body['result']
                    if len(rows) > 0:
                        logger.debug('# ************Auth0情報を設定する******************')
                        GV.CONFIG['AUTH0_AUDIENCE'] = rows[0]['management_api_audience']
                        GV.CONFIG['AUTH0_CLIENT_ID'] = rows[0]['api_clientid']
                        GV.CONFIG['AUTH0_CLIENT_SECRET'] = rows[0]['api_client_secret']
                        GV.CONFIG['AUTH0_DOMAIN'] = rows[0]['domain']
                        GV.CONFIG['API_AUDIENCE'] = rows[0]['api_audience']
                        GV.CONFIG['AUTH0_TENANT'] = rows[0]['tenant']
                        logger.debug(GV.CONFIG)
                        pass
                    else:
                        return {"error": + " ユーザーのデータは存在しないので、システム者にご連絡ください。"}
                logger.debug('# ************0704******************') 
                #
                res = get_data_from_user_infrastructure_t_entry(event, context)  
            if event['path'] == '/company_info/gdfuse' or event['path'] == '/company_info/gdfuse/':
                #
                res = get_data_from_gdfuse(event, context)  

        logger.info(res)

        # if 'statusCode' in res and (res['statusCode'] == 400 or res['statusCode'] == 500):
        #     global record
        #     res_body = json.loads(res['body'])
        #     record['error_message'] = {}
        #     record['error_message']['value'] = res_body['error_message']
        #     send_email_on_error(event, context)

        return res

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

# --------------------------------------------------------------------
# Auth0 S

def get_access_token_info(auth):
    auth0 = Auth0Component(GV.CONFIG)
    return auth0.get_access_token_info(auth)

# Auth0 E
# --------------------------------------------------------------------

# --------------------------------------------------------------------


def update_company_info(event, context):

    logger.info('update_company_info!!!')

    # フェーズ2 ------------------------S
    # --------------------------------------------------------------------
    # Auth0 S
    
    # 通常ユーザー管理者 のみアクセス可能
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        logger.info(event_headers)

        # 検証
        if 'Authorization' not in event_headers:
            msg = '認証情報が正しくありません。'
            return error_400(msg)
        
        access_token_info = get_access_token_info(event_headers["Authorization"])

        # if 'my_roles' not in access_token_info or 'user_metadata' not in access_token_info :
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        # フェーズ3 20230830 ------------------------S

        if 'user_metadata' not in access_token_info:
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        user_metadata = access_token_info['user_metadata']

        if 'data' not in user_metadata:
            print(''' 'data' not in user_metadata ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        if type(user_metadata['data']) != list:
            print(''' type(user_metadata['data']) != list ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        if len(user_metadata['data']) < 1:
            print(''' len(user_metadata['data']) < 1 ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------E

    # Auth0 E
    # --------------------------------------------------------------------
    # フェーズ2 ------------------------E
        
    global record

    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        event_body = {}
        event_body = json.loads(event['body'])

        tmp = event_body['record']
        print(tmp)

        # 更新情報をグローバル変数「record」とマージする
        record.update(tmp)
        print(record)

        # 検証
        res_validation = validate(user_infrastructure.M_COMPANY, record)
        if res_validation != True:
            print(res_validation)
            res_validation = "【企業情報】：" + res_validation
            return error_400(res_validation)

        res_validation = validate(user_infrastructure.M_CONTRACT, record)
        if res_validation != True:
            print(res_validation)
            res_validation = "【契約情報】：" + res_validation
            return error_400(res_validation)
        
        # #7105対応
        if 'entry_option' in record and record['entry_option'] is None: 
            res_validation = validate(user_infrastructure.M_USER, record)
            if res_validation != True:
                print(res_validation)
                res_validation = "【システム管理者情報】：" + res_validation
                return error_400(res_validation)

        # ------------------------------------
        # Get Old Data S

        record_old = {}

        result = get_data_from_user_infrastructure_t_entry(event, context)
        print(result)

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            result_body = json.loads(result['body'])
            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
            return result

        result_body = json.loads(result['body'])
        print(result_body)
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                record_old = rows[0]

        if 'm_update_company_info_history_update_date' in record_old:
            if record_old['m_update_company_info_history_update_date'] is None:
                record_old['m_update_company_info_history_update_date'] = ''
            if 'm_update_company_info_history_update_date' in record:
                if record['m_update_company_info_history_update_date']['value'] is None:
                    record['m_update_company_info_history_update_date']['value'] = ''
                if record_old['m_update_company_info_history_update_date'] > record['m_update_company_info_history_update_date']['value']:
                    msg = '編集中に別のユーザーが更新を行ったため、データの登録ができません。リロードして再度編集を行ってください。'
                    err = {
                        'message': msg
                    }
                    send_email_on_error(inspect.currentframe().f_code.co_name, err)
                    return error_400(msg)
                #     pass

        # ------------------------------------
        # 「GMO掛け払いのデータ更新あり」にチェックを入れる S
        
        # GMO掛け払いのデータはこのタイミングでは更新しない。
        # 以下の情報に変更が加わった場合、企業情報管理アプリの「GMO掛け払いのデータ更新あり」にチェックを入れる。
        # ・会社名
        # ・代表者姓名
        # ・代表者の生年月日
        # ・契約者の郵便番号
        # ・契約者の住所
        # ・契約者の電話番号
        # ・契約者のメールアドレス
        
        # バグ #2834 ------------------------S
        # 未変更でも申し込みを完了すると「GMO掛け払いのデータ更新あり」にチェックが入る
        
        # if (# 会社名
        #     record_old["company_name"] != record["company_name"]["value"] or 
        #     # 代表者（姓）
        #     record_old["company_leader_last"] != record["company_leader_last"]["value"] or 
        #     # 代表者（名）
        #     record_old["company_leader_first"] != record["company_leader_first"]["value"] or 
        #     # 代表者の生年月日
        #     record_old["company_leader_date_of_birth"] != record["company_leader_date_of_birth"]["value"] or 
        #     # 契約者の郵便番号
        #     record_old["contract_zipcode"] != record["contract_zipcode"]["value"] or 
        #     # 契約者の住所
        #     # 契約者都道府県
        #     record_old["contract_address_pref"] != record["contract_address_pref"]["value"] or 
        #     # 契約者住所１(市区町村)
        #     record_old["contract_address_1"] != record["contract_address_1"]["value"] or 
        #     # 契約者住所２(番地)
        #     record_old["contract_address_2"] != record["contract_address_2"]["value"] or 
        #     # 契約者住所３(ビル、マンション名)
        #     record_old["contract_address_3"] != record["contract_address_3"]["value"] or 
        #     # 契約者の電話番号
        #     record_old["contract_tel_1"] != record["contract_tel_1"]["value"] or 
        #     # 契約者のメールアドレス
        #     record_old["contract_email"] != record["contract_email"]["value"]):
          
        #     #「GMO掛け払いのデータ更新あり」にチェックを入れる
        #     record["need_gmo_ps_creditfacility_modifybuyer"] = {}
        #     record["need_gmo_ps_creditfacility_modifybuyer"]["value"] = True
            
        #     pass
        
        #「GMO掛け払いのデータ更新あり」にチェックを入れる
        record["need_gmo_ps_creditfacility_modifybuyer"] = {}
        record["need_gmo_ps_creditfacility_modifybuyer"]["value"] = False
            
        if record_old["company_name"] is None:
            record_old["company_name"] = ''
        if record_old["company_leader_last"] is None:
            record_old["company_leader_last"] = ''
        if record_old["company_leader_first"] is None:
            record_old["company_leader_first"] = ''
        if record_old["company_leader_date_of_birth"] is None:
            record_old["company_leader_date_of_birth"] = ''
        if record_old["contract_zipcode"] is None:
            record_old["contract_zipcode"] = ''
        if record_old["contract_address_pref"] is None:
            record_old["contract_address_pref"] = ''
        if record_old["contract_address_pref"] is None:
            record_old["contract_address_pref"] = ''
        if record_old["contract_address_pref"] is None:
            record_old["contract_address_pref"] = ''
        if record_old["contract_address_1"] is None:
            record_old["contract_address_1"] = ''
        if record_old["contract_address_2"] is None:
            record_old["contract_address_2"] = ''
        if record_old["contract_address_3"] is None:
            record_old["contract_address_3"] = ''
        if record_old["contract_tel_1"] is None:
            record_old["contract_tel_1"] = ''
        if record_old["contract_email"] is None:
            record_old["contract_email"] = ''
        if record_old["contract_product_request"] is None:
            record_old["contract_product_request"] = ''
        
        if record_old["company_leader_date_of_birth"] != '':
            record_old["company_leader_date_of_birth"] = dt.strptime(record_old["company_leader_date_of_birth"], '%Y-%m-%d %H:%M:%S').strftime('%Y/%m/%d')

        if record["company_name"]["value"] is None:
            record["company_name"]["value"] = ''
        if record["company_leader_last"]["value"] is None:
            record["company_leader_last"]["value"] = ''
        if record["company_leader_first"]["value"] is None:
            record["company_leader_first"]["value"] = ''
        if record["company_leader_date_of_birth"]["value"] is None:
            record["company_leader_date_of_birth"]["value"] = ''        
        if record["contract_zipcode"]["value"] is None:
            record["contract_zipcode"]["value"] = ''
        if record["contract_address_pref"]["value"] is None:
            record["contract_address_pref"]["value"] = ''
        if record["contract_address_1"]["value"] is None:
            record["contract_address_1"]["value"] = ''
        if record["contract_address_2"]["value"] is None:
            record["contract_address_2"]["value"] = ''
        if record["contract_address_3"]["value"] is None:
            record["contract_address_3"]["value"] = ''
        if record["contract_tel_1"]["value"] is None:
            record["contract_tel_1"]["value"] = ''
        if record["contract_email"]["value"] is None:
            record["contract_email"]["value"] = ''
            
        amount_upper_limitType = False
        print("||||||||||||1||||||||||")
        if ('contract_product_request' in record):
            print("||||||||||||2||||||||||")
            if record["contract_product_request"]["value"] is None:
                print("||||||||||||22||||||||||")
                record["contract_product_request"]["value"] = ''
            amount_upper_limitType = True
        else:
            print("||||||||||||3||||||||||")
            
            addArr = {'contract_product_request': {'value': ''}}
            # record['contract_product_request'] = []
            print("||||||||||||33||||||||||")
            record['contract_product_request'] = {'value': ''}
            amount_upper_limitType = False
            print("||||||||||||333||||||||||")
            
        if (# 会社名
            record_old["company_name"] != record["company_name"]["value"] or 
            # 代表者（姓）
            record_old["company_leader_last"] != record["company_leader_last"]["value"] or 
            # 代表者（名）
            record_old["company_leader_first"] != record["company_leader_first"]["value"] or 
            # 代表者の生年月日
            record_old["company_leader_date_of_birth"] != record["company_leader_date_of_birth"]["value"] or 
            # 契約者の郵便番号
            record_old["contract_zipcode"] != record["contract_zipcode"]["value"] or 
            # 契約者の住所
            # 契約者都道府県
            record_old["contract_address_pref"] != record["contract_address_pref"]["value"] or 
            # # 契約者住所１(市区町村)　# 契約者住所２(番地)
            # record_old["contract_address_1"] !=  record["contract_address_1"]["value"] + record["contract_address_2"]["value"]  or 
            # # 契約者住所３(ビル、マンション名)
            # record_old["contract_address_2"] != record["contract_address_3"]["value"] or 
            # 契約者住所１(市区町村)
            record_old["contract_address_1"] != record["contract_address_1"]["value"] or 
            # 契約者住所２(番地)
            record_old["contract_address_2"] != record["contract_address_2"]["value"]  or 
            # 契約者住所３(ビル、マンション名)
            record_old["contract_address_3"] != record["contract_address_3"]["value"] or 
            # 契約者の電話番号
            record_old["contract_tel_1"] != record["contract_tel_1"]["value"] or 
            # 契約者のメールアドレス
            record_old["contract_email"] != record["contract_email"]["value"] or 
            # 契約商品内容
            record_old["contract_product_request"] != record["contract_product_request"]["value"]):
          
            #「GMO掛け払いのデータ更新あり」にチェックを入れる
            record["need_gmo_ps_creditfacility_modifybuyer"] = {}
            record["need_gmo_ps_creditfacility_modifybuyer"]["value"] = True
            
            pass
        # バグ #2834 ------------------------E
        
        # 「GMO掛け払いのデータ更新あり」にチェックを入れる E
        # ------------------------------------
        

        # Get Old Data E
        # ------------------------------------

        # ------------------------------------
        # Auth0 user_info S

        # システム管理者のメールアドレスが変更された場合の、警告メッセージで「はい」を選んだ場合の処理

        #  ・入力されたのがAuth0に登録済みのメールアドレスならAuth0に再登録せずに、
        #    ログイン用のURLを記載したメールを送信する。ブロックされていた場合は有効化する。
        #  ・入力されたのがAuth0に未登録のメールアドレスならAuth0に登録して招待メールを送信する。
        #  ・旧システム管理者のAuth0アカウントをブロックする。

        if "administrator_email_old" in record:
            if "value" in record["administrator_email_old"]:
                if record["administrator_email"]['value'] != record["administrator_email_old"]['value']:

                    # 検索
                    result = get_auth0_users_by_email(event, context, "administrator")
                    print(result)

                    
                    if 'statusCode' in result:
                        if (result['statusCode'] == 400 or result['statusCode'] == 500):
                            result_body = json.loads(result['body'])
                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                            return result
                        else:
                            result_body = json.loads(result['body'])
                            if 'statusCode' in result_body:
                                if (result_body['statusCode'] == 400 or result_body['statusCode'] == 500):
                                    send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                    # err
                                    res_validation = "【システム管理者情報】：" + record["contract_email"]['value'] + "利用できません、メールアドレスを在確認ください。"
                                    return error_400(res_validation)

                    result_body = json.loads(result['body'])

                    is_registered = False
                    
                    # 登録済かどうか確認
                    if len(result_body) > 0:
                        # 登録済の場合
                        
                        is_registered = True
                        
                        print(result_body[0]['user_id'])

                        if result_body[0]['blocked']:
                            pass

                        # ユーザー情報更新、ブロック解除（デフォルト）
                        result = update_auth0_user_info(event, context, "administrator")
                        print(result)

                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            result_body = json.loads(result['body'])
                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                            return result

                        # # Auth0のロールから(Member)を削除する。
                        # result = remove_roles_from_a_user(event, context, "administrator")
                        # print(result)

                        # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        #     result_body = json.loads(result['body'])
                        #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        #     return result
                                                
                        # # Auth0のロールをシステム管理者のもの(MemberAdministrator, CommonPFSiteAvailableUser)にする。
                        # result = assign_roles_to_a_auth0_user(event, context, "administrator")
                        # print(result)

                        # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        #     result_body = json.loads(result['body'])
                        #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        #     return result
                                                
                    else:
                        # 未登録の場合
                        pass

                        # # Auth0に新規登録
                        # result = create_auth0_user(event, context, "administrator")
                        # print(result)

                        # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        #     result_body = json.loads(result['body'])
                        #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        #     return result

                        # # Auth0のロールをシステム管理者のもの(MemberAdministrator, CommonPFSiteAvailableUser)にする。
                        # result = assign_roles_to_a_auth0_user(event, context, "administrator")
                        # print(result)

                        # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        #     result_body = json.loads(result['body'])
                        #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        #     return result

                    # ******************************
                    # Phase3 change_admin_user
                    params = {
                        'company_code': record["company_code"]['value'],
                        'administrator_email_old': record["administrator_email_old"]['value'],
                        'administrator_email': record["administrator_email"]['value'],
                        'administrator_name_last': record["administrator_name_last"]['value'],
                        'administrator_name_first': record["administrator_name_first"]['value'],
                        'company_name': record["company_name"]['value'],
                        'entry_code': record["entry_code"]['value']
                    }
                    result = change_admin_user(event, context, params)
                    print(result)

                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        result_body = json.loads(result['body'])
                        send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        return result
                    # ##############################
                    
                    # ******************************
                    # 旧アカウントは申込ポータルサイトにはログインできる必要があるため、ブロックしないでほしい。
                    
                    # # 旧Auth0をBlock
                    # result = block_auth0_user_old(event, context)
                    # print(result)

                    # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    #     result_body = json.loads(result['body'])
                    #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                    #     return result
                    # ##############################

                    # ******************************
                    # change_admin_userで処理済

                    # # ・共通PFとSimSPのDBから旧システム管理者のデータを消す。
                    # # →mscone_lic.m_directory_userから企業ID、旧システム管理者のメールアドレスを検索してメールアドレスを空欄にする
                    # result = update_data_to_mscone_lic_m_directory_user(event, context)
                    # print(result)

                    # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    #     result_body = json.loads(result['body'])
                    #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                    #     return result
                    # ##############################

                    # →user_infrastructure.m_userから企業ID、旧システム管理者のメールアドレスを検索してレコードを削除
                    result = delete_data_from_user_infrastructure_m_user(event, context)
                    print(result)

                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        result_body = json.loads(result['body'])
                        send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        return result

                    if is_registered:
                        # 登録済の場合                        
                        # 入力されたのがAuth0に登録済みのメールアドレスならAuth0に再登録せずに、
                        # ログイン用のURLを記載したメールを送信する。(メールNo.25)
                        
                        # ------------------------------------
                        # システム管理者変更連絡メール送信

                        result = send_system_administrator_change_notification_email(event, context)

                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            result_body = json.loads(result['body'])
                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                            return result

                        # システム管理者変更連絡メール送信
                        # ------------------------------------
                        
                    else:
                        # 未登録の場合
                        pass
                        
                        # # ・招待日時と招待コードを更新する。
                        # result = get_invitation_code(event, context)

                        # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        #     result_body = json.loads(result['body'])
                        #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        #     return result

                        # print(result)

                        # if 'body' in result:
                        #     result_body = json.loads(result['body'])
                        #     record["invitation_code"]['value'] = result_body['invitation_code']
                        #     record['invitation_date']['value'] = result_body['invitation_date']

                        # # ------------------------------------
                        # # 招待メール送信

                        # result = send_invitation_email(event, context)

                        # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        #     result_body = json.loads(result['body'])
                        #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        #     return result

                        # # 招待メール送信
                        # # ------------------------------------

                        # ******************************
                        # 招待メールはフェーズ2の仕様なのでフェーズ3にはないです。
                        # Auth0のアカウントが無い場合は有効期限なしでパスワード設定が可能なメールの送信を行うよう仕様変更します。
                        # 申込内容修正サイトでシステム管理者を変更して、新しいシステム管理者のAuth0アカウントが作成される場合は
                        # 「システム管理者変更連絡」の代わりに「システム管理者変更連絡_アカウント作成」を送信してください。
                        # Phase3 change_admin_user で処理する
                        # ##############################

        # Auth0 user_info E
        
        # 
        # 契約者のメールアドレス変更はphase3では対応しない！！！
        # 
        # # 契約者のメールアドレスが変更された場合の警告表示・「はい」を選んだら処理続行。
        # # DBの契約情報テーブルと申込管理情報テーブルの契約者情報を新しい契約者の情報に書き換える。契約者変更連絡メールを送信する。
        # # 新しい契約者のAuth0アカウントが無い場合は招待メールを送信する。
        # # 申込ポータルサイトにログイン可能になるようAuth0のメタデータを設定する。
        # is_registered1 = False
        # if "contract_email_old" in record:
        #     if "value" in record["contract_email_old"]:
        #         if record["contract_email"]['value'] != record["contract_email_old"]['value']:

        #             # 検索
        #             result = get_auth0_users_by_email(event, context, "contract")
        #             print(result)

        #             if 'statusCode' in result:
        #                 if (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                     result_body = json.loads(result['body'])
        #                     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                     return result
        #                 else:
        #                     result_body = json.loads(result['body'])
        #                     if 'statusCode' in result_body:
        #                         if (result_body['statusCode'] == 400 or result_body['statusCode'] == 500):
        #                             send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                             # err
        #                             res_validation = "【契約情報】：" + "利用できません、メールアドレスを在確認ください。"
        #                             return error_400(res_validation)
                    
        #             result_body = json.loads(result['body'])
                    
                    

        #             # 登録済かどうか確認
        #             if len(result_body) > 0:
        #                 # 登録済の場合
                        
        #                 # err
        #                 res_validation = "【契約情報】：" + record["contract_email"]['value'] + "利用できません、メールアドレスを在確認ください。"
        #                 return error_400(res_validation)
        #             else:
        #                 # 未登録の場合
        #                 is_registered1 = True
        #                 pass
                        
        #                 # Auth0に新規登録
        #                 result = create_auth0_user(event, context, "contract")
        #                 print(result)

        #                 if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                     result_body = json.loads(result['body'])
        #                     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                     return result

        #                 # # Auth0のロールをシステム管理者のもの(MemberAdministrator, CommonPFSiteAvailableUser)にする。
        #                 # result = assign_roles_to_a_auth0_user(event, context, "contract")
        #                 # print(result)

        #                 # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                 #     result_body = json.loads(result['body'])
        #                 #     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                 #     return result

        #                 # ------------------------------------
        #                 # 招待メール送信
        #                 result = send_invitation_email(event, context)
    
        #                 if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                     result_body = json.loads(result['body'])
        #                     send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                     return result
        #                 # 招待メール送信
                        
        # DB m_company S
        result = update_m_company()
        print(result)

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            result_body = json.loads(result['body'])
            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
            return result

        # DB m_company E
        # ------------------------------------

        # ------------------------------------
        # DB m_contract S
        # DBの契約情報テーブルと申込管理情報テーブルの契約者情報を新しい契約者の情報に書き換える。
        result = update_m_contract()
        print(result)

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            result_body = json.loads(result['body'])
            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
            return result

        # DB m_contract E
        # ------------------------------------
        
        # DB m_cloud_strage S
        # DBのクラウドストレージマスタ。
        
        if 'entry_option' in record and record['entry_option'] is not None: 
            print(record['system_configuration_data']['value'])
            for system_configurationItem in record['system_configuration_data']['value']:
    
                # system_configurationItem = system_configurationKey
                # 変更チェックする
                result = editDateCloudStrageCheck(event, context, system_configurationItem)
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    result_body = json.loads(result['body'])
                    send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                    return result
                    
                result_body = json.loads(result['body'])
                
                # 登録済かどうか確認
                if 'result' in result_body:
                    rows = result_body['result']
                    # 登録済の場合
                    if len(rows) > 0:
                        record_new = rows[0]
    
                        if not (record_new['cloud_strage_domain'] == system_configurationItem['cloud_strage_domain']['value'] and record_new['user_name'] == system_configurationItem['user_name']['value'] and record_new['password'] == system_configurationItem['password']['value']  and record_new['enable_flg'] == system_configurationItem['enable_flg']['value']  and record_old["amount_upper_limit"] == record["amount_upper_limit"]["value"] ):
                            # データを更新する
                            result = update_m_cloud_strage(system_configurationItem,record)
                
                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                result_body = json.loads(result['body'])
                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                return result
                                
                            # オプションの更新通知 S # 02/07
                            result = send_email_data_cloud_strage(event, context, system_configurationItem,'M7')
                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                result_body = json.loads(result['body'])
                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                return result
        #                     # else:        
        #                     #     if record['system_configuration_type']["value"]  == 0 or record['system_configuration_type']["value"]  == 1 or record['system_configuration_type']["value"]  == 3 :    
        #                     # クラウドストレージ設定通知メール送信【M1】02/07
        #                     result = send_email_data_cloud_strage(event, context, system_configurationItem,'M1')
                    
                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                result_body = json.loads(result['body'])
                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                return result
                            
        #                     #     if record['system_configuration_type']["value"]  == 2:
                                    
        #                     #         # オプションの更新通知　E
        #                     #         if record["system_configuration_type2OK"]["value"]:
        #                     #             # クラウドストレージ設定通知メール送信【M3】02/07
        #                     #             result = send_email_data_cloud_strage(event, context, system_configurationItem,'M3')
                                
        #                     #             if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                     #                 result_body = json.loads(result['body'])
        #                     #                 send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                     #                 return result
        #                     #         else:
        #                     #             # クラウドストレージ設定通知メール送信【M5】02/07
        #                     #             result = send_email_data_cloud_strage(event, context, system_configurationItem,'M5')
                                
        #                     #             if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                     #                 result_body = json.loads(result['body'])
        #                     #                 send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                     #                 return result
                    else:
                        # データを新規作成する
                        result = update_m_cloud_strage(system_configurationItem,record)
            
                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            result_body = json.loads(result['body'])
                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                            return result
                        
                        # オプションの更新通知 S # 02/07
                        result = send_email_data_cloud_strage(event, context, system_configurationItem,'M7')
                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            result_body = json.loads(result['body'])
                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                            return result
        #                 # if record['system_configuration_type']["value"]  == 0 or record['system_configuration_type']["value"]  == 1 or record['system_configuration_type']["value"]  == 3 :      
        #                 # クラウドストレージ設定通知メール送信【M1】02/07
        #                 result = send_email_data_cloud_strage(event, context, system_configurationItem,'M1')
                
                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            result_body = json.loads(result['body'])
                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                            return result
                    
        #                 # if record['system_configuration_type']["value"]  == 2:
                            
        #                 #     if record["system_configuration_type2OK"]["value"]:
        #                 #         # クラウドストレージ設定通知メール送信【M3】02/07
        #                 #         result = send_email_data_cloud_strage(event, context, system_configurationItem,'M3')
                        
        #                 #         if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                 #             result_body = json.loads(result['body'])
        #                 #             send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                 #             return result
        #                 #     else:
        #                 #         # クラウドストレージ設定通知メール送信【M5】02/07
        #                 #         result = send_email_data_cloud_strage(event, context, system_configurationItem,'M5')
                        
        #                 #         if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #                 #             result_body = json.loads(result['body'])
        #                 #             send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #                 #             return result
    
        #             # クラウドストレージ設定通知メール送信【M1】
                    
        # print("-----------------E")
        # # DB m_cloud_strage E

        # # 契約者変更連絡メールを送信する。
        # if is_registered1:
        #     # ------------------------------------
        #     #  契約者変更連絡メール送信

        #     result = send_m_contract_email(event, context)

        #     if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #         result_body = json.loads(result['body'])
        #         send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
        #         return result

        #     # 招待メール送信
        #     # ------------------------------------
        # ------------------------------------
        # DB m_user S

        result = update_user_infrastructure_m_user()
        print(result)

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            result_body = json.loads(result['body'])
            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
            return result

        # DB m_user E
        # ------------------------------------
        
        # ----------------------0611----------------S
        # 本契約申込情報（確認済み）更新
        if amount_upper_limitType :
            paramall = {}
            
            paramall['contract_product_request'] = copy.deepcopy(record['contract_product_request']['value'])
            result = update_data_to_user_infrastructure_t_contract_request_confirmed(event, paramall)
            print(result)
            
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                result_body = json.loads(result['body'])
                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                return result
                
            # '# テーブル「契約商品マスタ」にデータ登録する'
            logger.debug('# テーブル「契約商品マスタ」にデータ登録する')
            logger.debug('m_contract_product')
    
            
            # 商品グループの商品コードを取得する
            product_codeArr = []
            for t1 in paramall['contract_product_request'] :
                product_codeArr.append(t1['product_group_id'])
            param1 = {}
            param1['product_group_id'] = product_codeArr
            result = get_data_from_user_infrastructure_m_regular_products(event, param1)
            print(result)
    
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                result_body = json.loads(result['body'])
                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                return result
    
            result_body = json.loads(result['body'])
            print(result_body)
            if 'result' in result_body:
                rows0 = result_body['result']
                for r0 in rows0 :
                    dataShow = False
                    for r1 in paramall['contract_product_request']:
                        # print("------------------------")
                        # print(r0)
                        # print(r1)
                        if r0['product_id'] == r1['main_product_id']:
                            dataShow = True
                            break
                        if r0['product_group_id'] == r1['product_group_id']:
                            r0['quantity'] = r1['quantity']
                    if (dataShow == False):
                        addArr = {}
                        addArr['main_product_id'] = r0['product_id']
                        addArr['quantity'] = r0['quantity']
                        addArr['product_group_id'] = r0['product_group_id']
                        paramall['contract_product_request'].append(addArr)
    
            # print('-------paramall[contract_product_request]------------')
            # print(paramall['contract_product_request'])
            current_year = datetime.datetime.now().year
            current_month = datetime.datetime.now().month
            
            
            
            param = {}
            param['company_code'] = record['company_code']['value']
            param['entry_code'] = record['entry_code']['value']
            result = get_data_from_user_infrastructure_m_contract(event, param)
            print(result)
    
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                result_body = json.loads(result['body'])
                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                return result
    
            result_body = json.loads(result['body'])
            print(result_body)
            if 'result' in result_body:
                rows = result_body['result']
                if len(rows) > 0:
                    logger.debug('# contract_product_request 存在する場合')
                    logger.debug(rows[0])
                    
                    
                    # 解約データを取得 リストから削除した場合
            
                    param = {}
                    param['contract_id'] = rows[0]['contract_id']
                    param['product_id'] = None
                    result = get_data_from_user_infrastructure_m_contract_product(event, param)
                    print(result)
            
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        result_body = json.loads(result['body'])
                        send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                        return result
            
                    result_body = json.loads(result['body'])
                    print(result_body)
                    if 'result' in result_body:
                        oldproduct_id = []
                        rows3 = result_body['result']
                        for r3 in rows3 :
                            # print(r3['product_id'])
                            # print(paramall['contract_product_request'])
                            if not any(entry.get('main_product_id') == r3['product_id'] for entry in paramall['contract_product_request']):
                                # 利用終了日に今月末日を設定。
                                print("解約データを取得 リストから削除した場合")
                                logger.debug('# データ更新')
                                param = {}
                                # 契約ID
                                param['contract_id'] = rows[0]['contract_id']
                                # 商品ID
                                param['product_id'] = r3['product_id']
                                # 今月末日を設定
                                if current_month == 12:
                                    last_day_of_current_month = datetime.datetime(current_year, current_month, 31)
                                else:
                                    last_day_of_current_month = datetime.datetime(current_year, current_month + 1, 1) - datetime.timedelta(days=1)
                                # 利用終了日
                                if r3['quantity'] is not None:
                                    param['use_end_date'] = last_day_of_current_month
                                else:
                                    param['use_end_date'] = None
                                result = update_data_to_user_infrastructure_m_contract_product(event, param,'0')
                                print(result)
                                
                                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                    result_body = json.loads(result['body'])
                                    send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                    return result
    
            
                    for t2 in paramall['contract_product_request'] :
                        ditem2 = t2
                        # logger.debug(ditem2)
                        # logger.debug(ditem2['main_product_id'])
                        # logger.debug(record['entry_code']['value'])
    
                        param = {}
                        param['contract_id'] = rows[0]['contract_id']
                        param['product_id'] = ditem2['main_product_id']
                        result = get_data_from_user_infrastructure_m_contract_product(event, param)
                        print(result)
            
                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                            result_body = json.loads(result['body'])
                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                            return result
                
                        result_body = json.loads(result['body'])
                        print(result_body)
                        
                        last_day_of_current_month = None
                        if 'result' in result_body:
                            rows1 = result_body['result']
                            if len(rows1) > 0:
                                logger.debug('#m_contract_product 存在する場合')
                                # 第一回　更新作成
                                if rows1[0]['quantity'] == None:
                                    param = {}
                                    # 契約ID
                                    param['contract_id'] = rows1[0]['contract_id']
                                    # 商品ID
                                    param['product_id'] = rows1[0]['product_id']
                                    # 数量
                                    param['quantity'] = ditem2['quantity']
                                    # 利用開始日
                                    param['use_start_date'] = rows[0]['subscription_start_date']
                                    # 利用終了日
                                    param['use_end_date'] = None
                                    result = update_data_to_user_infrastructure_m_contract_product(event, param,'0')
                                    print(result)
                                    
                                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                        result_body = json.loads(result['body'])
                                        send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                        return result
                                else:
                                    # 数量を変更場合
                                    # 数量を増やした場合
                                    # print(ditem2['quantity'])
                                    # print(rows1[0]['quantity'])
                                    if int(ditem2['quantity']) > int(rows1[0]['quantity']):
                                        print('数量を増やした場合-------')
                                        date_string = rows1[0]['use_start_date']
                                        date_object_s = datetime.datetime.strptime(date_string, '%Y-%m-%d %H:%M:%S')
                                        # print('-----date_object_s---------')
                                        # print(date_object_s)
                                        # print(date_object_s.year)
                                        # print(date_object_s.month)
                                        # print(current_year)
                                        # print(current_month)
                                        # print(date_object_s.year == current_year and date_object_s.month < current_month)
                                        # 利用開始日＞＝今月		そのまま
                                        # 利用開始日＜今月		利用終了日に先月末日を設定。新規レコードは追加
                                        # print(date_object_s.year)
                                        # print(current_year)
                                        # print(date_object_s.month)
                                        # print(current_month)
                                        # 今月末日を設定
                                        if current_month == 12:
                                            last_day_of_current_month = datetime.datetime(current_year, current_month, 31)
                                        else:
                                            last_day_of_current_month = datetime.datetime(current_year, current_month + 1, 1) - datetime.timedelta(days=1)
    
                                        if date_object_s.year < current_year or \
                                          (date_object_s.year == current_year and date_object_s.month < current_month):
                                            last_day_of_previous_month = datetime.datetime(current_year, current_month, 1) - datetime.timedelta(days=1)
                                            # 利用終了日に先月末日を設定。
                                            logger.debug('# データ更新')
                                            param = {}
                                            # 契約ID
                                            param['contract_id'] = rows1[0]['contract_id']
                                            # 商品ID
                                            param['product_id'] = rows1[0]['product_id']
                                            # 利用終了日
                                            if rows1[0]['quantity'] is not None:
                                                param['use_end_date'] = last_day_of_current_month
                                            else:
                                                param['use_end_date'] = None
                                            result = update_data_to_user_infrastructure_m_contract_product(event, param,'0')
                                            print(result)
                                            
                                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                                result_body = json.loads(result['body'])
                                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                                return result
                                            # 新規レコードは追加
                                            param = {}
                                            # 契約ID
                                            param['contract_id'] = rows1[0]['contract_id']
                                            # 商品ID
                                            param['product_id'] = rows1[0]['product_id']
                                            # 数量
                                            param['quantity'] = ditem2['quantity']
                                            # 利用開始日
                                            param['use_start_date'] = datetime.datetime(current_year, current_month, 1)
                                            if param['use_start_date'] != None:
                                                param['use_start_date'] = param['use_start_date'].strftime('%Y-%m-%d %H:%M:%S')
                                            # 利用終了日
                                            param['use_end_date'] = None
                                            result = insert_data_to_user_infrastructure_m_contract_product(event, param)
                                            print(result)
                                            
                                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                                result_body = json.loads(result['body'])
                                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                                return result
                                        else:
                                            param = {}
                                            # 契約ID
                                            param['contract_id'] = rows1[0]['contract_id']
                                            # 商品ID
                                            param['product_id'] = rows1[0]['product_id']
                                            # 数量
                                            param['quantity'] = ditem2['quantity']
                                            result = update_data_to_user_infrastructure_m_contract_product(event, param,'1')
                                            print(result)
                                            
                                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                                result_body = json.loads(result['body'])
                                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                                return result
                                            
                                    # 数量を減らした場合
                                    elif int(ditem2['quantity']) < int(rows1[0]['quantity']):
                                        print('数量を減らした場合-------')
                                        date_string = rows1[0]['use_start_date']
                                        date_object_s = datetime.datetime.strptime(date_string, '%Y-%m-%d %H:%M:%S')
                                        # 利用開始日＜＝今月		今月末日を設定		変更された数量でレコードを追加		
                                        # 利用開始日＞今月		数量を変更
                                        
                                        if date_object_s.year < current_year or \
                                          (date_object_s.year == current_year and date_object_s.month <= current_month):
                                            #  来月月初を指定
                                            next_month = current_month + 1 if current_month < 12 else 1
                                            next_year = current_year + 1 if current_month == 12 else current_year
                                            first_day_of_next_month = datetime.datetime(next_year, next_month, 1)
                                            
                                            # 今月末日を設定
                                            if current_month == 12:
                                                last_day_of_current_month = datetime.datetime(current_year, current_month, 31)
                                            else:
                                                last_day_of_current_month = datetime.datetime(current_year, current_month + 1, 1) - datetime.timedelta(days=1)
    
                                            # 利用終了日に今月末日を設定。
                                            # 利用終了日
                                            logger.debug('# データ更新')
                                            param = {}
                                            # 契約ID
                                            param['contract_id'] = rows1[0]['contract_id']
                                            # 商品ID
                                            param['product_id'] = rows1[0]['product_id']
                                            # 利用終了日
                                            if rows1[0]['quantity'] is not None:
                                                param['use_end_date'] = last_day_of_current_month
                                            else:
                                                param['use_end_date'] = None
                                            result = update_data_to_user_infrastructure_m_contract_product(event, param,'0')
                                            print(result)
                                            
                                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                                result_body = json.loads(result['body'])
                                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                                return result
                                                
                                            # 新規レコードは追加
                                            param = {}
                                            # 契約ID
                                            param['contract_id'] = rows1[0]['contract_id']
                                            # 商品ID
                                            param['product_id'] = rows1[0]['product_id']
                                            # 数量
                                            param['quantity'] = ditem2['quantity']
                                            # 利用開始日
                                            param['use_start_date'] = first_day_of_next_month
                                            if param['use_start_date'] != None:
                                                param['use_start_date'] = param['use_start_date'].strftime('%Y-%m-%d %H:%M:%S')
                                            # 利用終了日
                                            param['use_end_date'] = None
                                            result = insert_data_to_user_infrastructure_m_contract_product(event, param)
                                            print(result)
                                            
                                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                                result_body = json.loads(result['body'])
                                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                                return result
                                        else:
                                            param = {}
                                            # 契約ID
                                            param['contract_id'] = rows1[0]['contract_id']
                                            # 商品ID
                                            param['product_id'] = rows1[0]['product_id']
                                            # 数量
                                            param['quantity'] = ditem2['quantity']
                                            result = update_data_to_user_infrastructure_m_contract_product(event, param,'1')
                                            print(result)
                                            
                                            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                                result_body = json.loads(result['body'])
                                                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                                return result  
                                    
                                    elif (rows[0]['service_usable_status'] == "解約"):
                                        # 利用終了日に今月末日を設定。
                                        logger.debug('# データ更新')
                                        param = {}
                                        # 契約ID
                                        param['contract_id'] = rows1[0]['contract_id']
                                        # 商品ID
                                        param['product_id'] = rows1[0]['product_id']
                                        result = update_data_to_user_infrastructure_m_contract_product(event, param,'0')
                                        print(result)
                                        
                                        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                            result_body = json.loads(result['body'])
                                            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                            return result
                            else:
                                logger.debug('#m_contract_product 存在しな場合')
                                # 新規レコードは追加
                                param = {}
                                # 契約ID
                                param['contract_id'] = rows[0]['contract_id']
                                # 商品ID
                                param['product_id'] = ditem2['main_product_id']
                                # 数量
                                param['quantity'] = ditem2['quantity']
                                # 利用開始日
                                param['use_start_date'] = rows[0]['subscription_start_date']
                                # 利用終了日
                                if ditem2['quantity'] is not None:
                                    param['use_end_date'] = last_day_of_current_month
                                else:
                                    param['use_end_date'] = None
                                result = insert_data_to_user_infrastructure_m_contract_product(event, param)
                                print(result)
                                
                                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                                    result_body = json.loads(result['body'])
                                    send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                                    return result
                                
        # ----------------------0611----------------E


        # # Gmo 購入企業変更API
        # result = gmo_creditfacility_modifybuyer(event, context)
        # print(result)

        # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        #     return result

        # ------------------------------------
        # データの更新通知(お客様) S
        # 02/07
        if 'entry_option' not in record: 
            result = send_email_data_update_notification_to_customer(event, context)
    
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                result_body = json.loads(result['body'])
                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                return result
    
            # データの更新通知(お客様) E
            # ------------------------------------
    
            # ------------------------------------
            # データの更新通知 S
            # 02/07
            result = send_email_data_update_notification(event, context)
    
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                result_body = json.loads(result['body'])
                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                return result
        # 02/07
        # データの更新通知 E
        # ------------------------------------

        # ------------------------------------
        # 請求書の送付方法変更 S
        print('請求書の送付方法変更 S-------------')

        # 請求書の送付方法           
        is_changed_of_invoice_sending_method = False
        if 'invoice_sending_method' in record_old:
            tmp_invoice_sending_method = 0
            if record["invoice_sending_method"]["value"] == 1:
                tmp_invoice_sending_method = 1
            elif record["invoice_sending_method"]["value"] == 0:
                tmp_invoice_sending_method = 0
            else:
                tmp_invoice_sending_method = 0
            if str(tmp_invoice_sending_method) != str(record_old['invoice_sending_method']):
                is_changed_of_invoice_sending_method = True
        else:
            is_changed_of_invoice_sending_method = True

        if is_changed_of_invoice_sending_method:

            result = send_email_change_of_invoice_sending_method(event, context)

            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                result_body = json.loads(result['body'])
                send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
                return result

        print('請求書の送付方法変更 E-------------')
        # 請求書の送付方法変更 E
        # ------------------------------------

        # DB 更新履歴の追加
        result = insert_m_update_company_info_history()
        print(result)

        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            result_body = json.loads(result['body'])
            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
            return result

    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# ------------------------------------
# t_entry S

# def get_t_entry_entry_code(event, context, param):

#     logger.info('get_t_entry_entry_code!!!')

#     res = {}

#     try:
              
#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'GET',
#             'path': '/rds/user_infrastructure/t_entry_1',
#             'queryStringParameters': {
#                 'entry_code': {
#                     'value': param["entry_code"]
#                 }
#             }
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             FunctionName='evo-lam-sys-rds',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# ------------------------------------
# t_entry S

def get_t_manage_request_entry_code(event, context, param):

    logger.info('get_t_manage_request_entry_code!!!')

    res = {}

    try:
              
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_manage_request_sql',
            'queryStringParameters': {
                'company_code': {
                    'value': param["company_code"]
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_data_from_user_infrastructure_t_entry(event, context):

    logger.info('get_data_from_user_infrastructure_t_entry!!!')

    result = {}

    result1 = {}
    
    result_body = {}
    
    result_cloud_body = {}

    try:
        
        # ------------------------------------
        # DB 
        # service_id_system_idを取得する
        result = get_data_service_id_system_id(event, context)
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        
        result_body0 = json.loads(result['body'])
        print(result_body0)
        
        tmp = {}
        strService_id = "SRV00001"
        strSystem_id = ""
        if 'result' in result_body0:
            rows = result_body0['result']
            strService_id = rows[0]['service_id']
            strSystem_id = rows[0]['system_id']
        record["service_id"] = strService_id
        # ------------------------------------
        
        # DB 
        # 
        result = get_data_from_user_infrastructure_t_manage_request(event, context, strService_id, strSystem_id)
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            return result
        result_body1 = json.loads(result['body'])
        
        print(result_body1)
        
        if 'result' in result_body1:
            rows = result_body1['result']
            if len(rows) < 1:
                msg = '情報は存在しないので、入力情報を在確認ください。'
                return error_400(msg)
            dataStatus = rows[0]['status']
            if dataStatus == 'ワークショップ申請' or dataStatus == 'ワークショップ受付' or dataStatus == 'ワークショップ実施中':
                result = get_data_from_user_infrastructure_t_manage_request_workshop(event, context, strService_id, strSystem_id)
                if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                    return result
                result_body = json.loads(result['body'])
            else:
                if '本契約' in dataStatus:
                    result = get_data_from_user_infrastructure_t_manage_request_contract(event, context, strService_id, strSystem_id)
                    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
                        return result
                    result_body = json.loads(result['body'])
                    if 'result' in result_body:
                        rows = result_body['result']
                        if len(rows) > 0:
                            # --------------------1127-------#7197--------S
                            result1 = lam_sim_executionLogCharge_get(event, rows[0]['contract_id'])
                            result_body1 = json.loads(result1['body'])
                            result_body['result'][0]['used_amounts'] = str(result_body1['total_amount'])
                            result_body['result'][0]['has_fixed_monthly_option'] = result_body1['has_fixed_monthly_option']
                            # print('result_bodyのused_amounts')
                            # print(result_body['result'][0]['used_amounts'])
                            # --------------------1127-------#7197--------E
                            
                            # --------------------0611---------------S
                            
                            filtersT2 = []

                            for t2 in rows[0]['contract_product_request']:
                                ditem2 = t2
                                # logger.debug(ditem2)
                                # logger.debug(ditem2['billing_identifier'])
                            
                                data_tr = {}
                
                                data_tr['selectLink'] = ditem2['billing_identifier'] + ' 同時実行数：' + ditem2['quantity']
                                
                                filtersT2.append(data_tr)
                            
                            result_body['result'][0]['contract_product_request'] = filtersT2
                            #  契約する商品リスト
                            print('--------契約する商品リスト----')
                            resultviewbillingidentifer = get_data_from_view_product_groups_billing_identifier(event, strSystem_id)
                            if 'statusCode' in result and (resultviewbillingidentifer['statusCode'] == 400 or resultviewbillingidentifer['statusCode'] == 500):
                                return resultviewbillingidentifer
                            result_viewbillingidentifer = json.loads(resultviewbillingidentifer['body'])
                            if 'result' in result_viewbillingidentifer:
                                result_body['result'][0]['billing_identifierList'] = result_viewbillingidentifer['result']
                            # --------------------0611---------------E
                            # --------------------0704---------------S
                            result_body['result'][0]['tenant'] = GV.CONFIG['AUTH0_TENANT']
                            # --------------------0704---------------E
                            resultcloudstrage = get_data_from_user_infrastructure_m_cloud_strage(event, rows[0]['contract_id'])
                            if 'statusCode' in result and (resultcloudstrage['statusCode'] == 400 or resultcloudstrage['statusCode'] == 500):
                                return resultcloudstrage
                            result_cloudstrage = json.loads(resultcloudstrage['body'])
                            if 'result' in result_cloudstrage:
                                result_cloud_body = result_body

                                result_cloud_body['result'][0]['system_configuration_data'] = result_cloudstrage['result']

                                # rclone.confファイルのチェック
                                BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
                                s3_folder = 'user-infrastructure/cloud_strage/' + rows[0]['contract_id'] + '/rclone.conf'
                                results3 = boto3.client('s3').list_objects(Bucket=BUCKET_NAME, Prefix=  s3_folder)
                                # 次もキモ。上記のパスが存在しない場合、返ってきた結果の中には
                                # Contents というキーが存在しない。これを使えば存在判定ができる。
                                if "Contents" in results3:
                                    result_cloud_body['result'][0]['s3_rclone']  = True
                                else:
                                    result_cloud_body['result'][0]['s3_rclone']  = False
                                    
                                result['body'] = json.dumps(result_cloud_body)
                            
         # logger.info('-----------------')            
        # logger.info(result_body)
        if result_body == {} or len(result_body['result']) == 0:
            msg = 'アクセス権限がありません。'
            return error_400(msg)
            
        # ユーザー権限のチェック
        #  admin_user 本契約受付、申し込み修正サイトでシステム管理者変更
        #  workshop_user 申込ポータルサイトでワークショップを申し込み
        if (user_data_role_cheku(event, result_body['result']) == False):
            msg = 'アクセス権限がありません。'
            return error_400(msg)

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return result


def get_data_from_gdfuse(event, context):
    
    logger.info('get_data_from_gdfuse!!!')
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['system_configuration_type2OK'] = False
    
    result = {}
    result_body = {}

    try:
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        folder_id = ''
        company_code = ''
        bridge_instance_id = ''
        tmp = {}
    
        if 'folder_id' in query_string_parameters:
            if type(query_string_parameters['folder_id']) is str:
                tmp = json.loads(query_string_parameters['folder_id'])
                if 'value' in tmp:
                    folder_id = tmp['value']
            else:
                if 'value' in query_string_parameters['folder_id']:
                    folder_id = query_string_parameters['folder_id']['value'] 
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    company_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    company_code = query_string_parameters['company_code']['value']     
        
        # (修正後)用の値設定 ==>
        # ------------------------------------
        # DB 
        # service_id_system_idを取得する
        result = get_data_ec2id(event, company_code)
        if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            result_body = json.loads(result['body'])
            send_email_on_error(inspect.currentframe().f_code.co_name, result_body)
            return result
        
        result_body = json.loads(result['body'])
        print(result_body)
        
        if 'result' in result_body:
            rows = result_body['result']
            bridge_instance_id = rows[0]['bridge_instance_id']
        # ------------------------------------
        EC2ID = bridge_instance_id #ファイルサーバ dev-ec2-googledrive-test ubuntu
        gdFolder=folder_id
        mpFolder="/disc3" #企業のElastic Block Storeのマウントポイント
        emailTo="test-sales-ml@ndes.co.jp.test"
        print("--------(修正後)用の値設定------------------")
        print(company_code)
        print(EC2ID)
        print(gdFolder)
        print(mpFolder)
        print(emailTo)
        print("----------(修正後)用の値設定----------------")
        # <== (修正後)用の値設定

        endFile="/root/end/###".replace('###',company_code)
        reqFile="/root/request/###".replace('###',company_code)
        rlyFile="/root/reply/###".replace('###',company_code)
        ssm = boto3.client('ssm')
        cmd = ssm.send_command(
            InstanceIds=[ EC2ID ],
            DocumentName="AWS-RunShellScript",
            Parameters = {
                "commands": [
                    "sudo su - root",
                    "PATH=$PATH:/root/bin",
                    "rm " + rlyFile,
                    "echo " + mpFolder + "," + gdFolder + "," + emailTo + " >" + reqFile,
                    "touch " + endFile
                ]    
            }
        )
        print("1")
        command_id = cmd['Command']['CommandId']
        while True:
            time.sleep(0.2)
            res = ssm.list_command_invocations(CommandId=command_id,Details=True)
    
            invocations = res['CommandInvocations']
            if len(invocations) <= 0: continue
    
            status = invocations[0]['Status']
            if status == 'Success':
                cps = invocations[0]['CommandPlugins']
                # print('cps length=' + str(len(cps)))
                # print('res=' + str(invocations[0]['CommandPlugins'][0]['Output']))
                # print("OK")
                break
            if status == 'Failed':
                print('res=>' + str(res))
                print("NO")
                break
        print("getting")
        
        msg = ""
        stat = "Failed"
        while stat != "Success":
            time.sleep(1)
            cmd = ssm.send_command(
                InstanceIds=[ EC2ID ],
                DocumentName="AWS-RunShellScript",
                Parameters = {
                    "commands": [
                        "sudo su - root",
                        "cat " +rlyFile
                    ]    
                }
            )
            command_id = cmd['Command']['CommandId']
            while True:
                time.sleep(1)
                res = ssm.list_command_invocations(CommandId=command_id,Details=True)
                invocations = res['CommandInvocations']
                if len(invocations) <= 0:
                    # print("no invocation")
                    continue
                # print("invocation cout=" + str(len(invocations)))
                stat = invocations[0]['Status']
                print("replyファイル待ち:" + stat)
                if stat == 'Success':
                    cps = invocations[0]['CommandPlugins']
                    # print('cps length=' + str(len(cps)))
                    msg=str(invocations[0]['CommandPlugins'][0]['Output'])
                    if 0 == len(msg):
                        continue
                    print('res=' + msg)
                    print("OK")
                    break
                elif  stat == 'Failed':
                    break
                else:
                    continue
        cmd = ssm.send_command(
            InstanceIds=[ EC2ID ],
            DocumentName="AWS-RunShellScript",
            Parameters = {
                "commands": [
                    "sudo su - root",
                    "rm " + rlyFile
                ]    
            }
        )
        command_id = cmd['Command']['CommandId']
        while True:
            time.sleep(1)        
            res = ssm.list_command_invocations(CommandId=command_id,Details=True)
            invocations = res['CommandInvocations']
            if len(invocations) <= 0:
                # print("no invocation")
                continue
            # print("invocation cout=" + str(len(invocations)))
            status = invocations[0]['Status']
            print("replyファイル削除:" + status)
            if status == 'Success':
                if msg.startswith('https://'):
                    # return { "msg": "許可してから、再度、このパネルをクリックしてください", "url": msg }
                    # 、GoogleDriveマウントAPIを呼び出す。、NGの場合は【M5】のメールを送信する。
                    res['system_configuration_type2OK'] = False
                    res['msg'] = "許可してから、再度、このパネルをクリックしてください",
                    res['url'] = msg
                    return {
                        'statusCode': 200,
                        'headers': RESPONSE_HEADERS,
                        # 'body': json.dumps(res, default=str)
                        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
                    }
                else :
                    # return { "msg": "マウント済", "url": ""}  
                    # 結果がOKの場合、【M3】のメールを送信し
                    res['system_configuration_type2OK'] = True
                    res['msg'] = "マウント済",
                    res['url'] = ""
                    return {
                        'statusCode': 200,
                        'headers': RESPONSE_HEADERS,
                        # 'body': json.dumps(res, default=str)
                        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
                    }
            
    except Exception as err:
        res['system_configuration_type2OK'] = False
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

# ユーザー権限のチェック
def user_data_role_cheku(event,listData):
    logger.info('user_data_role_cheku!!!')

    resType = False
    
    event_headers = {}
    if 'headers' in event and event['headers'] is not None: 
        event_headers = event['headers']
        
        logger.info(event_headers)

        # 検証
        if 'Authorization' not in event_headers:
            msg = '認証情報が正しくありません。'
            return error_400(msg)
        
        # access_token_info = get_access_token_info(event_headers["Authorization"])
        # if 'my_roles' not in access_token_info or 'user_metadata' not in access_token_info :
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)
        
        # # 通常ユーザー管理者 のみアクセス可能
        # if GV.CONFIG['AUTH0_ROLES']['ROLES_MEMBER_ADMINISTRATOR'] not in access_token_info['my_roles']:
        #     msg = 'アクセス権限がありません。'
        #     return error_400(msg)

        access_token_info = get_access_token_info(event_headers["Authorization"])

        # フェーズ3 20230830 ------------------------S

        if 'user_metadata' not in access_token_info:
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        user_metadata = access_token_info['user_metadata']
        logger.info(user_metadata)

        if 'data' not in user_metadata:
            print(''' 'data' not in user_metadata ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)

        if type(user_metadata['data']) != list:
            print(''' type(user_metadata['data']) != list ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        if len(user_metadata['data']) < 1:
            print(''' len(user_metadata['data']) < 1 ''')
            msg = 'アクセス権限がありません。'
            return error_400(msg)
        
        # フェーズ3 20230830 ------------------------E
        
        logger.info(listData[0]['status'])

        for metadataList in access_token_info['user_metadata']['data']:
            if listData[0]['company_code'] == metadataList['company_code'] and listData[0]['system_id']  == metadataList['system_id'] and listData[0]['service_id']  == metadataList['service_id'] :
                if (listData[0]['status'] == 'ワークショップ申請' or listData[0]['status'] == 'ワークショップ受付' or listData[0]['status'] == 'ワークショップ実施中'):
                    if GV.CONFIG['AUTH0_ROLES']['ROLES_WORKSHOP_USER'] in metadataList['roles']:
                        resType = True
                        return resType
                if (listData[0]['status'] == '本契約申請' or listData[0]['status'] == '本契約受付' or listData[0]['status'] == '環境構築中' or listData[0]['status'] == '本契約利用中'):
                    if GV.CONFIG['AUTH0_ROLES']['ROLES_ADMIN_USER'] in metadataList['roles']:
                        resType = True
                        return resType
    logger.info(resType)
    return resType

def get_data_from_user_infrastructure_t_manage_request(event, context, strService_id, strSystem_id):

    logger.info('get_data_from_user_infrastructure_t_manage_request!!!')

    res = {}

    try:
        if "administrator_email_old" in record and "value" in record["administrator_email_old"]:
            record["auth0_user_id"]["value"] = \
                record["administrator_email_old"]["value"]
                
        event_body = {}
        if 'body' in event and event['body'] is not None:
            event_body = json.loads(event['body'])
            logger.info(event_body)

            tmp = event_body['record']
            if "auth0_user_id" in tmp and "value" in tmp["auth0_user_id"]:
                record["auth0_user_id"]["value"] = tmp["auth0_user_id"]["value"]
            if "service_id" in tmp and "value" in tmp["service_id"]:
                record["service_id"]["value"] = tmp["service_id"]["value"]
            if "system_id" in tmp and "value" in tmp["system_id"]:
                record["system_id"]["value"] = tmp["system_id"]["value"]

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
            auth0_user_id = None
            if 'auth0_user_id' in query_string_parameters:
                if type(query_string_parameters['auth0_user_id']) is str:
                    tmp = json.loads(query_string_parameters['auth0_user_id'])
                    if 'value' in tmp:
                        auth0_user_id = tmp['value']
                else:
                    if 'value' in query_string_parameters['auth0_user_id']:
                        auth0_user_id = query_string_parameters['auth0_user_id']['value']
                        
            if auth0_user_id is not None:
                record["auth0_user_id"]["value"] = auth0_user_id
                
            company_code = None
            if 'company_code' in query_string_parameters:
                if type(query_string_parameters['company_code']) is str:
                    tmp = json.loads(query_string_parameters['company_code'])
                    if 'value' in tmp:
                        company_code = tmp['value']
                else:
                    if 'value' in query_string_parameters['company_code']:
                        company_code = query_string_parameters['company_code']['value']
                        
            if company_code is not None:
                record["company_code"]["value"] = company_code
                
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_manage_request',
            'queryStringParameters': {
                'auth0_user_id': {
                    'value': record["auth0_user_id"]["value"]
                },
                'service_id': {
                    'value': strService_id
                },
                'system_id': {
                    'value': strSystem_id
                },
                'company_code': {
                    'value': record["company_code"]["value"]
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_data_from_user_infrastructure_m_cloud_strage(event, strContract_id):

    logger.info('get_data_from_user_infrastructure_m_cloud_strage!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_cloud_strage',
            'queryStringParameters': {
                 'contract_id': {
                    'value': strContract_id
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

logger.debug('# ************0704******************') 
def get_data_from_user_infrastructure_m_auth0_management(event):

    logger.info('get_data_from_user_infrastructure_m_auth0_management!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        strservice = ''
        strCompany_code = ''
        tmp = {}
    
        if 'serviceId' in query_string_parameters:
            if type(query_string_parameters['serviceId']) is str:
                tmp = json.loads(query_string_parameters['serviceId'])
                if 'value' in tmp:
                    strservice = tmp['value']
            else:
                if 'value' in query_string_parameters['serviceId']:
                    strservice = query_string_parameters['serviceId']['value']
        if (strservice == ''):
            strservice = record["serviceId"]['value']
            
        if 'company_code' in query_string_parameters:
            if type(query_string_parameters['company_code']) is str:
                tmp = json.loads(query_string_parameters['company_code'])
                if 'value' in tmp:
                    strCompany_code = tmp['value']
            else:
                if 'value' in query_string_parameters['company_code']:
                    strCompany_code = query_string_parameters['company_code']['value']
        if (strCompany_code == ''):
            strCompany_code = record["company_code"]['value']
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_auth0_management',
            'queryStringParameters': {
                 'service': {
                    'value': strservice
                },
                'company_code': {
                    'value': strCompany_code
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_data_from_user_infrastructure_m_auth0_management_list(event):

    logger.info('get_data_from_user_infrastructure_m_auth0_management_list!!!')
    
    logger.info(event)

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        strtenant = ''
        tmp = {}
    
        if 'tenant' in query_string_parameters:
            if type(query_string_parameters['tenant']) is str:
                tmp = json.loads(query_string_parameters['tenant'])
                if 'value' in tmp:
                    strtenant = tmp['value']
            else:
                if 'value' in query_string_parameters['tenant']:
                    strtenant = query_string_parameters['tenant']['value']
        
        if strtenant == '':
            event_body = {}
            if 'body' in event and event['body'] is not None:
                event_body = json.loads(event['body'])
                logger.info(event_body)
    
                tmp = event_body['record']
                if "tenant" in tmp and "value" in tmp["tenant"]:
                    strtenant = tmp["tenant"]['value']
                
        if (strtenant != ''):
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_auth0_management_list',
                'queryStringParameters': {
                     'tenant': {
                        'value': strtenant
                    }
                }
            }
    
            Payload = json.dumps(input_event)
            print("---01: Payload:", Payload)
    
            # 呼び出し
            response = boto3.client('lambda').invoke(
                FunctionName='prod-lam-sys-rds',
                InvocationType='RequestResponse',
                Payload=Payload
            )
            print("---02: response:", response)
    
            res = response
    
            result = None
            if 'StatusCode' in response and response['StatusCode'] == 200:
    
                # レスポンス読出し
                Payload = json.loads(response['Payload'].read())
                print("---03: body:", Payload)
                res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

logger.debug('# ************0704******************') 

def get_data_from_view_product_groups_billing_identifier(event,strSystem_id):
    
    logger.info('get_data_from_view_product_groups_billing_identifier!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/view_product_groups_billing_identifier',
            'queryStringParameters': {
                'system_id': {
                    'value': strSystem_id
                },
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res
    
    
def get_data_file_upload(event, context):
   
    print('get_data_file_upload!!!')
    
    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None
    
    
        wavBody = event['body']
        print(wavBody)
    
        jsons = wavBody.split('\r\n')
        # ファイル名前の設定
        fileName = eval(jsons[1].split('=')[2])
    
        # 契約IDの設定
        strContract_id = jsons[-3]
    
        # Boundary
        boundary = jsons[0].replace('-', '')
        wavBody = jsons[4]
        for i in range(5, len(jsons)):
            if jsons[i].find(boundary) != -1:
                break
            else:
                wavBody = wavBody + '\r\n' + jsons[i]
                
        # rclone.confファイルのチェック
        
        local_dir = "/tmp/"
    
        # ②企業コードを記載したテキストファイル「rclone_name.txt」を作成
        with open(local_dir + '/' + fileName, 'w') as txtf:
            txtf.write(wavBody)
        txtf.close()
            
    
        Filename = local_dir + '/' + fileName
        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        Key = 'user-infrastructure/cloud_strage/' + strContract_id + '/' + fileName
        boto3.client('s3').upload_file(Filename, BUCKET_NAME, Key)
        
    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
    
def get_data_file_file_download(event, context):
   
    print('get_data_file_file_download!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
        
    try:
        event_body = {}
        event_body = json.loads(event['body'])
        
        tmp = event_body['record']
        # print(tmp)
        print("=======================")
        print(tmp["contract_id"])
        print(tmp["contract_id"]['value'])
        
        GV.ENV = event['stageVariables']['env'].upper()

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/1.zip'
        OBJECT_KEY_NAME = 'config.json'

        bucket = s3.Bucket(BUCKET_NAME)
        
        s3_folder = 'user-infrastructure/cloud_strage/'
        local_dir = "/tmp/data"
        for p in glob.glob('/tmp/' + '*'):
            if os.path.isfile(p):
                os.remove(p)
        
        print("1")
        z = zipfile.ZipFile('/tmp/new.zip','w',zipfile.ZIP_DEFLATED)
        
        for obj in bucket.objects.filter(Prefix=s3_folder):
            if 'user-infrastructure/cloud_strage/CON' not in obj.key:
                target = obj.key if local_dir is None \
                    else os.path.join(local_dir, os.path.relpath(obj.key, s3_folder))
                if not os.path.exists(os.path.dirname(target)):
                    os.makedirs(os.path.dirname(target))
                if obj.key[-1] == '/':
                    continue
                
                bucket.download_file(obj.key, target)
        print("2")
        # ②企業コードを記載したテキストファイル「rclone_name.txt」を作成
        with open(local_dir + '/rclone_name.txt', 'w') as txtf:
            txtf.write(str(tmp["contract_id"]['value']))
            # txtf.write('contract_id = ')
        txtf.close()
        
            
        for dirpath, dirnames, filenames in os.walk(local_dir):
            fpath = dirpath.replace(local_dir,'') 
            fpath = fpath and fpath + os.sep or ''
            for filename in filenames:
                z.write(os.path.join(dirpath, filename),fpath+filename)
                # print ('OK')
        z.close()
        # POST = 8886
        zip_path = '/tmp/new.zip'
        
        # ファイルはS3にアップする
        compressed_file_key = 'user-infrastructure/rclone_config_program_back/rclone.zip'
        boto3.client('s3').upload_file(zip_path, BUCKET_NAME, compressed_file_key)
    
        # URL作成
        expiration_time = 60  # URL利用時間
        presigned_url = boto3.client('s3').generate_presigned_url('get_object',
            Params={'Bucket': BUCKET_NAME, 'Key': compressed_file_key},
            ExpiresIn=expiration_time
        )

        return {
            "statusCode": 200,
            "headers": RESPONSE_HEADERS,
            "body": presigned_url,
            "isBase64Encoded": True,
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    finally:
        print('get_data_file_file_download!!!')
        print('-----------------------------------------------------E')

def post_data_to_s3file(event, context):
   
    print('post_data_to_s3file!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
        
    try:
        event_body = {}
        event_body = json.loads(event['body'])
        
        tmpData = event_body['record']
        
        print("=======================")
        print(tmpData)

        GV.ENV = event['stageVariables']['env'].upper()
        
        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'

        s3_file = 'kintone/csv/test.csv'
        # local_dir_file = "/tmp/data/test.csv"
        
        local_dir = "/tmp/data"
        local_file = "test.csv"
        image_file = ""
        local_dir_file = os.path.join(local_dir, local_file)
        
        # 如果文件夹不存在，则创建文件夹
        if not os.path.exists(local_dir):
            os.makedirs(local_dir)
        
        # data_str = json.dumps(tmpData)
        # ②企業コードを記載したテキストファイル「rclone_name.txt」を作成
        with open(local_dir_file, 'w') as txtf:
            txtf.write('レコード番号, test1, table_test' + '\n')
            for item in tmpData['data']:
                tr = ''
                if (len(item['テーブル']['value']) > 0):
                    tr = str(item['レコード番号']['value']) + ',' + str(item['test1']['value']) 
                else:
                    tr = str(item['レコード番号']['value']) + ',' + str(item['test1']['value']) + ',' + '\n'
                    txtf.write(tr)
                    
                # 一般のイメージ保存
                for image_item in item['image1']['value']:
                    print('||||image_item|||')
                    print(str(image_item['fileKey']))
                    print(str(image_item['name']))
                    get_image_url(str(image_item['fileKey']),str(image_item['name']))

                # テーブルのデータ保存
                for table_item in item['テーブル']['value']:
                    print('|||table_item||||')
                    tr_table = tr + ',' + str(table_item['value']['table_test']['value'])  + '\n'
                    txtf.write(tr_table)
                    
                     # テーブルのイメージ保存
                    for table_image_item in table_item['value']['table_file']['value']:
                        print('|||table_image_item||||')
                        get_image_url(str(table_image_item['fileKey']),str(table_image_item['name']))
                

        txtf.close()
        
        # ファイルはS3にアップする
        boto3.client('s3').upload_file(local_dir_file, BUCKET_NAME, s3_file)
        
        return {
            "statusCode": 200,
            "headers": RESPONSE_HEADERS,
            "body": '',
            "isBase64Encoded": True,
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    finally:
        print('get_data_file_file_download!!!')
        print('-----------------------------------------------------E')

def kintone_post_data_to_s3file(event, context):
   
    print('kintone_post_data_to_s3file!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
        
    try:
        event_body = {}
        event_body = json.loads(event['body'])
        
        tmpData = event_body['record']
        
        print("=======================")
        print(tmpData)
        csv_first = 'レコードの開始行, レコード番号, アプリ表示名, アプリ表示, ボタン表示[資料請求], ボタン表示[トライアル], ボタン表示[ワークショップ], ボタン表示[本契約], サプライヤID, システムID, 個人情報取り扱い本文, アプリ説明, 資料請求説明, トライアル説明, トライアル申込み完了, ワークショップ説明, ワークショップ申し込み完了,アンケート説明,本契約説明,利用規約,本契約申込み完了,更新者,作成者,更新日時,作成日時,アンケート質問,アンケート回答選択肢("|"区切り),アンケート回答タイプ,必須項目[必須],資料説明タイトル,資料説明本文,アプリ画像URL,利用規約のPDFファイルURL,資料画像URL,資料URL'
        

        GV.ENV = event['stageVariables']['env'].upper()
        
        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'

        s3_file = 'kintone/csv/申込ポータルサイト設定.csv'
        # local_dir_file = "/tmp/data/test.csv"
        
        local_dir = "/tmp/data"
        local_file = "申込ポータルサイト設定.csv"
        image_file = ""
        local_dir_file = os.path.join(local_dir, local_file)
        
        # 如果文件夹不存在，则创建文件夹
        if not os.path.exists(local_dir):
            os.makedirs(local_dir)
        
        # data_str = json.dumps(tmpData)
        # ②企業コードを記載したテキストファイル「rclone_name.txt」を作成
        result_array = [item for item in tmpData['data']]
        print(result_array)
        result_str = '\n'.join(map(str, result_array))
        
        print("1111111")
        with open(local_dir_file, 'w') as txtf:
            print("22222")
            txtf.write(csv_first + '\n')
            txtf.write(result_str)
            
            # for item in tmpData['data']:
                # txtf.write(str(item['レコード番号']['value']) + ',' + str(item['test1']['value']) + '\n')
                
                # 生成数组
                
                
                # for image_item in item['image1']['value']:
                #     print('|||||||')
                #     print(str(image_item['fileKey']))
                #     print(str(image_item['name']))
                #     get_image_url(str(image_item['fileKey']),str(image_item['name']))
                    
        
        txtf.close()
        
        # ファイルはS3にアップする
        boto3.client('s3').upload_file(local_dir_file, BUCKET_NAME, s3_file)
        
        return {
            "statusCode": 200,
            "headers": RESPONSE_HEADERS,
            "body": '',
            "isBase64Encoded": True,
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    finally:
        print('get_data_file_file_download!!!')
        print('-----------------------------------------------------E')
        
# ----------------------0611-------------------S
def update_data_to_user_infrastructure_t_contract_request_confirmed(event, param):

    logger.info('update_data_to_user_infrastructure_t_contract_request_confirmed!!!')
    logger.info(record)
    logger.info(param)

    res = {}

    try:

        record['condition_value'] = {
            'entry_code': record['entry_code'],
        }
        record['new_value'] = {
            'contract_product_request': {
                'value': json.dumps(param['contract_product_request'])
            },
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/t_contract_request_confirmed',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def update_data_to_user_infrastructure_m_contract_product(event, param, typestr):

    logger.info('update_data_to_user_infrastructure_m_contract_product!!!')
    logger.info(param)

    res = {}
    
    try:

        record['condition_value'] = {
            'contract_id':  {
                'value': param['contract_id']
            },
            'product_id': {
                'value': param['product_id']
            },
            'use_end_date': {
                'value': None
            },
        }
        if (typestr == '1'):
            record['new_value'] = {
                'quantity': {
                    'value': param['quantity']
                },
            }
        else:
            dataS = None
            dataE = None
            if 'use_start_date' in param:
                if param['use_start_date'] is not None:
                    dataS = param['use_start_date'].strftime('%Y-%m-%d %H:%M:%S')
            if 'use_end_date' in param:
                if param['use_end_date'] is not None:
                    dataE = param['use_end_date'].strftime('%Y-%m-%d %H:%M:%S')
            if 'quantity' in param:
                record['new_value'] = {
                    'quantity': {
                        'value': param['quantity']
                    },
                    'use_start_date': {
                        'value': dataS
                    },
                    'use_end_date': {
                        'value': dataE
                    },
                }
            else:
                record['new_value'] = {
                    'use_end_date': {
                        'value': dataE
                    },
                }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_contract_product_post',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_data_from_user_infrastructure_m_contract(event, param):

    logger.info('get_data_from_user_infrastructure_m_contract!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_contract/',
            'queryStringParameters': {
                 'company_code': {
                    'value': param['company_code']
                },
                'entry_code': {
                    'value': param['entry_code']
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_data_from_user_infrastructure_m_regular_products(event, param):
    logger.info('get_data_from_user_infrastructure_m_regular_products!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_regular_products/',
            'queryStringParameters': {
                 'product_group_id': {
                    'value': param['product_group_id']
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res
    
def get_data_from_user_infrastructure_m_contract_product(event, param):

    logger.info('get_data_from_user_infrastructure_m_contract_product!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
        
        if param['product_id'] is None:
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract_product_check/',
                'queryStringParameters': {
                    'contract_id': {
                        'value': param['contract_id']
                    },
                    'use_end_date': {
                        'value': None
                    }
                }
            }
        else:
            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'GET',
                'path': '/rds/user_infrastructure/m_contract_product_check/',
                'queryStringParameters': {
                    'contract_id': {
                        'value': param['contract_id']
                    },
                    'product_id': {
                        'value': param['product_id']
                    },
                    'use_end_date': {
                        'value': None
                    }
                }
            }
            
        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def insert_data_to_user_infrastructure_m_contract_product(event,param):

    logger.info('insert_data_to_user_infrastructure_m_contract_product!!!')
    logger.info(param)
    
    res = {}

    try:

        record['condition_value'] = {
        }
        record['new_value'] = {
            'contract_id':  {
                'value': param['contract_id']
            },
            'product_id': {
                'value': param['product_id']
            },
            'quantity': {
                'value': param['quantity']
            },
            'use_start_date': {
                'value': param['use_start_date']
            },
            'use_end_date': {
                'value': param['use_end_date']
            },
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_contract_product_insert',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# ----------------------0611-------------------E

    
def get_data_file_upload(event, context):
   
    print('get_data_file_upload!!!')
    
    try:

        res = {}
        res['error_code'] = None
        res['error_message'] = None
    
    
        wavBody = event['body']
        print(wavBody)
    
        jsons = wavBody.split('\r\n')
        # ファイル名前の設定
        fileName = eval(jsons[1].split('=')[2])
    
        # 契約IDの設定
        strContract_id = jsons[-3]
    
        # Boundary
        boundary = jsons[0].replace('-', '')
        wavBody = jsons[4]
        for i in range(5, len(jsons)):
            if jsons[i].find(boundary) != -1:
                break
            else:
                wavBody = wavBody + '\r\n' + jsons[i]
                
        # rclone.confファイルのチェック
        
        local_dir = "/tmp/"
    
        # ②企業コードを記載したテキストファイル「rclone_name.txt」を作成
        with open(local_dir + '/' + fileName, 'w') as txtf:
            txtf.write(wavBody)
        txtf.close()
            
    
        Filename = local_dir + '/' + fileName
        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        Key = 'user-infrastructure/cloud_strage/' + strContract_id + '/' + fileName
        boto3.client('s3').upload_file(Filename, BUCKET_NAME, Key)
        
    except Exception as err:
        send_email_on_error(inspect.currentframe().f_code.co_name, err)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return {
        'statusCode': 200,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(res, default=str)
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }

def get_image_url(file_key,image_name):
    print('get_image_url|||')
    base_url = 'https://6e38ettii0vw.cybozu.com/k/v1/file.json?fileKey='
    url = base_url + file_key
    
    # username = 'Administrator'
    # password = 'NDESpass0'
    # credentials = username + ':' + password
    # credentials_b64 = base64.b64encode(credentials.encode()).decode()
    
    # headers = {
    #     'X-Requested-With': 'XMLHttpRequest',
    #     'Authorization': 'Basic ' + credentials_b64
    # }

    # headers = {'X-Requested-with': 'XMLHttpRequest'}
    token = '9bCAR25fvuMLtGJR0J51TP4kmoJj3xPu44qhjFyB'
    # headers = {
    #     'X-Requested-With': 'XMLHttpRequest',
    #     'Authorization': 'Bearer ' + token
    # };
    headers = {"X-Cybozu-API-Token": token}
    
    try:
        response = requests.get(url, headers=headers)
        # print("111")
        response.raise_for_status()  # 检查请求是否成功
        # print("222")
        blob = response.content  # 获取文件内容
        # print("333")
        img_url = save_blob_to_file(blob,image_name)  # 调用保存 Blob 到文件的方法
        return img_url
    except requests.exceptions.RequestException as e:
        print('Error:', e)

def save_blob_to_file(blob,str_name):
    print('save_blob_to_file|||')
    local_dir = "/tmp/data"
    str_file = os.path.join(local_dir, str(str_name))
    # 将 Blob 对象的内容写入文件
    with open(str_file, 'wb') as file:  # 将文件保存为 png 格式，可以根据实际情况修改
        file.write(blob)
    # ファイルはS3にアップする
    BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-public-001'

    s3_file = 'testimage/' + str_name
    boto3.client('s3').upload_file(str_file, BUCKET_NAME, s3_file)
    
    # 获取S3对象的公开URL
    object_url = f"https://{BUCKET_NAME}.s3.amazonaws.com/{s3_file}"
    
    # 打印对象的网址
    print("S3 Object URL:", object_url)
    
def get_s3_object_url(bucket_name, key):
    s3_client = boto3.client('s3')
    url = s3_client.generate_presigned_url(
        ClientMethod='get_object',
        Params={'Bucket': bucket_name, 'Key': key}
    )
    return url
    
def get_data_file_file_download(event, context):
   
    print('get_data_file_file_download!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
        
    try:
        event_body = {}
        event_body = json.loads(event['body'])
        
        tmp = event_body['record']
        # print(tmp)
        print("=======================")
        print(tmp["contract_id"])
        print(tmp["contract_id"]['value'])
        
        GV.ENV = event['stageVariables']['env'].upper()

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/1.zip'
        OBJECT_KEY_NAME = 'config.json'

        bucket = s3.Bucket(BUCKET_NAME)
        
        s3_folder = 'user-infrastructure/cloud_strage/'
        local_dir = "/tmp/data"
        for p in glob.glob('/tmp/' + '*'):
            if os.path.isfile(p):
                os.remove(p)
        
        print("1")
        z = zipfile.ZipFile('/tmp/new.zip','w',zipfile.ZIP_DEFLATED)
        
        for obj in bucket.objects.filter(Prefix=s3_folder):
            if 'user-infrastructure/cloud_strage/CON' not in obj.key:
                target = obj.key if local_dir is None \
                    else os.path.join(local_dir, os.path.relpath(obj.key, s3_folder))
                if not os.path.exists(os.path.dirname(target)):
                    os.makedirs(os.path.dirname(target))
                if obj.key[-1] == '/':
                    continue
                
                bucket.download_file(obj.key, target)
        print("2")
        # ②企業コードを記載したテキストファイル「rclone_name.txt」を作成
        with open(local_dir + '/rclone_name.txt', 'w') as txtf:
            txtf.write(str(tmp["contract_id"]['value']))
            # txtf.write('contract_id = ')
        txtf.close()
        
            
        for dirpath, dirnames, filenames in os.walk(local_dir):
            fpath = dirpath.replace(local_dir,'') 
            fpath = fpath and fpath + os.sep or ''
            for filename in filenames:
                z.write(os.path.join(dirpath, filename),fpath+filename)
                # print ('OK')
        z.close()
        # POST = 8886
        zip_path = '/tmp/new.zip'
        
        # ファイルはS3にアップする
        compressed_file_key = 'user-infrastructure/rclone_config_program_back/rclone.zip'
        boto3.client('s3').upload_file(zip_path, BUCKET_NAME, compressed_file_key)
    
        # URL作成
        expiration_time = 60  # URL利用時間
        presigned_url = boto3.client('s3').generate_presigned_url('get_object',
            Params={'Bucket': BUCKET_NAME, 'Key': compressed_file_key},
            ExpiresIn=expiration_time
        )

        return {
            "statusCode": 200,
            "headers": RESPONSE_HEADERS,
            "body": presigned_url,
            "isBase64Encoded": True,
        }

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    finally:
        print('get_data_file_file_download!!!')
        print('-----------------------------------------------------E')

def get_data_from_user_infrastructure_t_manage_request_contract(event, context, strService_id, strSystem_id):

    logger.info('get_data_from_user_infrastructure_t_manage_request_contract!!!')

    res = {}

    try:
        if "administrator_email_old" in record and "value" in record["administrator_email_old"]:
            record["auth0_user_id"]["value"] = \
                record["administrator_email_old"]["value"]
                
        event_body = {}
        if 'body' in event and event['body'] is not None:
            event_body = json.loads(event['body'])
            logger.info(event_body)

            tmp = event_body['record']
            if "auth0_user_id" in tmp and "value" in tmp["auth0_user_id"]:
                record["auth0_user_id"]["value"] = tmp["auth0_user_id"]["value"]
            if "service_id" in tmp and "value" in tmp["service_id"]:
                record["service_id"]["value"] = tmp["service_id"]["value"]
            if "system_id" in tmp and "value" in tmp["system_id"]:
                record["system_id"]["value"] = tmp["system_id"]["value"]

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
            auth0_user_id = None
            if 'auth0_user_id' in query_string_parameters:
                if type(query_string_parameters['auth0_user_id']) is str:
                    tmp = json.loads(query_string_parameters['auth0_user_id'])
                    if 'value' in tmp:
                        auth0_user_id = tmp['value']
                else:
                    if 'value' in query_string_parameters['auth0_user_id']:
                        auth0_user_id = query_string_parameters['auth0_user_id']['value']
                        
            if auth0_user_id is not None:
                record["auth0_user_id"]["value"] = auth0_user_id
                
            company_code = None
            if 'company_code' in query_string_parameters:
                if type(query_string_parameters['company_code']) is str:
                    tmp = json.loads(query_string_parameters['company_code'])
                    if 'value' in tmp:
                        company_code = tmp['value']
                else:
                    if 'value' in query_string_parameters['company_code']:
                        company_code = query_string_parameters['company_code']['value']
                        
            if company_code is not None:
                record["company_code"]["value"] = company_code
                
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_manage_request_contract',
            'queryStringParameters': {
                'auth0_user_id': {
                    'value': record["auth0_user_id"]["value"]
                },
                'service_id': {
                    'value': strService_id
                },
                'system_id': {
                    'value': strSystem_id
                },
                'company_code': {
                    'value': record["company_code"]["value"]
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res
  
def get_data_from_user_infrastructure_t_manage_request_workshop(event, context, strService_id, strSystem_id):

    logger.info('get_data_from_user_infrastructure_t_manage_request_workshop!!!')

    res = {}

    try:
        if "administrator_email_old" in record and "value" in record["administrator_email_old"]:
            record["auth0_user_id"]["value"] = \
                record["administrator_email_old"]["value"]
                
        event_body = {}
        if 'body' in event and event['body'] is not None:
            event_body = json.loads(event['body'])
            logger.info(event_body)

            tmp = event_body['record']
            if "auth0_user_id" in tmp and "value" in tmp["auth0_user_id"]:
                record["auth0_user_id"]["value"] = tmp["auth0_user_id"]["value"]
            if "service_id" in tmp and "value" in tmp["service_id"]:
                record["service_id"]["value"] = tmp["service_id"]["value"]
            if "system_id" in tmp and "value" in tmp["system_id"]:
                record["system_id"]["value"] = tmp["system_id"]["value"]

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
            auth0_user_id = None
            if 'auth0_user_id' in query_string_parameters:
                if type(query_string_parameters['auth0_user_id']) is str:
                    tmp = json.loads(query_string_parameters['auth0_user_id'])
                    if 'value' in tmp:
                        auth0_user_id = tmp['value']
                else:
                    if 'value' in query_string_parameters['auth0_user_id']:
                        auth0_user_id = query_string_parameters['auth0_user_id']['value']
                        
            if auth0_user_id is not None:
                record["auth0_user_id"]["value"] = auth0_user_id
                
            company_code = None
            if 'company_code' in query_string_parameters:
                if type(query_string_parameters['company_code']) is str:
                    tmp = json.loads(query_string_parameters['company_code'])
                    if 'value' in tmp:
                        company_code = tmp['value']
                else:
                    if 'value' in query_string_parameters['company_code']:
                        company_code = query_string_parameters['company_code']['value']
                        
            if company_code is not None:
                record["company_code"]["value"] = company_code
                
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/t_manage_request_workshop',
            'queryStringParameters': {
                'auth0_user_id': {
                    'value': record["auth0_user_id"]["value"]
                },
                'service_id': {
                    'value': strService_id
                },
                'system_id': {
                    'value': strSystem_id
                },
                'company_code': {
                    'value': record["company_code"]["value"]
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# 
def get_data_service_id_system_id(event, context):

    logger.info('get_data_service_id_system_id!!!')
    
    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        serviceId = ''
        strService_name = ''
        strSystem_name = ''
        tmp = {}
    
        if 'serviceId' in query_string_parameters:
            if type(query_string_parameters['serviceId']) is str:
                tmp = json.loads(query_string_parameters['serviceId'])
                if 'value' in tmp:
                    serviceId = tmp['value']
            else:
                if 'value' in query_string_parameters['serviceId']:
                    serviceId = query_string_parameters['serviceId']['value']
        if (serviceId == ''):
            serviceId = record["serviceId"]['value']
        # logger.info(serviceId)
        strService_name = GV.CONFIG_SYSTEM_SERVICE[serviceId]['service_name']
        strSystem_name = GV.CONFIG_SYSTEM_SERVICE[serviceId]['system_name']
        # logger.info(strService_name)
        # logger.info(strSystem_name)
            
        
    
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/service_id_system_id_SQL',
            'queryStringParameters': {
                'service_name': {
                    'value': strService_name
                },
                'system_name': {
                    'value': strSystem_name
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:
    
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_data_ec2id(event, strCompany_code):

    logger.info('get_data_ec2id!!!')
    
    res = {}

    try:
        serviceId = ''
        strService_name = ''
        strSystem_name = ''
        tmp = {}
        
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/mscone_lic/bridge_instance_id_SQL',
            'queryStringParameters': {
                'company_code': {
                    'value': strCompany_code
                },
            }
        }
        
        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:
    
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload
    
        

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# def get_data_ec2id(event, strCompany_code):

#     logger.info('get_data_ec2id!!!')
    
#     res = {}

#     try:

#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'GET',
#             'path': '/rds/mscone_lic/bridge_instance_id_SQL',
#             'queryStringParameters': {
#                 'company_code': {
#                     'value': strCompany_code
#                 },
#         }

#         # Payload = json.dumps(input_event)
#         # print("---01: Payload:", Payload)

#         # # 呼び出し
#         # response = boto3.client('lambda').invoke(
#         #     FunctionName='evo-lam-sys-rds',
#         #     InvocationType='RequestResponse',
#         #     Payload=Payload
#         # )
#         # print("---02: response:", response)

#         # res = response

#         # result = None
#         # if 'StatusCode' in response and response['StatusCode'] == 200:
    
#         #     # レスポンス読出し
#         #     Payload = json.loads(response['Payload'].read())
#         #     print("---03: body:", Payload)
#         #     res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# t_entry E
# ------------------------------------

# ------------------------------------
# m_company S

def update_m_company():

    logger.info('update_m_company!!!')

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_company',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# データの更新(GMO掛け払い)	
# GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う。
# 企業情報管理アプリの「GMO掛け払いのデータ更新あり」にチェックが入っている(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerがTrue)の企業のみを対象にする。
# 処理が正常終了した場合、RDSの「GMO掛け払いのデータ更新あり」をfalseにする。(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)
# 処理結果を営業ML、サポートMLにメールで通知する。
# 以下の情報が変更されている場合、GMO掛け払いで枠保証の再審査が発生する。同月中に2回目の審査をした、もしくは審査中(月跨ぎで)だった場合にエラーが出る。
# ・会社名
# ・代表者姓名
# ・代表者の生年月日
# ・契約者の郵便番号
# ・契約者の住所
# ・契約者の電話番号
# ・契約者のメールアドレス"
def need_gmo_ps_creditfacility_modifybuyer(event, context):
   
    print('GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う') 
    
    print('-----------------------------------------------------S')
    print('need_gmo_ps_creditfacility_modifybuyer!!!')
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
        
    try:
        ok_company_code = {}
        ng_company_code = {}
        
        print('GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う')
        print('実施開始日時：' + dt.now().strftime('%Y-%m-%d %H:%M:%S'))
        print('-----------------------------------------------------S')
        
        print('「GMO掛け払いのデータ更新あり」にチェックが入っている(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerがTrue)の企業のみ取得')
        
        print('企業情報取得')
        res_m_company = get_m_company_need_gmo_ps_creditfacility_modifybuyer(event, context)
        print(res_m_company)
        if 'statusCode' in res_m_company and (res_m_company['statusCode'] == 400 or res_m_company['statusCode'] == 500):
            # return res_m_company
            print('失敗 企業情報取得')
            print('GMO掛け払いで枠保証の再審査：エラー' + ' 企業情報取得')
            
        body_m_company = json.loads(res_m_company['body'])
        for company_data in body_m_company['result']:
            print(company_data)
            
            for k in company_data:
                if company_data[k] is None:
                    company_data[k] = ''
                    
            print('----------------------------------------')
            
            company_code = company_data['company_code']
            
            print('企業コード：' + company_data['company_code'])
            print('企業名：' + company_data['company_name'])
             
            ng_company_code[company_code] = ''
        
            print('契約情報取得')
            res_m_contract = get_m_contract_company_code(event, context, company_data)
            print(res_m_contract)
            
            if 'statusCode' in res_m_contract and (res_m_contract['statusCode'] == 400 or res_m_contract['statusCode'] == 500):

                # return res_m_contract
                ng_company_code[company_code] = '失敗 契約情報取得'
                print('失敗 契約情報取得')
                print('GMO掛け払いで枠保証の再審査：エラー' + ' 契約情報取得')
                continue
            
            body_m_contract = json.loads(res_m_contract['body'])
            contract_data = body_m_contract['result'][0]
            for k in contract_data:
                if contract_data[k] is None:
                    contract_data[k] = ''
                    
            print('申込情報取得')
            # res_t_entry = get_t_entry_entry_code(event, context, company_data)
            res_t_entry = get_t_manage_request_entry_code(event, context, company_data)
            print(res_t_entry)

            if 'statusCode' in res_t_entry and (res_t_entry['statusCode'] == 400 or res_t_entry['statusCode'] == 500):

                # return res_t_entry
                ng_company_code[company_code] = '失敗 申込情報取得'
                print('失敗 申込情報取得')
                print('GMO掛け払いで枠保証の再審査：エラー' + ' 申込情報取得')
                continue
            
            body_t_entry = json.loads(res_t_entry['body'])
            entry_data = body_t_entry['result'][0]
            
            record["service_id"] = entry_data["service_id"] 
            
            print('サービス情報取得')
            res_m_service = get_m_service(event, context, entry_data)
            print(res_m_service)

            # バグ #2818--------------------------------------S
            # if 'statusCode' in res_m_service and (res_m_service['statusCode'] == 400 or res_m_service['statusCode'] == 500):
            if 'statusCode' in res_m_service and (res_m_service['statusCode'] == 400 or res_m_service['statusCode'] == 500 or res_m_service['statusCode'] == 503):
            # バグ #2818--------------------------------------E
                # return res_m_service
                ng_company_code[company_code] = '失敗 サービス情報取得'
                print('失敗 サービス情報取得')
                print('GMO掛け払いで枠保証の再審査：エラー' + ' サービス情報取得')
                continue
            
            body_m_service = json.loads(res_m_service['body'])
            service_data = body_m_service['result'][0]
            
            print('GMO掛け払いで枠保証の再審査実施')
            # 申請する
            apply = 1
            # 
            address = contract_data["contract_address_pref"] + contract_data["contract_address_1"] + contract_data["contract_address_2"]
            company_leader_date_of_birth = dt.strptime(company_data["company_leader_date_of_birth"], '%Y-%m-%d %H:%M:%S').strftime('%Y/%m/%d')
            data = {
                'targetBuyer': {
                    'shopCustomerId': company_data["company_code"]
                },
                'buyer': {
                    'buyerNameFamily': contract_data["contract_name"].split(" ")[0],
                    'buyerName': contract_data["contract_name"].split(" ")[1],
                    'buyerNameFamilyKana': contract_data["contract_name_kana"].split(" ")[0],
                    'buyerNameKana': contract_data["contract_name_kana"].split(" ")[1],
                    'zipCode': contract_data["contract_zipcode"],
                    'address': address,
                    'companyName': company_data["company_name"],
                    'departmentName': contract_data["contract_department"],
                    'tel1': contract_data["contract_tel_1"],
                    'email1': contract_data["contract_email"],
                    'presidentNameFamily': company_data["company_leader_last"],
                    'presidentName': company_data["company_leader_first"],
                    'presidentNameFamilyKana': company_data["company_leader_kana_last"],
                    'presidentNameKana': company_data["company_leader_kana_first"],
                    'birthday': company_leader_date_of_birth,
                    'shopCustomerId': company_data["company_code"]
                },
                'creditFacility': {
                    'apply': apply,
                    'reqUpperLimit': service_data["gmo_ps_req_upper_limit"]
                }
            }

            result = gmo_creditfacility_modifybuyer(event, context, data)
            print(result)

            # if company_data['company_code'] == 'K01100':
            #     pass
            # else:
            # バグ #2818--------------------------------------S
            # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500 or result['statusCode'] == 503):
            # バグ #2818--------------------------------------E
                # return result
                result_body = json.loads(result['body'])
                err_msg = ''
                # バグ #2818 ------------------------S
                # [GMO掛け払いの購入企業情報編集] 月末の定期実行時に処理結果のメールが送信されない
                # for e in result_body['errors']:
                #     err_msg += 'errCode:' + e['errCode'] + '\n'
                #     err_msg += 'errorMessage:' + e['errorMessage'] + '\n'
                if 'errors' in result_body:
                    for e in result_body['errors']:
                        if 'errCode' in e:
                            if e['errCode'] is None:
                                e['errCode'] = ''
                            err_msg += 'errCode:' + e['errCode'] + '\n'
                        if 'errorMessage' in e:
                            if e['errorMessage'] is None:
                                e['errorMessage'] = ''
                            err_msg += 'errorMessage:' + e['errorMessage'] + '\n'
                if 'error_code' in result_body:
                    if result_body['error_code'] is None:
                        result_body['error_code'] = ''
                    err_msg += 'error_code:' + result_body['error_code'] + '\n'
                if 'error_message' in result_body:
                    if result_body['error_message'] is None:
                        result_body['error_message'] = ''
                    err_msg += 'error_message:' + result_body['error_message'] + '\n'
                # バグ #2818 ------------------------E
                ng_company_code[company_code] = err_msg
                print('失敗 GMO掛け払いで枠保証の再審査実施')
                print('GMO掛け払いで枠保証の再審査：失敗'+ '\n')
                continue
                # pass
            
            print('「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)')
            
            param = {}
            param['company_code'] = company_data['company_code']
            param['need_gmo_ps_creditfacility_modifybuyer'] = False
            
            result = update_m_company_need_gmo_ps_creditfacility_modifybuyer(event, context, param)
            
            # バグ #2818--------------------------------------S
            # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500 or result['statusCode'] == 503):
            # バグ #2818--------------------------------------E
                # return result
                ng_company_code[company_code] = '失敗 RDS「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)'
                print('失敗 RDS「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)')
                print('GMO掛け払いで枠保証の再審査：エラー' + ' RDS「GMO掛け払いのデータ更新あり」にチェックを外す')
                continue
            
            result = update_kintone_company_info_need_gmo_ps_creditfacility_modifybuyer(event, context, param)
            
            # バグ #2818--------------------------------------S
            # if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
            if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500 or result['statusCode'] == 503):    
            # バグ #2818--------------------------------------E
                # return result
                ng_company_code[company_code] = '失敗 Kintone「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)'
                print('失敗 Kintone「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)')
                print('GMO掛け払いで枠保証の再審査：エラー' + ' Kintone「GMO掛け払いのデータ更新あり」にチェックを外す')
                continue
            
            if ng_company_code[company_code] == '':
                del ng_company_code[company_code]
                
            ok_company_code[company_code] = 'GMO掛け払いで枠保証の再審査：成功'
            print('GMO掛け払いで枠保証の再審査：成功'+ '\n')
        
        print('-----------------------------------------------------E')
        print('実施終了日時：' + dt.now().strftime('%Y-%m-%d %H:%M:%S'))
        
        # 結果
        if len(body_m_company['result']) == 0:
            print('処理対象データがありません。')
            
        print('正常終了した企業：')
        for k, v in ok_company_code.items(): 
            print(k)
            
        print('処理中にエラーが出た企業：') 
        for k, v in ng_company_code.items(): 
            print(k + ':' + '\n' + v)
               
        # ??? メールテンプレート未定
        # 処理結果を営業ML、サポートMLにメールで通知する。
        send_email_data_need_gmo_ps_creditfacility_modifybuyer(event, context, ok_company_code, ng_company_code)
   
        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            # 'body': json.dumps(res, default=str)
            'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
        }
    
    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)
    finally:
        print('need_gmo_ps_creditfacility_modifybuyer!!!')
        print('-----------------------------------------------------E')


def post_data_to_payment_creditfacility_modifybuyer(event, context, service_data, company_data, contract_data):
    
    print("post_data_to_payment_creditfacility_modifybuyer!!!");

    # 申請する
    apply = 1
    # 
    address = contract_data["contract_address_pref"] + contract_data["contract_address_1"] + contract_data["contract_address_2"]
    
    data = {
        'targetBuyer': {
            'shopCustomerId': company_data["company_code"]
        },
        'buyer': {
            'buyerNameFamily': contract_data["contract_name"].split(" ")[0],
            'buyerName': contract_data["contract_name"].split(" ")[1],
            'buyerNameFamilyKana': contract_data["contract_name_kana"].split(" ")[0],
            'buyerNameKana': contract_data["contract_name_kana"].split(" ")[1],
            'zipCode': contract_data["contract_zipcode"],
            'address': address,
            'companyName': company_data["company_name"],
            'departmentName': contract_data["contract_department"],
            'tel1': contract_data["contract_tel_1"],
            'email1': contract_data["contract_email"],
            'presidentNameFamily': company_data["company_leader_last"],
            'presidentName': company_data["company_leader_first"],
            'presidentNameFamilyKana': company_data["company_leader_kana_last"],
            'presidentNameKana': company_data["company_leader_kana_first"],
            'birthday': company_data["company_leader_date_of_birth"],
            'shopCustomerId': company_data["company_code"]
        },
        'creditFacility': {
            'apply': apply,
            'reqUpperLimit': service_data["gmo_ps_req_upper_limit"]
        }
    }

    gmo_creditfacility_modifybuyer(event, context, data)
    
# 
def get_m_service(event, context, param):

    logger.info('get_m_service!!!')

    res = {}

    try:
                       
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/billing_infrastructure/m_services',
            'queryStringParameters': {
                'service_id': {
                    'value': param["service_id"]
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def get_m_company_need_gmo_ps_creditfacility_modifybuyer(event, context):

    logger.info('get_m_company_need_gmo_ps_creditfacility_modifybuyer!!!')

    res = {}

    try:
        
        record = {}
        
        record["need_gmo_ps_creditfacility_modifybuyer"] = {}
        record["need_gmo_ps_creditfacility_modifybuyer"]["value"] = True
               
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_company',
            'queryStringParameters': {
                'need_gmo_ps_creditfacility_modifybuyer': {
                    'value': record["need_gmo_ps_creditfacility_modifybuyer"]["value"]
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def update_m_company_need_gmo_ps_creditfacility_modifybuyer(event, context, param):

    logger.info('update_m_company_need_gmo_ps_creditfacility_modifybuyer!!!')

    res = {}

    try:

        record = {}
        
        record['condition_value'] = {
            'company_code': {
                'value': param['company_code']
            }
        }
        
        record['new_value'] = {
            'need_gmo_ps_creditfacility_modifybuyer': {
                'value': param['need_gmo_ps_creditfacility_modifybuyer']
            }
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'PUT',
            'path': '/rds/user_infrastructure/m_company',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# m_company E
# ------------------------------------

# ------------------------------------
# m_contract S

def get_m_contract_company_code(event, context, param):

    logger.info('get_m_contract_company_code!!!')

    res = {}

    try:
              
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_contract',
            'queryStringParameters': {
                'company_code': {
                    'value': param["company_code"]
                }
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def update_m_contract():

    logger.info('update_m_contract!!!')

    res = {}

    try:

        record_m_contract = {}

        record_m_contract["invoice_sending_method"] = {}
        # 請求書の送付方法
        if record["invoice_sending_method"]["value"] == 1:
            record_m_contract["invoice_sending_method"]["value"] = 1
        elif record["invoice_sending_method"]["value"] == 0:
            record_m_contract["invoice_sending_method"]["value"] = 0
        else:
            record_m_contract["invoice_sending_method"]["value"] = 0

        # 契約ID
        record_m_contract['contract_id'] = record["contract_id"]
        # 顧客ID
        record_m_contract['company_code'] = record["company_code"]
        # 契約名
        record_m_contract["subscription_name"] = {}
        # record_m_contract["subscription_name"]["value"] = record["system_name"]["value"] + \
        #     record["service_name"]["value"]
        record_m_contract["subscription_name"]["value"] = record["service_name"]["value"]
        # 契約者名
        # record_m_contract["contract_name"] = {}
        # record_m_contract["contract_name"]["value"] = record["contract_name_last"]["value"] + \
        #     " " + record["contract_name_first"]["value"]
        # 契約者名(姓)
        record_m_contract['contract_last_name'] = record["contract_last_name"]
        # 契約者名(名)
        record_m_contract['contract_first_name'] = record["contract_first_name"]
        # # 契約者名カナ
        # record_m_contract["contract_name_kana"] = {}
        # record_m_contract["contract_name_kana"]["value"] = record["contract_name_last_kana"]["value"] + \
        #     " " + record["contract_name_first_kana"]["value"]
        # 契約者名カナ(姓)
        record_m_contract['contract_last_name_kana'] = record["contract_last_name_kana"]
        # 契約者名カナ(名)
        record_m_contract['contract_first_name_kana'] = record["contract_first_name_kana"]
        
        # 契約開始日
        record_m_contract['subscription_start_date'] = record["subscription_start_date"]
        # 契約終了日
        record_m_contract['subscription_end_date'] = record["subscription_end_date"]
        # 送付先名
        record_m_contract["postal_address"] = {}
        record_m_contract["postal_address"]["value"] = record["company_name"]["value"] + "" + record["contract_department"]["value"] + \
            "" + record["contract_last_name"]["value"] + \
            "" + record["contract_first_name"]["value"]
        # 郵便番号
        record_m_contract["contract_zipcode"] = {}
        record_m_contract["contract_zipcode"]["value"] = record["contract_zipcode"]["value"].replace(
            "-", "")
        # 都道府県
        record_m_contract['contract_address_pref'] = record["contract_address_pref"]
        # # 住所１
        # record_m_contract["contract_address_1"] = {}
        # record_m_contract["contract_address_1"]["value"] = record["contract_address_1"]["value"] + \
        #     record["contract_address_2"]["value"]
        # # 住所２
        # record_m_contract['contract_address_2'] = record["contract_address_3"]
        # 住所１
        record_m_contract["contract_address_1"] = {}
        record_m_contract["contract_address_1"]["value"] = record["contract_address_1"]["value"]
        # 住所２
        record_m_contract["contract_address_2"] = {}
        record_m_contract["contract_address_2"]["value"] = record["contract_address_2"]["value"]
        # 住所３
        record_m_contract["contract_address_3"] = {}
        record_m_contract["contract_address_3"]["value"] = record["contract_address_3"]["value"]
        # 電話番号
        record_m_contract['contract_tel_1'] = record["contract_tel_1"]
        # メールアドレス
        record_m_contract['contract_email'] = record["contract_email"]
        # 部署名
        record_m_contract['contract_department'] = record["contract_department"]
        # 担当営業名
        record_m_contract['salesman_name'] = record["salesman_name"]
        # テキ05
        # 役職(顧客)
        record_m_contract['contract_position'] = record["contract_position"]
        # テキ08
        # 請求方法※1
        record_m_contract['payment_method'] = record["payment_method"]
        # テキ09
        # 担当営業(職番)
        record_m_contract['salesman_code'] = record["salesman_code"]
        # 備考
        record_m_contract['subscription_notes'] = record["subscription_notes"]
        
        # 利用料金上限設定フラグ   2023/12/13
        record_m_contract['amount_upper_limit_flg'] = record["amount_upper_limit_flg"]
        # 利用料金上限金額   2023/12/13
        record_m_contract['amount_upper_limit'] = record["amount_upper_limit"]
        # 利用中止フラグ   2023/12/13
        record_m_contract['amount_upper_limit_stop_flg'] = record["amount_upper_limit_stop_flg"]
        
        # 請求書の送付方法
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_contract',
            'body': json.dumps(
                {
                    'record': record_m_contract
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# m_cloud_strage S
def update_m_cloud_strage(dataItem,recordItem):

    logger.info('update_m_cloud_strage!!!')

    res = {}

    try:

        record_m_cloud_strage = {}
        print("dataItem")
        print(dataItem)

        # クラウドストレージID
        # record_m_cloud_strage['cloud_strage_id'] = dataItem["cloud_strage_id"]
        # 契約ID
        record_m_cloud_strage['contract_id'] = dataItem["contract_id"]
        # クラウドストレージドメイン
        record_m_cloud_strage['cloud_strage_domain'] = dataItem["cloud_strage_domain"]
        # ユーザ名
        record_m_cloud_strage['user_name'] = dataItem["user_name"]
        # パスワード
        record_m_cloud_strage['password'] = dataItem["password"]
        # ソルト
        # record_m_cloud_strage['salt']= dataItem['salt']
        # # 初期ベクトル
        # record_m_cloud_strage['iv'] = dataItem['iv']
        # フォルダID
        record_m_cloud_strage['folder_id'] = dataItem["folder_id"]
        # 有効化フラグ
        record_m_cloud_strage['enable_flg'] = dataItem["enable_flg"]
        # クラウドストレージ種類
        record_m_cloud_strage['cloud_strage_type'] = dataItem["cloud_strage_type"]
        # システム構成タイプ
        record_m_cloud_strage['system_configuration_type'] = recordItem['system_configuration_type']
        
        print(record_m_cloud_strage)
        # 請求書の送付方法
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_cloud_strage',
            'body': json.dumps(
                {
                    'record': record_m_cloud_strage
                }
            )
        }
        
        print("record_m_cloud_strage")
        print(record_m_cloud_strage)

        Payload = json.dumps(input_event)
        print("確認............................")
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def editDateCloudStrageCheck(event, context, editItem):

    logger.info('editDateCloudStrageCheck!!!')

    res = {}

    try:
    
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
            
        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_cloud_strage_check',
            'queryStringParameters': {
                 'contract_id': {
                    'value': editItem['contract_id']['value']
                },
                'cloud_strage_type': {
                    'value': editItem['cloud_strage_type']['value']
                },
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res
    
# m_cloud_strage E
# ------------------------------------

# ------------------------------------
# user_infrastructure m_user S

def update_user_infrastructure_m_user():

    logger.info('update_user_infrastructure_m_user!!!')

    res = {}

    try:

        # Auth0ユーザーID
        # record["auth0_user_id"] = record["auth0_user_id"],
        record["auth0_user_id"]["value"] = record["administrator_email"]["value"]
        # # 企業コード
        # record["company_code"] = record["company_code"],
        # システム管理者 （姓）
        record["name_last"] = record["administrator_name_last"]
        # システム管理者 （名）
        record["name_first"] = record["administrator_name_first"]
        # システム管理者 （姓）（カナ）
        record["name_last_kana"] = record["administrator_name_last_kana"]
        # システム管理者 （名）（カナ）
        record["name_first_kana"] = record["administrator_name_first_kana"]
        # システム管理者所属部署
        record["department"] = record["administrator_department"]
        # システム管理者役職
        record["position"] = record["administrator_position"]
        # システム管理者メールアドレス
        record["email"] = record["administrator_email"]
        # システム管理者電話番号(ハイフンなし)
        record["tel"] = record["administrator_tel_1"]
        # # 招待コード
        # record["invitation_code"] = record["invitation_code"]
        # # 招待日
        # record["invitation_date"] = record["invitation_date"]

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_user',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def delete_data_from_user_infrastructure_m_user(event, context):

    logger.info('delete_data_from_user_infrastructure_m_user!!!')

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'DELETE',
            'path': '/rds/user_infrastructure/m_user',
            'queryStringParameters': {
                'email': record["administrator_email_old"]["value"],
                'company_code': record["company_code"]["value"],
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# user_infrastructure m_user E
# ------------------------------------

# ------------------------------------
# kintone company_info S

# def update_kintone_company_info(event, context):

#     logger.info('update_kintone_company_info!!!')

#     res = {}

#     try:

#         record["auth0_user_id"]["value"] = record["administrator_email"]["value"]
        
#         if record['need_gmo_ps_creditfacility_modifybuyer']['value'] == True:
#             del record['need_gmo_ps_creditfacility_modifybuyer']
#             record['need_gmo_ps_creditfacility_modifybuyer'] = {'value':''}
#             record['need_gmo_ps_creditfacility_modifybuyer']['value'] = ["GMO掛け払いのデータ更新あり"]
#         else:
#             del record['need_gmo_ps_creditfacility_modifybuyer']
#             record['need_gmo_ps_creditfacility_modifybuyer'] = {'value':''}
#             record['need_gmo_ps_creditfacility_modifybuyer']['value'] = []
            
#         # バグ #2823 ------------------------S
#         # [PT-RT][申込内容修正サイト] システム管理者の情報を変更すると招待コードと招待日が削除される
#         # invitation_codeとinvitation_dateが空の場合更新しないようにする必要がある
#         if 'invitation_code' in record:
#             if 'value' in record['invitation_code']:
#                 if record['invitation_code']['value']:
#                     pass
#                 else:
#                     del record['invitation_code']
#             else:
#                 del record['invitation_code']
#         if 'invitation_date' in record:
#             if 'value' in record['invitation_date']:
#                 if record['invitation_date']['value']:
#                     pass
#                 else:
#                     del record['invitation_date']
#             else:
#                 del record['invitation_date']
#         # バグ #2823 ------------------------E

#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'POST',
#             'path': '/kintone/company_info',
#             'body': json.dumps(
#                 {
#                     'record': record
#                 }
#             )
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             FunctionName='lam-sys-kintone',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# def update_kintone_company_info_need_gmo_ps_creditfacility_modifybuyer(event, context, param):

#     logger.info('update_kintone_company_info_need_gmo_ps_creditfacility_modifybuyer!!!')

#     res = {}

#     try:

#         record = {}
        
#         record['condition_value'] = {
#             'company_code': {
#                 'value': param['company_code']
#             }
#         }
        
#         record['new_value'] = {}
#         if param['need_gmo_ps_creditfacility_modifybuyer'] == True:
#             record['new_value']['need_gmo_ps_creditfacility_modifybuyer'] = {'value':''}
#             record['new_value']['need_gmo_ps_creditfacility_modifybuyer']['value'] = ["GMO掛け払いのデータ更新あり"]
#         else:
#             record['new_value']['need_gmo_ps_creditfacility_modifybuyer'] = {'value':''}
#             record['new_value']['need_gmo_ps_creditfacility_modifybuyer']['value'] = []

#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'PUT',
#             'path': '/kintone/company_info',
#             'body': json.dumps(
#                 {
#                     'record': record
#                 }
#             )
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             FunctionName='lam-sys-kintone',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# kintone company_info E
# ------------------------------------

# ------------------------------------
# auth0 S

# administrator_email contract_email
def get_auth0_users_by_email(event, context, type):

    logger.info('get_auth0_users_by_email!!!')

    res = {}

    try:
        strEmail = ""
        if type == "administrator":
            strEmail = record["administrator_email"]["value"]
        if type == "contract":
            strEmail = record["contract_email"]["value"]

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/auth0/get_users_by_email',
            'queryStringParameters': {
                'email': strEmail,
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-auth0',
            FunctionName='prod-lam-sys-auth0',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

def create_auth0_user(event, context, type):

    logger.info('create_auth0_user!!!')

    res = {}

    try:
        
        strEmail = ""
        strgiven_name = ""
        strfamily_name = ""
        if type == "administrator":
            strEmail = record["administrator_email"]["value"]
            strgiven_name = record["administrator_name_first"]["value"]
            strfamily_name = record["administrator_name_last"]["value"]
        if type == "contract":
            strEmail = record["contract_email"]["value"]
            strgiven_name = record["contract_first_name"]["value"]
            strfamily_name = record["contract_last_name"]["value"]

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/auth0',
            'body': json.dumps(
                {
                    'email': strEmail,
                    'blocked': False,
                    'connection': 'Username-Password-Authentication',
                    'given_name': strgiven_name,
                    'family_name': strfamily_name,
                    'password': 'P@ssw0rd',
                    'verify_email': False,
                    'username': record["company_code"]["value"] + "_" + strEmail.split("@")[0],
                    'company_code': record["company_code"]["value"],
                    'user_metadata': {}
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-auth0',
            FunctionName='prod-lam-sys-auth0',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


def update_auth0_user_info(event, context, type):

    logger.info('update_auth0_user_info!!!')

    res = {}

    try:
        
        strEmail = ""
        strgiven_name = ""
        strfamily_name = ""
        if type == "administrator":
            strEmail = record["administrator_email"]["value"]
            strgiven_name = record["administrator_name_first"]["value"]
            strfamily_name = record["administrator_name_last"]["value"]
        if type == "contract":
            strEmail = record["contract_email"]["value"]
            strgiven_name = record["contract_first_name"]["value"]
            strfamily_name = record["contract_last_name"]["value"]

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'PUT',
            'path': '/auth0',
            'body': json.dumps(
                {
                    'company_code': record["company_code"]["value"],
                    'auth0_user_id': strEmail,
                    'email': strEmail,
                    'given_name': strgiven_name,
                    'family_name': strfamily_name,
                    'user_metadata': {}
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-auth0',
            FunctionName='prod-lam-sys-auth0',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


def block_auth0_user_old(event, context):

    logger.info('block_auth0_user_old!!!')

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/auth0/change_user_block_status',
            'body': json.dumps(
                {
                    'auth0_user_id': record["administrator_email_old"]["value"],
                    'blocked': True,
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-auth0',
            FunctionName='prod-lam-sys-auth0',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# def remove_roles_from_a_user(event, context, type):

#     logger.info('remove_roles_from_a_user!!!')

#     res = {}

#     try:
        
#         strEmail = ""
#         if type == "administrator":
#             strEmail = record["administrator_email"]["value"]
#         if type == "contract":
#             strEmail = record["contract_email"]["value"]

#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'POST',
#             'path': '/auth0/remove_roles_from_a_user',
#             'body': json.dumps(
#                 {
#                     'user_id': strEmail,
#                     'remove_role_ids': [GV.CONFIG['AUTH0_ROLE_IDS']['ROLES_MEMBER']],
#                 }
#             )
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             # FunctionName='lam-sys-auth0',
#             FunctionName='evo-lam-sys-auth0',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# def assign_roles_to_a_auth0_user(event, context, type):

#     logger.info('assign_roles_to_a_auth0_user!!!')

#     res = {}

#     try:
#         strEmail = ""
#         if type == "administrator":
#             strEmail = record["administrator_email"]["value"]
#         if type == "contract":
#             strEmail = record["contract_email"]["value"]

#         input_event = {
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'POST',
#             'path': '/auth0/assign_roles_to_a_user',
#             'body': json.dumps(
#                 {
#                     'user_id': strEmail,
#                     'assign_role_ids': [GV.CONFIG['AUTH0_ROLE_IDS']['ROLES_MEMBER_ADMINISTRATOR'], GV.CONFIG['AUTH0_ROLE_IDS']['ROLES_COMMON_PF_SITE_AVAILABLE_USER']],
#                 }
#             )
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             # FunctionName='lam-sys-auth0',
#             FunctionName='lam-sys-auth0-phase5-test',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# phase3 change_admin_user
def change_admin_user(event, context, params):

    logger.info('change_admin_user!!!')

    res = {}

    try:

        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
            query_string_parameters = event['queryStringParameters']
            logger.info(query_string_parameters)
    
        serviceId = ''
    
        if 'serviceId' in query_string_parameters:
            if type(query_string_parameters['serviceId']) is str:
                tmp = json.loads(query_string_parameters['serviceId'])
                if 'value' in tmp:
                    serviceId = tmp['value']
            else:
                if 'value' in query_string_parameters['serviceId']:
                    serviceId = query_string_parameters['serviceId']['value']
        if (serviceId == ''):
            serviceId = record["serviceId"]['value']

        data = {
            "func": "change_admin_user",
            "data": {
                "company_code": params['company_code'],
                "old_email_address": params['administrator_email_old'],
                "new_email_address": params['administrator_email'],
                'administrator_name_last': params["administrator_name_last"],
                'administrator_name_first': params["administrator_name_first"],
                'company_name': params["company_name"],
                'entry_code': params["entry_code"]
            }
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/api/' + serviceId + '/account',
            'body': json.dumps(data)
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        # response = boto3.client('lambda').invoke(
        response = boto3.client('lambda',config=boto3.session.Config(connect_timeout=60, read_timeout=300)).invoke(
            # FunctionName='lam-sys-comn-pf',
            FunctionName='prod-lam-sys-comn-pf',
            InvocationType='Event',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# auth0 E
# ------------------------------------

# ------------------------------------
# mscone_lic m_directory_user S

def update_data_to_mscone_lic_m_directory_user(event, context):

    logger.info('update_data_to_mscone_lic_m_directory_user!!!')

    res = {}

    try:

        record['condition_value'] = {
            'company_code': record['company_code'],
            'user_email': record['administrator_email_old'],
        }
        record['new_value'] = {
            'user_email': {
                'value': None
            },
        }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'PUT',
            'path': '/rds/mscone_lic/m_directory_user',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        del record['condition_value']
        del record['new_value']

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# mscone_lic m_directory_user E
# ------------------------------------

def send_email(mail_template, mail_parameter):
    
    from_address = ''
    to_address = []
    cc_address = []
    bcc_address = []
    title = ""
    message = ""

    if "mail_send_from" in mail_template:
        from_address = mail_template["mail_send_from"]

    if not from_address:
        return error_400("送信元アドレスが設定されていません。")

    if "mail_to" in mail_template:
        if not mail_template["mail_to"] is None and len(mail_template["mail_to"]) > 0:
            arr_value = mail_template["mail_to"].split(';')
            for val in arr_value:
                to_address.append(val)

    if "to_address" in mail_parameter:
        to_address.extend(mail_parameter["to_address"])
        set(to_address)

    # if len(to_address) < 1:
    #     return error_400("宛先アドレスが設定されていません。")

    if "mail_cc" in mail_template:
        if not mail_template["mail_cc"] is None and len(mail_template["mail_cc"]) > 0:
            arr_value = mail_template["mail_cc"].split(';')
            for val in arr_value:
                cc_address.append(val)

    if "cc_address" in mail_parameter:
        cc_address.extend(mail_parameter["cc_address"])
        set(cc_address)

    if "mail_bcc" in mail_template:
        if not mail_template["mail_bcc"] is None and len(mail_template["mail_bcc"]) > 0:
            arr_value = mail_template["mail_bcc"].split(';')
            for val in arr_value:
                bcc_address.append(val)

    if "bcc_address" in mail_parameter:
        bcc_address.extend(mail_parameter["bcc_address"])
        set(bcc_address)

    if "mail_subject" in mail_template:
        title = mail_template["mail_subject"]

    if not title:
        return error_400("メールのタイトルが空です。")

    if "mail_body" in mail_template:
        message = mail_template["mail_body"]

    if not message:
        return error_400("メールの本文が空です。")

    if 'to_address' in mail_parameter:
        del mail_parameter['to_address']
    if 'cc_address' in mail_parameter:
        del mail_parameter['cc_address']
    if 'bcc_address' in mail_parameter:
        del mail_parameter['bcc_address']

    for key in mail_parameter:
        # print('--11')
        # print(key)
        # print('---11')
        title = title.replace("{{" + key + "}}", mail_parameter[key])

    for key in mail_parameter:
        message = message.replace("{{" + key + "}}", mail_parameter[key])

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/email/send',
            'body': json.dumps(
                {
                    'from_address': from_address,
                    'to_address': to_address,
                    'cc_address': cc_address,
                    'bcc_address': bcc_address,
                    'title': title,
                    'message': message
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-email',
            FunctionName='prod-lam-sys-email',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


def get_email_template(service_id, mail_type):

    logger.info('get_email_template!!!')

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_send_mail',
            'queryStringParameters': {
                'service_id': service_id,
                'mail_type': mail_type,
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


def get_invitation_code(event, context):

    logger.info('get_invitation_code!!!')

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/common/invitation_code',
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='lam-sys-common',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


def send_invitation_email(event, context):
    # 招待メール送信

    logger.info('send_invitation_email!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 申込番号
        "entry_code",
        # 企業コード
        "company_code",
        # 企業名
        "company_name",
        # 契約者部署名
        "contract_department",
        # 契約者名 姓
        "contract_last_name",
        # 契約者名 名
        "contract_first_name",
        # 契約者役職
        "contract_position",
        # 契約者のメールアドレス
        "contract_email",
        # 担当営業名
        "salesman_name",
        # システム管理者名 姓
        "administrator_name_last",
        # システム管理者名 名
        "administrator_name_first",
        # システム管理者のメールアドレス
        "administrator_email",
        # Auth0の招待URL
        "invitation_url",
        # Auth0の招待コード
        "invitation_code"
    ]

    mail_parameter = {}

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

    # システム管理者のメールアドレス
    mail_parameter["to_address"] = []
    mail_parameter["to_address"].append(mail_parameter["administrator_email"])

    # Kintoneにしか定義されてない。
    # RDS側にもテーブルにするかどうか？
    # 定数で定義するか？
    mail_parameter["invitation_url"] = GV.CONFIG['INVITATION_URL']

    result = get_email_template(record["service_id"], '利用開始可能連絡')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            print(rows)
            print(rows[0])
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

def send_system_administrator_change_notification_email(event, context):
    # システム管理者変更連絡メール送信

    logger.info('send_system_administrator_change_notification_email!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 申込番号
        "entry_code",
        # 企業コード
        "company_code",
        # 企業名
        "company_name",
        # 契約者部署名
        "contract_department",
        # 契約者名 姓
        "contract_last_name",
        # 契約者名 名
        "contract_first_name",
        # 契約者役職
        "contract_position",
        # 契約者のメールアドレス
        "contract_email",
        # 担当営業名
        "salesman_name",
        # システム管理者名 姓
        "administrator_name_last",
        # システム管理者名 名
        "administrator_name_first",
        # システム管理者のメールアドレス
        "administrator_email",
        # Auth0の招待URL
        "invitation_url",
        # Auth0の招待コード
        "invitation_code"
    ]

    mail_parameter = {}

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']

    print(mail_parameter['contract_name_last'])
    print(mail_parameter['contract_name_first'])

    # システム管理者のメールアドレス
    mail_parameter["to_address"] = []
    mail_parameter["to_address"].append(mail_parameter["administrator_email"])

    # Kintoneにしか定義されてない。
    # RDS側にもテーブルにするかどうか？
    # 定数で定義するか？
    mail_parameter["login_url"] = GV.CONFIG['LOGIN_URL']

    result = get_email_template(record["service_id"], 'システム管理者変更連絡')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            print(rows)
            print(rows[0])
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# ------------------------------------
# データの更新通知(お客様) S

def send_email_data_update_notification_to_customer(event, context):

    logger.info('send_email_data_update_notification_to_customer!!!')
    
    SEND_EMAIL_FIELD_IDS = [
        'company_name',
        'contract_department',
        'contract_last_name',
        'contract_first_name',
        # 【ご契約サービス】
        'service_name',
        # 【ご契約商品】
        'contract_product_list',
        # お申込み番号
        'entry_code',
        # -------会社情報-------
        # 【会社名】
        'company_name',
        # 【会社名(カナ)】
        'company_name_kana',
        # 【郵便番号】
        'company_zipcode',
        # 【住所(都道府県)】
        'company_address_pref',
        # 【住所1】
        'company_address_1',
        # 【住所2】
        'company_address_2',
        # 【住所3】
        'company_address_3',
        # 【お電話番号】
        'company_tel_1',
        # 【代表者様(姓)】
        'company_leader_last',
        # 【代表者様(名)】
        'company_leader_first',
        # 【代表者様(姓)(カナ)】
        'company_leader_kana_last',
        # 【代表者様(名)(カナ)】
        'company_leader_kana_first',
        # 【代表者様(生年月日)】
        'company_leader_date_of_birth',
        # --------mail対応---------------S
        # 【備考欄】
        'customer_notes',
        # --------mail対応---------------E
        # -------会社情報-------
        # -------ご契約者様情報-------
        # 【郵便番号】
        'contract_zipcode',
        # 【住所(都道府県)】
        'contract_address_pref',
        # 【住所1】
        'contract_address_1',
        # 【住所2】
        'contract_address_2',
        # 【住所3】
        'contract_address_3',
        # 【お電話番号】
        'contract_tel_1',
        # 【ご契約者様(姓)】
        'contract_last_name',
        # 【ご契約者様(名)】
        'contract_first_name',
        # 【ご契約者様(姓)(カナ)】
        'contract_last_name_kana',
        # 【ご契約者様(名)(カナ)】
        'contract_first_name_kana',
        # 【ご契約様所属部署】
        'contract_department',
        # 【ご契約様役職】
        'contract_position',
        # 【ご契約様メールアドレス】
        'contract_email',
        # -------ご契約者様情報-------
        # -------管理者様情報-------
        # 【管理者様(姓)】
        'administrator_name_last',
        # 【管理者様(名)】
        'administrator_name_first',
        # 【管理者様(姓)(カナ)】
        'administrator_name_last_kana',
        # 【管理者様(名)(カナ)】
        'administrator_name_first_kana',
        # 【管理者所属部署】
        'administrator_department',
        # 【管理者役職】
        'administrator_position',
        # 【管理者メールアドレス】
        'administrator_email',
        # -------管理者様情報-------
        'invoice_sending_method',
        # 'enable_flg',
        # 'cloud_strage_type',
        # 'system_configuration_text',
        # 'system_configuration_type',
        
        
    ]

    mail_parameter = {}
    logger.info(record)

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            # logger.info(key)
            # logger.info(record[key]['value'])
            mail_parameter[key] = record[key]['value']
            if key == 'system_configuration_type' and mail_parameter[key] == 0:
                mail_parameter[key] = '0'
            if not mail_parameter[key]:
                mail_parameter[key] = ''

            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']
            elif key == 'contract_last_name_kana':
                mail_parameter['contract_name_last_kana'] = record[key]['value']
            elif key == 'contract_first_name_kana':
                mail_parameter['contract_name_first_kana'] = record[key]['value']
    contract_product_listStr = ""
    for product_request in record['contract_product_request']['value']:
        billing_identifier = product_request['billing_identifier']
        quantity = product_request['quantity']
        contract_product_listStr += billing_identifier + ' 同時実行数：' + quantity + '\n'
    mail_parameter['contract_product_list'] = contract_product_listStr[:-1]
                
    if record['invoice_sending_method']['value'] == 'PDF' or record['invoice_sending_method']['value'] == '郵送(書類)':
        mail_parameter["invoice_sending_method"] = record['invoice_sending_method']['value']
        pass
    else:
        if str(record["invoice_sending_method"]["value"]) == '1':
            mail_parameter["invoice_sending_method"] = "郵送(書類)"
        elif str(record["invoice_sending_method"]["value"]) == '0':
            mail_parameter["invoice_sending_method"] = "PDF"
        else:
            mail_parameter["invoice_sending_method"] = "PDF"
    
    # 契約者のメールアドレス
    mail_parameter["to_address"] = []
    mail_parameter["to_address"].append(mail_parameter["contract_email"])
    # バグ #2835 ------------------------S
    # [PT-RT][メール送信情報管理] 契約者にだけ送信している一部のメールをシステム管理者にも送信したい
    mail_parameter["to_address"].append(mail_parameter["administrator_email"])
    # バグ #2835 ------------------------E

    result = get_email_template(record["service_id"], 'データの更新通知(お客様)')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# データの更新通知(お客様) E

# ------------------------------------
# クラウドストレージ設定通知メール送信【M1】

def send_email_data_cloud_strage(event, context, system_configurationData,Mtype):

    logger.info('send_email_data_cloud_strage!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 環境ストックID
        'env_id',
        # システムID
        'system_id',
        # サービスID
        # 'service_id',
        # # システム名
        'system_name',
        # サービス名
        'service_name',
        # 企業コード
        'company_code',
        # 契約ID
        'contract_id',
        # システム構成タイプ
        'system_configuration_type',
        # クラウドストレージ有効化フラグ
        'enable_flg',
        # クラウドストレージドメイン
        'cloud_strage_domain',
        # クラウドストレージユーザ名
        'user_name',
        # クラウドストレージ種類
        'cloud_strage_type',
        # フォルダID
        'folder_id',
        'company_name',
        'contract_department',
        'contract_last_name',
        'contract_first_name',
        # お申込み番号
        'entry_code',
        # 利用料金上限金額 
        'amount_upper_limit_setting',
        'administrator_name_last',
        'administrator_name_first',
        'system_configuration_text',
        'administrator_email',
    ]

    mail_parameter = {}
    logger.info('mail_parameter||||||||||||')
    logger.info(record)

    for key in SEND_EMAIL_FIELD_IDS:
        # logger.info(key)
        if key in record:
            # logger.info(key)
            # logger.info(record[key]['value'])
            mail_parameter[key] = record[key]['value']
            if key == 'system_configuration_type' and mail_parameter[key] == 0:
                mail_parameter[key] = '0'
            if not mail_parameter[key]:
                mail_parameter[key] = ''
                
            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']

    logger.info('mail_parameter||||||||||||')
    logger.info(mail_parameter)
    if system_configurationData['enable_flg']['value']:
        mail_parameter['enable_flg'] = '有効化する'
    else:
        mail_parameter['enable_flg'] = '有効化しない'

    if system_configurationData['cloud_strage_domain']['value'] is None:
        mail_parameter['cloud_strage_domain'] = ''
    else:
        mail_parameter['cloud_strage_domain'] = system_configurationData['cloud_strage_domain']['value']

    if system_configurationData['user_name']['value'] is None:
        mail_parameter['user_name'] = ''
    else:
        mail_parameter['user_name'] = system_configurationData['user_name']['value']
        
    if system_configurationData['folder_id']['value'] is None:
        mail_parameter['folder_id'] = ''
    else:
        mail_parameter['folder_id'] = system_configurationData['folder_id']['value']
    
    if mail_parameter['system_configuration_type'] == '0':
        mail_parameter['system_configuration_type'] = 'クライアント/サーバ型（Windows版）'
        mail_parameter['system_configuration_text'] = '【ユーザー名】' + mail_parameter['user_name']
    elif mail_parameter['system_configuration_type'] == 1:
        mail_parameter['system_configuration_type'] = 'クライアント/サーバ型（RHEL版）'
        mail_parameter['system_configuration_text'] = ''
    elif mail_parameter['system_configuration_type'] == 2:
        # mail_parameter['system_configuration_type'] = 'ソルバー型'
        # mail_parameter['system_configuration_text'] = '【フォルダID】' + mail_parameter['folder_id']
        mail_parameter['system_configuration_type'] = 'ソルバー型'
        mail_parameter['system_configuration_text'] = ''
    elif mail_parameter['system_configuration_type'] == 3:
        mail_parameter['system_configuration_type'] = 'スタンドアローン型' 
        mail_parameter['system_configuration_text'] = '【G-Suiteドメイン】' + mail_parameter['cloud_strage_domain']

    mail_parameter['cloud_strage_type'] = system_configurationData['cloud_strage_type']['value']
    if system_configurationData['folder_id']['value'] is None:
        mail_parameter['folder_id'] = ''
    else:
        mail_parameter['folder_id'] = system_configurationData['folder_id']['value']
    mail_parameter['service_id'] = record["service_id"]
    
    # システム管理者のメールアドレス
    mail_parameter["to_address"] = []
    mail_parameter["to_address"].append(mail_parameter["administrator_email"])
    
    # print('----------111')
    # print(mail_parameter)
    # print('----------111')
    if Mtype == 'M1':
        result = get_email_template(record["service_id"], 'クラウドストレージ設定通知')
    if Mtype == 'M3':
        result = get_email_template(record["service_id"], 'クラウドストレージ登録完了通知')
    if Mtype == 'M5':
        result = get_email_template(record["service_id"], 'クラウドストレージ登録エラー通知')
    if Mtype == 'M7':
        result = get_email_template(record["service_id"], 'オプションの更新通知')
    
    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    # print(mail_template)
    # print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# クラウドストレージ設定通知メール送信【M1】
# ------------------------------------

# ------------------------------------
# データの更新通知 S

def send_email_data_update_notification(event, context):

    logger.info('send_email_data_update_notification!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 申込番号
        'entry_code',
        # 企業コード
        'company_code',
        # 会社名
        'company_name',
        # 契約者名
        'contract_last_name',
        'contract_first_name',
        # 契約者のメールアドレス
        'contract_email',
        # 案件名（プロダクト）：Simulation-Space
        # --------mail対応---------------S
        # 【備考欄】
        'customer_notes',
        # --------mail対応---------------E
        # 請求書の送付方法
        'invoice_sending_method'
    ]

    mail_parameter = {}
    

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']

    print(mail_parameter['contract_name_last'])
    print(mail_parameter['contract_name_first'])
                
    # 契約者メールアドレス
    mail_parameter["to_address"] = []
    # mail_parameter["to_address"] = .append(mail_parameter["contract_email"])
    
    if record['invoice_sending_method']['value'] == 'PDF' or record['invoice_sending_method']['value'] == '郵送(書類)':
        mail_parameter["invoice_sending_method"] = record['invoice_sending_method']['value']
        pass
    else:
        if str(record["invoice_sending_method"]["value"]) == '1':
            mail_parameter["invoice_sending_method"] = "郵送(書類)"
        elif str(record["invoice_sending_method"]["value"]) == '0':
            mail_parameter["invoice_sending_method"] = "PDF"
        else:
            mail_parameter["invoice_sending_method"] = "PDF"

    result = get_email_template(record["service_id"], 'データの更新通知(NDES)')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result


def send_m_contract_email(event, context):

    logger.info('send_m_contract_email!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 申込番号
        'entry_code',
        # 企業コード
        'company_code',
        # 会社名
        'company_name',
        # 契約者名
        'contract_last_name',
        'contract_first_name',
        # 契約者のメールアドレス
        'contract_email',
        # 【備考欄】
        'customer_notes',
        # 請求書の送付方法
        'invoice_sending_method'
    ]

    mail_parameter = {}
    

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''


            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']

    print(mail_parameter['contract_name_last'])
    print(mail_parameter['contract_name_first'])
    
    # 契約者メールアドレス
    mail_parameter["to_address"] = []
    
    if record['invoice_sending_method']['value'] == 'PDF' or record['invoice_sending_method']['value'] == '郵送(書類)':
        mail_parameter["invoice_sending_method"] = record['invoice_sending_method']['value']
        pass
    else:
        if str(record["invoice_sending_method"]["value"]) == 1:
            mail_parameter["invoice_sending_method"] = "郵送(書類)"
        elif str(record["invoice_sending_method"]["value"]) == 0:
            mail_parameter["invoice_sending_method"] = "PDF"
        else:
            mail_parameter["invoice_sending_method"] = "PDF"

    result = get_email_template(record["service_id"], '契約者変更連絡')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result
# データの更新通知 E
# ------------------------------------

# ------------------------------------
# 請求書の送付方法変更 S

def send_email_change_of_invoice_sending_method(event, context):

    logger.info('send_email_change_of_invoice_sending_method!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 申込番号
        'entry_code',
        # 企業コード
        'company_code',
        # 会社名
        'company_name',
        # 契約者名
        'contract_last_name',
        'contract_first_name',
        # 案件名（プロダクト）：Simulation-Space
        # --------mail対応---------------S
        # 【備考欄】
        'customer_notes',
        # --------mail対応---------------E
        # 請求書の送付方法
        'invoice_sending_method'
    ]

    mail_parameter = {}

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']

    print(mail_parameter['contract_name_last'])
    print(mail_parameter['contract_name_first'])

    if record['invoice_sending_method']['value'] == 'PDF' or record['invoice_sending_method']['value'] == '郵送(書類)':
        mail_parameter["invoice_sending_method"] = record['invoice_sending_method']['value']
        pass
    else:
        if str(record["invoice_sending_method"]["value"]) == '1':
            mail_parameter["invoice_sending_method"] = "郵送(書類)"
        elif str(record["invoice_sending_method"]["value"]) == '0':
            mail_parameter["invoice_sending_method"] = "PDF"
        else:
            mail_parameter["invoice_sending_method"] = "PDF"

    result = get_email_template(record["service_id"], '請求書の送付方法変更')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# 請求書の送付方法変更 E
# ------------------------------------

# ------------------------------------
# GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う 処理結果通知 S

def send_email_data_need_gmo_ps_creditfacility_modifybuyer(event, context, ok_company_code, ng_company_code):

    logger.info('send_email_data_need_gmo_ps_creditfacility_modifybuyer!!!')

    SEND_EMAIL_FIELD_IDS = [
        'company_name',
        'contract_department',
        'contract_last_name',
        'contract_first_name',
        # お申込み番号
        'entry_code',
        # -------会社情報-------
        # 【会社名】
        'company_name',
        # 【会社名(カナ)】
        'company_name_kana',
        # 【郵便番号】
        'company_zipcode',
        # 【住所(都道府県)】
        'company_address_pref',
        # 【住所1】
        'company_address_1',
        # 【住所2】
        'company_address_2',
        # 【住所3】
        'company_address_3',
        # 【お電話番号】
        'company_tel_1',
        # 【代表者様(姓)】
        'company_leader_last',
        # 【代表者様(名)】
        'company_leader_first',
        # 【代表者様(姓)(カナ)】
        'company_leader_kana_last',
        # 【代表者様(名)(カナ)】
        'company_leader_kana_first',
        # 【代表者様(生年月日)】
        'company_leader_date_of_birth',
        # -------会社情報-------
        # -------ご契約者様情報-------
        # 【郵便番号】
        'contract_zipcode',
        # 【住所(都道府県)】
        'contract_address_pref',
        # 【住所1】
        'contract_address_1',
        # 【住所2】
        'contract_address_2',
        # 【住所3】
        'contract_address_3',
        # 【お電話番号】
        'contract_tel_1',
        # 【ご契約者様(姓)】
        'contract_last_name',
        # 【ご契約者様(名)】
        'contract_first_name',
        # 【ご契約者様(姓)(カナ)】
        'contract_last_name_kana',
        # 【ご契約者様(名)(カナ)】
        'contract_first_name_kana',
        # 【ご契約様所属部署】
        'contract_department',
        # 【ご契約様役職】
        'contract_position',
        # 【ご契約様メールアドレス】
        'contract_email',
        # -------ご契約者様情報-------
        # -------管理者様情報-------
        # 【管理者様(姓)】
        'administrator_name_last',
        # 【管理者様(名)】
        'administrator_name_first',
        # 【管理者様(姓)(カナ)】
        'administrator_name_last_kana',
        # 【管理者様(名)(カナ)】
        'administrator_name_first_kana',
        # 【管理者所属部署】
        'administrator_department',
        # 【管理者役職】
        'administrator_position',
        # 【管理者メールアドレス】
        'administrator_email',
        # -------管理者様情報-------
        'invoice_sending_method'
    ]

    mail_parameter = {}

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

    print('正常終了した企業：')
    mail_parameter_ok_company_code = ''
    for k, v in ok_company_code.items(): 
        mail_parameter_ok_company_code += k + '\n'
    mail_parameter['ok_company_code'] = mail_parameter_ok_company_code
    print(mail_parameter['ok_company_code'])
        
    print('処理中にエラーが出た企業：') 
    mail_parameter_ng_company_code = ''
    for k, v in ng_company_code.items(): 
        mail_parameter_ng_company_code += k + ':' + '\n' + v + '\n'
    mail_parameter['ng_company_code'] = mail_parameter_ng_company_code
    print(mail_parameter['ng_company_code'])
    
    result = get_email_template(record["service_id"], '定期実行(月末)')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う 処理結果通知 E
# ------------------------------------

# ------------------------------------
# エラー発生通知 S

def send_email_on_error(func_name, err):

    logger.info('send_email_on_error!!!')
    logger.info(err)

    import traceback
    traceback.print_exc()

    error_message = ''
    error_message = '\n'
    # 関数名
    error_message += '【関数名】' + '\n'
    error_message += func_name + '\n'
    # エラー内容
    error_message += '【エラー内容】' + '\n'
    tmp = traceback.format_exc()
    print('tmp')
    print(tmp)
    if str.strip(tmp) != 'NoneType: None':
        error_message += tmp
    
    if 'error' in err:
        error_message += err['error'] + '\n'
    if 'message' in err:
        error_message += err['message'] + '\n'
    
    if 'error_code' in err:
        error_message += err['error_code'] + '\n'
    if 'error_message' in err:
        error_message += err['error_message'] + '\n'
        
    record['error_message'] = {}
    record['error_message']['value'] = error_message

    SEND_EMAIL_FIELD_IDS = [
        # エラーメッセージ
        'error_message',
        # 申込番号
        'entry_code',
        # 企業コード
        'company_code',
        # 会社名
        'company_name',
        # 契約者名
        'contract_last_name',
        'contract_first_name'
    ]

    mail_parameter = {}

    for key in SEND_EMAIL_FIELD_IDS:
        if key in record:
            mail_parameter[key] = record[key]['value']
            if not mail_parameter[key]:
                mail_parameter[key] = ''

            if key == 'contract_last_name':
                mail_parameter['contract_name_last'] = record[key]['value']
            elif key == 'contract_first_name':
                mail_parameter['contract_name_first'] = record[key]['value']

    print(mail_parameter['contract_name_last'])
    print(mail_parameter['contract_name_first'])

    # mail_parameter['error_message'] = 'test'

    result = get_email_template(record["service_id"], 'エラー発生通知')

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter)

    return result

# エラー発生通知 E
# ------------------------------------

# ------------------------------------
# Gmo 購入企業変更API S

def gmo_creditfacility_modifybuyer(event, context, data):

    logger.info('gmo_creditfacility_modifybuyer!!!')

    res = {}

    try:
        
        if data:
            pass
        else:
            data = {
                'targetBuyer': {
                    'shopCustomerId': record['company_code']["value"]
                },
                'buyer': {
                    'buyerNameFamily': record['contract_last_name']["value"],
                    'buyerName':  record['contract_first_name']["value"],
                    'buyerNameFamilyKana': record['contract_last_name_kana']["value"],
                    'buyerNameKana':  record['contract_first_name_kana']["value"],
                    'zipCode': record['contract_zipcode']["value"],
                    'address': record['contract_address_pref']["value"] + record['contract_address_1']["value"] + record['contract_address_2']["value"] + record['contract_address_3']["value"],
                    'companyName': record['company_name']["value"],
                    'departmentName': record['contract_department']["value"],
                    'tel1':  record['contract_tel_1']["value"],
                    'email1':  record['contract_email']["value"],
                    'presidentNameFamily': record['company_leader_last']["value"],
                    'presidentName':  record['company_leader_first']["value"],
                    'presidentNameFamilyKana': record['company_leader_kana_last']["value"],
                    'presidentNameKana':  record['company_leader_kana_first']["value"],
                    'birthday': record['company_leader_date_of_birth']["value"],
                    'shopCustomerId': record['company_code']["value"]
                },
                'creditFacility': {
                },
            }

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/payment/creditfacility/modifybuyer',
            'body': json.dumps(data)
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-payment',
            FunctionName='prod-lam-sys-payment',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# Gmo 購入企業変更API E
# ------------------------------------

# ------------------------------------
# 更新履歴の追加 S

def insert_m_update_company_info_history():

    logger.info('insert_m_update_company_info_history!!!')

    res = {}

    try:

        # 更新履歴ID
        # record["update_history_id"] = -
        # 企業コード
        record["company_code"] = record["company_code"]
        # Auth0ユーザーID
        if "administrator_email_old" in record and "value" in record["administrator_email_old"]:
            record["auth0_user_id"]["value"] = \
                record["administrator_email_old"]["value"]
        # 名前(姓)
        record["name_last"] = record["administrator_name_last"]
        # 名前(名)
        record["name_first"] = record["administrator_name_first"]
        # メールアドレス
        record["email"] = record["administrator_email"]
        if "administrator_email_old" in record and "value" in record["administrator_email_old"]:
            record["email"] = record["administrator_email_old"]
        # 更新元
        record["update_from"] = {}
        record["update_from"]["value"] = '企業情報修正サイト'
        # # 更新日時
        # record["update_date"] = {}
        # record["update_date"]["value"] = datetime.datetime.now()

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/rds/user_infrastructure/m_update_company_info_history',
            'body': json.dumps(
                {
                    'record': record
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res

# --------------------1127-------#7197--------S
def lam_sim_executionLogCharge_get(event,strContract_id):

    logger.info('lam_sim_executionLogCharge_get!!!')

    res = {}

    try:

        input_event = {
              'contract_id': strContract_id
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-simsp-calculateMonthlyCharges',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res
# --------------------1127-------#7197--------E
# 更新履歴の追加 E
# ------------------------------------

# ------------------------------------
# Smartbilling S

# def post_customer_to_smartbilling(event, context):

#     logger.info('post_customer_to_smartbilling!!!')

#     res = {}

#     try:
        
#         api_name = ''
#         if "customerId" in record and "value" in record["customerId"]:
#             api_name = 'customer_put'
#         else:
#             api_name = 'customer_post'
            
#         data = {
#             'api_name': api_name,
#             'stage': "eval",
#             'callingApiName': "postCustomer",
#             # 顧客名
#             'customerName': record["company_name"]["value"],
#             # 顧客名カナ
#             'kanaCharacters': record["company_name_kana"]["value"],
#             # 顧客登録日
#             'customerRegistrationDate': str(datetime.date.today()),
#             # 郵便番号
#             'zipCode': record["company_zipcode"]["value"].replace("-", ""),
#             # 都道府県
#             'address1': record["company_address_pref"]["value"],
#             # 住所１
#             'address2': record["company_address_1"]["value"] + record["company_address_2"]["value"],
#             # 住所２
#             'address3': record["company_address_3"]["value"],
#             # 電話番号
#             'contactTel': record["company_tel_1"]["value"],
#             # メールアドレス
#             'email': record["contract_email"]["value"],
#             # 会社名
#             'companyName': record["company_name"]["value"],
#             # 部署名
#             'departmentName': record["contract_department"]["value"],
#             # 担当者名
#             'contactPerson': record["salesman_name"]["value"],
#             # categoryOfCustomer: record["categoryOfCustomer"]["value"], ???
#             # customerNotes: record["customerNotes"]["value"], ???
#             # additionalText02: record["company_code"]["value"],
#             'categoryOfCustomer': "",
#             'customerNotes': "",
#             'additionalText02': "",
#         }

#         input_event = {
#             'requestContext': {
#               'stage': 'dev-mcl-mgmt-api'
#             },
#             'stageVariables': {
#                 'env': GV.ENV
#             },
#             'httpMethod': 'POST',
#             'path': '/smartbilling',
#             'body': json.dumps(data)
#         }

#         Payload = json.dumps(input_event)
#         print("---01: Payload:", Payload)

#         # 呼び出し
#         response = boto3.client('lambda').invoke(
#             FunctionName='lam-sys-smartbilling',
#             InvocationType='RequestResponse',
#             Payload=Payload
#         )
#         print("---02: response:", response)

#         res = response

#         result = None
#         if 'StatusCode' in response and response['StatusCode'] == 200:

#             # レスポンス読出し
#             Payload = json.loads(response['Payload'].read())
#             print("---03: body:", Payload)
#             res = Payload

#     except Exception as err:
#         return error_handling(inspect.currentframe().f_code.co_name, err)

#     return res

# Smartbilling E
# ------------------------------------

def error_400(message, code=None):
    body = {
        'error_code': code,
        'error_message': message
    }
    return {
        'statusCode': 400,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(body)
        'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
    }

def get_value(key, items):

    value = None

    if key in items:

        # Kintoneからのデータの場合
        if 'value' in items[key]:
            value = items[key]['value']
        else:
            value = items[key]

        if isinstance(value, str):
            value = value.strip()

    return value


def set_value(key, value, items):

    if key in items:
        # Kintoneからのデータの場合
        if 'value' in items[key]:
            items[key]['value'] = value
        else:
            items[key] = value

    return items


def validate(def_validation, record):

    for key in def_validation:

        item = def_validation[key]

        value = get_value(key, record)

        if 'label' not in item or \
            'is_required' not in item or \
            'min' not in item or \
                'max' not in item:
            return f'''システムエラー'''
        if 'is_date' in item and \
                ('date_format' not in item or 'date_format_description' not in item):
            return f'''システムエラー'''

        label = item['label']
        if value is None or value == '':
            if item['is_required']:
                return f'''「{label}」を指定してください。'''
            else:
                if 'is_not_null' in item and item['is_not_null']:
                    if value is None:
                        if 'is_intger' in item and item['is_intger']:
                            value = 0
                        else:
                            value = ''
                else:
                    if value is None:
                        pass
                    elif value == '':
                        value = None
                        pass
        else:
            if 'is_email' in item and item['is_email']:
                import re
                pattern = "^[A-Za-z0-9]{1}[A-Za-z0-9_.-]*@{1}[A-Za-z0-9_.-]{1,}\.[A-Za-z0-9]{1,}$"
                if ';' in value:
                    for v in value.split(';'):
                        if re.match(pattern, v):
                            pass
                        else:
                            return f'''「{label}」を正しく指定してください。(メールアドレス)'''
                else:
                    if re.match(pattern, value):
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。(メールアドレス)'''
            elif 'is_intger' in item and item['is_intger']:
                try:
                    value = int(value)
                except Exception as err:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                except TypeError:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                except ValueError:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if isinstance(value, int) == False:
                    return f'''「{label}」を正しく指定してください。(整数)'''
                if value < int(item['min']) or value > int(item['max']):
                    return f'''「{label}」を正しく指定してください。最小値:{item['min']}～最大値:{item['max']}'''
            elif 'is_bool' in item and item['is_bool']:
                try:
                    if str(value).lower() in ['true', 'false', '0', '1']:
                        pass
                    else:
                        return f'''「{label}」を正しく指定してください。'''
                except ValueError:
                    return f'''「{label}」を正しく指定してください。'''
            else:
                if item['min'] == 0 and item['max'] == 0:
                    pass
                elif len(value) < item['min'] or len(value) > item['max']:
                    return f'''「{label}」を正しく指定してください。({item['max']}桁)'''

                if 'is_date' in item and item['is_date']:
                    if 'date_format' in item:
                        try:
                            datetime.datetime.strptime(
                                value, item['date_format'])
                        except ValueError:
                            if 'date_format_description' in item:
                                return f'''「{label}」を正しく指定してください。({item['date_format_description']})'''
                            else:
                                return f'''「{label}」を正しく指定してください。'''
                if 'is_in' in item and item['is_in']:
                    if value not in item['is_in']:
                        return f'''「{label}」を正しく指定してください。'''

        set_value(key, value, record)

    return True

